$(document).ready(function () {

    $('body').on('change', '#account_head', function () {
        var account_head = $(this).val();
        $('#jquery_mask').show();
        $.post(siteurl + "/Accounts/Chartofaccounts/get_accounttype_byhead_dropdn", {account_head: account_head}
        , function (data) {
            console.log(data)
            $('#jquery_mask').hide();
            $('#type_parent').html(data);
            $('#type_parent_edit').html(data);
        });
    });

    $('body').on('click', '.accountmanage', function () {
        var acc_Id = $(this).attr('acc_Id');
        var parent_id = $(this).attr('parent_id');
        if (parent_id == 0) {
            $('#jquery_mask').show();
            $.post(siteurl + "/Accounts/Chartofaccounts/get_accounttype_by_id", {acc_Id: acc_Id}, function (data)
            {
                $('#jquery_mask').hide();
                var result = JSON.parse(data);
//                console.log(result);
                $('#accounteditModal .acc_id').val(result.type_id);
                $('#accounteditModal .account_head').val(result.ledger_head);
                $('#accounteditModal .module_order').val(result.type_order);
                $('#accounteditModal .type_parent').val(result.type_parent);
                $('#accounteditModal .module_name').val(result.type_name);
            });
        } else {
            $('#jquery_mask').show();
            $.post(siteurl + "/Accounts/Chartofaccounts/get_accounttype_by_type_id", {acc_Id: acc_Id}, function (data)
            {
                $('#jquery_mask').hide();
                var result = JSON.parse(data);
//                console.log(result);
                $('#accounteditModal .acc_id').val(result.type_id);
                $('#accounteditModal .account_head').val(result.ledger_head);
                $('#accounteditModal .module_order').val(result.type_order);
                $('#accounteditModal .type_parent').val(result.type_parent);
                $('#accounteditModal .module_name').val(result.type_name);
            });
        }
    });

    $('body').on('click', '.accountmanage_for_list', function () {
        var acc_Id = $(this).attr('acc_Id');
        var report_id = $(this).attr('report_id');
        var name_head = $(this).attr('name_head');
        if (name_head == 'EMPLOYEES') {
            window.location.href = siteurl + '/Accounts/Chartofaccounts/new_opening_balance_emp_deb_credit/' + acc_Id + '/EMPLOYEES';
        } else if (name_head == 'ACCOUNTS RECEIVABLE') {
            window.location.href = siteurl + '/Accounts/Chartofaccounts/new_opening_balance_emp_deb_credit/' + acc_Id + '/RECEIVABLE';
        } else if (name_head == 'ACCOUNTS PAYABLE') {
            window.location.href = siteurl + '/Accounts/Chartofaccounts/new_opening_balance_emp_deb_credit/' + acc_Id + '/PAYABLE';
        } else {
            $('#jquery_mask').show();
            $.post(siteurl + "/Accounts/Chartofaccounts/get_chartofaccounts_display", {acc_Id: acc_Id, type: type}, function (data)
            {
                $('#jquery_mask').hide();
                $('#coa_id').show();
                $('.chartbody').html(data);
            });
            $('.ledger_accounts').removeClass('ac_active');
            $(this).closest('.ledger_accounts').addClass('ac_active');
        }
    });

    $('body').on('click', '#search_account', function () {
        var account_id = $('#accountselect').val();
        var select_keyword = $('#search_keyword').val();
        if (account_id != '' && select_keyword != '') {
            $.post(siteurl + "/Accounts/Chartofaccounts/search_account", {select_keyword: select_keyword}, function (data) {
//                    console.log(data);
                if (data == 0) {
                    swal('Invalid Account Number');
                    $('#search_keyword').val('');
                } else {
                    var result = JSON.parse(data);
                    var href = siteurl + "/Accounts/Accountsreport/get_report_account_group/" + result.account_id + "/" + result.account_type;
                    $(this).attr('href', href);
                    $(this).attr('target', '_blank');
                }
            });
        } else if (account_id != '') {
            var account_type = $('#accountselect option:selected').attr('account');
            var type = $('#accountselect option:selected').attr('type');
            if (type == "normal") {
                var href = siteurl + "/Accounts/Accountsreport/get_report_account_group/" + account_id + "/" + account_type;
                $(this).attr('href', href);
                $(this).attr('target', '_blank');
            } else {
                var href = siteurl + "/Accounts/Accountsreport/get_reportaccounttype/" + account_id + "/" + account_type;
                $(this).attr('href', href);
                $(this).attr('target', '_blank');
            }
        } else if (select_keyword != '') {
            $.post(siteurl + "/Accounts/Chartofaccounts/search_account", {select_keyword: select_keyword}, function (data) {
//                    console.log(data);
                if (data == 0) {
                    swal('Invalid Account Number');
                    $('#search_keyword').val('');
                } else {
                    var result = JSON.parse(data);
                    var href = siteurl + "/Accounts/Accountsreport/get_report_account_group/" + result.account_id + "/" + result.account_type;
                    $(this).attr('href', href);
                    $(this).attr('target', '_blank');
                }
            });
        } else {
            swal('Please Choose one account');
        }
    });
    $('body').on('click', '#date_filter_group', function () {
        var from = $('#filter_data_from').val();
        var to = $('#filter_data_to').val();
        $.post(siteurl + "/Accounts/Accountsreport/filter_group_by_date", {from: from, to: to}, function (data) {

        });
    });

});

$(document).ready(function () {
    $('body').on('click', '#accountsedit', function () {
        $('#accountseditModal #depreciation_id').hide();
        $('#accountseditModal #depreciationshow_id').hide()
        var account_id = $(this).attr('account_id');
        var account_head_id = $(this).attr('account_head_id');
//        console.log(account_head_id);
        var selectedid = $(this).attr('account_type');
//        console.log(selectedid);
        $('#jquery_mask').show();
        $.post(siteurl + "/Accounts/Chartofaccounts/account_by_id", {account_id: account_id}, function (data)
        {
            $('#jquery_mask').hide();
            $('#accountseditModal .modal-body').html(data);
            $.ajax({
                url: siteurl + "/Accounts/Chartofaccounts/get_accounts",
                method: 'POST',
                data: {account_id: account_id},
                success: function (result) {
                    var json_array = JSON.parse(result);
                    if (json_array.account_table != false) {
                        var datas = "";
                        var indexa = "";
                        var col_name = JSON.parse(json_array.chartofaccounts.template_columns);
                        var values = json_array.account_table;
                        $('#acc_type').val(json_array.chartofaccounts.account_type);
                        for (var i = 0; i < col_name.length; i++) {
                            var form_field = $('#template').find("[name='" + col_name[i] + "']");
                            indexa = col_name[i];
                            datas = $.trim(indexa);
                            $(form_field).val(values[datas]);
                        }
                    }
                }
            });
            $('#jquery_mask').show();
            $.post(siteurl + "/Accounts/Chartofaccounts/get_accounttype_by_type_id", {acc_Id: selectedid}
            , function (data) {
                $('#jquery_mask').hide();
                var dataArray = JSON.parse(data);
                $('#accountseditModal #depreciationshow_id').attr('accnt_name', dataArray.type_name);
                $('#accountseditModal #depreciationshow_id').attr('accnt_id', selectedid);
                $('#accountseditModal #depreciation_id').attr('accnt_name', dataArray.type_name);
                $('#accountseditModal #depreciation_id').attr('accnt_id', selectedid);

            });

            if (account_head_id == 3) {
                $('#jquery_mask').show();
                $.post(siteurl + "/Accounts/Chartofaccounts/get_parenthead", {accnt_id: selectedid}
                , function (data) {
                    $('#jquery_mask').hide();
                    if (data == 'true')
                    {
                        $('#jquery_mask').show();
                        $.post(siteurl + "/Accounts/Chartofaccounts/get_depreciation", {accnt_id: selectedid}
                        , function (data) {
                            $('#jquery_mask').hide();
                            var result = JSON.parse(data);
                            if (result.length == 0) {
                                $('#accountseditModal #depreciation_id').show();
                                $('#accountseditModal #depreciationshow_id').hide();
                            } else
                            {
                                $('#accountseditModal #depreciation_id').hide();
                                $('#accountseditModal #depreciationshow_id').show();
                            }
                        });
                    }
                });
            }
        });
    });
});

$(document).ready(function () {

    $('body').on('click', '#btn_filter_account', function () {
//        console.log($('#accountselect'));
        var account_id = $('#accountselect').val();
        var account_type = $('#accountselect option:selected').attr('account');
        var type = $('#accountselect option:selected').attr('type');
        if (type == "normal") {
            window.location.href = siteurl + "/Accounts/Accountsreport/get_report_account_group/" + account_id + "/" + account_type;
        } else {
            window.location.href = siteurl + "/Accounts/Accountsreport/get_reportaccounttype/" + account_id + "/" + account_type;
        }
    });

    $('#chk_box').click(function () {
        var selected_id = $('.addca').val();
        var selected_type = $(".addca option[value=" + selected_id + "]").text();
        var result = selected_type.replace(/ /g, "_");
        result = result.replace(/[^\w\s]/gi, "_");
        window.location.href = siteurl + '/Accounts/Chartofaccounts/formbuilder/' + result + '/' + selected_id;
    });

    $('body').on('click', '#add_template', function () {
        var name = [];
        var test = $('.source ').val();
        var selected_type = $('#selected_id').val();
        var selected_id = $('#selected').val();
        $('.bld input,.bld select,.bld textarea,.bld button').each(function () {
            if ($.inArray($(this).attr('name'), name) == '-1') {
                name.push($(this).attr('name'));
            }
        });
        $('#jquery_mask').show();
        $.post(siteurl + "/Accounts/Chartofaccounts/create_template_table", {name: name, selected_type: selected_type, selected_id: selected_id, test: test}
        , function (data) {
            $('#jquery_mask').hide();
            window.location.href = siteurl + '/Accounts/Chartofaccounts/chartaccounts/1/' + selected_id;
        });
    });

    $('body').on('click', '#fb_close', function () {
        $('#add_accounts_Modal').modal('hide');
        window.location.href = siteurl + '/Accounts/Chartofaccounts/chartaccounts';
    });
    $('body').on('click', '.opening_bln_add', function () {


        var party_id = $(this).attr('party_id');
        var ledger_id = $(this).attr('ledger_id');
        var pagechec = $('#pagecheck').val();

        var amount = $(this).attr('amount');
        var debit_or_credit = $(this).attr('debit_or_credit');
        var description = $(this).attr('description');
        $('#party_id_open').val(party_id);
        $('#ledger_id_open').val(ledger_id);
        $('#open_amount_open').val(amount);
        $('#pagcheck_id_open').val(pagechec);
        $('.open_description_open').val(description);
        $('#open_amountt_type_open').val(debit_or_credit).trigger("change");
    });


    $('body').on('change', '#account_type', function () {
        var selectedid = this.value;
        if (selectedid == 'Select') {
            $('#template').hide();
            $('#chk_box').hide();
        } else {
            var data = {selectedid: selectedid};
            $.ajax({
                url: siteurl + "/Accounts/Chartofaccounts/get_template_structure",
                type: 'post',
                data: data,
                success: function (data) {
                    $('#template').show();
                    $('#chk_box').show();
                    $('#template').html(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    alert(jqXHR.status);
                }
            });
            $('#jquery_mask').show();
            $.post(siteurl + "/Accounts/Chartofaccounts/get_accounttype_by_type_id", {acc_Id: selectedid}
            , function (data) {
                $('#jquery_mask').hide();
                var dataArray = JSON.parse(data);
                $('#add_accounts_Modal #mov').hide();
                $('#add_accounts_Modal #fixed_asset_details').hide();
                $('#add_accounts_Modal #depreciation_id').hide();
                $('#add_accounts_Modal #depreciation_id').attr('accnt_id', selectedid)
                $('#add_accounts_Modal #depreciation_id').attr('accnt_name', dataArray.type_name);
                $('#add_accounts_Modal #depreciationshow_id').hide();
                $('#add_accounts_Modal #depreciationshow_id').attr('accnt_id', selectedid)
                $('#add_accounts_Modal #depreciationshow_id').attr('accnt_name', dataArray.type_name);
                if (dataArray.ledger_head == 3) {
                    $('#jquery_mask').show();
                    $.post(siteurl + "/Accounts/Chartofaccounts/get_parenthead", {accnt_id: selectedid}
                    , function (data) {
                        $('#jquery_mask').hide();
                        if (data == 'true')
                        {
                            $('#jquery_mask').show();
                            $.post(siteurl + "/Accounts/Chartofaccounts/get_depreciation", {accnt_id: selectedid}
                            , function (data) {
                                $('#jquery_mask').hide();
                                var result = JSON.parse(data);
                                if (result.length == 0) {
                                    $('#add_accounts_Modal #mov').show();
                                    $('#add_accounts_Modal #depreciation_id').show();
                                    $('#add_accounts_Modal #depreciationshow_id').hide();
                                } else
                                {
                                    $('#add_accounts_Modal #mov').hide();
                                    $('#add_accounts_Modal #depreciation_id').hide();
                                    $('#add_accounts_Modal #depreciationshow_id').show();
                                }
                            });
                            $('#add_accounts_Modal #fixed_asset_details').show();
                        }
                    });
                }
            });
        }
    });

    $('body').on('click', '#depreciation_id', function () {
        var accnt_id = $(this).attr('accnt_id');
        var accnt_name = $(this).attr('accnt_name');

        var ff = $('#depreciation_Modal').find('#fixed_asset');
        ff.text(accnt_name);
        var fsi = $('#depreciation_Modal').find('#fixed_asset_id');
        fsi.val(accnt_id);
        $('#jquery_mask').show();
        $.post(siteurl + "/Accounts/Chartofaccounts/get_depreciation", {accnt_id: accnt_id}
        , function (data) {
            $('#jquery_mask').hide();
            var dataArray = JSON.parse(data);
            var companyactper = $('#depreciation_Modal').find('#companyact_per');
            var itactper = $('#depreciation_Modal').find('#itact_per');
            var internallypolicyper = $('#depreciation_Modal').find('#internalpolicy_per');
            var residualvalue = $('#depreciation_Modal').find('#residual_value');
            var lifeinmonth = $('#depreciation_Modal').find('#life_in_month');
            var deprdate = $('#depreciation_Modal').find('#depr_date');
            var accnttype = $('#depreciation_Modal').find('#account_type');
            companyactper.val(dataArray.company_act_per);
            itactper.val(dataArray.it_act_per);
            internallypolicyper.val(dataArray.internal_company_policy_per);
            residualvalue.val(dataArray.residual_value);
            lifeinmonth.val(dataArray.life_in_month);
            accnttype.val(dataArray.depreciation_method);
        });
        $('#depreciation_Modal').modal('show');
    });

    $('body').on('click', '#depreciationshow_id', function () {
        var accnt_id = $(this).attr('accnt_id');
        var accnt_name = $(this).attr('accnt_name');
        var ff = $('#depreciation_Modal').find('#fixed_asset');
        ff.text(accnt_name);
        var fsi = $('#depreciation_Modal').find('#fixed_asset_id');
        fsi.val(accnt_id);
        $('#jquery_mask').show();
        $.post(siteurl + "/Accounts/Chartofaccounts/get_depreciation", {accnt_id: accnt_id}
        , function (data) {
            $('#jquery_mask').hide();
            var dataArray = JSON.parse(data);
            var companyactper = $('#depreciation_Modal').find('#companyact_per');
            var itactper = $('#depreciation_Modal').find('#itact_per');
            var internallypolicyper = $('#depreciation_Modal').find('#internalpolicy_per');
            var residualvalue = $('#depreciation_Modal').find('#residual_value');
            var deprdate = $('#depreciation_Modal').find('#depr_date');
            var lifeinmonth = $('#depreciation_Modal').find('#life_in_month');
            var accnttype = $('#depreciation_Modal').find('#account_type');
            companyactper.val(dataArray.company_act_per);
            itactper.val(dataArray.it_act_per);
            internallypolicyper.val(dataArray.internal_company_policy_per);
            residualvalue.val(dataArray.residual_value);
            lifeinmonth.val(dataArray.life_in_month);
            deprdate.val(dataArray.date);
            accnttype.val(dataArray.depreciation_method);
        });
        $('#depreciation_Modal').modal('show');
    });

    $('body').on('click', '#record_income', function () {
        var payment_account = $(this).attr('payment_account');
        var accnt_name = $(this).attr('accnt_name');
        var ff = $('#payment_Modal').find('#account_head');
        ff.val(payment_account);
        var acname = $('#payment_Modal').find('#account_name');
        acname.val(accnt_name);
    });

    $('body').on('click', '#getcntct', function () {
        var type = $('input[name=radio]:checked').val();
        if (type == "option1")
        {
            $('#jquery_mask').show();
            $.post(siteurl + "/Accounts/Chartofaccounts/get_contact", function (data)
            {
                $('#jquery_mask').hide();
                $('#contactvendorModal .modal-body #search_result').html(data);

            });
        } else
        {
            $('#jquery_mask').show();
            $.post(siteurl + "/Accounts/Chartofaccounts/search_vendor", function (data) {
                $('#jquery_mask').hide();
                $('#contactvendorModal').modal('hide');
                $('#VendorModal').modal('show');
                $('#VendorModal #search_vendor_result').html(data);

            });
        }
    });
    $('body').on('change', '#gvendor', function () {
        var vendor_name = $(this).data('cmpny_name');
        var company_name = $(this).attr('com_hid_name');
        var val = $(this).val();
        $('#getnewcontact_id').val('');
        $('#getnewvendor_id').val(val);
        if (company_name == '') {
            $('#getcntct').val(vendor_name);
        } else {
            $('#getcntct').val(company_name);
        }
        $('#VendorModal').modal('hide');
//        $('#account_type').val('Creditors');
        var type = 'Creditors';
        $.post(siteurl + "/Accounts/Chartofaccounts/get_accountid_by_type", {type: type}
        , function (data) {
            console.log(data)
            var result = JSON.parse(data);
            $('#account_ids').val(result[0]['type_name']);
            $('#account_type').val(result[0]['type_id']);
        });
    });
    $('body').on('change', '#gcntct', function () {
        var contact_name = $(this).data('name');
        var company_name = $(this).attr('compname');
        var val = $(this).val();
        $('#getnewvendor_id').val('');
        $('#getnewcontact_id').val(val);
        if (company_name != '') {
            $('#getcntct').val(company_name);
        } else {
            $('#getcntct').val(contact_name);
        }
        $('#contactvendorModal').modal('hide');
        var type = 'Deptors';
        $.post(siteurl + "/Accounts/Chartofaccounts/get_accountid_by_type", {type: type}
        , function (data) {
            var result = JSON.parse(data);
            $('#account_ids').val(result[0]['type_name']);
            $('#account_type').val(result[0]['type_id']);
        });
    });
    $('body').on('click', '#search_user', function () {
        var type = $('input[name=radio]:checked').val();
        var account_id = $('#account_type').val();
        var account_type = 'account_group';
        if (type == 'option1') {
            var type_name = 'Customer';

            var user_id = $('#getnewcontact_id').val();
            var account_id_new = 'Deptors';
        } else if (type == 'option2') {
            var type_name = 'Vendor';
            var user_id = $('#getnewvendor_id').val();
            var account_id_new = 'Creditors';
        }
        if (user_id != '') {
            var href = siteurl + "/Accounts/Accountsreport/get_reportaccount/" + account_id + "/" + account_type + "/" + user_id + "/" + account_id_new;
            $(this).attr('href', href);
            $(this).attr('target', '_blank');
        } else {
            swal('Please choose one ' + type_name);
        }
    });
    $('body').on('click', '.radio_cv', function () {
        $('#getcntct').val('');
        $('#account_ids').val('');
        $('#getnewcontact_id').val('');
        $('#getnewvendor_id').val('');
        $('#account_type').val('');
    });
    $('body').on('click', '#getemployee', function () {
        var emp_name = $(this).data('name');
        var emp_id = $(this).data('empid');
        $('#getemp').val(emp_name);
        $('#getemp_id').val(emp_id);
        $('#employeeModal').modal('hide');

    });
    $('body').on('click', '#search_employee', function () {
        var account_id = $('#account_type').val();
        var type_name = 'Customer';
        var account_type = 'account_group';
        var account_id_new = $('#select_acid').val();
        var account_id_text = $('#select_acid option:selected').text();
        var emp_id = $('#getemp_id').val();
        if (emp_id != '') {
            if (account_id_new != '') {
                if (account_id_text == 'EMPLOYEES') {
                    var account_text = 'Employee';
                } else if (account_id_text == 'EMPLOYEE SALARY') {
                    var account_text = 'Salaries_and_Wages';
                }

                var href = siteurl + "/Accounts/Accountsreport/get_reportaccount/" + account_id_new + "/" + account_type + "/" + emp_id + "/" + account_text;
                $(this).attr('href', href);
                $(this).attr('target', '_blank');
            } else {
                swal('Please choose one Ass. A/C');
            }
        } else {
            swal('Please choose one Employee');
        }
    });

    $('body').on('keyup', '#search_compcon_keyword', function () {
        var keyword = $(this).val();
        $('#jquery_mask').show();
        $.post(siteurl + "/Accounts/Accountsreport/search_company_contact", {keyword: keyword}
        , function (data) {
            $('#jquery_mask').hide();
            $('#search_result').html(data);
        });
    });
    $('body').on('keyup', '#search_vendor_keyword', function () {
        var keyword = $(this).val();
        $('#jquery_mask').show();
        $.post(siteurl + "/Accounts/Accountsreport/search_vendor_keyword", {keyword: keyword}
        , function (data) {
            $('#jquery_mask').hide();
            $('#search_vendor_result').html(data);
        });
    });

    $("body").on('click', '#search_item', function () {
        var account_id_new = $('#acitem_id_hidden').val();
        var account_type = 'account_group';
        var type = 'Inventory';
        var item_id = $('#getitem_id').val();
        if (item_id != '') {
            var href = siteurl + "/Accounts/Accountsreport/get_reportaccount/" + account_id_new + "/" + account_type + "/" + item_id + "/" + type;

            $(this).attr('href', href);
            $(this).attr('target', '_blank');
        } else {
            swal("Please select one item");
        }
    });
    $("body").on('click', '.pickitem', function () {
        var type = 'Inventory';
        var id = $(this).attr('sel-id');
        var item_name = $('#pdt_ser_name' + id).text();
        $('#getitem').val(item_name);
        $('#getitem_id').val(id);
//        $('#acitem_id').val('Inv');
//        $.post(siteurl +"/Accounts/Chartofaccounts/get_accountid_by_type",{type:type},function(data){
//              var result = JSON.parse(data);
//            $('#acitem_id').val(result[0]['type_name']);
//            $('#acitem_id_hidden').val(result[0]['type_id']);
//        });
        $('#ItemModal').modal('hide');
    });
    $("body").on('keyup', '#search_employee_keyword', function () {
        var keyword = $(this).val();
        var trs = '';
        var length = emp_json.length;

        if (emp_json == null || emp_json == 'undefined') {

        } else {
//            if (emp_json.length < Number(length))
//            {
//                length = emp_json.length;
//            }

            trs += '<tr height="" bgcolor="#dddddd" align="left">'
            trs += '<th class="w5">Select</th>'
            trs += '<th class="w25">Employee Name</th>'
            trs += '<th class="w20">Phone</th>'
            trs += '<th class="w20">Email</th>  '
            trs += '<th class="w30">Department</th>'
            trs += '</tr> '

            for (var i = 0; i < length; i++) {
                if (emp_json[i]['emp_name'].toLowerCase().indexOf(keyword.toLowerCase()) != -1) {
                    trs += '<tr class="sec_grid" >'
                    trs += '<td><input type="radio" name="getemployee" id="getemployee"  data-empid="' + emp_json[i]['emp_id'] + '" data-name="' + emp_json[i]['emp_name'] + '" data-mobile="' + emp_json[i]['emp_mobile'] + '" data-email="' + emp_json[i]['emp_email'] + '" class="ember-checkbox ember-view gemp" ></td>'
                    trs += '<td>' + emp_json[i]['emp_name'] + '</td>'
                    trs += '<td>' + emp_json[i]['emp_mobile'] + '</td>'
                    trs += '<td>' + emp_json[i]['emp_email'] + '</td>'
                    if (emp_json[i]['department_name'] != null) {
                        trs += '<td>' + emp_json[i]['department_name'] + '</td>'
                    } else {
                        trs += '<td></td>'
                    }
                    trs += '</tr>';
                }

            }

            $('#search_employee_bind').html(trs);
        }

    });


    $('body').on('click', '.selitem', function () {
        var option = '';
        var count = 1;
        var new_array = [];
        if (item_json == null || item_json == 'undefined') {

        } else {

            for (var i = 0; i < item_json.length; i++) {
                if (item_json[i]['item_type'] == 'inventory' || item_json[i]['item_type'] == 'inventory_and_service' || item_json[i]['item_type'] == 'non-inventory') {
                    new_array.push(item_json[i]);
                }
            }
            var length1 = 10;
            if (new_array.length < 10) {
                length1 = new_array.length;
            }
            var sku = '';
            var sellingprice = '';
            for (var i = 0; i < length1; i++) {
                if (new_array[i]['sku'] == null) {
                    sku = '';
                } else {
                    sku = new_array[i]['sku']
                }
                if (new_array[i]['sellingprice'] == null) {
                    sellingprice = '';
                } else {
                    sellingprice = parseFloat(new_array[i]['sellingprice']).toFixed(2);
                }
                if (new_array[i]['item_type'] == 'inventory_and_service') {
                    var pdt_type = 'Inventory and Service';
                } else {
                    var pdt_type = new_array[i]['item_type'];
                }
                option += '<tr class="sec_grid_sm">'
                option += '<td class="pa-5 vat">' + count + '</td> '
                option += '<td class="pa-5 vat">' + sku + '</td>'
                option += '<td class="pa-5 vat">' + new_array[i]['name'] + '</td>'
                option += '<td class="pa-5 vat">' + pdt_type + '</td>'
                option += '<td class="pa-5 vat">' + sellingprice + '</td>'
                option += '<td class="pa-5 vat">'
                option += '<label style="display:none;" id="pdt_ser_name' + new_array[i]['item_id'] + '">' + new_array[i]['name'] + '</label>'
                option += '<input type="hidden" id="pdt_ser_id' + new_array[i]['item_id'] + '" value="' + new_array[i]['item_id'] + '">'
                option += '<input type="hidden" id="pdt_ser_sku' + new_array[i]['item_id'] + '" value="' + new_array[i]['sku'] + '">'
                option += '<input type="hidden" id="pdt_ser_sell_price' + new_array[i]['item_id'] + '" value="' + new_array[i]['sellingprice'] + '">'
                option += '<input type="hidden" id="pdt_ser_pur_price' + new_array[i]['item_id'] + '" value="' + new_array[i]['purchase_price'] + '">'
                option += '<input type="hidden" id="pdt_ser_unit' + new_array[i]['item_id'] + '" value="' + new_array[i]['unit_code'] + '">'
                option += '<input type="hidden" id="pdt_ser_type' + new_array[i]['item_id'] + '" value="' + new_array[i]['item_type'] + '">'
                option += '<input type="hidden" id="tot_qty' + new_array[i]['item_id'] + '" value="' + new_array[i]['total_quantity'] + '">'
                option += '<button type="button" class="btn btn-primary btn-flat  pickitem" data-toggle="tooltip" id="product_search" sl-cl="" sel-id="' + new_array[i]['item_id'] + '"  status="whole"  value="' + new_array[i]['item_id'] + '"><i class="icon lindo-tick fz-24 m-p-w"></i> </button>'
                option += '</td>'
                option += '</tr>';
                count++;
                if (new_array[i]['sellingprice'] == null) {
                    new_array[i]['sellingprice'] = '';
                }
                if (new_array[i]['sku'] == null) {
                    new_array[i]['sku'] = '';
                }
            }
            $('.itemsearch').html(option);
        }
    });
    $("body").on('keyup', '#product_name', function () {

        var searchkeyword = $(this).val();
        var option = '';
        var count = 1;
        var sku = '';
        var sellingprice = '';
        for (var i = 0; i < item_json.length; i++) {
            if (item_json[i]['item_type'] == 'inventory' || item_json[i]['item_type'] == 'inventory_and_service' || item_json[i]['item_type'] == 'non-inventory') {
                if (item_json[i]['name'].toLowerCase().indexOf(searchkeyword.toLowerCase()) != -1) {
                    if (item_json[i]['sku'] == null) {
                        sku = '';
                    } else {
                        sku = item_json[i]['sku']
                    }
                    if (item_json[i]['sellingprice'] == null) {
                        sellingprice = '';
                    } else {
                        sellingprice = item_json[i]['sellingprice']
                    }
                    if (item_json[i]['item_type'] == 'inventory_and_service') {
                        var pdt_type = 'Inventory and Service';
                    } else {
                        var pdt_type = item_json[i]['item_type'];
                    }
                    option += '<tr class="sec_grid_sm">'
                    option += '<td class="pa-5 vat">' + count + '</td> '
                    option += '<td class="pa-5 vat">' + sku + '</td>'
                    option += '<td class="pa-5 vat">' + item_json[i]['name'] + '</td>'
                    option += '<td class="pa-5 vat">' + pdt_type + '</td>'
                    option += '<td class="pa-5 vat">' + sellingprice + '</td>'
                    option += '<td class="pa-5 vat">'
                    option += '<label style="display:none;" id="pdt_ser_name' + item_json[i]['item_id'] + '">' + item_json[i]['name'] + '</label>'
                    option += '<input type="hidden" id="pdt_ser_id' + item_json[i]['item_id'] + '" value="' + item_json[i]['item_id'] + '">'
                    option += '<input type="hidden" id="pdt_ser_sku' + item_json[i]['item_id'] + '" value="' + item_json[i]['sku'] + '">'
                    option += '<input type="hidden" id="pdt_ser_sell_price' + item_json[i]['item_id'] + '" value="' + item_json[i]['sellingprice'] + '">'
                    option += '<input type="hidden" id="pdt_ser_pur_price' + item_json[i]['item_id'] + '" value="' + item_json[i]['purchase_price'] + '">'
                    option += '<input type="hidden" id="pdt_ser_unit' + item_json[i]['item_id'] + '" value="' + item_json[i]['unit_code'] + '">'
                    option += '<input type="hidden" id="pdt_ser_type' + item_json[i]['item_id'] + '" value="' + item_json[i]['item_type'] + '">'
                    option += '<input type="hidden" id="tot_qty' + item_json[i]['item_id'] + '" value="' + item_json[i]['total_quantity'] + '">'
                    option += '<button type="button" class="btn btn-primary btn-flat  pickitem" data-toggle="tooltip" id="product_search" sl-cl="" sel-id="' + item_json[i]['item_id'] + '"  status="whole"  value="' + item_json[i]['item_id'] + '"><i class="icon lindo-tick fz-24 m-p-w"></i> </button>'
                    option += '</td>'
                    option += '</tr>';
                    count++;
                } else if (item_json[i]['sku'] != null) {
                    if (item_json[i]['sku'].toLowerCase().indexOf(searchkeyword.toLowerCase()) != -1) {
                        if (item_json[i]['sku'] == null) {
                            sku = '';
                        } else {
                            sku = item_json[i]['sku']
                        }
                        if (item_json[i]['sellingprice'] == null) {
                            sellingprice = '';
                        } else {
                            sellingprice = item_json[i]['sellingprice']
                        }
                        option += '<tr class="sec_grid_sm">'
                        option += '<td class="pa-5 vat">' + count + '</td> '
                        option += '<td class="pa-5 vat">' + sku + '</td>'
                        option += '<td class="pa-5 vat">' + item_json[i]['name'] + '</td>'
                        option += '<td class="pa-5 vat">' + item_json[i]['item_type'] + '</td>'
                        option += '<td class="pa-5 vat">' + sellingprice + '</td>'
                        option += '<td class="pa-5 vat">'
                        option += '<label style="display:none;" id="pdt_ser_name' + item_json[i]['item_id'] + '">' + item_json[i]['name'] + '</label>'
                        option += '<input type="hidden" id="pdt_ser_id' + item_json[i]['item_id'] + '" value="' + item_json[i]['item_id'] + '">'
                        option += '<input type="hidden" id="pdt_ser_sku' + item_json[i]['item_id'] + '" value="' + item_json[i]['sku'] + '">'
                        option += '<input type="hidden" id="pdt_ser_sell_price' + item_json[i]['item_id'] + '" value="' + item_json[i]['sellingprice'] + '">'
                        option += '<input type="hidden" id="pdt_ser_pur_price' + item_json[i]['item_id'] + '" value="' + item_json[i]['purchase_price'] + '">'
                        option += '<input type="hidden" id="pdt_ser_unit' + item_json[i]['item_id'] + '" value="' + item_json[i]['unit_code'] + '">'
                        option += '<input type="hidden" id="pdt_ser_type' + item_json[i]['item_id'] + '" value="' + item_json[i]['item_type'] + '">'
                        option += '<input type="hidden" id="tot_qty' + item_json[i]['item_id'] + '" value="' + item_json[i]['total_quantity'] + '">'
                        option += '<button type="button" class="btn btn-primary btn-flat  pickitem" data-toggle="tooltip" id="product_search" sl-cl="" sel-id="' + item_json[i]['item_id'] + '"  status="whole"  value="' + item_json[i]['item_id'] + '"><i class="icon lindo-tick fz-24 m-p-w"></i> </button>'
                        option += '</td>'
                        option += '</tr>';
                        count++;
                    }
                }

            }
        }

        $('.itemsearch').html(option);

    });

});

$('#formbuilder').ready(function () {
    var fbuild = $('#fb').val();
    if (fbuild == 1) {
        $('#add_accounts_Modal').modal('show');
        $('#chk_box').show();
        var selectedid = $('#add_accounts_Modal').find('#account_type');
        $('#jquery_mask').show();
        $.post(siteurl + "/Accounts/Chartofaccounts/get_accounttype_by_type_id", {acc_Id: selectedid.val()}
        , function (data) {
            $('#jquery_mask').hide();
            var dataArray = JSON.parse(data);
            $('#add_accounts_Modal #depreciation_id').hide();
            $('#add_accounts_Modal #depreciation_id').attr('accnt_id', selectedid.val())
            $('#add_accounts_Modal #depreciation_id').attr('accnt_name', dataArray.type_name);
            $('#add_accounts_Modal #depreciationshow_id').hide();
            $('#add_accounts_Modal #depreciationshow_id').attr('accnt_id', selectedid.val())
            $('#add_accounts_Modal #depreciationshow_id').attr('accnt_name', dataArray.type_name);
            $('#jquery_mask').show();
            $.post(siteurl + "/Accounts/Chartofaccounts/get_depreciation", {accnt_id: selectedid.val()}
            , function (data) {
                $('#jquery_mask').hide();
                var result = JSON.parse(data);
                if (result.length == 0) {
                    $('#add_accounts_Modal #depreciation_id').show();
                    $('#add_accounts_Modal #depreciationshow_id').hide();
                } else
                {
                    $('#add_accounts_Modal #depreciation_id').hide();
                    $('#add_accounts_Modal #depreciationshow_id').show();
                }
            });
        });
    } else
    {
        $('#chk_box').hide();
    }

    $('body').on('click', '.add_link_report', function () {
        var type_id = $(this).attr('type_id');
        $('#jquery_mask').show();
        $.post(siteurl + "/Webadmin/Bintelligence/get_reports_opt", function (data)
        {
            $('#jquery_mask').hide();
            $('#reports_select').html(data);
            $('#report_link_modal').modal('show');
            $('#jquery_mask').show();
            $.post(siteurl + "/Accounts/Chartofaccounts/check_acc_attach_report", {type_id: type_id}, function (data)
            {
                $('#jquery_mask').hide();
                if (data != 0) {
                    $('#reports_select').val(data);
                }
            });
        });
        //check whether report atached or not 
//         add_link_report
        $('#account_type_id').val(type_id);
    });
    //--check for parameter,initialize parameter set up----//

    $('body').on('click', '#opening_balance', function () {
        var account_id = $(this).attr('account_id');
        var title = $(this).attr('ac_name');
        $('#account_id_opening').val(account_id);
        $('#opening_balanceModal .ac_title').html(title);
        $('#open_amount').val('');
        $('#open_amountt_type').val('');
        $('#open_description').val('');
        $('#ledger_id').val('');
        $('#jquery_mask').show();
        $.post(siteurl + "/Accounts/Chartofaccounts/get_opening_balance", {account_id: account_id}, function (data) {
            $('#jquery_mask').hide();
            if (data != 'false') {
                var result = JSON.parse(data);
                $('#open_amount').val(result.amount);
                $('#open_amountt_type').val(result.debit_or_credit);
                $('#open_description').val(result.description);
                $('#ledger_id').val(result.ledger_id);
            }
        });
    });

    $('body').on('submit', '#opening_balance_form', function (e) {
        var amount = $('#open_amount').val();
        var amountt_type = $('#open_amountt_type').val();
        var open_description = $('#open_description').val();
        var account_id = $('#account_id_opening').val();
        var ledger_id = $('#ledger_id').val();
        var parse = parseFloat(amount);
        if (isNaN(parse)) {
            e.preventDefault();
            swal('Error!', 'Enter correct amount');
        } else if (amountt_type == '') {
            e.preventDefault();
            swal('Error!', 'Select Debit?Credit');
        }
    });

    $('body').on('click', '#makepay', function () {
        var employeename = $(this).attr('employeename');
        var amount = $(this).attr('amount');
        var task_id = $(this).attr('task_id');
        var task_expense_id = $(this).attr('task_expense_id');
        var service_number = $(this).attr('service_number');
        var task_type = $(this).attr('task_type');
        var task_name = $(this).attr('task_name');
        var remarks = $(this).attr('remarks');
        var empid = $(this).attr('empid');
        var expenseheader_id = $(this).attr('expenseheader_id');
        $('#employeename').val(employeename);
        $('#amount').val(amount);
        $('#task_type').val(task_type);
        $('#task_name').val(task_name);
        $('#task_id').val(task_id);
        $('#task_expense_id').val(task_expense_id);
        $('#service_number').val(service_number);
        $('#empid').val(empid);
        $('#accountpaidtoid').val(expenseheader_id);
        $('#jquery_mask').show();
        $.post(siteurl + "/Accounts/Chartofaccounts/get_emp_account", function (data) {
            $('#jquery_mask').hide();
            var resu = JSON.parse(data);
            var accountpaidto = resu.type_name;
            var accountpaidtoid = resu.type_id
//            $('#accountpaidto').val(accountpaidto);
//            $('#accountpaidtoid').val(accountpaidtoid);
        });
    });

    $('body').on('change', '#payment_modes', function () {
        var payment_mode = $(this).val();
        $('#jquery_mask').show();
        $.post(siteurl + "/Accounts/Chartofaccounts/get_sub_account", {payment_mode: payment_mode}, function (data) {
            $('#jquery_mask').hide();
            $('#account_paid_from').html(data);
        });
    });

    $('.acreportlink').on('click', function (e) {
        e.preventDefault();
        $(this).parents("form").submit();
    });

    $('body').on('click', '.acreportlinks', function (e) {
        e.preventDefault();
        $(this).parents("form").submit();
    });


    $('body').on('click', '.account_delete', function () {
        var account_id = $(this).attr('account_id');
        var nearest = $(this).closest('tr');

        var s = $(this).closest('tr');
        $.post(siteurl + "/Accounts/Chartofaccounts/check_to_for_ledger", {account_id: account_id}, function (data) {
            console.log(data);
            if (data == 0) {
                swal({
                    title: "Are you sure?",
                    text: "You are going to delete this Account",
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#DD6B55",
                    confirmButtonText: "Yes, delete !",
                    cancelButtonText: "No, don't delete !",
                    closeOnConfirm: false,
                    closeOnCancel: false
                },
                        function (isConfirm) {
                            if (isConfirm) {
                                $('#jquery_mask').show();
                                $.ajax({
                                    url: siteurl + '/Accounts/Chartofaccounts/delete_account',
                                    data: {account_id: account_id},
                                    cache: false,
                                    datatype: "json",
                                    type: "post",
                                    success: function (d) {
                                        $('#jquery_mask').hide();
                                        $(s).remove();
                                        //$(this).closest('.list-group').remove();
                                        swal("Deleted!", "Account has been deleted.", "success");
                                        location.reload();
                                    },
                                    fail: function (d) {
                                        $('#jquery_mask').hide();
                                        swal("Cannot delete!", "Account cannot be deleted.", "error");
                                    }
                                });
                            } else {
                                swal("Cancelled", "Account is not deleted ", "error");
                            }
                        });
            } else {
                swal("This account is already used for transaction");
            }
        });
        return false;
    });



    $('body').on('click', '.account_dlt', function () {
        var account_id = $(this).attr('account_id');
        var nearest = $(this).closest('tr');

        var s = $(this).closest('tr');
        $.post(siteurl + "/Accounts/Chartofaccounts/check_to_delete", {account_id: account_id}, function (data) {
            if (data == 1) {

                swal({
                    title: "Are you sure?",
                    text: "You are going to delete this Account",
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#DD6B55",
                    confirmButtonText: "Yes, delete !",
                    cancelButtonText: "No, don't delete !",
                    closeOnConfirm: false,
                    closeOnCancel: false
                },
                        function (isConfirm) {
                            if (isConfirm) {
                                $('#jquery_mask').show();
                                $.ajax({
                                    url: siteurl + '/Accounts/Chartofaccounts/delete_manage_account',
                                    data: {account_id: account_id},
                                    cache: false,
                                    datatype: "json",
                                    type: "post",
                                    success: function (d) {
                                        $('#jquery_mask').hide();
                                        $(s).remove();
                                        //$(this).closest('.list-group').remove();
                                        swal("Deleted!", "Account has been deleted.", "success");
                                        location.reload();
                                    },
                                    fail: function (d) {
                                        $('#jquery_mask').hide();
                                        swal("Cannot delete!", "Account cannot be deleted.", "error");
                                    }
                                });
                            } else {
                                swal("Cancelled", "Account is not deleted ", "error");
                            }
                        });
            } else {
                swal("This account is already used for transaction");
            }
        });
        return false;
    });





});
if (typeof (account_list) == 'undefined') {
    var account_list = [];
}


//test section
var page_row_count = 0;
var account_lists = '';
var account_list = '[]';
$(document).ready(function () {

    account_lists = JSON.parse(account_list);
//    console.log(account_lists);
    var mod = Number(account_lists.length) % Number(20);
    page_row_count = account_lists.length;
    var no_of_page = parseInt(account_lists.length / 20);
    var row_limit = 20;
    if (mod != 0)
    {
        no_of_page += 1;
    }

    createpagenation(row_limit, 1, Number(no_of_page));
//    page_display(1);

    $('body').on('click', '#date_filter', function () {
        account_list = [];
        var filter_from = $('#datepicker_from').val();
        var filter_to = $(' #datepicker_to').val();
        console.log(filter_from)
        console.log(filter_to)
        for (var k = 0; k < account_lists.length; k++) {
            if (account_lists[k]['transaction_date'] >= filter_from && account_lists[k]['transaction_date'] <= filter_to) {
                account_list.push(account_lists[k]);
            }
        }
        account_list = JSON.stringify(account_list);
        page_display(1);
    });



    $('body').on('click', '.pagenationbtn', function () {
        var rowlimit = $(this).attr('limit');
        var pagenum = $(this).attr('page');
        var activr_page_num = $('.pagination_div .active ').attr('page');
        var pagination_count = parseInt(page_row_count / rowlimit);
        var pagenumber = pagenum;
        if (pagination_count > 0) {
            if (page_row_count % rowlimit > 0) {
                pagination_count++;
            }
        }
        if (activr_page_num != pagenum) {
            if (pagenum == 'first') {
                if (activr_page_num != 1) {
                    pagenumber = 1;
                    $('.pagenationbtn').removeClass('active');
                    $('.pagenationbtn[page="1"]').addClass('active');
                    createpagenation(rowlimit, pagenumber, pagination_count);
                }
            } else if (pagenum == 'prev') {
                if (activr_page_num != 1) {
                    pagenumber = activr_page_num - 1;
                    $('.pagenationbtn').removeClass('active');
                    $('.pagenationbtn[page="' + (activr_page_num - 1) + '"]').addClass('active');
                    createpagenation(rowlimit, pagenumber, pagination_count);
                }
            } else if (pagenum == 'last') {
                if (activr_page_num != pagination_count) {
                    pagenumber = pagination_count;
                    $('.pagenationbtn').removeClass('active');
                    $('.pagenationbtn[page="' + pagination_count + '"]').addClass('active');
                    createpagenation(rowlimit, pagenumber, pagination_count);
                }
            } else if (pagenum == 'next') {

                if (activr_page_num != pagination_count) {
                    pagenumber = parseInt(activr_page_num) + 1;
                    $('.pagenationbtn').removeClass('active');
                    $('.pagenationbtn[page="' + (parseInt(activr_page_num) + 1) + '"]').addClass('active');
                    createpagenation(rowlimit, pagenumber, pagination_count);
                }
            } else {
                if (activr_page_num != pagenum) {
                    $('.pagenationbtn').removeClass('active');
                    $(this).addClass('active');
                    createpagenation(rowlimit, pagenumber, pagination_count);
                    page_display(pagenumber);
                }
            }
        }
    }
    );
    $('body').on('click', '.pagesubmit', function (e) {
        e.preventDefault();
        var from_date_srch = $('.from_date_srch').val();
        var to_date_srch = $('.to_date_srch').val();
        $('.hidden_date_from').val(from_date_srch);
        $('.hidden_date_to').val(to_date_srch);
        var url = $(this).attr('href');
        $('#paginationfilter').attr('action', url);
        $('#paginationfilter').submit();
    });

    $(".from_date_srch").on('change', function () {
        var from_date_srch = $('.from_date_srch').val();
        $('.to_date_srch').datepicker('destroy');
        $('.to_date_srch').datepicker({
            dateFormat: 'yy-mm-dd',
            minDate: new Date(from_date_srch)
        });
    });
});
function page_display(pagenumber) {
    var account_lists = JSON.parse(account_list);
    var item_start_count = (Number(pagenumber - 1) * 20);
    var count = item_start_count;
    var option = '';
    for (var i = item_start_count; i < Number(item_start_count) + 20; i++) {
        var url = '';
        var credit = '';
        var debit = '';
        var voucher_type = '';
        if (account_lists[i] == undefined)
        {
            break;
        } else {
            if (account_lists[i]['debit_or_credit'] == 'credit') {
                credit = parseFloat(account_lists[i]['amount']).toFixed(2);
            } else if (account_lists[i]['debit_or_credit'] == 'debit') {
                debit = parseFloat(account_lists[i]['amount']).toFixed(2);
            }
            if ('opening_balance' in account_lists[i]) {
                if (account_lists[i]['opening_balance'] == 1) {
                    credit = '';
                    debit = '';
                }
            }
//            console.log(account_lists[i]['reference_id1_type']);
            if (account_lists[i]['reference_id1_type'] == 'invoice') {
                voucher_type = 'Invoice';
                url = siteurl + '/Inventory/Invoice/get_invoice_for_view/' + account_lists[i]['reference_id1'];
            } else if (account_lists[i]['reference_id1_type'] == 'so') {
                voucher_type = 'Sales Order';
                url = siteurl + '/Inventory/Salesorder/get_salesorder_by_id/' + account_lists[i]['reference_id1'];
            } else if (account_lists[i]['reference_id1_type'] == 'po') {
                voucher_type = 'Purchase Order';
                url = siteurl + '/Inventory/Purchase/get_purchaseorder_for_view/' + account_lists[i]['reference_id1'];
            } else if (account_lists[i]['reference_id1_type'] == 'do') {
                voucher_type = 'Delivery Order';
                url = siteurl + '/Inventory/Delivery_order/get_deliveryorder_by_id/' + account_lists[i]['reference_id1'];
            } else if (account_lists[i]['reference_id1_type'] == 'mrv') {
                voucher_type = 'MRV';
                url = siteurl + '/Inventory/Mrv/get_mrv_view/' + account_lists[i]['reference_id1'];
            } else if (account_lists[i]['reference_id1_type'] == 'bill') {
                voucher_type = 'Bill';
                url = siteurl + '/Inventory/Bill/view_bill/' + account_lists[i]['reference_id1'];
            } else if (account_lists[i]['reference_id1_type'] == 'manual_journal') {
                voucher_type = 'Manual Journal';
                url = siteurl + '/Inventory/Manualjournals/view_journalentry/' + account_lists[i]['reference_id1'];
            } else if (account_lists[i]['reference_id1_type'] == 'payment_entry') {
                voucher_type = 'Payment Entry';
                url = siteurl + '/Accounts/Payment/view_paymententry/' + account_lists[i]['reference_id1'];
            } else if (account_lists[i]['reference_id1_type'] == 'service_task_expense') {
                voucher_type = 'Service Task Expense';
                url = siteurl + '/Accounts/Chartofaccounts/view_expense_paymentdetails_service/' + account_lists[i]['reference_id1'];
            } else if (account_lists[i]['reference_id1_type'] == 'crm_task_expense') {
                voucher_type = 'CRM Task Expense';
                url = siteurl + '/Accounts/Chartofaccounts/view_expense_paymentdetails_crm/' + account_lists[i]['reference_id1'];
            } else if (account_lists[i]['reference_id1_type'] == 'sales_return') {
                voucher_type = 'Sales Return';
                url = siteurl + '/Inventory/Sales_return/get_sales_return_for_view/' + account_lists[i]['reference_id1'];
            } else if (account_lists[i]['reference_id1_type'] == 'purchase_return') {
                voucher_type = 'Purchase Return';
                url = siteurl + '/Inventory/Purchase_return/get_purchasereturn_by_id/' + account_lists[i]['reference_id1'];
            } else if (account_lists[i]['reference_id1_type'] == 'service_item') {
                voucher_type = 'Service Parts';
                url = siteurl + '/Service/Service/get_service_by_id/' + account_lists[i]['reference_id1'];
            } else if (account_lists[i]['reference_id1_type'] == 'salary_wages') {
                voucher_type = '';
                url = siteurl + '/Payroll/Paysalary/view_salary_report/' + account_lists[i]['reference_id1'];
            } else if (account_lists[i]['reference_id1_type'] == 'employee_benefits') {
                voucher_type = '';
                url = siteurl + '/Payroll/Paybenefit/view_benefit_report/' + account_lists[i]['reference_id1'];
            } else if (account_lists[i]['reference_id1_type'] == 'salary_cut') {
                voucher_type = '';
                url = siteurl + '/Payroll/Paysalary/view_salary_report/' + account_lists[i]['reference_id1'];
            }
            var print_reference = account_lists[i]['reference_id1'];
            if (account_lists[i]['reference'] != '') {
                print_reference = account_lists[i]['reference'];
            }
            if (print_reference == 'undefined') {
                print_reference = '';
            }
            var current_balance = '';
            if (account_lists[i]['current_balance'] < 0) {
                current_balance = '<span class="pull-right">' + (parseFloat(account_lists[i]['current_balance'] * -1)).toFixed(2) + 'Cr.</span>';
            } else {
                current_balance = '<span class="pull-left">' + parseFloat(account_lists[i]['current_balance']).toFixed(2) + 'Dr.</span>';
            }
            if (party_id != '' && party_type != '') {
                if (party_id == account_lists[i]['party_id'] && party_type == account_lists[i]['party_type']) {

                    option += '<tr class="sec_grid" id="' + account_lists[i]['cc_id'] + '"> ';
                    option += ' <td>' + account_lists[i]['transaction_date'] + '</td> ';
                    option += '<td> #' + (1000 + account_lists[i]['ledger_id']) + '</td> ';
                    if (account_lists[i]['title']) {
                        option += '<td>' + account_lists[i]['title'] + '</td> ';
                    } else {
                        option += '<td> </td> ';
                    }
                    option += '<td>' + voucher_type + '</td> ';
                    option += ' <td><a href="' + url + '" target="_blank">' + print_reference + '</a></td> ';

                    option += ' <td  class="debit">' + debit + '</td> ';
                    option += ' <td class="credit">' + credit + '</td>  ';
                    option += ' <td>' + current_balance + '</td>  ';
                    option += '</tr> ';
                    count++;
                }
            } else {
                option += '<tr class="sec_grid" id="' + account_lists[i]['cc_id'] + '"> ';
                option += ' <td>' + account_lists[i]['transaction_date'] + '</td> ';
                option += '<td> #' + (1000 + account_lists[i]['ledger_id']) + '</td> ';

                if (account_lists[i]['title']) {
                    option += '<td>' + account_lists[i]['title'] + '</td> ';
                } else {
                    option += '<td> </td> ';
                }
                option += '<td>' + voucher_type + '</td> ';
                option += ' <td><a href="' + url + '" target="_blank">' + print_reference + '</a></td> ';

                option += ' <td class="debit">' + debit + '</td> ';
                option += ' <td class="credit">' + credit + '</td>  ';
                option += ' <td>' + current_balance + '</td>  ';
                option += '</tr> ';
                count++;
            }
        }
    }
    $('#search_result').html(option);
}

function createpagenation(rowlimit, pagenum, pagination_count) {
    if (pagination_count == 0 || pagination_count == 1)
    {
    } else {
        var nav_list = '<div class="buttons-row width100 pagination_div ">';
        if (pagination_count <= 6) {
            nav_list += '    <a href="#" page="first" limit="' + rowlimit + '" class="button pagenationbtn "><<</a>';
            nav_list += '    <a href="#" page="prev" limit="' + rowlimit + '" class="button pagenationbtn"><</a>';
            for (var i = 1; i <= pagination_count; i++) {
                nav_list += '    <a href="#" page="' + i + '" limit="' + rowlimit + '" class="button pagenationbtn ' + ((pagenum == i) ? 'active' : '') + '">' + i + '</a>';
            }
            nav_list += '    <a href="#" page="next" limit="' + rowlimit + '" class="button pagenationbtn">></a>';
            nav_list += '    <a href="#" page="last" limit="' + rowlimit + '" class="button pagenationbtn">>></a>';
        } else if (pagenum == pagination_count) {
            var num1 = pagenum - 4, num2 = pagenum - 3, num3 = pagenum - 2, num4 = pagenum - 1, num5 = pagenum;
            nav_list += '    <a href="#" page="first" limit="' + rowlimit + '" class="button pagenationbtn ">&#60;&#60;</a>';
            nav_list += '    <a href="#" page="prev" limit="' + rowlimit + '" class="button pagenationbtn">&#60;</a>';
            nav_list += '    <a href="#" page="1" limit="' + rowlimit + '" class="button border-none">...</a>';
            nav_list += '    <a href="#" page="' + num1 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num1 + '</a>';
            nav_list += '    <a href="#" page="' + num2 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num2 + '</a>';
            nav_list += '    <a href="#" page="' + num3 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num3 + '</a>';
            nav_list += '    <a href="#" page="' + num4 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num4 + '</a>';
            nav_list += '    <a href="#" page="' + num5 + '" limit="' + rowlimit + '" class="button pagenationbtn active">' + num5 + '</a>';
            nav_list += '    <a href="#" page="next" limit="' + rowlimit + '" class="button pagenationbtn">&#62;</a>';
            nav_list += '    <a href="#" page="last" limit="' + rowlimit + '" class="button pagenationbtn">&#62;&#62;</a>';
        } else if (pagenum == 1) {
            var num1 = pagenum, num2 = parseInt(pagenum) + 1, num3 = parseInt(pagenum) + 2, num4 = parseInt(pagenum) + 3, num5 = parseInt(pagenum) + 4;
            nav_list += '    <a href="#" page="first" limit="' + rowlimit + '" class="button pagenationbtn">&#60;&#60;</a>';
            nav_list += '    <a href="#" page="prev" limit="' + rowlimit + '" class="button pagenationbtn">&#60;</a>';
            nav_list += '    <a href="#" page="' + num1 + '" limit="' + rowlimit + '" class="button pagenationbtn active">' + num1 + '</a>';
            nav_list += '    <a href="#" page="' + num2 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num2 + '</a>';
            nav_list += '    <a href="#" page="' + num3 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num3 + '</a>';
            nav_list += '    <a href="#" page="' + num4 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num4 + '</a>';
            nav_list += '    <a href="#" page="' + num5 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num5 + '</a>';
            nav_list += '    <a href="#" page="1" limit="' + rowlimit + '" class="button border-none">...</a>';
            nav_list += '    <a href="#" page="next" limit="' + rowlimit + '" class="button pagenationbtn">&#62;</a>';
            nav_list += '    <a href="#" page="last" limit="' + rowlimit + '" class="button pagenationbtn">&#62;&#62;</a>';
        } else if (pagenum <= 4) {
            nav_list += '    <a href="#" page="first" limit="' + rowlimit + '" class="button pagenationbtn">&#60;&#60;</a>';
            nav_list += '    <a href="#" page="prev" limit="' + rowlimit + '" class="button pagenationbtn">&#60;</a>';
            nav_list += '    <a href="#" page="1" limit="' + rowlimit + '" class="button pagenationbtn">1</a>';
            nav_list += '    <a href="#" page="2" limit="' + rowlimit + '" class="button pagenationbtn';
            if (pagenum == 2)
                nav_list += ' active">2</a>';
            else
                nav_list += '">2</a>';
            nav_list += '    <a href="#" page="3" limit="' + rowlimit + '" class="button pagenationbtn';
            if (pagenum == 3)
                nav_list += ' active">3</a>';
            else
                nav_list += '">3</a>';
            nav_list += '    <a href="#" page="4" limit="' + rowlimit + '" class="button pagenationbtn';
            if (pagenum == 4)
                nav_list += ' active">4</a>';
            else
                nav_list += '">4</a>';
            nav_list += '    <a href="#" page="5" limit="' + rowlimit + '" class="button pagenationbtn">5</a>';
            nav_list += '    <a href="#" page="1" limit="' + rowlimit + '" class="button border-none">...</a>';
            nav_list += '    <a href="#" page="next" limit="' + rowlimit + '" class="button pagenationbtn">&#62;</a>';
            nav_list += '    <a href="#" page="last" limit="' + rowlimit + '" class="button pagenationbtn">&#62;&#62;</a>';
        } else if (pagenum > (pagination_count - 4)) {
            var num1 = pagination_count - 4, num2 = pagination_count - 3, num3 = pagination_count - 2, num4 = pagination_count - 1, num5 = pagination_count;
            nav_list += '    <a href="#" page="first" limit="' + rowlimit + '" class="button pagenationbtn">&#60;&#60;</a>';
            nav_list += '    <a href="#" page="prev" limit="' + rowlimit + '" class="button pagenationbtn">&#60;</a>';
            nav_list += '    <a href="#" page="1" limit="' + rowlimit + '" class="button border-none">...</a>';
            nav_list += '    <a href="#" page="' + num1 + '" limit="' + rowlimit + '" class="button pagenationbtn';
            if (pagenum == num1)
                nav_list += ' active">' + num1 + '</a>';
            else
                nav_list += '">' + num1 + '</a>';
            nav_list += '    <a href="#" page="' + num2 + '" limit="' + rowlimit + '" class="button pagenationbtn';
            if (pagenum == num2)
                nav_list += ' active">' + num2 + '</a>';
            else
                nav_list += '">' + num2 + '</a>';
            nav_list += '    <a href="#" page="' + num3 + '" limit="' + rowlimit + '" class="button pagenationbtn';
            if (pagenum == num3)
                nav_list += ' active">' + num3 + '</a>';
            else
                nav_list += '">' + num3 + '</a>';
            nav_list += '    <a href="#" page="' + num4 + '" limit="' + rowlimit + '" class="button pagenationbtn';
            if (pagenum == num4)
                nav_list += ' active">' + num4 + '</a>';
            else
                nav_list += '">' + num4 + '</a>';
            nav_list += '    <a href="#" page="' + num5 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num5 + '</a>';
            nav_list += '    <a href="#" page="next" limit="' + rowlimit + '" class="button pagenationbtn">&#62;</a>';
            nav_list += '    <a href="#" page="last" limit="' + rowlimit + '" class="button pagenationbtn">&#62;&#62;</a>';
        } else if ((pagenum > 4) && (pagination_count > (parseInt(pagenum) + 2))) {
            var num1 = pagenum - 2, num2 = pagenum - 1, num3 = pagenum, num4 = parseInt(pagenum) + 1;
            nav_list += '    <a href="#" page="first" limit="' + rowlimit + '" class="button pagenationbtn">&#60;&#60;</a>';
            nav_list += '    <a href="#" page="prev" limit="' + rowlimit + '" class="button pagenationbtn">&#60;</a>';
            nav_list += '    <a href="#" page="1" limit="' + rowlimit + '" class="button border-none">...</a>';
            nav_list += '    <a href="#" page="' + num1 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num1 + '</a>';
            nav_list += '    <a href="#" page="' + num2 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num2 + '</a>';
            nav_list += '    <a href="#" page="' + num3 + '" limit="' + rowlimit + '" class="button pagenationbtn active">' + num3 + '</a>';
            nav_list += '    <a href="#" page="' + num4 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num4 + '</a>';
            nav_list += '    <a href="#" page="6" limit="' + rowlimit + '" class="button border-none">...</a>';
            nav_list += '    <a href="#" page="next" limit="' + rowlimit + '" class="button pagenationbtn">&#62;</a>';
            nav_list += '    <a href="#" page="last" limit="' + rowlimit + '" class="button pagenationbtn">&#62;&#62;</a>';
        }
        nav_list += '</div>';
        $('.pagenatio').html(nav_list);
    }
}

if (typeof (f_start) != 'undefined') {
    $(function () {

        $.fn.dataTableExt.afnFiltering.push(
                function (oSettings, aData, iDataIndex) {
//                console.log(aData);
                    if (typeof aData._date == 'undefined') {
//                    console.log(aData);
                        aData._date = new Date(aData[3]).getTime();
                    }

                    if (minDateFilter && !isNaN(minDateFilter)) {
                        if (aData._date < minDateFilter) {
                            return false;
                        }
                    }

                    if (maxDateFilter && !isNaN(maxDateFilter)) {
                        if (aData._date > maxDateFilter) {
                            return false;
                        }
                    }

                    return true;
                }
        );
        var oTable = $('#datable_1').DataTable({
            "oLanguage": {
                "sSearch": "Filter Data"
            },
            "iDisplayLength": -1,
            "sPaginationType": "full_numbers",

        });


        $("#datepicker_from").datepicker({
            showOn: "button",
            buttonImage: "images/calendar.gif",
            buttonImageOnly: false,
            dateFormat: 'yy-mm-dd',
            "onSelect": function (date) {
                minDateFilter = new Date(date).getTime();
                oTable.fnDraw();
                filter();
                calculatetotal();

            }
        }).keyup(function () {
            minDateFilter = new Date(this.value).getTime();
            oTable.fnDraw();
            filter();
            calculatetotal();

        });

        $("#datepicker_to").datepicker({
            showOn: "button",
            buttonImage: "images/calendar.gif",
            buttonImageOnly: false,
            dateFormat: 'yy-mm-dd',
            "onSelect": function (date) {
                maxDateFilter = new Date(date).getTime();
                oTable.fnDraw();
                filter();
                calculatetotal();

            }
        }).keyup(function () {
            maxDateFilter = new Date(this.value).getTime();
            oTable.fnDraw();
            filter();
            calculatetotal();

        });

        $('#datable_1').on('draw.dt', function () {
            calculatetotal();

        });

        function calculatetotal() {
            $(".additional").remove();
            var from_date = $('#datepicker_from').val();
            var from_to = $('#datepicker_to').val();

            var option = '';
            var account_lists = JSON.parse(account_list);

            for (var i = 0; i < account_lists.length; i++) {
                if (from_date == account_lists[i]['transaction_date']) {
                    if ((i - 1) in account_lists) {

                        option += '<tr class="sec_grid additional" id="' + account_lists[i - 1]['cc_id'] + '">'
                        option += '<td>Opening balance </td>'
                        option += '<td> </td>'
                        option += '<td> </td>'
                        option += '<td> </td>'
                        option += '<td> </td>'
                        option += '<td> </td>'
                        if (account_lists[i - 1]['current_balance'] < 0) {
                            option += '<td>' + account_lists[i - 1]['current_balance'] * -1 + 'Cr</td>'
                        } else {
                            option += '<td>' + account_lists[i - 1]['current_balance'] + 'Dr</td>'
                        }
                        option += '</tr>';
                    }
                    break;
                }

            }
//            var total = total_dr-total_cr;
            $("#search_result").prepend(option);

            var total_cr = 0;
            var total_dr = 0;
            $('#search_result .sec_grid').each(function () {
                var debit = $(this).find('.debit').html();
                var credit = $(this).find('.credit').html();
                if (jQuery.type(credit) === "undefined" && jQuery.type(debit) === "undefined") {

                } else {
                    total_cr += Number(credit);
                    total_dr += Number(debit);
                }

            });

            var total = total_dr - total_cr;

            var post_option = '';
            post_option += '<tr class="additional">'
            post_option += '<td>Total</td>'
            post_option += '<td></td>'
            post_option += '<td></td>'
            post_option += '<td></td>'
            post_option += '<td>' + total_dr + '</td>'
            post_option += '<td>' + total_cr + '</td>'
            post_option += '<td></td>'
            post_option += '</tr>'

            post_option += '<tr class="additional">'
            post_option += '<td>Closing Balance</td>'
            post_option += '<td></td>'
            post_option += '<td></td>'
            post_option += '<td></td>'
            if (total > 0) {
                post_option += '<td>' + total + '</td>'
                post_option += '<td></td>'
            } else {
                post_option += '<td></td>'
                post_option += '<td>' + total * -1 + '</td>'
            }
            post_option += '<td></td>'
            post_option += '</tr>'
            $("#search_result").append(post_option);
        }

        function filter() {
            account_list = [];
            var filter_from = $('#datepicker_from').val();
            var filter_to = $(' #datepicker_to').val();

            for (var k = 0; k < account_lists.length; k++) {
                if (account_lists[k]['transaction_date'] >= filter_from && account_lists[k]['transaction_date'] <= filter_to) {
                    account_list.push(account_lists[k]);
                }
            }
            account_list = JSON.stringify(account_list);
            page_display(1);
        }
    });
}

