if (typeof (item_json_list) == 'undefined') {
    var item_json_list = [];
}
if (typeof (selected_state_billing) == 'undefined') {
    var selected_state_billing = 0;
}
if (typeof (selected_city_billing) == 'undefined') {
    var selected_city_billing = 0;
}
if (typeof (selected_state_shipping) == 'undefined') {
    var selected_state_shipping = 0;
}
if (typeof (selected_city_shipping) == 'undefined') {
    var selected_city_shipping = 0;
}

$(document).ready(function () {
    $('body').on('click', '#accouts_delete', function () {
        var account_Id = $(this).attr('account_Id');
        var billing_id = $(this).attr('billing_id');
        var shipping_id = $(this).attr('shipping_id');
        var nearest = $(this).closest('tr');
        var s = $(this).closest('tr');
        swal({
            title: "Are you sure?",
            text: "You are going to delete this Account",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes, delete !",
            cancelButtonText: "No, don't delete !",
            closeOnConfirm: false,
            closeOnCancel: false
        },
                function (isConfirm) {
                    if (isConfirm) {
                        $('#jquery_mask').show();
                        $.ajax({
                            url: siteurl + '/Crm/Accounts/delete_account',
                            data: {account_Id: account_Id, billing_id: billing_id, shipping_id: shipping_id},
                            cache: false,
                            datatype: "json",
                            type: "post",
                            success: function (d) {
                                $('#jquery_mask').hide();
                                $(s).remove();
                                swal("Deleted!", "Account has been deleted.", "success");
                            },
                            fail: function (d) {
                                $('#jquery_mask').hide();
                                swal("Cannot delete!", "Account cannot be deleted.", "error");
                            }
                        });
                    } else {
                        swal("Cancelled", "Account is not deleted ", "error");
                    }
                });
        return false;
    });

    //--Accounts selction ---------------------------------------
    $('body').on('click', '#billingcountry', function ()
    {
        var countryid = $('#billingcountry').val();
        $('#jquery_mask').show();
        $.post(siteurl + "/Common/Picklocation/get_states_by_country", {countryid: countryid}
        , function (data) {
            $('#jquery_mask').hide();
            $('#billingstate').html(data);
        });
    });
    $('body').on('click', '#savecompany', function (e)
    {
        var Company = $('#Company').val();
        var Phone = $('#Phone').val();
        var email = $('#Email').val();
        var frm = $(this).attr('frm');
        var payment = [];
        $('.payment:checked').each(function () {
            payment.push($(this).val());
        });
        $('.payment_edit:checked').each(function () {
            payment.push($(this).val());
        });
        var p_days = $('#p_days').val();
        var paymenttt = $('.payment').val();
        var credit_limit = $('#credit_limit').val();
        var billingaddressline1 = $('#billingaddressline1').val();
        var billingaddressline2 = $('#billingaddressline2').val();
        var billingcountry = $('#billingcountry').val();
        var billingstate = $('#billingstate').val();
        var billingcity = $('#billingcity').val();
        var billingpincode = $('#billingpincode').val();
        var shippingaddressline1 = $('#shippingaddressline1').val();
        var shippingaddressline2 = $('#shippingaddressline2').val();
        var shippingcountry = $('#shippingcountry').val();
        var shippingstate = $('#shippingstate').val();
        var shippingcity = $('#shippingcity').val();
        var shippingpincode = $('#shippingpincode').val();
        if (!Company) {
            swal('Please enter Company!');
            return false;
        }
        if (Phone == '') {
            swal('Please enter Phone number');
            return false;
        }
        if (!email) {
            swal('Please enter Email');
            return false;
        }
        if (email != '') {
            var result = isEmail(email);
            if (result == false) {
                swal("Invalid email");
                return false;
            }
        }
        if (!billingaddressline1) {
            swal('Please enter Billing Address Line 1 !');
            return false;
        }
        if (!billingaddressline2) {
            swal('Please enter Billing Address Line 2 !');
            return false;
        }
        if (!billingcountry) {
            swal('Please enter Billing Country !');
            return false;
        }
        if (!billingstate) {
            swal('Please enter Billing State!');
            return false;
        }
        if (!billingcity) {
            swal('Please enter Billing City!');
            return false;
        }
        if (!billingpincode) {
            swal('Please enter Billing Pincode!');
            return false;
        }
        if (!shippingaddressline1) {
            swal('Please enter Shipping Address Line 1 !');
            return false;
        }
        if (!shippingaddressline2) {
            swal('Please enter Shipping Address Line 2 !');
            return false;
        }
        if (!shippingcountry) {
            swal('Please enter Shipping Country !');
            return false;
        }
        if (!shippingstate) {
            swal('Please enter Shipping State !');
            return false;
        }
        if (!shippingcity) {
            swal('Please enter Shipping City !');
            return false;
        }
        if (!shippingpincode) {
            swal('Please enter Shipping Pincode !');
            return false;
        }

        var flag = 0;
        if (frm == "add") {
            $('.payment').each(function () {
                if ($(this).prop("checked") == false) {

                } else {
                    flag = 1;
                }
            });

            if (flag == 0) {
                swal('Please Choose Payment Type !');
                return false;
            }
        } else {
            $('.payment_edit').each(function () {
                if ($(this).prop("checked") == false) {
                } else {
                    flag = 1;
                }
            });

            if (flag == 0) {
                swal('Please Choose Payment Type !');
                return false;
            }
        }
        if ($.inArray('credit', payment) !== -1 || $.inArray('cheque', payment) !== -1) {
            if (p_days <= 0) {
                swal('Please enter Days !');
                return false;
            }
            if (credit_limit <= 0) {
                swal('Please enter Credit Limit !');
                return false;
            }
//            if ($('.files').val() == "") {
//                swal('Please Upload  Documents !');
//                return false;
//            }
//            if ($('.exp_date').val() == "") {
//                swal('Please Enter  Expiry date !');
//                return false;
//            }
        }
        if (Phone != '') {
            var frm = $('#frm').val();
            if (frm == 'edit') {
                var cmpny_id = $('#accid').val();
                $('#jquery_mask').show();
                $.post(siteurl + "/Crm/Accounts/check_editcompanyalreadyexist", {Phone: Phone, cmpny_id: cmpny_id}, function (data) {
                    $('#jquery_mask').hide();
                    if (data == 1) {
                        e.preventDefault();
                        swal('Phone Number Already Exist');
                    } else {
                        $('#formid').submit();
                    }
                });
            } else if (frm == 'add') {
                $('#jquery_mask').show();
                $.post(siteurl + "/Crm/Accounts/check_companyalreadyexist", {Phone: Phone}, function (data) {
                    $('#jquery_mask').hide();
                    if (data == 1) {
                        e.preventDefault();
                        swal('Phone Number Already Exist');
                    } else {
                        $('#formid').submit();
                    }
                });
            }
        }
    });
    $('body').on('click', '#bank_edit', function (e) {
        var bank_name = $('#editbankdetails #bank_name').val();
        var bank_code = $('#editbankdetails #bank_code').val();
        var account_number = $('#editbankdetails #account_number').val();
        var ifsc_code = $('#editbankdetails #ifsc_code').val();
        var bank_id = $('#editbankdetails #bank_id').val();
        if (!bank_name) {
            swal('Please enter Bank Name !');
            return false;
        }
        if (!bank_code) {
            swal('Please enter Bank Code !');
            return false;
        }
        if (!account_number) {
            swal('Please enter Account Number!');
            return false;
        }
        if (!ifsc_code) {
            swal('Please enter IFSC Code !');
            return false;
        }
        if (account_number != '' && ifsc_code != '') {
            $('#jquery_mask').show();
            $.post(siteurl + "/Crm/Accounts/check_edit_bank_alreadyexist", {account_number: account_number, ifsc_code: ifsc_code, bank_id: bank_id}, function (data) {
                $('#jquery_mask').hide();
                if (data == 'exist') {
                    e.preventDefault();
                    swal('This Bank Details Already Exist');
                }
                if (data == 'ok') {
                    $('#formid_edit').submit();
                }
            });
        }
    });
    $('body').on('click', '#bank_add', function (e) {
        var bank_name = $('#bank_name').val();
        var bank_code = $('#bank_code').val();
        var account_number = $('#account_number').val();
        var ifsc_code = $('#ifsc_code').val();
        if (!bank_name) {
            swal('Please enter Bank Name !');
            return false;
        }
        if (!bank_code) {
            swal('Please enter Bank Code !');
            return false;
        }
        if (!account_number) {
            swal('Please enter Account Number!');
            return false;
        }
        if (!ifsc_code) {
            swal('Please enter IFSC Code !');
            return false;
        }
        if (account_number != '' && ifsc_code != '') {
            $('#jquery_mask').show();
            $.post(siteurl + "/Crm/Accounts/get_company_account_details_by_id", {account_number: account_number, ifsc_code: ifsc_code}, function (data) {
                $('#jquery_mask').hide();
                if (data == 'exist') {
                    e.preventDefault();
                    swal('This Bank Details Already Exist');
                }
                if (data == 'ok') {
                    $('#formid').submit();
                }
            });
        }
    });
    $('body').on('click', '#billingstate', function ()
    {
        var stateid = $('#billingstate').val();
        $('#jquery_mask').show();
        $.post(siteurl + "/Common/Picklocation/get_city_by_state", {stateid: stateid}
        , function (data) {
            $('#jquery_mask').hide();
            $('#billingcity').html(data);
        });
    });

    $('body').on('click', '#shippingcountry', function ()
    {
        var countryid = $('#shippingcountry').val();
        $('#jquery_mask').show();
        $.post(siteurl + "/Common/Picklocation/get_states_by_country", {countryid: countryid}
        , function (data) {
            $('#jquery_mask').hide();
            $('#shippingstate').html(data);
        });
    });
    $('body').on('click', '#shippingstate', function ()
    {
        var stateid = $('#shippingstate').val();
        $('#jquery_mask').show();
        $.post(siteurl + "/Common/Picklocation/get_city_by_state", {stateid: stateid}
        , function (data) {
            $('#jquery_mask').hide();
            $('#shippingcity').html(data);
        });
    });

    $('body').on('click', '#add_industry_button', function () {
        var industry = $('#industry').val();
        if (industry != '') {
            $('#jquery_mask').show();
            $.post(siteurl + "/Crm/Accounts/add_industry", {industry: industry}, function (data) {
                $('#jquery_mask').hide();
                $('#selectindustry').html(data);
                $('#myModal').modal('hide');
            });
        } else {
            swal("No data entered");
        }

    });

    if (typeof selected_state_billing !== 'undefined') {
        var countryid = $('#billingcountry').val();
        $('#jquery_mask').show();
        $.post(siteurl + "/Common/Picklocation/get_states_by_country", {countryid: countryid}
        , function (data) {
            $('#jquery_mask').hide();
            $('#billingstate').html(data);
            $('#billingstate').val(selected_state_billing);
            if (selected_city_billing !== undefined) {
                var stateid = $('#billingstate').val();
                $('#jquery_mask').show();
                $.post(siteurl + "/Common/Picklocation/get_city_by_state", {stateid: stateid}
                , function (data) {
                    $('#jquery_mask').hide();
                    $('#billingcity').html(data);
                    $('#billingcity').val(selected_city_billing);
                });
            }
        });
    }

    if (typeof selected_state_shipping !== 'undefined') {
        var countryid = $('#shippingcountry').val();
        $('#jquery_mask').show();
        $.post(siteurl + "/Common/Picklocation/get_states_by_country", {countryid: countryid}
        , function (data) {
            $('#jquery_mask').hide();
            $('#shippingstate').html(data);
            $('#shippingstate').val(selected_state_shipping);
            if (selected_city_shipping !== undefined) {
                var stateid = $('#shippingstate').val();
                $('#jquery_mask').show();
                $.post(siteurl + "/Common/Picklocation/get_city_by_state", {stateid: stateid}
                , function (data) {
                    $('#jquery_mask').hide();
                    $('#shippingcity').html(data);
                    $('#shippingcity').val(selected_city_shipping);
                });
            }
        });
    }

    $('body').on('click', '#copy_billto_shipp', function () {
        $('#shippingaddressline1').val($('#billingaddressline1').val());
        $('#shippingaddressline2').val($('#billingaddressline2').val());
        $('#shippingcountry').val($('#billingcountry').val());
        $('#shippingstate').val($('#billingstate').val());
        $('#shippingpincode').val($('#billingpincode').val());

        var countryid = $('#billingcountry').val();
        var bill_state = $('#billingstate').val();
        if (countryid != "" && countryid != 0) {
            $('#jquery_mask').show();
            $.post(siteurl + "/Common/Picklocation/get_states_by_country", {countryid: countryid}
            , function (data) {
                $('#jquery_mask').hide();
                $('#shippingstate').html(data);
                $('#shippingstate').val(bill_state);
            });
        }

        var stateid = $('#billingstate').val();
        var bill_city = $('#billingcity').val();
        if (stateid != "" && stateid != 0) {
            $('#jquery_mask').show();
            $.post(siteurl + "/Common/Picklocation/get_city_by_state", {stateid: stateid}
            , function (data) {
                $('#jquery_mask').hide();
                $('#shippingcity').html(data);
                $('#shippingcity').val(bill_city);
            });
        }
    });

    $('body').on('click', '#copy_shippto_bill', function () {

        $('#billingaddressline1').val($('#shippingaddressline1').val());
        $('#billingaddressline2').val($('#shippingaddressline2').val());
        $('#billingcountry').val($('#shippingcountry').val());
        $('#billingstate').val($('#shippingstate').val());
        $('#billingpincode').val($('#shippingpincode').val());

        var countryid = $('#shippingcountry').val();
        var shipp_state = $('#shippingstate').val();
        if (countryid != "" && countryid != 0) {
            $('#jquery_mask').show();
            $.post(siteurl + "/Common/Picklocation/get_states_by_country", {countryid: countryid}
            , function (data) {
                $('#jquery_mask').hide();
                $('#billingstate').html(data);
                $('#billingstate').val(shipp_state);
            });
        }

        var stateid = $('#shippingstate').val();
        var shipp_city = $('#shippingcity').val();
        if (stateid != "" && stateid != 0) {
            $('#jquery_mask').show();
            $.post(siteurl + "/Common/Picklocation/get_city_by_state", {stateid: stateid}
            , function (data) {
                $('#jquery_mask').hide();
                $('#billingcity').html(data);
                $('#billingcity').val(shipp_city);
            });
        }

    });

    $("body").on('keyup', '#search_company_keywords', function () {

        var keyword = $('#search_company_keywords').val();
        var data = {keyword: keyword};
        //$('#jquery_mask').show();
        $.ajax({
            url: siteurl + '/Crm/Accounts/search_company',
            type: 'post',
            data: data,
            success: function (data) {
                //$('#jquery_mask').hide();
                $('#search_result').html(data);
            },
            error: function (jqXHR, textStatus, errorThrown) {
                $('#jquery_mask').hide();
                alert(jqXHR.status);
            }
        });
    });

    //    bank details edit
    $('body').on('click', '#editbank', function () {
        var bank_id = $(this).attr('bank_id');
        $('#jquery_mask').show();
        $.post(siteurl + "/Crm/Accounts/get_bank_details_by_id", {bank_id: bank_id}, function (data)
        {
            $('#jquery_mask').hide();
            var result = JSON.parse(data);
            $('#editbankdetails #bank_name').val(result.bank_name);
            $('#editbankdetails #account_number').val(result.account_number);
            $('#editbankdetails #ifsc_code').val(result.ifsc_code);
            $('#editbankdetails #bank_code').val(result.bank_code);
            $('#editbankdetails #bank_id').val(result.bank_id);
        });
    });
//    bank details delete
    $('body').on('click', '#bankdetails_delete', function () {
        var bank_id = $(this).attr('bank_id');

        var nearest = $(this).closest('tr');
        var s = $(this).closest('tr');
        swal({
            title: "Are you sure?",
            text: "You are going to delete this Bank",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes, delete !",
            cancelButtonText: "No, don't delete !",
            closeOnConfirm: false,
            closeOnCancel: false
        },
                function (isConfirm) {
                    if (isConfirm) {
                        $('#jquery_mask').show();
                        $.ajax({
                            url: siteurl + '/Crm/Accounts/delete_bank',
                            data: {bank_id: bank_id},
                            cache: false,
                            datatype: "json",
                            type: "post",
                            success: function (d) {
                                $('#jquery_mask').hide();
                                $(s).remove();
                                //$(this).closest('.list-group').remove();
                                swal("Deleted!", "Bank has been deleted.", "success");
                            },
                            fail: function (d) {
                                $('#jquery_mask').hide();
                                swal("Cannot delete!", "Bank cannot be deleted.", "error");
                            }
                        });
                    } else {
                        swal("Cancelled", "Bank is not deleted ", "error");
                    }
                });
        return false;
    });

    $('#import_uploader').on('click', function () {
        var file = document.getElementById('import_file').files[0];
        var fileName = $("#import_file").val();
        if (fileName) {
            var reader = new FileReader();
            reader.onload = function (progressEvent) {
                var lines = this.result.split('\n');
                if (lines.length > 0) {
                    var line = 0;
                    readFile(line, lines);
                }
            };
            reader.readAsText(file);
        } else {
            swal('Error!', 'Pleade chose file');
        }
    });

    $('body').on('click', '.leftarrow', function () {
        var ps = $('.pagediv').find('li.active').attr('pageno');
        if (ps !== 0)
        {
            ps = ps - 1;
            $('li[pageno="' + ps + '"]').trigger('click');
        }
    });
    $('body').on('click', '.rightarrow', function () {

        var ps = $('.pagediv').find('li.active').attr('pageno');
        if (ps < no_of_page)
        {
            ps = Number(ps) + 1;
            $('li[pageno="' + ps + '"]').trigger('click');
        }

    });
    $('body').on('click', '.rightdot', function () {
        var div_name = $(this).attr('divname');
        var ac = parseInt(div_name - 10);
        var ps = $('.pagenatio').find('.sectiondiv' + div_name + '').removeClass('no-display');
        var sc = $('.pagenatio').find('.sectiondiv' + ac + '').addClass('no-display');
    });
    $('body').on('click', '.leftdot', function () {
        var div_name = $(this).attr('divname');
        var ac = parseInt(div_name - 10);
        var ps = $('.pagenatio').find('.sectiondiv' + div_name + '').removeClass('no-display');
        var sc = $('.pagenatio').find('.sectiondiv' + ac + '').addClass('no-display');
    });
    $('body').on('click', '.pagenumber', function () {
        $('.pagediv').find('li.active').removeClass('active');
        $(this).addClass('active');
        var pagenumber = $(this).attr('pageno');
        var item_start_count = (Number(pagenumber) * 20 + 1);
        var count = item_start_count;
        var option = '';
        for (var i = item_start_count; i < Number(item_start_count) + 20; i++) {
            option += '<tr class="sec_grid">'
            option += '<td>' + count + '</td>'
            option += '<td>' + item_json_list[i]['companyname'] + '</td>'
            if (item_json_list[i]['website'] != null) {
                option += '<td>' + item_json_list[i]['website'] + '</td> '
            } else {
                option += '<td>' + ' ' + '</td> '
            }
            option += '<td>' + item_json_list[i]['email'] + '</td>'
            option += '<td>' + item_json_list[i]['phone'] + '</td>'
            option += '<td>'
            option += '<div class="inline-block dropdown">'
            option += '<a class="dropdown-toggle" data-toggle="dropdown" href="#" aria-expanded="true" role="button"><i class="icon lindo-android-more-vertical act-gray fz-22"></i></a>'

            option += '<ul class="dropdown-menu bullet dropdown-menu-right"  role="menu">'
            option += ' <li class="b-b-g"><a  href="' + siteurl + '/Crm/Accounts/view_account/' + item_json_list[i]['company_id'] + '"><i class="icon lindo-search mr-10 fz-22 vam txt-success"></i>View</a></li>'
            option += ' <li class="b-b-g"><a  href="' + siteurl + '/Crm/Accounts/get_account_by_id/' + item_json_list[i]['company_id'] + '"><i class="icon lindo-page-edit mr-10 fz-22 vam txt-primary"></i>Edit</a></li>'
            option += '<li role="presentation"><a  href="#"  account_Id="' + item_json_list[i]['company_id'] + '" billing_id="' + item_json_list[i]['billingaddress_id'] + '" shipping_id="' + item_json_list[i]['shippingaddress_id'] + '"  id="accouts_delete"><i class="icon lindo-delete-trash-1 mr-10 fz-22 vam txt-danger"></i>Delete</a></li>'
            option += '</ul>'
            option += '</div>'
            option += '</td>'
            option += '</tr>'
            count++;
        }
        $('#search_result').html(option);
    });

    var page_row_count = 0;


    $('body').on('click', '.pagenationbtn', function () {
        var rowlimit = $(this).attr('limit');
        var pagenum = $(this).attr('page');
        var activr_page_num = $('.pagination_div .active ').attr('page');

        var pagination_count = parseInt(page_row_count / rowlimit);
        var pagenumber = pagenum;
        if (pagination_count > 0) {
            if (page_row_count % rowlimit > 0) {
                pagination_count++;
            }
        }
        if (activr_page_num != pagenum) {
            if (pagenum == 'first') {
                if (activr_page_num != 1) {
                    pagenumber = 1;
                    $('.pagenationbtn').removeClass('active');
                    $('.pagenationbtn[page="1"]').addClass('active');
                    createpagenation(rowlimit, pagenumber, pagination_count);
                    page_display(pagenumber);
                }
            } else if (pagenum == 'prev') {
                if (activr_page_num != 1) {
                    pagenumber = activr_page_num - 1;
                    $('.pagenationbtn').removeClass('active');
                    $('.pagenationbtn[page="' + (activr_page_num - 1) + '"]').addClass('active');
                    createpagenation(rowlimit, pagenumber, pagination_count);
                    page_display(pagenumber);
                }
            } else if (pagenum == 'last') {
                if (activr_page_num != pagination_count) {
                    pagenumber = pagination_count;
                    $('.pagenationbtn').removeClass('active');
                    $('.pagenationbtn[page="' + pagination_count + '"]').addClass('active');
                    createpagenation(rowlimit, pagenumber, pagination_count);
                    page_display(pagenumber);
                }
            } else if (pagenum == 'next') {

                if (activr_page_num != pagination_count) {
                    pagenumber = parseInt(activr_page_num) + 1;
                    $('.pagenationbtn').removeClass('active');
                    $('.pagenationbtn[page="' + (parseInt(activr_page_num) + 1) + '"]').addClass('active');
                    createpagenation(rowlimit, pagenumber, pagination_count);
                    page_display(pagenumber);
                }
            } else {
                if (activr_page_num != pagenum) {
                    $('.pagenationbtn').removeClass('active');
                    $(this).addClass('active');
                    createpagenation(rowlimit, pagenumber, pagination_count);
                    page_display(pagenumber);
                }
            }
        }
    });

    var mod = Number(item_json_list.length) % Number(20);
    page_row_count = item_json_list.length;
    var no_of_page = parseInt(item_json_list.length / 20);
    var row_limit = 20;
    if (mod != 0)
    {
        no_of_page += 1;
    }
    createpagenation(row_limit, 1, no_of_page);

    //clone division
    $('body').on('click', '.add_new_row', function () {

        if ($('.files:last').val() != '') {

            var bc = $(".div_clone").clone();
            bc.find("input").val("");
            var id_cl = $('.clone_:last').attr('id-cl');
            var id_cl_nxt = parseFloat(id_cl) + 1;
            bc.attr('id-cl', id_cl_nxt);
            bc.removeClass('div_clone');
            bc.appendTo(".append_row");
            $('.exp_date:last').datepicker({
                format: 'yyyy-mm-dd'
            });
            $('.exp_dates:last').datepicker({
                format: 'yyyy-mm-dd'
            });
        } else {
            swal('Please choose one file');
        }
    });
    //remove button in clone
    $('body').on('click', '.remove_div', function (e) {
        e.preventDefault();
        if ($(this).closest('tr').attr('id-cl') != 1) {
            $(this).closest('tr').remove();
        } else {
            $(this).closest('tr').find("input").val("");
        }
    });
    $('body').on('mouseover', '.highlighted', function () {
        $(this).closest('tr').find('.popactions').removeClass('no-display');
    });

    $('body').on('mouseleave', '.highlighted', function () {
        $(this).closest('tr').find('.popactions').addClass('no-display');
    });
        $('body').on('click', '.pagesubmit', function (e) {
        e.preventDefault();
        var url = $(this).attr('href');
        var search=$('#search_company_keywordss').val();
        $('#searchcompnayhidden').val(search);
        $('#formsubmitcompny').attr('action', url);
        $('#formsubmitcompny').submit();
    });
    $('body').on('click', '#delete_deal', function () {
        var dealid = $(this).attr('dealid');
        var s = $(this).closest('tr');
        swal({
            title: "Are you sure?",
            text: "You are going to delete this Deal",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes, delete !",
            cancelButtonText: "No, don't delete !",
            closeOnConfirm: false,
            closeOnCancel: false
        },
                function (isConfirm) {
                    if (isConfirm) {
                        $('#jquery_mask').show();
                        $.ajax({
                            url: siteurl + "/Crm/Deals/delete_deal",
                            data: {dealid: dealid},
                            cache: false,
                            datatype: "json",
                            type: "post",
                            success: function (d) {
                                $('#jquery_mask').hide();
                                $(s).remove();
                                //$(this).closest('.list-group').remove();
                                swal("Deleted!", "Deal has been deleted.", "success");
                            },
                            fail: function (d) {
                                $('#jquery_mask').hide();
                                swal("Cannot delete!", "Deal cannot be deleted.", "error");
                            }
                        });
                    } else {
                        swal("Cancelled", "Deal is not deleted ", "error");
                    }
                });
        return false;
    });
    $('body').on('click', '#deleteqtv', function () {
        var quote_id = $(this).attr('id1');
        var s = $(this).closest('tr');
        swal({
            title: "Are you sure?",
            text: "You are going to delete this Quote",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes, delete !",
            cancelButtonText: "No, don't delete !",
            closeOnConfirm: false,
            closeOnCancel: false
        },
                function (isConfirm) {
                    if (isConfirm) {
                        $('#jquery_mask').show();
                        $.ajax({
                            url: siteurl + "/Inventory/Quote/delete_quote",
                            data: {quote_id: quote_id},
                            cache: false,
                            datatype: "json",
                            type: "post",
                            success: function (d) {
                                $('#jquery_mask').hide();
                                $(s).remove();
                                //$(this).closest('.list-group').remove();
                                swal("Deleted!", "Quote has been deleted.", "success");
                            },
                            fail: function (d) {
                                $('#jquery_mask').hide();
                                swal("Cannot delete!", "Quote cannot be deleted.", "error");
                            }
                        });
                    } else {
                        swal("Cancelled", "Quote is not deleted ", "error");
                    }
                });
        return false;

    });
});

function createpagenation(rowlimit, pagenum, pagination_count) {
    var nav_list = '<div class="buttons-row width100 pagination_div ">';

    if (pagination_count <= 6) {
        nav_list += '    <a href="#" page="first" limit="' + rowlimit + '" class="button pagenationbtn "><<</a>';
        nav_list += '    <a href="#" page="prev" limit="' + rowlimit + '" class="button pagenationbtn"><</a>';
        for (var i = 1; i <= pagination_count; i++) {
            nav_list += '    <a href="#" page="' + i + '" limit="' + rowlimit + '" class="button pagenationbtn ' + ((pagenum == i) ? 'active' : '') + '">' + i + '</a>';
        }
        nav_list += '    <a href="#" page="next" limit="' + rowlimit + '" class="button pagenationbtn">></a>';
        nav_list += '    <a href="#" page="last" limit="' + rowlimit + '" class="button pagenationbtn">>></a>';
    } else if (pagenum == pagination_count) {
        var num1 = pagenum - 4, num2 = pagenum - 3, num3 = pagenum - 2, num4 = pagenum - 1, num5 = pagenum;
        nav_list += '    <a href="#" page="first" limit="' + rowlimit + '" class="button pagenationbtn ">&#60;&#60;</a>';
        nav_list += '    <a href="#" page="prev" limit="' + rowlimit + '" class="button pagenationbtn">&#60;</a>';
        nav_list += '    <a href="#" page="1" limit="' + rowlimit + '" class="button border-none">...</a>';
        nav_list += '    <a href="#" page="' + num1 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num1 + '</a>';
        nav_list += '    <a href="#" page="' + num2 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num2 + '</a>';
        nav_list += '    <a href="#" page="' + num3 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num3 + '</a>';
        nav_list += '    <a href="#" page="' + num4 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num4 + '</a>';
        nav_list += '    <a href="#" page="' + num5 + '" limit="' + rowlimit + '" class="button pagenationbtn active">' + num5 + '</a>';
        nav_list += '    <a href="#" page="next" limit="' + rowlimit + '" class="button pagenationbtn">&#62;</a>';
        nav_list += '    <a href="#" page="last" limit="' + rowlimit + '" class="button pagenationbtn">&#62;&#62;</a>';
    } else if (pagenum == 1) {
        var num1 = pagenum, num2 = parseInt(pagenum) + 1, num3 = parseInt(pagenum) + 2, num4 = parseInt(pagenum) + 3, num5 = parseInt(pagenum) + 4;
        nav_list += '    <a href="#" page="first" limit="' + rowlimit + '" class="button pagenationbtn">&#60;&#60;</a>';
        nav_list += '    <a href="#" page="prev" limit="' + rowlimit + '" class="button pagenationbtn">&#60;</a>';
        nav_list += '    <a href="#" page="' + num1 + '" limit="' + rowlimit + '" class="button pagenationbtn active">' + num1 + '</a>';
        nav_list += '    <a href="#" page="' + num2 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num2 + '</a>';
        nav_list += '    <a href="#" page="' + num3 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num3 + '</a>';
        nav_list += '    <a href="#" page="' + num4 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num4 + '</a>';
        nav_list += '    <a href="#" page="' + num5 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num5 + '</a>';
        nav_list += '    <a href="#" page="1" limit="' + rowlimit + '" class="button border-none">...</a>';
        nav_list += '    <a href="#" page="next" limit="' + rowlimit + '" class="button pagenationbtn">&#62;</a>';
        nav_list += '    <a href="#" page="last" limit="' + rowlimit + '" class="button pagenationbtn">&#62;&#62;</a>';
    } else if (pagenum <= 4) {
        nav_list += '    <a href="#" page="first" limit="' + rowlimit + '" class="button pagenationbtn">&#60;&#60;</a>';
        nav_list += '    <a href="#" page="prev" limit="' + rowlimit + '" class="button pagenationbtn">&#60;</a>';
        nav_list += '    <a href="#" page="1" limit="' + rowlimit + '" class="button pagenationbtn">1</a>';
        nav_list += '    <a href="#" page="2" limit="' + rowlimit + '" class="button pagenationbtn';
        if (pagenum == 2)
            nav_list += ' active">2</a>';
        else
            nav_list += '">2</a>';
        nav_list += '    <a href="#" page="3" limit="' + rowlimit + '" class="button pagenationbtn';
        if (pagenum == 3)
            nav_list += ' active">3</a>';
        else
            nav_list += '">3</a>';
        nav_list += '    <a href="#" page="4" limit="' + rowlimit + '" class="button pagenationbtn';
        if (pagenum == 4)
            nav_list += ' active">4</a>';
        else
            nav_list += '">4</a>';
        nav_list += '    <a href="#" page="5" limit="' + rowlimit + '" class="button pagenationbtn">5</a>';
        nav_list += '    <a href="#" page="1" limit="' + rowlimit + '" class="button border-none">...</a>';
        nav_list += '    <a href="#" page="next" limit="' + rowlimit + '" class="button pagenationbtn">&#62;</a>';
        nav_list += '    <a href="#" page="last" limit="' + rowlimit + '" class="button pagenationbtn">&#62;&#62;</a>';
    } else if (pagenum > (pagination_count - 4)) {
        var num1 = pagination_count - 4, num2 = pagination_count - 3, num3 = pagination_count - 2, num4 = pagination_count - 1, num5 = pagination_count;
        nav_list += '    <a href="#" page="first" limit="' + rowlimit + '" class="button pagenationbtn">&#60;&#60;</a>';
        nav_list += '    <a href="#" page="prev" limit="' + rowlimit + '" class="button pagenationbtn">&#60;</a>';
        nav_list += '    <a href="#" page="1" limit="' + rowlimit + '" class="button border-none">...</a>';
        nav_list += '    <a href="#" page="' + num1 + '" limit="' + rowlimit + '" class="button pagenationbtn';
        if (pagenum == num1)
            nav_list += ' active">' + num1 + '</a>';
        else
            nav_list += '">' + num1 + '</a>';
        nav_list += '    <a href="#" page="' + num2 + '" limit="' + rowlimit + '" class="button pagenationbtn';
        if (pagenum == num2)
            nav_list += ' active">' + num2 + '</a>';
        else
            nav_list += '">' + num2 + '</a>';
        nav_list += '    <a href="#" page="' + num3 + '" limit="' + rowlimit + '" class="button pagenationbtn';
        if (pagenum == num3)
            nav_list += ' active">' + num3 + '</a>';
        else
            nav_list += '">' + num3 + '</a>';
        nav_list += '    <a href="#" page="' + num4 + '" limit="' + rowlimit + '" class="button pagenationbtn';
        if (pagenum == num4)
            nav_list += ' active">' + num4 + '</a>';
        else
            nav_list += '">' + num4 + '</a>';
        nav_list += '    <a href="#" page="' + num5 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num5 + '</a>';
        nav_list += '    <a href="#" page="next" limit="' + rowlimit + '" class="button pagenationbtn">&#62;</a>';
        nav_list += '    <a href="#" page="last" limit="' + rowlimit + '" class="button pagenationbtn">&#62;&#62;</a>';
    } else if ((pagenum > 4) && (pagination_count > (parseInt(pagenum) + 2))) {
        var num1 = pagenum - 2, num2 = pagenum - 1, num3 = pagenum, num4 = parseInt(pagenum) + 1;
        nav_list += '    <a href="#" page="first" limit="' + rowlimit + '" class="button pagenationbtn">&#60;&#60;</a>';
        nav_list += '    <a href="#" page="prev" limit="' + rowlimit + '" class="button pagenationbtn">&#60;</a>';
        nav_list += '    <a href="#" page="1" limit="' + rowlimit + '" class="button border-none">...</a>';
        nav_list += '    <a href="#" page="' + num1 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num1 + '</a>';
        nav_list += '    <a href="#" page="' + num2 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num2 + '</a>';
        nav_list += '    <a href="#" page="' + num3 + '" limit="' + rowlimit + '" class="button pagenationbtn active">' + num3 + '</a>';
        nav_list += '    <a href="#" page="' + num4 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num4 + '</a>';
        nav_list += '    <a href="#" page="6" limit="' + rowlimit + '" class="button border-none">...</a>';
        nav_list += '    <a href="#" page="next" limit="' + rowlimit + '" class="button pagenationbtn">&#62;</a>';
        nav_list += '    <a href="#" page="last" limit="' + rowlimit + '" class="button pagenationbtn">&#62;&#62;</a>';
    }
    nav_list += '</div>';
    $('.pagenatio').html(nav_list);
}
function page_display(pagenumber) {
    var item_start_count = (Number(pagenumber - 1) * 20 + 0);
    var count = item_start_count + 1;
    var option = '';
    for (var i = item_start_count; i < Number(item_start_count) + 20; i++) {
        if (item_json_list[i] == undefined)
        {
            break;
        } else {
            option += '<tr class="sec_grid">'
            option += '<td>' + count + '</td>'
            option += '<td>' + item_json_list[i]['companyname'] + '</td>'
            if (item_json_list[i]['website'] != null) {
                option += '<td>' + item_json_list[i]['website'] + '</td> '
            } else {
                option += '<td>' + ' ' + '</td> '
            }
            option += '<td>' + item_json_list[i]['email'] + '</td>'
            option += '<td>' + item_json_list[i]['phone'] + '</td>'
            option += '<td>'
            option += '<div class="inline-block dropdown">'
            option += '<a class="dropdown-toggle" data-toggle="dropdown" href="#" aria-expanded="true" role="button"><i class="icon lindo-android-more-vertical act-gray fz-22"></i></a>'

            option += '<ul class="dropdown-menu bullet dropdown-menu-right"  role="menu">'
            option += ' <li class="b-b-g"><a  href="' + siteurl + '/Crm/Accounts/view_account/' + item_json_list[i]['company_id'] + '"><i class="icon lindo-search mr-10 fz-22 vam txt-success"></i>View</a></li>'
            option += ' <li class="b-b-g"><a  href="' + siteurl + '/Crm/Accounts/get_account_by_id/' + item_json_list[i]['company_id'] + '"><i class="icon lindo-page-edit mr-10 fz-22 vam txt-primary"></i>Edit</a></li>'
            option += '<li role="presentation"><a  href="#"  account_Id="' + item_json_list[i]['company_id'] + '" billing_id="' + item_json_list[i]['billingaddress_id'] + '" shipping_id="' + item_json_list[i]['shippingaddress_id'] + '"  id="accouts_delete"><i class="icon lindo-delete-trash-1 mr-10 fz-22 vam txt-danger"></i>Delete</a></li>'
            option += '</ul>'
            option += '</div>'
            option += '</td>'
            option += '</tr>'
            count++;
        }
    }
    $('#search_result').html(option);

}

function readFile(line, lines) {
    line++;
    if (line < lines.length) {
        var line_data = lines[line].split(',');

        var companyname = line_data[0];
        var industry = line_data[1];
        var website = line_data[2];
        var phone = line_data[3];
        var email = line_data[4];
        var fax = line_data[5];
        var no_employee = line_data[6];
        var annual_revenue = line_data[7];
        var bil_adrsline1 = line_data[8];
        var bil_adrsline2 = line_data[9];
        var bil_country = line_data[10];
        var bil_state = line_data[11];
        var bil_city = line_data[12];
        var bil_zipcode = line_data[13];
        var ship_adrsline1 = line_data[14];
        var ship_adrsline2 = line_data[15];
        var ship_country = line_data[16];
        var ship_state = line_data[17];
        var ship_city = line_data[18];
        var ship_zipcode = line_data[19];
        var data1 = {
            companyname: companyname,
            industry: industry,
            website: website,
            phone: phone,
            email: email,
            fax: fax,
            no_employee: no_employee,
            annual_revenue: annual_revenue,
            bil_adrsline1: bil_adrsline1,
            bil_adrsline2: bil_adrsline2,
            bil_country: bil_country,
            bil_state: bil_state,
            bil_city: bil_city,
            bil_zipcode: bil_zipcode,
            ship_adrsline1: ship_adrsline1,
            ship_adrsline2: ship_adrsline2,
            ship_country: ship_country,
            ship_state: ship_state,
            ship_city: ship_city,
            ship_zipcode: ship_zipcode
        }
        if (companyname != '') {
            $('#jquery_mask').show();
            $.ajax({
                url: siteurl + '/Crm/Accounts/import_from_js',
                method: 'POST',
                data: data1,
                success: function (data) {
                    $('#jquery_mask').hide();
                    console.log('line' + line);
                    readFile(line, lines);
                },
                error: function (a, b, c) {
                    $('#jquery_mask').hide();
                    console.log('line' + line);
                    readFile(line, lines);
                }
            });
        } else {
            readFile(line, lines);
        }
    } else {
        location.reload();
    }
}
function isEmail(email) {
    var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
    return regex.test(email);
}