$(document).ready(function () {
    $('#expense_header_edit').on('click', function () {
        var expense_header_id = $(this).attr('expense_header_id');
        $('#jquery_mask').show();
        $.post(siteurl + '/Crm/Taskexpenseheader/get_expenseheader_by_id', {expense_header_id: expense_header_id}, function (data) {
            $('#jquery_mask').hide();
            var result = JSON.parse(data);
            $('#expenseheadereditmodal #expense_header').val(result.expense_header);
            $('#expenseheadereditmodal #expense_header_id').val(result.expense_header_id);
        });
    });


    $('body').on('click', '#expense_header_delete', function () {
        var expense_header_id = $(this).attr('expense_header_id');
        var s = $(this).closest('tr');
        swal({
            title: "Are you sure?",
            text: "You are going to delete this Expense header",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes, delete !",
            cancelButtonText: "No, don't delete !",
            closeOnConfirm: false,
            closeOnCancel: false
        },
                function (isConfirm) {
                    if (isConfirm) {
                        $('#jquery_mask').show();
                        $.ajax({
                            url: siteurl + "/Crm/Taskexpenseheader/delete_expense_header",
                            data: {expense_header_id: expense_header_id},
                            cache: false,
                            datatype: "json",
                            type: "post",
                            success: function (d) {
                                $('#jquery_mask').hide();
                                $(s).remove();
                                //$(this).closest('.list-group').remove();
                                swal("Deleted!", "Expense header has been deleted.", "success");
                            },
                            fail: function (d) {
                                $('#jquery_mask').hide();
                                swal("Cannot delete!", "Expense header cannot be deleted.", "error");
                            }
                        });
                    } else {
                        swal("Cancelled", "Expense header is not deleted ", "error");
                    }
                });
        return false;

    });

    $('body').on('click', '#addexpense', function () {
        var assigned_employee = $(this).data('assigned_employee');
        var taskid = $(this).data('taskid');
        $('#addexpenseModal .task_id').val(taskid);
        $('#addexpenseModal .assigned_employee').val(assigned_employee);
        $('#jquery_mask').show();
        $.post(siteurl + '/Crm/Task/get_expense_by_task', {taskid: taskid}, function (data) {
            $('#jquery_mask').hide();
            if (data != 0) {
                $('#addexpenseModal .modal-content').html(data);
                $('#addexpenseModal .task_id').val(taskid);
                $('#addexpenseModal .assigned_employee').val(assigned_employee);
            }
        });

    });

    $('body').on('change', '.expense_header', function () {
        var header = $(this).val();
        var tr = $(this).closest('tr');
        var eid = tr.attr('id-cl');
        $('.table-append tr.cld').not('tr[id-cl=' + eid + ']').find('select.expense_header option[value=' + header + ']').remove();
    });

    $('body').on('click', '.removeorgmember', function (e) {
        var closest = $(this).closest('tr');
        var item_count = closest.attr('id-cl');
        if (item_count == 1) {
            var bc = $(this).parent().parent();
            var dd = bc.find("input");
            var ss = bc.find("select");
            dd.val("");
            ss.val("");
        } else {
            e.preventDefault();
            var bc = $(this).parent().parent().remove();
            var dd = bc.find("input");
            var ss = bc.find("select");
            dd.val("");
            ss.val("");
            sum = 0;
            $('.amount').each(function ()
            {
                sum += Number($(this).val());
            });
            $('#total').val(sum);
        }
    });

    $('body').on('click', '.copyorgmember', function (e) {

        var amount = $('.amount:last').val();
        if (amount == '') {
            swal("Enter valid entry");
        } else {
            e.preventDefault();
            var clid = $(".cld:last").attr('id-cl');
            var nxt = parseFloat(clid) + 1;
            var bc = $("#addexpenseModal tr.cld[id-cl=1]").clone();
            bc.attr("id-cl", nxt);
            var dd = bc.find("input");
            bc.find('.clear').remove();
            dd.val("");
            bc.find("textarea").val('');
            bc.find(".pdt_title").text('');
            bc.find(".attach").html('');
            bc.removeClass('clone');

            $('#addexpenseModal .expense_header').each(function () {
                var header = $(this).val();
                bc.find('select.expense_header option[value=' + header + ']').remove();
                console.log(header);
                var tr = $(this).closest('tr');
                var eid = tr.attr('id-cl');
                $('.table-append tr.cld').not('tr[id-cl=' + eid + ']').find('select.expense_header option[value=' + header + ']').remove();
            });

            var cc = bc.find('.no-display');

            cc.removeClass('no-display');
            bc.appendTo(".table-append");
        }
    });
});
