$(document).ready(function () {
    $(window).load(function () {
        if (typeof old_rate !== 'undefined' && typeof new_rate !== 'undefined' && parseFloat(old_rate) != '' && parseFloat(old_rate) != parseFloat(new_rate)) {
            swal({
                title: "Transaction Rate Changed",
                text: "Do you want to apply the new rate",
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "Yes, Apply !",
                cancelButtonText: "No, don't apply !",
                closeOnConfirm: false,
                closeOnCancel: false
            },
                    function (isConfirm) {
                        if (isConfirm) {
                            $('.currency_rate').val(new_rate);
                            $('.old_hidden').val(old_rate);
                            $('.cur_trans_rate_id').val(new_cur_trans_rate_id);
                            swal("Rate Changed", "New Rate applied", "success");
                        } else {
                            swal("Cancelled", "Previous Rate will prevail", "success");
                            $('.gainloss').hide();
                        }
                    });
        } else {
            $('.gainloss').hide();
        }
    });
    $('body').on('change', '#get_po', function ()
    {
        var po_id = $(this).val();
        window.location.href = siteurl + "/Inventory/Bill/new_bill/" + po_id;
    });

    $('body').on('click', '.po_number', function ()
    {
        $('#jquery_mask').show();
        $.post(siteurl + "/Equipment/Equipment_Bill/list_po_model", {act: 'bill'}, function (data)
        {
            $('#jquery_mask').hide();
            $('#PO_List .modal-body').html(data);
        });
    });
    $('body').on('click', '.charge_new', function () {
        var selid = $(this).closest('tr').attr('id-cl_charge');
        $("#trid_charge").val(selid);
    });
    $('body').on('click', '#new_charges', function () {
        var charge_amount = $('#charge').val();
        var charge_id = $('#asso_extra_chrg').val();
        var charge_paidby = $("input[name='charge_paid_by']:checked").val();
        if (charge_amount != '' && charge_id != '') {

            var charge_type = $('input[name=charge_bill_type]:checked').val();
            var oc_paid_through = $('#oc_paid_through').val();
            var oc_pay_type = $('#oc_pay_type').val();
            var charge_vendor = $('#charge_vendor_id').val();
            var ot_valid_until = $('#charge_valid_until').val();
            var charge_bill_date = $('#charge_bill_date').val();
            var ot_currency_id = $('#trans_currency_id').val();
            var ot_currency_rate_id = $('#trans_cur_rate_id').val();
            var ot_currency_rate = $('#trans_currency_rate').val();
            if (charge_type == 'actual' && charge_paidby == 'company' && (oc_pay_type == 'Cash' || oc_pay_type == 'Card') && oc_paid_through == '') {
                $('#oc_paid_through').css('border', '1px solid red');
            } else if (charge_type == 'actual' && charge_paidby == 'company' && oc_pay_type == 'Credit' && charge_vendor == '') {
                $('#charge_vendor').css('border', '1px solid red');
            } else {
                var charge_id = $('#asso_extra_chrg').val();
                var charge_description = $('#charge_discription').val();
                var charge_amount = $('#charge').val();
                var chrg_name = $('#asso_extra_chrg option:selected').attr('charg_name');
                var bill_no = $('#bill_no_div').val();
                var sid = $('#trid_charge').val();
                var sll = $('.cld_charge[id-cl_charge=' + sid + ']');
                var ff = sll.find('.associated_chrg_id');
                ff.val(charge_id);
                var chaid = sll.find('.charge_id');
                chaid.val(charge_id);
                var chrg = sll.find('.charge_name_t');
                chrg.text(chrg_name);

                sll.find('.charge_paid_type').val(oc_pay_type);
                sll.find('.charge_paid_through').val(oc_paid_through);
                sll.find('.ot_valid_until').val(ot_valid_until);
                sll.find('.ot_vendor_id').val(charge_vendor);
                sll.find('.ot_bill_date').val(charge_bill_date);
                sll.find('.ot_transaction_currency').val(ot_currency_id);
                sll.find('.ot_transaction_currency_rate_id').val(ot_currency_rate_id);
                sll.find('.ot_transaction_currency_rate').val(ot_currency_rate);

                var paid_by = sll.find('.charge_paidby');
                paid_by.val(charge_paidby);
                var amountt = sll.find('.charge_amount_t');
                amountt.text(charge_amount);
                var amount1 = sll.find('.charge_amount')
                amount1.val(charge_amount);
                if (charge_paidby == "company" || charge_paidby == "vendor") {
                    var amountt = sll.find('#other_amount');
                    amountt.val(charge_amount);
                }
                var qq = sll.find('.charge_description');
                qq.val(charge_description);
                var bill_number = sll.find('.bill_no');
                bill_number.val(bill_no);
                var chargetype = sll.find('.charge_type');
                chargetype.val(charge_type);
                if (charge_type == 'acural') {
                    sll.find('.checck_acural').hide();
                    $('#charge_bill_number').val('');
                } else {
                    sll.find('.checck_acural').hide();
                    sll.find('.actual').addClass('no-display');
                    sll.find('.checck_acural').html('');
                }
                var sum = 0;
                var sum2 = 0;
                var f = 0;
                if (charge_paidby == "vendor") {
                    var sum1 = $('#bill_subtotal_txt').html();
                    sum2 = $('#charge').val();
                    sum1 = Number(sum1) + Number(sum2);
                    $('#bill_subtotal_txt').html(sum1);
                    $('#bill_subtotal').val(sum1);
                    var hid_sum1 = $('#total_amount_hidden').val();
                    hid_sum1 = Number(hid_sum1) + Number(sum2);
                    $('#total_amount_hidden').val(hid_sum1);

                } else {
                    if (charge_type == 'actual') {
                        if ($('#oc_pay_type').val() == '') {
                            f = 1;
                            $('#oc_pay_type').css('border', '1px solid red');
                        }
                        if ($('#oc_paid_through').val() == '') {
                            f = 1;
                            $('#oc_paid_through').css('border', '1px solid red');
                        }
                        if ($('#oc_pay_type').val() == '') {
                            f = 1;
                            $('#asso_extra_chrg').css('border', '1px solid red');
                        }
                    }
                    if ($('#trans_currency_id').val() == null) {
                        f = 1;
                        $('#trans_currency_id').css('border', '1px solid red');
                    }
                    if ($('#charge_vendor').val() == '') {
                        f = 1;
                        $('#charge_vendor').css('border', '1px solid red');
                    }
                }
                var ttlsum = 0;
                $('.charge_amount').each(function () {
                    ttlsum += Number($(this).val());

                });
                if (f == 0) {
                    $('.extracharge_totalamnt').val(ttlsum);
                    $('.extracharge_totalamnt').html(ttlsum);
                    $('#Othercharges').modal('hide');
                }
            }
        } else if (charge_amount == '') {
            $('#charge').css('border', '1px solid red');
        } else if (charge_id == '') {
            $('#asso_extra_chrg').css('border', '1px solid red');
        }
        $('#common_percentage_amount').trigger('change');
        $('.charge_new[id-cl_charge="' + sid + '"]').addClass('no-display');

    });
    $('body').on('keyup', '#charge', function (e) {
        $('#charge').css('border', '1px solid rgba(33, 33, 33, 0.12)');
    });
    $('body').on('click', '.copyorgmember_charge', function (e) {
        var val_chrge = $('.charge_amount_t:last').text();
        if (val_chrge == '') {
            swal("Enter valid other charge entry");
        } else {
            e.preventDefault();
            var clid = $(".cld_charge:last").attr('id-cl_charge');
            var nxt = parseFloat(clid) + 1;
            var bc = $(".clone_charge").clone();
            bc.attr("id-cl_charge", nxt);
            var dd = bc.find("input");
            bc.find(".charge_name_t").text('');
            bc.find(".charge_amount_t").text('');
            dd.val("");
            bc.removeClass('clone_charge');
            bc.find('.clear_charge').remove();
            var cc = bc.find('.no-display');
            cc.removeClass('no-display');
            bc.appendTo(".table-append_charge");
//        aswathy
            $('#asso_extra_chrg').val('');
//            $('#charge_bill_type').prop('checked', false);
            $('#charge_bill_number').val('');
            $('#charge').val('');
            $('#charge_discription').val('');
            $('#charge_paid_by').prop('checked', false);
        }
    });

    $('body').on('click', '.removeorgmember_charge', function (e) {
        e.preventDefault();

        var sum2 = 0;
        var charge = $(this).closest('tr').find('.charge_amount').val();
        var charge_paidby = $(this).closest('tr').find('.charge_paidby').val();
        if (charge_paidby == "vendor") {
            sum2 += Number(charge);
        }
        var sum1 = $('#bill_subtotal_txt').text();
        var sum3 = Number(sum1) - Number(sum2);
        $('#bill_subtotal_txt').text(sum3);
        $('#bill_subtotal').val(sum3);
        $(this).closest('tr').remove();
    });

    $('body').on('click', '.clear_charge', function (e) {
        e.preventDefault();
        var sum2 = 0;
        var charge = $(this).closest('tr').find('.charge_amount').val();
        $(this).closest('tr').find('.charge_new').removeClass('no-display');
        var charge_paidby = $(this).closest('tr').find('.charge_paidby').val();
        if (charge_paidby == "vendor") {
            sum2 += Number(charge);
        }
        var hid_sum1 = $('#bill_subtotal_txt').html();
        hid_sum1 = Number(hid_sum1) - Number(sum2);
        $('#bill_subtotal_txt').html(hid_sum1);
        $('#bill_subtotal').val(hid_sum1);
        $(this).closest('tr').find('input,select,checkbox').val('');
        $(this).closest('tr').find('.charge_name_t').text('');
        $(this).closest('tr').find('.charge_amount_t').text('');
        $(this).closest('tr').find('.charge_amount').val('0');
        var ttlsum = 0;
        $('.charge_amount').each(function () {
            ttlsum += Number($(this).val());

        });
        $('.extracharge_totalamnt').val(ttlsum);
        $('.extracharge_totalamnt').html(ttlsum);
        $("#bill_subtotal_txt").trigger("change");
        $('#common_percentage_amount').trigger('change');

    });

    $('body').on('click', '.ck_sel', function () {
        if ($(this).is(":checked")) {
            var table_cls = $(this).closest('table').attr('table_cls');
            var rowid = $(this).closest('tr').attr('id-cl');
//            var sll = $('.' + table_cls + ' [id-cl=' + rowid + ']');
            var sll = $(this).closest('tr');
            var aa = sll.find('#qty');
            var rr = sll.find('#pro_rate');
            var dc = sll.find('#discount');
            var kl = sll.find('.enterd_dis_amount');
            aa.attr('readonly', false);
            rr.attr('readonly', false);
            dc.attr('readonly', false);
            kl.attr('readonly', false);
            calculate_row_amount(sll);
            product_subtotal_calculation();
            final_calculation();
        } else {
            var table_cls = $(this).closest('table').attr('table_cls');
            var rowid = $(this).closest('tr').attr('id-cl');
//            var sll = $('.' + table_cls + ' [id-cl=' + rowid + ']');
            var sll = $(this).closest('tr');
            var aa = sll.find('#qty');
            var rr = sll.find('#pro_rate');
            var mm = sll.find('#pro_amount');
            var nn = sll.find('#po_rate');
            var dc = sll.find('#discount');
            var kl = sll.find('.enterd_dis_amount');
            aa.attr('readonly', true);
            rr.attr('readonly', true);
            dc.attr('readonly', true);
            kl.attr('readonly', true);
            aa.val('');
            dc.val('');
            var amt = nn.val();
//            $('#pro_rate').val(amt);
            mm.val(0);
            calculate_row_amount(sll);
            product_subtotal_calculation();
            final_calculation();
//            $('#ttltax_amount_txt').html('0.00');
        }
    });

    $('#bill_form').on('submit', function (e) {
        var count_err = 0;
        var checked = 0;
        var purchase_type = $('#sale_type').val();
        var paid_from = $('#deposit_to').val();
        $('.qty').each(function () {
            if ($(this).closest('tr').find('.ck_sel').prop('checked')) {
                checked++;
                if ($(this).val() == '0' || $(this).val() == '' || isNaN($(this).val())) {
                    count_err++;
                }
            }
        });
        if (purchase_type != "Credit" && paid_from == "") {
            e.preventDefault();
            swal('Alert', 'Please select Paid From', 'error');
        }
        if (checked == 0) {
            e.preventDefault();
            swal('Alert', 'Please select atleast one item', 'error');
        }
        if (count_err > 0) {
            e.preventDefault();
            swal('Alert', 'Please enter valid issue quantity.', 'error');
        }
    });
    $('body').on('click', '.checck_acural', function ()
    {
        if ($(this).is(":checked"))
        {
            $(this).closest('td').find('.charge_type').val('actual');
            $(this).closest('td').find('.bill_no').show();
        } else
        {
            $(this).closest('td').find('.charge_type').val('acural');
            $(this).closest('td').find('.bill_no').hide();
        }
    });
    $('body').on('click', '#charge_bill_type', function ()
    {
        if ($("input[name='charge_bill_type']:checked").val() == 'actual') {
            $('#bill_no_div').show();
        } else {
            $('#bill_no_div').hide();
        }
    });
    $('body').on('click', '.get_po_frominvoice', function (e) {
        var closest_tr = $(this).closest('tr');
        if ($(closest_tr).find('.mrv:checked').length > 0) {
        } else {
            e.preventDefault();
            swal('Please Select Atleast One MRV');
        }
    });


    $('body').on('click', '#currency_id', function () {
        var currency_id = $(this).val();
        $.post(siteurl + "/Inventory/Bill/fetch_currency_rate_by_latest", {currency_id: currency_id}, function (data) {
            var result = JSON.parse(data);
            $('.div_currencyrate').removeClass('no-display');
            $('.currency_rate').val(result.rate);
            $('.cur_trans_rate_id').val(result.cur_trans_rate_id);
            var net_amount = $('#bill_subtotal_txt').text();
            if (typeof result.rate === 'undefined' || result.rate == '') {
                result.rate = 1;
            }

            if (net_amount != 'undefined' && net_amount != '') {
                var transaction_currency = parseFloat(net_amount) * parseFloat(result.rate);
                var tr_currency = transaction_currency.toFixed(2);
                $('#transaction_currency').val(tr_currency);
                $('#transaction_rate_value').html(tr_currency);
                if (currency_id != cur_id) {
                    $('#transaction_gain').hide();
                } else {
                    $('#transaction_gain').show();
                }

            }

        });
    });


    $('body').on('change', '.qty', function () {
        $("#bill_subtotal_txt").trigger("change");
    });
    $('body').on('change', '.dis', function () {
        $("#bill_subtotal_txt").trigger("change");
    });

    $('body').on('click', '.new_charges', function () {
        $("#bill_subtotal_txt").trigger("change");
    });
    $('body').on('click', '.removeorgmember_charge', function () {
        $("#bill_subtotal_txt").trigger("change");
    });
    $('body').on('change click', '.new_charges,.removeorgmember_charge,.clear_charge', function () {
        var net_amount = $('#bill_subtotal_txt').text();

        var transaction_rate = $('#currency_rate').val();
        if (transaction_rate == 'undefined' && transaction_rate == '') {
            transaction_rate = 1;
        }

        if (net_amount != 'undefined' && net_amount != '') {
            var transaction_currency = parseFloat(net_amount) * parseFloat(transaction_rate);
            var tr_currency = transaction_currency.toFixed(2);
            $('#transaction_currency').val(tr_currency);
            $('#transaction_rate_value').html(tr_currency);
            var old_rate = $('#old_hidden').val();
            if (old_rate) {
                var po_amount = $('#old_hidden').val() * net_amount;
                var po = parseFloat(po_amount).toFixed(2);
                var tr = parseFloat(transaction_currency).toFixed(2);
                var gain_or_loss = parseFloat(po) - parseFloat(tr);
                var gain_loss = gain_or_loss.toFixed(2);
                $('.transaction_gain').html(gain_loss);
                $('#transaction_gain1').val(gain_loss);
            }
        }

    });


    $('body').on('click', '#search_do_keyword', function () {
        var search_do_keywords = $('#search_do_keywords').val();
        var from_date_list = $('.from_date_list').val();
        var to_date_list = $('.to_date_list').val();
        if (search_do_keywords == '' && from_date_list == '' && to_date_list == '') {
            swal("Please check any filter");
            $('#search_so_keywords').css('border', '1px solid red');
        } else if (from_date_list == '' && search_do_keywords == '')
        {
            swal("Please select from date");
        } else if (to_date_list == '' && search_do_keywords == '')
        {
            swal("Please select to date");
        } else {
            $('#filtersubmit').submit();
        }
    });
    $('body').on('click', '.pagesubmit', function (e) {
        e.preventDefault();
        var from_date_list = $('#from_date_list').val();
        var to_date_list = $('#to_date_list').val();
        var search_do_keywords = $('#search_do_keywords').val();
        $('#frmdate').val(from_date_list);
        $('#todate').val(to_date_list);
        $('#keywd').val(search_do_keywords);
        var url = $(this).attr('href');
        $('#paginationfilter').attr('action', url);
        $('#paginationfilter').submit();
    });


    $('body').on('change', '#sale_type', function ()
    {
        var mode = $('#sale_type').val();
        if (mode == 'Cheque') {
            $('#depositto').show();
            $('#jquery_mask').show();
            $.post(siteurl + "/Inventory/Inventory_transaction/get_details_payment", {selected: mode}, function (data) {
                $('#jquery_mask').hide();
                var json_array = JSON.parse(data);
                var html_data = '';
                html_data += '<option value="">select</option>';
                for (var i = 0; i < json_array[0].length; i++)
                {
                    html_data += '<option value="' + json_array[0][i]['account_id'] + '">' + json_array[0][i]['account_name'] + '</option>';
                }
                $('#deposit_to').html(html_data);
            });
            $('#chequepanel').show();
            $('#card_or_bank').hide();
            $('#amt_received').attr('readonly', true);
        } else if (mode == 'Cash') {
            $('#chequepanel').hide();
            $('#depositto').show();
            $('#jquery_mask').show();
            $.post(siteurl + "/Accounts/Transaction/get_details_payment", {selected: mode}, function (data) {
                $('#jquery_mask').hide();
                var json_array = JSON.parse(data);
                var html_data = '';
                html_data += '<option value="">select</option>';
                for (var i = 0; i < json_array[0].length; i++)
                {
                    html_data += '<option value="' + json_array[0][i]['account_id'] + '">' + json_array[0][i]['account_name'] + '</option>';
                }
                $('#deposit_to').html(html_data);
                $('#card_or_bank').hide();
            });
        } else if (mode == 'Card') {
            $('#chequepanel').hide();
            $('#depositto').show();
            mode = 'Bank';
            $('#jquery_mask').show();
            $.post(siteurl + "/Accounts/Transaction/get_details_payment", {selected: mode}, function (data) {
                $('#jquery_mask').hide();
                var json_array = JSON.parse(data);
                var html_data = '';
                html_data += '<option value="">select</option>';
                for (var i = 0; i < json_array[0].length; i++)
                {
                    html_data += '<option  value="' + json_array[0][i]['account_id'] + '">' + json_array[0][i]['account_name'] + '</option>';
                }
                $('#deposit_to').html(html_data);
                $('#card_or_bank').show();
            });
        } else if (mode == 'Credit') {
            $('#depositto').hide();
        }
    });

    $('#record_cheque_bill').on('submit', function (e) {
        var cheque_no = $('#cheque_no').val();
        var deposit_to = $('#deposit_to').val();
        var account_no = $('#account_no').val();
        var cheque_date = $('#cheque_date').val();
        var cheque_amount = $('#cheque_amount').val();
        var hidden_cheque_amount = $('#hidden_cheque_amount').val();
        if (Number(hidden_cheque_amount) < Number(cheque_amount)) {
            e.preventDefault();
            swal('Alert', 'Amount is greater than actual amount', 'error');
        } else if (cheque_amount == "0") {
            e.preventDefault();
            swal('Alert', 'You are already paid', 'error');
        } else if (cheque_no == "" || deposit_to == "" || account_no == "" || cheque_date == "" || cheque_amount == "") {
            e.preventDefault();
            swal('Alert', 'Please Fill All the Fields', 'error');
        }
    });

    $('body').on('click', '.cheque_clearence', function (e) {
        var cheque_track_id = $(this).attr('cheque_track_id');
        swal({
            title: "Are You sure want to clear cheque",
            text: "Do you Want to Clear?",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes, Proceed !",
            cancelButtonText: "No, don't Proceed !",
            closeOnConfirm: false,
            closeOnCancel: true
        },
                function (isConfirm) {
                    if (isConfirm) {
                        $.post(siteurl + "/Accounts/Transaction/chequeclearence", {cheque_track_id: cheque_track_id}, function (data)
                        {
                            location.reload();
                        });
                    } else {
                        e.preventDefault();
                    }
                });

    });



    $('body').on('click', '.use_advance', function (e)
    {
        var adv_amount = $(this).attr('adv_amt');
        var adv_amount_id = $(this).val();
        var payment_made = $('#cheque_amount').val();
        var use_value_hidden = $('#use_value_hidden').val();
        var use_id_hidden = $('#use_id_hidden').val();
        var amount = 0;
        if (payment_made > 0) {
            if (Number(adv_amount) >= Number(payment_made)) {
                var use_amount = parseFloat(adv_amount) - parseFloat(payment_made);
                $(this).closest('tr').find('.use_val').html(use_amount);
                $('#cheque_amount').val(0);
                $('#hidden_cheque_amount').val(0);
                amount = payment_made;
            } else {
                var new_payment_made = parseFloat(payment_made) - parseFloat(adv_amount);
                $(this).closest('tr').find('.use_val').html(0);
                $('#cheque_amount').val(new_payment_made);
                $('#hidden_cheque_amount').val(new_payment_made);
                amount = adv_amount;
            }
            $(this).hide();
            $(this).closest('tr').find('.revert_advance').show();
            if (use_value_hidden != "" && use_id_hidden != "") {
                var value = use_value_hidden + ',' + amount;
                var id = use_id_hidden + ',' + adv_amount_id;
                $('#use_value_hidden').val(value);
                $('#use_id_hidden').val(id);
            } else {
                $('#use_value_hidden').val(amount);
                $('#use_id_hidden').val(adv_amount_id);
            }

        }
    });


    $('body').on('click', '.revert_advance', function (e)
    {
        var adv_amount = $(this).attr('adv_amt');
        var adv_amount_id = $(this).val();
        var payment_made = $('#cheque_amount').val();
        var use_value_hidden = $('#use_value_hidden').val();
        var use_id_hidden = $('#use_id_hidden').val();
        var amount = 0;
//        if (payment_made > 0) {
        if (Number(adv_amount) >= Number(payment_made)) {
            var new1 = $(this).closest('tr').find('.use_val').html();
            var use_amount = parseFloat(adv_amount) - parseFloat(new1);
            var new_payment_made = parseFloat(payment_made) + parseFloat(use_amount);
            $(this).closest('tr').find('.use_val').html(adv_amount);
            $('#cheque_amount').val(new_payment_made);
            $('#hidden_cheque_amount').val(new_payment_made);
            amount = use_amount;
        } else {
            if (payment_made > 0) {
                var new1 = $(this).closest('tr').find('.use_val').html();
                var use_amount = parseFloat(adv_amount) - parseFloat(new1);
                var new_payment_made = parseFloat(payment_made) + parseFloat(use_amount);
                $(this).closest('tr').find('.use_val').html(adv_amount);
                $('#cheque_amount').val(new_payment_made);
                $('#hidden_cheque_amount').val(new_payment_made);
                amount = new_payment_made;
            }
        }

        $(this).hide();
        $(this).closest('tr').find('.use_advance').show();
        var values1 = use_value_hidden.split(',');
        for (var i = 0; i < values1.length; i++) {
            if (values1[i] == amount) {
                values1.splice(i, 1);
                values1.join(',');
            }
        }

        var id1 = use_id_hidden.split(',');
        for (var i = 0; i < id1.length; i++) {
            if (id1[i] == adv_amount_id) {
                id1.splice(i, 1);
                id1.join(',');
            }
        }
        $('#use_value_hidden').val(values1);
        $('#use_id_hidden').val(id1);

    });

    $('body').on('click', '.amc_pick_radio', function (e) {
        var option = '';
        $('#Asset_number_modal').modal('show');
        var equip_id = $(this).attr('equip_id');
        var amc_id = $(this).val();
        var amc_price = $(this).attr('amc_price');
        var amc_name = $(this).attr('amc_name');
        $('#equip_id_asset').val(equip_id);
        $('#amc_id_asset').val(amc_id);
        $('#amc_price_asset').val(amc_price);
        $('#amc_name_asset').val(amc_name);

        $.post(siteurl + "/Equipment/Equipment_Bill/get_all_assset_numbers_by_master", {equip_id: equip_id, amc_id: amc_id}, function (data)
        {
            var json_array = JSON.parse(data);
            var count = 1;
            for (var i = 0; i < json_array.length; i++) {
                option += '<tr>';
                option += '<td>' + count + '</td>';
                option += '<td>' + json_array[i].asset_number + '</td>';
                option += '<td><div class="checkbox checkbox-success"><input class="asset_select" equipment_id="' + equip_id + '" asset_number="' + json_array[i].asset_number + '" type="checkbox" name="asset_select" ><label for="checkbox_1"></label></div></td>';
                option += '</tr>';
                count++;
            }
            option += '<input type="hidden" value="' + equip_id + '" class="equipment_id_asset" id="equipment_id_asset" />';
            $('.assets_list').html(option);
            $('#Amc_modal').modal('hide');
        });
    });
    $('body').on('click', '.amcserialpick', function (e) {
        var equipment_id = $('.equipment_id_asset').val();
        var amc_price_asset = $('#amc_price_asset').val();
        var amc_name_asset = $('#amc_name_asset').val();
        var amc_id_asset = $('#amc_id_asset').val();
        $.post(siteurl + "/Equipment/Equipment_Bill/amc_details_by_amc_equip_ids", {equip_id: equipment_id}, function (data)
        {
            var option = '';
            var next_date = '';
            var next_year = '';
            $('.asset_select').each(function () {
                if ($(this).is(":checked")) {
                    if (data != '') {
                        var date = new Date(data);
                        var dd = date.getDate() + 1;
                        var mm = date.getMonth() + 1;
                        var yyyy = date.getFullYear();
                        var llll = date.getFullYear() + 1;
                        if (dd < 10) {
                            dd = '0' + dd
                        }
                        if (mm < 10) {
                            mm = '0' + mm
                        }
                        next_date = yyyy + '-' + mm + '-' + dd;
                    } else {
                        var date = new Date();
                        next_date = date.getFullYear() + "-" + (date.getMonth() + 1) + "-" + date.getDate();
                    }
                    var date = new Date(next_date);
                    var dd = date.getDate() + 1;
                    var mm = date.getMonth() + 1;
                    var yyyy = date.getFullYear();
                    var llll = date.getFullYear() + 1;
                    if (dd < 10) {
                        dd = '0' + dd
                    }
                    if (mm < 10) {
                        mm = '0' + mm
                    }
                    next_year = llll + '-' + mm + '-' + dd;
                    option += '<tr>';
                    option += '<td><input type="text" class="form-control asset_number_amc" name="asset_number_amc[]" value="' + $(this).attr('asset_number') + '" /></td><td><input type="hidden" class="form-control equip_id_amc" name="equip_id_amc[]" value="' + equipment_id + '" /><input type="hidden" class="form-control amc_id_amc" name="amc_id_amc[]" value="' + amc_id_asset + '" /> <input class="form-control amc_name_amc" name="amc_name_amc[]" readonly value="' + amc_name_asset + '" /></td><td><input class="form-control amc_price_amc" name="amc_price_amc[]" readonly class="" value="' + amc_price_asset + '" /></td><td><input class="form-control amc_qty" name="amc_qty[]" class="" value="1" /></td><td><input name="start_date_amc[]" class="form-control start_date_amc datepicker_start" value="' + next_date + '" /></td><td><input name="end_date_amc[]" readonly class="form-control end_date_amc" value="' + next_year + '" /></td>';
                    option += '</tr>';
                }
            });
            $('.amcview').removeClass('no-display');
            $('.amc_list_view').html(option);
            $('#Asset_number_modal').modal('hide');
            $('.datepicker_start').datepicker({
                dateFormat: 'yy-mm-dd',
                minDate: new Date(next_date)
            });
        });
    });
    $('body').on('change', '.start_date_amc', function (e) {
        var next_year = '';
        var date = new Date($(this).val());
        var dd = date.getDate() + 1;
        var mm = date.getMonth() + 1;
        var yyyy = date.getFullYear();
        var llll = date.getFullYear() + 1;
        if (dd < 10) {
            dd = '0' + dd
        }
        if (mm < 10) {
            mm = '0' + mm
        }
        next_year = llll + '-' + mm + '-' + dd;
        $('.end_date_amc').val(next_year);
    });
    $('body').on('keyup', '.amc_qty', function (e) {
        var next_year = '';
        var date = new Date($('.start_date_amc').val());
        var dd = date.getDate() + 1;
        var mm = date.getMonth() + 1;
        var yyyy = date.getFullYear();
        var llll = date.getFullYear() + parseInt($(this).val());
        if (dd < 10) {
            dd = '0' + dd
        }
        if (mm < 10) {
            mm = '0' + mm
        }
        next_year = llll + '-' + mm + '-' + dd;
        $('.end_date_amc').val(next_year);
    });
    $('body').on('click', '.pick_amc', function (e) {
        var equip_id = $(this).attr('equip_id');
        if ($(this).closest('tr').find('.ck_sel').is(':checked')) {
            $('#Amc_modal').modal('show');
            $.post(siteurl + "/Equipment/Equipment_Bill/amc_details_by_equip_master_id", {equip_id: equip_id}, function (data)
            {
                var json_array = JSON.parse(data);
                var option = '';
                for (var i = 0; i < json_array.length; i++) {
                    option += '<tr>';
                    option += '<td><div class="radio radio-success"><input type="radio" name="amc_pick_radio" id="amc_pick_radio" amc_price="' + json_array[i].price + '" amc_name="' + json_array[i].amc_name + '" value="' + json_array[i].amc_id + '" equip_id="' + equip_id + '"  class="ember-checkbox ember-view amc_pick_radio"><label class="control-label">&nbsp;</label></div></td>';
                    option += '<td>' + json_array[i].amc_name + '</td>';
                    option += '<td>' + json_array[i].price + '</td>';
                    option += '</tr>';
                }
                $('.amc_list').html(option);
            });

        } else {
            swal("please select item");
        }
    });
    $('body').on('click', '.check_all', function ()
    {
        var all_check_row = $(this).attr('id-check');
        if ($(this).is(":checked")) {

            $('.tbl_cls' + all_check_row).each(function () {
                $(this).prop('checked', true);
                var table_cls = $(this).closest('table').attr('table_cls');
                var rowid = $(this).closest('tr').attr('id-cl');
                var sll = $('.' + table_cls + ' [id-cl=' + rowid + ']');
                var aa = sll.find('#qty');
                var rr = sll.find('#pro_rate');
                var dc = sll.find('#discount');
                var eda = sll.find('#enterd_dis_amount');
                aa.attr('readonly', false);
                rr.attr('readonly', false);
                dc.attr('readonly', false);
                eda.attr('readonly', false);
            });
        } else if ($(this).is(":not(:checked)")) {

            $('.tbl_cls' + all_check_row).each(function () {
                $(this).prop('checked', false);
                var table_cls = $(this).closest('table').attr('table_cls');
                var rowid = $(this).closest('tr').attr('id-cl');
                var sll = $('.' + table_cls + ' [id-cl=' + rowid + ']');
                var aa = sll.find('#qty');
                var rr = sll.find('#pro_rate');
                var mm = sll.find('#pro_amount');
                var nn = sll.find('#po_rate');
                var dc = sll.find('#discount');
                var eda = sll.find('#enterd_dis_amount');
                aa.attr('readonly', true);
                rr.attr('readonly', true);
                dc.attr('readonly', true);
                eda.attr('readonly', true);
                aa.val('');
                dc.val('');
                eda.val('');
                var amt = nn.val();
                $('#pro_rate').val(amt);
                mm.val(0);
                var total_pdt = 0;
                $('.pro_amount').each(function () {
                    total_pdt += parseFloat($(this).val());
                });
                total_pdt = total_pdt.toFixed(2);
//                $('#bill_subtotal').val(parseFloat(total_pdt));
//                $('#bill_subtotal_txt').html(total_pdt);
//                $('#bill_subtotal').val(total_pdt);
            });
        }
         $('#common_percentage_amount').trigger('change');
    });
    $('.charge_paid_by').on('click', function () {
        var radioValue = $(".charge_paid_by:checked").val();
        var bill_type = $(".charge_bill_type:checked").val();
//        if(bill_type == 'actual'){
//            if(radioValue == 'company'){
//                $('#pay_mode').show();
//                $('#paid_thrgh').show();
//            }else if(radioValue == 'vendor'){
//                $('#pay_mode').hide();
//                $('#paid_thrgh').hide();
//            }
//        }else{
//            $('#pay_mode').hide();
//            $('#paid_thrgh').hide();
//        }
        if (radioValue == 'vendor') {
            $('.charge_bill_type[value="actual"]').prop('checked', true);
            $('.charge_bill_type[value="actual"]').trigger('click');
            $('.charge_bill_type').prop('disabled', true);
            $('#pay_mode').hide();
            $('#paid_thrgh').hide();
            $('#vendor_chose').hide();
            $('#trans_cur').hide();
            $('#div_currencyrates').hide();

        } else {
            $('#vendor_chose').show();
            $('.charge_bill_type').prop('disabled', false);
            if (bill_type == 'actual') {
                $('#trans_cur').show();
                $('#div_currencyrates').show();
                $('#pay_mode').show();
                $('#paid_thrgh').show();
            } else {
                $('#pay_mode').hide();
                $('#paid_thrgh').hide();
            }
        }
    });

    $('body').on('click', '#charge_bill_type', function ()
    {
        var radioValue = $(".charge_paid_by:checked").val();

        if ($("input[name='charge_bill_type']:checked").val() == 'actual') {
            $('#bill_no_div').show();
            $('#bill_date_div').show();
            if (radioValue == 'company') {
                $('#pay_mode').show();
                $('#paid_thrgh').show();
            } else {
                $('#pay_mode').hide();
                $('#paid_thrgh').hide();
            }
        } else {
            $('#bill_no_div').hide();
            $('#bill_date_div').hide();
            $('#pay_mode').hide();
            $('#paid_thrgh').hide();
        }
    });


    $('body').on('click', '#charge_vendor', function ()
    {
        var pagecheck = "pagejs";
        $('#jquery_mask').show();
        $.post(siteurl + "/Inventory/Purchase/search_vendor/" + pagecheck, {pagecheck: pagecheck}
        , function (data) {
            $('#jquery_mask').hide();
            $('#search_vendor_result').html(data);
        });
    });

    $('body').on('keyup', '#search_vendor_keyword', function () {
        var keyword = $('#search_vendor_keyword').val();
        $('#jquery_mask').show();
        $.post(siteurl + "/Inventory/Purchase/search_vendor", {keyword: keyword}
        , function (data) {
            $('#jquery_mask').hide();
            $('#search_vendor_result').html(data);
        });
    });

    $('body').on('change', '#gvendor', function ()
    {
        var vendor_name = $(this).data('cmpny_name');
        var com_hid_id = $(this).attr('com_hid_id');
        $('#charge_vendor_company').val(com_hid_id);
        var com_hid_name = $(this).attr('com_hid_name');

        if (com_hid_id) {
            $('#charge_vendor').val(com_hid_name);
        } else {
            $('#charge_vendor').val(vendor_name);
        }
        var val = $(this).val();
        $('#charge_vendor_id').val(val);
        $('#VendorModal').modal('hide');
    });
    $('body').on('change', '#oc_pay_type', function ()
    {
        var mode = $('#oc_pay_type').val();
        if (mode == 'Cash') {
            $('#paid_thrgh').show();
//            $('#vendor_chose').hide();
            $('#chequepanel').hide();
            $('#depositto').show();
            $('#jquery_mask').show();
            $.post(siteurl + "/Accounts/Transaction/get_details_payment", {selected: mode}, function (data) {
                $('#jquery_mask').hide();
                var json_array = JSON.parse(data);
                var html_data = '';
                html_data += '<option value="">select</option>';
                for (var i = 0; i < json_array[0].length; i++)
                {
                    html_data += '<option value="' + json_array[0][i]['account_id'] + '">' + json_array[0][i]['account_name'] + '</option>';
                }
                $('#oc_paid_through').html(html_data);
            });
        } else if (mode == 'Card') {
            $('#paid_thrgh').show();
//            $('#vendor_chose').hide();
            $('#chequepanel').hide();
            $('#depositto').show();
            mode = 'Bank';
            $('#jquery_mask').show();
            $.post(siteurl + "/Accounts/Transaction/get_details_payment", {selected: mode}, function (data) {
                $('#jquery_mask').hide();
                var json_array = JSON.parse(data);
                var html_data = '';
                html_data += '<option value="">select</option>';
                for (var i = 0; i < json_array[0].length; i++)
                {
                    html_data += '<option  value="' + json_array[0][i]['account_id'] + '">' + json_array[0][i]['account_name'] + '</option>';
                }
                $('#oc_paid_through').html(html_data);
            });
        } else if (mode == 'Credit') {
            $('#paid_thrgh').hide();
            $('#vendor_chose').show();
        }
    });
    $('.equip_bill_div').on('keyup', '.qty,.pro_rate', function () {
        var table_cls = $(this).closest('table').attr('table_cls');
        var rowid = $(this).closest('tr').attr('id-cl');
        var sll = $('.' + table_cls + ' [id-cl=' + rowid + ']');
        calculate_row_amount(sll);
        product_subtotal_calculation();
        final_calculation();

    });
    $('.equip_bill_div').on('keyup', '.enterd_dis_amount', function (e) {
        var table_cls = $(this).closest('table').attr('table_cls');
        var rowid = $(this).closest('tr').attr('id-cl');
        var sll = $('.' + table_cls + ' [id-cl=' + rowid + ']');
        calculate_row_amount(sll);
        product_subtotal_calculation();
        final_calculation();
    });
    $('.equip_bill_div').on('keyup', '#discount', function (e) {
        var table_cls = $(this).closest('table').attr('table_cls');
        var rowid = $(this).closest('tr').attr('id-cl');
        var sll = $('.' + table_cls + ' [id-cl=' + rowid + ']');
        var discount_percentage = $(this).val();
        var pro_rate = sll.find('.pro_rate').val();
        var quan = sll.find('.qty').val();
        var pro_amount = pro_rate * quan;

        var percent = (parseFloat(discount_percentage) * pro_amount / parseFloat(100));
        if (isNaN(percent)) {
            var percent = 0;
        }
        sll.find('.enterd_dis_amount').val(parseFloat(percent).toFixed(2));
        calculate_row_amount(sll);
        product_subtotal_calculation();
        final_calculation();
    });

    ///// common percentage calculations//////////

    $('body').on('change', '#common_percentage', function () {
        var common_percentage = $(this).val();
        if (common_percentage == '') {
            common_percentage = 0;
        }

        var subtotal = 0;
        $('body').find('.pro_amount').each(function () {
            subtotal += parseFloat($(this).val());
        });
        var other = 0;
        $('.cld_charge').each(function () {
            var charge_paidby = $(this).find('.charge_paidby').val();
            if (charge_paidby == "vendor") {
                other += Number($(this).find('.charge_amount').val());
            }
        });
        subtotal += other;

        var pro_total = subtotal;
//        var pro_total = $('#total_amount_hidden').val();
        if (pro_total != 0) {
            var cda = (parseFloat(pro_total) * parseFloat(common_percentage) / 100);
            $('#common_percentage_amount').val(parseFloat(cda).toFixed(2));
            var total_amount_with_disc = parseFloat(pro_total) - parseFloat(cda);
//            $('#bill_subtotal_txt').val(parseFloat(total_amount_with_disc).toFixed(2));
            $('#bill_subtotal').val(parseFloat(total_amount_with_disc).toFixed(2));
            $('#bill_subtotal_txt').html(parseFloat(total_amount_with_disc).toFixed(2));
            var currency_rate = $('#currency_rate').val();
            var final_currency_amt = (total_amount_with_disc * currency_rate);
            var tr_currency = final_currency_amt.toFixed(2);
            $('#transaction_rate_value').html(tr_currency);
        } else {
            $(this).val(0);
            $('#common_percentage_amount').val(0);
            $('#bill_subtotal_txt').html(0);
            $('#bill_subtotal').val(0);
           $('#transaction_rate_value').html(0);
        }
    });

    $('body').on('change', '#common_percentage_amount', function () {
        var common_percentage_amount = $(this).val();
        if (common_percentage_amount == '') {
            common_percentage_amount = 0;
        }

        var subtotal = 0;
        $('body').find('.pro_amount').each(function () {
            subtotal += parseFloat($(this).val());
        });
        var other = 0;
        $('.cld_charge').each(function () {
            var charge_paidby = $(this).find('.charge_paidby').val();
            if (charge_paidby == "vendor") {
                other += Number($(this).find('.charge_amount').val());
            }
        });
        subtotal += other;

        var pro_total = subtotal;
//        var pro_total = $('#total_amount_hidden').val();
        console.log(pro_total)
        if (pro_total != 0) {
            var cdp = (parseFloat(common_percentage_amount) * 100) / parseFloat(pro_total);
            $('#common_percentage').val(parseFloat(cdp).toFixed(2));
            var total_amount_with_disc = parseFloat(pro_total) - parseFloat(common_percentage_amount);
            $('#bill_subtotal_txt').html(parseFloat(total_amount_with_disc).toFixed(2));
            $('#bill_subtotal').val(parseFloat(total_amount_with_disc).toFixed(2));
            var currency_rate = $('#currency_rate').val();
            var final_currency_amt = (total_amount_with_disc * currency_rate);
            var tr_currency = final_currency_amt.toFixed(2);
            $('#transaction_rate_value').html(tr_currency);
        } else {
            $(this).val(0);
            $('#common_percentage').val(0);
            $('#bill_subtotal_txt').html(0);
            $('#bill_subtotal').val(0);
           $('#transaction_rate_value').html(0);
        }
    });





});

function calculate_row_amount(sll) {
    var aa = sll.find('.qty');
    var bb = sll.find('.pro_rate');
    var cc = sll.find('.pro_amount');
    var ee = sll.find('.qty_billed');
    var gg = sll.find('.qty_mrv');
    var ff = sll.find('.dis');
    var z = sll.find('#discount_amount');
    var zk = sll.find('.enterd_dis_amount');
    if (aa.val()) {
        var quantity = aa.val();
    } else {
        var quantity = '';
    }
    if (bb.val()) {
        var rate = bb.val();

    } else {
        var rate = '';
    }
    if (ff.val()) {
        var discount = ff.val();
    } else {
        var discount = '';
    }
    if (ee.val()) {
        var quantity_billed = ee.val();
    } else {
        var quantity_billed = '';
    }
    if (gg.val()) {
        var quantity_mrv = gg.val();
    } else {
        var quantity_mrv = '';
    }
    if (zk.val()) {
        var discnt_amt = zk.val();
    } else {
        var discnt_amt = '';
    }
    var ffu = sll.find('.error');
    if (parseFloat(quantity) > ((parseFloat(quantity_mrv)) - (parseFloat(quantity_billed))))
    {
        ffu.show();
        aa.val('');
        cc.val('0');
    } else {
        ffu.hide();
        if (quantity != "" && rate != "")
        {

            var taxamnt = 0;
            var tot_amt = parseFloat(quantity) * parseFloat(rate);
            var percent = (parseFloat(discnt_amt) * 100 / parseFloat(tot_amt));
            if (isNaN(percent)) {
                var percent = 0;
            }
            sll.find('.dis').val(parseFloat(percent).toFixed(2));
            var amt = ((parseFloat(quantity) * parseFloat(rate)) - parseFloat(discnt_amt));
            var tax_enabled = $('#tax_enabled').val();
            if (tax_enabled != -1) {
                taxamnt = tax_calculation(sll, amt);
            }

            cc.val(parseFloat(amt + taxamnt).toFixed(2));
        } else {
            var tax_enabled = $('#tax_enabled').val();
            var amt = 0;
            if (tax_enabled != -1) {
                taxamnt = tax_calculation(sll, amt);
            }
        }
    }
}
function tax_calculation(sll, net) {
    var selected_array = [];
    var selected_pdtgrpid = sll.find('.selected_product_taxgrp').val();
    var totaltax_amount = 0;
    for (const [key, value] of Object.entries(tax_details)) {

        if (key == selected_pdtgrpid) {
            for (var ii = 0; ii < value.length; ii++) {
                selected_array.push(value[ii]['tax_masterid']);
                var taxrate = value[ii]['tax_rate'];
                var tax_amount = (parseFloat(taxrate) / 100) * parseFloat(net);
                totaltax_amount += tax_amount;
                sll.find('#tax_masterid_' + value[ii]['tax_masterid']).val(value[ii]['tax_rate'] + '% :\n' + tax_amount);
            }
            var finalnet_amount = parseFloat(net) + parseFloat(totaltax_amount);

        }
    }

    return totaltax_amount;
}
function final_calculation() {
    var pdttaxmasteramount = 0;
    $('.pdttaxmasteramount').each(function () {
        pdttaxmasteramount += parseFloat($(this).val());
    });
    var nettaxamount = parseFloat(pdttaxmasteramount);
    $('#ttltax_amount').val(nettaxamount);

    var subtotal = 0;
    $('body').find('.pro_amount').each(function () {
        subtotal += parseFloat($(this).val());
    });
    var other = 0;
    $('.cld_charge').each(function () {
        var charge_paidby = $(this).find('.charge_paidby').val();
        if (charge_paidby == "vendor") {
            other += Number($(this).find('.charge_amount').val());
        }
    });
    subtotal += other;

    var pro_total = subtotal;
    var cmm_dis=$('#common_percentage_amount').val();

    subtotal = Number(pro_total) - Number(cmm_dis);

    $('#bill_subtotal_txt').html(subtotal);
    $('#bill_subtotal').val(subtotal);
    var net_amount = $('#bill_subtotal_txt').text();
    var transaction_rate = $('#currency_rate').val();
    if (transaction_rate == 'undefined' && transaction_rate == '') {
        transaction_rate = 1;
    }
    if (net_amount != 'undefined' && net_amount != '') {
        var transaction_currency = parseFloat(net_amount) * parseFloat(transaction_rate);
        var tr_currency = transaction_currency.toFixed(2);
        $('#transaction_currency').val(tr_currency);
        $('#transaction_rate_value').html(tr_currency);
        var old_rate = $('#old_hidden').val();
        if (old_rate) {
            var po_amount = $('#old_hidden').val() * net_amount;
            var po = parseFloat(po_amount).toFixed(2);
            var tr = parseFloat(transaction_currency).toFixed(2);
            var gain_or_loss = parseFloat(po) - parseFloat(tr);
            var gain_loss = gain_or_loss.toFixed(2);
            $('.transaction_gain').html(gain_loss);
            $('#transaction_gain1').val(gain_loss);
        }
    }
}
function product_subtotal_calculation() {
    var tax_enabled = $('#tax_enabled').val();
    if (tax_enabled != -1) {
        for (var i = 0; i < alltax_details.length; i++) {
            var totaltaxmaster_amount = 0;
            $('.tax_details_' + alltax_details[i].tax_master_id).each(function () {
                var taxamount_i = 0;
                if ($(this).val() != '') {
                    var res = $(this).val().split(':');
                    if (res.length > 1) {
                        taxamount_i = Number(res[1]);
                    }
                }
                totaltaxmaster_amount += taxamount_i;
            });

            $('#totalpro_tax_' + alltax_details[i].tax_master_id).val(totaltaxmaster_amount);
        }
    }
    var pro_total = 0;
    var pro_dis_amt = 0;
    $('.amount').each(function () {
        if ($(this).val() != '') {
            pro_total += parseFloat($(this).val());
        }
    });
    $('.item_disc_amt').each(function () {
        if ($(this).val() != '') {
            pro_dis_amt += parseFloat($(this).val());
        }

    });
    var pdttaxmasteramount = 0;
    $('.pdttaxmasteramount').each(function () {
        pdttaxmasteramount += parseFloat($(this).val());
    });
    var nettaxamount = parseFloat(pdttaxmasteramount);
    console.log(nettaxamount)
    $('#ttltax_amount').val(nettaxamount);
    $('#ttltax_amount_txt').text(nettaxamount);
    $('#pro_total').val(pro_total);
    $('#pro_dis').val(pro_dis_amt);
}