if (typeof (vendor_json_list) == 'undefined') {
    var vendor_json_list = [];
}
$(document).ready(function () {
    $('body').on('click', '#vendor_details', function () {
        var vendor_id = $(this).attr('vendor_id');
        $('#jquery_mask').show();
        $.post(siteurl + "/Hr/Vendor/edit_vendor_details", {vendor_id: vendor_id}, function (data)
        {
            $('#jquery_mask').hide();
            $('#vendoreditModal .modal-body').html(data);
        });
    });
    $('body').on('change', '.country', function () {
        var country_id = $(this).val();
        $('#jquery_mask').show();
        $.post(siteurl + "/Hr/Vendor/get_states_by_country", {country_id: country_id}, function (data)
        {
            $('#jquery_mask').hide();
            $('#state').html(data);
        });
    });

    $('body').on('change', '#billingcountry', function ()
    {

        var countryid = $(this).val();
        $('#jquery_mask').show();
        $.post(siteurl + "/Common/Picklocation/get_states_by_country", {countryid: countryid}
        , function (data) {
            $('#jquery_mask').hide();
            $('#billingstate').html(data);

        });
    });
    $('body').on('change', '#billingstate', function ()
    {
        var stateid = $(this).val();
        $('#jquery_mask').show();
        $.post(siteurl + "/Common/Picklocation/get_city_by_state", {stateid: stateid}
        , function (data) {
            $('#jquery_mask').hide();
            $('#billingcity').html(data);
        });
    });

    $('body').on('change', '#shippingcountry', function ()
    {
        var countryid = $(this).val();
        $('#jquery_mask').show();
        $.post(siteurl + "/Hr/Vendor/get_state_by_country_id", {countryid: countryid}
        , function (data) {
            $('#jquery_mask').hide();
            $('#shippingstate').html(data);
        });
    });

    $('body').on('click', '#shippingstate', function ()
    {
        var stateid = $(this).val();
        $('#jquery_mask').show();
        $.post(siteurl + "/Hr/Vendor/get_city_by_state", {stateid: stateid}
        , function (data) {
            $('#jquery_mask').hide();
            $('#shippingcity').html(data);
        });
    });

    $('body').on('click', '#gcmpny', function () {
        if ($(this).prop('checked', true))
        {
            var company = $(this).val();//$('input[name=company]:checked').val();
            $('#showallcompanies').modal('hide');
            $('#jquery_mask').show();
            $.post(siteurl + "/Hr/Vendor/get_account_details_by_id", {company: company}, function (data) {
                $('#jquery_mask').hide();
                if(company!=0){
                var result = JSON.parse(data);
                $('#company_name').val(result[0].companyname).prop("readonly", true);
                ;
                $('#company_id').val(result[0].company_id);
                $('#company_phone').val(result[0].phone).prop("readonly", true);
                ;
                $('#company_fax').val(result[0].fax).prop("readonly", true);
                ;
                $('#company_email').val(result[0].email).prop("readonly", true);
                ;
                $('#company_website').val(result[0].website).prop("readonly", true);
                ;
                $('#billingaddressline1').val(result[0].billingaddress1).prop("readonly", true);
                ;
                $('#billingaddressline2').val(result[0].billingaddress2).prop("readonly", true);
                ;
                var country_id = result[0].country_id;
                $('#jquery_mask').show();
                $.post(siteurl + '/Hr/Vendor/get_state_by_country_id', {countryid: country_id}, function (data) {
                    $('#jquery_mask').hide();
                    $('#billingstate').html(data);
                    $('#billingstate').val(result[0].state_id).prop("disabled", true);
                    ;
                });
                var stateid = result[0].state_id;
                $('#jquery_mask').show();
                $.post(siteurl + '/Hr/Vendor/get_city_by_state', {stateid: stateid}, function (data) {
                    $('#jquery_mask').hide();
                    $('#billingcity').html(data);
                    $('#billingcity').val(result[0].city_id).prop("disabled", true);
                    ;
                });
                $('#billingcountry').val(result[0].country_id).prop("disabled", true);
                ;
                $('#billingpincode').val(result[0].zipcode).prop("readonly", true);
                ;
                $('#shippingaddressline1').val(result[1].shippingaddress1).prop("readonly", true);
                ;
                $('#shippingaddressline2').val(result[1].shippingaddress1).prop("readonly", true);
                ;
                $('#shippingcountry').val(result[1].country_id).prop("readonly", true);
                ;
                var country_id_ship = result[1].country_id;
                $('#jquery_mask').show();
                $.post(siteurl + '/Hr/Vendor/get_state_by_country_id', {countryid: country_id_ship}, function (data) {
                    $('#jquery_mask').hide();
                    $('#shippingstate').html(data);
                    $('#shippingstate').val(result[0].state_id).prop("readonly", true);
                    ;
                });
                var stateid_ship = result[0].state_id;
                $('#jquery_mask').show();
                $.post(siteurl + '/Hr/Vendor/get_city_by_state', {stateid: stateid_ship}, function (data) {
                    $('#jquery_mask').hide();
                    $('#shippingcity').html(data);
                    $('#shippingcity').val(result[0].city_id).prop("readonly", true);
                    ;
                });
                $('#shippingpincode').val(result[1].shippingipcode).prop("readonly", true);
                ;
               
                }else{
                   $('#company_name').val('Others');     
                   $('#company_id').val(0);     
                }
            });
            $('#CmpnyModal').modal('hide');
            $('#clear_comp').show();
            $('#companyy').hide();

        }
    });
    $('#con2').hide();
    $('#states1').hide();
    $('#city1').hide();
    $("body").on("click", '#clear_comp', function (e) {
        $('#clear_comp').hide();
        $('#companyy').show();
        $('#company_name').val('').prop("readonly", false);
        $('#company_id').val('');
        $('#company_phone').val('').prop("readonly", false);
        $('#company_fax').val('').prop("readonly", false);
        $('#company_email').val('').prop("readonly", false);
        $('#company_website').val('').prop("readonly", false);
        $('#billingaddressline1').val('').prop("readonly", false);
        $('#billingaddressline2').val('').prop("readonly", false);
        $('#billingstate').html('');
        $('#billingstate').val('0').prop("disabled", false);
        $('#billingcity').html('');
        $('#billingcity').val('').prop("disabled", false);
        $('#billingcountry').val('0').prop("disabled", false);
        $('#billingpincode').val('').prop("readonly", false);
        $('#shippingaddressline1').val('').prop("readonly", false);
        $('#shippingaddressline2').val('').prop("readonly", false);
        $('#shippingcountry').val('0').prop("readonly", false);
        $('#shippingstate').html('');
        $('#shippingstate').val('').prop("readonly", false);
        $('#shippingcity').html('');
        $('#shippingcity').val('').prop("readonly", false);
        $('#con').hide();
        $('#con2').show();
        $('#states').hide();
        $('#states1').show();
        $('#citys').hide();
        $('#city1').show();
    });
    $('body').on('click', '#deletevendor', function () {
        var vendor_id = $(this).attr('vendor_id');
        var s = $(this).closest('tr');
        swal({
            title: "Are you sure?",
            text: "You are going to delete this Vendor",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes, delete !",
            cancelButtonText: "No, don't delete !",
            closeOnConfirm: false,
            closeOnCancel: false
        },
                function (isConfirm) {
                    if (isConfirm) {
                        $('#jquery_mask').show();
                        $.ajax({
                            url: siteurl + '/Hr/Vendor/delete_vendor',
                            data: {vendor_id: vendor_id},
                            cache: false,
                            datatype: "json",
                            type: "post",
                            success: function (d) {
                                $('#jquery_mask').hide();
                                $(s).remove();
                                swal("Deleted!", "Vendor has been deleted.", "success");
                                location.reload();
                            },
                            fail: function (d) {
                                $('#jquery_mask').hide();
                                swal("Cannot delete!", "Vendor cannot be deleted.", "error");
                            }
                        });
                    } else {
                        swal("Cancelled", "Leave Type is not deleted ", "error");
                    }
                });
        return false;
    });

    $('body').on('keyup', '#search_company_keyword', function () {
        var keyword = $('#search_company_keyword').val();
        $('#jquery_mask').show();
        $.post(siteurl + "/Hr/Vendor/search_company", {keyword: keyword}
        , function (data) {
            $('#jquery_mask').hide();
            $('#search_result').html(data);
        });
    });
    $('body').on('click', '#companyy', function () {
        var keyword = '';
        $('#jquery_mask').show();
        $.post(siteurl + "/Hr/Vendor/search_company", {keyword: keyword}
        , function (data) {
            $('#jquery_mask').hide();
            $('#search_result').html(data);
        });
    });

    $('body').on('click', '#copy_billto_shipp', function () {
        $('#shippingaddressline1').val($('#billingaddressline1').val());
        $('#shippingaddressline2').val($('#billingaddressline2').val());
        $('#shippingcountry').val($('#billingcountry').val());

        $('#shippingpincode').val($('#billingpincode').val());

        var countryid = $('#billingcountry').val();
        var bill_state = $('#billingstate').val();
        if (countryid != "" && countryid != 0) {
            $('#jquery_mask').show();
            $.post(siteurl + "/Inventory/Quote/get_states_by_country", {countryid: countryid}
            , function (data) {
                $('#jquery_mask').hide();
                $('#shippingstate').html(data);
                $('#shippingstate').val(bill_state);
            });
        }

        var stateid = $('#billingstate').val();
        var bill_city = $('#billingcity').val();
        if (stateid != "" && stateid != 0) {
            $('#jquery_mask').show();
            $.post(siteurl + "/Inventory/Quote/get_city_by_state_id", {state_id: stateid}
            , function (data) {
                $('#jquery_mask').hide();
                $('#shippingcity').html(data);
                $('#shippingcity').val(bill_city);
            });
        }
    });

    $('body').on('click', '#copy_shippto_bill', function () {
        $('#billingaddressline1').val($('#shippingaddressline1').val());
        $('#billingaddressline2').val($('#shippingaddressline2').val());
        $('#billingcountry').val($('#shippingcountry').val());
        $('#billingpincode').val($('#shippingpincode').val());

        var countryid = $('#shippingcountry').val();
        var shipp_state = $('#shippingstate').val();
        if (countryid != "" && countryid != 0) {
            $('#jquery_mask').show();
            $.post(siteurl + "/Inventory/Quote/get_states_by_country", {countryid: countryid}
            , function (data) {
                $('#jquery_mask').hide();
                $('#billingstate').html(data);
                $('#billingstate').val(shipp_state);
            });
        }

        var stateid = $('#shippingstate').val();
        var shipp_city = $('#shippingcity').val();
        if (stateid != "" && stateid != 0) {
            $('#jquery_mask').show();
            $.post(siteurl + "/Inventory/Quote/get_city_by_state_id", {state_id: stateid}
            , function (data) {
                $('#jquery_mask').hide();
                $('#billingcity').html(data);
                $('#billingcity').val(shipp_city);
            });
        }

    });

    $('#vendor_import').on('click', function () {

        var file = document.getElementById('import_file').files[0];
        var fileName = $("#import_file").val();
        if (fileName) {
            var reader = new FileReader();
            reader.onload = function (progressEvent) {
                var lines = this.result.split('\n');
                if (lines.length > 0) {
                    var line = 0;
                    readFile(line, lines);
                }
            };
            reader.readAsText(file);
        } else {
            swal('Error!', 'Pleade chose file');
        }
    });
// bank details edit
    $('body').on('click', '#editbank_vendor', function () {

        var bank_id = $(this).attr('bank_id');
        $('#jquery_mask').show();
        $.post(siteurl + "/Hr/Vendor/get_bank_details_by_id", {bank_id: bank_id}, function (data)
        {
            $('#jquery_mask').hide();
            var result = JSON.parse(data);
            console.log(result);
            $('#editbankdetails_vendor #bank_name').val(result.bank_name);
            $('#editbankdetails_vendor #account_number').val(result.account_number);
            $('#editbankdetails_vendor #ifsc_code').val(result.ifsc_code);
            $('#editbankdetails_vendor #bank_code').val(result.bank_code);
            $('#editbankdetails_vendor #bank_id').val(result.bank_id);
        });
    });
    //bank details delete
    $('body').on('click', '#bankdetails_delete_vendor', function () {
        var bank_id = $(this).attr('bank_id');
        var nearest = $(this).closest('tr');
        var s = $(this).closest('tr');
        swal({
            title: "Are you sure?",
            text: "You are going to delete this Bank",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes, delete !",
            cancelButtonText: "No, don't delete !",
            closeOnConfirm: false,
            closeOnCancel: false
        },
                function (isConfirm) {
                    if (isConfirm) {
                        $.ajax({
                            url: siteurl + '/Hr/Vendor/delete_bank',
                            data: {bank_id: bank_id},
                            cache: false,
                            datatype: "json",
                            type: "post",
                            success: function (d) {
                                $(s).remove();
                                //$(this).closest('.list-group').remove();
                                swal("Deleted!", "Bank has been deleted.", "success");
                            },
                            fail: function (d) {
                                swal("Cannot delete!", "Bank cannot be deleted.", "error");
                            }
                        });
                    } else {
                        swal("Cancelled", "Bank is not deleted ", "error");
                    }
                });
        return false;
    });


    $('body').on('click', '#block_vendor', function () {

        var vendor_id = $(this).attr('vendor_id');
        var company_id = $(this).attr('company_id');

        swal({
            title: "Are you sure?",
            text: "You are going to Block this Vendor",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes, block !",
            cancelButtonText: "No, don't block !",
            closeOnConfirm: false,
            closeOnCancel: false
        },
                function (isConfirm) {
                    if (isConfirm) {
                        $.ajax({
                            url: siteurl + "/Hr/Vendor/block_vendor",
                            data: {vendor_id: vendor_id, company_id: company_id},
                            cache: false,
                            datatype: "json",
                            type: "post",
                            success: function (d) {
                                swal("Blocked!", "Vendor has been blocked.", "success");
                                location.reload();
                            },
                            fail: function (d) {
                                swal("Cannot Block!", "Vendor cannot be blocked.", "error");
                            }
                        });
                    } else {
                        swal("Cancelled", "Vendor is not blocked ", "error");
                    }
                });
        return false;
    });

    $('body').on('click', '#unblock_vendor', function () {

        var vendor_id = $(this).attr('vendor_id');
        var company_id = $(this).attr('company_id');
        swal({
            title: "Are you sure?",
            text: "You are going to Unblock this Vendor",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes, Unblock !",
            cancelButtonText: "No, don't Unblock !",
            closeOnConfirm: false,
            closeOnCancel: false
        },
                function (isConfirm) {
                    if (isConfirm) {
                        $.ajax({
                            url: siteurl + "/Hr/Vendor/unblock_vendor",
                            data: {vendor_id: vendor_id, company_id: company_id},
                            cache: false,
                            datatype: "json",
                            type: "post",
                            success: function (d) {
//                                $(s).remove();
                                //$(this).closest('.list-group').remove();
                                swal("Unblocked!", "Vendor has been unblocked.", "success");
                                location.reload();
                            },
                            fail: function (d) {
                                swal("Cannot Unblock!", "Vendor cannot be unblocked.", "error");
                            }
                        });
                    } else {
                        swal("Cancelled", "Vendor is not unblocked ", "error");
                    }
                });
        return false;
    });

//////for payment methods////////////
   $('.payment').on('click', function () {
        if ($(this).closest('.payments_div').find('#credit').is(':checked') || $(this).closest('.payments_div').find('#cheque').is(':checked')) {
            $('#payment_day').show();
            $('#cer').show();
            $('.show_div').show();
            $('#mthend').show();
        } else {
            $('#payment_day').hide();
            $('#cer').hide();
            $('.show_div').hide();
            $('#mthend').hide();
        }
    });
    var selectvalue = $('#payment').find('option:selected').val();
    if (selectvalue == 'credit') {
        $('#payment_day').show();
        $('#cer').show();
         $('#mthend').show();
    } else {
        $('#payment_day').hide();
        $('#cer').hide();
        $('#mthend').hide();
    }
    
    
    
    
     $('.payment_edit').on('click', function () {
        var selectvalue = $(this).find('option:selected').val();
        if ($(this).closest('.payments_div').find('#credit').is(':checked') || $(this).closest('.payments_div').find('#cheque').is(':checked')) {
            $('#payment_day_edit').show();
            $('#credit_limit_edit').show();
            $('#mthend').show();
        } else if ($(this).closest('.payments_div').find('#cash').is(':checked')) {
            $('#payment_day_edit').hide();
            $('#credit_limit_edit').hide();
            $('#mthend').hide();
        } else {
            $('#payment_day_edit').hide();
            $('#credit_limit_edit').hide();
            $('#mthend').hide();
        }
    });
    var selectvalue = $('#payment_edit').find('option:selected').val();
    if ($('#credit').is(':checked') || $('#cheque').is(':checked')) {
        $('#payment_day_edit').show();
        $('#credit_limit_edit').show();
        $('#mthend').show();
    } else {
        $('#payment_day_edit').hide();
        $('#credit_limit_edit').hide();
        $('#mthend').hide();
    }
    
    
    


    $('#search_product_keyword').on('keyup', function () {

        var searchkeyword = $(this).val();
        var option = '';
        var count = 1;
        for (var i = 0; i < vendor_json_list.length; i++) {

            if (vendor_json_list[i]['first_name'].toLowerCase().indexOf(searchkeyword.toLowerCase()) != -1) {
                option += '<tr class="sec_grid">'
                option += '<td>' + count + '</td>'
                if(vendor_json_list[i]['companyname']!=null){
                   option += '<td>' + vendor_json_list[i]['companyname'] + '</td>' 
                }else{
                    option += '<td></td>' 
                }
                option += '<td>' + vendor_json_list[i]['first_name'] + vendor_json_list[i]['last_name'] + '</td>'
                option += '<td>' + vendor_json_list[i]['email'] + '</td>'
                option += '<td>' + vendor_json_list[i]['mobile'] + '</td> '
                if(vendor_json_list[i]['country_name'] !=null){
                    option += '<td>' + vendor_json_list[i]['country_name'] + '</td>'
                }else{
                    option += '<td></td>' 
                }
                option += '<td>'
                option += '<div class="inline-block dropdown">'
                option += '<a class="dropdown-toggle" data-toggle="dropdown" href="#" aria-expanded="false" role="button"><i class="icon lindo-android-more-vertical act-gray fz-22"></i></a>'
                option += '<ul class="dropdown-menu bullet dropdown-menu-right"  role="menu">'
                option += '<li class="b-b-g url_navigator" resource="Hr/Vendor/view_vendor_details"><a href="' + siteurl + '/Hr/Vendor/view_vendor_details/' + vendor_json_list[i]['vendor_id'] + '"  vendor_id="' + vendor_json_list[i]['vendor_id'] + '"  id="vendor_details111" data-toggle="modal"><i class="icon lindo-android-apps mr-10 fz-22 vam txt-success"></i>View</a></li>'
                option += '<li class="b-b-g url_navigator" resource="Hr/Vendor/edit_vendor_details"><a href="' + siteurl + '/Hr/Vendor/edit_vendor_details/' + vendor_json_list[i]['vendor_id'] + '"  vendor_id="' + vendor_json_list[i]['vendor_id'] + '" id="vendor_details" role="menuitem"><i class="icon lindo-page-edit mr-10 fz-22 vam txt-primary"></i>Edit</a></li>'
                option += '<li class="url_navigator" resource="Hr/Vendor/delete_vendor"><a href="#" vendor_id="' + vendor_json_list[i]['vendor_id'] + '" id="deletevendor" role=""  ><i class="icon lindo-delete-trash-1 mr-10 fz-22 vam txt-danger"></i>Delete</a></li>'
                if (vendor_json_list[i]['blocked'] == 0) {
                    option += '<li class="url_navigators" resource="Hr/Vendor/block_vendor"><a href="#" id="block_vendor" vendor_id="' + vendor_json_list[i]['vendor_id'] + '" company_id="' + vendor_json_list[i]['company_id'] + '" role="menuitem"><i class="" ></i>Block</a></li>'
                } else {
                    option += '<li class="url_navigators" resource="Hr/Vendor/unblock_vendor"><a href="#" id="unblock_vendor"  vendor_id="' + vendor_json_list[i]['vendor_id'] + '" company_id=""' + vendor_json_list[i]['company_id'] + '"" role="menuitem"><i class="" ></i>Unblock</a></li>'
                }
                option += '</ul>'
                option += '</div>'
                option += '</td>'
                option += '</tr>'
                option += '</tr>'


            }
            count++;
        }
//        $(".search_result").empty();
        $('#search_result').html(option);
    });
    $('body').on('click', '.leftarrow', function () {
        var ps = $('.pagediv').find('li.active').attr('pageno');
        if (ps !== 0)
        {
            ps = ps - 1;
            $('li[pageno="' + ps + '"]').trigger('click');
        }
    });
    $('body').on('click', '.rightarrow', function () {

        var ps = $('.pagediv').find('li.active').attr('pageno');
        if (ps < no_of_page)
        {
            ps = Number(ps) + 1;
            $('li[pageno="' + ps + '"]').trigger('click');
        }

    });

    $('body').on('click', '.rightdot', function () {
        var div_name = $(this).attr('divname');
        var ac = parseInt(div_name - 10);
        var ps = $('.pagenatio').find('.sectiondiv' + div_name + '').removeClass('no-display');
        var sc = $('.pagenatio').find('.sectiondiv' + ac + '').addClass('no-display');


    });
    $('body').on('click', '.leftdot', function () {
        var div_name = $(this).attr('divname');
        var ac = parseInt(div_name - 10);
        var ps = $('.pagenatio').find('.sectiondiv' + div_name + '').removeClass('no-display');
        var sc = $('.pagenatio').find('.sectiondiv' + ac + '').addClass('no-display');


    });
    $('body').on('click', '.pagenumber', function () {

        $('.pagediv').find('li.active').removeClass('active');
        $(this).addClass('active');
        var pagenumber = $(this).attr('pageno');
        var vendor_start_count = (Number(pagenumber) * 20 + 1);
        var count = vendor_start_count;
        var option = '';
        for (var i = vendor_start_count; i < Number(vendor_start_count) + 20; i++) {
            option += '<tr class="sec_grid">'
            option += '<td class="w5 pa-10 text-center">' + count + '</td>'
            option += '<td class="w25 pa-10">' + vendor_json_list[i]['companyname'] + '</td>'
            option += '<td class="w25 pa-10">' + vendor_json_list[i]['first_name'] + vendor_json_list[i]['last_name'] + '</td>'
            option += '<td class="w15 pa-10">' + vendor_json_list[i]['email'] + '</td>'
            option += '<td class="w15 pa-10">' + vendor_json_list[i]['mobile'] + '</td> '
            option += '<td class="w10 pa-10">' + vendor_json_list[i]['country_name'] + '</td>'
            option += '<td class="w5 text-center">'
            option += '<div class="inline-block dropdown">'
            option += '<a class="dropdown-toggle" data-toggle="dropdown" href="#" aria-expanded="false" role="button"><i class="icon lindo-android-more-vertical act-gray fz-22"></i></a>'
            option += '<ul class="dropdown-menu bullet dropdown-menu-right"  role="menu">'
            option += '<li class="b-b-g url_navigator" resource="Hr/Vendor/view_vendor_details"><a href="' + siteurl + '/Hr/Vendor/view_vendor_details/' + vendor_json_list[i]['vendor_id'] + '"  vendor_id="' + vendor_json_list[i]['vendor_id'] + '"  id="vendor_details111" data-toggle="modal"><i class="icon lindo-android-apps mr-10 fz-22 vam txt-success"></i>View</a></li>'
            option += '<li class="b-b-g url_navigator" resource="Hr/Vendor/edit_vendor_details"><a href="' + siteurl + '/Hr/Vendor/edit_vendor_details/' + vendor_json_list[i]['vendor_id'] + '"  vendor_id="' + vendor_json_list[i]['vendor_id'] + '" id="vendor_details" role="menuitem"><i class="icon lindo-page-edit mr-10 fz-22 vam txt-primary"></i>Edit</a></li>'
            option += '<li class="url_navigator" resource="Hr/Vendor/delete_vendor"><a href="#" vendor_id="' + vendor_json_list[i]['vendor_id'] + '" id="deletevendor" role=""  ><i class="icon lindo-delete-trash-1 mr-10 fz-22 vam txt-danger"></i>Delete</a></li>'
            if (vendor_json_list[i]['blocked'] == 0) {
                option += '<li class="url_navigators" resource="Hr/Vendor/block_vendor"><a href="#" id="block_vendor" vendor_id="' + vendor_json_list[i]['vendor_id'] + '" company_id="' + vendor_json_list[i]['company_id'] + '" role="menuitem"><i class="" ></i>Block</a></li>'
            } else {
                option += '<li class="url_navigators" resource="Hr/Vendor/unblock_vendor"><a href="#" id="unblock_vendor"  vendor_id="' + vendor_json_list[i]['vendor_id'] + '" company_id=""' + vendor_json_list[i]['company_id'] + '"" role="menuitem"><i class="" ></i>Unblock</a></li>'
            }
            option += '</ul>'
            option += '</div>'
            option += '</td>'
            option += '</tr>'
            option += '</tr>'
            count++;
        }
//        $(".search_result").empty();
        $('#search_result').html(option);

    });
    var page_row_count = 0;
    $('body').on('click', '.pagenationbtn', function () {

        var rowlimit = $(this).attr('limit');
        var pagenum = $(this).attr('page');
        var activr_page_num = $('.pagination_div .active ').attr('page');

        var pagination_count = parseInt(page_row_count / rowlimit);
        var pagenumber = pagenum;
        if (pagination_count > 0) {
            if (page_row_count % rowlimit > 0) {
                pagination_count++;
            }
        }
        if (activr_page_num != pagenum) {
            if (pagenum == 'first') {
                if (activr_page_num != 1) {
                    pagenumber = 1;
                    $('.pagenationbtn').removeClass('active');
                    $('.pagenationbtn[page="1"]').addClass('active');
                    createpagenation(rowlimit, pagenumber, pagination_count);
                    page_display(pagenumber);
                }
            } else if (pagenum == 'prev') {
                if (activr_page_num != 1) {
                    pagenumber = activr_page_num - 1;
                    $('.pagenationbtn').removeClass('active');
                    $('.pagenationbtn[page="' + (activr_page_num - 1) + '"]').addClass('active');
                    createpagenation(rowlimit, pagenumber, pagination_count);
                    page_display(pagenumber);
                }
            } else if (pagenum == 'last') {
                if (activr_page_num != pagination_count) {
                    pagenumber = pagination_count;
                    $('.pagenationbtn').removeClass('active');
                    $('.pagenationbtn[page="' + pagination_count + '"]').addClass('active');
                    createpagenation(rowlimit, pagenumber, pagination_count);
                    page_display(pagenumber);
                }
            } else if (pagenum == 'next') {

                if (activr_page_num != pagination_count) {
                    pagenumber = parseInt(activr_page_num) + 1;
                    $('.pagenationbtn').removeClass('active');
                    $('.pagenationbtn[page="' + (parseInt(activr_page_num) + 1) + '"]').addClass('active');
                    createpagenation(rowlimit, pagenumber, pagination_count);
                    page_display(pagenumber);
                }
            } else {
                if (activr_page_num != pagenum) {
                    $('.pagenationbtn').removeClass('active');
                    $(this).addClass('active');
                    createpagenation(rowlimit, pagenumber, pagination_count);
                    page_display(pagenumber);
                }
            }
        }
    });
    var mod = Number(vendor_json_list.length) % Number(20);
    page_row_count = vendor_json_list.length;
    var no_of_page = parseInt(vendor_json_list.length / 20);
    var row_limit = 20;
    if (mod != 0)
    {
        no_of_page += 1;
    }
    createpagenation(row_limit, 1, no_of_page);



});

function createpagenation(rowlimit, pagenum, pagination_count) {
    if(pagination_count==0 || pagination_count ==1){
    }else{
    var nav_list = '<div class="buttons-row width100 pagination_div ">';

    if (pagination_count <= 6) {
        nav_list += '    <a href="#" page="first" limit="' + rowlimit + '" class="button pagenationbtn "><<</a>';
        nav_list += '    <a href="#" page="prev" limit="' + rowlimit + '" class="button pagenationbtn"><</a>';
        for (var i = 1; i <= pagination_count; i++) {
            nav_list += '    <a href="#" page="' + i + '" limit="' + rowlimit + '" class="button pagenationbtn ' + ((pagenum == i) ? 'active' : '') + '">' + i + '</a>';
        }
        nav_list += '    <a href="#" page="next" limit="' + rowlimit + '" class="button pagenationbtn">></a>';
        nav_list += '    <a href="#" page="last" limit="' + rowlimit + '" class="button pagenationbtn">>></a>';
    } else if (pagenum == pagination_count) {
        var num1 = pagenum - 4, num2 = pagenum - 3, num3 = pagenum - 2, num4 = pagenum - 1, num5 = pagenum;
        nav_list += '    <a href="#" page="first" limit="' + rowlimit + '" class="button pagenationbtn ">&#60;&#60;</a>';
        nav_list += '    <a href="#" page="prev" limit="' + rowlimit + '" class="button pagenationbtn">&#60;</a>';
        nav_list += '    <a href="#" page="1" limit="' + rowlimit + '" class="button border-none">...</a>';
        nav_list += '    <a href="#" page="' + num1 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num1 + '</a>';
        nav_list += '    <a href="#" page="' + num2 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num2 + '</a>';
        nav_list += '    <a href="#" page="' + num3 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num3 + '</a>';
        nav_list += '    <a href="#" page="' + num4 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num4 + '</a>';
        nav_list += '    <a href="#" page="' + num5 + '" limit="' + rowlimit + '" class="button pagenationbtn active">' + num5 + '</a>';
        nav_list += '    <a href="#" page="next" limit="' + rowlimit + '" class="button pagenationbtn">&#62;</a>';
        nav_list += '    <a href="#" page="last" limit="' + rowlimit + '" class="button pagenationbtn">&#62;&#62;</a>';
    } else if (pagenum == 1) {
        var num1 = pagenum, num2 = parseInt(pagenum) + 1, num3 = parseInt(pagenum) + 2, num4 = parseInt(pagenum) + 3, num5 = parseInt(pagenum) + 4;
        nav_list += '    <a href="#" page="first" limit="' + rowlimit + '" class="button pagenationbtn">&#60;&#60;</a>';
        nav_list += '    <a href="#" page="prev" limit="' + rowlimit + '" class="button pagenationbtn">&#60;</a>';
        nav_list += '    <a href="#" page="' + num1 + '" limit="' + rowlimit + '" class="button pagenationbtn active">' + num1 + '</a>';
        nav_list += '    <a href="#" page="' + num2 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num2 + '</a>';
        nav_list += '    <a href="#" page="' + num3 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num3 + '</a>';
        nav_list += '    <a href="#" page="' + num4 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num4 + '</a>';
        nav_list += '    <a href="#" page="' + num5 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num5 + '</a>';
        nav_list += '    <a href="#" page="1" limit="' + rowlimit + '" class="button border-none">...</a>';
        nav_list += '    <a href="#" page="next" limit="' + rowlimit + '" class="button pagenationbtn">&#62;</a>';
        nav_list += '    <a href="#" page="last" limit="' + rowlimit + '" class="button pagenationbtn">&#62;&#62;</a>';
    } else if (pagenum <= 4) {
        nav_list += '    <a href="#" page="first" limit="' + rowlimit + '" class="button pagenationbtn">&#60;&#60;</a>';
        nav_list += '    <a href="#" page="prev" limit="' + rowlimit + '" class="button pagenationbtn">&#60;</a>';
        nav_list += '    <a href="#" page="1" limit="' + rowlimit + '" class="button pagenationbtn">1</a>';
        nav_list += '    <a href="#" page="2" limit="' + rowlimit + '" class="button pagenationbtn';
        if (pagenum == 2)
            nav_list += ' active">2</a>';
        else
            nav_list += '">2</a>';
        nav_list += '    <a href="#" page="3" limit="' + rowlimit + '" class="button pagenationbtn';
        if (pagenum == 3)
            nav_list += ' active">3</a>';
        else
            nav_list += '">3</a>';
        nav_list += '    <a href="#" page="4" limit="' + rowlimit + '" class="button pagenationbtn';
        if (pagenum == 4)
            nav_list += ' active">4</a>';
        else
            nav_list += '">4</a>';
        nav_list += '    <a href="#" page="5" limit="' + rowlimit + '" class="button pagenationbtn">5</a>';
        nav_list += '    <a href="#" page="1" limit="' + rowlimit + '" class="button border-none">...</a>';
        nav_list += '    <a href="#" page="next" limit="' + rowlimit + '" class="button pagenationbtn">&#62;</a>';
        nav_list += '    <a href="#" page="last" limit="' + rowlimit + '" class="button pagenationbtn">&#62;&#62;</a>';
    } else if (pagenum > (pagination_count - 4)) {
        var num1 = pagination_count - 4, num2 = pagination_count - 3, num3 = pagination_count - 2, num4 = pagination_count - 1, num5 = pagination_count;
        nav_list += '    <a href="#" page="first" limit="' + rowlimit + '" class="button pagenationbtn">&#60;&#60;</a>';
        nav_list += '    <a href="#" page="prev" limit="' + rowlimit + '" class="button pagenationbtn">&#60;</a>';
        nav_list += '    <a href="#" page="1" limit="' + rowlimit + '" class="button border-none">...</a>';
        nav_list += '    <a href="#" page="' + num1 + '" limit="' + rowlimit + '" class="button pagenationbtn';
        if (pagenum == num1)
            nav_list += ' active">' + num1 + '</a>';
        else
            nav_list += '">' + num1 + '</a>';
        nav_list += '    <a href="#" page="' + num2 + '" limit="' + rowlimit + '" class="button pagenationbtn';
        if (pagenum == num2)
            nav_list += ' active">' + num2 + '</a>';
        else
            nav_list += '">' + num2 + '</a>';
        nav_list += '    <a href="#" page="' + num3 + '" limit="' + rowlimit + '" class="button pagenationbtn';
        if (pagenum == num3)
            nav_list += ' active">' + num3 + '</a>';
        else
            nav_list += '">' + num3 + '</a>';
        nav_list += '    <a href="#" page="' + num4 + '" limit="' + rowlimit + '" class="button pagenationbtn';
        if (pagenum == num4)
            nav_list += ' active">' + num4 + '</a>';
        else
            nav_list += '">' + num4 + '</a>';
        nav_list += '    <a href="#" page="' + num5 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num5 + '</a>';
        nav_list += '    <a href="#" page="next" limit="' + rowlimit + '" class="button pagenationbtn">&#62;</a>';
        nav_list += '    <a href="#" page="last" limit="' + rowlimit + '" class="button pagenationbtn">&#62;&#62;</a>';
    } else if ((pagenum > 4) && (pagination_count > (parseInt(pagenum) + 2))) {
        var num1 = pagenum - 2, num2 = pagenum - 1, num3 = pagenum, num4 = parseInt(pagenum) + 1;
        nav_list += '    <a href="#" page="first" limit="' + rowlimit + '" class="button pagenationbtn">&#60;&#60;</a>';
        nav_list += '    <a href="#" page="prev" limit="' + rowlimit + '" class="button pagenationbtn">&#60;</a>';
        nav_list += '    <a href="#" page="1" limit="' + rowlimit + '" class="button border-none">...</a>';
        nav_list += '    <a href="#" page="' + num1 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num1 + '</a>';
        nav_list += '    <a href="#" page="' + num2 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num2 + '</a>';
        nav_list += '    <a href="#" page="' + num3 + '" limit="' + rowlimit + '" class="button pagenationbtn active">' + num3 + '</a>';
        nav_list += '    <a href="#" page="' + num4 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num4 + '</a>';
        nav_list += '    <a href="#" page="6" limit="' + rowlimit + '" class="button border-none">...</a>';
        nav_list += '    <a href="#" page="next" limit="' + rowlimit + '" class="button pagenationbtn">&#62;</a>';
        nav_list += '    <a href="#" page="last" limit="' + rowlimit + '" class="button pagenationbtn">&#62;&#62;</a>';
    }
    nav_list += '</div>';
    $('.pagenatio').html(nav_list);
}
}


function page_display(pagenumber) {

//        $('.pagediv').find('li.active').removeClass('active');
//        $(this).addClass('active');
//        var pagenumber = $(this).attr('pageno');
    var vendor_start_count = (Number(pagenumber - 1) * 20 + 1);
    var count = vendor_start_count;
    var option = '';
    for (var i = vendor_start_count; i < Number(vendor_start_count) + 20; i++) {
        if (vendor_json_list[i] == undefined)
        {
            break;
        } else {
            option += '<tr class="sec_grid">'
            option += '<td class="w5 pa-10 text-center">' + count + '</td>'
            if(vendor_json_list[i]['companyname'] !=null){
                option += '<td class="w25 pa-10">' + vendor_json_list[i]['companyname'] + '</td>'
            }else{
                option += '<td class="w25 pa-10"></td>'
            }
            option += '<td class="w25 pa-10">' + vendor_json_list[i]['first_name'] + vendor_json_list[i]['last_name'] + '</td>'
            option += '<td class="w15 pa-10">' + vendor_json_list[i]['email'] + '</td>'
            option += '<td class="w15 pa-10">' + vendor_json_list[i]['mobile'] + '</td> '
            if(vendor_json_list[i]['country_name'] !=null){
                option += '<td class="w10 pa-10">' + vendor_json_list[i]['country_name'] + '</td>'
            }else{
                option += '<td></td>'
            }
            option += '<td class="w5 text-center">'
            option += '<div class="inline-block dropdown">'
            option += '<a class="dropdown-toggle" data-toggle="dropdown" href="#" aria-expanded="false" role="button"><i class="icon lindo-android-more-vertical act-gray fz-22"></i></a>'
            option += '<ul class="dropdown-menu bullet dropdown-menu-right"  role="menu">'
            option += '<li class="b-b-g url_navigator" resource="Hr/Vendor/view_vendor_details"><a href="' + siteurl + '/Hr/Vendor/view_vendor_details/' + vendor_json_list[i]['vendor_id'] + '"  vendor_id="' + vendor_json_list[i]['vendor_id'] + '"  id="vendor_details111" data-toggle="modal"><i class="icon lindo-android-apps mr-10 fz-22 vam txt-success"></i>View</a></li>'
            option += '<li class="b-b-g url_navigator" resource="Hr/Vendor/edit_vendor_details"><a href="' + siteurl + '/Hr/Vendor/edit_vendor_details/' + vendor_json_list[i]['vendor_id'] + '"  vendor_id="' + vendor_json_list[i]['vendor_id'] + '" id="vendor_details" role="menuitem"><i class="icon lindo-page-edit mr-10 fz-22 vam txt-primary"></i>Edit</a></li>'
            option += '<li class="url_navigator" resource="Hr/Vendor/delete_vendor"><a href="#" vendor_id="' + vendor_json_list[i]['vendor_id'] + '" id="deletevendor" role=""  ><i class="icon lindo-delete-trash-1 mr-10 fz-22 vam txt-danger"></i>Delete</a></li>'
            if (vendor_json_list[i]['blocked'] == 0) {
                option += '<li class="url_navigators" resource="Hr/Vendor/block_vendor"><a href="#" id="block_vendor" vendor_id="' + vendor_json_list[i]['vendor_id'] + '" company_id="' + vendor_json_list[i]['company_id'] + '" role="menuitem"><i class="" ></i>Block</a></li>'
            } else {
                option += '<li class="url_navigators" resource="Hr/Vendor/unblock_vendor"><a href="#" id="unblock_vendor"  vendor_id="' + vendor_json_list[i]['vendor_id'] + '" company_id=""' + vendor_json_list[i]['company_id'] + '"" role="menuitem"><i class="" ></i>Unblock</a></li>'
            }
            option += '</ul>'
            option += '</div>'
            option += '</td>'
            option += '</tr>'
            option += '</tr>'
            count++;
        }
    }
    $('#search_result').html(option);

}



function readFile(line, lines) {
    line++;
    if (line < (lines.length)-1) {
        var line_data = lines[line].split(',');
        var firstname = line_data[0];
        var latname = line_data[1];
        var mobile = line_data[2];
        var email = line_data[3];
        var costcenter = line_data[4];
        var company_name = line_data[5];
        var company_phone = line_data[6];
        var company_fax = line_data[7];
        var company_email = line_data[8];
        var companywebsite = line_data[9];
        var billingaddressline1 = line_data[10];
        var billingaddressline2 = line_data[11];
        var billing_country = line_data[12];
        var billing_state = line_data[13];
        var billing_city = line_data[14];
        var billingzipcode = line_data[15];
        var shipadressline1 = line_data[16];
        var shipadressline2 = line_data[17];
        var shipcountry = line_data[18];
        var shipstate = line_data[19];
        var shipcity = line_data[20];
        var shipzipcode = line_data[21];
        var openingbalance = line_data[22];
        var debit = line_data[23];
        var data1 = {
            firstname: firstname,
            latname: latname,
            mobile: mobile,
            email: email,
            costcenter: costcenter,
            company_name: company_name,
            company_phone: company_phone,
            company_fax: company_fax,
            company_email: company_email,
            companywebsite: companywebsite,
            billingaddressline1: billingaddressline1,
            billingaddressline2: billingaddressline2,
            billing_country: billing_country,
            billing_state: billing_state,
            billing_city: billing_city,
            billingzipcode: billingzipcode,
            shipadressline1: shipadressline1,
            shipadressline2: shipadressline2,
            shipcountry: shipcountry,
            shipstate: shipstate,
            shipcity: shipcity,
            shipzipcode: shipzipcode,
            openingbalance: openingbalance,
            debit: debit

        }

        $.ajax({
            url: siteurl + '/Hr/Vendor/import_from_js',
            method: 'POST',
            data: data1,
            success: function (data) {
                console.log('line'+line);
                console.log('lines'+lines);
                readFile(line, lines);
            },
            error: function (a, b, c) {
                console.log('er line'+line);
                console.log('er lines'+lines);
                readFile(line, lines);
            }
        });
    } else {
        location.reload();
    }
}



