$(document).ready(function () {

    $(window).load(function () {
        if (typeof old_rate !== 'undefined' && typeof new_rate !== 'undefined' && parseFloat(old_rate) != parseFloat(new_rate)) {
            swal({
                title: "Transaction Rate Changed",
                text: "Do you want to apply the new rate",
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "Yes, Apply !",
                cancelButtonText: "No, don't apply !",
                closeOnConfirm: false,
                closeOnCancel: false
            },
                    function (isConfirm) {
                        if (isConfirm) {
                            $('.currency_rate').val(new_rate);
                            $('.cur_trans_rate_id').val(new_cur_trans_rate_id);
                            var net = $('#net_amt').val();
                            var final = parseFloat(net) / new_rate
                            $('#transaction_currency').val(parseFloat(final).toFixed(2));
                            swal("Rate Changed", "New Rate applied", "success");
                        } else {
                            swal("Cancelled", "Previous Rate will prevail", "success");
                        }
                    });
        }
    });
    $.post(siteurl + "/Inventory/Item/serach_item_and_service", {}, function (result)
    {
        item_json = JSON.parse(result);

    });
    $('body').on('change', '#common_percentage', function () {
//       
        var common_percentage = $(this).val();
        var pro_total = $('#hidden_pro_total').val();
        var proo = $('#pro_total').val();
        var serr = $('#ser_total').val();
        var extra = 0;
        $('.charge_amount').each(function () {
            if ($(this).val()) {
                extra += Number($(this).val());
            }
        });
        if (isNaN(serr)) {
            serr = 0;
        }
        if (isNaN(proo)) {
            proo = 0;
        }
        var sumt = Number(proo) + Number(serr) + Number(extra);

        if (sumt != 0) {
            if (common_percentage != "") {
                var cda = (parseFloat(sumt) * parseFloat(common_percentage) / 100);
            } else {
                var cda = 0;
            }
            $('#common_percentage_amount').val(parseFloat(cda).toFixed(2));
            calculate_grandtotal();
        } else {
            $(this).val(0);
            $('#common_percentage_amount').val(0);
        }
    });

    $('body').on('change', '#common_percentage_amount', function () {
        calculate_grandtotal();
    });
    $("body").on('click', '.selitem_noninv', function () {
        var item_id = $(this).attr('noninvid');
        var selid = $(this).closest('tr').attr('id-cl');
        var qtyy = $(this).closest('tr').find('.quan').val();
        if (item_id == '') {
            $('#noninventoryModal').find('input,checkbox').val('');
            $('#noninventoryModal').find('select').val('').trigger('change');
            $('#noninventoryModal').find('.barc_non_inv_type').val('vpu');
            //         <-----anju for tax------>
            $('#tax_type_inclu').prop('checked', true);
            $('#tax_type_inclu').val('inclusive');
            $('#tax_type_exclu').val('exclusive');
            //         <-----END------>
            $("#trid_non").val(selid);
            $('#sku').prop('disabled', false);
            $('#selectbrand').prop('disabled', false);
            
             $('#nonpro_qty').val(0);
             $('#nonpro_costprice').val(0);
             $('#nonpro_markup').val(0);
             $('#nonpro_sellingprice').val(0);
        } else {
            $.post(siteurl + "/Inventory/Item/pick_noninventory_details", {item_id: item_id}, function (result)
            {

                $("#trid_non").val(selid);
                var josn_array = JSON.parse(result);
                console.log(josn_array);
                $('#nonpro_costprice').val(josn_array.purchase_price);
                $('#nonpro_sellingprice').val(josn_array.sellingprice);
                $('#nonpro_markup').val(josn_array.markup_on_price);
                $('#nonpro_unit').val(josn_array.unit_id);
                $('#sku').val(josn_array.sku);
                $('#nonpro_name').val(josn_array.name);
                $('#saved_not').val(josn_array.item_id);
                $('#getvendor').val(josn_array.companyname);
                $('#getvendor_id').val(josn_array.vendor_id);
                $('#barc_non_inv').val(josn_array.barcode_type);
                $('#sku').prop('disabled', true);
                $('#selectbrand').prop('disabled', true);
                if (josn_array.barcode_type == 'vpc') {
                    $('.common_barcode_div_vpc').removeClass('no-display');
                    $('#common_barcode').val('');
                    $('.common_barcode_div').addClass('no-display');
                    $('#common_barcode_div').val(josn_array.barcode);

                } else if (josn_array.barcode_type == 'sgc') {
                    $('.common_barcode_div_vpc').addClass('no-display');
                    $('#common_barcode_div').val('');
                    $('.common_barcode_div').removeClass('no-display');
                    $('#common_barcode').val(josn_array.barcode);
                } else {
                    $('.common_barcode_div_vpc').addClass('no-display');
                    $('#common_barcode_div').val('');
                    $('.common_barcode_div').addClass('no-display');
                    $('#common_barcode').val('');
                }
                if (qtyy == '') {
                    qtyy = 0;
                }
                $('#nonpro_qty').val(qtyy);
            });
        }


    });
    $("body").on('click', '.selitem', function () {
        var noninvid = $(this).attr('noninvid');
        var searchkeyword = $(this).val();
        var option = '';
        var count = 1;
        var new_array = [];
        var length1 = 10;
        var selid = $(this).closest('tr').attr('id-cl');
        $("#trid").val(selid);
        $('#page_so_or_service').val('deal');
        for (var i = 0; i < item_json.length; i++) {
            if (item_json[i]['item_type'] == 'inventory' || item_json[i]['item_type'] == 'inventory_and_service' || item_json[i]['item_type'] == 'inventory and service') {
                new_array.push(item_json[i]);
            }
        }
        if (new_array.length < 10) {
            length1 = new_array.length;
        }
        for (var i = 0; i < length1; i++) {
            var cc = '';
            var cd = '';
            var vv = '';
            if (new_array[i]['sku'] == null)
            {
                cc = '&nbsp;'
            } else {
                cc = new_array[i]['sku'];
            }
            if (new_array[i]['sellingprice'] == null)
            {
                cd = '&nbsp;'
                vv = '&nbsp;'
            } else {
                cd = new_array[i]['sellingprice'];
                vv = Number(cd).toFixed(2);
            }
            option += '<tr class="sec_grid_sm">'
            option += '<td class="pa-5 vat">' + count + '</td> '
            option += '<td class="pa-5 vat">' + cc + '</td>'
            option += '<td class="pa-5 vat"><a href="" id="itm_id" class="closeopenmodal-sidebar itm_id" item_name="' + new_array[i]['name'] + '" item_id="' + new_array[i]['item_id'] + '">' + new_array[i]['name'] + '</a></td>'
            option += '<td class="pa-5 vat">'
            if (new_array[i]['item_type'] == 'inventory_and_service') {
                option += 'inventory and service'
            } else {
                option += new_array[i]['item_type'];
            }
            option += '</td>'
            option += '<td class="pa-5 vat">' + vv + '</td>'
            option += '<td class="pa-5 vat">'
            option += '<label style="display:none;" id="pdt_ser_name' + new_array[i]['item_id'] + '">' + new_array[i]['name'] + '</label>'
            option += '<input type="hidden" id="pdt_ser_id' + new_array[i]['item_id'] + '" value="' + new_array[i]['item_id'] + '">'
            option += '<input type="hidden" id="pdt_ser_sku' + new_array[i]['item_id'] + '" value="' + new_array[i]['sku'] + '">'
            option += '<input type="hidden" id="pdt_ser_sell_price' + new_array[i]['item_id'] + '" value="' + new_array[i]['sellingprice'] + '">'
            option += '<input type="hidden" id="pdt_ser_pur_price' + new_array[i]['item_id'] + '" value="' + new_array[i]['purchase_price'] + '">'
            option += '<input type="hidden" id="pdt_ser_unit' + new_array[i]['item_id'] + '" value="' + new_array[i]['unit_code'] + '">'
            option += '<input type="hidden" id="pdt_ser_type' + new_array[i]['item_id'] + '" value="' + new_array[i]['item_type'] + '">'
            option += '<input type="hidden" id="tot_qty' + new_array[i]['item_id'] + '" value="' + new_array[i]['total_quantity'] + '">'
            option += '<input type="hidden" id="enable_tracking' + new_array[i]['item_id'] + '" value="' + new_array[i]['enable_tracking'] + '">'
            option += '<input type="hidden" id="barcode_type' + new_array[i]['item_id'] + '" value="' + new_array[i]['barcode_type'] + '">'
            option += '<input type="hidden" id="bcd' + new_array[i]['item_id'] + '" value="' + new_array[i]['barcode'] + '">'
//          <-----anju for tax------>
            option += '<input type="hidden" id="interstate_tax' + new_array[i]['item_id'] + '" value="' + new_array[i]['interstate_taxid'] + '">'
            option += '<input type="hidden" id="intrastate_tax' + new_array[i]['item_id'] + '" value="' + new_array[i]['intrastate_taxid'] + '">'
            option += '<input type="hidden" id="export_tax' + new_array[i]['item_id'] + '" value="' + new_array[i]['export_taxid'] + '">'
            option += '<input type="hidden" id="service_tax' + new_array[i]['item_id'] + '" value="' + new_array[i]['service_taxid'] + '">'
            option += '<input type="hidden" id="intra_sales_account_id_hidden' + new_array[i]['item_id'] + '" value="' + new_array[i]['intra_sales_account_id'] + '">'
            option += '<input type="hidden" id="inter_sales_account_id_hidden' + new_array[i]['item_id'] + '" value="' + new_array[i]['inter_sales_account_id'] + '">'
            option += '<input type="hidden" id="export_sales_account_id_hidden' + new_array[i]['item_id'] + '" value="' + new_array[i]['export_sales_account_id'] + '">'
            option += '<input type="hidden" id="service_sales_account_id_hidden' + new_array[i]['item_id'] + '" value="' + new_array[i]['service_sales_account_id'] + '">'
            option += '<input type="hidden" id="item_taxtype' + new_array[i]['item_id'] + '" value="' + new_array[i]['tax_type'] + '">'

            //         <-----END------>
            option += '<button type="button" class="btn btn-primary btn-flat  pickitem " amc_flag="' + new_array[i]['amc_flag'] + '"  warrenty_flag="' + new_array[i]['warranty_flag'] + '" data-toggle="tooltip" id="product_search" sl-cl="" sel-id="' + new_array[i]['item_id'] + '" item_name="' + new_array[i]['name'] + '"  status="whole"  value="' + new_array[i]['item_id'] + '"><i class="icon lindo-tick fz-24 m-p-w"></i> </button>'
            option += '</td>'
            option += '<td class="pa-5 vat"><a id="itm_id" class="closeopenmodal-sidebar itm_id" item_name="' + new_array[i]['name'] + '" item_id="' + new_array[i]['item_id'] + '"><i class="icon lindo-info-circled fz-24"></i></a></td>'
            option += '</tr>';
            if (new_array[i]['partial_selling'] == 1)
            {
                if (new_array[i]['sellingprice'] == null)
                {
                    cd = '&nbsp;'
                    vv = '&nbsp;'
                } else {
                    cd = new_array[i]['sellingprice'];
                    vv = Number(cd).toFixed(2);
                }
                option += '<tr id="partial_tr">'
                option += '<td class="pa-5 vat">' + count + '</td> '
                option += '<td class="pa-5 vat">' + new_array[i]['sku'] + '</td>'
                option += '<td class="pa-5 vat"><a href="" id="itm_id" class="closeopenmodal-sidebar" item_name="' + new_array[i]['name'] + '" item_id="' + new_array[i]['item_id'] + '">' + new_array[i]['name'] + '(partial)' + '</a></td>'
                option += '<td class="pa-5 vat">'
                if (new_array[i]['item_type'] == 'inventory_and_service') {
                    option += 'inventory and service'
                } else {
                    option += new_array[i]['item_type'];
                }
                option += '</td>'
                option += '<td class="pa-5 vat">' + vv + '</td>'
                option += '<td class="pa-5 vat">'
                option += '<label style="display:none;" id="pdt_ser_name' + new_array[i]['item_id'] + '">' + new_array[i]['name'] + '(partial)</label>'
                option += '<input type="hidden" id="pdt_ser_id' + new_array[i]['item_id'] + '" value="' + new_array[i]['item_id'] + '-p' + '">'
                option += '<input type="hidden" id="pdt_ser_sku' + new_array[i]['item_id'] + '" value="' + new_array[i]['sku'] + '">'
                option += '<input type="hidden" id="pdt_ser_sell_price' + new_array[i]['item_id'] + '" value="' + new_array[i]['sellingprice'] + '">'
                option += '<input type="hidden" id="pdt_ser_pur_price' + new_array[i]['item_id'] + '" value="' + new_array[i]['purchase_price'] + '">'
                option += '<input type="hidden" id="pdt_ser_unit_partial' + new_array[i]['item_id'] + '" value="' + new_array[i]['partial_unit_code'] + '">'
                option += '<input type="hidden" id="pdt_ser_type' + new_array[i]['item_id'] + '" value="' + new_array[i]['item_type'] + '">'
                option += '<input type="hidden" id="tot_qty' + new_array[i]['item_id'] + '" value="' + new_array[i]['total_quantity'] + '">'
                option += '<input type="hidden" id="enable_tracking' + new_array[i]['item_id'] + '" value="' + new_array[i]['enable_tracking'] + '">'
                option += '<input type="hidden" id="barcode_type' + new_array[i]['item_id'] + '" value="' + new_array[i]['barcode_type'] + '">'
                option += '<input type="hidden" id="bcd' + new_array[i]['item_id'] + '" value="' + new_array[i]['barcode'] + '">'

                option += '<button type="button" class="btn btn-primary btn-flat  pickitem " amc_flag="' + new_array[i]['amc_flag'] + '"  warrenty_flag="' + new_array[i]['warranty_flag'] + '" data-toggle="tooltip" id="product_search" sl-cl="" item_name="' + new_array[i]['name'] + '" sel-id="' + new_array[i]['item_id'] + '-p' + '"  status="partial"  value="' + new_array[i]['item_id'] + '"><i class="icon lindo-tick fz-24 m-p-w"></i> </button>'
                option += '</td>'
                option += '<td class="pa-5 vat"><a id="itm_id" class="closeopenmodal-sidebar itm_id" item_name="' + new_array[i]['name'] + '" item_id="' + new_array[i]['item_id'] + '"><i class="icon lindo-info-circled fz-24"></i></a></td>'
                option += '</tr>';
            }
            count++;
        }
        $('.itemsearch').html(option);
        $('.item_editsearch').html(option);
    });
    $("body").on('keyup', '#product_name_service', function () {
        var searchkeyword = $(this).val();
        var hiddn_ser_mas_idcl = $('#hiddn_ser_mas_idcl').val();
        var option = '';
        var count = 1;
        var sellingprice = '';
        var selling_price = '';
        for (var i = 0; i < item_json.length; i++) {
            if (item_json[i]['name'].toLowerCase().indexOf(searchkeyword.toLowerCase()) != -1) {
                if (item_json[i]['item_type'] == 'service' || item_json[i]['item_type'] == 'inventory_and_service' || item_json[i]['item_type'] == 'inventory and service') {
                    var item_det = JSON.stringify(item_json[i]);
                    var newTemp = item_det.replace(/"/g, '\'');
                    option += '<tr class="sec_grid_sm">'
                    option += '<td class="pa-5 vat">' + count + '</td> '
                    option += '<td class="pa-5 vat">'
                    if (item_json[i]['sac']) {
                        option += item_json[i]['sac'];
                    } else {
                        option += "";
                    }
                    option += '</td>'
                    option += '<td class="pa-5 vat">' + item_json[i]['name'] + '</td>'
                    option += '<td class="pa-5 vat">'
                    if (item_json[i]['item_type'] == 'inventory_and_service') {
                        option += 'inventory and service'
                    } else {
                        option += item_json[i]['item_type'];
                    }
                    option += '</td>'
                    option += '<td class="pa-5 vat">'
                    if (item_json[i]['sellingprice']) {
                        sellingprice = item_json[i]['sellingprice'];
                        selling_price = Number(sellingprice).toFixed(2);
                        option += selling_price;

                    } else {
                        option += "";
                    }
                    option += '</td>'
                    option += '<td class="pa-5 vat">'
                    option += '<label style="display:none;" id="pdt_ser_name' + item_json[i]['item_id'] + '">' + item_json[i]['name'] + '</label>'
                    option += '<input type="hidden" id="pdt_ser_id' + item_json[i]['item_id'] + '" value="' + item_json[i]['item_id'] + '">'
                    option += '<input type="hidden" id="pdt_ser_sku' + item_json[i]['item_id'] + '" value="' + item_json[i]['sku'] + '">'
                    option += '<input type="hidden" id="pdt_ser_sell_price' + item_json[i]['item_id'] + '" value="' + item_json[i]['sellingprice'] + '">'
                    option += '<input type="hidden" id="pdt_ser_pur_price' + item_json[i]['item_id'] + '" value="' + item_json[i]['purchase_price'] + '">'
                    option += '<input type="hidden" id="pdt_ser_unit' + item_json[i]['item_id'] + '" value="' + item_json[i]['unit_code'] + '">'
                    option += '<input type="hidden" id="pdt_ser_type' + item_json[i]['item_id'] + '" value="' + item_json[i]['item_type'] + '">'
                    option += '<input type="hidden" id="tot_qty' + item_json[i]['item_id'] + '" value="' + item_json[i]['total_quantity'] + '">'
                    // nid last commit
                    option += '<input type="hidden" id="ser_intra_sales_account_id_hidden' + item_json[i]['item_id'] + '" value="' + item_json[i]['intra_sales_account_id'] + '">'
                    option += '<input type="hidden" id="ser_inter_sales_account_id_hidden' + item_json[i]['item_id'] + '" value="' + item_json[i]['inter_sales_account_id'] + '">'
                    option += '<input type="hidden" id="ser_export_sales_account_id_hidden' + item_json[i]['item_id'] + '" value="' + item_json[i]['export_sales_account_id'] + '">'
                    option += '<input type="hidden" id="ser_service_sales_account_id_hidden' + item_json[i]['item_id'] + '" value="' + item_json[i]['service_sales_account_id'] + '">'
                    option += '<input type="hidden" id="enable_tracking' + item_json[i]['item_id'] + '" value="' + item_json[i]['enable_tracking'] + '">'
                    option += '<input type="hidden" id="barcode_type' + item_json[i]['item_id'] + '" value="' + item_json[i]['barcode_type'] + '">'
                    option += '<input type="hidden" id="item_taxtype' + item_json[i]['item_id'] + '" value="' + item_json[i]['tax_type'] + '">'
                    option += '<input type="hidden" id="bcd' + item_json[i]['item_id'] + '" value="' + item_json[i]['barcode'] + '">'
                    option += '<button type="button" class="btn btn-primary btn-flat  pickservice2 product_search" ser_mast_idcl="' + hiddn_ser_mas_idcl + '" jcoded="' + newTemp + '" data-toggle="tooltip" id="product_search" sl-cl="" sel-id="' + item_json[i]['item_id'] + '" item_name="' + item_json[i]['name'] + '"  status="whole"  value="' + item_json[i]['item_id'] + '"><i class="icon lindo-tick fz-24 m-p-w"></i> </button>'
                    option += '</td>'
                    option += '</tr>';
                    count++;
                }
            }
        }
        $('.servicesearch').html(option);
    });
    $("body").on('keyup', '#product_name', function () {
        var searchkeyword = $(this).val();
        var option = '';
        var count = 1;
        var sku = '';
        var sellingprice = '';
        var selling_price = '';
        for (var i = 0; i < item_json.length; i++) {
            if (item_json[i]['item_type'] == 'inventory' || item_json[i]['item_type'] == 'inventory_and_service') {
                if (item_json[i]['name'].toLowerCase().indexOf(searchkeyword.toLowerCase()) != -1) {
                    if (item_json[i]['sku'] == null) {
                        sku = '';
                    } else {
                        sku = item_json[i]['sku']
                    }
                    if (item_json[i]['sellingprice'] == null) {
                        sellingprice = '';
                        selling_price = '';
                    } else {
                        sellingprice = item_json[i]['sellingprice']
                        selling_price = Number(sellingprice).toFixed(2);
                    }
                    option += '<tr class="sec_grid_sm">'
                    option += '<td class="pa-5 vat">' + count + '</td> '
                    option += '<td class="pa-5 vat">' + sku + '</td>'
                    option += '<td class="pa-5 vat"><a href="" id="itm_id" class="closeopenmodal-sidebar itm_id" item_name="' + item_json[i]['name'] + '" item_id="' + item_json[i]['item_id'] + '">' + item_json[i]['name'] + '</a></td>'

                    option += '<td class="pa-5 vat">'
                    if (item_json[i]['item_type'] == 'inventory_and_service') {
                        option += 'inventory and service'
                    } else {
                        option += item_json[i]['item_type'];
                    }
                    option += '</td>'
                    option += '<td class="pa-5 vat">' + selling_price + '</td>'
                    option += '<td class="pa-5 vat">'
                    option += '<label style="display:none;" id="pdt_ser_name' + item_json[i]['item_id'] + '">' + item_json[i]['name'] + '</label>'
                    option += '<input type="hidden" id="pdt_ser_id' + item_json[i]['item_id'] + '" value="' + item_json[i]['item_id'] + '">'
                    option += '<input type="hidden" id="pdt_ser_sku' + item_json[i]['item_id'] + '" value="' + item_json[i]['sku'] + '">'
                    option += '<input type="hidden" id="pdt_ser_sell_price' + item_json[i]['item_id'] + '" value="' + item_json[i]['sellingprice'] + '">'
                    option += '<input type="hidden" id="pdt_ser_pur_price' + item_json[i]['item_id'] + '" value="' + item_json[i]['purchase_price'] + '">'
                    option += '<input type="hidden" id="pdt_ser_unit' + item_json[i]['item_id'] + '" value="' + item_json[i]['unit_code'] + '">'
                    option += '<input type="hidden" id="pdt_ser_type' + item_json[i]['item_id'] + '" value="' + item_json[i]['item_type'] + '">'
                    option += '<input type="hidden" id="tot_qty' + item_json[i]['item_id'] + '" value="' + item_json[i]['total_quantity'] + '">'
                    option += '<input type="hidden" id="enable_tracking' + item_json[i]['item_id'] + '" value="' + item_json[i]['enable_tracking'] + '">'
                    option += '<input type="hidden" id="bcd' + item_json[i]['item_id'] + '" value="' + item_json[i]['barcode'] + '">'

                    //         <-----anju for tax------>
                    option += '<input type="hidden" id="intra_sales_account_id_hidden' + item_json[i]['item_id'] + '" value="' + item_json[i]['intra_sales_account_id'] + '">'
                    option += '<input type="hidden" id="inter_sales_account_id_hidden' + item_json[i]['item_id'] + '" value="' + item_json[i]['inter_sales_account_id'] + '">'
                    option += '<input type="hidden" id="export_sales_account_id_hidden' + item_json[i]['item_id'] + '" value="' + item_json[i]['export_sales_account_id'] + '">'
                    option += '<input type="hidden" id="service_sales_account_id_hidden' + item_json[i]['item_id'] + '" value="' + item_json[i]['service_sales_account_id'] + '">'
                    option += '<input type="hidden" id="interstate_tax' + item_json[i]['item_id'] + '" value="' + item_json[i]['interstate_taxid'] + '">'
                    option += '<input type="hidden" id="intrastate_tax' + item_json[i]['item_id'] + '" value="' + item_json[i]['intrastate_taxid'] + '">'
                    option += '<input type="hidden" id="export_tax' + item_json[i]['item_id'] + '" value="' + item_json[i]['export_taxid'] + '">'
                    option += '<input type="hidden" id="service_tax' + item_json[i]['item_id'] + '" value="' + item_json[i]['service_taxid'] + '">'
                    option += '<input type="hidden" id="item_taxtype' + item_json[i]['item_id'] + '" value="' + item_json[i]['tax_type'] + '">'
                    //         <-----END------>
                    option += '<input type="hidden" id="barcode_type' + item_json[i]['item_id'] + '" value="' + item_json[i]['barcode_type'] + '">'
                    option += '<button type="button" class="btn btn-primary btn-flat  pickitem" data-toggle="tooltip" id="product_search" sl-cl="" item_name="' + item_json[i]['name'] + '" sel-id="' + item_json[i]['item_id'] + '"  status="whole"  value="' + item_json[i]['item_id'] + '"><i class="icon lindo-tick fz-24 m-p-w"></i> </button>'
                    option += '</td>'
                    option += '<td class="pa-5 vat"><a id="itm_id" class="closeopenmodal-sidebar itm_id" item_name="' + item_json[i]['name'] + '" item_id="' + item_json[i]['item_id'] + '"><i class="icon lindo-info-circled fz-24"></i></a></td>'
                    option += '</tr>';
                    if (item_json[i]['partial_selling'] == 1)
                    {
                        count++;
                        option += '<tr id="partial_tr">'
                        option += '<td class="pa-5 vat">' + count + '</td> '
                        option += '<td class="pa-5 vat">' + item_json[i]['sku'] + '</td>'
                        option += '<td class="pa-5 vat"><a href="" id="itm_id" class="closeopenmodal-sidebar itm_id" item_name="' + item_json[i]['name'] + '" item_id="' + item_json[i]['item_id'] + '">' + item_json[i]['name'] + '(partial)' + '</a></td>'
                        option += '<td class="pa-5 vat">'
                        if (item_json[i]['item_type'] == 'inventory_and_service') {
                            option += 'inventory and service'
                        } else {
                            option += item_json[i]['item_type'];
                        }
                        option += '</td>'
                        option += '<td class="pa-5 vat">' + selling_price + '</td>'
                        option += '<td class="pa-5 vat">'
                        option += '<label style="display:none;" id="pdt_ser_name' + item_json[i]['item_id'] + '">' + item_json[i]['name'] + '(partial)</label>'
                        option += '<input type="hidden" id="pdt_ser_id' + item_json[i]['item_id'] + '" value="' + item_json[i]['item_id'] + '-p' + '">'
                        option += '<input type="hidden" id="pdt_ser_sku' + item_json[i]['item_id'] + '" value="' + item_json[i]['sku'] + '">'
                        option += '<input type="hidden" id="pdt_ser_sell_price' + item_json[i]['item_id'] + '" value="' + item_json[i]['sellingprice'] + '">'
                        option += '<input type="hidden" id="pdt_ser_pur_price' + item_json[i]['item_id'] + '" value="' + item_json[i]['purchase_price'] + '">'
                        option += '<input type="hidden" id="pdt_ser_unit_partial' + item_json[i]['item_id'] + '" value="' + item_json[i]['partial_unit_code'] + '">'
                        option += '<input type="hidden" id="pdt_ser_type' + item_json[i]['item_id'] + '" value="' + item_json[i]['item_type'] + '">'
                        option += '<input type="hidden" id="tot_qty' + item_json[i]['item_id'] + '" value="' + item_json[i]['total_quantity'] + '">'
                        option += '<input type="hidden" id="enable_tracking' + item_json[i]['item_id'] + '" value="' + item_json[i]['enable_tracking'] + '">'
                        option += '<input type="hidden" id="bcd' + item_json[i]['item_id'] + '" value="' + item_json[i]['barcode'] + '">'

                        //         <-----anju for tax------>
                        option += '<input type="hidden" id="interstate_tax' + item_json[i]['item_id'] + '" value="' + item_json[i]['interstate_taxid'] + '">'
                        option += '<input type="hidden" id="intrastate_tax' + item_json[i]['item_id'] + '" value="' + item_json[i]['intrastate_taxid'] + '">'
                        option += '<input type="hidden" id="export_tax' + item_json[i]['item_id'] + '" value="' + item_json[i]['export_taxid'] + '">'
                        option += '<input type="hidden" id="service_tax' + item_json[i]['item_id'] + '" value="' + item_json[i]['service_taxid'] + '">'
                        //         <-----END------>
                        option += '<input type="hidden" id="barcode_type' + item_json[i]['item_id'] + '" value="' + item_json[i]['barcode_type'] + '">'
                        option += '<button type="button" class="btn btn-primary btn-flat  pickitem" data-toggle="tooltip" id="product_search" sl-cl="" item_name="' + item_json[i]['name'] + '" sel-id="' + item_json[i]['item_id'] + '-p' + '"  status="partial"  value="' + item_json[i]['item_id'] + '"><i class="icon lindo-tick fz-24 m-p-w"></i> </button>'
                        option += '</td>'
                        option += '<td class="pa-5 vat"><a id="itm_id" class="closeopenmodal-sidebar itm_id" item_name="' + item_json[i]['name'] + '" item_id="' + item_json[i]['item_id'] + '"><i class="icon lindo-info-circled fz-24"></i></a></td>'
                        option += '</tr>';
                    }
                    count++;
                } else if (item_json[i]['sku'] != null) {
                    if (item_json[i]['sku'].toLowerCase().indexOf(searchkeyword.toLowerCase()) != -1) {
                        if (item_json[i]['sku'] == null) {
                            sku = '';
                        } else {
                            sku = item_json[i]['sku']
                        }
                        if (item_json[i]['sellingprice'] == null) {
                            sellingprice = '';
                            selling_price = '';
                        } else {
                            sellingprice = item_json[i]['sellingprice']
                            selling_price = Number(sellingprice).toFixed(2);
                        }
                        option += '<tr class="sec_grid_sm">'
                        option += '<td class="pa-5 vat">' + count + '</td> '
                        option += '<td class="pa-5 vat">' + sku + '</td>'
                        option += '<td class="pa-5 vat"><a href="" id="itm_id" class="closeopenmodal-sidebar itm_id" item_name="' + item_json[i]['name'] + '" item_id="' + item_json[i]['item_id'] + '">' + item_json[i]['name'] + '</a></td>'

                        option += '<td class="pa-5 vat">'
                        if (item_json[i]['item_type'] == 'inventory_and_service') {
                            option += 'inventory and service'
                        } else {
                            option += item_json[i]['item_type'];
                        }
                        option += '</td>'
                        option += '<td class="pa-5 vat">' + selling_price + '</td>'
                        option += '<td class="pa-5 vat">'
                        option += '<label style="display:none;" id="pdt_ser_name' + item_json[i]['item_id'] + '">' + item_json[i]['name'] + '</label>'
                        option += '<input type="hidden" id="pdt_ser_id' + item_json[i]['item_id'] + '" value="' + item_json[i]['item_id'] + '">'
                        option += '<input type="hidden" id="pdt_ser_sku' + item_json[i]['item_id'] + '" value="' + item_json[i]['sku'] + '">'
                        option += '<input type="hidden" id="pdt_ser_sell_price' + item_json[i]['item_id'] + '" value="' + item_json[i]['sellingprice'] + '">'
                        option += '<input type="hidden" id="pdt_ser_pur_price' + item_json[i]['item_id'] + '" value="' + item_json[i]['purchase_price'] + '">'
                        option += '<input type="hidden" id="pdt_ser_unit' + item_json[i]['item_id'] + '" value="' + item_json[i]['unit_code'] + '">'
                        option += '<input type="hidden" id="pdt_ser_type' + item_json[i]['item_id'] + '" value="' + item_json[i]['item_type'] + '">'
                        option += '<input type="hidden" id="tot_qty' + item_json[i]['item_id'] + '" value="' + item_json[i]['total_quantity'] + '">'
                        option += '<input type="hidden" id="enable_tracking' + item_json[i]['item_id'] + '" value="' + item_json[i]['enable_tracking'] + '">'
                        option += '<input type="hidden" id="bcd' + item_json[i]['item_id'] + '" value="' + item_json[i]['barcode'] + '">'

                        //         <-----anju for tax------>
                        option += '<input type="hidden" id="interstate_tax' + item_json[i]['item_id'] + '" value="' + item_json[i]['interstate_taxid'] + '">'
                        option += '<input type="hidden" id="intrastate_tax' + item_json[i]['item_id'] + '" value="' + item_json[i]['intrastate_taxid'] + '">'
                        option += '<input type="hidden" id="export_tax' + item_json[i]['item_id'] + '" value="' + item_json[i]['export_taxid'] + '">'
                        option += '<input type="hidden" id="service_tax' + item_json[i]['item_id'] + '" value="' + item_json[i]['service_taxid'] + '">'
                        //         <-----END------>
                        option += '<input type="hidden" id="barcode_type' + item_json[i]['item_id'] + '" value="' + item_json[i]['barcode_type'] + '">'
                        option += '<button type="button" class="btn btn-primary btn-flat  pickitem" data-toggle="tooltip" id="product_search" sl-cl="" item_name="' + item_json[i]['name'] + '" sel-id="' + item_json[i]['item_id'] + '"  status="whole"  value="' + item_json[i]['item_id'] + '"><i class="icon lindo-tick fz-24 m-p-w"></i> </button>'
                        option += '</td>'
                        option += '<td class="pa-5 vat"><a id="itm_id" class="closeopenmodal-sidebar itm_id" item_name="' + item_json[i]['name'] + '" item_id="' + item_json[i]['item_id'] + '"><i class="icon lindo-info-circled fz-24"></i></a></td>'
                        option += '</tr>';
                        if (item_json[i]['partial_selling'] == 1)
                        {
                            count++;
                            option += '<tr id="partial_tr">'
                            option += '<td class="pa-5 vat">' + count + '</td> '
                            option += '<td class="pa-5 vat">' + item_json[i]['sku'] + '</td>'
                            option += '<td class="pa-5 vat"><a href="" id="itm_id" class="closeopenmodal-sidebar itm_id" item_name="' + item_json[i]['name'] + '" item_id="' + item_json[i]['item_id'] + '">' + item_json[i]['name'] + '(partial)' + '</a></td>'
                            option += '<td class="pa-5 vat">'
                            if (item_json[i]['item_type'] == 'inventory_and_service') {
                                option += 'inventory and service'
                            } else {
                                option += item_json[i]['item_type'];
                            }
                            option += '</td>'
                            option += '<td class="pa-5 vat">' + selling_price + '</td>'
                            option += '<td class="pa-5 vat">'
                            option += '<label style="display:none;" id="pdt_ser_name' + item_json[i]['item_id'] + '">' + item_json[i]['name'] + '(partial)</label>'
                            option += '<input type="hidden" id="pdt_ser_id' + item_json[i]['item_id'] + '" value="' + item_json[i]['item_id'] + '-p' + '">'
                            option += '<input type="hidden" id="pdt_ser_sku' + item_json[i]['item_id'] + '" value="' + item_json[i]['sku'] + '">'
                            option += '<input type="hidden" id="pdt_ser_sell_price' + item_json[i]['item_id'] + '" value="' + item_json[i]['sellingprice'] + '">'
                            option += '<input type="hidden" id="pdt_ser_pur_price' + item_json[i]['item_id'] + '" value="' + item_json[i]['purchase_price'] + '">'
                            option += '<input type="hidden" id="pdt_ser_unit_partial' + item_json[i]['item_id'] + '" value="' + item_json[i]['partial_unit_code'] + '">'
                            option += '<input type="hidden" id="pdt_ser_type' + item_json[i]['item_id'] + '" value="' + item_json[i]['item_type'] + '">'
                            option += '<input type="hidden" id="tot_qty' + item_json[i]['item_id'] + '" value="' + item_json[i]['total_quantity'] + '">'
                            option += '<input type="hidden" id="enable_tracking' + item_json[i]['item_id'] + '" value="' + item_json[i]['enable_tracking'] + '">'
                            option += '<input type="hidden" id="bcd' + item_json[i]['item_id'] + '" value="' + item_json[i]['barcode'] + '">'

                            //         <-----anju for tax------>
                            option += '<input type="hidden" id="interstate_tax' + item_json[i]['item_id'] + '" value="' + item_json[i]['interstate_taxid'] + '">'
                            option += '<input type="hidden" id="intrastate_tax' + item_json[i]['item_id'] + '" value="' + item_json[i]['intrastate_taxid'] + '">'
                            option += '<input type="hidden" id="export_tax' + item_json[i]['item_id'] + '" value="' + item_json[i]['export_taxid'] + '">'
                            option += '<input type="hidden" id="service_tax' + item_json[i]['item_id'] + '" value="' + item_json[i]['service_taxid'] + '">'
                            option += '<input type="hidden" id="item_taxtype' + item_json[i]['item_id'] + '" value="' + item_json[i]['tax_type'] + '">'
                            //         <-----END------>
                            option += '<input type="hidden" id="barcode_type' + item_json[i]['item_id'] + '" value="' + item_json[i]['barcode_type'] + '">'
                            option += '<button type="button" class="btn btn-primary btn-flat  pickitem" data-toggle="tooltip" id="product_search" sl-cl="" item_name="' + item_json[i]['name'] + '" sel-id="' + item_json[i]['item_id'] + '-p' + '"  status="partial"  value="' + item_json[i]['item_id'] + '"><i class="icon lindo-tick fz-24 m-p-w"></i> </button>'
                            option += '</td>'
                            option += '<td class="pa-5 vat"><a id="itm_id" class="closeopenmodal-sidebar itm_id" item_name="' + item_json[i]['name'] + '" item_id="' + item_json[i]['item_id'] + '"><i class="icon lindo-info-circled fz-24"></i></a></td>'
                            option += '</tr>';
                        }
                        count++;
                    }
                }
            }
        }
        $('.itemsearch').html(option);
    });
    $(".product_search").on('click', function ()
    {
        var product_name = $('#product_name').val();
        if (product_name == "")
        {
            swal('Alert', 'Please enter details.', 'error');
        } else {
            $('#jquery_mask').show();
            $.post(siteurl + "/Inventory/Purchase_requsition/search_item", {product_name: product_name}, function (data) {
                $('#jquery_mask').hide();
                $('#search_results_disp').html(data);
            });
        }
    });
    $('body').on('click', '.btn_addnoninventory', function () {
        var savecheck = $('#saved_not').val();
        var currency_rate = $('#currency_rate').val();
        var trid = $('#trid_non').val();
        var nonpro_name = $('#nonpro_name').val();
        var sku = $('#sku').val();
        var selectbrand = $('#selectbrand').val();
        var nonpro_vendor = $('#getvendor_id').val();
        var nonpro_unit = $('#nonpro_unit').val();
        var unit_code = $('#nonpro_unit option:selected').attr('unit_code');
        var quantity = $('#nonpro_qty').val();
        var nonpro_costprice = $('#nonpro_costprice').val();
        var nonpro_markup = $('#nonpro_markup').val();
        var nonpro_sellingprice = $('#nonpro_sellingprice').val();
        var barc_non_inv = $('#barc_non_inv').val();
        var common_barcode = $('#common_barcode').val();
        var common_barcode_div = $('#common_barcode_div').val();
        //anjup for tax-------------->
        var tax_enabled = $('#tax_enabled').val();
        var interstate_tax = -1;
        var intrastate_tax = -1;
        var export_tax = -1;
        var tax_type = 'inclusive';
        if (tax_enabled != -1) {
            interstate_tax = $('#interstate_tax').val();
            intrastate_tax = $('#intrastate_tax').val();
            export_tax = $('#export_tax').val();
            tax_type = $('#noninventoryModal .tax_typein:checked').val();
            var maintax_type = $('.tax_type:checked').val();
        }
        //END<------------------------

        var itemsell1 = parseFloat(nonpro_sellingprice) * parseFloat(currency_rate);
        var nonprosellingprice = itemsell1.toFixed(2);

        var itemsell2 = parseFloat(nonpro_costprice) * parseFloat(currency_rate);
        var nonprocostprice = itemsell2.toFixed(2);

        if (nonpro_name == "") {
            swal("required", "product name required", "error");
            return false;
        }
//        if (selectbrand == "") {
//            swal("required", "Brand  required", "error");
//            return false;
//        }
//        if (sku == "") {
//            swal("required", "sku  required", "error");
//            return false;
//        }
//        if (nonpro_unit == "") {
//            swal("required", "product unit required", "error");
//            return false;
//        }
//        if (quantity == "") {
//            swal("required", "quantity required", "error");
//            return false;
//        }
//        if (nonpro_costprice == "") {
//            swal("required", "cost price required", "error");
//            return false;
//        }
//        if (nonpro_markup == "") {
//            swal("required", "markup price", "error");
//            return false;
//        }
//        if (barc_non_inv == "") {
//            swal("required", "Barcode Type", "error");
//            return false;
//        }
//        if (barc_non_inv == 'vpc' || barc_non_inv == 'sgc') {
//            if (common_barcode == '' && common_barcode_div == '') {
//                swal("required", "Barcode", "error");
//                return false;
//            }
//        }
        if (barc_non_inv == 'vpc') {

            $('#jquery_mask').show();
            $.post(siteurl + "/Crm/Deals/check_barcode_for_vpc_sales", {common_barcode: common_barcode_div, savecheck: savecheck}, function (result) {
                $('#jquery_mask').hide();
                if (result == 1) {
                    swal("This Barcode already exist please change");
                } else {
                    $('#jquery_mask').show();
                    $.post(siteurl + "/Crm/Deals/insert_noninventory", {nonpro_name: nonpro_name, sku: sku, nonpro_vendor: nonpro_vendor, nonpro_unit: nonpro_unit, nonpro_costprice: nonpro_costprice, nonpro_markup: nonpro_markup, nonpro_sellingprice: nonpro_sellingprice, savecheck: savecheck, tax_enabled: tax_enabled, interstate_tax: interstate_tax, intrastate_tax: intrastate_tax, export_tax: export_tax, tax_type: tax_type, barcode_type: barc_non_inv, common_barcode: common_barcode_div}, function (result)
                    {
                        $('#jquery_mask').hide();
                        result = $.trim(result);
                        var sid = $('#trid_non').val();
                        var sll = $('[id-cl=' + sid + ']');
                        var ff = sll.find('.pdt_title');
                        ff.text(nonpro_name);

                        var ff1 = sll.find('.comments_pro');
                        ff1.val(nonpro_name);
                        var sk = sll.find('.pdt_sku');
                        sk.text(sku);
//            var un = sll.find('.pdt_unit');
//            un.text(nonpro_unit);
                        var non = sll.find('.pdt_type');
                        non.text('non-inventory');
                        var ii = sll.find('.pdt_id');
                        ii.val(result);
                        var ii = sll.find('#view_details');
                        ii.attr('iditem', result);
                        var ii = sll.find('#view_history');
                        ii.attr('iditem', result);
                        var ii = sll.find('.selitem_noninv');
                        ii.attr('noninvid', result);
                        var qq = sll.find('.quan'); //for purchase order
                        qq.val(quantity);
                        var pp = sll.find('.purchase_p'); //for quote
                        pp.val(nonprocostprice);
                        var uu = sll.find('.pdt_unit'); //for quote
                        uu.text(unit_code);
                        var type = sll.find('.pdt_type'); //for quote
                        type.val('non-inventory');
                        var ss = sll.find('.selling_p'); //for quote
                        ss.val(nonprosellingprice);
                        var sp = sll.find('.s_p'); //for quote
                        sp.val('');
                        var am = sll.find('.amount'); //for quote
                        am.val('');
                        var dis = sll.find('.dis'); //for quote
                        dis.val(0);
                        var dd = sll.find('#item_id');
                        dd.val(result).change();
                        sll.find('#itemtaxtype_hidden').val(tax_type);
                        tax_bind_product(sll, result, tax_type);
                        calculate_pro_row_total(sll);
                        product_subtotal_calculation();
                        calculate_grandtotal();

                        sll.find('.sellingPrice').val(nonpro_sellingprice);
                        sll.find('.selling_p_hidden').val(nonpro_sellingprice);
                        sll.find('.purchase_p_hidden').val(nonpro_costprice);
                        sll.find('.add_noninv').hide();
                        sll.find('.editnoninv').show();
                        if (sid == 1) {
                            sll.find('.editnoninv').removeClass('no-display');
                        }

                        var sum = 0;
                        $('.amount').each(function () {
                            sum += Number($(this).val());
                        });
                        $('#net_amt').val(parseFloat(sum));
                        $('#noninventoryModal').modal('hide');
                        $('.sellingPrice').trigger("keyup");
                    });
                }
            });
        } else {
            $('#jquery_mask').show();
            $.post(siteurl + "/Crm/Deals/insert_noninventory", {nonpro_name: nonpro_name, sku: sku, nonpro_vendor: nonpro_vendor, nonpro_unit: nonpro_unit, nonpro_costprice: nonpro_costprice, nonpro_markup: nonpro_markup, nonpro_sellingprice: nonpro_sellingprice, savecheck: savecheck, tax_enabled: tax_enabled, interstate_tax: interstate_tax, intrastate_tax: intrastate_tax, export_tax: export_tax, tax_type: tax_type, barcode_type: barc_non_inv, common_barcode: common_barcode}, function (result)
            {
                console.log(result);
                $('#jquery_mask').hide();
                result = $.trim(result);
                var sid = $('#trid_non').val();
                var sll = $('[id-cl=' + sid + ']');
                var ff = sll.find('.pdt_title');
                ff.text(nonpro_name);
                var ff1 = sll.find('.comments_pro');
                ff1.val(nonpro_name);
                var sk = sll.find('.pdt_sku');
                sk.html(sku);
//            var un = sll.find('.pdt_unit');
//            un.text(nonpro_unit);
                var non = sll.find('.pdt_type');
                non.text('non-inventory');
                var ii = sll.find('.pdt_id');
                ii.val(result);
                var ii = sll.find('#view_details');
                ii.attr('iditem', result);
                var ii = sll.find('#view_history');
                ii.attr('iditem', result);
                var ii = sll.find('.selitem_noninv');
                ii.attr('noninvid', result);
                var qq = sll.find('.quan'); //for purchase order
                qq.val(quantity);
                var pp = sll.find('.purchase_p'); //for quote
                pp.val(nonprocostprice);
                var uu = sll.find('.pdt_unit'); //for quote
                uu.text(unit_code);
                var type = sll.find('.pdt_type'); //for quote
                type.val('non-inventory');
                var ss = sll.find('.selling_p'); //for quote
                ss.val(nonprosellingprice);
                var sp = sll.find('.s_p'); //for quote
                sp.val('');
                var am = sll.find('.amount'); //for quote
                am.val('');
                var dis = sll.find('.dis'); //for quote
                dis.val(0);
                var dd = sll.find('#item_id');
                dd.val(result).change();
                sll.find('#itemtaxtype_hidden').val(tax_type);
                tax_bind_product(sll, result, tax_type);
                calculate_pro_row_total(sll);
                product_subtotal_calculation();
                calculate_grandtotal();

                sll.find('.sellingPrice').val(nonpro_sellingprice);
                sll.find('.selling_p_hidden').val(nonpro_sellingprice);
                sll.find('.purchase_p_hidden').val(nonpro_costprice);
                sll.find('.add_noninv').hide();
                sll.find('.editnoninv').show();
                if (sid == 1) {
                    sll.find('.editnoninv').removeClass('no-display');
                }
                var sum = 0;
                $('.amount').each(function () {
                    sum += Number($(this).val());
                });
                $('#net_amt').val(parseFloat(sum));
                $('#noninventoryModal').modal('hide');
                $('.sellingPrice').trigger("keyup");
            });
        }
    });

    $('body').on('change', '#selectbrand', function (e) {
        var brand_id = $(this).val();
        if (brand_id) {
            $.post(siteurl + "/Inventory/Item/generate_sku", {brand_id: brand_id}, function (result) {
                $('.sku_chk').val(result);
            });
        }
    });
    $('body').on('click', '.copyorgmember', function (e) {

        var pdt_title = $('.pdt_title:last').html();
        var sellingPrice = $('.sellingPrice:last').val();
        var quan = $('.quan:last').val();
        var amount = $('.amount:last').val();
        if (pdt_title == '' || sellingPrice == '' || quan == '' || quan == 0 || amount == '' || amount == 0) {
            swal("Please enter valid entry");
        } else {
            e.preventDefault();
            var clid = $(".cld:last").attr('id-cl');
            var nxt = parseFloat(clid) + 1;
            var bc = $(".clone").clone();
            bc.attr("id-cl", nxt);
            bc.find('.clear').remove();
            var dd = bc.find("input");
            dd.val("");
            var pdt_sku = bc.find(".pdt_sku");
            pdt_sku.text("");
            var pdt_unit = bc.find(".pdt_unit");
            pdt_unit.text("");
            var pdt_unit = bc.find("#view_details");
            pdt_unit.attr('iditem', '');
            var pdt_unit = bc.find("#view_history");
            pdt_unit.attr('iditem', '');
            var pdt_unit = bc.find(".selitem_noninv");
            pdt_unit.attr('noninvid', '');

            bc.find(".barcodes").html('');
            bc.find(".add_noninv").show();
            bc.find(".editnoninv").hide();
            var pdt_type = bc.find(".pdt_type");
            pdt_type.text("");
            bc.removeClass('clone');
            bc.find(".pdt_title").text('');
            var cc = bc.find('.no-display');
            cc.removeClass('no-display');
            bc.find('.show_format1').text('');
            bc.find('.error').addClass('no-display');
            bc.find('.amcbtn').addClass('no-display');
            bc.find('.selitem_noninv').prop('disabled', false);
            bc.find('.show_format3').text('');
            bc.find('.discount').attr('from_disc', 'per_dicount');
            bc.appendTo(".table-append_common");
        }
    });
    $('body').on('keyup', '.quan,.sellingPrice', function () {
        var common_page = $('.page_check_common').val();
        if (common_page == 'deal') {
            $("#deal_stage")[0].selectedIndex = 0;
            $("#probability").val('');
            $("#expected_revenue").val('');
        }
        var rowid = $(this).closest('tr').attr('id-cl');
        var sll = $('[id-cl=' + rowid + ']');
        calculate_pro_row_total(sll);
        product_subtotal_calculation();
        calculate_grandtotal();
    });
    $('body').on('blur', '.discount', function () {
        var rowid = $(this).closest('tr').attr('id-cl');
        var sll = $('[id-cl=' + rowid + ']');
        var discount_percentage = $(this).val();
        var pro_rate = sll.find('.sellingPrice').val();
        var quan = sll.find('.quan').val();
        var pro_amount = pro_rate * quan;
        var percent = (parseFloat(discount_percentage) * pro_amount / parseFloat(100));
        if (isNaN(percent)) {
            var percent = 0;
        }
        sll.find('.item_disc_amt').val(parseFloat(percent).toFixed(2));
        calculate_pro_row_total(sll);
        product_subtotal_calculation();
        calculate_grandtotal();
    });
    $('body').on('keyup', '.item_disc_amt', function (e) {
        var rowid = $(this).closest('tr').attr('id-cl');
        var sll = $('[id-cl=' + rowid + ']');
        calculate_pro_row_total(sll);
        product_subtotal_calculation();
        calculate_grandtotal();
    });
//    $('body').on('keyup', '.sellingPrice', function () {
//        $("#net_amt").trigger("change");
//        $('#common_percentage_amount').trigger("change");
//    });
//    $('body').on('change', '.item_disc_amt', function () {
//        $("#net_amt").trigger("change");
//        $('#common_percentage_amount').trigger("change");
//    });
    $('body').on('click', '.clear', function (e) {
        e.preventDefault();

        var quote_pdt_id = $(this).closest('tr').find('.quote_pdt_id').val();
        var deleteids = [];
        var deleteidd = $('.deleted_pdt_ids').val();
        if (deleteidd != '') {
            deleteids = deleteidd.split(',');
        }
        deleteids.push(quote_pdt_id);
        $(this).closest('tr').find('.div_moneyholder span').html('');
        var pdt_id = $(this).closest('tr').find('.pdt_id').val();
        $(this).closest('tr').find('input,select,checkbox').val('');
        $(this).closest('tr').find('.pdt_title  ').text('');
        $(this).closest('tr').find('.pdt_sku').html('');
        $(this).closest('tr').find('.pdt_type').html('');
        $(this).closest('tr').find('.pdt_unit').html('');
        $(this).closest('tr').find('.barcodes').html('');
        $(this).closest('tr').find('.selitem_noninv').prop('disabled', false);
        product_subtotal_calculation();
        calculate_grandtotal();


    });






    $('body').on('click', '.remove_ser_masta', function () {
        if ($(this).closest('tr').attr('rowid') != 1) {
            $(this).closest('tr').remove();
        } else {
            $(this).closest('tr').find("input").val('');
            $(this).closest('tr').find("textarea").val('');
        }
    });
    $('body').on('click', '.ser_master_add', function () {
        var servicename = $('.servicename:last').val();
        var serviceprice = $('.serviceprice:last').val();
        if (servicename == '' || serviceprice == '') {
            swal("Enter valid service master entry");
        } else {
            var clid = $(".cole_master_div:last").attr('rowid');
            var nxt = parseFloat(clid) + 1;
            var bc = $(".service_masterdiv").clone();
            bc.attr("rowid", nxt);
            var dd = bc.find("input");
            dd.val("");
            var dd = bc.find("textarea");
            dd.val("");
            bc.removeClass('service_masterdiv');
            bc.appendTo(".servicemasterdiv");
        }
    });
    $('body').on('click', '.ser_new_search', function () {
        var selid = $(this).closest('tbody').attr('id-cl_ser');
//        var ser_mastter_id_newtr = $('.serv_tbltr:last').attr('id-newtr');
//        if (ser_mastter_id_newtr) {
//            var ser_mas_idcl = selid+'_'+ser_mastter_id_newtr;
//        } else {
//            var ser_mas_idcl = selid+'_'+1;
//        }
//        var sel_count = 1;
        var ser_mas_idcl = 0;
        $('#hiddn_ser_mas_idcl').val(ser_mas_idcl);
        var searchkeyword = $(this).val();
        var option = '';
        var count = 1;
        var new_array = [];
        var length1 = 10;
        var sellingprice = '';
        var selling_price = '';
        for (var i = 0; i < item_json.length; i++) {
            if (item_json[i]['item_type'] == 'service' || item_json[i]['item_type'] == 'inventory_and_service' || item_json[i]['item_type'] == 'inventory and service') {
                new_array.push(item_json[i]);
            }
        }
        if (new_array.length < 10) {
            length1 = new_array.length;
        }
        for (var i = 0; i < length1; i++) {
            if (new_array[i]['item_type'] == 'inventory_and_service') {
                new_array[i]['item_type'] = 'inventory and service';
            }
            var item_det = JSON.stringify(new_array[i]);
            var newTemp = item_det.replace(/"/g, '\'');
            option += '<tr class="sec_grid_sm">'
            option += '<td class="pa-5 vat">' + count + '</td> '
            option += '<td class="pa-5 vat">'
            if (new_array[i]['sac']) {
                option += new_array[i]['sac'];
            } else {
                option += "";
            }
            option += '</td>'

            option += '<td class="pa-5 vat">' + new_array[i]['name'] + '</td>'
            option += '<td class="pa-5 vat">'
            if (new_array[i]['item_type'] == 'inventory_and_service') {
                option += 'inventory and service'
            } else {
                option += new_array[i]['item_type'];
            }
            option += '</td>'
            option += '<td class="pa-5 vat">'
            if (new_array[i]['sellingprice']) {
                sellingprice = new_array[i]['sellingprice'];
                selling_price = Number(sellingprice).toFixed(2);
                option += selling_price;
            } else {
                option += "";
            }
            option += '</td>'
            option += '<td class="pa-5 vat">'
            option += '<label style="display:none;" id="pdt_ser_name' + new_array[i]['item_id'] + '">' + new_array[i]['name'] + '</label>'
            option += '<input type="hidden" id="pdt_ser_id' + new_array[i]['item_id'] + '" value="' + new_array[i]['item_id'] + '">'
            option += '<input type="hidden" id="pdt_ser_sku' + new_array[i]['item_id'] + '" value="' + new_array[i]['sku'] + '">'
            option += '<input type="hidden" id="pdt_ser_sell_price' + new_array[i]['item_id'] + '" value="' + new_array[i]['sellingprice'] + '">'
            option += '<input type="hidden" id="pdt_ser_pur_price' + new_array[i]['item_id'] + '" value="' + new_array[i]['purchase_price'] + '">'
            option += '<input type="hidden" id="pdt_ser_unit' + new_array[i]['item_id'] + '" value="' + new_array[i]['unit_code'] + '">'
            option += '<input type="hidden" id="pdt_ser_type' + new_array[i]['item_id'] + '" value="' + new_array[i]['item_type'] + '">'
            option += '<input type="hidden" id="tot_qty' + new_array[i]['item_id'] + '" value="' + new_array[i]['total_quantity'] + '">'
            option += '<input type="hidden" id="ser_intra_sales_account_id_hidden' + new_array[i]['item_id'] + '" value="' + new_array[i]['intra_sales_account_id'] + '">'
            option += '<input type="hidden" id="ser_inter_sales_account_id_hidden' + new_array[i]['item_id'] + '" value="' + new_array[i]['inter_sales_account_id'] + '">'
            option += '<input type="hidden" id="ser_export_sales_account_id_hidden' + new_array[i]['item_id'] + '" value="' + new_array[i]['export_sales_account_id'] + '">'
            option += '<input type="hidden" id="ser_service_sales_account_id_hidden' + new_array[i]['item_id'] + '" value="' + new_array[i]['service_sales_account_id'] + '">'
            option += '<input type="hidden" id="item_taxtype' + new_array[i]['item_id'] + '" value="' + new_array[i]['tax_type'] + '">'
            option += '<input type="hidden" id="bcd' + new_array[i]['item_id'] + '" value="' + new_array[i]['common_barcode'] + '">'
            option += '<input type="hidden" id="barcode_type' + new_array[i]['item_id'] + '" value="' + new_array[i]['tax_type'] + '">'
            option += '<button type="button" class="btn btn-primary btn-flat  pickservice2 product_search" jcoded="' + newTemp + '" data-toggle="tooltip" id="product_search" sl-cl="" ser_mast_idcl="' + ser_mas_idcl + '" sel-id="' + new_array[i]['item_id'] + '"  status="whole"  value="' + new_array[i]['item_id'] + '"><i class="icon lindo-tick fz-24 m-p-w"></i> </button>'
            option += '</td>'
            option += '</tr>';
            count++;
        }
        $('#search_service2 .servicesearch').html(option);
        $("#trid_ser_search").val(selid);
    });
    $('body').on('click', '.ser_new', function () {
        $('#AddService').find('select,checkbox,textarea,radio').val('');

        $('#AddService').find('input').each(function () {
            if ($(this).hasClass('sermastadefault')) {

            } else {
                $(this).val('');
            }
        });
        //
        //         <-----anju for tax------>
        $('#AddService #tax_type_inclu').prop('checked', true);
        $('#AddService #tax_type_inclu').val('inclusive');
        $('#AddService #tax_type_exclu').val('exclusive');

//         <-----END------>
        var selid = $(this).closest('tbody').attr('id-cl_ser');
        var iditem = $(this).closest('tbody').find('.serviceid_ser').val();
        var page_type_checking = $('#page_type_checking').val();
        if (page_type_checking) {
            $('#AddService .page_type').val(page_type_checking);
        }
        $("#trid_ser").val(selid);
        $("#item_id_bind").val(iditem);
    });
    $('body').on('click', '.add_cos_clone', function () {
        var clone_radio_count = 1;
        var cost_cntr = $('.cost_center:last').val();
        var cat = $('.cost_center_category:last').val();
        var est = $('.estimate:last').val();
        if (cost_cntr == '' || cat == '' || cost_cntr == 'select' || cat == 'select' || est == '' || est == 0) {
            swal("Enter valid cost center entry");
        } else {
            var clid = $(".cld_costcentr:last").attr('id-cl');
            var nxt = parseFloat(clid) + 1;
            var bc = $(".clone_cost_center_div").clone();
            bc.attr("id-cl", nxt);
            var dd = bc.find("input");
            dd.val("");
            bc.find('input[type="radio"]').attr('name', 'estimate_radio' + nxt);
            var abc = 'estimate_radio' + nxt;
            bc.find('input[name=' + abc + ']').attr('checked', false);
            $('.remove_cos_clone').show();
            bc.removeClass('clone_cost_center_div');
            bc.appendTo(".cost_center_div");
        }
    });
    $('body').on('click', '.remove_cos_clone', function (e) {
        var cost_per_unit = $('#AddService #ser_unitcoste').val();
        var clone_id = $(".cld_costcentr:last").attr('id-cl');
        if (clone_id != 1)
        {
            $('.cld_costcentr:last').closest('div').remove();
        } else
        {
            var dd = $('.cld_costcentr:last').find("input");
            dd.val("");
            $(this).closest('.cld_costcentr:last').find('.cost_center').val('');
            $(this).closest('.cld_costcentr:last').find('.cost_center_category').val('');
        }
        var sum = 0;
        $('.ind_final_rate').each(function () {
            sum += Number($(this).val());
        });
        $('.final_rate_total').val(sum);

        var option = '';
        var profit_loss = 0;
        profit_loss = parseFloat(cost_per_unit) - parseFloat(sum);
        if (parseFloat(profit_loss) > 0) {
            option += ' <label class="control-label txt-success">Profit:' + parseFloat(profit_loss) + '</label>'

        } else if (parseFloat(profit_loss) < 0) {
            option += ' <label class="control-label txt-danger">Loss:' + parseFloat(profit_loss) + '</label>'
        }
        $('.profit_loss_direct_div').html(option);
    });
    $("body").on('change', '.cost_center', function () {
        var rowid = $(this).closest('div .div_clone').attr('id-cl');
        var sll = $('[id-cl=' + rowid + ']');
        var cost_center_id = $(this).val();
        $('#jquery_mask').show();
        $.post(siteurl + "/Crm/Deals/get_costcenter_category_by_id", {cost_center_id: cost_center_id}, function (data) {
            $('#jquery_mask').hide();
            sll.find('.cost_center_category').html(data);
        });
    });
    $("body").on('change', '.cost_center_category', function () {
        var category_id = $(this).val();
        var rowid = $(this).closest('div .div_clone').attr('id-cl');
        var sll = $('[id-cl=' + rowid + ']');
        $('#jquery_mask').show();
        $.post(siteurl + "/Crm/Deals/get_rate_category_by_id", {category_id: category_id}, function (data) {
            $('#jquery_mask').hide();
            var rate = JSON.parse(data);
            var hourly_rate = (rate['rate_details'][0]['hourly_rate']);
            var day_rate = (rate['working_hour'][0]['working_hours']);
            var rate_id = (rate['rate_details'][0]['rate_master_id']);
            sll.find('.rate_master_id').val(rate_id);
            sll.find('.rate_by_category').val(hourly_rate);
            sll.find('.day_hour').val(day_rate);
        });
    });
    $("body").on('keyup', '.estimate', function () {
        var cost_per_unit = $('#ser_unitcoste').val();
        if (cost_per_unit == '') {
            cost_per_unit = 0;
        }
        var rowid = $(this).closest('div .div_clone  ').attr('id-cl');
        var sll = $('[id-cl=' + rowid + ']');
        var aa = sll.find('#cost_center');
        var bb = sll.find('#cost_center_category');
        var cc = sll.find('#amount');
        var fb = sll.find('#cost_type');
        var dd = sll.find('#rate_by_category');
        var ds = sll.find('#day_hour');
        var di = sll.find('#estimate');
        var tt = $('.final_rate_total');
        var tc = $('#full_cost_center');
        var tcc = $('#full_cost_center_category');
        var tra = $('#ind_rate');
        var tsa = $('#ind_type');
        var est = $('#ind_estimate_value');
        var estf = $('#rate_id_full');
        if (aa.val()) {
            var cost_center = aa.val();
        }
        if (bb.val()) {
            var cost_center_category = bb.val();
        }
        if (dd.val()) {
            var rate_by_category = dd.val();
        }
        if (ds.val()) {
            var day_hour = ds.val();
        }
        if (di.val()) {
            var input_rate = di.val();
        }
        if (fb.val()) {
            var type_ind = fb.val();
        }
        var input_rate = $(this).val();
        var rate_by_category = sll.find('.rate_by_category').val();
        var rate_day = sll.find('.day_hour').val();
        var rate_day = Number(rate_day) * Number(rate_by_category);
        var type = '';
        var typearray = [];
        if (sll.find('.estimate_radio_hour').is(':checked')) {
            var final_rate = Number(input_rate) * Number(rate_by_category);
            var type = 'hour';
            sll.find('.ind_final_rate').val(final_rate);
            sll.find('.cost_type').val(type);
            sll.find('.rate_db').val(rate_by_category);
        } else if (sll.find('.estimate_radio_day').is(':checked')) {
            var type = 'day';
            var final_rate = Number(input_rate) * Number(rate_day);
            sll.find('.ind_final_rate').val(final_rate);
            sll.find('.cost_type').val(type);
            sll.find('.rate_db').val(rate_day);
        }
        var sum = 0;
        var ratearray = [];
        $('.ind_final_rate').each(function () {
            sum += Number($(this).val());
            ratearray.push($(this).val());
        });
        var cosarray = [];
        var coscatarray = [];
        var ratearray_ind = [];
        var estimate_ind = [];
        var full_ra_id = [];
        $('.cost_center').each(function () {
            cosarray.push($(this).val());
        });
        $('.cost_center_category').each(function () {
            coscatarray.push($(this).val());
        });
        $('.rate_db').each(function () {
            ratearray_ind.push($(this).val());
        });
        $('.cost_type').each(function () {
            typearray.push($(this).val());
        });
        $('.estimate').each(function () {
            estimate_ind.push($(this).val());
        });
        $('.rate_master_id').each(function () {
            full_ra_id.push($(this).val());
        });
        var option = '';
        var profit_loss = 0;
        profit_loss = parseFloat(cost_per_unit) - parseFloat(sum);
        if (parseFloat(profit_loss) > 0) {
            option += ' <label class="control-label txt-success">Profit:' + parseFloat(profit_loss) + '</label>'

        } else if (parseFloat(profit_loss) < 0) {
            option += ' <label class="control-label txt-danger">Loss:' + parseFloat(profit_loss) + '</label>'
        }
        $('.profit_loss_direct_div').html(option);
        tt.val(parseFloat(sum));
        tra.val(ratearray);
        tsa.val(typearray);
        tc.val(cosarray);
        tcc.val(coscatarray);
        tra.val(ratearray_ind);
        est.val(estimate_ind);
        estf.val(full_ra_id);
    });

    $('body').on('click', '.copyorgmember_ser', function (e) {

        var pdt_title = $('#ser_new:last').val();
        var ser_unitcost = $('.ser_unitcost:last').val();
        var page_type_checking = $('.page_type_checking:last').val();
        var quan = $('.ser_quan:last').val();
        var ser_amount = $('.ser_amount:last').val();
        if (pdt_title == '' || ser_unitcost === '' || quan == '' || quan == 0) {
            swal("Please enter valid entry");
        } else {
            e.preventDefault();
            var clid = $(".cld_ser:last").attr('id-cl_ser');
            var nxt = parseFloat(clid) + 1;
            var bc = $(".clone_ser").clone();
            bc.attr("id-cl_ser", nxt);
            var dd = bc.find("input");
            dd.val("");
            bc.find(".ser_barcodes").html('');
            bc.find(".accessories").val('');
            bc.find(".item_comments_grv").val('');
            var dd = bc.find("#view_details");
            dd.attr('iditem', '');
            var dd = bc.find("#view_history");
            dd.attr('iditem', '');
            var gp = bc.find(".page_type_checking");
            gp.val(page_type_checking);
            bc.removeClass('clone_ser');
            bc.find('.clear_ser').remove();
            bc.find('.serv_tbltr').remove();
            bc.find('.ser_new_search').removeClass('no-display');
            bc.find('.ser_dis').attr('ser_from_disc', 'ser_per_dicount');
            bc.find('.ser_newww').hide();
            bc.find(".ser_new").prop('disabled', false);
            bc.find(".fast_track").prop('checked', false);
            var cc = bc.find('.no-display');
            cc.removeClass('no-display');
            bc.find(".ser_barcodes").addClass('no-display');
            bc.appendTo(".table-append_service_common");
        }
    });
    $('body').on('keyup', '.ser_quan,.ser_unitcost', function () {
        var currency_rate = $('#currency_rate').val();
        var common_page = $('.page_check_common').val();
        if (common_page == 'deal') {
            $("#deal_stage")[0].selectedIndex = 0;
            $("#probability").val('');
            $("#expected_revenue").val('');
        }
        var rowid = $(this).closest('tr').attr('id-newtr');
        var sll = $('[id-newtr=' + rowid + ']');
        calculate_ser_row_total(sll);
        service_subtotal_calculation();
        calculate_grandtotal();
    });
    $('body').on('blur', '.ser_dis', function () {
        var rowid = $(this).closest('tr').attr('id-newtr');
        var sll = $('[id-newtr=' + rowid + ']');
        var discount_percentage = $(this).val();
        var ser_rate = sll.find('.ser_unitcost').val();
        var ser_quan = sll.find('.ser_quan').val();
        var ser_amount = ser_rate * ser_quan;
        var percent = (parseFloat(discount_percentage) * ser_amount / parseFloat(100));
        if (isNaN(percent)) {
            var percent = 0;
        }
        sll.find('.ser_item_dis_amt').val(parseFloat(percent).toFixed(2));
        calculate_ser_row_total(sll);
        service_subtotal_calculation();
        calculate_grandtotal();
    });

    $('body').on('keyup', '.ser_item_dis_amt', function () {
        var rowid = $(this).closest('tr').attr('id-newtr');
        var sll = $('[id-newtr=' + rowid + ']');
        calculate_ser_row_total(sll);
        service_subtotal_calculation();
        calculate_grandtotal();
    });
    $('body').on('click', '.clear_ser', function (e) {
        e.preventDefault();
        var serv_id = $(this).closest('tbody').find('.salesorder_service_id_hidden').val();
        var deleteidd = $('.deleted_ser_ids').val();
        var deleteids = [];
        if (deleteidd != '') {
            deleteids = deleteidd.split(',');
        }
        deleteids.push(serv_id);
        $('.deleted_ser_ids').val(deleteids);

        var page_type_checking = $(this).closest('tbody').find('.page_type_checking').val();

        $(this).closest('tbody').find('.div_moneyholder span').html('');
        $(this).closest('tbody').find('input,select,checkbox').val('');
        $(this).closest('tbody').find('.ser_new_search').removeClass('no-display');
        $(this).closest('tbody').find('.ser_newww').addClass('no-display');
        $(this).closest('tbody').find(".ser_new").prop('disabled', false);
        $(this).closest('tbody').find('.serv_tbltr').remove();
        $(this).closest('tbody').find('.page_type_checking').val(page_type_checking);
        service_subtotal_calculation();
        calculate_grandtotal();



        ///////////iiiiiiiiiiiiiiiiiii
        var service_discount = 0;
        $('body').find('.ser_dist_amt').each(function () {
            if ($(this).val() != '')
            {
                service_discount += parseFloat($(this).val());
            }
        });
        $('#ser_discount').val(parseFloat(service_discount).toFixed(2));
        //anjup for tax-------------->
        for ($i = 0; $i < alltax_details.length; $i++) {
            var totaltaxmaster_amount = 0;
            $('body').find('.ser_tax_details_' + alltax_details[$i]['tax_master_id']).each(function () {
                var taxamount_i = 0;
                if ($(this).val() != '') {
                    var res = $(this).val().split(':');
                    taxamount_i = Number(res[1]);
                }

                totaltaxmaster_amount += taxamount_i;
            });
            $('#ser_ttltaxamnt_' + alltax_details[$i]['tax_master_id']).val(totaltaxmaster_amount);
        }
        //END<------------------------


        //for sercice and product total ie. for net amount 
        var service_amt = 0;
        $('body').find('.ser_amount').each(function () {
            if ($(this).val() != '')
            {
                service_amt += parseFloat($(this).val());
            }
        });

        var other_amount = 0;
        $('.charge_amount').each(function () {
            other_amount += Number($(this).val());
        });

        var amc_amount = 0;
        $('.amc_amount').each(function () {
            amc_amount += Number($(this).val());
        });

        $('#ser_total').val(parseFloat(service_amt).toFixed(2));
        if ($('#pro_total').val() != "")
        {
            var final = parseFloat($('#pro_total').val()) + parseFloat($('#ser_total').val()) + parseFloat(other_amount) + parseFloat(amc_amount);
            $('#net_amt').val(parseFloat(final).toFixed(2));
            $('#hidden_pro_total').val(parseFloat(final).toFixed(2));
        } else {
            var final = parseFloat($('#ser_total').val()) + parseFloat(other_amount) + parseFloat(amc_amount);
            $('#net_amt').val(parseFloat(final).toFixed(2));
            $('#hidden_pro_total').val(parseFloat(final).toFixed(2));
        }
        var deal_stage_id = $('#deal_stage').val();
        $('#jquery_mask').show();

        if (deal_stage_id != 0) {
            $.post(siteurl + "/Crm/Deals/get_dealstage_by_id", {deal_stage_id: deal_stage_id}, function (result)
            {
                $('#jquery_mask').hide();
                var prob = result;
                $('#probability').val(result);
                var expected_amount = (parseFloat(parseFloat($('#net_amt').val()) * parseFloat(prob)) / 100);
                $('#expected_revenue').val(expected_amount);
            });
        } else {
            $('#jquery_mask').hide();
            var expected_amount = 0;
            $('#expected_revenue').val(expected_amount);
        }

        $("#net_amt").trigger("change");
        $('#common_percentage_amount').trigger("change");
    });
    $("body").on('change', '#ser_unitcoste_search', function () {
        var cost_per_unit = $(this).val();
        if (cost_per_unit == '') {
            cost_per_unit = 0;
        }
        var sum = 0;
        $('.ind_final_rate_search').each(function () {
            sum += Number($(this).val());
        });
        var option = '';
        var profit_loss = 0;
        profit_loss = parseFloat(cost_per_unit) - parseFloat(sum);
        if (parseFloat(profit_loss) > 0) {
            option += ' <label class="control-label txt-success">Profit:' + parseFloat(profit_loss) + '</label>'

        } else if (parseFloat(profit_loss) < 0) {
            option += ' <label class="control-label txt-danger">Loss:' + parseFloat(profit_loss) + '</label>'
        }
        $('.profit_loss_div').html(option);

    });
    $("body").on('keyup', '.estimate_search', function () {
        var cost_per_unit = $('#ser_unitcoste_search').val();
        if (cost_per_unit == '') {
            cost_per_unit = 0;
        }
        var rowid = $(this).closest('div .div_clone_search  ').attr('cl');
        var sll = $('[cl=' + rowid + ']');
        var aa = sll.find('#cost_center_search');
        var bb = sll.find('#cost_center_category_search');
        var cc = sll.find('#amount_search');
        var fb = sll.find('#cost_type_search');
        var dd = sll.find('#rate_by_category_search');
        var ds = sll.find('#day_hour_search');
        var di = sll.find('#estimate_search');
        var tt = $('#final_rate_total_search');
        var tc = $('#full_cost_center_search');
        var tcc = $('#full_cost_center_category_search');
        var tra = $('#ind_rate_search');
        var tsa = $('#ind_type_search');
        var est = $('#ind_estimate_value_search');
        var estf = $('#rate_id_full_search');
        if (aa.val()) {
            var cost_center = aa.val();
        }
        if (bb.val()) {
            var cost_center_category = bb.val();
        }
        if (dd.val()) {
            var rate_by_category = dd.val();
        }
        if (ds.val()) {
            var day_hour = ds.val();
        }
        if (di.val()) {
            var input_rate = di.val();
        }
        if (fb.val()) {
            var type_ind = fb.val();
        }
        var input_rate = $(this).val();
        var rate_by_category = sll.find('.rate_by_category_search').val();
        var rate_day = sll.find('.day_hour_search').val();
        var rate_day = Number(rate_day) * Number(rate_by_category);
        var type = '';
        var typearray = [];
        if (sll.find('.estimate_radio_hour_search').is(':checked')) {
            var final_rate = Number(input_rate) * Number(rate_by_category);
            var type = 'hour';
            sll.find('.ind_final_rate_search').val(final_rate);
            sll.find('.cost_type_search').val(type);
            sll.find('.rate_db_search').val(rate_by_category);
        } else if (sll.find('.estimate_radio_day_search').is(':checked')) {
            var type = 'day';
            var final_rate = Number(input_rate) * Number(rate_day);
            sll.find('.ind_final_rate_search').val(final_rate);
            sll.find('.cost_type_search').val(type);
            sll.find('.rate_db_search').val(rate_day);
        }
        var sum = 0;
        var ratearray = [];
        $('.ind_final_rate_search').each(function () {
            sum += Number($(this).val());
            ratearray.push($(this).val());
        });
        var cosarray = [];
        var coscatarray = [];
        var ratearray_ind = [];
        var estimate_ind = [];
        var full_ra_id = [];
        $('.cost_center_search').each(function () {
            cosarray.push($(this).val());
        });
        $('.cost_center_category_search').each(function () {
            coscatarray.push($(this).val());
        });
        $('.rate_db_search').each(function () {
            ratearray_ind.push($(this).val());
        });
        $('.cost_type_search').each(function () {
            typearray.push($(this).val());
        });
        $('.estimate_search').each(function () {
            estimate_ind.push($(this).val());
        });
        $('.rate_master_id_search').each(function () {
            full_ra_id.push($(this).val());
        });
        tt.val(parseFloat(sum));
        tra.val(ratearray);
        tsa.val(typearray);
        tc.val(cosarray);
        tcc.val(coscatarray);
        tra.val(ratearray_ind);
        est.val(estimate_ind);
        estf.val(full_ra_id);
        var option = '';
        var profit_loss = 0;
        profit_loss = parseFloat(cost_per_unit) - parseFloat(sum);
        if (parseFloat(profit_loss) > 0) {
            option += ' <label class="control-label txt-success">Profit:' + parseFloat(profit_loss) + '</label>'

        } else if (parseFloat(profit_loss) < 0) {
            option += ' <label class="control-label txt-danger">Loss:' + parseFloat(profit_loss) + '</label>'
        }
        $('.profit_loss_div').html(option);
    });
    $("body").on('click', '.estmt_rdio', function () {
        var cost_per_unit = $('#ser_unitcoste_search').val();
        if (cost_per_unit == '') {
            cost_per_unit = 0;
        }
        var rowid = $(this).closest('div .div_clone_search  ').attr('cl');
        var sll = $('[cl=' + rowid + ']');
        var aa = sll.find('#cost_center_search');
        var bb = sll.find('#cost_center_category_search');
        var cc = sll.find('#amount_search');
        var fb = sll.find('#cost_type_search');
        var dd = sll.find('#rate_by_category_search');
        var ds = sll.find('#day_hour_search');
        var di = sll.find('#estimate_search');
        var tt = $('#final_rate_total_search');
        var tc = $('#full_cost_center_search');
        var tcc = $('#full_cost_center_category_search');
        var tra = $('#ind_rate_search');
        var tsa = $('#ind_type_search');
        var est = $('#ind_estimate_value_search');
        var estf = $('#rate_id_full_search');
        if (aa.val()) {
            var cost_center = aa.val();
        }
        if (bb.val()) {
            var cost_center_category = bb.val();
        }
        if (dd.val()) {
            var rate_by_category = dd.val();
        }
        if (ds.val()) {
            var day_hour = ds.val();
        }
        if (di.val()) {
            var input_rate = di.val();
        }
        if (fb.val()) {
            var type_ind = fb.val();
        }
        var input_rate = sll.find('.estimate_search').val();
        var rate_by_category = sll.find('.rate_by_category_search').val();
        var rate_day = sll.find('.day_hour_search').val();
        var rate_day = Number(rate_day) * Number(rate_by_category);
        var type = '';
        var typearray = [];
        if (sll.find('.estimate_radio_hour_search').is(':checked')) {
            var final_rate = Number(input_rate) * Number(rate_by_category);
            var type = 'hour';
            sll.find('.ind_final_rate_search').val(final_rate);
            sll.find('.cost_type_search').val(type);
            sll.find('.rate_db_search').val(rate_by_category);
        } else if (sll.find('.estimate_radio_day_search').is(':checked')) {
            var type = 'day';
            var final_rate = Number(input_rate) * Number(rate_day);
            sll.find('.ind_final_rate_search').val(final_rate);
            sll.find('.cost_type_search').val(type);
            sll.find('.rate_db_search').val(rate_day);
        }
        var sum = 0;
        var ratearray = [];
        $('.ind_final_rate_search').each(function () {
            sum += Number($(this).val());
            ratearray.push($(this).val());
        });
        var cosarray = [];
        var coscatarray = [];
        var ratearray_ind = [];
        var estimate_ind = [];
        var full_ra_id = [];
        $('.cost_center_search').each(function () {
            cosarray.push($(this).val());
        });
        $('.cost_center_category_search').each(function () {
            coscatarray.push($(this).val());
        });
        $('.rate_db_search').each(function () {
            ratearray_ind.push($(this).val());
        });
        $('.cost_type_search').each(function () {
            typearray.push($(this).val());
        });
        $('.estimate_search').each(function () {
            estimate_ind.push($(this).val());
        });
        $('.rate_master_id_search').each(function () {
            full_ra_id.push($(this).val());
        });
        tt.val(parseFloat(sum));
        tra.val(ratearray);
        tsa.val(typearray);
        tc.val(cosarray);
        tcc.val(coscatarray);
        tra.val(ratearray_ind);
        est.val(estimate_ind);
        estf.val(full_ra_id);
        var option = '';
        var profit_loss = 0;
        profit_loss = parseFloat(cost_per_unit) - parseFloat(sum);
        if (parseFloat(profit_loss) > 0) {
            option += ' <label class="control-label txt-success">Profit:' + parseFloat(profit_loss) + '</label>'

        } else if (parseFloat(profit_loss) < 0) {
            option += ' <label class="control-label txt-danger">Loss:' + parseFloat(profit_loss) + '</label>'
        }
        $('.profit_loss_div').html(option);
    });
    $("body").on('change', '.cost_center_search', function () {
        var row = $(this).closest('div .div_clone_search').attr('cl');
        var sll = $('[cl=' + row + ']');
        var cost_center_id = $(this).val();
        $('#jquery_mask').show();
        $.post(siteurl + "/Crm/Deals/get_costcenter_category_by_id", {cost_center_id: cost_center_id}, function (data) {
            $('#jquery_mask').hide();
            sll.find('.cost_center_category_search').html(data);
        });
    });
    $("body").on('change', '.cost_center_category_search', function () {
        var category_id = $(this).val();
        var rowid = $(this).closest('div .div_clone_search').attr('cl');
        var sll = $('[cl=' + rowid + ']');
        $('#jquery_mask').show();
        $.post(siteurl + "/Crm/Deals/get_rate_category_by_id", {category_id: category_id}, function (data) {
            $('#jquery_mask').hide();
            var rate = JSON.parse(data);
            var hourly_rate = (rate['rate_details'][0]['hourly_rate']);
            var day_rate = (rate['working_hour'][0]['working_hours']);
            var rate_id = (rate['rate_details'][0]['rate_master_id']);
            sll.find('.rate_master_id_search').val(rate_id);
            sll.find('.rate_by_category_search').val(hourly_rate);
            sll.find('.day_hour_search').val(day_rate);
        });
    });
    $('body').on('click', '.add_cos_clone_search', function () {

        var clone_radio_count = 1;
        var cost_cntr = $('#addservice_search .cost_center_search:last').val();
        var cat = $('#addservice_search .cost_center_category_search:last').val();
        var est = $('#addservice_search .estimate_search:last').val();
        if (cost_cntr == '' || cat == '' || cost_cntr == 'select' || cat == 'select' || est == '' || est == 0) {
            swal("Enter valid cost center entry");
        } else {
            var clid = $("#addservice_search .cld_costcentr_search:last").attr('cl');
            var nxt = parseFloat(clid) + 1;
            var bc = $("#addservice_search .clone_cost_center_div_search").clone();
            bc.attr("cl", nxt);
            var dd = bc.find("input");
            dd.val("");
            bc.find('input[type="radio"]').attr('name', 'estimate_radio_search' + nxt); //        var ee = bc.find("radio");
            var abc = 'estimate_radio_search' + nxt;
            bc.find('input[name=' + abc + ']').attr('checked', false);
            $('#addservice_search .remove_cos_clone_search').show();
            bc.removeClass('clone_cost_center_div_search');
            bc.appendTo("#addservice_search .cost_center_div_search");
        }
    });
    $('body').on('click', '#new_charges', function () {
        var charge_amount = $('#charge').val();
        var charge_amount_hidden = $('#charge_hidden').val();
        var charge_id = $('#asso_extra_chrg').val();
        var charge_discription = $('#charge_discription').val();
        var charge_paid_by = $('#charge_paid_by').val();
        var charge_paid_by2 = $('.charge_paid_by_cls').val();
        var selectunit = $('.selectunit').val();
        var select_unit_text = $('.selectunit option:selected').text();
        var qty = $('.ch_qty').val();
        $('.editts').show();
        $('.editts').removeClass('no-display');
        $(".adds_pick").addClass('no-display');
        $('.adds').hide();
        if (charge_amount == '' || charge_discription == '' || charge_paid_by2 == '' || charge_amount == 0 || selectunit == "" || qty == "") {
            swal('Please enter valid entry');
            if (charge_amount == '' || charge_amount == 0) {
                $('#charge').css('border', '1px solid red');
            }
        } else if (charge_amount != '' || charge_discription != '') {

            var charge_description = $('#charge_discription').val();
            var charge_paidby = $("input[name='charge_paid_by']").val();
            var chrg_name = $('#asso_extra_chrg option:selected').attr('charg_name');
            var sid = $('#trid_charge').val();
            var sll = $('[id-cl_charge=' + sid + ']');
            var sum3 = sll.find('.charge_amount').val();
            var ff = sll.find('.associated_chrg_id');
            ff.val(charge_id);
            var chrg = sll.find('.charge_name_t');
            chrg.text(chrg_name);
            var chrg2 = sll.find('.charge_name_new');
            chrg2.val(chrg_name);
            var paid_by = sll.find('.charge_paidby');
            paid_by.val(charge_paidby);
            var amountt = sll.find('.charge_amount_t');
            amountt.text(charge_amount);
//            if (charge_paidby == "customer") {
            var ii = sll.find('.charge_amount');
            ii.val(charge_amount);
//            }
            var qq = sll.find('.charge_description');
            qq.val(charge_description);
            var qqs = sll.find('.charge_description_t');
            qqs.text(charge_description);
            var qqp = sll.find('.charge_paidby');
            qqp.val(charge_paidby);
//            var qqpg = sll.find('.charge_paidby_t');
//            qqpg.text(charge_paidby);

            var chargeamount = Number(qty) * Number(charge_amount);
            sll.find('.charge_unit_t').html(select_unit_text);
            sll.find('.charge_unit').val(selectunit);
            sll.find('.charge_qty_t').html(qty);
            sll.find('.charge_qty').val(qty);
            sll.find('.charge_charge_t').html(charge_amount);
            sll.find('.charge_charge').val(charge_amount);
            sll.find('.charge_amount_t').html(chargeamount);
            sll.find('.charge_amount').val(chargeamount);
            var sum = 0;
            var sum1 = $('#net_amt').val();
            var sum22 = $('#hidden_pro_total').val();
            var sum2 = 0;
            var ss = $('#charge').val();
            var ss = chargeamount;
            var ss1 = $('#charge_hidden').val();
            sum2 = Number(ss) - Number(ss1);
            sum1 = Number(sum1) + Number(sum2);
            var sum221 = Number(sum22) + Number(sum2);
            $('#net_amt').val(sum1);
            var transaction_rate = $('#currency_rate').val();
            if (transaction_rate == 'undefined' && transaction_rate == '') {
                transaction_rate = 1;
            }
            $('#transaction_currency').val(parseFloat(sum1).toFixed(2) / parseFloat(transaction_rate));
            $('#hidden_pro_total').val(sum221);
            $('#net_amt').trigger("change");
            $('#Othercharges').modal('hide');
        } else {

            $('#charge').css('border', '1px solid red');
            $('#asso_extra_chrg').css('border', '1px solid red');
        }
        calculate_grandtotal();
    });
    $('body').on('click', '.charge_new', function () {
        var selid = $(this).closest('tr').attr('id-cl_charge');
        $('#asso_extra_chrg').val('').trigger("change");
        $('#charge').val(0);
        $('#charge_hidden').val(0);
        $('#charge_discription').val('');
        $('#selectunit').val('');
        $('#ch_qty').val('');
        $("#trid_charge").val(selid);
    });
    $('body').on('click', '.clear_charge', function (e) {
        e.preventDefault();
        var sum2 = 0;
        var cur_rate = $('#currency_rate').val();
        var charge = $(this).closest('tr').find('.charge_amount').val();
        if (charge != '') {
            var charge_paidby = $(this).closest('tr').find('.charge_paidby').val();
            if (charge_paidby == "customer") {
                sum2 += Number(charge);
            }
            var sum1 = $('#net_amt').val();
            var sum3 = Number(sum1) - Number(charge);
            $('#net_amt').val(sum3);

            //nid last
            var transaction_rate = $('#currency_rate').val();
            if (transaction_rate == 'undefined' && transaction_rate == '') {
                transaction_rate = 1;
            }
            $('#transaction_currency').val(parseFloat(sum3).toFixed(2) / parseFloat(transaction_rate));
            var sum22 = $('#hidden_pro_total').val();
            var sum221 = Number(sum22) - Number(charge);
            $('#hidden_pro_total').val(parseFloat(sum221).toFixed(2));
            var amount_transaction_currency = parseFloat(sum3) * parseFloat(cur_rate);
            $('.transaction_rate_value span:last').html(amount_transaction_currency.toFixed(2));
            $(this).closest('tr').find('input,select,checkbox').val('');
            $(this).closest('tr').find('.charge_name_t').text('');
            $(this).closest('tr').find('.charge_amount_t').text('');
            $(this).closest('tr').find('.charge_description_t').text('');
            $(this).closest('tr').find('.charge_unit_t').text('');
            $(this).closest('tr').find('.charge_qty_t').text('');
            $(this).closest('tr').find('.charge_charge_t').text('');


            $(this).closest('tr').find(".editts").hide();
            $(this).closest('tr').find(".adds").show();
            $(this).closest('tr').find(".adds_pick").removeClass('no-display');
            var charge_a = 0;
            $('.charge_amount').each(function () {
                charge_a += $(this).val();
            });
            $('#charge').val(parseFloat(charge_a));
//            $('#common_percen tage_amount').trigger("change");
        }
        calculate_grandtotal();
    });
    $('body').on('click', '.copyorgmember_charge', function (e) {
        var amt = $('.charge_amount:last').val();
        if (amt == '') {
            swal("Enter valid other charge entry");
        } else {
            e.preventDefault();
            var clid = $(".cld_charge:last").attr('id-cl_charge');
            var nxt = parseFloat(clid) + 1;
            var bc = $(".clone_charge").clone();
            bc.attr("id-cl_charge", nxt);
            var dd = bc.find("input");
            bc.find(".charge_name_t").text('');
            bc.find(".charge_amount_t").text('');
            bc.find(".charge_description_t").text('');
            bc.find(".charge_paidby_t").text('');
            bc.find(".charge_unit_t").text('');
            bc.find(".charge_qty_t").text('');
            bc.find(".charge_charge_t").text('');
            dd.val("");
            bc.removeClass('clone_charge');
            bc.find('.clear_charge').remove();
            var cc = bc.find('.no-display');
            cc.removeClass('no-display');
            bc.appendTo(".table-append_charge");
        }
        var mm = bc.find(".editts");
        mm.hide();
        var ad = bc.find(".adds");
        ad.show();

    });
    $("body").on('click', '.pickitem', function (e) {

        var currency_rate = $('#currency_rate').val();
        var page_name_item_search = $('#page_so_or_service').val();
        var direct_invoiceflag = $('.direct_invoiceflag ').val();
        if (page_name_item_search == 'service')
        {
            var item_id = $(this).attr('sel-id');
            var item_name_for_ser = $('#pdt_ser_name' + item_id).text();
            $('#item_name_service').val(item_name_for_ser);
            $('#item_id_service').val(item_id);
            $('#productlist').modal('hide');
        } else if (page_name_item_search == 'deal') {
            var id_get = $(this).attr('sel-id');
            var status = $(this).attr('status');
            var values = id_get.split('-');
            var id = values[0];
            var occurence = 0;
            var occurence1 = 0;
            if (status === "whole")
            {
                var pt_id = $('#pdt_id').val();
                $('#invoice_table .pdt_id').each(function () {
                    if ($(this).val() === id) {
                        occurence1++;
                    }
                });
                if (occurence1 > 0) {
                    swal('Alert', 'This item already picked', 'error');
                    return false;
                }
            }
            if (status === "partial")
            {
                var part_id = $('#partial_id').val();
                $('#invoice_table .partial_id').each(function () {
                    if ($(this).val() === id_get) {
                        occurence++;
                    }
                });
                if (occurence > 0) {
                    swal('Alert', 'This item already picked', 'error');
                    return false;
                }
            }
            var tot_qty = $('#tot_qty' + id).val();
            var sid = $('#trid').val();
            var sll = $('[id-cl=' + sid + ']');
            var item_name = $('#pdt_ser_name' + id).text();
            var item_pur = $('#pdt_ser_pur_price' + id).val();
            var itemsell = $('#pdt_ser_sell_price' + id).val();

            var itemsell1 = parseFloat(itemsell) * parseFloat(currency_rate);

            var item_sell = itemsell1.toFixed(2);
            var item_sell_partial = Number(item_sell) / Number(tot_qty);
            var item_unit = $('#pdt_ser_unit' + id).val();
            var item_unit_partial = $('#pdt_ser_unit_partial' + id).val();
            var item_sku = $('#pdt_ser_sku' + id).val();
            var item_type = $('#pdt_ser_type' + id).val();
            var barcode_type = $('#barcode_type' + id).val();
            var enable_tracking = $('#enable_tracking' + id).val();
            var item_barcode = $('#bcd' + id).val();

            var ll = sll.find('.tot_qty');
            ll.val(tot_qty);
            var ff = sll.find('.pdt_title');
            ff.text(item_name);
            var ff1 = sll.find('.comments_pro');
            ff1.val(item_name);
            var ii = sll.find('.pdt_id');
            ii.val(id);
            var ii = sll.find('#view_details');
            ii.attr('iditem', id);
            var ii = sll.find('#view_history');
            ii.attr('iditem', id);
            if (status == 'partial')
            {
                var jj = sll.find('.partial_id');
                jj.val(1);
                var jj1 = sll.find('.partial_selling');
                jj1.val(1);
            } else
            {
                var jj = sll.find('.partial_id');
                jj.val(0);
                var jj1 = sll.find('.partial_selling');
                jj1.val(0);
            }
            if (status == 'partial')
            {
                var mm = sll.find('.pdt_status');
                mm.val(status);
            }
            if (status == 'whole')
            {
                var mm = sll.find('.pdt_status');
                mm.val(status);
            }
            if (status == 'whole')
            {
                var ee = sll.find('.pdt_unit');
                ee.val(item_unit);
                ee.text(item_unit);
            }
            if (status == 'partial')
            {
                var ee = sll.find('.pdt_unit');
                ee.val(item_unit_partial);
                ee.text(item_unit_partial);
            }
            if (status == 'whole')
            {
                var ss = sll.find('.selling_p'); //for quote
                if (item_sell == '' || isNaN(item_sell)) {
                    ss.val(0);
                } else {
                    ss.val(item_sell);
                }

            }
            if (status == 'partial')
            {
                var ss = sll.find('.selling_p'); //for quote
                if (item_sell_partial == '' || isNaN(item_sell_partial)) {
                    ss.val(0);
                } else {
                    ss.val(item_sell_partial);
                }
            }

            var itempur = parseFloat(item_pur) * parseFloat(currency_rate);
            var qq = sll.find('.quan'); //for purchase order
            if (direct_invoiceflag == 1) {
                qq.val(0);
            } else {
                qq.val(1);
            }


            var pp = sll.find('.purchase_p'); //for quote
            if (itempur == '' || isNaN(itempur)) {
                pp.val(0);
            } else {
                pp.val(itempur.toFixed(2));
            }
            var type = sll.find('.pdt_type'); //for quote
            type.val(item_type);
            if (item_type == 'inventory_and_service') {
                item_type = 'inventory & service';
            }
            type.text(item_type);
            var sku = sll.find('.pdt_sku'); //for quote
            sku.val(item_sku);
            sku.text(item_sku);
            var sp = sll.find('.s_p'); //for quote
            sp.val('');
            var am = sll.find('.amount'); //for quote
            am.val('');
            var dis = sll.find('.dis'); //for quote
            dis.val(0);
            var dd = sll.find('#item_id');
            dd.val(id).change();
            var et = sll.find('#tracking');
            et.val(enable_tracking).change();
            var bt = sll.find('#barcode_type');
            bt.val(barcode_type).change();

            var itembarcode = sll.find('.common_barcode');      //for quote
            if (item_barcode != 'null') {
                itembarcode.val(item_barcode);
            } else {
                itembarcode.val('');
            }


            sll.find('.selling_p_hidden').val(itemsell);
            sll.find('.purchase_p_hidden').val(item_pur);
            var tax_enabled = $('#tax_enabled').val();
            if (tax_enabled != -1) {
                sll.find('.itemtaxtype_hidden').val($('#item_taxtype' + id).val());
                tax_bind_product(sll, id);//function for bind tax 
            }
            sll.find('.selitem_noninv').prop('disabled', true);
            calculate_pro_row_total(sll);
            product_subtotal_calculation()
            calculate_grandtotal();
            $("#item_Modal").modal('toggle');
            $('#productlist').modal('hide');
            $('.itm_details').removeClass('no-display');
        }
    });
    $('body').on('click', '.ser_newww', function () {
        var selid = $(this).closest('tbody').attr('id-cl_ser');
        $("#trid_ser").val(selid);
        var servicedetails = $(this).attr('cost_dtls');

        var service_list = $(this).attr('service_list');
        var item_id = $(this).attr('item_id');
        var newT = servicedetails.replace(/'/g, '\"');
        var service_detail2 = service_list.replace(/'/g, '\"');
        var servce_array = JSON.parse(newT);
        var cc = servce_array.cost_center;
        if (cc) {
            var service_cost_center_details = JSON.parse(servce_array.cost_center);
        } else {
            var service_cost_center_details = '';
        }
        var service_detail = JSON.parse(service_detail2);
        var co_id = new Array();
        var coc_id = new Array();
        var json_co_id = '';
        var json_coc_id = '';
        if (service_cost_center_details != null) {
            for (var s = 0; s < service_cost_center_details.length; s++) {
                co_id.push(service_cost_center_details[s].cost_center);
                coc_id.push(service_cost_center_details[s].cost_center_category);
            }
            json_co_id = JSON.stringify(co_id);
            json_coc_id = JSON.stringify(coc_id);
        } else {
            json_co_id = '';
            json_coc_id = '';
        }
        $('#jquery_mask').show();
        $.post(siteurl + "/Crm/Deals/get_cost_center_details_by_co_id", {json_co_id: json_co_id, json_coc_id: json_coc_id, item_id: item_id}, function (result)
        {
            $('#jquery_mask').hide();
            var jso = JSON.parse(result);
            var json_cos_cat = jso.cos;
            var service_details_item = jso.service_details;
            var cou = 1;
            var final_rate = 0;
            var option2 = '';
            var j_ids = [];
            // nid new
            for (var i = 0; i < service_detail.length; i++) {
                option2 += '<tr>';
                option2 += '<td><div class="checkbox checkbox-success"><input type="checkbox" servicetaxid="' + service_detail[0].tax_group_id + '" checked="checked" disabled class="pickservices2" id="" name="pickservices[]" value="' + service_detail[i].service_master_id + '" item_id="' + item_id + '"><label></label></div></td>';
                option2 += '<td><input type="text" readonly class="form-control number_validate service_names" id="service_names" name="service_names[]" value="' + service_detail[i].service_name + '"></td>';
                option2 += '<td><input type="number" readonly class="form-control number_validate service_qty" min="0" id="service_qty" name="service_qty[]" value="' + service_detail[i].quantity + '"></td>';
                option2 += '<td><input type="number" readonly class="form-control number_validate service_price" min="0" id="service_price" name="service_price[]" value="' + service_detail[i].price_per_unit + '">';
                option2 += '<input type="hidden" class="sac_services" name="sac_services[]" value="' + service_detail[i].sac + '"/>';
                option2 += '<input type="hidden" class="range_services" name="range_services[]" value="' + service_detail[i].range_accuracy + '"/>';
                option2 += '</td>';
                option2 += '</tr>';
                j_ids.push(service_detail[i].service_master_id);
            }
            for (var j = 0; j < service_details_item.length; j++) {
                if ($.inArray(service_details_item[j].service_master_id, j_ids) == '-1') {
                    option2 += '<tr>';
                    option2 += '<td><div class="checkbox checkbox-success"><input type="checkbox" servicetaxid="' + service_detail[0].tax_group_id + '" class="pickservices" id="" name="pickservices[]" value="' + service_details_item[j].service_master_id + '" item_id="' + item_id + '"><label></label></div></td>';
                    option2 += '<td><input type="text" readonly class="form-control number_validate service_names" id="service_names" name="service_names[]" value="' + service_details_item[j].service_name + '"></td>';
                    option2 += '<td><input type="number" readonly class="form-control number_validate service_qty" min="0" id="service_qty" name="service_qty[]" value="' + service_details_item[j].quantity + '"></td>';
                    option2 += '<td><input type="number" readonly class="form-control number_validate service_price" min="0" id="service_price" name="service_price[]" value="' + service_details_item[j].price_per_unit + '">';
                    option2 += '<input type="hidden" class="sac_services" name="sac_services[]" value="' + service_details_item[j].sac + '"/>';
                    option2 += '<input type="hidden" class="range_services" name="range_services[]" value="' + service_details_item[j].range_accuracy + '"/>';
                    option2 += '</td>';
                    option2 += '</tr>';
                }
            }

            for (var s = 0; s < co_id.length; s++) {
                $('#cost_center').val(co_id[s]);
                var html_option = '';
                var htmldata1 = '';
                var co = json_cos_cat.category_details[s];
                var cor = json_cos_cat.daily_rate_details[s];
                var cod = json_cos_cat.hour_rate_details[s];
                var c = 0;

                for (var s = 0; s < service_cost_center_details.length; s++) {
//                    deal pick div modal start
                    c = s + 1;
                    htmldata1 += '<tr><td class="p0 pt-10 pos-rel w5 text-center vat cld_pick" icl="' + c + '">';
                    htmldata1 += '<div class="new_clone" >';
                    htmldata1 += '<a href="#" cl="' + s + '" class="remove_cos_clone_pick1" style="color:red; " ><i class="icon lindo-android-remove-circle fz-22 txt-danger"></i></a>';
                    htmldata1 += '</div>';
                    htmldata1 += '</td>';

                    htmldata1 += '<td class="pa-2 vat w20">';
                    htmldata1 += '<select class="form-control cost_center_pick" name="cost_center_pick" id="cost_center_pick" readonly disabled>';
                    htmldata1 += '<option value="">select</option>';
                    for (var d = 0; d < json_cost_cntr.length; d++) {

                        htmldata1 += '<option ';
                        if (json_cost_cntr[d]['cc_id'] == co_id[s]) {

                            htmldata1 += 'selected="selected"';
                        }
                        htmldata1 += 'value="' + json_cost_cntr[d]['cc_id'] + '">' + json_cost_cntr[d]['cc_name'] + '</option>';
                    }
                    htmldata1 += '</select>';
                    htmldata1 += '</td>';

                    htmldata1 += '<td class="pa-2 vat w20">';
                    htmldata1 += '<select class="form-control  cost_center_category_pick" disabled name="cost_center_category_pick" id="cost_center_category_pick"><option value="">select</option>'
                    for (var c = 0; c < json_cost_cntr_cat.length; c++) {
                        if (json_cost_cntr_cat[c]['costcenter_id'] == co_id[s]) {
                            htmldata1 += '<option ';
                            if (json_cost_cntr_cat[c]['cc_category_id'] == coc_id[s]) {
                                htmldata1 += 'selected="selected"';
                            }
                            htmldata1 += ' value="' + json_cost_cntr_cat[c]['cc_category_id'] + '">' + json_cost_cntr_cat[c]['cc_category_name'] + '</option>';
                        }
                    }
                    htmldata1 += ' </select>'
                    htmldata1 += '<input type="hidden" class="form-control rate_master_id_pick" id="rate_master_id_pick"  name="rate_master_id_pick" value="' + service_cost_center_details[s]['rate_id'] + '" /></td>';

                    htmldata1 += '<td class="pa-2 vat w35">';
                    htmldata1 += '<div class="col-lg-6 col-md-6 col-sm-12 col-xs-12 pr-0-l pt-10">';
                    htmldata1 += '<input disabled class="estimate_radio_hour_pick"';
                    if (service_cost_center_details[s]['type'] == 'hour') {
                        htmldata1 += 'checked="checked"'
                    }
                    htmldata1 += 'type = "radio" name = "estimate_radio' + cou + '" / > Hours';
                    htmldata1 += '<input disabled class = "estimate_radio_day_pick"';
                    if (service_cost_center_details[s]['type'] == 'day') {
                        htmldata1 += 'checked="checked"'
                    }
                    htmldata1 += 'type = "radio" name = "estimate_radio' + cou + '" / > Day'
                    htmldata1 += '</div><div class="col-lg-6 col-md-6 col-sm-12 col-xs-12 p0">'
                    htmldata1 += '<input  type="number" class="form-control estimate_deal_pick" readonly id="estimate_deal_pick" required name="estimate_deal_pick" value="' + service_cost_center_details[s]['hour'] + '" />'
                    htmldata1 += '</div>';
                    htmldata1 += '</td>';
                    htmldata1 += '<td class="pa-2 vat w20">';
                    htmldata1 += '<input  type="text" readonly class="form-control ind_final_rate_pick" id="ind_final_rate_pick" required name="ind_final_rate_pick" value="' + service_cost_center_details[s]['sub_total'] + '" />'
                    htmldata1 += '<input  type="hidden" class="form-control cost_type_pick" id="cost_type_pick" required name="cost_type_pick" value="' + service_cost_center_details[s]['type'] + '" />'
                    htmldata1 += '<input  type="hidden" class="form-control rate_db_pick" id="rate_db_pick" required name="rate_db_pick" value="' + service_cost_center_details[s]['rate'] + '" />'
                    htmldata1 += '</td></tr>';
                    final_rate += Number(service_cost_center_details[s]['sub_total']);
                    cou++;
                }

            }
            $('.coscntrnid').html(htmldata1);
            $('#AddService_common #final_rate_total_pick').val(final_rate);
            var option = '';
            var profit_loss = 0;
            profit_loss = parseFloat(servce_array['unitcost']) - parseFloat(final_rate);

            if (parseFloat(profit_loss) > 0) {
                option += ' <label class="control-label txt-success">Profit:' + parseFloat(profit_loss) + '</label>'

            } else if (parseFloat(profit_loss) < 0) {
                option += ' <label class="control-label txt-danger">Loss:' + parseFloat(profit_loss) + '</label>'
            }
            $('#AddService_common .servicetbl').html(option2);
            $('.profit_loss_edit_div').html(option);

        });
        $('#AddService_common #select_ser_unit').val(servce_array['unit_id']);
        $('#AddService_common #servicenam').val(servce_array['name']);
        $('#AddService_common #item_description').val(servce_array['itemdescription']);
        $('#AddService_common #ser_rangeaccu').val(servce_array['range_accuracy']);
        $('#AddService_common #ser_unitcoste').val(servce_array['unitcost']);
    });
    $("body").on('change', '.cost_center_pick', function () {
        var rowid = $(this).closest('tr').attr('icl');
        var sll = $('[icl=' + rowid + ']');
        var cost_center_id = $(this).val();
        $('#jquery_mask').show();
        $.post(siteurl + "/Crm/Deals/get_costcenter_category_by_id", {cost_center_id: cost_center_id}, function (data) {
            $('#jquery_mask').hide();
            sll.find('.cost_center_category_pick').html(data);
        });

    });
    $("body").on('change', '.cost_center_category_pick', function () {
        var category_id = $(this).val();
        var rowid = $(this).closest('tr').attr('icl');
        var sll = $('[icl=' + rowid + ']');
        $('#jquery_mask').show();
        $.post(siteurl + "/Crm/Deals/get_rate_category_by_id", {category_id: category_id}, function (data) {
            $('#jquery_mask').hide();
            var rate = JSON.parse(data);
            var hourly_rate = (rate['rate_details'][0]['hourly_rate']);
            var day_rate = (rate['working_hour'][0]['working_hours']);
            var rate_id = (rate['rate_details'][0]['rate_master_id']);
            sll.find('.rate_master_id_pick').val(rate_id);
            sll.find('.rate_by_category_pick').val(hourly_rate);
            sll.find('.day_hour_pick').val(day_rate);

        });
    });
    $("body").on('keyup', '.estimate_pick', function () {
        var cost_per_unit = $('#AddService_common #ser_unitcoste').val();
        if (cost_per_unit == '') {
            cost_per_unit = 0;
        }
        var rowid = $(this).closest('tr').attr('icl');
        var sll = $('.pick_cos_tr[icl="' + rowid + '"]');
        var aa = sll.find('.cost_center_pick');
        var bb = sll.find('.cost_center_category_pick');
        var cc = sll.find('.amount_pick');
        var fb = sll.find('.cost_type_pick');
        var dd = sll.find('.rate_by_category_pick');
        var ds = sll.find('.day_hour_pick');
        var di = sll.find('.estimate_pick');
        var tt = $('.final_rate_total_pick');
        var tc = $('.full_cost_center_pick');
        var tcc = $('.full_cost_center_category_pick');
        var tra = $('.ind_rate_pick');
        var tsa = $('.ind_type_pick');
        var est = $('.ind_estimate_value_pick');
        var estf = $('.rate_id_full_pick');
        if (aa.val()) {
            var cost_center = aa.val();
        }
        if (bb.val()) {
            var cost_center_category = bb.val();
        }
        if (dd.val()) {
            var rate_by_category = dd.val();
        }
        if (ds.val()) {
            var day_hour = ds.val();
        }
        if (di.val()) {
            var input_rate = di.val();
        }
        if (fb.val()) {
            var type_ind = fb.val();
        }

        var input_rate = $(this).val();
        var rate_by_category = sll.find('#rate_by_category_pick').val();
        var rate_day = sll.find('#day_hour_pick').val();
        var rate_day = Number(rate_day) * Number(rate_by_category);
        var type = '';
        var typearray = [];
        if (sll.find('.estimate_radio_hour_pick').is(':checked')) {
            var final_rate = Number(input_rate) * Number(rate_by_category);
            var type = 'hour';
            sll.find('.ind_final_rate_pick').val(final_rate);
            sll.find('.cost_type_pick').val(type);
            sll.find('.rate_db_pick').val(rate_by_category);
        } else if (sll.find('.estimate_radio_day_pick').is(':checked')) {
            var type = 'day';
            var final_rate = Number(input_rate) * Number(rate_day);
            sll.find('.ind_final_rate_pick').val(final_rate);
            sll.find('.cost_type_pick').val(type);
            sll.find('.rate_db_pick').val(rate_day);
        }

        var sum = 0;
        var rate_array = [];
        $('#AddService_common .ind_final_rate_pick').each(function () {
            sum += Number($(this).val());
            rate_array.push($(this).val());
        });
        var cosarray = [];
        var coscatarray = [];
        var ratearray_ind = [];
        var estimate_ind = [];
        var full_ra_id = [];
        $('.cost_center_pick').each(function () {

            cosarray.push($(this).val());
        });
        $('.cost_center_category_pick').each(function () {
            coscatarray.push($(this).val());
        });
        $('.rate_db_pick').each(function () {

            ratearray_ind.push($(this).val());
        });
        $('#AddService_common .cost_type_pick').each(function () {

            typearray.push($(this).val());
        });
        $('.estimate_pick').each(function () {

            estimate_ind.push($(this).val());
        });
        $('.rate_master_id_pick').each(function () {

            full_ra_id.push($(this).val());
        });
        var option = '';
        var profit_loss = 0;
        profit_loss = parseFloat(cost_per_unit) - parseFloat(sum);
        if (parseFloat(profit_loss) > 0) {
            option += ' <label class="control-label txt-success">Profit:' + parseFloat(profit_loss) + '</label>'

        } else if (parseFloat(profit_loss) < 0) {
            option += ' <label class="control-label txt-danger">Loss:' + parseFloat(profit_loss) + '</label>'
        } else {

        }
        $('.profit_loss_edit_div').html(option);
        tt.val(parseFloat(sum));
        tra.val(rate_array);
        tsa.val(typearray);
        tc.val(cosarray);
        tcc.val(coscatarray);
        tra.val(ratearray_ind);
        est.val(estimate_ind);
        estf.val(full_ra_id);
    });
//    $('body').on('keyup', '.ser_quan', function () {
//        $("#net_amt").trigger("change");
//        $('#common_percentage_amount').trigger("change");
//    });
//    $('body').on('keyup', '.ser_unitcost', function () {
//        $("#net_amt").trigger("change");
//        $('#common_percentage_amount').trigger("change");
//    });
//    $('body').on('change', '.ser_dis', function () {
//        $('#common_percentage_amount').trigger("change");
//    });
//    $('body').on('change', '.ser_item_dis_amt', function () {
//        $("#net_amt").trigger("change");
//        $('#common_percentage_amount').trigger("change");
//    });

    $('body').on('click', '.clear_services', function (e) {
        e.preventDefault();
        $(this).parent().parent().remove();

        service_subtotal_calculation();
        calculate_grandtotal();



        var tb = $(this).attr('tbody_cnt');
        var c = $(this).closest('tr').attr('id-newtr');
        var service_item_id_hidden = $(this).closest('tr').find('.service_item_id_hidden').val();
        var deleteids = [];
        var deleteidd = $('.deleted_seritem_ids').val();
        if (deleteidd != '') {
            deleteids = deleteidd.split(',');
        }
        deleteids.push(service_item_id_hidden);
        $('.deleted_seritem_ids').val(deleteids);
        if (c == 1) {
            var item_id = $(this).closest('tr').find('.item_ids_service');

            if (tb == 1) {
                $(".cld_ser[id-cl_ser='" + tb + "']").find('input').val('');
                $(".cld_ser[id-cl_ser='" + tb + "']").find('.ser_names').val('');
                service_subtotal_calculation();
                calculate_grandtotal();
            } else {
                $('.cld_ser').attr('id-cl_ser["' + tb + '"]').remove();
                service_subtotal_calculation();
                calculate_grandtotal();
            }
        }

    });

    $('body').on('click', '.removeorgmember_ser', function (e) {
        e.preventDefault();
        $(this).parent().parent().parent().remove();
        product_subtotal_calculation();
        calculate_grandtotal();
    });
    $('body').on('click', '.add_cos_clone_pick', function () {
        var cost_cntr = $('.cost_center_pick:last').val();
        var cat = $('.cost_center_category_pick:last').val();
        var est = $('.estimate_deal_pick:last').val();
        if (cost_cntr == '' || cat == '' || cost_cntr == 'select' || cat == 'select' || est == '' || est == 0) {
            swal("Enter valid cost center entry");
        } else {
            var clone_radio_count = 1;
            var clid = $('#pick_table tr:last').attr('icl');
//            var clid = $(".cld_pick:last").attr('icl');
            var nxt = parseFloat(clid) + 1;
            var bc = $("#AddService_common .pick_cos_tr:last").clone();
            bc.attr("icl", nxt);
            var dd = bc.find("input");
            dd.val("");
            bc.find('input[type="radio"]').attr('name', 'estimate_radio' + nxt);
            var abc = 'estimate_radio' + nxt;
            bc.find('input[name=' + abc + ']').attr('checked', false);
            $('.remove_cos_clone_pick').show();
            bc.removeClass('clone_cost_center_div_pick');
            bc.appendTo(".table_pick_body");
        }
    });

    $('body').on('click', '.removeorgmember', function (e) {
        e.preventDefault();
        $(this).parent().parent().remove();
        var total_pdt = 0;
        var net_amt = 0;
        var product_discount = 0;
        var hidden = $('.qut_pdt_id_array').val();

        var hidden_remove = '';

        var hidden_remove_pdt_id = $(this).closest('tr').find('.quote_pdt_id').val();
        if (hidden_remove_pdt_id != '') {

            if (hidden == '') {
                hidden_remove = hidden_remove_pdt_id;

            } else {
                hidden_remove = hidden + ',' + hidden_remove_pdt_id;
            }
            $('.qut_pdt_id_array').val(hidden_remove);


        }
        var deleteids = [];
        var quote_pdt_id = $(this).closest('tr').find('.quote_pdt_id').val();
        var deleteidd = $('.deleted_pdt_ids').val();
        if (deleteidd != '') {
            deleteids = deleteidd.split(',');
        }
        deleteids.push(quote_pdt_id);
        var pdt_id = $(this).closest('tr').find('.pdt_id').val();
        remove_amcs(pdt_id);
        product_subtotal_calculation();
        calculate_grandtotal();
    });
    $('body').on('click', '.pickservices', function () {
        if ($(this).is(":checked")) {
            $(this).closest('tr').find('.service_qty').prop('readonly', false);
            $(this).closest('tr').find('.service_price').prop('readonly', false);
        } else {
            $(this).closest('tr').find('.service_qty').prop('readonly', true);
            $(this).closest('tr').find('.service_price').prop('readonly', true);
        }
    });
    $('body').on('click', '.pickservice2', function () {
        var page_type_checking = '';
        var ser_master_idcl = $(this).attr('ser_mast_idcl');
        page_type_checking = $('.ser_new_search').closest('tr').find('.page_type_checking').val();
        var item_detail = $(this).attr('jcoded');
        var newT = item_detail.replace(/'/g, '\"');
        var j_item_detail = JSON.parse(newT);
        var item_id = j_item_detail['sac'];
        var item_name = j_item_detail['name'];
        var i_id = $(this).attr('sel-id');

        var ser_intra_sales_account_id_hidden = $('#ser_intra_sales_account_id_hidden' + i_id).val();
        var ser_inter_sales_account_id_hidden = $('#ser_inter_sales_account_id_hidden' + i_id).val();
        var ser_export_sales_account_id_hidden = $('#ser_export_sales_account_id_hidden' + i_id).val();
        var ser_service_sales_account_id_hidden = $('#ser_service_sales_account_id_hidden' + i_id).val();
        var ser_bcd_type = $('#barcode_type' + i_id).val();
        var ser_bcd = $('#bcd' + i_id).val();



        var occurence = 0;
        var occurence1 = 0;
        $.post(siteurl + "/Crm/Deals/get_all_services_by_id/", {item_id: i_id}, function (data) {
            if (data) {
                var json_array = JSON.parse(data);
                var option = '';
                option += '<input type="hidden" class="hiddn_master_idcl" id="" name="hiddn_master_idcl" value="' + ser_master_idcl + '">';
                for (var i = 0; i < json_array.length; i++) {
                    option += '<tr>';
                    option += '<td class="w5 pa-2 text-center"><div class="checkbox checkbox-success"><input  type="checkbox" checked="checked" class="pickservices newpickservice" id="" name="pickservices[]" value="' + json_array[i].service_master_id + '" item_id="' + i_id + '" servicetaxid="' + json_array[i].service_taxid + '"><label></label></div></td>';
                    option += '<td class="w55 pa-2"><input type="text" readonly class="form-control number_validate service_names" id="service_names" name="service_names[]" value="' + json_array[i].service_name + '"></td>';
                    option += '<td class="w20 pa-2"><input type="number"  class="form-control number_validate service_qty" min="0" id="service_qty" name="service_qty[]" value="1"></td>';
                    option += '<td class="w20 pa-2"><input type="number" readonly class="form-control number_validate service_price" min="0" id="service_price" name="service_price[]" value="' + json_array[i].price_per_unit + '">';
                    option += '<input type="hidden" class="sac_services" name="sac_services[]" value="' + json_array[i].sac + '"/>';
                    option += '<input type="hidden" class="range_services" name="range_services[]" value="' + json_array[i].range_accuracy + '"/>';
                    option += '</td>';
                    option += '</tr>';

                }
                $('.servicetbl').html(option);
            }
            $('.serviceid_ser').each(function () {
                if ($(this).val() === i_id) {
                    occurence1++;
                }
            });
            if (occurence1 > 0) {
                swal('Alert', 'This item is already picked', 'error');
                return false;
            }
            $('#sac_search').val(j_item_detail['sac']);
            $('#item_description_search').val(j_item_detail['description']);
            $('#service_name_search_view').val(j_item_detail['name']);
            $('#ser_unitcoste_search').val(j_item_detail['cost_per_unit']);
            $('#ser_rangeaccu_search').val(j_item_detail['range_accuracy']);
            $('#select_ser_unit_search').val(j_item_detail['unit_id']);
            $('#select_ser_unit_search_value').val(j_item_detail['unit_code']);
            $('#serviceid_so_servce_search').val(j_item_detail['item_id']);
            $('#servitem_taxtype').val(j_item_detail['tax_type']);
            $('.cld_costcentr_search').each(function () {
                if ($(this).attr('cl') != 1) {
                    $(this).remove();
                }
            });
            $('#salesaccnt_id_intra').val(ser_intra_sales_account_id_hidden);
            $('#salesaccnt_id_inter').val(ser_inter_sales_account_id_hidden);
            $('#salesaccnt_id_export').val(ser_export_sales_account_id_hidden);
            $('#salesaccnt_id_service').val(ser_service_sales_account_id_hidden);
            $('#ser_bcd_type').val(ser_bcd_type);
            if (ser_bcd != 'null') {
                $('#ser_bcd').val(ser_bcd);
            } else {
                $('#ser_bcd').val('');
            }
            $('.cost_type_search').val('');
            $('.profit_loss_div').text('');
            $('.rate_db_search').val('');
            $('.rate_by_category_search').val('');
            $('.day_hour_search').val('');
            $('.rate_master_id_search').val('');
            $('.cost_center_category_search').val('');
            $('.cost_center_search').val('');
            $('.estimate_search').val('');
            $('.ind_final_rate_search').val('');
            $('.final_rate_total_search').val('');

            $('.final_rate_total_search').val('');
            $('.final_rate_total_search').val('');
            $('.final_rate_total_search').val('');
            $('.final_rate_total_search').val('');
            $('#search_service2').modal('hide');
            $('#addservice_search').modal('show');
        });

    });
    $('body').on('click', '#view_details', function () {
        var iditem = $(this).attr('iditem');
        var check = $(this).attr('check');
        if (iditem != '') {
            $.post(siteurl + "/Inventory/Item/item_details_by_id/", {iditem: iditem}, function (data) {
                var json_array = JSON.parse(data);
                var abc = '';
                var itemtype = json_array.item_type;
                if (json_array.item_type == 'inventory_and_service') {
                    itemtype = 'Inventory & service';
                }
                if (json_array.partial_selling == 1) {
                    abc = 'partial product';
                } else {
                    abc = 'whole product';
                }
                if (check == 'item') {
                    $('.item_table_details').removeClass('no-display');
                    $('.service_table_details').addClass('no-display');
                    $('.v_d_name').text(json_array.name);
                    $('.v_d_sku').text(json_array.sku);
                    $('.v_d_description').text(json_array.description);
                    $('.v_d_curr_stock').text(json_array.current_stock - (json_array.demo_qty + json_array.service_quantity));
                    $('.v_d_brand').text(json_array.brandname);
                    $('.v_d_type').text(itemtype);
                    $('.v_d_status').text(abc);
                } else {
                    $('.item_table_details').addClass('no-display');
                    $('.service_table_details').removeClass('no-display');
                    $('.v_d_name').text(json_array.name);
                    $('.v_d_description').text(json_array.description);
                    $('.v_d_sac').text(json_array.sac);
                    $('.v_d_brand').text(json_array.brandname);
                    $('.v_d_type').text(itemtype);
                    $('.v_d_status').text(abc);
                }
            });
        }
    });
    $('body').on('click', '#view_history', function () {
        var iditem = $(this).attr('iditem');
        var check = $(this).attr('check');
        var contact_id = $('#getcmpny_id').val();
        var option = '';
        var option2 = '';
        var option3 = '';
        if (iditem != '') {
            if (check == 'item') {
                $.post(siteurl + "/Inventory/Item/item_history_by_id/", {iditem: iditem}, function (data) {
                    console.log(data);
                    var json_array_1 = JSON.parse(data);

                    var json_array = json_array_1['item'];
                    var json_array_sale = json_array_1['sales'];
                    var json_array_sales = json_array_sale.full;
                    var json_array_salesso = json_array_sale.withso;
                    var json_array_salesquote = json_array_sale.withquote;
                    var json_array_service = json_array_1['service'];
                    var soqty = 0;
                    var sowithoutdo = 0;
                    option += '<thead>';
                    option += '<th>PO NUMBER</th>';
                    option += '<th>MRV NUMBER</th>';
                    option += '<th>BILL NUMBER</th>';
                    option += '<th>MRV DATE</th>';
                    option += '<th>COST OF ITEM</th>';
                    option += '</thead><tbody>';
                    for (var i = 0; i < json_array.length; i++) {

                        if (json_array[i].po_number == null) {
                            json_array[i].po_number = '';
                            url1 = '';
                        } else {
                            url1 = siteurl + '/Inventory/Purchase/get_purchaseorder_for_view/' + json_array[i].po_id;
                        }
                        if (json_array[i].mrv_number == null) {
                            json_array[i].mrv_number = '';
                            url2 = '';
                        } else {
                            url2 = siteurl + '/Inventory/Mrv/get_mrv_view/' + json_array[i].mrv_id;
                        }
                        if (json_array[i].bill_no == null) {
                            json_array[i].bill_no = '';
                            url3 = '';
                        } else {
                            url3 = siteurl + '/Inventory/Bill/view_bill/' + json_array[i].bill_id;
                        }
                        if (json_array[i].mrv_date == null) {
                            json_array[i].mrv_date = '';
                        }
                        if (json_array[i].cost_of_item == null) {
                            json_array[i].cost_of_item = '';
                        }
                        option += '<tr>';
                        option += '<td> <a href="' + url1 + '" target="_blank">' + json_array[i].po_number + '</a></td>';
                        option += '<td> <a href="' + url2 + '" target="_blank">' + json_array[i].mrv_number + '</a></td>';
                        option += '<td> <a href="' + url3 + '" target="_blank">' + json_array[i].bill_no + '</a></td>';
                        option += '<td>' + json_array[i].mrv_date + '</td>';
                        option += '<td>' + parseFloat(json_array[i].cost_of_item).toFixed(2) + '</td>';
                        option += '</tr>';
                    }
                    option += '</tbody>';




                    option2 += '<thead>';
                    option2 += '<th>QUOTE NUMBER</th>';
                    option2 += '<th>SO NUMBER</th>';
                    option2 += '<th>DO NUMBER</th>';
                    option2 += '<th>INV NUMBER</th>';
                    option2 += '</thead><tbody>';
                    var selldisamt = 0;
                    var quoteamnt = 0;
                    var soamnt = 0;
                    var invamnt = 0;
                    console.log(json_array_sales);
                    for (var i = 0; i < json_array_sales.length; i++) {
                        if (json_array_sales[i].quantity == null) {
                            json_array_sales[i].quantity = 0;
                        }
                        if (json_array_sales[i].issued_qty == null) {
                            json_array_sales[i].issued_qty = 0;
                        }
                        if (json_array_sales[i].amount == null) {
                            json_array_sales[i].amount = 0;
                        }
                        if (json_array_sales[i].subtotal == null) {
                            json_array_sales[i].subtotal = 0;
                        }
                        if (json_array_sales[i].inv_qty == null) {
                            json_array_sales[i].inv_qty = 0;
                        }

                        invamnt = parseFloat(json_array_sales[i].subtotal) / parseFloat(json_array_sales[i].inv_qty);
                        sowithoutdo = parseFloat(json_array_sales[i].quantity) - parseFloat(json_array_sales[i].issued_qty);
                        soqty += sowithoutdo;
                        if (json_array_sales[i].subject == null) {
                            json_array_sales[i].subject = '';
                            urls1 = '';
                        } else {
                            urls1 = siteurl + '/Inventory/Quote/get_quote_for_view/' + json_array_sales[i].quote_id;
                        }
                        if (json_array_sales[i].so_number == null) {
                            json_array_sales[i].so_number = '';
                            urls2 = '';
                        } else {
                            urls2 = siteurl + '/Inventory/Salesorder/get_salesorder_by_id/' + json_array_sales[i].so_id;
                        }
                        if (json_array_sales[i].do_number == null) {
                            json_array_sales[i].do_number = '';
                            urls3 = '';
                        } else {
                            urls3 = siteurl + '/Inventory/Delivery_order/get_deliveryorder_by_id/' + json_array_sales[i].deliveryorder_id;
                        }
                        if (json_array_sales[i].invoice_number == null) {
                            json_array_sales[i].invoice_number = '';
                            urls4 = '';
                        } else {
                            if (json_array_sales[i].invoice_method == 'sales_order') {
                                urls4 = siteurl + '/Inventory/Invoice/get_invoice_for_view/' + json_array_sales[i].inv_id;
                            } else {
                                urls4 = siteurl + '/Inventory/Direct_invoice/get_directinvoice_for_view/' + json_array_sales[i].inv_id;
                            }

                        }
                        if ((json_array_sales[i].selling_price) == null) {
                            json_array_sales[i].selling_price = 0;
                        }
                        if ((json_array_sales[i].discount_percentage) == null) {
                            json_array_sales[i].discount_percentage = 0;
                        }
                        soamnt = (parseFloat(json_array_sales[i].amount)) / (parseFloat(json_array_sales[i].quantity));
                        selldisamt = (parseFloat(json_array_sales[i].selling_price) * parseFloat(json_array_sales[i].discount_percentage)) / 100;
                        quoteamnt = parseFloat(json_array_sales[i].selling_price) - parseFloat(selldisamt);
                        if (json_array_sales[i].subject == '' && json_array_sales[i].so_number == '' && json_array_sales[i].do_number == '' && json_array_sales[i].invoice_number == '') {

                        } else {
                            if (contact_id == '') {
                                option2 += '<tr>';
                                option2 += '<td> <a href="' + urls1 + '" target="_blank">' + json_array_sales[i].subject + '</a><br>PRICE :' + quoteamnt + '</td>';
                                option2 += '<td> <a href="' + urls2 + '" target="_blank">' + json_array_sales[i].so_number + '</a><br>PRICE : ' + soamnt + '</td>';
                                option2 += '<td> <a href="' + urls3 + '" target="_blank">' + json_array_sales[i].do_number + '</a></td>';
                                option2 += '<td> <a href="' + urls4 + '" target="_blank">' + json_array_sales[i].invoice_number + '</a><br>PRICE : ' + invamnt + '</td>';
                                option2 += '</tr>';
                            } else {
                                if (json_array_sales[i].quotecontact != null) {
                                    if (json_array_sales[i].quotecontact == contact_id) {

                                        option2 += '<tr>';
                                        option2 += '<td> <a href="' + urls1 + '" target="_blank">' + json_array_sales[i].subject + '</a><br>PRICE :' + quoteamnt + '</td>';
                                        option2 += '<td> <a href="' + urls2 + '" target="_blank">' + json_array_sales[i].so_number + '</a><br>PRICE : ' + soamnt + '</td>';
                                        option2 += '<td> <a href="' + urls3 + '" target="_blank">' + json_array_sales[i].do_number + '</a></td>';
                                        option2 += '<td> <a href="' + urls4 + '" target="_blank">' + json_array_sales[i].invoice_number + '</a><br>PRICE : ' + invamnt + '</td>';
                                        option2 += '</tr>';
                                    }
                                } else if (json_array_sales[i].socontact != null) {
                                    if (json_array_sales[i].socontact == contact_id) {
                                        option2 += '<tr>';
                                        option2 += '<td> <a href="' + urls1 + '" target="_blank">' + json_array_sales[i].subject + '</a><br>PRICE :' + quoteamnt + '</td>';
                                        option2 += '<td> <a href="' + urls2 + '" target="_blank">' + json_array_sales[i].so_number + '</a><br>PRICE : ' + soamnt + '</td>';
                                        option2 += '<td> <a href="' + urls3 + '" target="_blank">' + json_array_sales[i].do_number + '</a></td>';
                                        option2 += '<td> <a href="' + urls4 + '" target="_blank">' + json_array_sales[i].invoice_number + '</a><br>PRICE : ' + invamnt + '</td>';
                                        option2 += '</tr>';
                                    }
                                }
                            }





                        }
                    }
                    selldisamt = 0;
                    quoteamnt = 0;
                    soamnt = 0;
                    console.log(json_array_salesso);
                    for (var i = 0; i < json_array_salesso.length; i++) {

                        if (json_array_salesso[i].quantity == null) {
                            json_array_salesso[i].quantity = 0;
                        }
                        if (json_array_salesso[i].issued_qty == null) {
                            json_array_salesso[i].issued_qty = 0;
                        }
                        if (json_array_salesso[i].amount == null) {
                            json_array_salesso[i].amount = 0;
                        }
                        sowithoutdo = parseFloat(json_array_salesso[i].quantity) - parseFloat(json_array_salesso[i].issued_qty);
                        soqty += sowithoutdo;
                        if (json_array_salesso[i].subject == null) {
                            json_array_salesso[i].subject = '';
                            urls1 = '';
                        } else {
                            urls1 = siteurl + '/Inventory/Quote/get_quote_for_view/' + json_array_salesso[i].quote_id;
                        }
                        if (json_array_salesso[i].so_number == null) {
                            json_array_salesso[i].so_number = '';
                            urls2 = '';
                        } else {
                            urls2 = siteurl + '/Inventory/Salesorder/get_salesorder_by_id/' + json_array_salesso[i].so_id;
                        }
                        if ((json_array_salesso[i].selling_price) == null) {
                            json_array_salesso[i].selling_price = 0;
                        }
                        if ((json_array_salesso[i].discount_percentage) == null) {
                            json_array_salesso[i].discount_percentage = 0;
                        }
                        soamnt = (parseFloat(json_array_salesso[i].amount)) / (parseFloat(json_array_salesso[i].quantity));
                        selldisamt = (parseFloat(json_array_salesso[i].selling_price) * parseFloat(json_array_salesso[i].discount_percentage)) / 100;
                        quoteamnt = parseFloat(json_array_salesso[i].selling_price) - parseFloat(selldisamt);
                        if (json_array_salesso[i].subject == '' && json_array_salesso[i].so_number == '' && json_array_salesso[i].do_number == '' && json_array_salesso[i].invoice_number == '') {

                        } else {
                            if (contact_id == '') {
                                option2 += '<tr>';
                                option2 += '<td> <a href="' + urls1 + '" target="_blank">' + json_array_salesso[i].subject + '</a><br>PRICE :' + quoteamnt + '</td>';
                                option2 += '<td> <a href="' + urls2 + '" target="_blank">' + json_array_salesso[i].so_number + '</a><br>PRICE : ' + soamnt + '</td>';
                                option2 += '<td> </td>';
                                option2 += '<td> </td>';
                                option2 += '</tr>';
                            } else {
                                if (json_array_salesso[i].quotecontact != null) {
                                    if (json_array_salesso[i].quotecontact == contact_id) {

                                        option2 += '<tr>';
                                        option2 += '<td> <a href="' + urls1 + '" target="_blank">' + json_array_salesso[i].subject + '</a><br>PRICE :' + quoteamnt + '</td>';
                                        option2 += '<td> <a href="' + urls2 + '" target="_blank">' + json_array_salesso[i].so_number + '</a><br>PRICE : ' + soamnt + '</td>';
                                        option2 += '<td> </td>';
                                        option2 += '<td> </td>';
                                        option2 += '</tr>';
                                    }
                                } else if (json_array_salesso[i].socontact != null) {
                                    if (json_array_salesso[i].socontact == contact_id) {
                                        option2 += '<tr>';
                                        option2 += '<td> <a href="' + urls1 + '" target="_blank">' + json_array_salesso[i].subject + '</a><br>PRICE :' + quoteamnt + '</td>';
                                        option2 += '<td> <a href="' + urls2 + '" target="_blank">' + json_array_salesso[i].so_number + '</a><br>PRICE : ' + soamnt + '</td>';
                                        option2 += '<td></td>';
                                        option2 += '<td></td>';
                                        option2 += '</tr>';
                                    }
                                }
                            }





                        }
                    }
                    selldisamt = 0;
                    quoteamnt = 0;
                    for (var i = 0; i < json_array_salesquote.length; i++) {
                        if (json_array_salesquote[i].subject == null) {
                            json_array_salesquote[i].subject = '';
                            urls1 = '';
                        } else {
                            urls1 = siteurl + '/Inventory/Quote/get_quote_for_view/' + json_array_salesquote[i].quote_id;
                        }
                        if ((json_array_salesquote[i].selling_price) == null) {
                            json_array_salesquote[i].selling_price = 0;
                        }
                        if ((json_array_salesquote[i].discount_percentage) == null) {
                            json_array_salesquote[i].discount_percentage = 0;
                        }
                        selldisamt = (parseFloat(json_array_salesquote[i].selling_price) * parseFloat(json_array_salesquote[i].discount_percentage)) / 100;
                        quoteamnt = parseFloat(json_array_salesquote[i].selling_price) - parseFloat(selldisamt);

                        if (json_array_salesquote[i].subject == '' && json_array_salesquote[i].so_number == '' && json_array_salesquote[i].do_number == '' && json_array_salesquote[i].invoice_number == '') {

                        } else {
                            if (contact_id == '') {
                                option2 += '<tr>';
                                option2 += '<td> <a href="' + urls1 + '" target="_blank">' + json_array_salesquote[i].subject + '</a><br>PRICE :' + quoteamnt + '</td>';
                                option2 += '<td> </td>';
                                option2 += '<td> </td>';
                                option2 += '<td> </td>';
                                option2 += '</tr>';
                            } else {
                                if (json_array_salesquote[i].quotecontact != null) {
                                    if (json_array_salesquote[i].quotecontact == contact_id) {

                                        option2 += '<tr>';
                                        option2 += '<td> <a href="' + urls1 + '" target="_blank">' + json_array_salesquote[i].subject + '</a>PRICE :' + quoteamnt + '</td>';
                                        option2 += '<td></td>';
                                        option2 += '<td> </td>';
                                        option2 += '<td> </td>';
                                        option2 += '</tr>';
                                    }
                                }
                            }





                        }
                    }
                    option3 += '<thead class="bg-medium-gray"></thead>';
                    option3 += '<tr>';
                    option3 += '<td><span class="" >Current Stock:</span></td>';
                    option3 += '<td>' + json_array_service.current_stock + '</td>';
                    option3 += '</tr>';
                    option3 += '<tr>';
                    option3 += '<td><span class="" >Service Qty:</span></td>';
                    option3 += '<td>' + json_array_service.service_quantity + '</td>';
                    option3 += '</tr>';
                    option3 += '<tr>';
                    option3 += '<td><span class="" >Damaged Qty:</span></td>';
                    option3 += '<td>' + json_array_service.damaged_qty + '</td>';
                    option3 += '</tr>';
                    option3 += '<tr>';
                    option3 += '<td><span class="" >Demo Qty:</span></td>';
                    option3 += '<td>' + json_array_service.demo_qty + '</td>';
                    option3 += '</tr>';
                    option3 += '<td><span class="" >Stock Status:</span></td>';
                    option3 += '<td>' + json_array_service.stock_status + '</td>';
                    option3 += '</tr>';
                    option3 += '<td><span class="" >So Qty:</span></td>';
                    option3 += '<td>' + soqty + '</td>';
                    option3 += '</tr>';
                    $('.history_table_details').html(option);
                    $('.history_table_details_sales').html(option2);
                    $('.history_table_details_service').html(option3);
                });
            }
        }

    });
    $('body').on('click', '#btn_addservice_search', function () {
        var count_checked = $("#addservice_search .newpickservice:checkbox:checked").length;
        console.log(count_checked);
        //        anjup for tax--------->
        var tax_enabled = $("#tax_enabled").val();
        var tax_type_value = $(".tax_type").val();
        var sales_accnt_id = '';
        var salesaccnt_id_intra = $("#salesaccnt_id_intra").val();
        var salesaccnt_id_inter = $("#salesaccnt_id_inter").val();
        var salesaccnt_id_export = $("#salesaccnt_id_export").val();
        var salesaccnt_id_service = $("#salesaccnt_id_service").val();
        var bcd_type = $("#ser_bcd_type").val();
        var bcd = $("#ser_bcd").val();
        if (tax_type_value == 'intra_state') {
            sales_accnt_id = salesaccnt_id_intra;
        } else if (tax_type_value == 'inter_state') {
            sales_accnt_id = salesaccnt_id_inter;
        } else if (tax_type_value == 'export') {
            sales_accnt_id = salesaccnt_id_export;
        }
        var servc_taxids = [];
//        END<-------------------
        var services_array = [];
        var services_qty_array = [];
        var services_price_array = [];
        var services_name_array = [];
        var sac_services = [];
        var servc_itemids = [];
        var range_services = [];
        var option = '';
        if (count_checked > 0) {
            $("#addservice_search .newpickservice").each(function () {
                if ($(this).is(":checked")) {
                    services_array.push($(this).val());
                    servc_itemids.push($(this).attr('item_id'));
                    //        anjup for tax--------->
                    if (tax_enabled != -1) {
                        servc_taxids.push($(this).attr('servicetaxid'));
                    }
                    //END<-------------------
                    services_qty_array.push($(this).closest('tr').find('.service_qty').val());
                    services_price_array.push($(this).closest('tr').find('.service_price').val());
                    services_name_array.push($(this).closest('tr').find('.service_names').val());
                    sac_services.push($(this).closest('tr').find('.sac_services').val());
                    range_services.push($(this).closest('tr').find('.range_services').val());
                }
            });
            var hiddn_master_idcl = $('.hiddn_master_idcl').val();
            if (hiddn_master_idcl == 0) {

            }
            var sid = $('#trid_ser_search').val();
            var sll = $('[id-cl_ser=' + sid + ']');

            var sel_count = 1;



            var currency_rate = $('#currency_rate').val();
            var full_rate_id = $('#rate_id_full_search').val();
            var trid = $('#trid_ser_search').val();
            var sac = $('#sac_search').val();
            var item_description = $('#item_description_search').val();
            var ser_unit_id = $('#select_ser_unit_search').val();
            var ser_unit = $('#select_ser_unit_search_value').val();
            var servceid = $('#serviceid_so_servce_search').val();
            var unit_code = $('#select_ser_unit_search').attr('unit_code');
            var ser_qty = $('#ser_qty_search').val();
            var final_rate = $('#final_rate_total_search').val();
            var ind_rates = $('#ind_rate_search').val();
            var hour_day = $('#ind_estimate_value_search').val();
            var name = $('#service_name_search_view').val();
            var item_id = $('#serviceid_so_servce_search').val();

//        anjup for tax--------->
            var selectedtaxgrp = '';
            //        END<-------------------
            for (var i = 0; i < services_array.length; i++) {
                //        anjup for tax--------->
                selectedtaxgrp = servc_taxids[i];
                //        END<-------------------
                var ser_mas_idcl = sid + '_' + sel_count;
                option += '<tr class="serv_tbltr" id-newtr="' + ser_mas_idcl + '">';
                option += '<td class="p0 pa-2  w2 text-center vat"><a href="#" class="clear_services text-danger" tbody_cnt="' + trid + '"><i class="icon lindo-android-remove-circle fz-22 txt-danger" ></i></a></td>';
                option += '<td class="p0 pa-2 w2 text-center vat"><input type="hidden" class="form-control service_ids"  readonly value="' + services_array[i] + '" name="service_ids[]" /><input type="hidden" class="form-control item_ids_service" name="item_ids_service[]" readonly value="' + servc_itemids[i] + '" /><input type="text" class="form-control" readonly value="' + services_name_array[i] + '" /></td>';
                option += '<td class="p0 pa-2 w2 text-center vat"><input type="text" class="form-control ser_quan allow_float number_validate" id="ser_quan" name="ser_quan[]" value="' + services_qty_array[i] + '"> </td>';
                option += '<td class="p0 pa-2 w2 text-center vat"><input type="text" class="form-control ser_unitcost" name="ser_unitcost[]" id="ser_unitcost" value="' + services_price_array[i] + '"><input type="hidden" readonly="" class="form-control ser_unitcost_hidden" value="' + services_price_array[i] + '"></td>';


                option += '<td class="p0 pa-5 w2 text-center vat"><table><tr><td class="pa-5">SAC:</td><td class="pa-5"><input type="text"  class="form-control ser_new ser_sac w100 input-to-label" id="ser_new" id-cl_ser="1" name="ser_sacs[]" value="' + sac_services[i] + '"></td><td class="pa-5"><label data-tooltip="Range or accuracy">R/A:</label></td><td class="pa-5"><input type="text" class="form-control ser_range input-to-label"  name="ser_range[]" id="ser_range" value="' + range_services[i] + '"></td></tr></table></td>';
                option += '<input type="hidden"  class="form-control ser_unit_id" name="unit_id[]" id="ser_unit_id">';
                option += '</div>  </td>';
                option += '<td class="p0 pa-2 w2 text-center vat"><input type="number" step="0.01" min="0" class="form-control ser_dis allow_float ser_dis " id="ser_dis" ser_from_disc="ser_per_dicount" name="ser_dis[]" value="0"></td>';
                option += '<td class="p0 pa-2 w2 text-center vat"><input type="number" step="0.01" min="0" class="form-control ser_item_dis_amt allow_float  " id="ser_item_dis_amt" name="ser_item_dis_amt[]" value="0"> <input type="hidden"  class="form-control ser_dist_amt" id="ser_dist_amt" name="ser_dist_amt[]" value="0"></td>';
                //               <-----anjup for tax----------->
                if (tax_enabled != -1) {
                    if (alltax_details != null) {
                        for (var ii = 0; ii < alltax_details.length; ii++) {
                            option += '<td class="p0 pa-2 w2 text-center vat"><div class="form-group col-md-12 pa-0 ma-0 sertaxdetails">';
                            option += '<input type="text" readonly class="form-control servtax ser_tax_details_' + alltax_details[ii]['tax_master_id'] + '" id="tax_masterid_' + alltax_details[ii]['tax_master_id'] + '" name="ser_tax_details_' + alltax_details[ii]['tax_master_id'] + '[]" taxmaster_id="' + alltax_details[ii]['tax_master_id'] + '" tax_groupid="' + alltax_details[ii]['tax_group_id'] + '" tax_id="' + alltax_details[ii]['tax_id'] + '"';
                            if (alltax_details[ii]['tax_group_id'] == servc_taxids[i]) {
                                option += 'value="' + alltax_details[ii]['tax_rate'] + '% : ">';
                            }
                            option += '</div>';
                            option += '<input type="hidden" readonly class="form-control ser_taxslab ser_taxslab_' + alltax_details[ii]['tax_master_id'] + '" id="ser_taxslab_' + alltax_details[ii]['tax_master_id'] + '" name="ser_taxslab_' + alltax_details[ii]['tax_master_id'] + '[]" value="">';
                            option += '<input type="hidden" readonly class="form-control  ser_sales_account_id_' + alltax_details[ii]['tax_master_id'] + '" id="ser_sales_account_id_' + alltax_details[ii]['tax_master_id'] + '" name="ser_sales_account_id_' + alltax_details[ii]['tax_master_id'] + '[]" value="">';
                            option += '</td>';
                        }
                    }
                }
//               <-----END----------->
                option += '<td class="p0 pa-2 w2 text-center vat"><input type="text" class="form-control ser_amount " readonly="" name="ser_amount[]" id="ser_amount" value="0"></td>';
                option += '</tr>';
                sel_count++;
            }
            //anju for tax------------->
            sll.find('.selected_service_taxgrp').val(selectedtaxgrp);
            sll.find('.ser_sales_account_id').val(sales_accnt_id);
            sll.find('.selected_service_taxgrp_count').val(services_array.length);
//END<----------------------
            var ff = sll.find('.ser_sac');
            ff.val(sac);
            var ii = sll.find('.ser_description');
            ii.val(item_description);
            var iis = sll.find('.comments_ser');
            iis.val(name);
            var ii1 = sll.find('.service_item_id');
            ii1.val(item_id);
            var ii = sll.find('.ser_names');
            ii.val(name);
            var qq = sll.find('.ser_unit'); //for purchase order
            qq.val(ser_unit);
            var qq = sll.find('.ser_unit_id'); //for purchase order
            qq.val(ser_unit_id);
//            var pp = sll.find('.ser_range'); //for quote
//            pp.val(ser_range);
//            var uu = sll.find('.ser_unitcost'); //for quote
//            uu.val(ser_unitcoste);
            var type = sll.find('.ser_quan'); //for quote
            type.val(0);
            var am = sll.find('.ser_amount'); //for quote
            am.val('');
            var dis = sll.find('.ser_dis'); //for quote
            dis.val(0);
//            sll./find('.ser_unitcost_hidden').val(serunitcoste);
            var disser = sll.find('.serviceid_ser'); //for quote
            disser.val(servceid);
            var disser = sll.find('#view_details'); //for quote
            disser.attr('iditem', servceid);
            var disser = sll.find('#view_history'); //for quote
            disser.attr('iditem', servceid);
            var frate = sll.find('.final_rate'); //for quote
            frate.val(final_rate);
            var cost_center_id = [];
            $('#addservice_search .cost_center_search').each(function () {
                if ($(this).val() != '') {
                    cost_center_id.push($(this).val());
                }
            })
            sll.find('.cost_center_id').val(cost_center_id);
            var cost_center_category_id = [];
            $('#addservice_search .cost_center_category_search').each(function () {
                if ($(this).val() != '') {
                    cost_center_category_id.push($(this).val());
                }
            })
            sll.find('.cost_center_category_id').val(cost_center_category_id);

            var rate_master_id = [];
            $('#addservice_search .rate_master_id_search').each(function () {
                if ($(this).val() != '') {
                    rate_master_id.push($(this).val());
                }
            })
            sll.find('.final_rate_ids').val(rate_master_id);
            var rate_db = [];
            $('#addservice_search .rate_db_search').each(function () {
                if ($(this).val() != '') {
                    rate_db.push($(this).val());
                }
            })
            sll.find('.rate_type').val(rate_db);
            var estimate = [];
            $('#addservice_search .estimate_search').each(function () {
                if ($(this).val() != '') {
                    estimate.push($(this).val());
                }
            })
            sll.find('.hour_day').val(estimate);
            var cost_type = [];
            $('#addservice_search .cost_type_search').each(function () {
                if ($(this).val() != '') {
                    cost_type.push($(this).val());
                }
            })
            sll.find('.rate_type_value').val(cost_type);
            var sub_total = [];
            $('#addservice_search .ind_final_rate_search').each(function () {
                if ($(this).val() != '') {
                    sub_total.push($(this).val());
                }
            })
            sll.find('.sub_total').val(sub_total);
            sll.find('.ser_barcode_type').val(bcd_type);
            sll.find('.ser_common_barcode').val(bcd);
            $('#addservice_search').modal('hide');
            sll.find(".serv_tbltr").remove();
            sll.find(".ser_new").prop('disabled', true);
            $(".serv_tbl[id-cl_ser='" + sid + "']").append(option);
//        $('.serv_tbl').append(option);
            $('.ser_quan').trigger('keyup');
            $('#net_amt').trigger('change');
        } else {
            swal("please check service master");
        }

    });
    $('body').on('keyup', '#servicenam', function () {
        var servicenam_des = $(this).val();
        $('#item_description').val(servicenam_des);
    });
    $('body').on('click', '#btn_addservice', function () {
        var option = '';
        var currency_rate = $('#currency_rate').val();
        var trid = $('#trid_ser').val();
        var servicenam = $('#AddService #servicenam').val();
        var item_description = $('#AddService #item_description').val();
        var ser_unit = $('#AddService #select_ser_unit').val();
        var unit_code = $('#AddService #select_ser_unit option:selected').attr('unit_code');
        var serunitcoste = $('#AddService #ser_unitcoste').val();

        //anjup for tax-------------->
        var tax_enabled = $('#tax_enabled').val();
        var interstate_tax = -1;
        var intrastate_tax = -1;
        var export_tax = -1;
        var service_tax = -1;
        var tax_type = 'inclusive';
        if (tax_enabled != -1) {
            interstate_tax = $('#AddService #interstate_tax').val();
            intrastate_tax = $('#AddService #intrastate_tax').val();
            export_tax = $('#AddService #export_tax').val();
            service_tax = $('#AddService #service_tax').val();
            tax_type = $('#AddService .tax_typein:checked').val();
            var maintax_type = $('.tax_type:checked').val();
        }
        //END<------------------------

        var ser_unitcoste = parseFloat(serunitcoste) * parseFloat(currency_rate)
        var ser_range = $('#AddService #ser_rangeaccu').val();
        var servcename = $('#AddService #servicenam').val();
        var itm_id = $('#AddService #item_id_service').val();
        var full_rate_id = $('#AddService #rate_id_full').val();
        var servicenam = $('#AddService #servicenam').val();
        var page_type = $('#AddService .page_type').val();
        var pagecheck = "js";
        var ischeck = false;
        var ser_mas_name = [];
        var ser_price_mas = [];
        var ser_range_mas = [];
        var ser_des_mas = [];
        $('.servicename').each(function () {
            ser_mas_name.push($(this).val());
            ser_price_mas.push($(this).closest('tr').find('.serviceprice').val());
            ser_range_mas.push($(this).closest('tr').find('.rangeaccuracy').val());
            ser_des_mas.push($(this).closest('tr').find('.sedescription').val());
        });

        //Jess//
        var amc_check = 0;
//        if ($('#ck_amc:checkbox:checked')) {
        if ($('#ck_amc').prop("checked") == true) {
            amc_check = 1;
        }
        var warranty_check = 0;
//        if ($('#ck_warranty:checkbox:checked')) {
        if ($('#ck_warranty').prop("checked") == true) {
            warranty_check = 1;
        }
        var check_certificate = 0;
//        if ($('#chk_certificate:checkbox:checked')) {
        if ($('#chk_certificate').prop("checked") == true) {
            check_certificate = 1;
        }

        var cer_array = {};
        $(".cer_param_name").each(function () {
            var close_tr = $(this).closest('tr');
            var cer_name = $(this).val();
            var cer_val = close_tr.find('.cer_param_value').val();
            var cer_order = close_tr.find('.cer_param_order').val();
            cer_array[cer_order] = {name: cer_name, value: cer_val};
        });
        var data_array = {};
        $(".data_param_name").each(function () {
            var close_tr = $(this).closest('tr');
            var cer_name = $(this).val();
            var cer_val = close_tr.find('.data_param_value').val();
            var cer_order = close_tr.find('.data_param_order').val();
            data_array[cer_order] = {name: cer_name, value: cer_val};
        });
        var manufacture = $('#AddService #selectmanufacturer option:selected').val();
        var brand = $('#AddService #selectbrand option:selected').val();
        //Jess//
        if (servicenam == "") {
            swal("required", "Service Name required", "error");
            ischeck = true;
        }
        if (item_description == "") {
            swal("required", "Service Description required", "error");
            ischeck = true;
        }
        if (unit_code == "") {
            swal("required", "unit code required", "error");
            ischeck = true;
        }
        if (ischeck == false) {
            $('#jquery_mask').show();
            $.post(siteurl + "/Crm/Deals/insert_service_product_from_js", {sername: servcename, item_description: item_description, select_ser_unit: ser_unit,
                ser_unitcoste: ser_unitcoste, ser_rangeaccu: ser_range, item_id_service: itm_id, pagecheck: pagecheck,
                amc_check: amc_check, warranty_check: warranty_check, check_certificate: check_certificate, cer_array: JSON.stringify(cer_array),
                data_array: JSON.stringify(data_array), manufacture: manufacture, brand: brand, ser_mas_name: JSON.stringify(ser_mas_name), ser_price_mas: JSON.stringify(ser_price_mas), ser_range_mas: JSON.stringify(ser_range_mas), ser_des_mas: JSON.stringify(ser_des_mas), tax_enabled: tax_enabled, interstate_tax: interstate_tax, intrastate_tax: intrastate_tax, export_tax: export_tax, service_tax: service_tax, tax_type: tax_type}, function (result)
            {
                $('#jquery_mask').hide();
                var j_sac_itm_array = JSON.parse(result);
                var insert_id = j_sac_itm_array.itemid;
                var sac = j_sac_itm_array.sacid;
                var servid_sac = j_sac_itm_array.servid_sac;
                var cost_center_id = $('#full_cost_center').val();
                var cost_center_category_id = $('#full_cost_center_category').val();
                var final_rate = $('#final_rate_total').val();
                var cost_type = $('#ind_type').val();
                var ind_rates = $('#ind_rate').val();
                var hour_day = $('#ind_estimate_value').val();
                var sid = $('#trid_ser').val();
                var sll = $('[id-cl_ser=' + sid + ']');
                var ff = sll.find('.ser_sac');
                ff.val(sac);
                var ii = sll.find('.ser_description');
                ii.val(item_description);

                var ii = sll.find('.ser_names');
                ii.val(servicenam);
                var des = sll.find('.comments_ser');
                des.val(item_description);
                var ii = sll.find('.selected_service_taxgrp');
                ii.val(service_tax);
                var ii = sll.find('#view_details');
                ii.attr('iditem', insert_id);
                var ii = sll.find('#view_history');
                ii.attr('iditem', insert_id);
                var qq = sll.find('.ser_unit'); //for purchase order
                qq.val(unit_code);
                var qq = sll.find('.ser_unit_id'); //for purchase order
                qq.val(ser_unit);
                var pp = sll.find('.ser_range'); //for quote
                pp.val(ser_range);
                var uu = sll.find('.ser_unitcost'); //for quote
                uu.val(ser_unitcoste);
                sll.find('.ser_unitcost_hidden').val(serunitcoste);
                $('.totalservicesss').val(ser_unitcoste);
                var total = sll.find('.ser_amount');
                total.val(0);
                var sum = 0;
                $('.ser_amount').each(function () {
                    sum += Number($(this).val());
                });
                $('.totalservicesss').val(parseFloat(sum));
                $('#ser_total').val(parseFloat(sum));
                var type = sll.find('.ser_quan'); //for quote
                type.val(0);
                var am = sll.find('.ser_amount'); //for quote
                var final = parseFloat($('.totalservicesss').val()) + parseFloat($('#totalproduct').val());
                $('#net_amt').val(parseFloat(final));
                var dis = sll.find('.ser_dis'); //for quote
                dis.val(0);
                var cos = sll.find('.cost_center_id'); //for quote
                cos.val(cost_center_id);
                var ccntr = sll.find('.cost_center_category_id'); //for quote
                ccntr.val(cost_center_category_id);
                var frate = sll.find('.final_rate'); //for quote
                frate.val(final_rate);
                var val = sll.find('.rate_type_value'); //for quote
                val.val(cost_type);
                var mn = sll.find('.rate_type'); //for quote
                mn.val(ind_rates);
                var sd = sll.find('.serviceid_ser'); //for quote
                sd.val(insert_id);
                var sd = sll.find('.ser_quan_serv'); //for quote
                if (page_type == "from_grv") {
                    sd.val(0);
                } else {
                    sd.val(1);
                }
                var sd = sll.find('.hour_day'); //for quote
                sd.val(hour_day);
                var sds = sll.find('.final_rate_ids'); //for quote
                sds.val(full_rate_id);
                var sds1 = sll.find('.rate_id_full_pick');
                sds1.val(full_rate_id);
                var rate_modal = new Array();
                var rate_mod = '';
                $('.ind_final_rate').each(function () {
                    rate_modal.push($(this).val());
                });
                rate_mod = rate_modal.join(",");
                sll.find('.sub_total').val(rate_mod);

                for (var i = 0; i < ser_mas_name.length; i++) {
                    option += '<tr class="serv_tbltr" id-newtr=' + sid + '_' + (i + 1) + '>';
                    option += '<td><a href="#" class="clear_services text-danger"><i class="icon lindo-android-remove-circle fz-22 txt-danger"></i></a></td>';
                    option += '<td><input type="hidden" class="form-control service_ids"  readonly value="' + servid_sac[i].service_id + '" name="service_ids[]" /><input type="hidden" class="form-control item_ids_service" name="item_ids_service[]" readonly value="' + insert_id + '" /><input type="text" class="form-control" readonly value="' + ser_mas_name[i] + '" /></td>';
                    if (page_type == "from_grv") {
                        option += '<td><input type="text" class="form-control ser_quan allow_float number_validate" id="ser_quan" name="ser_quan[]" value="0"> </td>';
                    } else {
                        option += '<td><input type="text" class="form-control ser_quan allow_float number_validate" id="ser_quan" name="ser_quan[]" value="1"> </td>';

                    }
                    option += '<td><input type="text" class="form-control ser_unitcost" name="ser_unitcost[]" id="ser_unitcost" value="' + ser_price_mas[i] + '"><input type="hidden" readonly="" class="form-control ser_unitcost_hidden" value="' + ser_price_mas[i] + '"></td>';
                    option += '<td><div class="form-group"><b>SAC: </b><input type="text"  class="form-control ser_new ser_sac w100 input-to-label" id="ser_new" id-cl_ser="1" name="ser_sacs[]" value="' + servid_sac[i].sac + '">';
                    option += '<b>Range/Accuracy: </b><input type="text" class="form-control ser_range input-to-label"  name="ser_range[]" id="ser_range" value="' + ser_range_mas[i] + '">';
                    option += '<input type="hidden"  class="form-control ser_unit_id" name="unit_id[]" id="ser_unit_id">';
                    option += '</div> </td>';
                    option += '<td><input type="number" class="form-control ser_dis allow_float ser_dis " id="ser_dis" ser_from_disc="ser_per_dicount" name="ser_dis[]" value="0"></td>';
                    option += '<td><input type="number" class="form-control ser_item_dis_amt allow_float  " id="ser_item_dis_amt" name="ser_item_dis_amt[]" value="0"> <input type="hidden"  class="form-control ser_dist_amt" id="ser_dist_amt" name="ser_dist_amt[]" value="0"></td>';
                    //               <-----anjup for tax----------->
                    if (tax_enabled != -1) {
                        for (var ii = 0; ii < alltax_details.length; ii++) {
                            option += '<td class="p0 pa-2 w2 text-center vat"><div class="form-group col-md-12 pa-0 ma-0 sertaxdetails">';
                            option += '<input type="text" readonly class="form-control servtax ser_tax_details_' + alltax_details[ii]['tax_master_id'] + '" id="tax_masterid_' + alltax_details[ii]['tax_master_id'] + '" name="ser_tax_details_' + alltax_details[ii]['tax_master_id'] + '[]" taxmaster_id="' + alltax_details[ii]['tax_master_id'] + '" tax_groupid="' + alltax_details[ii]['tax_group_id'] + '" tax_id="' + alltax_details[ii]['tax_id'] + '"';
                            if (alltax_details[ii]['tax_group_id'] == service_tax) {
                                option += 'value="' + alltax_details[ii]['tax_rate'] + '% : ">';
                            }
                            option += '</div></td>';
                        }
                    }
//               <-----END----------->
                    option += '<td><input type="text" class="form-control ser_amount " readonly="" name="ser_amount[]" id="ser_amount" value="0"></td>';
                    option += '</tr>';
                }

                $(".serv_tbl[id-cl_ser='" + sid + "']").append(option);
                $('.ser_quan').trigger('keyup');
                $('#net_amt').trigger('change');
                $('#AddService').modal('hide');

            });
        } else {
            swal('Enter all details');
        }
    });

    $('body').on('click', '#btn_addservice_pick', function () {
        var currency_rate = $('#currency_rate').val();
        var trid = $('#trid_ser').val();
        var serunitcoste = $('#AddService_common #ser_unitcoste').val();
        //        anjup for tax--------->
        var tax_enabled = $("#tax_enabled").val();
        var tax_type_value = $(".tax_type").val();
        var sales_accnt_id = '';
        var salesaccnt_id_intra = $("#salesaccnt_id_intra").val();
        var salesaccnt_id_inter = $("#salesaccnt_id_inter").val();
        var salesaccnt_id_export = $("#salesaccnt_id_export").val();
        var salesaccnt_id_service = $("#salesaccnt_id_service").val();
        if (tax_type_value == 'intra_state') {
            sales_accnt_id = salesaccnt_id_intra;
        } else if (tax_type_value == 'inter_state') {
            sales_accnt_id = salesaccnt_id_inter;
        } else if (tax_type_value == 'export') {
            sales_accnt_id = salesaccnt_id_export;
        }
        var servc_taxids = [];
//        END<-------------------
        var ser_unitcoste = parseFloat(serunitcoste) * parseFloat(currency_rate)

        var ser_range = $('#AddService_common #ser_rangeaccu').val();
        var full_rate_id = $('#AddService_common #rate_id_full_pick').val();
        var pagecheck = "js";
        var final_rate = $('#final_rate_total_pick').val();
        var ind_rates = $('#ind_rate_pick').val();
        var servicenam = $('#servicenam').val();
        var sid = $('#trid_ser').val();
        var sll = $('[id-cl_ser=' + sid + ']');
        var pp = sll.find('.ser_range'); //for quote
        pp.val(ser_range);
//        var uu = sll.find('.ser_unitcost'); //for quote
//        uu.val(ser_unitcoste);
        $('.totalservicesss').val(ser_unitcoste);
//        var total = sll.find('.ser_amount');
//        total.val(0);
//        var sum = 0;
//        $('.ser_amount').each(function () {
//            sum += Number($(this).val());
//        });
//        $('.totalservicesss').val(parseFloat(sum));
//        $('#ser_total').val(parseFloat(sum));
//        var type = sll.find('.ser_quan'); //for quote
//        type.val(0);
//        var am = sll.find('.ser_amount'); //for quote
//        var final = parseFloat($('.totalservicesss').val()) + parseFloat($('#totalproduct').val());
//        $('#net_amt').val(parseFloat(final));
//        am.val('');
//        var dis = sll.find('.ser_dis'); //for quote
//        dis.val(0);
        var frate = sll.find('.final_rate'); //for quote
        sll.find('.ser_unitcost_hidden').val(serunitcoste);
        frate.val(final_rate);
        var cost_center_id = [];
        $('#AddService_common .cost_center_pick').each(function () {
            if ($(this).val() != '') {
                cost_center_id.push($(this).val());
            }
        })
        sll.find('.cost_center_id').val(cost_center_id);



        var cost_center_category_id = [];
        $('#AddService_common .cost_center_category_pick').each(function () {

            if ($(this).val() != '') {
                cost_center_category_id.push($(this).val());
            }
        })

        sll.find('.cost_center_category_id').val(cost_center_category_id);


        var rate_master_id = [];

        $('#AddService_common .rate_master_id_pick').each(function () {
            if ($(this).val() != '') {
                rate_master_id.push($(this).val());
            }
        })
        sll.find('.final_rate_ids').val(rate_master_id);

        var rate_db = [];
        $('#AddService_common .rate_db_pick').each(function () {
            if ($(this).val() != '') {
                rate_db.push($(this).val());
            }
        })
        sll.find('.rate_type').val(rate_db);

        var estimate = [];
        $('#AddService_common .estimate_deal_pick').each(function () {
            if ($(this).val() != '') {
                estimate.push($(this).val());
            }
        })
        sll.find('.hour_day').val(estimate);

        var cost_type = [];
        $('#AddService_common .cost_type_pick').each(function () {
            if ($(this).val() != '') {
                cost_type.push($(this).val());
            }
        })
        sll.find('.rate_type_value').val(cost_type);

        var sub_total = [];
        $('#AddService_common .ind_final_rate_pick').each(function () {
            if ($(this).val() != '') {
                sub_total.push($(this).val());
            }
        })

        sll.find('.sub_total').val(sub_total);
        var services_array = [];
        var services_qty_array = [];
        var services_price_array = [];
        var services_name_array = [];
        var sac_services = [];
        var servc_itemids = [];
        var range_services = [];
        var option = '';
        $(".pickservices:checkbox:checked").each(function () {
            services_array.push($(this).val());
            servc_itemids.push($(this).attr('item_id'));
            services_qty_array.push($(this).closest('tr').find('.service_qty').val());
            services_price_array.push($(this).closest('tr').find('.service_price').val());
            services_name_array.push($(this).closest('tr').find('.service_names').val());
            sac_services.push($(this).closest('tr').find('.sac_services').val());
            range_services.push($(this).closest('tr').find('.range_services').val());
        });
        var selectedtaxgrp = $(".pickservices").attr('servicetaxid');
        for (var i = 0; i < services_array.length; i++) {
            option += '<tr class="serv_tbltr" id-newtr=' + (i + 1) + '>';
            option += '<td class="p0 pa-2  w2 text-center vat"><a href="#" class="clear_services text-danger" tbody_cnt="' + trid + '"><i class="icon lindo-android-remove-circle fz-22 txt-danger" ></i></a></td>';
            option += '<td class="p0 pa-2 w2 text-center vat"><input type="hidden" class="form-control service_ids"  readonly value="' + services_array[i] + '" name="service_ids[]" /><input type="hidden" class="form-control item_ids_service" name="item_ids_service[]" readonly value="' + servc_itemids[i] + '" /><input type="text" class="form-control" readonly value="' + services_name_array[i] + '" /></td>';
            option += '<td class="p0 pa-2 w2 text-center vat"><input type="text" class="form-control ser_quan allow_float number_validate" id="ser_quan" name="ser_quan[]" value="' + services_qty_array[i] + '"> </td>';
            option += '<td class="p0 pa-2 w2 text-center vat"><input type="text" class="form-control ser_unitcost" name="ser_unitcost[]" id="ser_unitcost" value="' + services_price_array[i] + '"><input type="hidden" readonly="" class="form-control ser_unitcost_hidden" value="' + services_price_array[i] + '"></td>';
            option += '<td class="p0 pa-5 w2 text-center vat"><table><tr><td class="pa-5">SAC:</td><td class="pa-5"><input type="text"  class="form-control ser_new ser_sac w100 input-to-label" id="ser_new" id-cl_ser="1" name="ser_sacs[]" value="' + sac_services[i] + '"></td><td class="pa-5"><label data-tooltip="Range or accuracy">R/A:</label></td><td class="pa-5"><input type="text" class="form-control ser_range input-to-label"  name="ser_range[]" id="ser_range" value="' + range_services[i] + '"></td></tr></table></td>';
            option += '<input type="hidden"  class="form-control ser_unit_id" name="unit_id[]" id="ser_unit_id">';
            option += '</div>  </td>';
            option += '<td class="p0 pa-2 w2 text-center vat"><input type="number" min="0" class="form-control ser_dis allow_float ser_dis " id="ser_dis" ser_from_disc="ser_per_dicount" name="ser_dis[]" value="0"></td>';
            option += '<td class="p0 pa-2 w2 text-center vat"><input type="number" min="0" class="form-control ser_item_dis_amt allow_float  " id="ser_item_dis_amt" name="ser_item_dis_amt[]" value="0"> <input type="hidden"  class="form-control ser_dist_amt" id="ser_dist_amt" name="ser_dist_amt[]" value="0"></td>';
            //               <-----anjup for tax----------->
            if (tax_enabled != -1) {
                if (alltax_details != null) {
                    for (var ii = 0; ii < alltax_details.length; ii++) {
                        option += '<td class="p0 pa-2 w2 text-center vat"><div class="form-group col-md-12 pa-0 ma-0 sertaxdetails">';
                        option += '<input type="text" readonly class="form-control servtax ser_tax_details_' + alltax_details[ii]['tax_master_id'] + '" id="tax_masterid_' + alltax_details[ii]['tax_master_id'] + '" name="ser_tax_details_' + alltax_details[ii]['tax_master_id'] + '[]" taxmaster_id="' + alltax_details[ii]['tax_master_id'] + '" tax_groupid="' + alltax_details[ii]['tax_group_id'] + '" tax_id="' + alltax_details[ii]['tax_id'] + '"';
                        if (alltax_details[ii]['tax_group_id'] == selectedtaxgrp) {
                            option += 'value="' + alltax_details[ii]['tax_rate'] + '% : ">';
                        }
                        option += '</div>';
                        option += '<input type="hidden" readonly class="form-control ser_taxslab ser_taxslab_' + alltax_details[ii]['tax_master_id'] + '" id="ser_taxslab_' + alltax_details[ii]['tax_master_id'] + '" name="ser_taxslab_' + alltax_details[ii]['tax_master_id'] + '[]" value="">';
                        option += '<input type="hidden" readonly class="form-control  ser_sales_account_id_' + alltax_details[ii]['tax_master_id'] + '" id="ser_sales_account_id_' + alltax_details[ii]['tax_master_id'] + '" name="ser_sales_account_id_' + alltax_details[ii]['tax_master_id'] + '[]" value="">';
                        option += '</td>';
                    }
                }
            }
//               <-----END----------->

            option += '<td class="p0 pa-2 w2 text-center vat"><input type="text" class="form-control ser_amount " readonly="" name="ser_amount[]" id="ser_amount"></td>';
            option += '</tr>';

        } //anju for tax------------->
        sll.find('.selected_service_taxgrp').val(selectedtaxgrp);
        sll.find('.ser_sales_account_id').val(sales_accnt_id);
        sll.find('.selected_service_taxgrp_count').val(services_array.length);
//END<----------------------
        $(".serv_tbl[id-cl_ser='" + sid + "']").append(option);
        $('#AddService_common').modal('hide');
        $('.ser_quan').trigger('keyup');
        $('#net_amt').trigger('change');

    });

    $("#nonpro_costprice,#nonpro_markup").keyup(function () {
        if ($('#nonpro_markup').val() != "0")
        {
            $('#nonpro_sellingprice').attr('readonly', true);
            var percentage = (parseFloat(($('#nonpro_costprice').val()) * parseFloat($('#nonpro_markup').val())) / 100);
            $('#nonpro_sellingprice').val(parseFloat(percentage) + parseFloat($('#nonpro_costprice').val()));
        } else if
                ($('#nonpro_markup').val() == "0")
        {
            $('#nonpro_sellingprice').attr('readonly', false);
        }
    });
    $('body').on('click', '.editts', function () {
        //nid area
        var charge_amount = $(this).closest('tr').find('.charge_charge').val();
        var charge_description = $(this).closest('tr').find('.charge_description').val();
        var charge_paidby = $(this).closest('tr').find('.charge_paidby').val();
        var charge_qty = $(this).closest('tr').find('.charge_qty').val();
        var charge_unit = $(this).closest('tr').find('.charge_unit').val();
        var associated_chrg_id = $(this).closest('tr').find('.associated_chrg_id').val();
        $('#asso_extra_chrg').val(associated_chrg_id).trigger("change");
        $('#charge').val(charge_amount);
        $('#ch_qty').val(charge_qty);
        $('#selectunit').val(charge_unit);
        $('#charge_hidden').val(charge_amount);
        $('#charge_discription').val(charge_description);
        if (charge_paidby == 'customer') {
            $('.customercls').prop('checked', true);
        } else {
            $('.companycls').prop('checked', true);
        }

    });
    $('body').on('click', '.remove_cos_clone_search', function (e) {
        var cost_per_unit = $('#ser_unitcoste_search').val();
        if (cost_per_unit == '') {
            cost_per_unit = 0;
        }
        var clone_id = $(this).closest('div.cpn').attr('cl');
        ;
        var newvalue = $(this).parents('.div_clone_search').find('.ind_final_rate_search').val();
        var currnt = $('.final_rate_total_search').val();
        var new_value = Number(currnt) - Number(newvalue);
        $('.final_rate_total_search').val(new_value);
        var sum = 0;
        $('.ind_final_rate_search').each(function () {
            sum += Number($(this).val());
        });
        if (sum == '') {
            sum = 0;

        }
        var option = '';
        var profit_loss = 0;
        profit_loss = parseFloat(cost_per_unit) - parseFloat(sum);
        if (parseFloat(profit_loss) > 0) {
            option += ' <label class="control-label txt-success">Profit:' + parseFloat(profit_loss) + '</label>'

        } else if (parseFloat(profit_loss) < 0) {
            option += ' <label class="control-label txt-danger">Loss:' + parseFloat(profit_loss) + '</label>'
        }
        $('.profit_loss_div').html(option);
        if (clone_id != 1)
        {
            $(this).closest('div.cpn').remove();
        } else
        {
            var dd = $(this).closest('div.cpn').find("input");
            dd.val("");
            $(this).closest('div.cpn').find('.cost_center_category_search').val('');
            $(this).closest('div.cpn').find('.cost_center_search').val('');
        }

    });
    $('body').on('change', '#AddService_common #ser_unitcoste', function () {
        var cost_per_unit = $(this).val();
        if (cost_per_unit == '') {
            cost_per_unit = 0;
        }
        var sum = 0;
        $('.ind_final_rate_pick').each(function () {
            sum += Number($(this).val());
        });
        var option = '';
        var profit_loss = 0;
        profit_loss = parseFloat(cost_per_unit) - parseFloat(sum);
        if (parseFloat(profit_loss) > 0) {
            option += ' <label class="control-label txt-success">Profit:' + parseFloat(profit_loss) + '</label>'

        } else if (parseFloat(profit_loss) < 0) {
            option += ' <label class="control-label txt-danger">Loss:' + parseFloat(profit_loss) + '</label>'
        }
        $('.profit_loss_edit_div').html(option);
    })
    $('body').on('change', '#AddService #ser_unitcoste', function () {
        var cost_per_unit = $(this).val();
        if (cost_per_unit == '') {
            cost_per_unit = 0;
        }
        var sum = 0;
        $('.ind_final_rate').each(function () {
            sum += Number($(this).val());
        });
        var option = '';
        var profit_loss = 0;
        profit_loss = parseFloat(cost_per_unit) - parseFloat(sum);
        if (parseFloat(profit_loss) > 0) {
            option += ' <label class="control-label txt-success">Profit:' + parseFloat(profit_loss) + '</label>'

        } else if (parseFloat(profit_loss) < 0) {
            option += ' <label class="control-label txt-danger">Loss:' + parseFloat(profit_loss) + '</label>'
        }
        $('.profit_loss_direct_div').html(option);
    })
    $('body').on('click', '.remove_cos_clone_pick1', function (e) {
        var cost_per_unit = $('#AddService_common #ser_unitcoste').val();
        var row = $(this).attr('cl');
        var newvalue = 0;
        newvalue = $(this).closest('tr').find('.ind_final_rate_pick').val();
        if (newvalue == '') {
            newvalue = 0;
        }
        var currnt = 0;
        currnt = $('.final_rate_total_pick').val();
        if (isNaN(currnt)) {
            var currnt = 0;
        }
        var new_value = Number(currnt) - Number(newvalue);
        $('.final_rate_total_pick').val(new_value);
//        $(this).parents('.pick_div').remove();

        var option = '';
        var profit_loss = 0;
        profit_loss = parseFloat(cost_per_unit) - parseFloat(new_value);
        if (parseFloat(profit_loss) > 0) {
            option += ' <label class="control-label txt-success">Profit:' + parseFloat(profit_loss) + '</label>'

        } else if (parseFloat(profit_loss) < 0) {
            option += ' <label class="control-label txt-danger">Loss:' + parseFloat(profit_loss) + '</label>'
        }
        $('.profit_loss_editdiv').html(option);
        $(this).closest('tr').remove();
    });
    $('body').on('click', '.remove_cos_clone_pick', function (e) {
        var cost_per_unit = $('#AddService_common #ser_unitcoste').val();
        var clone_id = $(this).closest('tr').attr('icl');
        var newvalue = $(this).closest('tr').find('.ind_final_rate_pick').val();
        var currnt = $('.final_rate_total_pick').val();
        var sum = 0;
        if (clone_id != 1)
        {
            $(this).closest('tr').remove();
        } else
        {
            var dd = $(this).closest('tr').find("input");
            dd.val("");
            $(this).closest('tr').find('.cost_center_category_pick').val('');
            $(this).closest('tr').find('.cost_center_pick').val('');
        }
        $('.ind_final_rate_pick').each(function () {
            sum += Number($(this).val());
        });
        $('.final_rate_total_pick').val(sum);


        var option = '';
        var profit_loss = 0;
        profit_loss = parseFloat(cost_per_unit) - parseFloat(sum);
        if (parseFloat(profit_loss) > 0) {
            option += ' <label class="control-label txt-success">Profit:' + parseFloat(profit_loss) + '</label>'

        } else if (parseFloat(profit_loss) < 0) {
            option += ' <label class="control-label txt-danger">Loss:' + parseFloat(profit_loss) + '</label>'
        }
        $('.profit_loss_edit_div').html(option);
    });

    //Certificate
    $('body').on('click', '#chk_certificate', function () {
        if ($(this).is(":checked")) {
            $('#ck_cer_data_record').removeClass('no-display');
            $('.certificate_info_data').addClass('no-display');
        } else if ($(this).is(":not(:checked)")) {
            $('#ck_cer_data_record').addClass('no-display');
            $('.certificate_info_data').removeClass('no-display');
        }
    });

    $('body').on('change', '#import_file', function (e) {
        var ext = $('#import_file').val().split('.').pop().toLowerCase();
        if (ext != '') {
            if ($.inArray(ext, ['xlsx']) == -1) {
                swal('invalid extension! please select file only with the extension xlsx');
                e.preventDefault();
            }
        }
    });

    $('body').on('click', '.removecertclone', function (e) {
        var closest = $(this).closest('tr');
        e.preventDefault();
        var bc = $(this).parent().parent().remove();
        var dd = bc.find("input");
        var ss = bc.find("select");
        dd.val("");
        ss.val("");
    });
    $('body').on('click', '.clearcertclone', function (e) {
        var closest = $(this).closest('tr');
        var bc = $(this).parent().parent();
        var dd = bc.find("input");
        var ss = bc.find("select");
        dd.val("");
        ss.val("");
    });

    $('body').on('click', '.copycerclone', function (e) {
//        var page_name = $(this).attr('modal_name');
        var cer_name = $('.cer_param_name:last').val();
        var cer_val = $('.cer_param_value:last').val();
        var cer_order = $('.cer_param_order:last').val();
        if (cer_name == '' || cer_val == '' || cer_order == '') {
            swal("Enter valid entry");
        } else {
            e.preventDefault();
            var clid = $(".cld_cov:last").attr('id-cll');
            var nxt = parseFloat(clid) + 1;
            var bc = $(" tr.cld_cov[id-cll=1]").clone();
            bc.attr("id-cll", nxt);
            var dd = bc.find("input");
            bc.find('.clearcertclone').remove();
            dd.val("");
            bc.removeClass('clone');
            var cc = bc.find('.removecertclone');
            cc.removeClass('no-display');
            bc.appendTo(".table_certificate");
        }
    });
    $('body').on('click', '.removedatatclone', function (e) {
        var closest = $(this).closest('tr');
        e.preventDefault();
        var bc = $(this).parent().parent().remove();
        var dd = bc.find("input");
        var ss = bc.find("select");
        dd.val("");
        ss.val("");
    });
    $('body').on('click', '.cleardatatclone', function (e) {
        var closest = $(this).closest('tr');
        var bc = $(this).parent().parent();
        var dd = bc.find("input");
        var ss = bc.find("select");
        dd.val("");
        ss.val("");
    });

    $('body').on('click', '.copydataclone', function (e) {
        var cer_name = $('.data_param_name:last').val();
        var cer_val = $('.data_param_value:last').val();
        var cer_order = $('.data_param_order:last').val();
        if (cer_name == '' || cer_val == '' || cer_order == '') {
            swal("Enter valid entry");
        } else {
            e.preventDefault();
            var clid = $(".cld_data:last").attr('id-cld');
            var nxt = parseFloat(clid) + 1;
            var bc = $(" tr.cld_data[id-cld=1]").clone();
            bc.attr("id-cld", nxt);
            var dd = bc.find("input");
            bc.find('.cleardatatclone').remove();
            dd.val("");
            bc.removeClass('clone');
            var cc = bc.find('.removedatatclone');
            cc.removeClass('no-display');
            bc.appendTo(".table_datarecording");
        }
    });
    $("#manufacturer_add").on('click', function ()
    {
        var manufacturer = $('#manufacturer_name').val();
        if (manufacturer == "")
        {
            swal('Enter Details');
        } else {
            $('#jquery_mask').show();
            $.post(siteurl + "/Inventory/Item/add_manufacturer", {manufacturer: manufacturer}, function (data) {
                $('#jquery_mask').hide();
                $('#AddService #selectmanufacturer').html(data);
                $('#newManufacturer').find("input[type=text],textarea,select").val('').end();
                $("#newManufacturer").modal('hide');
            });
        }
    });
    $('body').on('click', '.removeorgmember_charge', function (e) {
        e.preventDefault();
        var sum2 = $(this).closest('tr').find('.charge_amount').val();
        $(this).closest('tr').remove();
        var charge_paidby = $(this).closest('tr').find('#charge_paidby').val();
        var sum = 0;
        var sum1 = $('#net_amt').val();
//        var sum2 = 0;
        sum1 = Number(sum1) - Number(sum2);
        $('#net_amt').val(sum1);
        var sum22 = $('#hidden_pro_total').val();
        var sum221 = Number(sum22) - Number(sum2);
        $('#hidden_pro_total').val(parseFloat(sum221).toFixed(2));
        var transaction_rate = $('#currency_rate').val();
        if (transaction_rate == 'undefined' && transaction_rate == '') {
            transaction_rate = 1;
        }

        $('#transaction_currency').val(parseFloat(sum1).toFixed(2) / parseFloat(transaction_rate));
        var charge_a = 0;
        $('.charge_amount').each(function () {
            charge_a += $(this).val();
        });
        $('#charge').val(parseFloat(charge_a));
        calculate_grandtotal();
    });

    // for vendor popup/////
    $('#noninventoryModal').on('click', '#getvendor', function () {
        var pagecheck = "pagejs";
        $('#jquery_mask').show();
        $.post(siteurl + "/Inventory/Quote/search_vendor/" + pagecheck, {pagecheck: pagecheck}
        , function (data) {
            $('#jquery_mask').hide();
            $('#search_vendor_result').html(data);
        });
    })

    $('body').on('keyup', '#search_vendor_keyword', function () {
        var keyword = $('#search_vendor_keyword').val();
        $('#jquery_mask').show();
        $.post(siteurl + "/Inventory/Quote/search_vendor", {keyword: keyword}
        , function (data) {
            $('#jquery_mask').hide();
            $('#search_vendor_result').html(data);
        });
    });

    $('body').on('change', '#gvendor', function ()
    {
        var vendor_name = $(this).data('cmpny_name');
        var com_hid_id = $(this).attr('com_hid_id');
        $('#hid_com_id').val(com_hid_id);
        var com_hid_name = $(this).attr('com_hid_name');

        if (com_hid_id) {
            $('#getvendor').val(com_hid_name);
        } else {
            $('#getvendor').val(vendor_name);
        }
        var val = $(this).val();
        $('#getvendor_id').val(val);
        $('#getnewvendor_id').val(val);
        $('#VendorModal').modal('hide');
    });

    $('body').on('change', '#billingcountry', function ()
    {

        var countryid = $(this).val();
        $('#jquery_mask').show();
        $.post(siteurl + "/Common/Picklocation/get_states_by_country", {countryid: countryid}
        , function (data) {
            $('#jquery_mask').hide();
            $('#billingstate').html(data);

        });
    });
    $('body').on('change', '#billingstate', function ()
    {
        var stateid = $(this).val();
        $('#jquery_mask').show();
        $.post(siteurl + "/Common/Picklocation/get_city_by_state", {stateid: stateid}
        , function (data) {
            $('#jquery_mask').hide();
            $('#billingcity').html(data);
        });
    });
    $('#addvendorModal').on('click', '#btn_addnewvendor', function ()
    {
        var vendor_first_name = $('#vendor_first_name').val();
        var vendor_last_name = $('#vendor_last_name').val();
        var vendor_mob = $('#vendor_mob').val();
        var vendor_email = $('#vendor_email').val();
        var company_name = $('#company_name').val();
        var company_phone = $('#company_phone').val();
        var company_email = $('#company_email').val();
        var company_website = $('#company_website').val();
        var company_fax = $('#company_fax').val();
        var billingaddressline1 = $('#billingaddressline1').val();
        var billingaddressline2 = $('#billingaddressline2').val();
        var billingcountry = $('#billingcountry').val();
        var billingstate = $('#billingstate').val();
        var billingcity = $('#billingcity').val();
        var billingpincode = $('#billingpincode').val();
        var payment = $('#payment').val();
        var p_days = $('#p_days').val();
        var credit_limit = $('#credit_limit1').val();

        if (vendor_first_name == '' || vendor_last_name == '' || vendor_email == '' || vendor_mob == '') {
            swal('Please Enter Valid Entry')
        } else {
            $.post(siteurl + "/Hr/Vendor/insert_vendor_details", {first_name: vendor_first_name, last_name: vendor_last_name, mobile: vendor_mob, email: vendor_email, company_name: company_name, company_phone: company_phone, company_email: company_email, company_website: company_website, company_fax: company_fax, addressline1: billingaddressline1, addressline2: billingaddressline2, country: billingcountry, state: billingstate, city: billingcity, pincode: billingpincode, payment: payment, p_days: p_days, credit_limit: credit_limit}
            , function (data) {
                $('#jquery_mask').hide();
                if (company_name != '') {
                    $('#getvendor').val(company_name);
                } else {
                    $('#getvendor').val(vendor_first_name);
                }
                $('#addvendorModal').modal('hide');
            });
        }
    });

    $('#payment').on('click', function () {

        var selectvalue = $(this).find('option:selected').val();
        if (selectvalue == 'credit') {
            $('#payment_day').show();
            $('#credit_limit').show();

        } else {
            $('#payment_day').hide();
            $('#credit_limit').hide();
        }
    });
    $('#payment_day').hide();
    $('#credit_limit').hide();
    //////////////



    $('body').on('change', '#currency_id', function () {

        var currency_id = $(this).val();
        $.post(siteurl + "/Crm/Deals/fetch_currency_rate_by_latest", {currency_id: currency_id}, function (data) {
            var result = JSON.parse(data);

            $('.div_currencyrate').removeClass('no-display');
            $('.currency_rate').val(result.rate);
            $('.cur_trans_rate_id').val(result.cur_trans_rate_id);
            $('.transaction_c_symbol').html(result.currency_symbol);


            change_with_currency_change();

            var net_amount = $('#net_amt').val();
            if (typeof result.rate === 'undefined' || result.rate == '') {
                result.rate = 1;
            }

            if (net_amount != 'undefined' && net_amount != '') {
                var transaction_currency = parseFloat(net_amount) / parseFloat(result.rate);
                var tr_currency = transaction_currency.toFixed(2);
                $('#transaction_currency').val(tr_currency);

            }

        });
    });
    $('#view_existing_slno').on('click', function () {
        var itemname = $(this).closest('tr').find('.pdt_title').html();
        var iditem = $(this).closest('tr').find('#pdt_id').val();
        var currentissue_qty = 0;
        if ($(this).closest('tr').find('#qty').val() != '') {
            currentissue_qty = $(this).closest('tr').find('#qty').val();
        }
        var used_mpns = [];
        $('#mpn_tbody .barcode_enter').each(function () {
            used_mpns.push($(this).val());
        });

        currentissue_qty = parseFloat(currentissue_qty) + 10;
        $('#view_existing_serialnumber .modal-title').html(itemname);
        $.post(siteurl + '/Inventory/Direct_invoice/fetch_existing_mpn', {iditem: iditem, currentissue_qty: currentissue_qty, used_mpns: JSON.stringify(used_mpns)}, function (data) {
            $('#view_existing_serialnumber .view_existing_serialnumber_tablebody').html(data);
        });
    });

    $('body').on('change', '.tax_type', function (e) {
        var taxtype = $(this).val();
        $('.cld').each(function () {
            var pdtid = $(this).find('.pdt_id').val();
            tax_bind_product($(this), pdtid);
            calculate_pro_row_total($(this));
        });

        product_subtotal_calculation();
        calculate_grandtotal();
    });
    $('#CmpnyaddModal').on('click', '.company_save_btn', function (e) {
        var company_add_name = $('#CmpnyaddModal #company_add_name').val();
        var company_add_email = $('#CmpnyaddModal #company_add_email').val();
        var company_add_mob = $('#CmpnyaddModal #company_add_mob').val();
        if (company_add_name == '') {
            swal("Please Enter Company Name");
        } else {
            $.post(siteurl + '/Inventory/Quote/save_company_details_common', {company_name: company_add_name, company_email: company_add_email, company_mob: company_add_mob}, function (data) {
                console.log(data.trim());
                $('#getcmpny').val(company_add_name);
                $('#con_mob').val(company_add_mob);
                $('#con_email').val(company_add_email);
                $('#getcmpny_id').val(data.trim());
                $('#CmpnyModal').modal('hide');
                $('#CmpnyaddModal').modal('hide');

            });
        }
    });
    $('#CntataddModal').on('click', '.contact_add_save_btn', function (e) {
        var contact_add_name = $('#CntataddModal #contact_add_name').val();
        var contact_add_email = $('#CntataddModal #contact_add_email').val();
        var contact_add_mob = $('#CntataddModal #contact_add_mob').val();
        var company_id = $('#getcmpny_id').val();
        if (contact_add_name == '') {
            swal("Please Enter Contact Name");
        } else {
            $.post(siteurl + '/Inventory/Quote/save_contact_details_common', {contact_name: contact_add_name, contact_email: contact_add_email, contact_mob: contact_add_mob, company_id: company_id}, function (data) {
                console.log(data);
                $('#getcntct').val(contact_add_name);
                $('#contact_id').val(data.trim());
                $('#con_mob').val(contact_add_mob);
                $('#con_email').val(contact_add_email);
                $('#CntataddModal').modal('hide');
                $('#contactModal').modal('hide');

            });
        }
    });

});

//////////////////////anjup-/////////////////
function check_msp_limit(dealttlamnt, dealttlqty, dealttlmsp, this_tr) {

    var rty = dealttlamnt / dealttlqty;
    if (rty < dealttlmsp) {
        this_tr.find('#error').attr('lessorgreat', 'less');
        this_tr.find('#error').removeClass('no-display');
    } else if (rty == dealttlmsp) {
        this_tr.find('#error').attr('lessorgreat', 'great');
        this_tr.find('#error').addClass('no-display');
    } else {
        this_tr.find('#error').attr('lessorgreat', 'great');
        this_tr.find('#error').addClass('no-display');
    }
}
///////////////////////////////////////////

function remove_amcs(pdt_id) {
    $('.amctr_' + pdt_id + '').remove();

}
function change_with_currency_change(address_id) {

    var transaction_rate = $('#currency_rate').val();
    if (transaction_rate == 'undefined' && transaction_rate == '') {
        transaction_rate = 1;
    }

    $('.selling_p').each(function () {
        var this_tr = $(this).closest('tr');
        var pro_rate = $(this).closest('tr').find('.selling_p_hidden').val();
        var prorate = parseFloat(pro_rate) * parseFloat(transaction_rate);
        if (prorate) {
            $(this).val(prorate);
        }

    });


    $('.purchase_p').each(function () {
        var this_tr = $(this).closest('tr');
        var purchase_p = $(this).closest('tr').find('.purchase_p_hidden').val();
        var prorate = parseFloat(purchase_p) * parseFloat(transaction_rate);
        if (prorate) {
            $(this).val(prorate);
        }

    });


    $('.ser_unitcost').each(function () {
        var this_tr = $(this).closest('tr');
        var purchase_p = $(this).closest('tr').find('.ser_unitcost_hidden').val();
        var prorate = parseFloat(purchase_p) * parseFloat(transaction_rate);
        if (prorate) {
            $(this).val(prorate);
        }

    });

    $('.amc_price').each(function () {
        var this_tr = $(this).closest('tr');
        var purchase_p = $(this).closest('tr').find('.amc_price_hidden').val();
        var prorate = parseFloat(purchase_p) * parseFloat(transaction_rate);
        if (prorate) {
            $(this).val(prorate);
        }

    });

    $('.amc_amount').each(function () {
        var this_tr = $(this).closest('tr');
        var amc_price_hidden = $(this).closest('tr').find('.amc_price_hidden').val();
        var amc_qty = $(this).closest('tr').find('.amc_qty').val();
        var purchase_p = parseFloat(amc_price_hidden) * parseFloat(amc_qty);
        var prorate = parseFloat(purchase_p) * parseFloat(transaction_rate);
        if (prorate) {
            $(this).val(prorate);
        }

    });

    $('.sellingPrice').each(function () {
        var this_tr = $(this).closest('tr');
        var dealttlamnt = $(this).closest('tr').find('#amount').val();
        var dealttlqty = $(this).closest('tr').find('#qty').val();
        var dealttlmsp = $(this).closest('tr').find('#pro_rate').val();

        var rty = dealttlamnt / dealttlqty;
        if (rty < dealttlmsp) {
            this_tr.find('#error').attr('lessorgreat', 'less');
            this_tr.find('#error').removeClass('no-display');
        } else if (rty == dealttlmsp) {
            this_tr.find('#error').attr('lessorgreat', 'great');
            this_tr.find('#error').addClass('no-display');
        } else {
            this_tr.find('#error').attr('lessorgreat', 'great');
            this_tr.find('#error').addClass('no-display');
        }

    });

    $('.ser_quan,.ser_dis').trigger("keyup");
}
function calculate_pro_row_total(sll) {
    var selected_array = [];
    var aa = sll.find('.quan');
    var bb = sll.find('.sellingPrice');
    var cc = sll.find('.amount');
    var dd = sll.find('.discount');
    var tax_amnt = 0;
    if (aa.val()) {
        var quantity = aa.val();
    } else {
        var quantity = '';
    }
    if (bb.val()) {
        var rate = bb.val();
    } else {
        var rate = '';
    }
    if (dd.val()) {
        var disc = dd.val();
    } else {
        var disc = 0;
    }
    var tax_enabled = $('#tax_enabled').val();
    if (quantity != "" && rate != "")
    {
        var enterd_dis_amount = sll.find('.item_disc_amt').val();
        var total_amount = parseFloat(rate) * parseFloat(quantity);
        var amt_with_disc_amt = (parseFloat(total_amount) - (enterd_dis_amount));
        if (enterd_dis_amount != "" && rate != "")
        {
            var percent = (parseFloat(enterd_dis_amount) * 100 / parseFloat(total_amount));
            if (isNaN(percent)) {
                var percent = 0;
            }
            dd.val(parseFloat(percent).toFixed(2));

        }
        var percent = (parseFloat(enterd_dis_amount) * 100 / parseFloat(total_amount));
        if (isNaN(percent)) {
            var percent = 0;
        }
        sll.find('.discount').val(parseFloat(percent).toFixed(2));
//        sll.find('.discount').val(parseFloat(percent).toFixed(2));

        if (tax_enabled != -1) {
            tax_amnt = tax_calculation(sll, amt_with_disc_amt);
        }
        sll.find('.amount').val(parseFloat(amt_with_disc_amt + tax_amnt).toFixed(2));
    }
    ////////////////check msp limit-------------->//////
    var dealttlamnt = sll.find('.amount').val();
    var dealttlqty = sll.find('.quan').val();
    var dealttlmsp = sll.find('.selling_p').val();
    check_msp_limit(dealttlamnt, dealttlqty, dealttlmsp, sll);
    ////////////////<----------End/////////////////////
}
function calculate_ser_row_total(sll) {
    var aa = sll.find('#ser_quan');
    var currency_rate = $('#currency_rate').val();
    var bb = sll.find('.ser_unitcost');
    var cc = sll.find('#ser_amount');
    var dd = sll.find('#ser_dis');
    var gs = sll.find('#final_rate');
    var serv_dist_amt = sll.find('#ser_dist_amt');
    var ser_item_dis_amt = sll.find('#ser_item_dis_amt');
    var ser_from_disc = sll.find('.ser_dis').attr('ser_from_disc');
    var tax_enabled = $('#tax_enabled').val();
    var tax_amnt = 0;
    var tax_amnt_ser = 0;
    //anjup for tax---------->
    if (tax_enabled != -1) {
        var selected_sergrpid = sll.closest('.serv_tbl').find('.selected_service_taxgrp').val();
        var selected_array = [];
    }
    //END<--------------------
    var common_percentage_amount = $('#common_percentage_amount').val();
    var other_amount = 0;
    $('.charge_amount').each(function () {
        other_amount += Number($(this).val());
    });
    var amc_amount = 0;
    $('.amc_amount').each(function () {
        amc_amount += Number($(this).val());
    });

    if (gs.val()) {
        var cost_rate = gs.val();
        var cost_rate = parseFloat(cost_rate) * parseFloat(currency_rate)
    } else {
        var cost_rate = 0;
    }
    if (aa.val()) {
        var quantity = aa.val();
    } else {
        var quantity = '';
    }
    if (bb.val()) {
        var rate = bb.val();
        var rate = parseFloat(rate) * parseFloat(currency_rate)
    } else {
        var rate = '';
    }
    if (dd.val()) {
        var disc = dd.val();
    } else {
        var disc = 0;
    }
    if (ser_item_dis_amt.val()) {
        var disc_amt = ser_item_dis_amt.val();
    } else {
        var disc_amt = 0;
    }
    var tt = $('#ser_total');

    if (quantity != "" && rate != "")
    {
        var enterd_dis_amount = sll.find('.ser_item_dis_amt').val();
        var total_amount = parseFloat(rate) * parseFloat(quantity);
        var amt_with_disc_amt = (parseFloat(total_amount) - (enterd_dis_amount));

        if (enterd_dis_amount != "" && rate != "")
        {
            var percent = (parseFloat(enterd_dis_amount) * 100 / parseFloat(total_amount));
            if (isNaN(percent)) {
                var percent = 0;
            }
            dd.val(parseFloat(percent).toFixed(2));

        }
        var percent = (parseFloat(enterd_dis_amount) * 100 / parseFloat(total_amount));
        if (isNaN(percent)) {
            var percent = 0;
        }
        sll.find('.ser_dis').val(parseFloat(percent).toFixed(2));

        if (tax_enabled != -1) {
            tax_amnt_ser = tax_calculation_service(sll, amt_with_disc_amt);
        }
        sll.find('.ser_amount').val(parseFloat(amt_with_disc_amt + tax_amnt_ser).toFixed(2));
    } else {
        var amt = 0;
        if (isNaN(net)) {
            var net = 0;
        }
        //anjup for tax---------->
        if (tax_enabled != -1) {
            tax_amnt = tax_calculation_service(sll, amt_with_disc_amt);
        }
        cc.val(parseFloat(net) + tax_amnt);
        //END<--------------------


        var sum = 0;
        $('.ser_amount').each(function () {
            sum += Number($(this).val());
        });
        if (isNaN(sum)) {
            var sum = 0;
        }
        tt.val(parseFloat(sum));
        if ($('#pro_total').val() != "")
        {
            var final = parseFloat($('#pro_total').val()) + parseFloat($('#ser_total').val()) + parseFloat(amc_amount);

            if (isNaN(final)) {
                var final = 0;
            }



            $('#net_amt').val(parseFloat(final).toFixed(2));
            $('#hidden_pro_total').val(parseFloat(final).toFixed(2));

            $('#net_amount').trigger("change");
        } else
        {
            var final = parseFloat($('#ser_total').val()) + parseFloat(amc_amount);

            if (isNaN(final)) {
                var final = 0;
            }
            $('#net_amt').val(parseFloat(final).toFixed(2));
            $('#hidden_pro_total').val(parseFloat(final).toFixed(2));

            $('#net_amount').trigger("change");
        }
    }
}
function tax_bind_product(sll, id, noninvcheck = 0) {
    var tax_type = $('input[name=tax_type]:checked').val();
    var tax_enabled = $('#tax_enabled').val();
    var salesaccount_id = '';
    if (tax_enabled != -1) {
        var interstate_tax = $('#interstate_tax' + id).val();
        var intrastate_tax = $('#intrastate_tax' + id).val();
        var export_tax = $('#export_tax' + id).val();
        var service_tax = $('#service_tax' + id).val();
        var item_taxtype = sll.find('.itemtaxtype_hidden').val();
        var msp = sll.find('.selling_p_hidden').val();
        if (noninvcheck != 0) {
            interstate_tax = $('#interstate_tax').val();
            intrastate_tax = $('#intrastate_tax').val();
            export_tax = $('#export_tax').val();
            service_tax = $('#service_tax').val();
//            item_taxtype = noninvcheck;
            msp = $('#nonpro_sellingprice').val();
        }
        var key_exist = 0;
        if (product_taxarray != null) {
            for (const [key, value] of Object.entries(product_taxarray)) {
                if (key == id) {
                    key_exist = 1;
                }
            }
        } else {
            product_taxarray = [];
        }
        if (key_exist == 0) {
            product_taxarray[id] = {interstate_tax: interstate_tax, intrastate_tax: intrastate_tax, export_tax: export_tax, service_tax: service_tax};
        }
        sll.find('.pdttax').val('');
        var tax_data = '';
        var sellingprice = 0;
        for (const [key_pdtid, value_tax] of Object.entries(product_taxarray)) {
            if (key_pdtid == id) {
                for (const [key, value] of Object.entries(tax_details)) {
                    if (tax_type == 'intra_state') {
                        if (key == value_tax['intrastate_tax']) {
                            var ttlrate = 0;
                            for (var ii = 0; ii < value.length; ii++) {
                                sll.find('.selected_product_taxgrp').val(value_tax['intrastate_tax']);
                                sll.find('.tax_details_' + value[ii]['tax_masterid']).val(value[ii]['tax_rate'] + '% :\n0');
                                sll.find('.pdtslab_' + value[ii]['tax_masterid']).val(value[ii]['output_taxid']);
                                salesaccount_id = $('#intra_sales_account_id_hidden' + id).val();
                                ttlrate += parseFloat(value[ii]['tax_rate']);
                            }
                            sellingprice = (100 * parseFloat(msp)) / (100 + ttlrate);
                        }
                    } else if (tax_type == 'inter_state') {
                        if (key == value_tax['interstate_tax']) {
                            var ttlrate = 0;
                            for (var ii = 0; ii < value.length; ii++) {
                                sll.find('.selected_product_taxgrp').val(value_tax['interstate_tax']);
                                sll.find('.tax_details_' + value[ii]['tax_masterid']).val(value[ii]['tax_rate'] + '% :\n0');
                                sll.find('.pdtslab_' + value[ii]['tax_masterid']).val(value[ii]['output_taxid']);
                                salesaccount_id = $('#inter_sales_account_id_hidden' + id).val();
                                ttlrate += parseFloat(value[ii]['tax_rate']);
                            }
                            sellingprice = (100 * parseFloat(msp)) / (100 + ttlrate);
                        }
                    } else if (tax_type == 'export') {
                        if (key == value_tax['export_tax']) {
                            var ttlrate = 0;
                            for (var ii = 0; ii < value.length; ii++) {
                                sll.find('.selected_product_taxgrp').val(value_tax['export_tax']);
                                sll.find('.tax_details_' + value[ii]['tax_masterid']).val(value[ii]['tax_rate'] + '% :\n0');
                                sll.find('.pdtslab_' + value[ii]['tax_masterid']).val(value[ii]['output_taxid']);
                                salesaccount_id = $('#export_sales_account_id_hidden' + id).val();
                                ttlrate += parseFloat(value[ii]['tax_rate']);
                            }
                            sellingprice = (100 * parseFloat(msp)) / (100 + ttlrate);
                        }
                    }
                }
            }
        }
        sll.find('.sales_account_id').val(salesaccount_id);
        if (sll.find('.data_loadtype').val() != 'edit') {
            if (item_taxtype == 'exclusive') {
                if (msp) {
                    sll.find('#sellingPrice').val(parseFloat(msp).toFixed(2));
                } else {
                    sll.find('#sellingPrice').val(0);
                }
            } else {
                if (msp) {
                    sll.find('#sellingPrice').val(sellingprice.toFixed(2));
                } else {
                    sll.find('#sellingPrice').val(0);
                }
            }
        }
}
}
function tax_calculation(sll, net) {
    var selected_array = [];
    var cc = sll.find('.amount');
    var totaltax_amount = 0;
    var selected_pdtgrpid = sll.find('.selected_product_taxgrp').val();
    for (const [key, value] of Object.entries(tax_details)) {

        if (key == selected_pdtgrpid) {
            for (var ii = 0; ii < value.length; ii++) {
                selected_array.push(value[ii]['tax_masterid']);
                var taxrate = value[ii]['tax_rate'];
                var tax_amount = (parseFloat(taxrate) / 100) * parseFloat(net);
                totaltax_amount += tax_amount;
                sll.find('#tax_masterid_' + value[ii]['tax_masterid']).val(value[ii]['tax_rate'] + '% :\n' + tax_amount.toFixed(2));
            }
            var finalnet_amount = parseFloat(net) + parseFloat(totaltax_amount);
//            cc.val(finalnet_amount);
        }
    }
    return totaltax_amount;

}
function tax_calculation_service(sll, net) {
    if (isNaN(net))
    {
        net = 0;
    }
    //nid check
    var selected_array = [];
    var cc = sll.find('.ser_amount');
    var totaltax_amount = 0;
    var selected_pdtgrpid = sll.closest('tbody').find('.selected_service_taxgrp').val();
    for (const [key, value] of Object.entries(tax_details)) {

        if (key == selected_pdtgrpid) {
            for (var ii = 0; ii < value.length; ii++) {
                selected_array.push(value[ii]['tax_masterid']);
                var taxrate = value[ii]['tax_rate'];
                var output = value[ii]['output_taxid'];
                var sales_account_id = value[ii]['sales_account_id'];
                var tax_amount = (parseFloat(taxrate) / 100) * parseFloat(net);
                totaltax_amount += tax_amount;
                sll.find('#tax_masterid_' + value[ii]['tax_masterid']).val(value[ii]['tax_rate'] + '% :\n' + tax_amount);
                sll.find('#ser_taxslab_' + value[ii]['tax_masterid']).val(output);
                sll.find('#ser_sales_account_id_' + value[ii]['tax_masterid']).val(sales_account_id);
            }
            var finalnet_amount = parseFloat(net) + parseFloat(totaltax_amount);
//            cc.val(s);
        }
    }
//    if (item_taxtype == 'exclusive') {
//        sll.find('#sellingPrice').val(parseFloat(msssp).toFixed(2));
//    } else {
//        sll.find('#sellingPrice').val(sellingprice.toFixed(2));
//    }
    return totaltax_amount;

}
function service_subtotal_calculation() {

    var tax_enabled = $('#tax_enabled').val();
    if (tax_enabled != -1) {
        for (var i = 0; i < alltax_details.length; i++) {
            var totaltaxmaster_amount = 0;
            $('.ser_tax_details_' + alltax_details[i].tax_master_id).each(function () {
                var taxamount_i = 0;
                if ($(this).val() != '') {
                    var res = $(this).val().split(':');
                    taxamount_i = Number(res[1]);
                }
                totaltaxmaster_amount += taxamount_i;
            });

            $('#ser_ttltaxamnt_' + alltax_details[i].tax_master_id).val(totaltaxmaster_amount.toFixed(2));
        }
    }

    var service_total = 0;
    var ser_item_dis_amt = 0;
    $('.ser_amount').each(function () {
        service_total += parseFloat($(this).val());
    });
    $('.ser_item_dis_amt').each(function () {
        ser_item_dis_amt += parseFloat($(this).val());
    });
    $('#ser_total').val(service_total);
    $('#ser_discount').val(ser_item_dis_amt);
    var sertaxmasteramount = 0;
    $('.sertaxmasteramount').each(function () {
        sertaxmasteramount += parseFloat($(this).val());
    });
    if (isNaN(sertaxmasteramount)) {
        sertaxmasteramount = 0;
    }
    var pdttaxmasteramount = 0;
    $('.pdttaxmasteramount').each(function () {
        pdttaxmasteramount += parseFloat($(this).val());
    });
    if (isNaN(pdttaxmasteramount)) {
        pdttaxmasteramount = 0;
    }
    var nettaxamount = parseFloat(sertaxmasteramount) + parseFloat(pdttaxmasteramount);
//    $('#ttltax_amount').val(nettaxamount.toFixed(2));
}
function product_subtotal_calculation() {
    var tax_enabled = $('#tax_enabled').val();
    if (tax_enabled != -1) {
        for (var i = 0; i < alltax_details.length; i++) {
            var totaltaxmaster_amount = 0;
            $('.tax_details_' + alltax_details[i].tax_master_id).each(function () {
                var taxamount_i = 0;
                if ($(this).val() != '') {
                    var res = $(this).val().split(':');
                    taxamount_i = Number(res[1]);
                }
                totaltaxmaster_amount += taxamount_i;
            });

            $('#totalpro_tax_' + alltax_details[i].tax_master_id).val(totaltaxmaster_amount.toFixed(2));
        }
    }
    var pro_total = 0;
    var pro_dis_amt = 0;
    $('.amount').each(function () {
        if ($(this).val() != '') {
            pro_total += parseFloat($(this).val());
        }
    });
    $('.item_disc_amt').each(function () {
        if ($(this).val() != '') {
            pro_dis_amt += parseFloat($(this).val());
        }

    });
    $('#pro_total').val(pro_total);
    $('#pro_dis').val(pro_dis_amt);
}
function calculate_grandtotal() {
    var amc_amount = 0;
    var other_amount = 0;
    var pro_total = 0;
    var ser_total = 0;
    var sertaxmasteramount = 0;
    var currency_rate = $('.currency_rate').val();
    $('.sertaxmasteramount').each(function () {
        var abbb = parseFloat($(this).val());
        if (isNaN(parseFloat($(this).val()))) {
            abbb = 0;
        }
        sertaxmasteramount += abbb;
    });
    if (isNaN(parseFloat(sertaxmasteramount))) {
        sertaxmasteramount = 0;
    }
    var pdttaxmasteramount = 0;
    $('.pdttaxmasteramount').each(function () {
        var abb = parseFloat($(this).val());
        if (isNaN(parseFloat($(this).val()))) {
            abb = 0;
        }
        pdttaxmasteramount += abb;
    });
    var nettaxamount = parseFloat(sertaxmasteramount) + parseFloat(pdttaxmasteramount);
    $('#ttltax_amount').val(nettaxamount.toFixed(2));
    $('.charge_amount').each(function () {
        other_amount += Number($(this).val());
    });
    if (isNaN(parseFloat(other_amount))) {
        other_amount = 0;
    }
    $('.amc_amount').each(function () {
        amc_amount += Number($(this).val());
    });
    $('.amount').each(function () {
        pro_total += Number($(this).val());
    });
    $('.pro_total').val(parseFloat(final).toFixed(2));

    var ss = $('#charge').val();
    var ss1 = $('#charge_hidden').val();
    var sum2 = 0;
    var product_total = $('#pro_total').val();
    var service_total = $('#ser_total').val();
    if (isNaN(product_total)) {
        product_total = 0;
    }
    if (isNaN(service_total)) {
        service_total = 0;
    }
    if (ss != '' && ss1 != '') {
        sum2 = Number(ss) - Number(ss1);
    }
    if ($('#ser_total').val() != "") {
        var final = parseFloat(product_total) + parseFloat(service_total) + parseFloat(amc_amount) + parseFloat(other_amount);
        if (isNaN(final)) {
            var final = 0;
        }
    } else {
        var final = parseFloat(product_total) + parseFloat(amc_amount) + parseFloat(other_amount);
        if (isNaN(final)) {
            var final = 0;
        }
    }
    var common_percentage_amount = $('.common_percentage_amount').val();
    console.log(final)
    if (final != 0 && parseFloat(final) >= parseFloat(common_percentage_amount)) {
        if (common_percentage_amount != "") {
            var common_percentage_amount = common_percentage_amount;
        } else {
            var common_percentage_amount = 0;
        }
        var cdp = (parseFloat(common_percentage_amount) * 100) / parseFloat(final);
        $('#common_percentage').val(parseFloat(cdp).toFixed(2));
        var final = parseFloat(final) - parseFloat(common_percentage_amount);

    } else {
        if (common_percentage_amount) {
            $('.common_percentage_amount').val(0);
        } else {
            $('.common_percentage_amount').val(0);
        }
        $('#common_percentage').val(0);
    }

    $('#net_amt').val(parseFloat(final).toFixed(2));
    $('#hidden_pro_total').val(parseFloat(final).toFixed(2));
    var transaction_rate = $('#currency_rate').val();
    if (transaction_rate == 'undefined' && transaction_rate == '') {
        transaction_rate = 1;
    }
    $('#transaction_currency').val(parseFloat(final).toFixed(2) / parseFloat(transaction_rate));
}


























