$(document).ready(function () {

    $('body').on('click', '#purchasedetail', function () {
        var item_id = $(this).attr('item_id');
        $('#jquery_mask').show();
        $.post(siteurl + "/Inventory/Item/get_itempurchasedetails", {item_id: item_id}, function (data)
        {
            $('#jquery_mask').hide();
            $('#purchasedetailModal .modal-body').html(data);
        });
    });
    $('body').on('click', '#salesdetail', function () {
        var item_id = $(this).attr('item_id');
        $('#jquery_mask').show();
        $.post(siteurl + "/Inventory/Item/get_itemsalesdetails", {item_id: item_id}, function (data)
        {
            $('#jquery_mask').hide();
            $('#salesdetailModal .modal-body').html(data);
        });
    });
    $('body').on('click', '#stockdetail', function () {

        var item_id = $(this).attr('item_id');
        $('#jquery_mask').show();
        $.post(siteurl + "/Inventory/Item/get_itemstockdetails", {item_id: item_id}, function (data)
        {
            $('#jquery_mask').hide();
            $('#stockdetailModal .modal-body').html(data);
        });
    });
    $('body').on('click', '#update_purchase', function ()
    {

        var purchase_price = $('#purchase_price').val();
        var item_id = $('#itemm_id').val();
        var vendor_id = $('#selectvendor').val();
        var description = $('#descripton_purchase').val();
        $('#jquery_mask').show();
        $.post(siteurl + "/Inventory/Item/add_pruchasedetail", {purchase_price: purchase_price, item_id: item_id, vendor_id: vendor_id, description: description}, function (data) {
            $('#jquery_mask').hide();
            $('#purchasedetailModal').modal('hide');
            location.reload();
        });
    });
    $('body').on('click', '#add_purchase', function ()
    {

        var purchase_price = $('#purchase_price').val();
        var item_id = $('#itemm_id').val();
        var vendor_id = $('#selectvendor').val();
        var description = $('#descripton_purchase').val();
        $('#jquery_mask').show();
        $.post(siteurl + "/Inventory/Item/add_pruchasedetail", {purchase_price: purchase_price, item_id: item_id, vendor_id: vendor_id, description: description}, function (data) {
            $('#jquery_mask').hide();
            $('#purchasedetailModal').modal('hide');
            location.reload();
        });
    });
    $('body').on('click', '#update_stock', function ()
    {
        var reorderlevel = $('#reorderlevel').val();
        var item_id = $('#item_id').val();
        var openingstock = $('#openingstock').val();
        var openingstockvalue = $('#openingstockvalue').val();
        var store_name = $('#store_name').val();
        if (reorderlevel == "") {
            swal("required", "reorderlevel", "error");
            return false;
        }
        if (openingstock == "") {
            swal("required", "openingstock", "error");
            return false;
        }
        if (store_name == "") {
            swal("required", "store", "error");
            return false;
        }
        if (openingstockvalue == "") {
            swal("required", "openingstockvalue", "error");
            return false;
        }
        $('#jquery_mask').show();
        $.post(siteurl + "/Inventory/Item/update_stockdetail", {reorderlevel: reorderlevel, item_id: item_id, openingstock: openingstock, openingstockvalue: openingstockvalue, store_name: store_name}, function (data) {
            $('#jquery_mask').hide();
            $('#stockdetailModal').modal('hide');
        });
    });
    $('body').on('click', '#add_stock', function ()
    {
        var reorderlevel = $('#reorderlevel').val();
        var item_id = $('#item_id').val();
        var openingstock = $('#openingstock').val();
        var openingstockvalue = $('#openingstockvalue').val();
        var store_name = $('#store_name').val();
        if (reorderlevel == "") {
            swal("required", "reorderlevel", "error");
            return false;
        }
        if (openingstock == "") {
            swal("required", "openingstock", "error");
            return false;
        }
        if (store_name == "") {
            swal("required", "store", "error");
            return false;
        }
        if (openingstockvalue == "") {
            swal("required", "openingstockvalue", "error");
            return false;
        }

        $('#jquery_mask').show();
        $.post(siteurl + "/Inventory/Item/add_stockdetail", {store_name: store_name, reorderlevel: reorderlevel, item_id: item_id, openingstock: openingstock, openingstockvalue: openingstockvalue}, function (data) {
            $('#jquery_mask').hide();
            $('#stockdetailModal').modal('hide');
            location.reload();
        });
    });
    $('body').on('click', '#update_salesdetails', function ()
    {
        var markup_price = $('#markup_price').val();
        var item_id = $('#item_id').val();
        var sellingprice = $('#sellingprice').val();
        var description_sales = $('#description_sales').val();
        $('#jquery_mask').show();
        $.post(siteurl + "/Inventory/Item/add_salesdetail", {markup_price: markup_price, item_id: item_id, sellingprice: sellingprice, description_sales: description_sales}, function (data) {
            $('#jquery_mask').hide();
            $('#stockdetailModal').modal('hide');
            location.reload();
        });
    });
    $('body').on('click', '#add_salesdetails', function ()
    {
        var markup_price = $('#markup_price').val();
        var item_id = $('#item_id').val();
        var sellingprice = $('#sellingprice').val();
        var description_sales = $('#description_sales').val();
        $('#jquery_mask').show();
        $.post(siteurl + "/Inventory/Item/add_salesdetail", {markup_price: markup_price, item_id: item_id, sellingprice: sellingprice, description_sales: description_sales}, function (data) {
            $('#jquery_mask').hide();
            $('#stockdetailModal').modal('hide');
            location.reload();
        });
    });
    //for select category and sub category
    $('body').on('change', '.selectcategory', function (e) {
        $(this).parents('.cat-divs').nextAll('.cat-divs').remove();
        $('.attributeoption').html('');
        e.preventDefault();
        var gencode = "";
        $('.selectcategory').each(function (e) {

            var category_id = $(this).val();
            var selectvalue = $(this).find('option:selected').html();
            if (selectvalue != 'select' && selectvalue != "") {
                var first = selectvalue[0];
                var cat = first.toUpperCase();
                gencode += cat;
            }
        });
        $('.catefirst_hidden_id').val(gencode);
        var category_id = $(this).val();
        if (category_id != "" && category_id != 0 && category_id != 'select') {
            $('#jquery_mask').show();
            $.post(siteurl + "/Inventory/Item/get_category_by_current_parent_id", {category_id: category_id}, function (data) {
                $('#jquery_mask').hide();
                if (data != 0) {
                    $('.select-append').append(data);
                } else {
                    $('#category_hidden_id').val(category_id);
                    $('#category_hidden_id_edit').val(category_id);
                    $('.attributeoption').show();
                    $('#jquery_mask').show();
                    $.post(siteurl + "/Inventory/Item/get_attribute_name_optionalvalue", {category_id: category_id}, function (result) {
                        $('#jquery_mask').hide();
                        $('.attributeoption').html(result);
                    });
                }
            });
        }

    });
    var code = "";
    $('body').on('change', '.optionalvalue_attr,#selectbrand', function (e) {
        if (typeof $('.optionalvalue_attr').val() !== 'undefined') {
            if ($('#selectbrand').val() != '') {
                var code = "";
                var second = "";
                var secondcode = "";
                var thirdcode = "";
                var forthcode = "";
                var gencode = "";
                var gencode1 = "";
                var categryid = "";
                var brand_id = $('#selectbrand').val();
                $('#jquery_mask').show();
                $.post(siteurl + "/Inventory/Item/selectcode", {brand_id: brand_id}, function (result) {
                    $('#jquery_mask').hide();
                    code = result;
                    $('#codebrand').val(result);
                    var codes = code.toUpperCase();
                    var categryid_arr = new Array();
                    $('.selectcategory').each(function (e) {

                        var category_id = $(this).val();
                        var selectvalue = $('option:selected', this).text();
                        if (selectvalue != 'select' && selectvalue != "") {

                            categryid_arr.push(category_id);
                        }
                        ;
                    });
                    $('#jquery_mask').show();
                    $.post(siteurl + "/Inventory/Item/categorycode", {category_id: JSON.stringify(categryid_arr)}, function (result1) {
                        $('#jquery_mask').hide();
                        second = result1;
                        secondcode = second.toUpperCase();
                        $("#categorycode").val(secondcode);
                        $(".optionalvalue_attr").each(function (e) {
                            var attribute_id = $(this).val();
                            var selectvalue1 = $(this).val();
                            selectvalue1 = selectvalue1.trim();
                            if (selectvalue1 != 'Select' && selectvalue1 != "") {
                                var third = selectvalue1[0];
                                if ($.isNumeric(selectvalue1[0]) == false) {
                                    var att = third.toUpperCase();
                                    thirdcode += att;
                                } else {
                                    forthcode += selectvalue1;
                                }

                            }
                        });
                        gencode = codes + secondcode + thirdcode + forthcode;
                        var skugencode = gencode.split(' ').join('');
                        $('#sku').val(skugencode);
                        gencode1 = $("#sku").val();
                        $('#jquery_mask').show();
                        $.post(siteurl + "/Inventory/Item/check_name", {namesplit: gencode1}, function (result) {
                            $('#jquery_mask').hide();
                            var list = JSON.parse(result);
                            if (list != "") {
                                e.preventDefault();
                                swal("This SKU already exist.");
                            }
                        });
                    });
                });
            } else
            {
                swal('Please Select Item Brand First');
                $('.optionalvalue_attr').val("");
            }
        }
    });
    $('body').on('click', '#save_item', function () {
        var f = 0;
        var productname = $('#productname').val();
        var selectunit = $('#selectunit').val();
        var description = $('#description').val();
        var sku_chk = $('.sku_chk').val();
        if (productname == '') {
            swal("Please enter product name");
            f = 1;
        }
        if (selectunit == '') {
            swal("Please select unit");
            f = 1;
        }
        if (description == '') {
            swal("Please enter product description");
            f = 1;
        }
        if (sku_chk == '') {
            swal("Please enter product sku");
            f = 1;
        }
        if (f == 0) {
            var gencode1 = $("#sku").val();

            var bar_type = $("input[name='bar_type']:checked").val();

            if (bar_type == 'vpc') {
                var flag_barcode = 0;
                var common_barcode = $("#common_barcode_div").val();
                $.post(siteurl + "/Inventory/Item/check_barcode_for_vpc", {common_barcode: common_barcode}, function (result) {
                    if (result == 1) {
                        swal("This Barcode already exist please change");

                    } else {
                        flag_barcode++;
                    }
                });
            }
//        else if (bar_type == 'sgc') {
//            var flag_barcode_sgc =0;
//            var common_barcode = $("#common_barcode").val();
//            $.post(siteurl + "/Inventory/Item/check_barcode_for_sgc", {common_barcode: common_barcode}, function (result) {
//                console.log(result);
//                if (result == 1) {
//                    swal("This Barcode already exist please change");
//
//                }
//                else {
//                    flag_barcode_sgc++;
//                }
//            });
//        }


            $.post(siteurl + "/Inventory/Item/check_name", {namesplit: gencode1}, function (result) {

                var list = JSON.parse(result);
                if (list != "") {
                    swal("This SKU already exist please change");

                } else if (flag_barcode != 0 || bar_type == 'sgu' || bar_type == 'vpu') {
//                e.preventDefault();
                    $('#jquery_mask').show();
//                $('#jquery_mask').hide();
                    $('#item_form').submit();

                }



            });
        }
    });

    $('body').on('change', '#selectbrand', function (e) {
        var brand_id = $(this).val();
        $.post(siteurl + "/Inventory/Item/generate_sku", {brand_id: brand_id}, function (result) {
            $('.sku_chk').val(result);
        });
    });

    $('body').on('submit', '#item_updation', function (e) {
        $('#jquery_mask').show();
    });

    //for add button
    $('body').on('click', '.addoption', function () {
        var att_id = $(this).attr('att_id');
        var att_name = $(this).attr('att_name');
        $('.addoptionModal #optional_hidden_id').val(att_id);
        $('.addoptionModal #optional_hidden_name').val(att_name);
        close_tr = $(this).closest('tr');
    });
//   for submit button
    $('body').on('click', '.optional_value_add', function () {
        var att_id = $('.optid').val();
        var att_name = $('.optname').val();
        var input = $('#optionalvalue_id').val();
        if (input != '')
        {
            $('#jquery_mask').show();
            $.post(siteurl + "/Inventory/Item/addoptionalvalue", {att_id: att_id, att_name: att_name, input: input}, function (result) {
                $('#jquery_mask').hide();
                var option = '<option value="' + input + '">' + input + '</option>';
                close_tr.find('.optionalvalue_attr').append(option);
                close_tr.find('.optionalvalue_attr').val(input);
                $('.addoptionModal').find("input[type=text],textarea,select").val('').end();
                $('.addoptionModal').hide();
                $('.modal-backdrop').remove();
            });
        } else
        {
            swal('No Data Entered');
        }
    });
    $('#import_uploader').on('click', function () {
        var file = document.getElementById('import_file').files[0];
        var fileName = $("#import_file").val();
        if (fileName) {
            var reader = new FileReader();
            reader.onload = function (progressEvent) {
                var lines = this.result.split('\n');
                if (lines.length > 0) {
                    var line = 0;
                    readFile(line, lines);
                }
            };
            reader.readAsText(file);
        } else {
            swal('Error!', 'Please choose file');
        }
    });
    var mod = 0;
    var no_of_page = 0;
    var row_limit = 20;
    if (typeof (stock_report) != 'undefined') {
        mod = Number(stock_report.length) % Number(20);
        page_row_count = stock_report.length;

        no_of_page = parseInt(stock_report.length / 20);
        row_limit = 20;
        if (mod != 0)
        {
            no_of_page += 1;
        }
        createpagenation1(row_limit, 1, no_of_page);

    }

    $('body').on('keyup', '#search_item_report', function () {

        var searchkeyword = $(this).val();
        var option = '';
        var count = 1;
        for (var i = 0; i < stock_report.length; i++) {
            if (stock_report[i]['name'].toLowerCase().indexOf(searchkeyword.toLowerCase()) != -1) {
                var curr_stock = Number(stock_report[i]['current_stock']) - (Number(stock_report[i]['demo_qty']) + Number(stock_report[i]['service_quantity']) + Number(stock_report[i]['damaged_quantity']));
                option += '<tr class="sec_grid_tbl">'
                option += '<td class="w30 h40 hard_left pa-0"><div class="w100 h40 pull-left custom-title-wrap bar-gray pa-5 m0 item-head-nolink"><div class="sm_title">' + stock_report[i]['name'] + '</div><div class="custom-title txt-caps">&nbsp;</div></div></td>'
                option += '<td class="w100px h40 pa-2 text-center moneyholder5">' + stock_report[i]['openingstock'] + '</td>'
                option += '<td class="w150px h40 pa-2 text-center moneyholder5">' + stock_report[i]['openingstockvalue'] + '</td>'
                option += '<td class="w150px h40 pa-2 text-center moneyholder5">' + stock_report[i]['current_stock'] + '</td>'
                option += '<td class="w150px h40 pa-2 moneyholder5">' + stock_report[i]['current_stock_value'] + '</td>'
                option += '<td class="w150px h40 pa-2">' + stock_report[i]['demo_qty'] + '</td>'
                option += '<td class="w150px h40 pa-2">' + stock_report[i]['service_quantity'] + '</td>'
                option += '<td class="w150px h40 pa-2">' + stock_report[i]['damaged_quantity'] + '</td>'
                option += '<td class="w150px h40 pa-2">' + curr_stock + '</td>'
                option += '<td class="w150px h40 pa-2 moneyholder5">' + stock_report[i]['current_stock_value'] / stock_report[i]['current_stock'] + '</td>'
                option += '<td class="w150px h40 pa-2">' + stock_report[i]['stock_status'] + '</td>'
                option += '<td class="w50px h40 pa-2 text-center"> <div class="inline-block dropdown ">'
                        + '<a class="dropdown-toggle" data-toggle="dropdown" href="#" aria-expanded="true" role="button"><i class="icon lindo-android-more-vertical act-gray fz-22"></i></a>'
                        + '<ul class="dropdown-menu bullet dropdown-menu-right" role="menu">'

                        + '<li role="presentation" class="b-b-g url_navigators" resource="Inventory/Item/store_stock_details"><a href="' + siteurl + '/Inventory/Item/store_stock_details/' + stock_report[i]['item_id'] + '" id="view_stock_item_details" ><i class="icon lindo-view mr-10 fz-22 vam txt-primary"></i>Store Stock Details</a></li>'
                        + '</ul></div></td>'
                option += '</tr>'
                count++;
            }

        }
        $('.stockreport').html(option);
        pageload();
    }
    );
    $("body").on('keyup', '#product_name', function () {
        var itm = $('#productname').val();
        var searchkeyword = $(this).val();
        var option = '';
        var count = 1;
        for (var i = 0; i < item_json.length; i++) {
            if (item_json[i]['name'].toLowerCase().indexOf(searchkeyword.toLowerCase()) != -1 && item_json[i]['name'] != itm) {
                option += '<tr class="sec_grid_sm">'
                option += '<td>' + count + '</td> '
                option += '<td>' + item_json[i]['sku'] + '</td>'
                option += '<td>' + item_json[i]['name'] + '</td>'
                option += '<td>' + item_json[i]['item_type'] + '</td>'
                option += '<td>'
                option += '<label style="display:none;" id="pdt_ser_name' + item_json[i]['item_id'] + '">' + item_json[i]['name'] + '</label>'
                option += '<input type="hidden" id="pdt_ser_id' + item_json[i]['item_id'] + '" value="' + item_json[i]['item_id'] + '">'
                option += '<input type="hidden" id="pdt_ser_sku' + item_json[i]['item_id'] + '" value="' + item_json[i]['sku'] + '">'
                option += '<input type="hidden" id="pdt_ser_sell_price' + item_json[i]['item_id'] + '" value="' + item_json[i]['sellingprice'] + '">'
                option += '<input type="hidden" id="pdt_ser_pur_price' + item_json[i]['item_id'] + '" value="' + item_json[i]['purchase_price'] + '">'
                option += '<input type="hidden" id="pdt_ser_unit' + item_json[i]['item_id'] + '" value="' + item_json[i]['unit_code'] + '">'
                option += '<input type="hidden" id="pdt_ser_type' + item_json[i]['item_id'] + '" value="' + item_json[i]['item_type'] + '">'
                option += '<input type="hidden" id="tot_qty' + item_json[i]['item_id'] + '" value="' + item_json[i]['total_quantity'] + '">'
                option += '<div class="checkbox checkbox-success"><input type="checkbox" class="pickitem" id="" name="pickitem[]" amc_flag="' + item_json[i]['amc_flag'] + '"  warranty_flag="' + item_json[i]['warranty_flag'] + '"  pdt_ser_id="' + item_json[i]['item_id'] + '"  pdt_ser_sell_price="' + item_json[i]['sellingprice'] + '"  item_name="' + item_json[i]['name'] + '"   pdt_ser_unit="' + item_json[i]['unit_code'] + '"><label></label></div>'
                option += '</td>'
                option += '</tr>';
                count++;
            }
        }
        $('.item_parts').html(option);
    });
    $('body').on('click', '.parts_add', function () {

        var count_checked = $(".pickitem:checkbox:checked").length;
        var spn = '';
        var item_id = [];
        var name = [];
        var amc = [];
        var warranty = [];
        var amc_flag = [];
        var warranty_flag = [];
        if (count_checked > 0) {
            $(".pickitem:checkbox:checked").each(function () {
                item_id.push($(this).attr('pdt_ser_id'));
                name.push($(this).attr('item_name'));
                amc_flag.push($(this).attr('amc_flag'));
                warranty_flag.push($(this).attr('warranty_flag'));
            });
        }
        for (var i = 0; i < name.length; i++) {

            spn += '<tr class="sec_grid assembledparts-tr">';
            spn += '<td><input type="checkbox" name="warranty[]" class="warranty"';
            if (warranty_flag[i] == "1") {
                spn += 'checked="checked"';
            }
            spn += 'value="1"/></td>';
            spn += '<td><input type="checkbox" name="amc[]" class="amc"';
            if (amc_flag[i] == "1") {
                spn += 'checked="checked"';
            }
            spn += 'value="1"/></td>';
            spn += '<td>' + name[i] + '</td>';
            spn += '<td><input type="number" name="quantity_parts[]" id="quantity_parts" class="form-control quantity_parts number_validate" min="0" value="" placeholder="enter quantity"></td>';
            spn += '<td><a href="#" class="clear_parts text-danger"><i class="icon lindo-android-remove-circle fz-22 txt-danger"></i></a></td>';
            spn += '<input type="hidden" name="part_item_id[]" id="item_id" class="item_id"  value="' + item_id[i] + '">';
            spn += '<input type="hidden" name="ck_warranty_parts[]" id="ck_warranty_parts" class="ck_warranty_parts"';
            if (warranty_flag[i] == "1") {
                spn += 'value="1"';
            } else {
                spn += 'value="0"';
            }
            spn += '>';
            spn += '<input type="hidden" name="ck_amc_parts[]" id="ck_amc_parts" class="ck_amc_parts"';
            if (amc_flag[i] == "1") {
                spn += 'value="1"';
            } else {
                spn += 'value="0"';
            }
            spn += '>';
            spn += '</tr>';
        }
        $('.addtl_parts').append(spn);
        $('#addtl_parts_div').removeClass('no-display')
        $('#addtlparts').modal('hide');
        $('.modal-backdrop').remove();
        if ($('.assembledparts-tr').length == 0) {
            $('.no_data').show();
            $('#addtl_parts_div').addClass('no-display');
        } else {
            $('.no_data').hide();
        }
    });
    $('body').on('click', '.warranty', function () {
        if ($(this).prop("checked") == true) {
            $(this).closest('tr').find('.ck_warranty_parts').val(1);
        } else {
            $(this).closest('tr').find('.ck_warranty_parts').val(0);
        }
    });
    $('body').on('click', '.amc', function () {
        if ($(this).prop("checked") == true) {
            $(this).closest('tr').find('.ck_amc_parts').val(1);
        } else {
            $(this).closest('tr').find('.ck_amc_parts').val(0);
        }
    });
    $('body').on('click', '#ck_amc', function () {
        if ($(this).is(":checked")) {
            $('#ck_amc_list').show();
            $('.amc_new_div').show();
            $('.new_amc_clone').removeClass('no-display');
        } else if ($(this).is(":not(:checked)")) {
            $('#ck_amc_list').hide();
            $('.amc_new_div').hide();
        }
    });
    $('body').on('click', '#ck_task_div', function () {
        if ($(this).is(":checked")) {
            $('.new_task_div').show();
        } else if ($(this).is(":not(:checked)")) {
            $('.new_task_div').hide();
        }
    });
    $('body').on('click', '.recursive', function () {
        if ($(this).is(":checked")) {
            var att_value = $(this).attr('recur_no');
            var add_newbtn = $(this).closest('.new_amc_clone').find('.add_new').addClass('no-display');
            $(this).closest('.new_amc_clone').find('.new_clone').remove();
            $(this).closest('.new_amc_clone').find('.ck_recursive').val(1);
            $(this).closest('.new_amc_clone').find('.clone2').remove();
        } else if ($(this).is(":not(:checked)")) {
            $(this).closest('.new_amc_clone').find('.add_new').removeClass('no-display');
            $(this).closest('.new_amc_clone').find('.ck_recursive').val(0);
        }
    });
    $('body').on('click', '.add_new', function (e) {

        var att = $(this).attr('add_no');
        var bc = $(this).closest('.new_amc_clone').find('.clone').clone();
        bc.removeClass('clone');
        bc.addClass('new_clone');
        bc.find('.clear').remove();
        bc.removeClass('clone');
        var gg = bc.find("input");
        gg.val("");
        bc.find('.month').val("");
        var cc = bc.find('.no-display');
        cc.removeClass('no-display');
        var dd = bc.find(".recursive");
        dd.addClass('no-display');
        var dd = bc.find(".rec");
        dd.addClass('no-display');
        var ee = bc.find(".clear_amc");
        ee.removeClass('no-display');
        bc.appendTo($(this).closest('.new_amc_clone').find('.ck_amc_list'));
    });
    $('body').on('click', '.clear_amc', function () {
        $(this).closest('tr').remove();
    });
    $('body').on('click', '.clear_parts', function () {
        $(this).closest('tr').remove();
        if ($('.assembledparts-tr').length == 0) {
            $('.no_data').show();
            $('#addtl_parts_div').addClass('no-display');
        } else {
            $('.no_data').hide();
        }
    });
    var count = 1;
    $('body').on('click', '#add_amc', function (e) {
        var clid = $(".new_amc_clone:last").attr('id-cld');
        var nxt = parseFloat(clid) + 1;
        var bc = $(".clones").clone();
        bc.attr("id-cld", nxt);
        bc.removeClass('clones');
        bc.addClass('new_clones');
        var dd = bc.find("input");
        dd.val("");
        bc.removeClass('clone2');
        bc.find('.clone2').remove();
        bc.find('.deafault_amc').prop("checked", false);
        bc.find('.month').val("");
        bc.find('.serviceno').attr('name', 'serviceno_' + nxt + '[]');
        bc.find('.month').attr('name', 'month_' + nxt + '[]');
        bc.find('.period').attr('name', 'period_' + nxt + '[]');
        bc.find('.ck_recursive').attr('name', 'ck_recursive_' + nxt);
        bc.find('.price').attr('name', 'price_' + nxt);
        bc.find('.amc_id').attr('name', 'amc_id' + nxt);
        $('#amccount').val(nxt);
        bc.find('.new_clone').addClass('no-display');
        bc.find('.add_new').removeClass('no-display');
        bc.find('.delete_amc').removeClass('no-display');
        bc.find('.recursive').prop('checked', false);
        bc.find('.ck_recursive').val(0);
        bc.find('.amc_id').val(0);
        bc.find('.deafault_amc').val(nxt);
        var att = $('.chec').attr('recur_no');
        if (att !== 0) {
            bc.find('.recursive').attr('recur_no', count);
        }

        bc.find('.add_new').attr('add_no', count)
        count++;
        bc.appendTo(".new_amc");
    });
    $('body').on('click', '#ck_warranty', function () {
        if ($(this).is(":checked")) {
            $('#ck_warranty_list').show();
            $('.no_warr_data').hide();
        } else if ($(this).is(":not(:checked)")) {
            $('#ck_warranty_list').hide();
            $('.no_warr_data').show();
        }
    });
    $('body').on('click', '#addtl_parts', function () {
        $('.pickitem').prop('checked', false);
        var itm = $('#productname').val();
        var searchkeyword = $(this).val();
        var option = '';
        var count = 1;
        var new_array = [];
        for (var i = 0; i < item_json.length; i++) {
            if (item_json[i]['name'].toLowerCase().indexOf(searchkeyword.toLowerCase()) != -1 && item_json[i]['name'] != itm) {
                new_array.push(item_json[i]);
            }
        }
        var length1 = 10;
        if (new_array.length < 10) {
            length1 = new_array.length
        }
        for (var i = 0; i < length1; i++) {
            if (new_array[i]['name'].toLowerCase().indexOf(searchkeyword.toLowerCase()) != -1 && new_array[i]['name'] != itm) {
                option += '<tr class="sec_grid_sm">'
                option += '<td>' + count + '</td> '
                option += '<td>' + new_array[i]['sku'] + '</td>'
                option += '<td>' + new_array[i]['name'] + '</td>'
                option += '<td>' + new_array[i]['item_type'] + '</td>'
                option += '<td>'
                option += '<label style="display:none;" id="pdt_ser_name' + new_array[i]['item_id'] + '">' + new_array[i]['name'] + '</label>'
                option += '<input type="hidden" id="pdt_ser_id' + new_array[i]['item_id'] + '" value="' + new_array[i]['item_id'] + '">'
                option += '<input type="hidden" id="pdt_ser_sku' + new_array[i]['item_id'] + '" value="' + new_array[i]['sku'] + '">'
                option += '<input type="hidden" id="pdt_ser_sell_price' + new_array[i]['item_id'] + '" value="' + new_array[i]['sellingprice'] + '">'
                option += '<input type="hidden" id="pdt_ser_pur_price' + new_array[i]['item_id'] + '" value="' + new_array[i]['purchase_price'] + '">'
                option += '<input type="hidden" id="pdt_ser_unit' + new_array[i]['item_id'] + '" value="' + new_array[i]['unit_code'] + '">'
                option += '<input type="hidden" id="pdt_ser_type' + new_array[i]['item_id'] + '" value="' + new_array[i]['item_type'] + '">'
                option += '<input type="hidden" id="tot_qty' + new_array[i]['item_id'] + '" value="' + new_array[i]['total_quantity'] + '">'
                option += '<div class="checkbox checkbox-success"><input type="checkbox" class="pickitem" id="" name="pickitem[]" amc_flag="' + new_array[i]['amc_flag'] + '"  warranty_flag="' + new_array[i]['warranty_flag'] + '"  pdt_ser_id="' + new_array[i]['item_id'] + '"  pdt_ser_sell_price="' + new_array[i]['sellingprice'] + '"  item_name="' + new_array[i]['name'] + '"   pdt_ser_unit="' + new_array[i]['unit_code'] + '"><label></label></div>'
                option += '</td>'
                option += '</tr>';
                count++;
            }
        }
        $('.item_parts').html(option);
    });
    $("body").on('click', '.pickitem', function (e) {
        var id = $(this).attr('pdt_ser_id');
        var occurence1 = 0;
        $('.item_id').each(function () {
            if ($(this).val() === id) {
                occurence1++;
            }
        });
        $('.part_item_id').each(function () {
            if ($(this).val() === id) {
                occurence1++;
            }
        });
        if (occurence1 > 0) {
            swal('Alert', 'This item is already picked', 'error');
            return false;
        }
    });
    $('body').on('keyup change', '#openingstock,#unitcost', function ()
    {
        var unitcost = $('#unitcost').val();
        var openingstock = $('#openingstock').val();
        if (unitcost && openingstock) {
            var openingstockvalue = parseFloat(openingstock) * parseFloat(unitcost);
            $('#openingstockvalue').val(openingstockvalue.toFixed(2));
        } else {
            $('#openingstockvalue').val(0);
        }
    });

    $('body').on('click', '.pagenationbtn,#pagenation_click', function () {
        var rowlimit = $(this).attr('limit');
        var pagenum = $(this).attr('page');
        var activr_page_num = $('.pagination_div1 .active ').attr('page');
        var pagination_count = parseInt(page_row_count / rowlimit);
        var pagenumber = pagenum;
        if (pagination_count > 0) {
            if (page_row_count % rowlimit > 0) {
                pagination_count++;
            }
        }
        activr_page_num = activr_page_num - 1;
        if (activr_page_num != pagenum) {
            if (pagenum == 'first') {
                if (activr_page_num != 1) {
                    pagenumber = 1;
                    $('.pagenationbtn').removeClass('active');
                    $('.pagenationbtn[page="1"]').addClass('active');
                    createpagenation1(rowlimit, pagenumber, pagination_count);
                    page_display1(pagenumber);
                }
            } else if (pagenum == 'prev') {
                if (activr_page_num != 1) {
                    pagenumber = activr_page_num - 1;
                    $('.pagenationbtn').removeClass('active');
                    $('.pagenationbtn[page="' + (activr_page_num - 1) + '"]').addClass('active');
                    createpagenation1(rowlimit, pagenumber, pagination_count);
                    page_display1(pagenumber);
                }
            } else if (pagenum == 'last') {
                if (activr_page_num != pagination_count) {
                    pagenumber = pagination_count;
                    $('.pagenationbtn').removeClass('active');
                    $('.pagenationbtn[page="' + pagination_count + '"]').addClass('active');
                    createpagenation1(rowlimit, pagenumber, pagination_count);
                    page_display1(pagenumber);
                }
            } else if (pagenum == 'next') {

                if (activr_page_num != pagination_count) {
                    pagenumber = parseInt(activr_page_num) + 1;
                    $('.pagenationbtn').removeClass('active');
                    $('.pagenationbtn[page="' + (parseInt(activr_page_num) + 1) + '"]').addClass('active');
                    createpagenation1(rowlimit, pagenumber, pagination_count);
                    page_display1(pagenumber);
                }
            } else {
                if (activr_page_num != pagenum) {
                    $('.pagenationbtn').removeClass('active');
                    $(this).addClass('active');
                    createpagenation1(rowlimit, pagenumber, pagination_count);
                    page_display1(pagenumber);
                }
            }
        }
    });
    $('#sort_by').on('change', function () {
        $('#search_product_keyword').val('');
        var type = $(this).val();
        if (type != '0') {
            $.post(siteurl + "/Inventory/Item/sort_item_by_type", {type: type}, function (result) {
                $('#sorted_data').html(result);
            });
        } else {
            location.reload();
        }
    });

    $('body').on('click', '.pagesubmit', function (e) {
        e.preventDefault();
        var search_quote_keyword = $('#search_keyword').val();
        $('#search_keyword_hidden').val(search_quote_keyword);
        var url = $(this).attr('href');
        $('#paginationfilter').attr('action', url);
        $('#paginationfilter').submit();
    });
});

function createpagenation1(rowlimit, pagenum, pagination_count) {

    if (pagination_count == 0 || pagination_count == 1) {
        $('.pagenatio').addClass('no-display');
    } else {
        var nav_list = '<div class="buttons-row width100 pagination_div1 ">';

        if (pagination_count <= 6) {
            nav_list += '    <a href="#" page="first" limit="' + rowlimit + '" class="button pagenationbtn " id="pagenation_click"><<</a>';
            nav_list += '    <a href="#" page="prev" limit="' + rowlimit + '" class="button pagenationbtn" id="pagenation_click"><</a>';
            for (var i = 1; i <= pagination_count; i++) {
                nav_list += '    <a href="#" page="' + i + '" limit="' + rowlimit + '" class="button pagenationbtn ' + ((pagenum == i) ? 'active' : '') + '" id="pagenation_click">' + i + '</a>';
            }
            nav_list += '    <a href="#" page="next" limit="' + rowlimit + '" class="button pagenationbtn" id="pagenation_click">></a>';
            nav_list += '    <a href="#" page="last" limit="' + rowlimit + '" class="button pagenationbtn" id="pagenation_click">>></a>';
        } else if (pagenum == pagination_count) {
            var num1 = pagenum - 4, num2 = pagenum - 3, num3 = pagenum - 2, num4 = pagenum - 1, num5 = pagenum;
            nav_list += '    <a href="#" page="first" limit="' + rowlimit + '" class="button pagenationbtn " id="pagenation_click"><<</a>';
            nav_list += '    <a href="#" page="prev" limit="' + rowlimit + '" class="button pagenationbtn" id="pagenation_click"><</a>';
            nav_list += '    <a href="#" page="1" limit="' + rowlimit + '" class="button border-none">...</a>';
            nav_list += '    <a href="#" page="' + num1 + '" limit="' + rowlimit + '" class="button pagenationbtn" id="pagenation_click">' + num1 + '</a>';
            nav_list += '    <a href="#" page="' + num2 + '" limit="' + rowlimit + '" class="button pagenationbtn" id="pagenation_click">' + num2 + '</a>';
            nav_list += '    <a href="#" page="' + num3 + '" limit="' + rowlimit + '" class="button pagenationbtn" id="pagenation_click">' + num3 + '</a>';
            nav_list += '    <a href="#" page="' + num4 + '" limit="' + rowlimit + '" class="button pagenationbtn" id="pagenation_click">' + num4 + '</a>';
            nav_list += '    <a href="#" page="' + num5 + '" limit="' + rowlimit + '" class="button pagenationbtn active" id="pagenation_click">' + num5 + '</a>';
            nav_list += '    <a href="#" page="next" limit="' + rowlimit + '" class="button pagenationbtn" id="pagenation_click">></a>';
            nav_list += '    <a href="#" page="last" limit="' + rowlimit + '" class="button pagenationbtn" id="pagenation_click">>></a>';
        } else if (pagenum == 1) {
            var num1 = pagenum, num2 = parseInt(pagenum) + 1, num3 = parseInt(pagenum) + 2, num4 = parseInt(pagenum) + 3, num5 = parseInt(pagenum) + 4;
            nav_list += '    <a href="#" page="first" limit="' + rowlimit + '" class="button pagenationbtn" id="pagenation_click"><<</a>';
            nav_list += '    <a href="#" page="prev" limit="' + rowlimit + '" class="button pagenationbtn" id="pagenation_click"><</a>';
            nav_list += '    <a href="#" page="' + num1 + '" limit="' + rowlimit + '" class="button pagenationbtn active" id="pagenation_click">' + num1 + '</a>';
            nav_list += '    <a href="#" page="' + num2 + '" limit="' + rowlimit + '" class="button pagenationbtn" id="pagenation_click">' + num2 + '</a>';
            nav_list += '    <a href="#" page="' + num3 + '" limit="' + rowlimit + '" class="button pagenationbtn" id="pagenation_click">' + num3 + '</a>';
            nav_list += '    <a href="#" page="' + num4 + '" limit="' + rowlimit + '" class="button pagenationbtn" id="pagenation_click">' + num4 + '</a>';
            nav_list += '    <a href="#" page="' + num5 + '" limit="' + rowlimit + '" class="button pagenationbtn" id="pagenation_click">' + num5 + '</a>';
            nav_list += '    <a href="#" page="1" limit="' + rowlimit + '" class="button border-none">...</a>';
            nav_list += '    <a href="#" page="next" limit="' + rowlimit + '" class="button pagenationbtn" id="pagenation_click">></a>';
            nav_list += '    <a href="#" page="last" limit="' + rowlimit + '" class="button pagenationbtn" id="pagenation_click">>></a>';
        } else if (pagenum <= 4) {
            nav_list += '    <a href="#" page="first" limit="' + rowlimit + '" class="button pagenationbtn" id="pagenation_click"><<</a>';
            nav_list += '    <a href="#" page="prev" limit="' + rowlimit + '" class="button pagenationbtn" id="pagenation_click"><</a>';
            nav_list += '    <a href="#" page="1" limit="' + rowlimit + '" class="button pagenationbtn" id="pagenation_click">1</a>';
            nav_list += '    <a href="#" page="2" limit="' + rowlimit + '" class="button pagenationbtn';
            if (pagenum == 2)
                nav_list += ' active" id="pagenation_click">2</a>';
            else
                nav_list += '" id="pagenation_click">2</a>';
            nav_list += '    <a href="#" page="3" limit="' + rowlimit + '" class="button pagenationbtn';
            if (pagenum == 3)
                nav_list += ' active" id="pagenation_click">3</a>';
            else
                nav_list += '" id="pagenation_click">3</a>';
            nav_list += '    <a href="#" page="4" limit="' + rowlimit + '" class="button pagenationbtn';
            if (pagenum == 4)
                nav_list += ' active" id="pagenation_click">4</a>';
            else
                nav_list += '" id="pagenation_click">4</a>';
            nav_list += '    <a href="#" page="5" limit="' + rowlimit + '" class="button pagenationbtn" id="pagenation_click">5</a>';
            nav_list += '    <a href="#" page="1" limit="' + rowlimit + '" class="button border-none">...</a>';
            nav_list += '    <a href="#" page="next" limit="' + rowlimit + '" class="button pagenationbtn" id="pagenation_click">></a>';
            nav_list += '    <a href="#" page="last" limit="' + rowlimit + '" class="button pagenationbtn" id="pagenation_click">>></a>';
        } else if (pagenum > (pagination_count - 4)) {
            var num1 = pagination_count - 4, num2 = pagination_count - 3, num3 = pagination_count - 2, num4 = pagination_count - 1, num5 = pagination_count;
            nav_list += '    <a href="#" page="first" limit="' + rowlimit + '" class="button pagenationbtn" id="pagenation_click"><<</a>';
            nav_list += '    <a href="#" page="prev" limit="' + rowlimit + '" class="button pagenationbtn" id="pagenation_click"><</a>';
            nav_list += '    <a href="#" page="1" limit="' + rowlimit + '" class="button border-none">...</a>';
            nav_list += '    <a href="#" page="' + num1 + '" limit="' + rowlimit + '" class="button pagenationbtn';
            if (pagenum == num1)
                nav_list += ' active" id="pagenation_click">' + num1 + '</a>';
            else
                nav_list += '">' + num1 + '</a>';
            nav_list += '    <a href="#" page="' + num2 + '" limit="' + rowlimit + '" class="button pagenationbtn';
            if (pagenum == num2)
                nav_list += ' active" id="pagenation_click">' + num2 + '</a>';
            else
                nav_list += '" id="pagenation_click">' + num2 + '</a>';
            nav_list += '    <a href="#" page="' + num3 + '" limit="' + rowlimit + '" class="button pagenationbtn';
            if (pagenum == num3)
                nav_list += ' active" id="pagenation_click">' + num3 + '</a>';
            else
                nav_list += '" id="pagenation_click">' + num3 + '</a>';
            nav_list += '    <a href="#" page="' + num4 + '" limit="' + rowlimit + '" class="button pagenationbtn';
            if (pagenum == num4)
                nav_list += ' active" id="pagenation_click">' + num4 + '</a>';
            else
                nav_list += '" id="pagenation_click">' + num4 + '</a>';
            nav_list += '    <a href="#" page="' + num5 + '" limit="' + rowlimit + '" class="button pagenationbtn" id="pagenation_click">' + num5 + '</a>';
            nav_list += '    <a href="#" page="next" limit="' + rowlimit + '" class="button pagenationbtn" id="pagenation_click">></a>';
            nav_list += '    <a href="#" page="last" limit="' + rowlimit + '" class="button pagenationbtn" id="pagenation_click">>></a>';
        } else if ((pagenum > 4) && (pagination_count > (parseInt(pagenum) + 2))) {
            var num1 = pagenum - 2, num2 = pagenum - 1, num3 = pagenum, num4 = parseInt(pagenum) + 1;
            nav_list += '    <a href="#" page="first" limit="' + rowlimit + '" class="button pagenationbtn" id="pagenation_click"><<</a>';
            nav_list += '    <a href="#" page="prev" limit="' + rowlimit + '" class="button pagenationbtn" id="pagenation_click"><</a>';
            nav_list += '    <a href="#" page="1" limit="' + rowlimit + '" class="button border-none">...</a>';
            nav_list += '    <a href="#" page="' + num1 + '" limit="' + rowlimit + '" class="button pagenationbtn" id="pagenation_click">' + num1 + '</a>';
            nav_list += '    <a href="#" page="' + num2 + '" limit="' + rowlimit + '" class="button pagenationbtn" id="pagenation_click">' + num2 + '</a>';
            nav_list += '    <a href="#" page="' + num3 + '" limit="' + rowlimit + '" class="button pagenationbtn active" id="pagenation_click">' + num3 + '</a>';
            nav_list += '    <a href="#" page="' + num4 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num4 + '</a>';
            nav_list += '    <a href="#" page="6" limit="' + rowlimit + '" class="button border-none">...</a>';
            nav_list += '    <a href="#" page="next" limit="' + rowlimit + '" class="button pagenationbtn" id="pagenation_click">></a>';
            nav_list += '    <a href="#" page="last" limit="' + rowlimit + '" class="button pagenationbtn" id="pagenation_click">>></a>';
        }
        nav_list += '</div>';
        $('.pagenatio').removeClass('no-display');
        $('.pagenatio').html(nav_list);
    }
}

function page_display1(pagenumber) {
    var item_start_count = (Number(pagenumber - 1) * 20 + 1);
    var count = item_start_count;
    var option = '';
    for (var i = item_start_count; i < Number(item_start_count) + 20; i++) {

        if (stock_report[i] == undefined) {
            break;

        } else if (stock_report.length > 0) {
            var current_stock = '';
            var current_stock_value = '';
            if (stock_report[i]['current_stock'] == null) {
                current_stock = '0';
            } else {
                current_stock = stock_report[i]['current_stock'];
            }
            current_stock = Number(current_stock);
            if (stock_report[i]['current_stock_value'] == null || stock_report[i]['current_stock_value'] == '') {
                current_stock_value = '0';
            } else {
                current_stock_value = stock_report[i]['current_stock_value'];
            }
            current_stock_value = Number(current_stock_value);
            var landed_cost = current_stock_value / current_stock;
            var curr_stock = Number(current_stock) - (Number(stock_report[i]['demo_qty']) + Number(stock_report[i]['service_quantity']) + Number(stock_report[i]['damaged_quantity']));
            option += '<tr class="sec_grid_tbl">'
            option += '<td class="w30 h40 hard_left pa-0"><div class="w100 h40 pull-left custom-title-wrap bar-gray pa-5 m0 item-head-nolink"><div class="sm_title">' + stock_report[i]['name'] + '</div><div class="custom-title txt-caps">&nbsp;</div></div></td>'
            option += '<td class="w100px h40 pa-2 text-center moneyholder5">' + stock_report[i]['openingstock'] + '</td>'
            option += '<td class="w150px h40 pa-2 text-center moneyholder5">' + stock_report[i]['openingstockvalue'] + '</td>'
            option += '<td class="w150px h40 pa-2 text-center moneyholder5">' + current_stock + '</td>'
            option += '<td class="w150px h40 pa-2 moneyholder5">' + stock_report[i]['current_stock_value'] + '</td>'
            option += '<td class="w150px h40 pa-2">' + stock_report[i]['demo_qty'] + '</td>'
            option += '<td class="w150px h40 pa-2">' + stock_report[i]['service_quantity'] + '</td>'
            option += '<td class="w150px h40 pa-2">' + stock_report[i]['damaged_quantity'] + '</td>'
            option += '<td class="w150px h40 pa-2">' + curr_stock + '</td>'
            option += '<td class="w150px h40 pa-2 moneyholder5">' + stock_report[i]['current_stock_value'] / stock_report[i]['current_stock'] + '</td>'
            if (current_stock_value != 0 && current_stock != 0) {
                option += '<td class="w150px h40 pa-2">' + landed_cost.toFixed(2) + '</td>'
            } else {
                option += '<td class="w150px h40 pa-2">' + 0 + '</td>'
            }
            option += '<td class="w150px h40 pa-2">' + stock_report[i]['stock_status'] + '</td>'
            option += '<td class="w50px h40 pa-2 text-center"> <div class="inline-block dropdown ">'
                    + '<a class="dropdown-toggle" data-toggle="dropdown" href="#" aria-expanded="true" role="button"><i class="icon lindo-android-more-vertical act-gray fz-22"></i></a>'
                    + '<ul class="dropdown-menu bullet dropdown-menu-right" role="menu">'

                    + '<li role="presentation" class="b-b-g url_navigators" resource="Inventory/Item/store_stock_details"><a href="' + siteurl + '/Inventory/Item/store_stock_details/' + stock_report[i]['item_id'] + '" id="view_stock_item_details" ><i class="icon lindo-view mr-10 fz-22 vam txt-primary"></i>Store Stock Details</a></li>'
                    + '</ul></div></td>'
            option += '</tr>'
            count++;
        }
    }
    $('.stockreport').html(option);

}

function readFile(line, lines) {
    line++;
    if (line < lines.length) {
        var line_data = lines[line].split(',');

        //ap-->
        if (line_data.length > 2) {
            //<--

            var name = line_data[0];
            var sku = line_data[1];
            var brand = line_data[2];
            var manufacturer = line_data[3];
            var category = line_data[4];
            var intrastate_tax = line_data[5];
            var interstate_tax = line_data[6];
            var mpn = line_data[7];
            var isbn = line_data[8];
            var hsn = line_data[9];
            var sac = line_data[10];
            var upc = line_data[11];
            var ean = line_data[12];
            var unit = line_data[13];
            var purchase_price = line_data[14];
            var purchase_description = line_data[15];
            var markup_on_price = line_data[16];
            var sellingprice = line_data[17];
            var selling_description = line_data[18];
            var reorderlevel = line_data[19];
            var openingstock = line_data[20];
            var openingstockvalue = line_data[21];
            var openingbalance = line_data[22];
            var credit_or_debit = line_data[23];
            var preservice_required = line_data[24];
            var data1 = {
                name: name.replace(/[^\x00-\x7F]/g, ""),
                sku: sku.replace(/[^\x00-\x7F]/g, ""),
                brand: brand.replace(/[^\x00-\x7F]/g, ""),
                manufacturer: manufacturer.replace(/[^\x00-\x7F]/g, ""),
                category: category.replace(/[^\x00-\x7F]/g, ""),
                intrastate_tax: intrastate_tax.replace(/[^\x00-\x7F]/g, ""),
                interstate_tax: interstate_tax.replace(/[^\x00-\x7F]/g, ""),
                mpn: mpn.replace(/[^\x00-\x7F]/g, ""),
                isbn: isbn.replace(/[^\x00-\x7F]/g, ""),
                hsn: hsn.replace(/[^\x00-\x7F]/g, ""),
                sac: sac.replace(/[^\x00-\x7F]/g, ""),
                upc: upc.replace(/[^\x00-\x7F]/g, ""),
                ean: ean.replace(/[^\x00-\x7F]/g, ""),
                unit: unit.replace(/[^\x00-\x7F]/g, ""),
                purchase_price: purchase_price.replace(/[^\x00-\x7F]/g, ""),
                purchase_description: purchase_description.replace(/[^\x00-\x7F]/g, ""),
                markup_on_price: markup_on_price.replace(/[^\x00-\x7F]/g, ""),
                sellingprice: sellingprice.replace(/[^\x00-\x7F]/g, ""),
                selling_description: selling_description.replace(/[^\x00-\x7F]/g, ""),
                reorderlevel: reorderlevel.replace(/[^\x00-\x7F]/g, ""),
                openingstock: openingstock.replace(/[^\x00-\x7F]/g, ""),
                openingstockvalue: openingstockvalue.replace(/[^\x00-\x7F]/g, ""),
                openingbalance: openingbalance.replace(/[^\x00-\x7F]/g, ""),
                credit_or_debit: credit_or_debit.replace(/[^\x00-\x7F]/g, ""),
                preservice_required: preservice_required.replace(/[^\x00-\x7F]/g, "")
            }
            $('#jquery_mask').show();
            $.ajax({
                url: siteurl + '/Inventory/Item/import_from_js',
                method: 'POST',
                data: data1,
                success: function (data) {
                    console.log(data);
                    $('#jquery_mask').hide();
                    readFile(line, lines);
                },
                error: function (a, b, c) {
                    $('#jquery_mask').hide();
                    readFile(line, lines);
                }
            });

            //ap-->
        } else {
            readFile(line, lines);
        }
        //<--
    } else {
        location.reload();
    }
}
