$(document).ready(function () {
    $(window).load(function () {
        if (typeof old_rate !== 'undefined' && typeof new_rate !== 'undefined' && parseFloat(old_rate) != '' && parseFloat(old_rate) != parseFloat(new_rate)) {
            swal({
                title: "Transaction Rate Changed",
                text: "Do you want to apply the new rate",
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "Yes, Apply !",
                cancelButtonText: "No, don't apply !",
                closeOnConfirm: false,
                closeOnCancel: false
            },
                    function (isConfirm) {
                        if (isConfirm) {
                            $('.currency_rate').val(new_rate);
                            $('.old_hidden').val(old_rate);
                            $('.cur_trans_rate_id').val(new_cur_trans_rate_id);
                            swal("Rate Changed", "New Rate applied", "success");
                        } else {
                            swal("Cancelled", "Previous Rate will prevail", "success");
                            $('.gainloss').hide();
                        }
                    });
        } else {
            $('.gainloss').hide();
        }

        $('.ck_sel').each(function () {
            if ($(this).is(":checked")) {
                var closest_tr = $(this).closest('tr');
                var rowid = closest_tr.attr('idcl');
                calculate_row_amount(closest_tr);
                find_mrv_total(rowid);
                product_subtotal_calculation();
                final_calculation();
                $('#common_percentage_amount').trigger('change');
            }
        });
    });
    $('body').on('change', '#get_po', function ()
    {
        var po_id = $(this).val();
        window.location.href = siteurl + "/Inventory/Bill/new_bill/" + po_id;
    });
    $('body').on('click', '.po_number', function ()
    {
        $('#jquery_mask').show();
        $.post(siteurl + "/Inventory/Bill/list_po_model", {act: 'bill'}, function (data)
        {
            $('#jquery_mask').hide();
            $('#PO_List .modal-body').html(data);
        });
    });
    $('body').on('keyup', '#qty,#invoice_rate', function () {
        var table_cls = $(this).closest('table').attr('table_cls');
        var rowid = $(this).closest('tr').attr('id-cl');
//        var row_id1 = $(this).closest('tr').attr('idcl');
        var sll = $('.' + table_cls + ' [id-cl=' + rowid + ']');
        if (table_cls == 'undefined' || table_cls == undefined) {
            var sll = $(this).closest('tr');
        }
        calculate_row_amount(sll);
        find_mrv_total(sll.attr('idcl'));
        product_subtotal_calculation();
        final_calculation();
        $('#common_percentage').trigger('change');
    });
    $('body').on('blur', '.dis', function () {

        var table_cls = $(this).closest('table').attr('table_cls');
        var rowid = $(this).closest('tr').attr('id-cl');
        var sll = $('.' + table_cls + ' [id-cl=' + rowid + ']');
        if (table_cls == 'undefined' || table_cls == undefined) {
            var sll = $(this).closest('tr');
        }
        var discount_percentage = $(this).val();
        var pro_rate = sll.find('.invoice_rate').val();
        var quan = sll.find('.qty').val();
        var pro_amount = pro_rate * quan;
        var percent = (parseFloat(discount_percentage) * pro_amount / parseFloat(100));
        if (isNaN(percent)) {
            var percent = 0;
        }
        sll.find('.entered_discount_amount').val(parseFloat(percent).toFixed(2));
        calculate_row_amount(sll);
        find_mrv_total(sll.attr('idcl'));
        product_subtotal_calculation();
        final_calculation();
        $('#common_percentage').trigger('change');
    });
    //////// for enterd discount//////////////
    $('body').on('keyup', '#entered_discount_amount', function () {
        var table_cls = $(this).closest('table').attr('table_cls');
        var rowid = $(this).closest('tr').attr('id-cl');
        var sll = $('.' + table_cls + ' [id-cl=' + rowid + ']');
        if (table_cls == 'undefined' || table_cls == undefined) {
            var sll = $(this).closest('tr');
        }
        calculate_row_amount(sll);
        find_mrv_total(sll.attr('idcl'));
        product_subtotal_calculation();
        final_calculation();
        $('#common_percentage').trigger('change');
    });
    ///// common percentage calculations//////////

    $('body').on('change', '#common_percentage', function () {
        var common_percentage = $(this).val();
        if (common_percentage == '') {
            common_percentage = 0;
        }
        var pro_total = $('#total_amount_hidden').val();
        if (pro_total != 0) {
            var cda = (parseFloat(pro_total) * parseFloat(common_percentage) / 100);
            $('#common_percentage_amount').val(parseFloat(cda).toFixed(2));
            var total_amount_with_disc = parseFloat(pro_total) - parseFloat(cda);
//            $('#bill_subtotal_txt').val(parseFloat(total_amount_with_disc).toFixed(2));
            $('#bill_subtotal').val(parseFloat(total_amount_with_disc).toFixed(2));
            $('#bill_subtotal_txt').val(parseFloat(total_amount_with_disc).toFixed(2));
            var currency_rate = $('#currency_rate').val();
            var final_currency_amt = (total_amount_with_disc * currency_rate);
            var tr_currency = final_currency_amt.toFixed(2);
            $('.final_curency_amount').val(tr_currency);
        } else {
            $(this).val(0);
            $('#common_percentage_amount').val(0);
        }
    });
    $('body').on('change', '#common_percentage_amount', function () {
        var common_percentage_amount = $(this).val();
        if (common_percentage_amount == '') {
            common_percentage_amount = 0;
        }
        var pro_total = $('#total_amount_hidden').val();
        console.log(pro_total)
        if (pro_total != 0) {
            var cdp = (parseFloat(common_percentage_amount) * 100) / parseFloat(pro_total);
            $('#common_percentage').val(parseFloat(cdp).toFixed(2));
            var total_amount_with_disc = parseFloat(pro_total) - parseFloat(common_percentage_amount);
            $('#bill_subtotal_txt').val(parseFloat(total_amount_with_disc).toFixed(2));
            $('#bill_subtotal').val(parseFloat(total_amount_with_disc).toFixed(2));
        } else {
            $(this).val(0);
            $('#common_percentage').val(0);
        }
    });
    $('body').on('click', '.charge_new', function () {
        var date = new Date();
        var dd = date.getDate();
        var mm = date.getMonth() + 1;
        var yyyy = date.getFullYear();
        var llll = date.getFullYear() + 1;
        if (dd < 10) {
            dd = '0' + dd
        }

        if (mm < 10) {
            mm = '0' + mm
        }
        var cur_date = yyyy + '-' + mm + '-' + dd;
        $('#charge_bill_date').val(cur_date);
        $('#charge_valid_until').val('');
        $('#oc_pay_type').val('');
        $('#oc_paid_through').val('');
        $('#charge_vendor').val('');
        $('#trans_currency_id').val(cur_id);
        $('#trans_currency_rate').val(old_rate);
        $('#trans_cur_rate_id').val(new_cur_trans_rate_id);
        var selid = $(this).closest('tr').attr('id-cl_charge');
        $('.charge_paid_by[value="vendor"]').prop('checked', true);
        $("#trid_charge").val(selid);
        $('#pay_mode').hide();
        $('#paid_thrgh').hide();
        $('#vendor_chose').hide();
        $('#trans_cur').hide();
        $('#div_currencyrates').hide();
    });
    $('body').on('click', '#new_charges', function () {
        var charge_amount = $('#charge').val();
        var charge_id = $('#asso_extra_chrg').val();
        var charge_paidby = $("input[name='charge_paid_by']:checked").val();
        if (charge_amount != '' && charge_id != '') {

            var charge_type = $('input[name=charge_bill_type]:checked').val();
            var oc_paid_through = $('#oc_paid_through').val();
            var oc_pay_type = $('#oc_pay_type').val();
            var charge_vendor = $('#charge_vendor_id').val();
            var ot_valid_until = $('#charge_valid_until').val();
            var charge_bill_date = $('#charge_bill_date').val();
            var ot_currency_id = $('#trans_currency_id').val();
            var ot_currency_rate_id = $('#trans_cur_rate_id').val();
            var ot_currency_rate = $('#trans_currency_rate').val();
            var ot_bill_no = $('#charge_bill_number').val();
            if (charge_type == 'actual' && charge_paidby == 'company' && (oc_pay_type == 'Cash' || oc_pay_type == 'Card') && oc_paid_through == '') {
                $('#oc_paid_through').css('border', '1px solid red');
            } else if (charge_type == 'actual' && charge_paidby == 'company' && oc_pay_type == 'Credit' && charge_vendor == '') {
                $('#charge_vendor').css('border', '1px solid red');
            } else {
                var charge_id = $('#asso_extra_chrg').val();
                var charge_description = $('#charge_discription').val();
                var charge_amount = $('#charge').val();
                var chrg_name = $('#asso_extra_chrg option:selected').attr('charg_name');
                var bill_no = $('#bill_no_div').val();
                var sid = $('#trid_charge').val();
                var sll = $('.cld_charge[id-cl_charge=' + sid + ']');
                var ff = sll.find('.associated_chrg_id');
                ff.val(charge_id);
                var chaid = sll.find('.charge_id');
                chaid.val(charge_id);
                var chrg = sll.find('.charge_name_t');
                chrg.text(chrg_name);
                sll.find('.charge_paid_type').val(oc_pay_type);
                sll.find('.charge_paid_through').val(oc_paid_through);
                sll.find('.ot_valid_until').val(ot_valid_until);
                sll.find('.ot_vendor_id').val(charge_vendor);
                sll.find('.ot_bill_date').val(charge_bill_date);
                sll.find('.ot_transaction_currency').val(ot_currency_id);
                sll.find('.ot_transaction_currency_rate_id').val(ot_currency_rate_id);
                sll.find('.ot_transaction_currency_rate').val(ot_currency_rate);
                var paid_by = sll.find('.charge_paidby');
                paid_by.val(charge_paidby);
                var amountt = sll.find('.charge_amount_t');
                amountt.text(charge_amount);
                var amount1 = sll.find('.charge_amount')
                amount1.val(charge_amount);
                if (charge_paidby == "company" || charge_paidby == "vendor") {
                    var amountt = sll.find('#other_amount');
                    amountt.val(charge_amount);
                }
                var qq = sll.find('.charge_description');
                qq.val(charge_description);
                var bill_number = sll.find('.bill_no');
                bill_number.val(bill_no);
                var other_bill_number = sll.find('.charge_bill_no');
                other_bill_number.val(ot_bill_no);
                var chargetype = sll.find('.charge_type');
                chargetype.val(charge_type);
                if (charge_type == 'acural') {
                    sll.find('.checck_acural').hide();
                    $('#charge_bill_number').val('');
                } else {
                    sll.find('.checck_acural').hide();
                    sll.find('.actual').addClass('no-display');
                    sll.find('.checck_acural').html('');
                }
                var sum = 0;
                var sum2 = 0;
                var f = 0;
                if (charge_paidby == "vendor") {
//                    var sum1 = $('#bill_subtotal_txt').val();
                    var sum1 = $('#bill_subtotal_txt').val();
                    console.log(sum1)
                    sum2 = $('#charge').val();
                    sum1 = Number(sum1) + Number(sum2);
                    $('.qwer').val(sum1);
                    $('#transaction_rate_value').text(sum1);
//                    var hid_sum1 = $('#total_amount_hidden').val();
//                    hid_sum1 = Number(hid_sum1) + Number(sum2);
//                    $('#total_amount_hidden').val(hid_sum1);

                } else {
                    if (charge_type == 'actual') {
                        if ($('#oc_pay_type').val() == '') {
                            f = 1;
                            $('#oc_pay_type').css('border', '1px solid red');
                        } else if ($('#oc_paid_through').val() == '') {
                            f = 1;
                            $('#oc_paid_through').css('border', '1px solid red');
                        } else if ($('#oc_pay_type').val() == '') {
                            f = 1;
                            $('#asso_extra_chrg').css('border', '1px solid red');
                        } else {
                            f = 0;
                        }
                    }
                    if ($('#trans_currency_id').val() == null) {
                        f = 1;
                        $('#trans_currency_id').css('border', '1px solid red');
                    } else if ($('#charge_vendor').val() == '') {
                        f = 1;
                        $('#charge_vendor').css('border', '1px solid red');
                    } else {
                        f = 0;
                    }
                }
                var ttlsum = 0;
                $('.charge_amount').each(function () {
                    ttlsum += Number($(this).val());
                });
                if (f == 0) {
                    $('.extracharge_totalamnt').val(ttlsum);
                    $('.extracharge_totalamnt').html(ttlsum);
                    $('#Othercharges').modal('hide');
                }
            }
        } else if (charge_amount == '') {
            $('#charge').css('border', '1px solid red');
        } else if (charge_id == '') {
            $('#asso_extra_chrg').css('border', '1px solid red');
        }
//        $('#common_percentage_amount').trigger('change');
        $('.charge_new[id-cl_charge="' + sid + '"]').addClass('no-display');
    });
    $('body').on('keyup', '#charge', function (e) {
        $('#charge').css('border', '1px solid rgba(33, 33, 33, 0.12)');
    });
    $('body').on('click', '.copyorgmember_charge', function (e) {
        var val_chrge = $('.charge_amount_t:last').text();
        if (val_chrge == '') {
            swal("Enter valid other charge entry");
        } else {
            e.preventDefault();
            var clid = $(".cld_charge:last").attr('id-cl_charge');
            var nxt = parseFloat(clid) + 1;
            var bc = $(".clone_charge").clone();
            bc.attr("id-cl_charge", nxt);
            var dd = bc.find("input");
            bc.find(".charge_name_t").text('');
            bc.find(".charge_amount_t").text('');
            dd.val("");
            bc.removeClass('clone_charge');
            bc.find('.charge_new').attr("id-cl_charge", nxt);
            bc.find('.clear_charge').remove();
            var cc = bc.find('.no-display');
            cc.removeClass('no-display');
            bc.appendTo(".table-append_charge");
//        aswathy
            $('#asso_extra_chrg').val('');
//            $('#charge_bill_type').prop('checked', false);
            $('#charge_bill_number').val('');
            $('#charge').val('');
            $('#charge_discription').val('');
            $('#charge_paid_by').prop('checked', false);
        }
    });
    $('body').on('click', '.removeorgmember_charge', function (e) {
        e.preventDefault();
        var sum2 = 0;
        var charge = $(this).closest('tr').find('.charge_amount').val();
        var charge_paidby = $(this).closest('tr').find('.charge_paidby').val();
        $(this).closest('tr').find('.charge_new').removeClass('no-display');
        if (charge_paidby == "vendor") {
            sum2 = Number(charge);
        }
        var hid_sum1 = $('#bill_subtotal_txt').val();
        if (hid_sum1 == 0) {
            $('#bill_subtotal_txt').val(0);
        } else {
            hid_sum1 = Number(hid_sum1) - Number(sum2);
            $('#total_amount_hidden').val(hid_sum1);
            $('#bill_subtotal_txt').val(hid_sum1);
            var ttlsum = 0;
            $('.charge_amount').each(function () {
                ttlsum += Number($(this).val());
            });
            $('.extracharge_totalamnt').val(ttlsum);
            $('.extracharge_totalamnt').html(ttlsum);
        }
        $(this).closest('tr').remove();
    });
    $('body').on('click', '.clear_charge', function (e) {
        e.preventDefault();
        var sum2 = 0;
        var charge = $(this).closest('tr').find('.charge_amount').val();
        $(this).closest('tr').find('.charge_new').removeClass('no-display');
        var charge_paidby = $(this).closest('tr').find('.charge_paidby').val();
        if (charge_paidby == "vendor") {
            sum2 = Number(charge);
        }
        var hid_sum1 = $('#bill_subtotal_txt').val();
        if (hid_sum1 == 0) {
            $('#bill_subtotal_txt').val(0);
        } else {


            hid_sum1 = Number(hid_sum1) - Number(sum2);
            $('#total_amount_hidden').val(hid_sum1);
            $('#bill_subtotal_txt').val(hid_sum1);
            $(this).closest('tr').find('input,select,checkbox').val('');
            $(this).closest('tr').find('.charge_name_t').text('');
            $(this).closest('tr').find('.charge_amount_t').text('');
            $(this).closest('tr').find('.charge_amount').val('0');
            var ttlsum = 0;
            $('.charge_amount').each(function () {
                ttlsum += Number($(this).val());
            });
            $('.extracharge_totalamnt').val(ttlsum);
            $('.extracharge_totalamnt').html(ttlsum);
//        $("#bill_subtotal_txt").trigger("change");
//        $('#common_percentage_amount').trigger('change');
        }
    });
    $('body').on('click', '#ck_sel', function () {
        var row_id = $(this).attr('id-cl');
        var all_total_bill = 0;
        var all_total_bill1 = 0;
        $('.ck_sel').each(function () {
            if ($(this).is(":checked")) {
                var proamnt = $(this).closest('tr').find('#pro_amount').val();
                all_total_bill += parseFloat(proamnt);
                var closest_tr = $(this).closest('tr');
                var rowid = closest_tr.attr('idcl');
                var net = closest_tr.find();
                calculate_row_amount(closest_tr);
                find_mrv_total(rowid);
                product_subtotal_calculation();
                final_calculation();
//                tax_calculation(closest_tr, net);
            }
        });
        $('.ck_sel_' + row_id + '').each(function () {
            if ($(this).is(":checked")) {
                var proamnt = $(this).closest('tr').find('#pro_amount').val();
                all_total_bill1 += parseFloat(proamnt);
            }
        });
//        $('#bill_subtotal_txt').val(all_total_bill);
        $('#bill_subtotal').val(all_total_bill);
        $('#total_amount_hidden').val(all_total_bill);
        if ($(this).is(":checked")) {

            var table_cls = $(this).closest('table').attr('table_cls');
            var rowid = $(this).closest('tr').attr('id-cl');
            var sll = $('.' + table_cls + ' [id-cl=' + rowid + ']');
            var aa = sll.find('#qty');
            var bb = sll.find('#invoice_rate');
            var rr = sll.find('#pro_rate');
            var dc = sll.find('#discount');
            var eda = sll.find('#entered_discount_amount');
            var nn = sll.find('#po_rate');
            var mm = sll.find('#pro_amount');
            aa.attr('readonly', false);
            bb.attr('readonly', false);
            rr.attr('readonly', false);
            dc.attr('readonly', false);
            eda.attr('readonly', false);
            var oth_subtotal = 0;
            $('body').find('.charge_amount').each(function () {
                var aa = $(this).closest('tr').find('.charge_paidby').val();
                if (aa == "vendor") {
                    oth_subtotal += parseFloat($(this).val());
                }
            });
            var amt = nn.val();
            sll.find('#pro_rate').val(amt);
            all_total_bill += oth_subtotal;
            $('#bill_subtotal').val(parseFloat(all_total_bill));
//            $('#bill_subtotal_txt').val(all_total_bill);
//            $('#bill_subtotal_txt_' + row_id + '').html(all_total_bill1);

            $('#total_amount_hidden').val(all_total_bill);
            $('#common_percentage_amount').trigger('change');
        } else {
            var table_cls = $(this).closest('table').attr('table_cls');
            var rowid = $(this).closest('tr').attr('id-cl');
            var sll = $('.' + table_cls + ' [id-cl=' + rowid + ']');
            var aa = sll.find('#qty');
            var bb = sll.find('#invoice_rate');
            var rr = sll.find('#pro_rate');
            var mm = sll.find('#pro_amount');
            var nn = sll.find('#po_rate');
            var dc = sll.find('#discount');
            var eda = sll.find('#entered_discount_amount');
            aa.attr('readonly', true);
            bb.attr('readonly', true);
            rr.attr('readonly', true);
            dc.attr('readonly', true);
            eda.attr('readonly', true);
            var tax_enabled = $('#tax_enabled').val();
            if (tax_enabled != -1) {
                var fff = sll.find('.pdttax');
                var taxval = fff.val();
                var taxvalfinal = taxval.split(':');
                taxvalfinal = taxvalfinal[0] + ':' + 0;
                fff.val(taxvalfinal);
            }


            aa.val(0);
            dc.val(0);
            bb.val(0);
            eda.val(0);
            var oth_subtotal = 0;
            $('body').find('.charge_amount').each(function () {
                var aa = $(this).closest('tr').find('.charge_paidby').val();
                if (aa == "vendor") {
                    oth_subtotal += parseFloat($(this).val());
                }
            });
            var amt = nn.val();
            sll.find('#pro_rate').val(amt);
            mm.val(0);
            calculate_row_amount(sll);
            find_mrv_total(rowid);
            product_subtotal_calculation();
            final_calculation();
        }
    });
    $('#bill_form').on('submit', function (e) {
        var pagecheck_view = $('#pagecheck_view').val();
        var count_err = 0;
        if (pagecheck_view == 'direct_bill') {
            var checked = 1;
        } else {
            var checked = 0;
        }
        var purchase_type = $('#sale_type').val();
        var paid_from = $('#deposit_to').val();
        $('.qty').each(function () {
            if ($(this).closest('tr').find('.ck_sel').prop('checked')) {
                checked++;
                if ($(this).val() == '0' || $(this).val() == '' || isNaN($(this).val())) {
                    count_err++;
                }
            }
        });
        if (purchase_type != "Credit" && paid_from == "") {
            e.preventDefault();
            swal('Alert', 'Please select Paid From', 'error');
        }
        if (checked == 0) {
            e.preventDefault();
            swal('Alert', 'Please select atleast one item', 'error');
        }
        if (count_err > 0) {
            e.preventDefault();
            swal('Alert', 'Please enter valid issue quantity.', 'error');
        }
    });
    $('body').on('click', '.checck_acural', function ()
    {
        if ($(this).is(":checked"))
        {
            $(this).closest('td').find('.charge_type').val('actual');
            $(this).closest('td').find('.bill_no').show();
        } else
        {
            $(this).closest('td').find('.charge_type').val('acural');
            $(this).closest('td').find('.bill_no').hide();
        }
    });
    $('body').on('click', '#charge_bill_type', function ()
    {
        var radioValue = $(".charge_paid_by:checked").val();
        if ($("input[name='charge_bill_type']:checked").val() == 'actual') {
            $('#bill_no_div').show();
            $('#bill_date_div').show();
            if (radioValue == 'company') {
                $('#pay_mode').show();
                $('#paid_thrgh').show();
            } else {
                $('#pay_mode').hide();
                $('#paid_thrgh').hide();
            }
        } else {
            $('#bill_no_div').hide();
            $('#bill_date_div').hide();
            $('#pay_mode').hide();
            $('#paid_thrgh').hide();
        }
    });
    $('body').on('click', '.get_po_frominvoice', function (e) {
        var closest_tr = $(this).closest('tr');
        if ($(closest_tr).find('.mrv:checked').length > 0) {
        } else {
            e.preventDefault();
            swal('Please Select Atleast One MRV');
        }
    });
    $('body').on('click', '#currency_id', function () {
        var currency_id = $(this).val();
        $.post(siteurl + "/Inventory/Bill/fetch_currency_rate_by_latest", {currency_id: currency_id}, function (data) {
            var result = JSON.parse(data);
            $('.div_currencyrate').removeClass('no-display');
            $('.currency_rate').val(result.rate);
            $('.cur_trans_rate_id').val(result.cur_trans_rate_id);
            var net_amount = $('#bill_subtotal_txt').val();
            if (typeof result.rate === 'undefined' || result.rate == '') {
                result.rate = 1;
            }


            $('.po_rate').each(function () {
                var this_tr = $(this).closest('tr');
                var pro_rate = $(this).closest('tr').find('.po_rate_hidden').val();
                var prorate = parseFloat(pro_rate) * parseFloat(result.rate);
                if (prorate) {
                    $(this).val(prorate.toFixed(2));
                }

            });
            if (net_amount != 'undefined' && net_amount != '') {
                var transaction_currency = parseFloat(net_amount) / parseFloat(result.rate);
                var tr_currency = transaction_currency.toFixed(2);
                $('#transaction_currency').val(tr_currency);
                $('#transaction_rate_value').html(tr_currency);
                if (currency_id != cur_id) {
                    $('#transaction_gain').hide();
                } else {
                    $('#transaction_gain').show();
                }

            }

        });
    });
    $('body').on('change click', '.qty,.dis,.removeorgmember_charge,.clear_charge,.entered_discount_amount,.common_percentage_amount,.common_percentage', function () {
        var net_amount = $('#bill_subtotal_txt').val();
        var transaction_rate = $('#currency_rate').val();
        if (transaction_rate == 'undefined' && transaction_rate == '') {
            transaction_rate = 1;
        }

        if (net_amount != 'undefined' && net_amount != '') {
            var transaction_currency = parseFloat(net_amount) / parseFloat(transaction_rate);
            var tr_currency = transaction_currency.toFixed(2);
            $('#transaction_currency').val(tr_currency);
            $('#transaction_rate_value').html(tr_currency);
            var old_rate = $('#old_hidden').val();
            if (old_rate) {
                var po_amount = $('#old_hidden').val() * net_amount;
                var po = parseFloat(po_amount).toFixed(2);
                var tr = parseFloat(transaction_currency).toFixed(2);
                var gain_or_loss = parseFloat(po) - parseFloat(tr);
                var gain_loss = gain_or_loss.toFixed(2);
                $('.transaction_gain').html(gain_loss);
                $('#transaction_gain1').val(gain_loss);
            }
        }
    });
    $('body').on('click', '#Due_date', function () {
        var bill_date = $('.bill_date').val();
        $('.datepickerduedate').datepicker({
            dateFormat: 'yy-mm-dd',
            minDate: new Date(bill_date)
        });
    });
    $('body').on('click', '#search_do_keyword', function () {
        var search_do_keywords = $('#search_do_keywords').val();
        var from_date_list = $('.from_date_list').val();
        var to_date_list = $('.to_date_list').val();
        var created_by_p = $('#created_by_p').val();
        if (search_do_keywords == '' && from_date_list == '' && to_date_list == '' && created_by_p == '') {
            swal("Please check any filter");
            $('#search_so_keywords').css('border', '1px solid red');
        } else if (from_date_list == '' && search_do_keywords == '' && created_by_p == '')
        {
            swal("Please select from date");
        } else if (to_date_list == '' && search_do_keywords == '' && created_by_p == '')
        {
            swal("Please select to date");
        } else {
            $('#filtersubmit').submit();
        }
    });
    $('body').on('click', '.pagesubmit', function (e) {
        e.preventDefault();
        var from_date_list = $('#from_date_list').val();
        var to_date_list = $('#to_date_list').val();
        var search_do_keywords = $('#search_do_keywords').val();
        var created_by_p = $('#created_by_p').val();
        var filter_supplier = $('#filter_supplier').val();
        $('#frmdate').val(from_date_list);
        $('#todate').val(to_date_list);
        $('#keywd').val(search_do_keywords);
        $('#cr_by').val(created_by_p);
        $('#supplier_filter_id').val(filter_supplier);
        var url = $(this).attr('href');
        $('#paginationfilter').attr('action', url);
        $('#paginationfilter').submit();
    });
    $('body').on('change', '#sale_type', function ()
    {
        var mode = $('#sale_type').val();
        if (mode == 'Cheque') {
            $('#deposit_to').prop('disabled', false);
            $('.depositto').show();
            $('#jquery_mask').show();
            $.post(siteurl + "/Inventory/Inventory_transaction/get_details_payment", {selected: mode}, function (data) {
                $('#jquery_mask').hide();
                var json_array = JSON.parse(data);
                var html_data = '';
                html_data += '<option value="">select</option>';
                for (var i = 0; i < json_array[0].length; i++)
                {
                    html_data += '<option value="' + json_array[0][i]['account_id'] + '">' + json_array[0][i]['account_name'] + '</option>';
                }
                console.log(data);
                $('#deposit_to').html(html_data);
            });
            $('#chequepanel').show();
            $('#card_or_bank').hide();
            $('#amt_received').attr('readonly', true);
        } else if (mode == 'Cash') {
            $('#chequepanel').hide();
            $('.depositto').show();
            $('#deposit_to').prop('disabled', false);
            $('#jquery_mask').show();
            $.post(siteurl + "/Accounts/Transaction/get_details_payment", {selected: mode}, function (data) {
                $('#jquery_mask').hide();
                var json_array = JSON.parse(data);
                var html_data = '';
                html_data += '<option value="">select</option>';
                for (var i = 0; i < json_array[0].length; i++)
                {
                    html_data += '<option value="' + json_array[0][i]['account_id'] + '">' + json_array[0][i]['account_name'] + '</option>';
                }
                $('#deposit_to').html(html_data);
                $('#card_or_bank').hide();
            });
        } else if (mode == 'Card') {
            $('#chequepanel').hide();
            $('.depositto').show();
            mode = 'Bank';
            $('#deposit_to').prop('disabled', false);
            $('#jquery_mask').show();
            $.post(siteurl + "/Accounts/Transaction/get_details_payment", {selected: mode}, function (data) {
                $('#jquery_mask').hide();
                var json_array = JSON.parse(data);
                var html_data = '';
                html_data += '<option value="">select</option>';
                for (var i = 0; i < json_array[0].length; i++)
                {
                    html_data += '<option  value="' + json_array[0][i]['account_id'] + '">' + json_array[0][i]['account_name'] + '</option>';
                }
                $('#deposit_to').html(html_data);
                $('#card_or_bank').show();
            });
        } else if (mode == 'Credit') {
//            $('.deposit_to').attr('disabled');
//            $("#deposit_to").attr("disabled",true);
            $('#deposit_to').val('');
            $('#deposit_to').prop('disabled', true);
            $('#deposit_to').prop('readonly', true);
        }
    });
    $('#record_cheque_bill').on('submit', function (e) {
        var cheque_no = $('#cheque_no').val();
        var deposit_to = $('#deposit_to').val();
        var account_no = $('#account_no').val();
        var cheque_date = $('#cheque_date').val();
        var cheque_amount = $('#cheque_amount').val();
        var hidden_cheque_amount = $('#hidden_cheque_amount').val();
        if (Number(hidden_cheque_amount) < Number(cheque_amount)) {
            e.preventDefault();
            swal('Alert', 'Amount is greater than actual amount', 'error');
        } else if (cheque_amount == "0") {
            e.preventDefault();
            swal('Alert', 'You are already paid', 'error');
        } else if (cheque_no == "" || deposit_to == "" || account_no == "" || cheque_date == "" || cheque_amount == "") {
            e.preventDefault();
            swal('Alert', 'Please Fill All the Fields', 'error');
        }
    });
    $('body').on('click', '.cheque_clearence', function (e) {
        var cheque_track_id = $(this).attr('cheque_track_id');
        swal({
            title: "Are You sure want to clear cheque",
            text: "Do you Want to Clear?",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes, Proceed !",
            cancelButtonText: "No, don't Proceed !",
            closeOnConfirm: false,
            closeOnCancel: true
        },
                function (isConfirm) {
                    if (isConfirm) {
                        $.post(siteurl + "/Accounts/Transaction/chequeclearence", {cheque_track_id: cheque_track_id}, function (data)
                        {
                            location.reload();
                        });
                    } else {
                        e.preventDefault();
                    }
                });
    });
    $('body').on('click', '.use_advance', function (e)
    {
        var adv_amount = $(this).attr('adv_amt');
        var adv_amount_id = $(this).val();
        var payment_made = $('#cheque_amount').val();
        var use_value_hidden = $('#use_value_hidden').val();
        var use_id_hidden = $('#use_id_hidden').val();
        var amount = 0;
        if (payment_made > 0) {
            if (Number(adv_amount) >= Number(payment_made)) {
                var use_amount = parseFloat(adv_amount) - parseFloat(payment_made);
                $(this).closest('tr').find('.use_val').html(use_amount);
                $('#cheque_amount').val(0);
                $('#hidden_cheque_amount').val(0);
                amount = payment_made;
            } else {
                var new_payment_made = parseFloat(payment_made) - parseFloat(adv_amount);
                $(this).closest('tr').find('.use_val').html(0);
                $('#cheque_amount').val(new_payment_made);
                $('#hidden_cheque_amount').val(new_payment_made);
                amount = adv_amount;
            }
            $(this).hide();
            $(this).closest('tr').find('.revert_advance').show();
            if (use_value_hidden != "" && use_id_hidden != "") {
                var value = use_value_hidden + ',' + amount;
                var id = use_id_hidden + ',' + adv_amount_id;
                $('#use_value_hidden').val(value);
                $('#use_id_hidden').val(id);
            } else {
                $('#use_value_hidden').val(amount);
                $('#use_id_hidden').val(adv_amount_id);
            }

        }
    });
    $('body').on('click', '.revert_advance', function (e)
    {
        var adv_amount = $(this).attr('adv_amt');
        var adv_amount_id = $(this).val();
        var payment_made = $('#cheque_amount').val();
        var use_value_hidden = $('#use_value_hidden').val();
        var use_id_hidden = $('#use_id_hidden').val();
        var amount = 0;
//        if (payment_made > 0) {
        if (Number(adv_amount) >= Number(payment_made)) {
            var new1 = $(this).closest('tr').find('.use_val').html();
            var use_amount = parseFloat(adv_amount) - parseFloat(new1);
            var new_payment_made = parseFloat(payment_made) + parseFloat(use_amount);
            $(this).closest('tr').find('.use_val').html(adv_amount);
            $('#cheque_amount').val(new_payment_made);
            $('#hidden_cheque_amount').val(new_payment_made);
            amount = use_amount;
        } else {
            if (payment_made > 0) {
                var new1 = $(this).closest('tr').find('.use_val').html();
                var use_amount = parseFloat(adv_amount) - parseFloat(new1);
                var new_payment_made = parseFloat(payment_made) + parseFloat(use_amount);
                $(this).closest('tr').find('.use_val').html(adv_amount);
                $('#cheque_amount').val(new_payment_made);
                $('#hidden_cheque_amount').val(new_payment_made);
                amount = new_payment_made;
            }
        }

        $(this).hide();
        $(this).closest('tr').find('.use_advance').show();
        var values1 = use_value_hidden.split(',');
        for (var i = 0; i < values1.length; i++) {
            if (values1[i] == amount) {
                values1.splice(i, 1);
                values1.join(',');
            }
        }

        var id1 = use_id_hidden.split(',');
        for (var i = 0; i < id1.length; i++) {
            if (id1[i] == adv_amount_id) {
                id1.splice(i, 1);
                id1.join(',');
            }
        }
        $('#use_value_hidden').val(values1);
        $('#use_id_hidden').val(id1);
    });
    $('.charge_paid_by').on('click', function () {
        var radioValue = $(".charge_paid_by:checked").val();
        var bill_type = $(".charge_bill_type:checked").val();
//        if(bill_type == 'actual'){
//            if(radioValue == 'company'){
//                $('#pay_mode').show();
//                $('#paid_thrgh').show();
//            }else if(radioValue == 'vendor'){
//                $('#pay_mode').hide();
//                $('#paid_thrgh').hide();
//            }
//        }else{
//            $('#pay_mode').hide();
//            $('#paid_thrgh').hide();
//        }
        if (radioValue == 'vendor') {
            $('.charge_bill_type[value="actual"]').prop('checked', true);
            $('.charge_bill_type[value="actual"]').trigger('click');
            $('.charge_bill_type').prop('disabled', true);
            $('#pay_mode').hide();
            $('#paid_thrgh').hide();
            $('#vendor_chose').hide();
            $('#trans_cur').hide();
            $('#div_currencyrates').hide();
        } else {
            $('#vendor_chose').show();
            $('.charge_bill_type').prop('disabled', false);
            if (bill_type == 'actual') {
                $('#trans_cur').show();
                $('#div_currencyrates').show();
                $('#pay_mode').show();
                $('#paid_thrgh').show();
            } else {
                $('#pay_mode').hide();
                $('#paid_thrgh').hide();
            }
        }
    });
    $('body').on('change', '#oc_pay_type', function ()
    {
        var mode = $('#oc_pay_type').val();
        if (mode == 'Cash') {
            $('#paid_thrgh').show();
//            $('#v endor_chose').hide();
            $('#chequepanel').hide();
            $('#depositto').show();
            $('#jquery_mask').show();
            $.post(siteurl + "/Accounts/Transaction/get_details_payment", {selected: mode}, function (data) {
                $('#jquery_mask').hide();
                var json_array = JSON.parse(data);
                var html_data = '';
                html_data += '<option value="">select</option>';
                for (var i = 0; i < json_array[0].length; i++)
                {
                    html_data += '<option value="' + json_array[0][i]['account_id'] + '">' + json_array[0][i]['account_name'] + '</option>';
                }
                $('#oc_paid_through').html(html_data);
            });
        } else if (mode == 'Card') {
            $('#paid_thrgh').show();
//            $('#vendor_chose').hide();
            $('#chequepanel').hide();
            $('#depositto').show();
            mode = 'Bank';
            $('#jquery_mask').show();
            $.post(siteurl + "/Accounts/Transaction/get_details_payment", {selected: mode}, function (data) {
                $('#jquery_mask').hide();
                var json_array = JSON.parse(data);
                var html_data = '';
                html_data += '<option value="">select</option>';
                for (var i = 0; i < json_array[0].length; i++)
                {
                    html_data += '<option  value="' + json_array[0][i]['account_id'] + '">' + json_array[0][i]['account_name'] + '</option>';
                }
                $('#oc_paid_through').html(html_data);
            });
        } else if (mode == 'Credit') {
            $('#paid_thrgh').hide();
            $('#vendor_chose').show();
        }
    });
    $('body').on('click', '#charge_vendor', function ()
    {
        var pagecheck = "pagejs";
        $('#jquery_mask').show();
        $.post(siteurl + "/Inventory/Purchase/search_vendor/" + pagecheck, {pagecheck: pagecheck}
        , function (data) {
            $('#jquery_mask').hide();
            $('#search_vendor_result').html(data);
        });
    });
    $('body').on('keyup', '#search_vendor_keyword', function () {
        var keyword = $('#search_vendor_keyword').val();
        $('#jquery_mask').show();
        $.post(siteurl + "/Inventory/Purchase/search_vendor", {keyword: keyword}
        , function (data) {
            $('#jquery_mask').hide();
            $('#search_vendor_result').html(data);
        });
    });
    $('body').on('change', '#gvendor', function ()
    {
        var vendor_name = $(this).data('cmpny_name');
        var com_hid_id = $(this).attr('com_hid_id');
        $('#charge_vendor_company').val(com_hid_id);
        var com_hid_name = $(this).attr('com_hid_name');
        if (com_hid_id) {
            $('#charge_vendor').val(com_hid_name);
        } else {
            $('#charge_vendor').val(vendor_name);
        }
        var val = $(this).val();
        $('#charge_vendor_id').val(val);
        $('#VendorModal').modal('hide');
    });
    $('body').on('change', '.inv_date', function ()
    {
        var inv_date = $(this).val();
        var monthendbase = $('#monthendbase').val();
        var count_days = $('#days').val();
        if (count_days == 0) {
            var start_datee = inv_date;
        } else {
            if (monthendbase == 0) {
                var someDate = new Date(inv_date);
                var numberOfDaysToAdd = Number(count_days);
                someDate.setDate(someDate.getDate() + numberOfDaysToAdd);
                var dd = someDate.getDate();
                var mm = someDate.getMonth() + 1;
                var y = someDate.getFullYear();
                if (dd < 10) {
                    dd = '0' + dd
                }

                if (mm < 10) {
                    mm = '0' + mm
                }

                var start_datee = y + '-' + mm + '-' + dd;
            } else if (monthendbase == 1) {
                var date = new Date(inv_date);
                var firstDay = new Date(date.getFullYear(), date.getMonth(), 1);
                var lastDay = new Date(date.getFullYear(), date.getMonth() + 1, 0);
                var last_Day = lastDay.getFullYear() + '-' + (lastDay.getMonth() + 1) + '-' + (lastDay.getDate());
                var someDate = new Date(last_Day);
                var numberOfDaysToAdd = Number(count_days);
                someDate.setDate(someDate.getDate() + numberOfDaysToAdd);
                var dd = someDate.getDate();
                var mm = someDate.getMonth() + 1;
                var y = someDate.getFullYear();
                if (dd < 10) {
                    dd = '0' + dd
                }

                if (mm < 10) {
                    mm = '0' + mm
                }

                var start_datee = y + '-' + mm + '-' + dd;
            }
        }


        $('#Due_date').val(start_datee);
    });
    $('body').on('change', '#bill_date', function (e) {
        var prev_date = $('#bill_date').val();
        $('.datepickerduedate').datepicker('destroy');
        $('.datepickerduedate').datepicker({
            dateFormat: 'yy-mm-dd',
            minDate: new Date(prev_date)
        });
        $('.datepickerinv').datepicker('destroy');
        $('.datepickerinv').datepicker({
            dateFormat: 'yy-mm-dd',
            maxDate: new Date(prev_date)
        });
        var current_date_input = $('.datepickerduedate').val();
        var changed_date = new Date(prev_date)
        var current_date = new Date(current_date_input);
        if (changed_date > current_date) {
            $('.datepickerduedate').val(prev_date);
        }
        var monthendbase = $('#monthendbase').val();
        var count_days = $('#days').val();
        var inv_date = $('.inv_date').val();
        if (inv_date = "") {
            if (monthendbase == 0) {
                var someDate = new Date(prev_date);
                var numberOfDaysToAdd = Number(count_days);
                someDate.setDate(someDate.getDate() + numberOfDaysToAdd);
                var dd = someDate.getDate();
                var mm = someDate.getMonth() + 1;
                var y = someDate.getFullYear();
                if (dd < 10) {
                    dd = '0' + dd
                }

                if (mm < 10) {
                    mm = '0' + mm
                }

                var start_datee = y + '-' + mm + '-' + dd;
            } else if (monthendbase == 1) {
                var date = new Date(prev_date);
                var firstDay = new Date(date.getFullYear(), date.getMonth(), 1);
                var lastDay = new Date(date.getFullYear(), date.getMonth() + 1, 0);
                var last_Day = lastDay.getFullYear() + '-' + (lastDay.getMonth() + 1) + '-' + (lastDay.getDate());
                var someDate = new Date(last_Day);
                var numberOfDaysToAdd = Number(count_days);
                someDate.setDate(someDate.getDate() + numberOfDaysToAdd);
                var dd = someDate.getDate();
                var mm = someDate.getMonth() + 1;
                var y = someDate.getFullYear();
                if (dd < 10) {
                    dd = '0' + dd
                }

                if (mm < 10) {
                    mm = '0' + mm
                }

                var start_datee = y + '-' + mm + '-' + dd;
            }
            $('.datepickerduedate').val(start_datee);
        }
    });
    $('body').on('click', '#trans_currency_id', function () {
        var currency_id = $(this).val();
        $.post(siteurl + "/Inventory/Bill/fetch_currency_rate_by_latest", {currency_id: currency_id}, function (data) {
            var result = JSON.parse(data);
            if (typeof result.rate === 'undefined' || result.rate == '') {
                result.rate = 1;
            }
            $('#trans_currency_rate').val(result.rate);
            $('.trans_cur_rate_id').val(result.cur_trans_rate_id);
        });
    });
///////////////////////////////////////////////////*****************************************************/////////////////////////////////////////////////////**************    
    //for direct bill
    $('body').on('click', '#getvendor', function () {
        $('#VendorModal #call_from').val($(this).attr('from'));
    });
    $('body').on('click', '#getvendor', function ()
    {
        var pagecheck = "pagejs";
        var abc=$(this).attr('noninv');
        $('#page_check_vendor').val(abc);
        $('#jquery_mask').show();
        $.post(siteurl + "/Inventory/Purchase/search_vendor/" + pagecheck, {pagecheck: pagecheck}
        , function (data) {
            console.log(data);
            $('#jquery_mask').hide();
            $('#search_vendor_result').html(data);
        });
    });
    $('body').on('change', '#gvendor', function ()
    {
        var vendor_from = $('#call_from').val();
        var page_check_vendor = $('#page_check_vendor').val();
       if(page_check_vendor == '1') {
            var vendor_name = $(this).data('cmpny_name');
            var com_hid_id = $(this).attr('com_hid_id');
            $('#hid_com_id').val(com_hid_id);
            var com_hid_name = $(this).attr('com_hid_name');
            if (com_hid_id) {
                $('#noninventoryModal #getvendor').val(com_hid_name);
            } else {
                $('#noninventoryModal #getvendor').val(vendor_name);
            }
            var val = $(this).val();
            $('#noninventoryModal #getvendor_id').val(val);
            $('#noninventoryModal #getnewvendor_id').val(val);
            $('#VendorModal').modal('hide');
        }else{
             var vendor_name = $(this).data('cmpny_name');
            var com_hid_id = $(this).attr('com_hid_id');
            $('#hid_com_id').val(com_hid_id);
            var com_hid_name = $(this).attr('com_hid_name');
            if (com_hid_id) {
                $('#getvendor').val(com_hid_name);
            } else {
                $('#getvendor').val(vendor_name);
            }
            var val = $(this).val();
            $('#getvendor_id').val(val);
            $('#getnewvendor_id').val(val);
            $('#VendorModal').modal('hide');
        }
    });
      $('body').on('click', '#view_history', function () {
        var iditem = $(this).attr('iditem');
        var check = $(this).attr('check');
        $('.history_table_details').html();
        var option = '';
        if (iditem != '') {
            $.post(siteurl + "/Inventory/Item/item_history_by_id/", {iditem: iditem}, function (data) {
                var json_array = JSON.parse(data);
                console.log(json_array.length);
                option += '<thead>';
                option += '<th>PO NUMBER</th>';
                option += '<th>MRV NUMBER</th>';
                option += '<th>BILL NUMBER</th>';
                option += '<th>MRV DATE</th>';
                option += '<th>COST OF ITEM</th>';
                option += '</thead><tbody>';
                for (var i = 0; i < json_array.length; i++) {
                    if (json_array[i].po_number == null) {
                        json_array[i].po_number = '';
                    }
                    if (json_array[i].mrv_number == null) {
                        json_array[i].mrv_number = '';
                    }
                    if (json_array[i].bill_no == null) {
                        json_array[i].bill_no = '';
                    }
                    if (json_array[i].mrv_date == null) {
                        json_array[i].mrv_date = '';
                    }
                    if (json_array[i].cost_of_item == null) {
                        json_array[i].cost_of_item = '';
                    }
                    option += '<tr>';
                    option += '<td>' + json_array[i].po_number + '</td>';
                    option += '<td>' + json_array[i].mrv_number + '</td>';
                    option += '<td>' + json_array[i].bill_no + '</td>';
                    option += '<td>' + json_array[i].mrv_date + '</td>';
                    option += '<td>' + json_array[i].cost_of_item + '</td>';
                    option += '</tr>';
                }
                option += '</tbody>';
                $('.history_table_details').html(option);
            });
        } else {
            option += '<thead>';
            option += '<th>PO NUMBER</th>';
            option += '<th>MRV NUMBER</th>';
            option += '<th>BILL NUMBER</th>';
            option += '<th>MRV DATE</th>';
            option += '<th>COST OF ITEM</th>';
            option += '</thead>';
            $('.history_table_details').html(option);
        }
    });
     $("#nonpro_costprice,#nonpro_markup").keyup(function () {

        if ($('#nonpro_markup').val() != "0")
        {
            $('#nonpro_sellingprice').attr('readonly', true);
            var percentage = (parseFloat(($('#nonpro_costprice').val()) * parseFloat($('#nonpro_markup').val())) / 100);
            $('#nonpro_sellingprice').val(parseFloat(percentage) + parseFloat($('#nonpro_costprice').val()));
        } else if ($('#nonpro_markup').val() == "0")
        {
            var costprice = $('#nonpro_costprice').val();
            $('#nonpro_sellingprice').val(costprice);
            $('#nonpro_sellingprice').attr('readonly', false);
        }
    });
       $('body').on('click', '#btn_addnoninventory', function () {
        var trid = $('#trid').val();
        var nonpro_name = $('#nonpro_name').val();
        var nonpro_sku = $('#nonpro_sku').val();
        var nonpro_vendor = $('#getnewvendor_id').val();
        var nonpro_unit = $('#nonpro_unit').val();
        var unit_code = $('#nonpro_unit option:selected').attr('unit_code');
        var quantity = $('#nonpro_qty').val();
        var nonpro_costprice = $('#nonpro_costprice').val();
        var rate_currency = $('#currency_rate').val();
        var pr_rate_with_currency = parseFloat(rate_currency) * parseFloat(nonpro_costprice);
        var nonpro_markup = $('#nonpro_markup').val();
        var nonpro_sellingprice = $('#nonpro_sellingprice').val();
        var barc_non_inv = $('#barc_non_inv').val();
        var common_barcode_sgc = $('#common_barcode').val();
        var common_barcode_vpc = $('#common_barcode_div').val();
        //anjup for tax-------------->
        var tax_enabled = $('#tax_enabled').val();
        var interstate_tax = -1;
        var intrastate_tax = -1;
        var export_tax = -1;
        var tax_type = 'inclusive';
        if (tax_enabled != -1) {
            interstate_tax = $('#interstate_tax').val();
            intrastate_tax = $('#intrastate_tax').val();
            export_tax = $('#export_tax').val();
            tax_type = $('#noninventoryModal .tax_typein:checked').val();
            var maintax_type = $('.tax_type:checked').val();
        }
//END<------------------------
        if (nonpro_name == "" ) {
            swal("Enter all details");
        } else {
            if (barc_non_inv == 'vpc') {
                $('#jquery_mask').show();
                $.post(siteurl + "/Inventory/Item/check_barcode_for_vpc", {common_barcode: common_barcode_vpc}, function (result) {
                    $('#jquery_mask').hide();
//                    $('#jquery_mask').show();
                    if (result == 1) {
                        swal("This Barcode already exist please change");
                    } else {
                        $('#jquery_mask').show();
                        $.post(siteurl + "/Inventory/Purchase/insert_noninventory", {nonpro_name: nonpro_name, nonpro_sku: nonpro_sku, nonpro_vendor: nonpro_vendor, nonpro_unit: nonpro_unit, nonpro_costprice: nonpro_costprice, nonpro_markup: nonpro_markup, nonpro_sellingprice: nonpro_sellingprice, non_quantity: quantity, tax_enabled: tax_enabled, interstate_tax: interstate_tax, intrastate_tax: intrastate_tax, export_tax: export_tax, tax_type: tax_type, bar_type: barc_non_inv, common_barcode: common_barcode_vpc}, function (result)
                        {
                            $('#jquery_mask').hide();
                            result = result.trim();
                            var sid = $('#noninventoryModal #trid').val();
                            var sll = $('[id-cl=' + sid + ']');
                            var ff = sll.find('.pdt_title');
                            ff.text(nonpro_name);
                            var itm_code = sll.find('.pdt_sku');
                            itm_code.text(nonpro_sku);
//                var itm_code = sll.find('.pdt_sku');  //for po edit
//                itm_code.val(nonpro_sku);
                            var ii = sll.find('.pdt_id');
                            ii.val(result);
                            var ii = sll.find('.itemtaxtype_hidden');
                            ii.val(tax_type);
                            var qq = sll.find('.quan'); //for purchase order
                            qq.val(quantity);
                            var pp = sll.find('.pro_rate'); //for quote
                            pp.val(nonpro_costprice);
                            var uu = sll.find('.pdt_unit'); //for quote
                            uu.text(unit_code);
//                var pu = sll.find('.pdt_unit'); //for PO EDIT
//                pu.val(unit_code);
//                var item_unit_pr = sll.find('.item_unit'); //for PR
//                item_unit_pr.html(unit_code);
//                var item_quuantity = sll.find('.quantity'); //for PR
//                item_quuantity.val(quantity);
//                var type = sll.find('.pdt_type'); //for quote
//                type.val('non-inventory');
//                var ss = sll.find('.selling_p'); //for quote
//                ss.val(nonpro_sellingprice);
//                var sp = sll.find('.s_p'); //for quote
//                sp.val('');
//                var am = sll.find('.amount'); //for quote
//                am.val('');
                            var amt_with_qty = parseFloat(pr_rate_with_currency) * parseFloat(quantity);
                            var pro_am = sll.find('.pro_amount'); //for quote
                            pro_am.val(amt_with_qty);
                            var dis = sll.find('.dis'); //for quote
                            dis.val(0);
                            var ent_dis = sll.find('.enterd_dis_amount'); //for quote
                            ent_dis.val(0);
                            var dd = sll.find('#item_id');
                            dd.val(result).change();
                            var total_pdt = 0;
                            $('body').find('.pro_amount').each(function () {
                                if ($(this).val() != '')
                                {
                                    total_pdt += parseFloat($(this).val());
                                }
                            });
                            //anjup for tax-------------->
                            if (tax_enabled != -1) {
                                bind_taxrate(sll, result);
                            }
                            //END<------------------------
                            $('#pro_total').val(parseFloat(total_pdt).toFixed(2));
                            $('#hidden_pro_total').val(parseFloat(total_pdt));
                            var total_with_currency = (parseFloat(total_pdt) / parseFloat(rate_currency));
                            $('#final_curency_amount').val(parseFloat(total_with_currency).toFixed(2));
                            $('#noninventoryModal').modal('hide');
                            calculate_row_amount(sll);
                            product_subtotal_calculation()
                            final_calculation();
                        });
                    }
                });
            } else {
                $('#jquery_mask').show();
                $.post(siteurl + "/Inventory/Purchase/insert_noninventory", {nonpro_name: nonpro_name, nonpro_sku: nonpro_sku, nonpro_vendor: nonpro_vendor, nonpro_unit: nonpro_unit, nonpro_costprice: nonpro_costprice, nonpro_markup: nonpro_markup, nonpro_sellingprice: nonpro_sellingprice, non_quantity: quantity, tax_enabled: tax_enabled, interstate_tax: interstate_tax, intrastate_tax: intrastate_tax, export_tax: export_tax, tax_type: tax_type, bar_type: barc_non_inv, common_barcode: common_barcode_sgc}, function (result)
                {
                    $('#jquery_mask').hide();
                    result = result.trim();
                    var sid = $('#noninventoryModal #trid').val();
                    var sll = $('[id-cl=' + sid + ']');
                    var ff = sll.find('.pdt_title');
                    ff.text(nonpro_name);
                    var itm_code = sll.find('.pdt_sku');
                    itm_code.text(nonpro_sku);
                    var ii = sll.find('.pdt_id');
                    ii.val(result);
                    var ii = sll.find('.itemtaxtype_hidden');
                    ii.val(tax_type);
                    var qq = sll.find('.quan'); //for purchase order
                    qq.val(quantity);
                    var pp = sll.find('.pro_rate'); //for quote
                    pp.val(nonpro_costprice);
                    var uu = sll.find('.pdt_unit'); //for quote
                    uu.text(unit_code);
                    var amt_with_qty = parseFloat(pr_rate_with_currency) * parseFloat(quantity);
                    var pro_am = sll.find('.pro_amount'); //for quote
                    pro_am.val(amt_with_qty);
                    var dis = sll.find('.dis'); //for quote
                    dis.val(0);
                    var ent_dis = sll.find('.enterd_dis_amount'); //for quote
                    ent_dis.val(0);
                    var dd = sll.find('#item_id');
                    dd.val(result).change();
                    var total_pdt = 0;
                    $('body').find('.pro_amount').each(function () {
                        if ($(this).val() != '')
                        {
                            total_pdt += parseFloat($(this).val());
                        }
                    });
                    //anjup for tax-------------->
                    if (tax_enabled != -1) {
                        bind_taxrate(sll, result);
                    }
                    //END<------------------------
                    $('#pro_total').val(parseFloat(total_pdt).toFixed(2));
                    $('#hidden_pro_total').val(parseFloat(total_pdt));
                    var total_with_currency = (parseFloat(total_pdt) / parseFloat(rate_currency));
                    $('#final_curency_amount').val(parseFloat(total_with_currency).toFixed(2));
                    $('#noninventoryModal').modal('hide');
                    calculate_row_amount(sll);
                    product_subtotal_calculation()
                    final_calculation();
                });
            }
        }
    });
    $('body').on('click', '.selitem', function () {
        $('#nonpro_name').val('');
        $('#noninventoryModal .getvendor').val('');
        $('#nonpro_unit').val('0');
        $('#nonpro_qty').val('0');
        $('#nonpro_costprice').val('0');
        $('#nonpro_sellingprice').val('0');
        $('#nonpro_markup').val('0');
        $('#nonpro_sku').val('');
        $('#common_barcode').val('');
        $('#common_barcode_div').val('');
        $('#barc_non_inv').val('sgu');
        $('.common_barcode_div').addClass('no-display');
        $('.common_barcode_div_vpc').addClass('no-display');
        var selid = $(this).closest('tr').attr('id-cl');
        var pp = $(this).closest('tr');
//        pp.find('#pro_amount').val('0');
        var option = '';
        var count = 1;
        var new_array = [];
        console.log(item_json);
        if (item_json == null || item_json == 'undefined') {

        } else {

            for (var i = 0; i < item_json.length; i++) {
                if (item_json[i]['item_type'] == 'inventory' || item_json[i]['item_type'] == 'inventory_and_service' || item_json[i]['item_type'] == 'non-inventory') {
                    new_array.push(item_json[i]);
                }
            }
            var length1 = 10;
            if (new_array.length < 10) {
                length1 = new_array.length;
            }
            var sku = '';
            var puprice = '';
            var sellingprice = '';
            for (var i = 0; i < length1; i++) {
                if (new_array[i]['sku'] == null) {
                    sku = '';
                } else {
                    sku = new_array[i]['sku']
                }
                if (new_array[i]['sellingprice'] == null) {
                    sellingprice = '';
                } else {
                    sellingprice = parseFloat(new_array[i]['sellingprice']).toFixed(2);
                }
                option += '<tr class="sec_grid_tbl">'
                //option += '<td class="pa-5 vat">' + count + '</td> '
                option += '<td class="w15 pa-5">' + sku + '</td>'
//                option += '<td class="pa-5 vat">' + new_array[i]['name'] + '</td>'
                if (new_array[i]['item_type'] == 'non-inventory') {
                    option += '<td class="w55 pa-5">' + new_array[i]['name'] + '</td>'
                } else {
                    option += '<td class="w60 pa-5"><a href="" id="itm_id" class="closeopenmodal-sidebar itm_id" item_name="' + new_array[i]['name'] + '" item_id="' + new_array[i]['item_id'] + '">' + new_array[i]['name'] + '</a></td>'
                }
                option += '<td class="w10 pa-5 text-center">'
                if (item_json[i]['item_type'] == 'inventory_and_service') {
                    option += '<span data-tooltip="Inventoy & Services"><i class="icon lindo-023-worldwide fz-20 txt-dgray"></i></span>';
                } else if (item_json[i]['item_type'] == 'inventory') {
                    option += '<span data-tooltip="Inventory"><i class="icon lindo-shopping-cart-content fz-20 txt-dgray"></i></span>';
                } else {
                    option += '<span data-tooltip="Non-Inventory"><i class="icon lindo-shopping-bag-1 fz-20 txt-dgray"></i></span>';
                }
                option += '</td>'
                option += '<td class="w10 pa-5">' + sellingprice + '</td>'
                if (new_array[i]['item_type'] == 'non-inventory') {
                    option += '<td class="w5 pa-5"></td>'
                } else {
                    option += '<td class="w5 pa-5 text-center"><a id="itm_id" class="btn btn-default btn-outline btn-flat closeopenmodal-sidebar itm_id" item_name="' + new_array[i]['name'] + '" item_id="' + new_array[i]['item_id'] + '" data-tooltip="Stock Details"><i class="icon lindo-information-white fz-18"></i></a></td>'
                }
                option += '<td class="w5 pa-5">'
                option += '<label style="display:none;" id="pdt_ser_name' + new_array[i]['item_id'] + '">' + new_array[i]['name'] + '</label>'
                option += '<input type="hidden" id="pdt_ser_id' + new_array[i]['item_id'] + '" value="' + new_array[i]['item_id'] + '">'
                option += '<input type="hidden" id="pdt_ser_sku' + new_array[i]['item_id'] + '" value="' + new_array[i]['sku'] + '">'
                option += '<input type="hidden" id="pdt_ser_sell_price' + new_array[i]['item_id'] + '" value="' + new_array[i]['sellingprice'] + '">'
                option += '<input type="hidden" id="pdt_ser_pur_price' + new_array[i]['item_id'] + '" value="' + new_array[i]['purchase_price'] + '">'
                option += '<input type="hidden" id="pdt_ser_unit' + new_array[i]['item_id'] + '" value="' + new_array[i]['unit_code'] + '">'
                option += '<input type="hidden" id="pdt_ser_type' + new_array[i]['item_id'] + '" value="' + new_array[i]['item_type'] + '">'
                option += '<input type="hidden" id="tot_qty' + new_array[i]['item_id'] + '" value="' + new_array[i]['total_quantity'] + '">'
                //         <-----anju for tax------>
                option += '<input type="hidden" id="interstate_tax' + new_array[i]['item_id'] + '" value="' + new_array[i]['interstate_taxid'] + '">'
                option += '<input type="hidden" id="intrastate_tax' + new_array[i]['item_id'] + '" value="' + new_array[i]['intrastate_taxid'] + '">'
                option += '<input type="hidden" id="export_tax' + new_array[i]['item_id'] + '" value="' + new_array[i]['export_taxid'] + '">'
                option += '<input type="hidden" id="service_tax' + new_array[i]['item_id'] + '" value="' + new_array[i]['service_taxid'] + '">'
                option += '<input type="hidden" id="item_taxtype' + new_array[i]['item_id'] + '" value="' + new_array[i]['tax_type'] + '">'

                option += '<input type="hidden" id="enable_tracking' + new_array[i]['item_id'] + '" value="' + new_array[i]['enable_tracking'] + '">'
                option += '<input type="hidden" id="partial_selling' + new_array[i]['item_id'] + '" value="' + new_array[i]['partial_selling'] + '">'
                option += '<input type="hidden" id="total_quantity' + new_array[i]['item_id'] + '" value="' + new_array[i]['total_quantity'] + '">'
                option += '<input type="hidden" id="barcode_type' + new_array[i]['item_id'] + '" value="' + new_array[i]['barcode_type'] + '">'
                option += '<input type="hidden" id="barcode' + new_array[i]['item_id'] + '" value="' + new_array[i]['barcode'] + '">'
                //         <-----END------>
                option += '<button type="button" class="btn btn-default btn-outline btn-flat pickitem" data-toggle="tooltip" id="product_search" sl-cl="" sel-id="' + new_array[i]['item_id'] + '"  status="whole"  value="' + new_array[i]['item_id'] + '"><i class="icon lindo-tick fz-18"></i> </button>'
                option += '</td>'

                option += '</tr>';
                count++;
                if (new_array[i]['sellingprice'] == null) {
                    new_array[i]['sellingprice'] = '';
                }
                if (new_array[i]['sku'] == null) {
                    new_array[i]['sku'] = '';
                }
            }
            $('.itemsearch').html(option);
        }
        $("#productlist #trid").val(selid);
        $("#requsitionList #trid").val(selid);
        $("#noninventoryModal #trid").val(selid);
    });
    $('body').on('click', '.pickbarcode_mrv', function ()
    {

//        if ($(this).closest('tr').find('.checkbox_mrv #ck_select').is(":checked")) {
        $('#barcodeModal').modal('toggle');
//        } else {
//            swal({
//                title: "Please Select Item!!!",
//            });
//        }


        var product_id = $(this).closest('tr').find('.pdt_id').val();
        var common_barcode = $(this).closest('tr').find('.common_barcode').val();
        var barcode_type = $(this).closest('tr').find('.barcode_type').val();
        var cld = $(this).closest('tr').attr('id-cl');
        var barcodes = $(this).closest('tr').find('.hidden_mpn').val();
        console.log(barcodes);
        var storeids = $(this).closest('tr').find('.storeids').val();
        var patial_selling = $(this).closest('tr').find('.partial_selling').val();
        var remaining_qty = $(this).closest('tr').find('.remaining_qty').val();
        var json_store_id = $(this).closest('tr').find('.storeids').val();
        var tot_qty_modal = $(this).closest('tr').find('.qty_in_po').val();
        var hiddenqtys = $(this).closest('tr').find('.hiddenqty').val();
        $('#barcodeModal #cld_modal').val(cld);
        $('#barcodeModal #barcodetype_modal').val(barcode_type);
        $('#barcodeModal #remaining_qty_modal').val(remaining_qty);
        $('#barcodeModal #common_bcd_modal').val(common_barcode);
        $('#barcodeModal #tot_qty_modal').val(tot_qty_modal);
        $('#barcodeModal .hidden_barc_type').val(barcode_type);
        var msg = '';
        if (barcode_type == 'sgu') {
            msg = 'System Generated & Unique'
        }
        if (barcode_type == 'sgc') {
            msg = 'System Generated & Common'
        }
        if (barcode_type == 'vpu') {
            msg = 'Vendor Provided & Unique'
        }
        if (barcode_type == 'vpc') {
            msg = 'Vendor Provided & Common'
        }

//---------------barcode type label------------------------------------------------  
        var bc_type = barcode_type.toUpperCase();
        var opt = '<label class="fob"><strong> Barcode: </strong></label>  <label class="fob barcode_label">' + common_barcode + '</label>';
        $('#barcodeModal .barcode_type_label').html(bc_type);
        if (common_barcode != '') {
            $('#barcodeModal .barcode_label_div').html(opt);
        } else {
            $('#barcodeModal .barcode_label_div').html('');
        }
        $('.barcode_type_label').attr('data-tooltip', msg);
        //---------------------------------------------------------------------------------  


        if (barcode_type == "vpu" || barcode_type == "sgu") {
            var tr_bd = 1;
            $('#barcodeModal .barcode_enter').val('');
        } else {
            var tr_bd = 0;
            $('#barcodeModal .barcode_enter').val(common_barcode);
        }
        $('#barcodeModal .tracking_barcode').val(tr_bd);
        if (barcodes) {
            var disp = "";
            var barcodes_array = barcodes.split(',');
            var store = json_store_id.split(',');
            var hiddenqty = hiddenqtys.split(',');
            for (var i = 0; i < barcodes_array.length; i++) {
                disp += '<tr class="">'
                disp += '<td><input type="checkbox" class="barcode_check" checked></td>'
                disp += '<td class="notd "><input type="text" class="form-control mpn barcode_enter" autocomplete="off" required="" placeholder="Barcode" name="mpn[]" value="' + barcodes_array[i] + '"></td>'
                disp += '<td><input type="hidden" class="tracking_barcode" name="tracking_barcode[]" value="' + tr_bd + '"> <input type="hidden"  class = "hidden_barc_type" name = "hidden_barc_type[]" value = "' + barcode_type + '" ><select class="form-control store_list"  name="store_list[]">'

                for (var d = 0; d < stores.length; d++) {

                    disp += '<option ';
                    if (stores[d]['store_id'] == store[i]) {

                        disp += 'selected="selected"';
                    }
                    disp += 'value="' + stores[d]['store_id'] + '">' + stores[d]['store_name'] + '</option>';
                }
                disp += '</select></td>'
                disp += '<td><input type="text" class="form-control store_qty" name="store_qty[]" value="' + hiddenqty[i] + '"> </td>'
                disp += '</tr>'
            }
            $('.clone_tr').addClass('no-display');
            $('#barcodeModal .barcodedtls').html(disp);
            $('#barcodeModal .clone_tr').find('.barcode_enter').val('');
            $('#barcodeModal .clone_tr').find('.barcode_enter').removeClass('mpn');
            $('#barcodeModal .clone_tr').find('.tracking_barcode').val('');
            $('#barcodeModal .clone_tr').find('.hidden_barc_type').val('');
            $('#barcodeModal .clone_tr').find('.barcode_enter').removeAttr("style");
            $('table tr.new_clone').remove();
        } else {
            $('.clone_tr').removeClass('no-display');
            $('#barcodeModal .clone_tr').find('.barcode_enter').addClass('mpn');
            $('#barcodeModal .barcodedtls').html('');
            $('#barcodeModal .main').find('.store_list').val('');
            $('#barcodeModal .main').find('.mpn').removeAttr("style");
            $('table tr.new_clone').remove();
            $('table tr.new_clone').remove();
        }
        if (barcode_type == "vpu" || barcode_type == "sgu") {
            $('#barcodeModal .store_qty').addClass('no-display');
            $('#barcodeModal .notd').removeClass('no-display');
        } else {
            $('#barcodeModal .store_qty').removeClass('no-display');
            $('#barcodeModal .notd').addClass('no-display');
        }

    });
    $("body").on('keyup', '#product_name', function () {

        var searchkeyword = $(this).val();
        var option = '';
        var count = 1;
        var sku = '';
        var sellingprice = '';
        for (var i = 0; i < item_json.length; i++) {
            if (item_json[i]['item_type'] == 'inventory' || item_json[i]['item_type'] == 'inventory_and_service' || item_json[i]['item_type'] == 'non-inventory') {
                if (item_json[i]['name'].toLowerCase().indexOf(searchkeyword.toLowerCase()) != -1) {
                    if (item_json[i]['sku'] == null) {
                        sku = '';
                    } else {
                        sku = item_json[i]['sku']
                    }
                    if (item_json[i]['sellingprice'] == null) {
                        sellingprice = '';
                    } else {
                        sellingprice = item_json[i]['sellingprice']
                    }
                    option += '<tr class="sec_grid_tbl">'
                    //option += '<td class="pa-5 vat">' + count + '</td> '
                    option += '<td class="w15 pa-5">' + sku + '</td>'
//                    option += '<td class="pa-5 vat">' + item_json[i]['name'] + '</td>'
                    if (item_json[i]['item_type'] == 'non-inventory') {
                        option += '<td class="w60 pa-5">' + item_json[i]['name'] + '</td>'
                    } else {
                        option += '<td class="w60 pa-5"><a href="" id="itm_id" class="closeopenmodal-sidebar itm_id" item_name="' + item_json[i]['name'] + '" item_id="' + item_json[i]['item_id'] + '">' + item_json[i]['name'] + '</a></td>'

                    }
                    option += '<td class="w10 pa-5 text-center">'
                    if (item_json[i]['item_type'] == 'inventory_and_service') {
                        option += '<span data-tooltip="Inventoy & Services"><i class="icon lindo-023-worldwide fz-20 txt-dgray"></i></span>';
                    } else if (item_json[i]['item_type'] == 'inventory') {
                        option += '<span data-tooltip="Inventory"><i class="icon lindo-shopping-cart-content fz-20 txt-dgray"></i></span>';
                    } else {
                        option += '<span data-tooltip="Non-Inventory"><i class="icon lindo-shopping-bag-1 fz-20 txt-dgray"></i></span>';
                    }
                    option += '</td>'
                    option += '<td class="w10 pa-5">' + Number(sellingprice).toFixed(2) + '</td>'
                    if (item_json[i]['item_type'] == 'non-inventory') {
                        option += '<td class="w5 pa-5"></td>'
                    } else {
                        option += '<td class="w5 pa-5 text-center"><a id="itm_id" class="btn btn-default btn-outline btn-flat closeopenmodal-sidebar itm_id" item_name="' + item_json[i]['name'] + '" item_id="' + item_json[i]['item_id'] + '" data-tooltip="Stock Details"><i class="icon lindo-information-white fz-18"></i></a></td>'
                    }
                    option += '<td class="pa-5 vat">'
                    option += '<label style="display:none;" id="pdt_ser_name' + item_json[i]['item_id'] + '">' + item_json[i]['name'] + '</label>'
                    option += '<input type="hidden" id="pdt_ser_id' + item_json[i]['item_id'] + '" value="' + item_json[i]['item_id'] + '">'
                    option += '<input type="hidden" id="pdt_ser_sku' + item_json[i]['item_id'] + '" value="' + item_json[i]['sku'] + '">'
                    option += '<input type="hidden" id="pdt_ser_sell_price' + item_json[i]['item_id'] + '" value="' + item_json[i]['sellingprice'] + '">'
                    option += '<input type="hidden" id="pdt_ser_pur_price' + item_json[i]['item_id'] + '" value="' + item_json[i]['purchase_price'] + '">'
                    option += '<input type="hidden" id="pdt_ser_unit' + item_json[i]['item_id'] + '" value="' + item_json[i]['unit_code'] + '">'
                    option += '<input type="hidden" id="pdt_ser_type' + item_json[i]['item_id'] + '" value="' + item_json[i]['item_type'] + '">'
                    option += '<input type="hidden" id="tot_qty' + item_json[i]['item_id'] + '" value="' + item_json[i]['total_quantity'] + '">'
                    //         <-----anju for tax------>
                    option += '<input type="hidden" id="interstate_tax' + item_json[i]['item_id'] + '" value="' + item_json[i]['interstate_taxid'] + '">'
                    option += '<input type="hidden" id="intrastate_tax' + item_json[i]['item_id'] + '" value="' + item_json[i]['intrastate_taxid'] + '">'
                    option += '<input type="hidden" id="export_tax' + item_json[i]['item_id'] + '" value="' + item_json[i]['export_taxid'] + '">'
                    option += '<input type="hidden" id="service_tax' + item_json[i]['item_id'] + '" value="' + item_json[i]['service_taxid'] + '">'
                    option += '<input type="hidden" id="item_taxtype' + item_json[i]['item_id'] + '" value="' + item_json[i]['tax_type'] + '">'

                    option += '<input type="hidden" id="enable_tracking' + item_json[i]['item_id'] + '" value="' + item_json[i]['enable_tracking'] + '">'
                    option += '<input type="hidden" id="partial_selling' + item_json[i]['item_id'] + '" value="' + item_json[i]['partial_selling'] + '">'
                    option += '<input type="hidden" id="total_quantity' + item_json[i]['item_id'] + '" value="' + item_json[i]['total_quantity'] + '">'
                    option += '<input type="hidden" id="barcode_type' + item_json[i]['item_id'] + '" value="' + item_json[i]['barcode_type'] + '">'
                    option += '<input type="hidden" id="barcode' + item_json[i]['item_id'] + '" value="' + item_json[i]['barcode'] + '">'
                    //         <-----END------>
                    option += '<button type="button" class="btn btn-default btn-outline btn-flat pickitem" data-toggle="tooltip" id="product_search" sl-cl="" sel-id="' + item_json[i]['item_id'] + '"  status="whole"  value="' + item_json[i]['item_id'] + '"><i class="icon lindo-tick fz-18"></i> </button>'
                    option += '</td>'
                    option += '</tr>';
                    count++;
                } else if (item_json[i]['sku'] != null) {
                    if (item_json[i]['sku'].toLowerCase().indexOf(searchkeyword.toLowerCase()) != -1) {
                        if (item_json[i]['sku'] == null) {
                            sku = '';
                        } else {
                            sku = item_json[i]['sku']
                        }
                        if (item_json[i]['sellingprice'] == null) {
                            sellingprice = '';
                        } else {
                            sellingprice = item_json[i]['sellingprice']
                        }
                        option += '<tr class="sec_grid_sm">'
                        option += '<td class="pa-5 vat">' + count + '</td> '
                        option += '<td class="pa-5 vat">' + sku + '</td>'
//                        option += '<td class="pa-5 vat">' + item_json[i]['name'] + '</td>'
                        if (item_json[i]['item_type'] == 'non-inventory') {
                            option += '<td class="pa-5 vat">' + item_json[i]['name'] + '</td>'
                        } else {
                            option += '<td class="pa-5 vat"><a href="" id="itm_id" class="closeopenmodal-sidebar itm_id" item_name="' + item_json[i]['name'] + '" item_id="' + item_json[i]['item_id'] + '">' + item_json[i]['name'] + '</a></td>'

                        }
                        option += '<td class="pa-5 vat">' + item_json[i]['item_type'] + '</td>'
                        option += '<td class="pa-5 vat">' + Number(sellingprice).toFixed(2) + '</td>'
                        option += '<td class="pa-5 vat">'
                        option += '<label style="display:none;" id="pdt_ser_name' + item_json[i]['item_id'] + '">' + item_json[i]['name'] + '</label>'
                        option += '<input type="hidden" id="pdt_ser_id' + item_json[i]['item_id'] + '" value="' + item_json[i]['item_id'] + '">'
                        option += '<input type="hidden" id="pdt_ser_sku' + item_json[i]['item_id'] + '" value="' + item_json[i]['sku'] + '">'
                        option += '<input type="hidden" id="pdt_ser_sell_price' + item_json[i]['item_id'] + '" value="' + item_json[i]['sellingprice'] + '">'
                        option += '<input type="hidden" id="pdt_ser_pur_price' + item_json[i]['item_id'] + '" value="' + item_json[i]['purchase_price'] + '">'
                        option += '<input type="hidden" id="pdt_ser_unit' + item_json[i]['item_id'] + '" value="' + item_json[i]['unit_code'] + '">'
                        option += '<input type="hidden" id="pdt_ser_type' + item_json[i]['item_id'] + '" value="' + item_json[i]['item_type'] + '">'
                        option += '<input type="hidden" id="tot_qty' + item_json[i]['item_id'] + '" value="' + item_json[i]['total_quantity'] + '">'
                        //         <-----anju for tax------>
                        option += '<input type="hidden" id="interstate_tax' + item_json[i]['item_id'] + '" value="' + item_json[i]['interstate_taxid'] + '">'
                        option += '<input type="hidden" id="intrastate_tax' + item_json[i]['item_id'] + '" value="' + item_json[i]['intrastate_taxid'] + '">'
                        option += '<input type="hidden" id="export_tax' + item_json[i]['item_id'] + '" value="' + item_json[i]['export_taxid'] + '">'
                        option += '<input type="hidden" id="service_tax' + item_json[i]['item_id'] + '" value="' + item_json[i]['service_taxid'] + '">'
                        option += '<input type="hidden" id="item_taxtype' + item_json[i]['item_id'] + '" value="' + item_json[i]['tax_type'] + '">'

                        option += '<input type="hidden" id="enable_tracking' + item_json[i]['item_id'] + '" value="' + item_json[i]['enable_tracking'] + '">'
                        option += '<input type="hidden" id="partial_selling' + item_json[i]['item_id'] + '" value="' + item_json[i]['partial_selling'] + '">'
                        option += '<input type="hidden" id="total_quantity' + item_json[i]['item_id'] + '" value="' + item_json[i]['total_quantity'] + '">'
                        option += '<input type="hidden" id="barcode_type' + item_json[i]['item_id'] + '" value="' + item_json[i]['barcode_type'] + '">'
                        option += '<input type="hidden" id="barcode' + item_json[i]['item_id'] + '" value="' + item_json[i]['barcode'] + '">'

                        //         <-----END------>
                        option += '<button type="button" class="btn btn-primary btn-flat  pickitem" data-toggle="tooltip" id="product_search" sl-cl="" sel-id="' + item_json[i]['item_id'] + '"  status="whole"  value="' + item_json[i]['item_id'] + '"><i class="icon lindo-tick fz-24 m-p-w"></i> </button>'
                        option += '</td>'
                        if (item_json[i]['item_type'] == 'non-inventory') {
                            option += '<td class="pa-5 vat"></td>'
                        } else {
                            option += '<td class="pa-5 vat text-center"><a id="itm_id" class="closeopenmodal-sidebar itm_id" item_name="' + item_json[i]['name'] + '" item_id="' + item_json[i]['item_id'] + '"><i class="icon lindo-info-circled fz-24"></i></a></td>'

                        }
                        option += '</tr>';
                        count++;
                    }
                }

            }
        }

        $('.itemsearch').html(option);
    });
    $("body").on('click', '.pickitem', function (e) {
        var currency_rate = $('#currency_rate').val();
        var id = $(this).attr('sel-id');
        var occurence = 0;
        $('#invoice_table .pdt_id').each(function () {
            if ($(this).val() == id) {
                occurence++;
            }
        });
        if (occurence > 0) {
            swal('Alert', 'This item is already picked', 'error');
            return false;
        }
        var sid = $('#productlist #trid').val();
        var sll = $('[id-cl=' + sid + ']');
        var item_name = $('#pdt_ser_name' + id).text();
        var item_pur = $('#pdt_ser_pur_price' + id).val();
        var item_pur_rate = parseFloat(item_pur) * parseFloat(currency_rate);
        var item_sell = $('#pdt_ser_sell_price' + id).val();
        var item_unit = $('#pdt_ser_unit' + id).val();
        var item_sku = $('#pdt_ser_sku' + id).val();
        var item_type = $('#pdt_ser_type' + id).val();
        var item_taxtype = $('#item_taxtype' + id).val();
        var cos_per_unit = $('#cos_per_unit' + id).val();
        var enable_tracking = $('#enable_tracking' + id).val();
        var partial_selling = $('#partial_selling' + id).val();
        var total_quantity = $('#total_quantity' + id).val();
        var barcode_type = $('#barcode_type' + id).val();
        var barcode = $('#barcode' + id).val();
        var ff = sll.find('.pdt_title');
        ff.text(item_name);
        var ii = sll.find('.pdt_id');
        ii.val(id);
        var ii = sll.find('.itemtaxtype_hidden');
        ii.val(item_taxtype);
        var qq = sll.find('.quan'); //for purchase order
        qq.val('1');
        var pp = sll.find('.purchase_p'); //for quote
        pp.val(item_pur);
        var pp1 = sll.find('.pro_rate'); //for quote
        var njn = sll.find('.prorate_hidden'); //for quote
        pp1.val(Math.round(item_pur * 100) / 100);
        njn.val(Math.round(item_pur * 100) / 100);
//        pp1.val(item_pur);
        var uu = sll.find('.pdt_unit'); //for quote
        uu.val(item_unit);
        uu.text(item_unit)
        var cos = sll.find('.cos_per_unit');
        cos.val(cos_per_unit);
        var ii = sll.find('#view_history');
        ii.attr('iditem', id);
        cos.text(cos_per_unit);
        var type = sll.find('.pdt_type'); //for quote
        type.val(item_type);
        var ss = sll.find('.selling_p'); //for quote
        ss.val(item_sell);
        var sku = sll.find('.pdt_sku'); //for quote
        sku.val(item_sku);
        sku.text(item_sku);
        var sp = sll.find('.s_p'); //for quote
        sp.val('');
        var am = sll.find('.amount'); //for quote
        am.val('');
        sll.find('.pro_amount').val(0);
        var dis = sll.find('.dis'); //for quote
        dis.val(0);
        var dd = sll.find('#item_id');
        dd.val(id).change();
        var dd = sll.find('#enable_tracking');
        dd.val(enable_tracking);
        var dd = sll.find('#partial_enabled');
        dd.val(partial_selling);
        var dd = sll.find('#partial_selling');
        dd.val(partial_selling);
        var dd = sll.find('#total_quantity');
        dd.val(total_quantity);
        var dd = sll.find('#barcode_type');
        dd.val(barcode_type);
        var dd = sll.find('#common_barcode');
        dd.val(barcode);
        var dd = sll.find('#item_type');
        dd.val(item_type);
        if (barcode_type == 'sgu' || barcode_type == 'vpu') {
            var dd = sll.find('.trackingbarcode');
            dd.val(1);
        } else {
            var dd = sll.find('.trackingbarcode');
            dd.val(0);
        }
//for tax--->
        var tax_enabled = $('#tax_enabled').val();
        if (tax_enabled != -1) {
            bind_taxrate(sll, id);
        }
        calculate_row_amount(sll);
        product_subtotal_calculation()
        final_calculation();
        $('#common_percentage').trigger('change');
        //<----End
        $("#item_Modal").modal('toggle');
        $('#productlist').modal('hide');
    });
    $('body').on('click', '.copyorgmember', function (e) {
        var product_id = $('.pdt_id:last').val();
        var quantity = $('.quan:last').val();
        if (product_id == '' || quantity == '') {
            swal("Please enter valid entry");
        } else {

            e.preventDefault();
            var clid = $(".cld:last").attr('id-cl');
            var nxt = parseFloat(clid) + 1;
            var bc = $(".clone").clone();
            bc.attr("id-cl", nxt);
            var dd = bc.find("input");
            dd.val("");
            var pdt_sku = bc.find(".pdt_sku");
            pdt_sku.text("");
            var pdt_unit = bc.find(".pdt_unit");
            pdt_unit.text("");
            var cos_per_unit = bc.find(".cos_per_unit");
            cos_per_unit.text("");
            var pdt_unit = bc.find("#view_history");
            pdt_unit.attr('iditem', '');
            var ord_qty = bc.find(".ord_qty");
            ord_qty.text("");
            var req_qty = bc.find(".req_qty");
            req_qty.text("");
            bc.find(".pdt_title").text('');
            bc.removeClass('clone');
            var cc = bc.find('.no-display');
            cc.removeClass('no-display');
            bc.appendTo(".table-append_clone");
            var rc = bc.find('.clear');
            rc.addClass('no-display');
            bc.find('#discount').attr('from_disc', 'per_discount');
        }
    });
    $('body').on('click', '.removeorgmember', function (e) {
        e.preventDefault();
        $(this).closest('tr').remove();
        product_subtotal_calculation();
        final_calculation();
        $('#common_percentage').trigger('change');
    });
    $('body').on('click', '.clear', function (e) {

        e.preventDefault();
        $(this).closest('tr').find('.pdt_title').text('');
        $(this).closest('tr').find('.pdt_sku').text('');
        $(this).closest('tr').find('.pdt_unit').val('');
        $(this).closest('tr').find('.cos_per_unit').text('');
        $(this).closest('tr').find('.ord_qty').text('');
        $(this).closest('tr').find('.req_qty').text('');
        $(this).closest('tr').find('.pro_rate').val('');
        $(this).closest('tr').find('.quan').val('');
        $(this).closest('tr').find('.dis').val('');
        $(this).closest('tr').find('.pdt_id').val('');
        $(this).closest('tr').find('.pro_amount').val('');
        $(this).closest('tr').find('.enterd_dis_amount').val('');
        $(this).closest('tr').find('.common_percentage_amount').val(0);
        $(this).closest('tr').find('.pdttax').val('');
        product_subtotal_calculation();
        final_calculation();
        $('#common_percentage').trigger('change');
    });
    $('body').on('click', '.add_new_mrv', function (e) {
        e.preventDefault();
        var remaining_qty = $('#barcodeModal #remaining_qty_modal').val();
        var common_bcd_modal = $('#barcodeModal #common_bcd_modal').val();
        var qttyy = 0;
        var bc = $('#barcodeModal .clone_tr').clone();
        var bcd_type = $('#barcodetype_modal').val();
        bc.removeClass('clone_tr');
        bc.addClass('new_clone');
        bc.find('.barcode_enter').addClass('mpn');
        bc.removeClass('no-display');
        bc.find('.clear').remove();
        if (bcd_type == "sgu" || bcd_type == "vpu") {
            bc.find(".barcode_enter").val('');
            bc.find(".tracking_barcode").val(1);
        } else {
            bc.find(".barcode_enter").val(common_bcd_modal);
            bc.find(".tracking_barcode").val(0);
        }

        bc.find(".store_list").val('');
        bc.find(".store_qty").val('');
        bc.find(".hidden_barc_type").val(bcd_type);
        var cc = bc.find('.barcode_check');
        cc.addClass('no-display');
        var dd = bc.find(".remove");
        dd.removeClass('no-display');
        $('#barcodeModal .mpn').each(function () {

            qttyy++;
        });
        if (bcd_type == "sgu" || bcd_type == "vpu") {
//            if (Number(remaining_qty) > Number(qttyy)) {
            bc.appendTo('.main');
//            }
        } else {
            bc.appendTo('.main');
        }
    });
    $('body').on('click', '.add_barcode_mrv', function (e) {
        var cld_val = $('#barcodeModal #cld_modal').val();
        var barcodetype = $('#barcodeModal #barcodetype_modal').val();
        $('#jquery_mask').show();
        $.post(siteurl + "/Inventory/Mrv/get_barcode_details", {}, function (data)
        {
            console.log(data);
            $('#jquery_mask').hide();
            var count_err = 0;
            var flag = 0;
            var flag_mpn = 0;
            var flag_qty = 0;
            var flag_new_barcode = 0;
            var flag_bar_check = 0;
            var generated_barc_flag = 0;
            var json_array = JSON.parse(data);
            var json_array_barcode = json_array['barcodes']['barcode'];
            var json_array_barcode_number = json_array['barcodes']['barcode_number'];
            var barcode_type = new Array();
            var mpn = new Array();
            var store = new Array();
            var store_qty = new Array();
            flag = 0;
            var hidden_mpn = [];
            $(".hidden_mpn").each(function () {
                if ($(this).val()) {
                    hidden_mpn.push($(this).val());
                }
            });
            var tracking_barcode = new Array();
            $("input[name='mpn[]']").each(function () {
                var value = $(this).val();
                var closest = $(this).closest('tr');
                var hidden_barc_type = closest.find('.hidden_barc_type').val();
                if (hidden_barc_type == 'sgu' || hidden_barc_type == 'vpu') {
                    if ($.inArray(value, mpn) != -1) {
                        flag_bar_check = 1;
                    }
                }
                mpn.push($(this).val());
                store.push($(this).closest('tr').find('.store_list').val());
                store_qty.push($(this).closest('tr').find('.store_qty').val());
            });
            if (flag_bar_check == 1) {
                swal('Alert', 'Please enter unique Barcode.', 'error');
            }
            $("input[name='tracking_barcode[]']").each(function () {
                tracking_barcode.push($(this).val());
            });
            $("input[name='hidden_barc_type[]']").each(function () {
                barcode_type.push($(this).val());
            });
            if (mpn.length == 0) {
                swal('Alert', 'Please check sl number.', 'error');
                flag_mpn = 1;
                return;
            }

            for (var i = 0; i < mpn.length; i++)
            {
                console.log(tracking_barcode[i]);
                if (tracking_barcode[i] == 1) {

                    ///////////////////for sgu and vpu//////////////////

                    if (barcode_type[i] == 'sgu' || barcode_type[i] == 'vpu') {
                        if ($.inArray(mpn[i], json_array_barcode) == -1)
                        {
                            var count_err = 0;
                            $('.barcode_enter' + i).css('border', '1px solid rgba(33, 33, 33, 0.12)');
                            flag = 1;
                        } else
                        {
                            e.preventDefault();
                            if (tracking_barcode[i] == 1) {
                                if (mpn[i] == '') {
                                    swal('Enter Barcode.');
                                } else {
                                    swal('Barcode already exists.');
                                }
                            }
                            e.preventDefault();
                            $('.barcode_enter' + i).focus();
                            $('.barcode_enter' + i).css('border', '1px solid red');
                            $('.barcode_enter' + i).val('');
                            flag = 0;
                            break;
                        }

                        var new_barcode_array = new Array();
                    }


                    if (barcode_type[i] == 'sgu') {
                        if ($.inArray(mpn[i], json_array_barcode_number) == -1) {
                            swal('Please enter generated Barcode');
                            generated_barc_flag = 1;
                        }

                    }
                    ///////////////////end//////////////////

                } else {
                    flag = 1;
                }

                if (store[i] == '') {
                    swal('Choose Store.');
                    generated_barc_flag = 1;
                }
                if (barcode_type[i] == 'sgc' || barcode_type[i] == 'vpc') {
                    if (store_qty[i] == '') {
                        swal('Enter Quantity.');
                        generated_barc_flag = 1;
                    }
                }

            }
            var new_mpnarray = [];
            var new_storearray = [];
            var new_store_qtyarray = [];
            var enterd_qty = 0;
            console.log(barcode_type);
            if (barcodetype == "sgu" || barcodetype == "vpu") {
                $('.barcode_enter').each(function () {
                    if ($(this).val()) {
                        if ($(this).closest('tr').find('.barcode_check').is(":checked")) {
                            new_mpnarray.push($(this).val());
                            new_storearray.push($(this).closest('tr').find('.store_list').val());
                        }
                    }
                });
            } else if (barcodetype == "sgc" || barcodetype == "vpc") {
                $('.store_qty').each(function () {
                    if ($(this).val()) {
                        if ($(this).closest('tr').find('.barcode_check').is(":checked")) {
                            new_storearray.push($(this).closest('tr').find('.store_list').val());
                            new_store_qtyarray.push($(this).val());
                            enterd_qty += Number($(this).val());
                            new_mpnarray.push(0);
                        }
                    }
                });
            }
            if (flag == 1 && flag_qty == 0 && flag_mpn == 0 && flag_bar_check == 0 && generated_barc_flag == 0) {
                var barcodes = new_mpnarray.toString();
                var stores = new_storearray.toString();
                var qtys = new_store_qtyarray.toString();
                var sll = $('.cld[id-cl=' + cld_val + ']');
                if (barcodetype == "sgu" || barcodetype == "vpu") {
                    var qty = new_mpnarray.length;
                    sll.find('.barcodes').html(barcodes);
                } else if (barcodetype == "sgc" || barcodetype == "vpc") {
                    var qty = enterd_qty;
                }


                sll.find('.qty').val(qty);
                sll.find('.hidden_mpn').val(barcodes);
                sll.find('.storeids').val(stores);
                sll.find('.hiddenqty').val(qtys);
                $('#barcodeModal').modal('hide');
                sll.find('.qty').trigger('keyup');
            }
        });
    });
///////////////////////////////////////////////////*****************************************************/////////////////////////////////////////////////////**************    




});
function calculate_row_amount(sll) {
    var aa = sll.find('.qty');
    var bb = sll.find('.invoice_rate');
    var cc = sll.find('.pro_amount');
    var ee = sll.find('.qty_billed');
    var gg = sll.find('.qty_mrv');
    var ff = sll.find('.dis');
    var z = sll.find('#discount_amount');
    var zk = sll.find('.entered_discount_amount');
    if (aa.val()) {
        var quantity = aa.val();
    } else {
        var quantity = '';
    }
    if (bb.val()) {
        var rate = bb.val();
    } else {
        var rate = '';
    }
    if (ff.val()) {
        var discount = ff.val();
    } else {
        var discount = '';
    }
    if (ee.val()) {
        var quantity_billed = ee.val();
    } else {
        var quantity_billed = '';
    }
    if (gg.val()) {
        var quantity_mrv = gg.val();
    } else {
        var quantity_mrv = '';
    }
    if (zk.val()) {
        var discnt_amt = zk.val();
    } else {
        var discnt_amt = 0;
    }
    var ffu = sll.find('.error');
    if (parseFloat(quantity) > ((parseFloat(quantity_mrv)) - (parseFloat(quantity_billed))))
    {
        ffu.show();
        aa.val('');
        cc.val('0');
    } else {
        ffu.hide();
        if (quantity != "" && rate != "")
        {
            var taxamnt = 0;
            var tot_amt = parseFloat(quantity) * parseFloat(rate);
            var percent = (parseFloat(discnt_amt) * 100 / parseFloat(tot_amt));
            if (isNaN(percent)) {
                var percent = 0;
            }
            sll.find('.dis').val(parseFloat(percent).toFixed(2));
            var amt = ((parseFloat(quantity) * parseFloat(rate)) - parseFloat(discnt_amt));
            var tax_enabled = $('#tax_enabled').val();
            if (tax_enabled != -1) {
                taxamnt = tax_calculation(sll, amt);
            }
            cc.val(parseFloat(amt + taxamnt).toFixed(2));
        } else {
            quantity = 0;
            rate = 0;
            var taxamnt = 0;
            var tot_amt = parseFloat(quantity) * parseFloat(rate);
            var percent = (parseFloat(discnt_amt) * 100 / parseFloat(tot_amt));
            if (isNaN(percent)) {
                var percent = 0;
            }
            sll.find('.dis').val(parseFloat(percent).toFixed(2));
            var amt = ((parseFloat(quantity) * parseFloat(rate)) - parseFloat(discnt_amt));
            var tax_enabled = $('#tax_enabled').val();
            if (tax_enabled != -1) {
                taxamnt = tax_calculation(sll, amt);
            }
            cc.val(parseFloat(amt + taxamnt).toFixed(2));
        }
    }
}
function tax_calculation(sll, net) {
    var selected_array = [];
    var selected_pdtgrpid = sll.find('.selected_product_taxgrp').val();
    var totaltax_amount = 0;
    for (const [key, value] of Object.entries(tax_details)) {

        if (key == selected_pdtgrpid) {
            for (var ii = 0; ii < value.length; ii++) {
                selected_array.push(value[ii]['tax_masterid']);
                var taxrate = value[ii]['tax_rate'];
                var tax_amount = (parseFloat(taxrate) / 100) * parseFloat(net);
                totaltax_amount += tax_amount;
                sll.find('#tax_masterid_' + value[ii]['tax_masterid']).val(value[ii]['tax_rate'] + '% :\n' + tax_amount.toFixed(2));
            }
            var finalnet_amount = parseFloat(net) + parseFloat(totaltax_amount);
        }
    }
    return totaltax_amount;
}
function bind_taxrate(sll, id) {
    var tax_type = $('input[name=tax_type]:checked').val();
    var interstate_tax = $('#interstate_tax' + id).val();
    var intrastate_tax = $('#intrastate_tax' + id).val();
    var export_tax = $('#export_tax' + id).val();
    var service_tax = $('#service_tax' + id).val();
    if (typeof (interstate_tax) == 'undefined') {
        interstate_tax = $('#interstate_tax').val();
        intrastate_tax = $('#intrastate_tax').val();
        export_tax = $('#export_tax').val();
        service_tax = $('#service_tax').val();
    }
    var key_exist = 0;
    if (product_taxarray != null) {
        for (const [key, value] of Object.entries(product_taxarray)) {
            if (key == id) {
                key_exist = 1;
            }
        }
    } else {
        product_taxarray = [];
    }
    if (key_exist == 0) {
        product_taxarray[id] = {interstate_tax: interstate_tax, intrastate_tax: intrastate_tax, export_tax: export_tax, service_tax: service_tax};
    }
    sll.find('.pdttax').val('');
    for (const [key_pdtid, value_tax] of Object.entries(product_taxarray)) {
        if (key_pdtid == id) {
            for (const [key, value] of Object.entries(tax_details)) {
                if (tax_type == 'intra_state') {
                    if (key == value_tax['intrastate_tax']) {
                        for (var ii = 0; ii < value.length; ii++) {
                            sll.find('.selected_product_taxgrp').val(value_tax['intrastate_tax']);
                            sll.find('.tax_details_' + value[ii]['tax_masterid']).val(value[ii]['tax_rate'] + '% :\n0');
                        }
                    }
                } else if (tax_type == 'inter_state') {
                    if (key == value_tax['interstate_tax']) {
                        for (var ii = 0; ii < value.length; ii++) {
                            sll.find('.selected_product_taxgrp').val(value_tax['interstate_tax']);
                            sll.find('.tax_details_' + value[ii]['tax_masterid']).val(value[ii]['tax_rate'] + '% :\n0');
                        }
                    }
                } else if (tax_type == 'export') {
                    if (key == value_tax['export_tax']) {
                        for (var ii = 0; ii < value.length; ii++) {
                            sll.find('.selected_product_taxgrp').val(value_tax['export_tax']);
                            sll.find('.tax_details_' + value[ii]['tax_masterid']).val(value[ii]['tax_rate'] + '% :\n0');
                        }
                    }
                }
            }
        }
    }
}

function final_calculation() {
    var pdttaxmasteramount = 0;
    $('.pdttaxmasteramount').each(function () {
        pdttaxmasteramount += parseFloat($(this).val());
    });
    var nettaxamount = parseFloat(pdttaxmasteramount);
    $('#ttltax_amount').val(nettaxamount);
    var subtotal = 0;
    $('body').find('.pro_amount').each(function () {
        subtotal += parseFloat($(this).val());
    });
    var other = 0;
    $('.cld_charge').each(function () {
        var charge_paidby = $(this).find('.charge_paidby').val();
        if (charge_paidby == "vendor") {
            other += Number($(this).find('.charge_amount').val());
        }
    });
    subtotal += other;
    $('#bill_subtotal_txt').val(subtotal);
    $('#bill_subtotal').val(subtotal);
    var net_amount = $('#bill_subtotal_txt').val();
//    $('.bill_subtotal_txt').html(net_amount);
    $('#total_amount_hidden').val(net_amount);
    var transaction_rate = $('#currency_rate').val();
    if (transaction_rate == 'undefined' && transaction_rate == '') {
        transaction_rate = 1;
    }


    if (net_amount != 'undefined' && net_amount != '') {
        var transaction_currency = parseFloat(net_amount) * parseFloat(transaction_rate);
        var tr_currency = transaction_currency.toFixed(2);
        $('#transaction_currency').val(tr_currency);
        $('#transaction_rate_value').html(tr_currency);
        var old_rate = $('#old_hidden').val();
        if (old_rate) {
            var po_amount = $('#old_hidden').val() * net_amount;
            var po = parseFloat(po_amount).toFixed(2);
            var tr = parseFloat(transaction_currency).toFixed(2);
            var gain_or_loss = parseFloat(po) - parseFloat(tr);
            var gain_loss = gain_or_loss.toFixed(2);
            $('.transaction_gain').html(gain_loss);
            $('#transaction_gain1').val(gain_loss);
        }
    }
}

function find_mrv_total(row_id) {
    var slll = $('.cld[idcl="' + row_id + '"]');
    var mrvamountfinal = 0;
    slll.each(function () {
        mrvamountfinal += parseFloat($(this).closest('tr').find('.pro_amount').val());
    });
    $('#bill_subtotal_txt_' + row_id).text(mrvamountfinal.toFixed(2));
}

function product_subtotal_calculation() {
    var tax_enabled = $('#tax_enabled').val();
    if (tax_enabled != -1) {
        for (var i = 0; i < alltax_details.length; i++) {
            var totaltaxmaster_amount = 0;
            $('.tax_details_' + alltax_details[i].tax_master_id).each(function () {
                if ($(this).closest('tr').find('.ck_sel').is(':checked')) {
                    var taxamount_i = 0;
                    if ($(this).val() != '') {
                        var res = $(this).val().split(':');
                        if (res.length > 1) {
                            taxamount_i = Number(res[1]);
                        }
                    }
                    totaltaxmaster_amount += taxamount_i;
                }
            });
            $('#totalpro_tax_' + alltax_details[i].tax_master_id).val(totaltaxmaster_amount);
        }
    }
    var pro_total = 0;
    var pro_dis_amt = 0;
    $('.amount').each(function () {
        if ($(this).closest('tr').find('.ck_sel').is(':checked')) {
            if ($(this).val() != '') {
                pro_total += parseFloat($(this).val());
            }
        }
    });
    $('.item_disc_amt').each(function () {
        if ($(this).closest('tr').find('.ck_sel').is(':checked')) {
            if ($(this).val() != '') {
                pro_dis_amt += parseFloat($(this).val());
            }
        }
    });
    var pdttaxmasteramount = 0;
    $('.pdttaxmasteramount').each(function () {
        pdttaxmasteramount += parseFloat($(this).val());
    });
    var nettaxamount = parseFloat(pdttaxmasteramount);
    $('#ttltax_amount').val(nettaxamount);
    $('#pro_total').val(pro_total);
    $('#pro_dis').val(pro_dis_amt);
}