$(document).ready(function () {
    $(window).load(function () {
        if (typeof old_rate !== 'undefined' && typeof new_rate !== 'undefined' && parseFloat(old_rate) != '' && parseFloat(old_rate) != parseFloat(new_rate)) {
            swal({
                title: "Transaction Rate Changed",
                text: "Do you want to apply the new rate",
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "Yes, Apply !",
                cancelButtonText: "No, don't apply !",
                closeOnConfirm: false,
                closeOnCancel: false
            },
                    function (isConfirm) {
                        if (isConfirm) {
                            $('.currency_rate').val(new_rate);
                            $('.cur_trans_rate_id').val(new_cur_trans_rate_id);
                            $('.transaction_c_symbol').val(new_curr_symbol);
                            swal("Rate Changed", "New Rate applied", "success");
                        } else {
                            swal("Cancelled", "Previous Rate will prevail", "success");
                        }
                    });
        }
    });
    $("#product_search2").on('click', function ()
    {
        var product_name = $('#product_name').val();
        if (product_name == "")
        {
            alert('Enter Details');
        } else {
            $('#jquery_mask').show();
            $.post(siteurl + "/Inventory/Purchase_requsition/search_item", {product_name: product_name}, function (data) {
                $('#jquery_mask').hide();
                $('#search_results_disp').html(data);
                $('#search_results_disp #partial_tr').hide();
            });
        }
    });
    $('body').on('click', '.clear', function (e) {

        e.preventDefault();
        $(this).closest('tr').find('.pdt_title').text('');
        $(this).closest('tr').find('.pdt_sku').text('');
        $(this).closest('tr').find('.pdt_unit').val('');
        $(this).closest('tr').find('.cos_per_unit').text('');
        $(this).closest('tr').find('.ord_qty').text('');
        $(this).closest('tr').find('.req_qty').text('');
        $(this).closest('tr').find('.pro_rate').val('');
        $(this).closest('tr').find('.quan').val('');
        $(this).closest('tr').find('.dis').val('');
        $(this).closest('tr').find('.pdt_id').val('');
        $(this).closest('tr').find('.pro_amount').val('');
        $(this).closest('tr').find('.enterd_dis_amount').val('');
        $(this).closest('tr').find('.common_percentage_amount').val(0);
        $(this).closest('tr').find('.pdttax').val('');
        product_subtotal_calculation();
        final_calculation();
        $('#common_percentage').trigger('change');
    });
    $('body').on('click', '.pagesubmit', function (e) {
        e.preventDefault();
        var my_purchase_filter = $('#my_purchase_filter').val();
        var po_filter = $('#po_filter').val();
        var search_po_keyword = $('#search_po_keyword').val();
        $('#my_purchase_filter2').val(my_purchase_filter);
        $('#po_filter2').val(po_filter);
        $('#search_po_keyword2').val(search_po_keyword);
        var url = $(this).attr('href');
        $('#paginationfilter2').attr('action', url);
        $('#paginationfilter2').submit();
    });
    $('body').on('click', '.pagesubmit2', function (e) {
        e.preventDefault();
        var po_filter = $('#purchase_filter_p').val();
        var search_po_keyword = $('#search_po_keyword').val();
        var created_by_p = $('#created_by_p').val();
        $('#purchase_filter_p2').val(po_filter);
        $('#search_po_keyword_p2').val(search_po_keyword);
        $('#created_by_p2').val(created_by_p);
        var url = $(this).attr('href');
        $('#paginationfilter2').attr('action', url);
        $('#paginationfilter2').submit();
    });
    $('body').on('click', '#search_do_keyword', function () {
//        var my_purchase_filter = $('#my_purchase_filter').val();
//        var po_filter = $('#po_filter').val();
//        if (my_purchase_filter == '' && po_filter == '') {
//            swal("Please check any filter");
//        } else {
        $('#filtersubmit').submit();
//        }
    });
    $('body').on('click', '#search_do_keyword_p', function () {
//        var purchase_filter_p = $('#purchase_filter_p').val();
//        if (purchase_filter_p == '') {
//            swal("Please check any filter");
//        } else {
        $('#filtersubmit_p').submit();
//        }
    });
    $('body').on('click', '.copyorgmember', function (e) {
        var product_id = $('.pdt_id:last').val();
        var quantity = $('.quan:last').val();
        if (product_id == '' || quantity == '') {
            swal("Please enter valid entry");
        } else {

            e.preventDefault();
            var clid = $(".cld:last").attr('id-cl');
            var nxt = parseFloat(clid) + 1;
            var bc = $(".clone").clone();
            bc.attr("id-cl", nxt);
            var dd = bc.find("input");
            dd.val("");
            var pdt_sku = bc.find(".pdt_sku");
            pdt_sku.text("");
            var pdt_unit = bc.find(".pdt_unit");
            pdt_unit.text("");
            var cos_per_unit = bc.find(".cos_per_unit");
            cos_per_unit.text("");
            var pdt_unit = bc.find("#view_history");
            pdt_unit.attr('iditem', '');
            var ord_qty = bc.find(".ord_qty");
            ord_qty.text("");
            var req_qty = bc.find(".req_qty");
            req_qty.text("");
            bc.find(".pdt_title").text('');
            bc.removeClass('clone');
            var cc = bc.find('.no-display');
            cc.removeClass('no-display');
            bc.appendTo(".table-append_clone");
            var rc = bc.find('.clear');
            rc.addClass('no-display');
            bc.find('#discount').attr('from_disc', 'per_discount');
        }
    });
    $('body').on('click', '.removeorgmember', function (e) {
        e.preventDefault();
        $(this).closest('tr').remove();
        product_subtotal_calculation();
        final_calculation();
        $('#common_percentage').trigger('change');
    });
    $('body').on('change', '.tax_type', function (e) {
        var taxtype = $(this).val();
        $('.cld').each(function () {
            var pdtid = $(this).find('.pdt_id').val();
            bind_taxrate($(this), pdtid);
            calculate_row_amount($(this));
        });
        product_subtotal_calculation()
        final_calculation();
    });
    $("body").on('click', '.pickitem', function (e) {
        var currency_rate = $('#currency_rate').val();
        var id = $(this).attr('sel-id');
        var occurence = 0;
        $('#invoice_table .pdt_id').each(function () {
            if ($(this).val() == id) {
                occurence++;
            }
        });
        if (occurence > 0) {
            swal('Alert', 'This item is already picked', 'error');
            return false;
        }
        var sid = $('#productlist #trid').val();
        var sll = $('[id-cl=' + sid + ']');
        var item_name = $('#pdt_ser_name' + id).text();
        var item_pur = $('#pdt_ser_pur_price' + id).val();
        var item_pur_rate = parseFloat(item_pur) * parseFloat(currency_rate);
        var item_sell = $('#pdt_ser_sell_price' + id).val();
        var item_unit = $('#pdt_ser_unit' + id).val();
        var item_sku = $('#pdt_ser_sku' + id).val();
        var item_type = $('#pdt_ser_type' + id).val();
        var item_taxtype = $('#item_taxtype' + id).val();
        var cos_per_unit = $('#cos_per_unit' + id).val();
        var ff = sll.find('.pdt_title');
        ff.text(item_name);
        var ii = sll.find('.pdt_id');
        ii.val(id);
        var ii = sll.find('.itemtaxtype_hidden');
        ii.val(item_taxtype);
        var qq = sll.find('.quan'); //for purchase order
        qq.val('1');
        var pp = sll.find('.purchase_p'); //for quote
        pp.val(item_pur);
        var pp1 = sll.find('.pro_rate'); //for quote
        var njn = sll.find('.prorate_hidden'); //for quote
        pp1.val(Math.round(item_pur * 100) / 100);
        njn.val(Math.round(item_pur * 100) / 100);
//        pp1.val(item_pur);
        var uu = sll.find('.pdt_unit'); //for quote
        uu.val(item_unit);
        uu.text(item_unit)
        var cos = sll.find('.cos_per_unit');
        cos.val(cos_per_unit);
        var ii = sll.find('#view_history');
        ii.attr('iditem', id);
        cos.text(cos_per_unit);
        var type = sll.find('.pdt_type'); //for quote
        type.val(item_type);
        var ss = sll.find('.selling_p'); //for quote
        ss.val(item_sell);
        var sku = sll.find('.pdt_sku'); //for quote
        sku.val(item_sku);
        sku.text(item_sku);
        var sp = sll.find('.s_p'); //for quote
        sp.val('');
        var am = sll.find('.amount'); //for quote
        am.val('');
        sll.find('.pro_amount').val(0);
        var dis = sll.find('.dis'); //for quote
        dis.val(0);
        var dd = sll.find('#item_id');
        dd.val(id).change();
        //for tax--->
        var tax_enabled = $('#tax_enabled').val();
        if (tax_enabled != -1) {
            bind_taxrate(sll, id);
        }
        calculate_row_amount(sll);
        product_subtotal_calculation()
        final_calculation();
        $('#common_percentage').trigger('change');
        //<----End
        $("#item_Modal").modal('toggle');
        $('#productlist').modal('hide');
    });
    $('body').on('click', '.selitem', function () {
        $('#nonpro_name').val('');
        $('#noninventoryModal .getvendor').val('');
        $('#nonpro_unit').val('0');
        $('#nonpro_qty').val('0');
        $('#nonpro_costprice').val('0');
        $('#nonpro_sellingprice').val('0');
        $('#nonpro_markup').val('0');
        $('#nonpro_sku').val('');
        $('#common_barcode').val('');
        $('#common_barcode_div').val('');
        $('#barc_non_inv').val('sgu');
        $('.common_barcode_div').addClass('no-display');
        $('.common_barcode_div_vpc').addClass('no-display');
        var selid = $(this).closest('tr').attr('id-cl');
        var pp = $(this).closest('tr');
//        pp.find('#pro_amount').val('0');
        var option = '';
        var count = 1;
        var new_array = [];
        if (item_json == null || item_json == 'undefined') {

        } else {

            for (var i = 0; i < item_json.length; i++) {
                if (item_json[i]['item_type'] == 'inventory' || item_json[i]['item_type'] == 'inventory_and_service' || item_json[i]['item_type'] == 'non-inventory') {
                    new_array.push(item_json[i]);
                }
            }
            var length1 = 10;
            if (new_array.length < 10) {
                length1 = new_array.length;
            }
            var sku = '';
            var puprice = '';
            var sellingprice = '';
            for (var i = 0; i < length1; i++) {
                if (new_array[i]['sku'] == null) {
                    sku = '';
                } else {
                    sku = new_array[i]['sku']
                }
                if (new_array[i]['sellingprice'] == null) {
                    sellingprice = '';
                } else {
                    sellingprice = parseFloat(new_array[i]['sellingprice']).toFixed(2);
                }
                option += '<tr class="sec_grid_tbl">'
                //option += '<td class="pa-5 vat">' + count + '</td> '
                option += '<td class="w15 pa-5">' + sku + '</td>'
//                option += '<td class="pa-5 vat">' + new_array[i]['name'] + '</td>'
                if (new_array[i]['item_type'] == 'non-inventory') {
                    option += '<td class="w55 pa-5">' + new_array[i]['name'] + '</td>'
                } else {
                    option += '<td class="w60 pa-5"><a href="" id="itm_id" class="closeopenmodal-sidebar itm_id" item_name="' + new_array[i]['name'] + '" item_id="' + new_array[i]['item_id'] + '">' + new_array[i]['name'] + '</a></td>'
                }
                option += '<td class="w10 pa-5 text-center">'
                if (item_json[i]['item_type'] == 'inventory_and_service') {
                    option += '<span data-tooltip="Inventoy & Services"><i class="icon lindo-023-worldwide fz-20 txt-dgray"></i></span>';
                } else if (item_json[i]['item_type'] == 'inventory') {
                    option += '<span data-tooltip="Inventory"><i class="icon lindo-shopping-cart-content fz-20 txt-dgray"></i></span>';
                } else {
                    option += '<span data-tooltip="Non-Inventory"><i class="icon lindo-shopping-bag-1 fz-20 txt-dgray"></i></span>';
                }
                option += '</td>'
                option += '<td class="w10 pa-5">' + sellingprice + '</td>'
                if (new_array[i]['item_type'] == 'non-inventory') {
                    option += '<td class="w5 pa-5"></td>'
                } else {
                    option += '<td class="w5 pa-5 text-center"><a id="itm_id" class="btn btn-default btn-outline btn-flat closeopenmodal-sidebar itm_id" item_name="' + new_array[i]['name'] + '" item_id="' + new_array[i]['item_id'] + '" data-tooltip="Stock Details"><i class="icon lindo-information-white fz-18"></i></a></td>'
                }
                option += '<td class="w5 pa-5">'
                option += '<label style="display:none;" id="pdt_ser_name' + new_array[i]['item_id'] + '">' + new_array[i]['name'] + '</label>'
                option += '<input type="hidden" id="pdt_ser_id' + new_array[i]['item_id'] + '" value="' + new_array[i]['item_id'] + '">'
                option += '<input type="hidden" id="pdt_ser_sku' + new_array[i]['item_id'] + '" value="' + new_array[i]['sku'] + '">'
                option += '<input type="hidden" id="pdt_ser_sell_price' + new_array[i]['item_id'] + '" value="' + new_array[i]['sellingprice'] + '">'
                option += '<input type="hidden" id="pdt_ser_pur_price' + new_array[i]['item_id'] + '" value="' + new_array[i]['purchase_price'] + '">'
                option += '<input type="hidden" id="pdt_ser_unit' + new_array[i]['item_id'] + '" value="' + new_array[i]['unit_code'] + '">'
                option += '<input type="hidden" id="pdt_ser_type' + new_array[i]['item_id'] + '" value="' + new_array[i]['item_type'] + '">'
                option += '<input type="hidden" id="tot_qty' + new_array[i]['item_id'] + '" value="' + new_array[i]['total_quantity'] + '">'
                //         <-----anju for tax------>
                option += '<input type="hidden" id="interstate_tax' + new_array[i]['item_id'] + '" value="' + new_array[i]['interstate_taxid'] + '">'
                option += '<input type="hidden" id="intrastate_tax' + new_array[i]['item_id'] + '" value="' + new_array[i]['intrastate_taxid'] + '">'
                option += '<input type="hidden" id="export_tax' + new_array[i]['item_id'] + '" value="' + new_array[i]['export_taxid'] + '">'
                option += '<input type="hidden" id="service_tax' + new_array[i]['item_id'] + '" value="' + new_array[i]['service_taxid'] + '">'
                option += '<input type="hidden" id="item_taxtype' + new_array[i]['item_id'] + '" value="' + new_array[i]['tax_type'] + '">'
                //         <-----END------>
                option += '<button type="button" class="btn btn-default btn-outline btn-flat pickitem" data-toggle="tooltip" id="product_search" sl-cl="" sel-id="' + new_array[i]['item_id'] + '"  status="whole"  value="' + new_array[i]['item_id'] + '"><i class="icon lindo-tick fz-18"></i> </button>'
                option += '</td>'

                option += '</tr>';
                count++;
                if (new_array[i]['sellingprice'] == null) {
                    new_array[i]['sellingprice'] = '';
                }
                if (new_array[i]['sku'] == null) {
                    new_array[i]['sku'] = '';
                }
            }
            $('.itemsearch').html(option);
        }
        $("#productlist #trid").val(selid);
        $("#requsitionList #trid").val(selid);
        $("#noninventoryModal #trid").val(selid);
    });
    $('body').on('click', '#deliverto_warehouse', function () {
        $('#warehouse_spec_box').show();
        $('#customer_spec_box').hide();
    });
    $('body').on('click', '#deliverto_customer', function () {
        $('#customer_spec_box').show();
        $('#warehouse_spec_box').hide();
    });
    $('body').on('click', '#purchase_order_request', function () {
        var id1 = $(this).attr('id2');
        var s = $(this).closest('tr');
        var approve_status = 'pending';
        $('#jquery_mask').show();
        $.post(siteurl + "/Inventory/Purchase/update_approval_status", {approve_status: approve_status, id1: id1}, function (data) {

            $('#jquery_mask').hide();
            s.find('#purchase_order_request').css({'visibility': 'hidden'});
            location.reload();
        });
    });
    $('body').on('click', '#po_request_approve', function () {
        var id1 = $(this).attr('id2');
        var id2 = $(this).attr('req_id');
        var s = $(this).closest('tr');
        var approve_status = 'approved';
        $('#jquery_mask').show();
        $.post(siteurl + "/Inventory/Purchase/update_approval_status", {approve_status: approve_status, id1: id1, id2: id2}, function (data) {
            $('#jquery_mask').hide();
            location.reload();
        });
    });
    $('body').on('click', '#po_request_reject', function () {
        var id1 = $(this).attr('id3');
        var s = $(this).closest('tr');
        $('#rejectModal #reject_id').val(id1);
    });
    $('body').on('keyup', '.enterd_dis_amount', function (e) {
        var sll = $(this).closest('tr');
        var tax_enabled = $('#tax_enabled').val();
        calculate_row_amount(sll, tax_enabled);
        product_subtotal_calculation();
        final_calculation();
        $('#common_percentage').trigger('change');
    });
    $('body').on('blur', '#discount', function (e) {
        var sll = $(this).closest('tr');
        var discount_percentage = $(this).val();
        var pro_rate = sll.find('.pro_rate').val();
        var quan = sll.find('.quan').val();
        var pro_amount = pro_rate * quan;
        var percent = (parseFloat(discount_percentage) * pro_amount / parseFloat(100));
        if (isNaN(percent)) {
            var percent = 0;
        }
        sll.find('.enterd_dis_amount').val(parseFloat(percent).toFixed(2));
        calculate_row_amount(sll);
        product_subtotal_calculation();
        final_calculation();
        $('#common_percentage').trigger('change');
    });
    $('body').on('keyup', '.discount_direct', function (e) {
        var rowid = $(this).parent().parent().parent().attr('id-cl');
        var sll = $('[id-cl=' + rowid + ']');
        var discount_percentage = $(this).val();
        var pro_rate = sll.find('.pro_rate').val();
        var quan = sll.find('.quan').val();
        var pro_amount = pro_rate * quan;
        var percent = (parseFloat(discount_percentage) * pro_amount / parseFloat(100));
        if (isNaN(percent)) {
            var percent = 0;
        }
        sll.find('.enterd_dis_amount').val(parseFloat(percent).toFixed(2));
        calculate_row_amount(sll);
        product_subtotal_calculation();
        final_calculation();
    });
    $('body').on('keyup', '.enterd_dis_amount_direct', function (e) {
        var rowid = $(this).parent().parent().parent().attr('id-cl');
        var sll = $('[id-cl=' + rowid + ']');
        //anjup for tax---------->
        var tax_enabled = $('#tax_enabled').val();
        //END<--------------------
        calculate_row_amount(sll, tax_enabled);
        final_calculation();
    });
    $('body').on('keyup', '#qty,#pro_rate', function () {
        var sll = $(this).closest('tr');
        calculate_row_amount(sll);
        product_subtotal_calculation();
        final_calculation();
        $('#common_percentage').trigger('change');
    });
///////for discount amount///////////////


//    $('body').on('change', '#enterd_dis_amount', function () {
//        var rowid = $(this).closest('tr').attr('id-cl');
//        var sll = $('[id-cl=' + rowid + ']');
//        var aa = sll.find('#qty');
//        var bb = sll.find('#pro_rate');
//        var cc = sll.find('#pro_amount');
//        var zz = sll.find('#discount');
//        var ida = sll.find('#enterd_dis_amount');
//        if (aa.val()) {
//            var quantity = aa.val();
//        } else {
//            var quantity = '';
//        }
//        if (bb.val()) {
//            var rate = bb.val();
//        } else {
//            var rate = '';
//        }
//        if (zz.val()) {
//            var dis = zz.val();
//        } else {
//            var dis = '0';
//        }
//        if (ida.val()) {
//            var entered_dis_amount = ida.val();
//        } else {
//            var entered_dis_amount = 0;
//        }
//        if (entered_dis_amount == '') {
//            entered_dis_amount = 0;
//        }
//        var total_amount = parseFloat(rate) * parseFloat(quantity);
//        var amt_with_disc_amt = (parseFloat(total_amount) - (entered_dis_amount));
//        if (entered_dis_amount != "" && rate != "")
//        {
//            var percent = (parseFloat(entered_dis_amount) * 100 / parseFloat(total_amount));
//            if (isNaN(percent)) {
//                var percent = 0;
//            }
//            zz.val(parseFloat(percent).toFixed(2));
//
//        } else {
//            zz.val(0);
//        }
//        zz.attr('from_disc', 'amt_discount');
//        zz.trigger("keyup");
//    });


    $('body').on('change', '#common_percentage', function () {
        var common_percentage = $(this).val();
        if (common_percentage == '') {
            common_percentage = 0;
        }
        var pro_total = $('#hidden_pro_total').val();
        if (pro_total != 0) {
            var cda = (parseFloat(pro_total) * parseFloat(common_percentage) / 100);
            $('#common_percentage_amount').val(parseFloat(cda).toFixed(2));
            var total_amount_with_disc = parseFloat(pro_total) - parseFloat(cda);
            $('#pro_total').val(parseFloat(total_amount_with_disc).toFixed(2));
            var currency_rate = $('#currency_rate').val();
            var final_currency_amt = (total_amount_with_disc / currency_rate);
            var tr_currency = final_currency_amt.toFixed(2);
            $('.final_curency_amount').val(tr_currency);
//nid check
        } else {
            $(this).val(0);
            $('#common_percentage_amount').val(0);
        }
    });
    $('body').on('change', '#common_percentage_amount', function () {
        var common_percentage_amount = $(this).val();
        if (common_percentage_amount == '') {
            common_percentage_amount = 0;
        }
        var pro_total = $('#hidden_pro_total').val();
        if (pro_total != 0) {
            var cdp = (parseFloat(common_percentage_amount) * 100) / parseFloat(pro_total);
            $('#common_percentage').val(parseFloat(cdp).toFixed(2));
            var total_amount_with_disc = parseFloat(pro_total) - parseFloat(common_percentage_amount);
            $('#pro_total').val(parseFloat(total_amount_with_disc).toFixed(2));
            var currency_rate = $('#currency_rate').val();
            var final_currency_amt = (total_amount_with_disc / currency_rate);
            var tr_currency = final_currency_amt.toFixed(2);
            $('.final_curency_amount').val(tr_currency);
        } else {
            $(this).val(0);
            $('#common_percentage').val(0);
        }
    });
    $('body').on('keyup', '.qty_direct,.pro_direct', function () {
        var rowid = $(this).parent().parent().parent().attr('id-cl');
        var sll = $('[id-cl=' + rowid + ']');
        calculate_row_amount(sll);
        product_subtotal_calculation();
        final_calculation();
        //changed by anjup for adding common calcluation------->
//        var aa = $(this).closest('tr').find('.qty_direct').val();
//        var bb = $(this).closest('tr').find('.pro_direct').val();
//        var cc = $(this).closest('tr').find('.pro_amount');
//        var zz = $(this).closest('tr').find('.discount').val();
//        var eda = $(this).closest('tr').find('.enterd_dis_amount_direct');
//        var from_disc = $(this).closest('tr').find('.discount').attr('from_disc');
//        if (aa) {
//            var quantity = aa;
//        } else {
//            var quantity = '';
//        }
//        if (bb) {
//            var rate = bb;
//        } else {
//            var rate = '';
//        }
//        if (zz) {
//            var dis = zz;
//        } else {
//            var dis = '0';
//        }
//        var dd = $('#pro_total');
//        var hpt = $('.hidden_pro_total');
//        if (dd) {
//            var tot = dd;
//        } else {
//            var tot = '';
//        }
//        if (eda.val()) {
//            var entered_dis_amount = eda.val();
//        } else {
//            var entered_dis_amount = 0;
//        }
//        if (quantity != "" && rate != "")
//        {
//            if (from_disc == 'per_discount') {
//                var percentage = (parseFloat(rate) * parseFloat(dis) / 100);
//                var qty_percent = (parseFloat(percentage) * parseFloat(quantity));
//                var amt = parseFloat(rate) - parseFloat(percentage);
//                var net = (parseFloat(quantity) * parseFloat(amt));
//                cc.val(parseFloat(net).toFixed(2));
//                eda.val(parseFloat(qty_percent).toFixed(2))
//            } else {
//                var qty_rate = (parseFloat(rate) * parseFloat(quantity));
//                var net = parseFloat(qty_rate) - parseFloat(entered_dis_amount);
//                cc.val(parseFloat(net).toFixed(2));
//                eda.val(parseFloat(entered_dis_amount).toFixed(2))
//            }
//            var sum = 0;
//            $('.pro_amount').each(function () {
//                sum += Number($(this).val());
//            });
//            dd.val(parseFloat(sum).toFixed(2));
//            hpt.val(parseFloat(sum).toFixed(2));
//            $('#common_percentage_amount').trigger("change");
//
//        } else {
//            var amt = 0;
//            cc.val(parseFloat(amt));
//            var sum = 0;
//            $('.pro_amount').each(function () {
//                sum += Number($(this).val());
//            });
//            dd.val(parseFloat(sum).toFixed(2));
//            hpt.val(parseFloat(sum).toFixed(2));
//
//            $('#common_percentage_amount').trigger("change");
//
//        }
//        $(this).closest('tr').find('.discount').attr('from_disc', 'per_discount');
//<-----------------------------------------------------
    });
///////for discount amount///////////////


//    $('body').on('change', '#enterd_dis_amount_direct', function () {
//        var rowid = $(this).parent().parent().parent().attr('id-cl');
//        var sll = $('[id-cl=' + rowid + ']');
//        var aa = $(this).closest('tr').find('.qty_direct');
//        var bb = $(this).closest('tr').find('.pro_direct');
//        var cc = $(this).closest('tr').find('.pro_amount');
//        var zz = $(this).closest('tr').find('.discount');
//        var ida = $(this).closest('tr').find('#enterd_dis_amount_direct');
//        if (aa.val()) {
//            var quantity = aa.val();
//        } else {
//            var quantity = '';
//        }
//        if (bb.val()) {
//            var rate = bb.val();
//        } else {
//            var rate = '';
//        }
//        if (zz.val()) {
//            var dis = zz.val();
//        } else {
//            var dis = '0';
//        }
//        if (ida.val()) {
//            var entered_dis_amount = ida.val();
//        } else {
//            var entered_dis_amount = '';
//        }
//        var total_amount = parseFloat(rate) * parseFloat(quantity);
//        var amt_with_disc_amt = (parseFloat(total_amount) - (entered_dis_amount));
//        if (entered_dis_amount != "" && rate != "")
//        {
//            var percent = (parseFloat(entered_dis_amount) * 100 / parseFloat(total_amount));
//            amt_with_disc_amt
//            if (isNaN(percent)) {
//                var percent = 0;
//            }
//            zz.val(parseFloat(percent).toFixed(2));
//
//        }
//        if (entered_dis_amount == '') {
//            zz.val(0);
//        }
//        zz.attr('from_disc', 'amt_discount');
//        zz.trigger("keyup");
//    });



    $('body').on('click', '.requsition_no', function () {
        $('#jquery_mask').show();
        $.post(siteurl + "/Inventory/Purchase/list_purchase_requsition", function (data)
        {
            $('#jquery_mask').hide();
            $('#requsitionList .modal-body').html(data);
        });
    });
    $('body').on('change', '#grequstion', function ()
    {
        var requsition_id = $(this).val();
        window.location.href = siteurl + "/Inventory/Purchase/new_purchase/" + requsition_id;
    });
    $('body').on('click', '.so_no', function () {
        $('#jquery_mask').show();
        $.post(siteurl + "/Inventory/Purchase/list_so", function (data)
        {
            $('#jquery_mask').hide();
            $('#soList .modal-body').html(data);
        });
    });
    $('body').on('click', '#get_direct_so', function ()
    {
        var so_id = $(this).val();
        window.location.href = siteurl + "/Inventory/Purchase/create_direct_po/" + so_id;
    });
//    $('body').on('change', '#purchase_filter', function () {
//        var purchase_filter = $(this).val();
//        if (purchase_filter == 'all') {
//            window.location.href = siteurl + '/Inventory/Purchase/list_purchaseorder';
//        } else {
//            window.location.href = siteurl + '/Inventory/Purchase/get_purchase_filter/' + purchase_filter;
//        }
//    });
//    $('body').on('change', '#po_filter', function () {
//        var po_filter = $(this).val();
//        if (po_filter == 'all') {
//            window.location.href = siteurl + '/Inventory/Purchase/list_my_purchase_order';
//        } else {
//            window.location.href = siteurl + '/Inventory/Purchase/get_po_filter/' + po_filter;
//        }
//    });
//    $('body').on('change', '#my_purchase_filter', function () {
//        var my_purchase_filter = $(this).val();
//        if (my_purchase_filter == 'all') {
//            window.location.href = siteurl + '/Inventory/Purchase/list_my_purchase_order';
//        } else {
//            window.location.href = siteurl + '/Inventory/Purchase/list_my_purchase_order_filter/' + my_purchase_filter;
//        }
//    });
    $('.status:contains("Open")').addClass('label label-primary-outline');
    $('.status:contains("Completed")').addClass('label label-success-outline');
    $('.status:contains("Partial")').addClass('label label-warning-outline');
    $('.status:contains("partialclose")').addClass('label label-danger-outline');
    $('.status:contains("cancelled")').addClass('label label-danger-outline');
    $('.status:contains("Cancelled")').addClass('label label-danger-outline');
    $('.statuss:contains("Pending")').addClass('label label-warning-outline');
    $('.statuss:contains("Partialbilled")').addClass('label label-primary-outline');
    $('.statuss:contains("Billed")').addClass('label label-success-outline');
    $('.statusss:contains("Open")').addClass('label label-primary-outline');
    $('.statusss:contains("Pending")').addClass('label label-warning-outline');
    $('.statusss:contains("Approved")').addClass('label label-success-outline');
    $('.statusss:contains("Rejected")').addClass('label label-danger-outline');
    $('body').on('click', '#getcmpny', function () {
        var keyword = '';
        $('#jquery_mask').show();
        $.post(siteurl + "/Inventory/Purchase/search_company", {keyword: keyword}
        , function (data) {
            $('#jquery_mask').hide();
            $('#search_result').html(data);
        });
    });
    $('body').on('keyup', '#search_company_keyword', function () {
        var keyword = $('#search_company_keyword').val();
        $('#jquery_mask').show();
        $.post(siteurl + "/Inventory/Purchase/search_company", {keyword: keyword}
        , function (data) {
            $('#jquery_mask').hide();
            $('#search_result').html(data);
        });
    });
    $('body').on('keyup', '#search_vendor_keyword', function () {
        var keyword = $('#search_vendor_keyword').val();
        $('#jquery_mask').show();
        $.post(siteurl + "/Inventory/Purchase/search_vendor", {keyword: keyword}
        , function (data) {
//            console.log(data);
            $('#jquery_mask').hide();
            $('#search_vendor_result').html(data);
        });
    });
    $('body').on('change', '#gvendor', function ()
    {
        var vendor_from = $('#call_from').val();
        if (vendor_from == 'page') {
            var vendor_name = $(this).data('cmpny_name');
            var com_hid_id = $(this).attr('com_hid_id');
            $('#hid_com_id').val(com_hid_id);
            var com_hid_name = $(this).attr('com_hid_name');
            if (com_hid_id) {
                $('#getvendor').val(com_hid_name);
            } else {
                $('#getvendor').val(vendor_name);
            }
            var val = $(this).val();
            $('#getvendor_id').val(val);
            $('#getnewvendor_id').val(val);
            $('#VendorModal').modal('hide');
        } else {
            var vendor_name = $(this).data('cmpny_name');
            var com_hid_id = $(this).attr('com_hid_id');
            $('#hid_com_id').val(com_hid_id);
            var com_hid_name = $(this).attr('com_hid_name');
            if (com_hid_id) {
                $('#noninventoryModal #getvendor').val(com_hid_name);
            } else {
                $('#noninventoryModal #getvendor').val(vendor_name);
            }
            var val = $(this).val();
            $('#noninventoryModal #getvendor_id').val(val);
            $('#noninventoryModal #getnewvendor_id').val(val);
            $('#VendorModal').modal('hide');
        }
    });
////FOR N0N INVENORY PDT SAVE ///
    $('body').on('click', '#btn_addnoninventory', function () {
        var trid = $('#trid').val();
        var nonpro_name = $('#nonpro_name').val();
        var nonpro_sku = $('#nonpro_sku').val();
        var nonpro_vendor = $('#getnewvendor_id').val();
        var nonpro_unit = $('#nonpro_unit').val();
        var unit_code = $('#nonpro_unit option:selected').attr('unit_code');
        var quantity = $('#nonpro_qty').val();
        var nonpro_costprice = $('#nonpro_costprice').val();
        var rate_currency = $('#currency_rate').val();
        var pr_rate_with_currency = parseFloat(rate_currency) * parseFloat(nonpro_costprice);
        var nonpro_markup = $('#nonpro_markup').val();
        var nonpro_sellingprice = $('#nonpro_sellingprice').val();
        var barc_non_inv = $('#barc_non_inv').val();
        var common_barcode_sgc = $('#common_barcode').val();
        var common_barcode_vpc = $('#common_barcode_div').val();
        //anjup for tax-------------->
        var tax_enabled = $('#tax_enabled').val();
        var interstate_tax = -1;
        var intrastate_tax = -1;
        var export_tax = -1;
        var tax_type = 'inclusive';
        if (tax_enabled != -1) {
            interstate_tax = $('#interstate_tax').val();
            intrastate_tax = $('#intrastate_tax').val();
            export_tax = $('#export_tax').val();
            tax_type = $('#noninventoryModal .tax_typein:checked').val();
            var maintax_type = $('.tax_type:checked').val();
        }
//END<------------------------
        if (nonpro_name == "" ) {
            swal("Enter all details");
        } else {
            if (barc_non_inv == 'vpc') {
                $('#jquery_mask').show();
                $.post(siteurl + "/Inventory/Item/check_barcode_for_vpc", {common_barcode: common_barcode_vpc}, function (result) {
                    $('#jquery_mask').hide();
//                    $('#jquery_mask').show();
                    if (result == 1) {
                        swal("This Barcode already exist please change");
                    } else {
                        $('#jquery_mask').show();
                        $.post(siteurl + "/Inventory/Purchase/insert_noninventory", {nonpro_name: nonpro_name, nonpro_sku: nonpro_sku, nonpro_vendor: nonpro_vendor, nonpro_unit: nonpro_unit, nonpro_costprice: nonpro_costprice, nonpro_markup: nonpro_markup, nonpro_sellingprice: nonpro_sellingprice, non_quantity: quantity, tax_enabled: tax_enabled, interstate_tax: interstate_tax, intrastate_tax: intrastate_tax, export_tax: export_tax, tax_type: tax_type, bar_type: barc_non_inv, common_barcode: common_barcode_vpc}, function (result)
                        {
                            $('#jquery_mask').hide();
                            result = result.trim();
                            var sid = $('#noninventoryModal #trid').val();
                            var sll = $('[id-cl=' + sid + ']');
                            var ff = sll.find('.pdt_title');
                            ff.text(nonpro_name);
                            var itm_code = sll.find('.pdt_sku');
                            itm_code.text(nonpro_sku);
//                var itm_code = sll.find('.pdt_sku');  //for po edit
//                itm_code.val(nonpro_sku);
                            var ii = sll.find('.pdt_id');
                            ii.val(result);
                            var ii = sll.find('.itemtaxtype_hidden');
                            ii.val(tax_type);
                            var qq = sll.find('.quan'); //for purchase order
                            qq.val(quantity);
                            var pp = sll.find('.pro_rate'); //for quote
                            pp.val(nonpro_costprice);
                            var uu = sll.find('.pdt_unit'); //for quote
                            uu.text(unit_code);
//                var pu = sll.find('.pdt_unit'); //for PO EDIT
//                pu.val(unit_code);
//                var item_unit_pr = sll.find('.item_unit'); //for PR
//                item_unit_pr.html(unit_code);
//                var item_quuantity = sll.find('.quantity'); //for PR
//                item_quuantity.val(quantity);
//                var type = sll.find('.pdt_type'); //for quote
//                type.val('non-inventory');
//                var ss = sll.find('.selling_p'); //for quote
//                ss.val(nonpro_sellingprice);
//                var sp = sll.find('.s_p'); //for quote
//                sp.val('');
//                var am = sll.find('.amount'); //for quote
//                am.val('');
                            var amt_with_qty = parseFloat(pr_rate_with_currency) * parseFloat(quantity);
                            var pro_am = sll.find('.pro_amount'); //for quote
                            pro_am.val(amt_with_qty);
                            var dis = sll.find('.dis'); //for quote
                            dis.val(0);
                            var ent_dis = sll.find('.enterd_dis_amount'); //for quote
                            ent_dis.val(0);
                            var dd = sll.find('#item_id');
                            dd.val(result).change();
                            var total_pdt = 0;
                            $('body').find('.pro_amount').each(function () {
                                if ($(this).val() != '')
                                {
                                    total_pdt += parseFloat($(this).val());
                                }
                            });
                            //anjup for tax-------------->
                            if (tax_enabled != -1) {
                                bind_taxrate(sll, result);
                            }
                            //END<------------------------
                            $('#pro_total').val(parseFloat(total_pdt).toFixed(2));
                            $('#hidden_pro_total').val(parseFloat(total_pdt));
                            var total_with_currency = (parseFloat(total_pdt) / parseFloat(rate_currency));
                            $('#final_curency_amount').val(parseFloat(total_with_currency).toFixed(2));
                            $('#noninventoryModal').modal('hide');
                            calculate_row_amount(sll);
                            product_subtotal_calculation()
                            final_calculation();
                        });
                    }
                });
            } else {
                $('#jquery_mask').show();
                $.post(siteurl + "/Inventory/Purchase/insert_noninventory", {nonpro_name: nonpro_name, nonpro_sku: nonpro_sku, nonpro_vendor: nonpro_vendor, nonpro_unit: nonpro_unit, nonpro_costprice: nonpro_costprice, nonpro_markup: nonpro_markup, nonpro_sellingprice: nonpro_sellingprice, non_quantity: quantity, tax_enabled: tax_enabled, interstate_tax: interstate_tax, intrastate_tax: intrastate_tax, export_tax: export_tax, tax_type: tax_type, bar_type: barc_non_inv, common_barcode: common_barcode_sgc}, function (result)
                {
                    $('#jquery_mask').hide();
                    result = result.trim();
                    var sid = $('#noninventoryModal #trid').val();
                    var sll = $('[id-cl=' + sid + ']');
                    var ff = sll.find('.pdt_title');
                    ff.text(nonpro_name);
                    var itm_code = sll.find('.pdt_sku');
                    itm_code.text(nonpro_sku);
                    var ii = sll.find('.pdt_id');
                    ii.val(result);
                    var ii = sll.find('.itemtaxtype_hidden');
                    ii.val(tax_type);
                    var qq = sll.find('.quan'); //for purchase order
                    qq.val(quantity);
                    var pp = sll.find('.pro_rate'); //for quote
                    pp.val(nonpro_costprice);
                    var uu = sll.find('.pdt_unit'); //for quote
                    uu.text(unit_code);
                    var amt_with_qty = parseFloat(pr_rate_with_currency) * parseFloat(quantity);
                    var pro_am = sll.find('.pro_amount'); //for quote
                    pro_am.val(amt_with_qty);
                    var dis = sll.find('.dis'); //for quote
                    dis.val(0);
                    var ent_dis = sll.find('.enterd_dis_amount'); //for quote
                    ent_dis.val(0);
                    var dd = sll.find('#item_id');
                    dd.val(result).change();
                    var total_pdt = 0;
                    $('body').find('.pro_amount').each(function () {
                        if ($(this).val() != '')
                        {
                            total_pdt += parseFloat($(this).val());
                        }
                    });
                    //anjup for tax-------------->
                    if (tax_enabled != -1) {
                        bind_taxrate(sll, result);
                    }
                    //END<------------------------
                    $('#pro_total').val(parseFloat(total_pdt).toFixed(2));
                    $('#hidden_pro_total').val(parseFloat(total_pdt));
                    var total_with_currency = (parseFloat(total_pdt) / parseFloat(rate_currency));
                    $('#final_curency_amount').val(parseFloat(total_with_currency).toFixed(2));
                    $('#noninventoryModal').modal('hide');
                    calculate_row_amount(sll);
                    product_subtotal_calculation()
                    final_calculation();
                });
            }
        }
    });
    $('body').on('click', '#btn_addnoninventory_poedit', function () {
        var trid = $('#trid').val();
        var nonpro_name = $('#nonpro_name').val();
        var nonpro_sku = $('#nonpro_sku').val();
        var nonpro_vendor = $('#getnewvendor_id').val();
        var nonpro_unit = $('#nonpro_unit').val();
        var unit_code = $('#nonpro_unit option:selected').attr('unit_code');
        var quantity = $('#nonpro_qty').val();
        var nonpro_costprice = $('#nonpro_costprice').val();
        var rate_currency = $('#currency_rate').val();
        var pr_rate_with_currency = parseFloat(rate_currency) * parseFloat(nonpro_costprice);
        var nonpro_markup = $('#nonpro_markup').val();
        var nonpro_sellingprice = $('#nonpro_sellingprice').val();
        var barc_non_inv = $('#barc_non_inv').val();
        var common_barcode_sgc = $('#common_barcode').val();
        var common_barcode_vpc = $('#common_barcode_div').val();
        //anjup for tax-------------->
        var tax_enabled = $('#tax_enabled').val();
        var interstate_tax = -1;
        var intrastate_tax = -1;
        var export_tax = -1;
        var tax_type = 'inclusive';
        if (tax_enabled != -1) {
            interstate_tax = $('#interstate_tax').val();
            intrastate_tax = $('#intrastate_tax').val();
            export_tax = $('#export_tax').val();
            tax_type = $('#noninventoryModal .tax_typein:checked').val();
            var maintax_type = $('.tax_type:checked').val();
        }
//END<------------------------
        if (nonpro_name == "" || nonpro_sku == "" || nonpro_vendor == "" || nonpro_unit == "0" || unit_code == "" || unit_code == "" || quantity == "" || nonpro_costprice == "" || nonpro_markup == "" || nonpro_sellingprice == "") {
            swal("Enter all details");
        } else {
            if (barc_non_inv == 'vpc') {
                $('#jquery_mask').show();
                $.post(siteurl + "/Inventory/Item/check_barcode_for_vpc", {common_barcode: common_barcode_vpc}, function (result) {
                    $('#jquery_mask').hide();
                    if (result == 1) {
                        swal("This Barcode already exist please change");
                    } else {
                        $('#jquery_mask').show();
                        $.post(siteurl + "/Inventory/Purchase/insert_noninventory", {nonpro_name: nonpro_name, nonpro_sku: nonpro_sku, nonpro_vendor: nonpro_vendor, nonpro_unit: nonpro_unit, nonpro_costprice: nonpro_costprice, nonpro_markup: nonpro_markup, nonpro_sellingprice: nonpro_sellingprice, non_quantity: quantity, tax_enabled: tax_enabled, interstate_tax: interstate_tax, intrastate_tax: intrastate_tax, export_tax: export_tax, tax_type: tax_type, bar_type: barc_non_inv, common_barcode: common_barcode_vpc}, function (result)
                        {
                            $('#jquery_mask').hide();
                            result = result.trim();
                            var sid = $('#noninventoryModal #trid').val();
                            var sll = $('[id-cl=' + sid + ']');
                            var ff = sll.find('.pdt_title');
                            ff.text(nonpro_name);
//                var itm_code = sll.find('.pdt_sku');
//                itm_code.text(nonpro_sku);
                            var itm_code = sll.find('.pdt_sku'); //for po edit
                            itm_code.val(nonpro_sku);
                            var ii = sll.find('.pdt_id');
                            ii.val(result);
                            var qq = sll.find('.quan'); //for purchase order
                            qq.val(quantity);
                            var pp = sll.find('.pro_rate'); //for quote
                            pp.val(nonpro_costprice);
//                var uu = sll.find('.pdt_unit'); //for quote
//                uu.text(unit_code);
                            var pu = sll.find('.pdt_unit'); //for PO EDIT
                            pu.val(unit_code);
//                var item_unit_pr = sll.find('.item_unit'); //for PR
//                item_unit_pr.html(unit_code);
//                var item_quuantity = sll.find('.quantity'); //for PR
//                item_quuantity.val(quantity);
//                var type = sll.find('.pdt_type'); //for quote
//                type.val('non-inventory');
//                var ss = sll.find('.selling_p'); //for quote
//                ss.val(nonpro_sellingprice);
//                var sp = sll.find('.s_p'); //for quote
//                sp.val('');
//                var am = sll.find('.amount'); //for quote
//                am.val('');
                            var amt_with_qty = parseFloat(pr_rate_with_currency) * parseFloat(quantity);
                            var pro_am = sll.find('.pro_amount'); //for quote
                            pro_am.val(amt_with_qty);
                            var dis = sll.find('.dis'); //for quote
                            dis.val(0);
                            var dd = sll.find('#item_id');
                            dd.val(result).change();
                            var total_pdt = 0;
                            $('body').find('.pro_amount').each(function () {
                                if ($(this).val() != '')
                                {
                                    total_pdt += parseFloat($(this).val());
                                }
                            });
                            //anjup for tax-------------->
                            if (tax_enabled != -1) {
                                bind_taxrate(sll, result);
                            }

                            $('#pro_total').val(parseFloat(total_pdt).toFixed(2));
                            $('#hidden_pro_total').val(parseFloat(total_pdt));
                            var total_with_currency = (parseFloat(total_pdt) / parseFloat(rate_currency));
                            $('#final_curency_amount').val(parseFloat(total_with_currency).toFixed(2));
                            $('#noninventoryModal').modal('hide');
                            calculate_row_amount(sll);
                            product_subtotal_calculation()
                            final_calculation();
                            $('#common_percentage').trigger('change');
                        });
                    }
                });
            } else {
                $('#jquery_mask').show();
                $.post(siteurl + "/Inventory/Purchase/insert_noninventory", {nonpro_name: nonpro_name, nonpro_sku: nonpro_sku, nonpro_vendor: nonpro_vendor, nonpro_unit: nonpro_unit, nonpro_costprice: nonpro_costprice, nonpro_markup: nonpro_markup, nonpro_sellingprice: nonpro_sellingprice, non_quantity: quantity, tax_enabled: tax_enabled, interstate_tax: interstate_tax, intrastate_tax: intrastate_tax, export_tax: export_tax, tax_type: tax_type, bar_type: barc_non_inv, common_barcode: common_barcode_sgc}, function (result)
                {
                    $('#jquery_mask').hide();
                    result = result.trim();
                    var sid = $('#noninventoryModal #trid').val();
                    var sll = $('[id-cl=' + sid + ']');
                    var ff = sll.find('.pdt_title');
                    ff.text(nonpro_name);
//                var itm_code = sll.find('.pdt_sku');
//                itm_code.text(nonpro_sku);
                    var itm_code = sll.find('.pdt_sku'); //for po edit
                    itm_code.val(nonpro_sku);
                    var ii = sll.find('.pdt_id');
                    ii.val(result);
                    var qq = sll.find('.quan'); //for purchase order
                    qq.val(quantity);
                    var pp = sll.find('.pro_rate'); //for quote
                    pp.val(nonpro_costprice);
//                var uu = sll.find('.pdt_unit'); //for quote
//                uu.text(unit_code);
                    var pu = sll.find('.pdt_unit'); //for PO EDIT
                    pu.val(unit_code);
//                var item_unit_pr = sll.find('.item_unit'); //for PR
//                item_unit_pr.html(unit_code);
//                var item_quuantity = sll.find('.quantity'); //for PR
//                item_quuantity.val(quantity);
//                var type = sll.find('.pdt_type'); //for quote
//                type.val('non-inventory');
//                var ss = sll.find('.selling_p'); //for quote
//                ss.val(nonpro_sellingprice);
//                var sp = sll.find('.s_p'); //for quote
//                sp.val('');
//                var am = sll.find('.amount'); //for quote
//                am.val('');
                    var amt_with_qty = parseFloat(pr_rate_with_currency) * parseFloat(quantity);
                    var pro_am = sll.find('.pro_amount'); //for quote
                    pro_am.val(amt_with_qty);
                    var dis = sll.find('.dis'); //for quote
                    dis.val(0);
                    var dd = sll.find('#item_id');
                    dd.val(result).change();
                    var total_pdt = 0;
                    $('body').find('.pro_amount').each(function () {
                        if ($(this).val() != '')
                        {
                            total_pdt += parseFloat($(this).val());
                        }
                    });
                    //anjup for tax-------------->
                    if (tax_enabled != -1) {
                        bind_taxrate(sll, result);
                    }

                    $('#pro_total').val(parseFloat(total_pdt).toFixed(2));
                    $('#hidden_pro_total').val(parseFloat(total_pdt));
                    var total_with_currency = (parseFloat(total_pdt) / parseFloat(rate_currency));
                    $('#final_curency_amount').val(parseFloat(total_with_currency).toFixed(2));
                    $('#noninventoryModal').modal('hide');
                    calculate_row_amount(sll);
                    product_subtotal_calculation()
                    final_calculation();
                    $('#common_percentage').trigger('change');
                });
            }
        }
    });
    $("#nonpro_costprice,#nonpro_markup").keyup(function () {

        if ($('#nonpro_markup').val() != "0")
        {
            $('#nonpro_sellingprice').attr('readonly', true);
            var percentage = (parseFloat(($('#nonpro_costprice').val()) * parseFloat($('#nonpro_markup').val())) / 100);
            $('#nonpro_sellingprice').val(parseFloat(percentage) + parseFloat($('#nonpro_costprice').val()));
        } else if ($('#nonpro_markup').val() == "0")
        {
            var costprice = $('#nonpro_costprice').val();
            $('#nonpro_sellingprice').val(costprice);
            $('#nonpro_sellingprice').attr('readonly', false);
        }
    });
    $('body').on('change', '#gcmpny', function ()
    {
        var cmpny_name = $(this).data('cmpny_name');
        $('#getcmpny').val(cmpny_name);
        var val = $(this).val();
        $('#getcmpny_id').val(val);
        $('#CmpnyModal').modal('hide');
    });
    $('body').on('click', '#getcntct', function () {
        var getcmpny_id = $('#getcmpny_id').val();
        if (getcmpny_id == "")
        {
            $('#contactModal .modal-body').html('Select Company First');
            $('#contactModal').modal('hide');
        } else
        {
            $('#jquery_mask').show();
            $.post(siteurl + "/Inventory/Purchase/get_contact", {getcmpny_id: getcmpny_id}, function (data)
            {
                $('#jquery_mask').hide();
                $('#contactModal .modal-body').html(data);
            });
        }
    });
    $('body').on('change', '#gcntct', function ()
    {
        var val = $(this).val();
        var contact_name = $(this).data('name');
        $('#contact_id').val(val);
        $('#getcntct').val(contact_name);
        $('#contactModal').modal('hide');
    });
    $('#po_form').on('submit', function (e) {
        var qty_err = 0;
        var pro_err = 0;
        var rate_err = 0;
        $('#pro_id').each(function () {
            var pro_id = $(this).closest('tr').find('#pro_id').val();
            var qty = $(this).closest('tr').find('#qty').val();
            var pro_rate = $(this).closest('tr').find('#pro_rate').val();
            if (pro_id != '' || pro_id != '0') {
                pro_err++;
            }
            if (qty == '' || qty == '0') {
                qty_err++;
            }
            if (pro_rate == '' || pro_rate == '0') {
                rate_err++;
            }
        });
        if (pro_err == 0) {
            e.preventDefault();
            swal('Alert', 'Please select atleast one item.', 'error');
        }
        if (qty_err != 0) {
            e.preventDefault();
            swal('Alert', 'Please enter quantity.', 'error');
        }
        if (rate_err != 0) {
            e.preventDefault();
            swal('Alert', 'Please enter valid rate.', 'error');
        }
        if ($('.pdt_id').val() == '') {
            e.preventDefault();
            swal('Alert', 'Please pick item.', 'error');
        }
    });
    $('body').on('click', '#btn_add_po', function (e) {
        var ext = $('#attachment').val().split('.').pop().toLowerCase();
        if (ext != '') {
            if ($.inArray(ext, ['pdf', 'png', 'doc', 'txt', 'docx']) == -1) {
                sweetAlert('Invalid File extension!', 'Upload doc or pdf files only');
                e.preventDefault();
            }
        }
        if ($('.deliverto_warehouse').is(':checked')) {
            if ($('.selectwarehouse').val() == 0) {
                e.preventDefault();
                $('.selectwarehouse').focus();
                $('.selectwarehouse').css('border', '1px solid red');
            } else {
                $('.selectwarehouse').css('border', '1px solid rgba(33, 33, 33, 0.12)');
            }
        }
        if ($('.deliverto_customer').is(':checked')) {
            if ($('.getcmpny').val() == '') {
                e.preventDefault();
                $('.getcmpny').focus();
                $('.getcmpny').css('border', '1px solid red');
            } else {
                $('.getcmpny').css('border', '1px solid rgba(33, 33, 33, 0.12)');
            }
        }
        if ($('#getvendor_id').val() == '') {
            sweetAlert('Please Choose Vendor');
            e.preventDefault();
        }

    });
    $('body').on('click', '#btn_update_po', function (e) {
        var ext = $('#a_ttachment').val().split('.').pop().toLowerCase();
        if (ext != '') {
            if ($.inArray(ext, ['pdf', 'png', 'doc', 'txt', 'docx']) == -1) {
                sweetAlert('Invalid File extension!', 'Upload doc or pdf files only');
                e.preventDefault();
            }
        }
        if ($('.deliverto_warehouse').is(':checked')) {
            if ($('.selectwarehouse').val() == 0) {
                e.preventDefault();
                $('.selectwarehouse').focus();
                $('.selectwarehouse').css('border', '1px solid red');
            } else {
                $('.selectwarehouse').css('border', '1px solid rgba(33, 33, 33, 0.12)');
            }
        }
        if ($('.deliverto_customer').is(':checked')) {
            if ($('.getcmpny').val() == '') {
                e.preventDefault();
                $('.getcmpny').focus();
                $('.getcmpny').css('border', '1px solid red');
            } else {
                $('.getcmpny').css('border', '1px solid rgba(33, 33, 33, 0.12)');
            }
        }
    });
    $("body").on('keyup', '#product_name', function () {

        var searchkeyword = $(this).val();
        var option = '';
        var count = 1;
        var sku = '';
        var sellingprice = '';
        for (var i = 0; i < item_json.length; i++) {
            if (item_json[i]['item_type'] == 'inventory' || item_json[i]['item_type'] == 'inventory_and_service' || item_json[i]['item_type'] == 'non-inventory') {
                if (item_json[i]['name'].toLowerCase().indexOf(searchkeyword.toLowerCase()) != -1) {
                    if (item_json[i]['sku'] == null) {
                        sku = '';
                    } else {
                        sku = item_json[i]['sku']
                    }
                    if (item_json[i]['sellingprice'] == null) {
                        sellingprice = '';
                    } else {
                        sellingprice = item_json[i]['sellingprice']
                    }
                    option += '<tr class="sec_grid_tbl">'
                    //option += '<td class="pa-5 vat">' + count + '</td> '
                    option += '<td class="w15 pa-5">' + sku + '</td>'
//                    option += '<td class="pa-5 vat">' + item_json[i]['name'] + '</td>'
                    if (item_json[i]['item_type'] == 'non-inventory') {
                        option += '<td class="w60 pa-5">' + item_json[i]['name'] + '</td>'
                    } else {
                        option += '<td class="w60 pa-5"><a href="" id="itm_id" class="closeopenmodal-sidebar itm_id" item_name="' + item_json[i]['name'] + '" item_id="' + item_json[i]['item_id'] + '">' + item_json[i]['name'] + '</a></td>'

                    }
                    option += '<td class="w10 pa-5 text-center">'
                    if (item_json[i]['item_type'] == 'inventory_and_service') {
                        option += '<span data-tooltip="Inventoy & Services"><i class="icon lindo-023-worldwide fz-20 txt-dgray"></i></span>';
                    } else if (item_json[i]['item_type'] == 'inventory') {
                        option += '<span data-tooltip="Inventory"><i class="icon lindo-shopping-cart-content fz-20 txt-dgray"></i></span>';
                    } else {
                        option += '<span data-tooltip="Non-Inventory"><i class="icon lindo-shopping-bag-1 fz-20 txt-dgray"></i></span>';
                    }
                    option += '</td>'
                    option += '<td class="w10 pa-5">' + Number(sellingprice).toFixed(2) + '</td>'
                    if (item_json[i]['item_type'] == 'non-inventory') {
                        option += '<td class="w5 pa-5"></td>'
                    } else {
                        option += '<td class="w5 pa-5 text-center"><a id="itm_id" class="btn btn-default btn-outline btn-flat closeopenmodal-sidebar itm_id" item_name="' + item_json[i]['name'] + '" item_id="' + item_json[i]['item_id'] + '" data-tooltip="Stock Details"><i class="icon lindo-information-white fz-18"></i></a></td>'
                    }
                    option += '<td class="pa-5 vat">'
                    option += '<label style="display:none;" id="pdt_ser_name' + item_json[i]['item_id'] + '">' + item_json[i]['name'] + '</label>'
                    option += '<input type="hidden" id="pdt_ser_id' + item_json[i]['item_id'] + '" value="' + item_json[i]['item_id'] + '">'
                    option += '<input type="hidden" id="pdt_ser_sku' + item_json[i]['item_id'] + '" value="' + item_json[i]['sku'] + '">'
                    option += '<input type="hidden" id="pdt_ser_sell_price' + item_json[i]['item_id'] + '" value="' + item_json[i]['sellingprice'] + '">'
                    option += '<input type="hidden" id="pdt_ser_pur_price' + item_json[i]['item_id'] + '" value="' + item_json[i]['purchase_price'] + '">'
                    option += '<input type="hidden" id="pdt_ser_unit' + item_json[i]['item_id'] + '" value="' + item_json[i]['unit_code'] + '">'
                    option += '<input type="hidden" id="pdt_ser_type' + item_json[i]['item_id'] + '" value="' + item_json[i]['item_type'] + '">'
                    option += '<input type="hidden" id="tot_qty' + item_json[i]['item_id'] + '" value="' + item_json[i]['total_quantity'] + '">'
                    //         <-----anju for tax------>
                    option += '<input type="hidden" id="interstate_tax' + item_json[i]['item_id'] + '" value="' + item_json[i]['interstate_taxid'] + '">'
                    option += '<input type="hidden" id="intrastate_tax' + item_json[i]['item_id'] + '" value="' + item_json[i]['intrastate_taxid'] + '">'
                    option += '<input type="hidden" id="export_tax' + item_json[i]['item_id'] + '" value="' + item_json[i]['export_taxid'] + '">'
                    option += '<input type="hidden" id="service_tax' + item_json[i]['item_id'] + '" value="' + item_json[i]['service_taxid'] + '">'
                    option += '<input type="hidden" id="item_taxtype' + item_json[i]['item_id'] + '" value="' + item_json[i]['tax_type'] + '">'
                    //         <-----END------>
                    option += '<button type="button" class="btn btn-default btn-outline btn-flat pickitem" data-toggle="tooltip" id="product_search" sl-cl="" sel-id="' + item_json[i]['item_id'] + '"  status="whole"  value="' + item_json[i]['item_id'] + '"><i class="icon lindo-tick fz-18"></i> </button>'
                    option += '</td>'
                    option += '</tr>';
                    count++;
                } else if (item_json[i]['sku'] != null) {
                    if (item_json[i]['sku'].toLowerCase().indexOf(searchkeyword.toLowerCase()) != -1) {
                        if (item_json[i]['sku'] == null) {
                            sku = '';
                        } else {
                            sku = item_json[i]['sku']
                        }
                        if (item_json[i]['sellingprice'] == null) {
                            sellingprice = '';
                        } else {
                            sellingprice = item_json[i]['sellingprice']
                        }
                        option += '<tr class="sec_grid_sm">'
                        option += '<td class="pa-5 vat">' + count + '</td> '
                        option += '<td class="pa-5 vat">' + sku + '</td>'
//                        option += '<td class="pa-5 vat">' + item_json[i]['name'] + '</td>'
                        if (item_json[i]['item_type'] == 'non-inventory') {
                            option += '<td class="pa-5 vat">' + item_json[i]['name'] + '</td>'
                        } else {
                            option += '<td class="pa-5 vat"><a href="" id="itm_id" class="closeopenmodal-sidebar itm_id" item_name="' + item_json[i]['name'] + '" item_id="' + item_json[i]['item_id'] + '">' + item_json[i]['name'] + '</a></td>'

                        }
                        option += '<td class="pa-5 vat">' + item_json[i]['item_type'] + '</td>'
                        option += '<td class="pa-5 vat">' + Number(sellingprice).toFixed(2) + '</td>'
                        option += '<td class="pa-5 vat">'
                        option += '<label style="display:none;" id="pdt_ser_name' + item_json[i]['item_id'] + '">' + item_json[i]['name'] + '</label>'
                        option += '<input type="hidden" id="pdt_ser_id' + item_json[i]['item_id'] + '" value="' + item_json[i]['item_id'] + '">'
                        option += '<input type="hidden" id="pdt_ser_sku' + item_json[i]['item_id'] + '" value="' + item_json[i]['sku'] + '">'
                        option += '<input type="hidden" id="pdt_ser_sell_price' + item_json[i]['item_id'] + '" value="' + item_json[i]['sellingprice'] + '">'
                        option += '<input type="hidden" id="pdt_ser_pur_price' + item_json[i]['item_id'] + '" value="' + item_json[i]['purchase_price'] + '">'
                        option += '<input type="hidden" id="pdt_ser_unit' + item_json[i]['item_id'] + '" value="' + item_json[i]['unit_code'] + '">'
                        option += '<input type="hidden" id="pdt_ser_type' + item_json[i]['item_id'] + '" value="' + item_json[i]['item_type'] + '">'
                        option += '<input type="hidden" id="tot_qty' + item_json[i]['item_id'] + '" value="' + item_json[i]['total_quantity'] + '">'
                        //         <-----anju for tax------>
                        option += '<input type="hidden" id="interstate_tax' + item_json[i]['item_id'] + '" value="' + item_json[i]['interstate_taxid'] + '">'
                        option += '<input type="hidden" id="intrastate_tax' + item_json[i]['item_id'] + '" value="' + item_json[i]['intrastate_taxid'] + '">'
                        option += '<input type="hidden" id="export_tax' + item_json[i]['item_id'] + '" value="' + item_json[i]['export_taxid'] + '">'
                        option += '<input type="hidden" id="service_tax' + item_json[i]['item_id'] + '" value="' + item_json[i]['service_taxid'] + '">'
                        option += '<input type="hidden" id="item_taxtype' + item_json[i]['item_id'] + '" value="' + item_json[i]['tax_type'] + '">'
                        //         <-----END------>
                        option += '<button type="button" class="btn btn-primary btn-flat  pickitem" data-toggle="tooltip" id="product_search" sl-cl="" sel-id="' + item_json[i]['item_id'] + '"  status="whole"  value="' + item_json[i]['item_id'] + '"><i class="icon lindo-tick fz-24 m-p-w"></i> </button>'
                        option += '</td>'
                        if (item_json[i]['item_type'] == 'non-inventory') {
                            option += '<td class="pa-5 vat"></td>'
                        } else {
                            option += '<td class="pa-5 vat text-center"><a id="itm_id" class="closeopenmodal-sidebar itm_id" item_name="' + item_json[i]['name'] + '" item_id="' + item_json[i]['item_id'] + '"><i class="icon lindo-info-circled fz-24"></i></a></td>'

                        }
                        option += '</tr>';
                        count++;
                    }
                }

            }
        }

        $('.itemsearch').html(option);
    });
//<-----------------------------------------------------
    $('body').on('change', '#currency_id', function () {

        var currency_id = $(this).val();
        $.post(siteurl + "/Inventory/Purchase/fetch_currency_rate_by_latest", {currency_id: currency_id}, function (data) {
            var result = JSON.parse(data);
            $('.div_currencyrate').removeClass('no-display');
            $('.currency_rate').val(result.rate);
            $('.cur_trans_rate_id').val(result.cur_trans_rate_id);
            $('.transaction_c_symbol').html(result.currency_symbol);
            var net_amount = $('#pro_total').val();
            if (typeof result.rate === 'undefined' || result.rate == '') {
                result.rate = 1;
            }

            if (net_amount != 'undefined' && net_amount != '') {
                var transaction_currency = parseFloat(net_amount) / parseFloat(result.rate);
                var tr_currency = transaction_currency.toFixed(2);
                $('.final_curency_amount').val(tr_currency);
            }
        });
    });
    $('body').on('change', '#pro_total,#currency_id', function () {

        var final_amount = $('#pro_total').val();
        var currency_rate = $('#currency_rate').val();
        var final_currency_amt = (final_amount / currency_rate);
        var tr_currency = final_currency_amt.toFixed(2);
        $('.final_curency_amount').val(tr_currency);
//        $('.transaction_rate_value span:last').html(tr_currency);

    });
    ////for non inventory vendor///
    $('body').on('click', '#getvendor', function () {
        $('#VendorModal #call_from').val($(this).attr('from'));
    });
    $('body').on('click', '.purchase_req', function (e) {
        var pr_type = $(this).attr("href");
        var vendor_id = $('body').find('#getvendor_id').val();
        console.log(pr_type);
        if (pr_type == '#vendor_PR') {
            if (vendor_id == '') {
                swal('Please Select vendor');
                e.preventDefault();
            } else {
                $.post(siteurl + "/Inventory/Purchase/fetch_pr_details_by_vendor", {vendor_id: vendor_id}, function (data) {
                    var result = JSON.parse(data);
                    console.log(result);
                    var disp = '';
                    if (result) {
                        for (var i = 0; i < result.length; i++)
                        {
                            disp += '<tr class="sec_grid_tbl">';
                            disp += '<td class="w20">' + '<div class="checkbox checkbox-success"><input type="checkbox" class="select_purchasereq" id="select_purchasereq" name="select_purchasereq[]" value="' + result[i]['id'] + '" /><label>&nbsp;</label></div>';
                            disp += '<input type="hidden" class="hidden_vendor_id" id="hidden_vendor_id" name="hidden_vendor_id" value="' + vendor_id + '" />' + '</td>';
                            disp += '<td data-ember-action="" data-ember-action-2438="2438" class="w40">' + result[i]['requisition_no'] + '</td>';
                            disp += '<td data-ember-action="" data-ember-action-2438="2438" class="w40">' + result[i]['expected_date'] + '</td>';
                            disp += '</tr>';
                        }
                    }
                    $('#vendor_pr_det').html(disp);
                });
            }

        }

    });
    $('#btn_import_po').on('click', function () {
        var file = document.getElementById('import_file').files[0];
        var reader = new FileReader();
        reader.onload = function (progressEvent) {
            var lines = this.result.split('\n');
            liness = [];
            for (var k = 0; k < lines.length; k++) {
                if (lines[k] != "") {
                    liness.push(lines[k]);
                }
            }
//            console.log(liness);
            if (liness.length > 0) {
                var line = 0;
                readFile(line, liness);
            }
        };
        reader.readAsText(file);
    });
    function readFile(line, lines) {
        line++;
        if (line < lines.length) {
            var line_data = lines[line].split(',');
            var po_number = line_data[0];
            po_number = po_number.trim();
            var vendor = line_data[1];
            vendor = vendor.trim();
            var vendor_email = line_data[2];
            vendor_email = vendor_email.trim();
            var po_date = line_data[3];
            po_date = po_date.trim();
            var expected_delivery_date = line_data[4];
            expected_delivery_date = expected_delivery_date.trim();
            var delivery_to = line_data[5];
            delivery_to = delivery_to.trim();
            var store = line_data[6];
            store = store.trim();
            var company = line_data[7];
            company = company.trim();
            var contact = line_data[8];
            contact = contact.trim();
            var item_name = line_data[9];
            item_name = item_name.trim();
            var sku = line_data[10];
            sku = sku.trim();
            var rate = line_data[11];
            rate = rate.trim();
            var quantity = line_data[12];
            quantity = quantity.trim();
            var amount = line_data[13];
            amount = amount.trim();
            $('#jquery_mask').show();
            $.ajax({
                url: siteurl + '/Inventory/Purchase/check_po_already_imported',
                method: 'POST',
                data: {po_number: po_number},
                success: function (data) {
                    $('#jquery_mask').hide();
                    data = data.trim();
                    if ($.isNumeric(data)) {
                        var item_id = check_item_existence(item_name, sku, line, lines);
                        save_po_item_import(data, item_id, rate, quantity, amount, line, lines);
                    } else {
                        var store_id = 0;
                        var company_id = 0;
                        var contact_id = 0;
                        if (store != '') {
                            store_id = check_store_existence(store, line, lines);
                        }
                        if (company != '') {
                            company_id = check_company_existence(company, line, lines);
                        }
                        if (contact != '') {
                            contact_id = check_contact_existence(contact, line, lines);
                        }
                        var vendor_id = check_vendor_existence(vendor, vendor_email, line, lines);
                        var item_id = check_item_existence(item_name, sku, line, lines);
                        save_data_in_po(po_number, vendor_id, item_id, po_date, delivery_to, expected_delivery_date, rate, quantity, amount, store_id, company_id, contact_id, line, lines);
                    }
                    readFile(line, lines);
                },
                error: function (a, b, c) {
                    $('#jquery_mask').hide();
                    console.log('line number : ' + line);
                    readFile(line, lines);
                }
            });
        }
    }
    function check_vendor_existence(vendor, vendor_email, line, lines) {
        var result_vendor = 0;
        $('#jquery_mask').show();
        $.ajax({
            url: siteurl + '/Inventory/Purchase/check_vendor_existence',
            method: 'POST',
            dataType: "html",
            async: false,
            data: {vendor: vendor, vendor_email: vendor_email},
            success: function (data) {
                $('#jquery_mask').hide();
                result_vendor = data.trim();
            },
            error: function (a, b, c) {
                $('#jquery_mask').hide();
                console.log('line number : ' + line);
                readFile(line, lines);
            }
        });
        return result_vendor;
    }
    function  check_item_existence(item_name, sku, line, lines) {
        var result_item = 0;
        $('#jquery_mask').show();
        $.ajax({
            url: siteurl + '/Inventory/Purchase/check_item_existence',
            method: 'POST',
            data: {item_name: item_name, sku: sku},
            dataType: "html",
            async: false,
            success: function (data) {
                $('#jquery_mask').hide();
                result_item = data.trim();
                if (data != 0) {
                }
            },
            error: function (a, b, c) {
                $('#jquery_mask').hide();
                console.log('line number : ' + line);
                readFile(line, lines);
            }
        });
        return result_item;
    }
    function  check_store_existence(store, line, lines) {
        var result_store = 0;
        $('#jquery_mask').show();
        $.ajax({
            url: siteurl + '/Inventory/Purchase/check_store_existence',
            method: 'POST',
            data: {store: store},
            dataType: "html",
            async: false,
            success: function (data) {
                $('#jquery_mask').hide();
                result_store = data.trim();
                if (data != 0) {

                }
            },
            error: function (a, b, c) {
                $('#jquery_mask').hide();
                console.log('line number : ' + line);
                readFile(line, lines);
            }
        });
        return result_store;
    }
    function  check_company_existence(company, line, lines) {
        var result_company = 0;
        $('#jquery_mask').show();
        $.ajax({
            url: siteurl + '/Inventory/Purchase/check_company_existence',
            method: 'POST',
            data: {company: company},
            dataType: "html",
            //line added to get ajax response in sync
            async: false,
            success: function (data) {
                $('#jquery_mask').hide();
                result_company = data.trim();
                if (data != 0) {

                }
            },
            error: function (a, b, c) {
                $('#jquery_mask').hide();
                console.log('line number : ' + line);
                readFile(line, lines);
            }
        });
        return result_company;
    }
    function  check_contact_existence(contact, line, lines) {
        var result_contact = 0;
        $('#jquery_mask').show();
        $.ajax({
            url: siteurl + '/Inventory/Purchase/check_contact_existence',
            method: 'POST',
            data: {contact: contact},
            dataType: "html",
            //line added to get ajax response in sync
            async: false,
            success: function (data) {
                $('#jquery_mask').hide();
                result_contact = data.trim();
                if (data != 0) {

                }
            },
            error: function (a, b, c) {
                $('#jquery_mask').hide();
                console.log('line number : ' + line);
                readFile(line, lines);
            }
        });
        return result_contact;
    }
    function save_data_in_po(po_number, vendor_id, item_id, po_date, delivery_to, expected_delivery_date, rate, quantity, amount, store_id, company_id, contact_id, line, lines) {
        $('#jquery_mask').show();
        $.ajax({
            url: siteurl + '/Inventory/Purchase/import_data',
            method: 'POST',
            data: {po_number: po_number, vendor_id: vendor_id, item_id: item_id, po_date: po_date, delivery_to: delivery_to, expected_delivery_date: expected_delivery_date, rate: rate, quantity: quantity, amount: amount, store_id: store_id, company_id: company_id, contact_id: contact_id},
            success: function (data) {
                $('#jquery_mask').hide();
            },
            error: function (a, b, c) {
                $('#jquery_mask').hide();
                console.log('line number : ' + line);
                readFile(line, lines);
            }
        });
    }
    function save_po_item_import(data, item_id, rate, quantity, amount, line, lines) {
        $('#jquery_mask').show();
        $.ajax({
            url: siteurl + '/Inventory/Purchase/save_po_item_import',
            method: 'POST',
            data: {po_id: data, item_id: item_id, rate: rate, quantity: quantity, amount: amount},
            success: function (data) {
                $('#jquery_mask').hide();
            },
            error: function (a, b, c) {
                $('#jquery_mask').hide();
                console.log('line number : ' + line);
                readFile(line, lines);
            }
        });
    }

    $(".datepickerpo").on('change', function () {

        var po_date = $('.po_date').val();
        $('#expected_deviverydate').datepicker('destroy');
        $('#expected_deviverydate').datepicker({
            dateFormat: 'yy-mm-dd',
            minDate: new Date(po_date)
        });
        var current_date_input = $('#expected_deviverydate').val();
        var changed_date = new Date(po_date)
        var current_date = new Date(current_date_input);
        if (changed_date > current_date) {
            $('#expected_deviverydate').val(po_date);
        }

        $('#refdate').datepicker('destroy');
        $('#refdate').datepicker({
            dateFormat: 'yy-mm-dd',
            maxDate: new Date(po_date)
        });
        current_date_input = $('#refdate').val();
        changed_date = new Date(po_date)
        current_date = new Date(current_date_input);
        if (changed_date < current_date) {
            $('#refdate').val(po_date);
        }
    });
    $('#expected_deviverydate').datepicker({
        dateFormat: 'yy-mm-dd',
        minDate: new Date()
    });
    $('body').on('click', '#getvendor', function ()
    {
        var pagecheck = "pagejs";
        $('#jquery_mask').show();
        $.post(siteurl + "/Inventory/Purchase/search_vendor/" + pagecheck, {pagecheck: pagecheck}
        , function (data) {
            console.log(data);
            $('#jquery_mask').hide();
            $('#search_vendor_result').html(data);
        });
    });
    $('body').on('click', '.submit_mrv_a', function () {
        var po_id = $(this).attr('po_id');
        $('#get_po').val(po_id);
        $('#createmrv_form').submit();
    });
    $('body').on('click', '#view_history', function () {
        var iditem = $(this).attr('iditem');
        var check = $(this).attr('check');
        $('.history_table_details').html();
        var option = '';
        if (iditem != '') {
            $.post(siteurl + "/Inventory/Item/item_history_by_id/", {iditem: iditem}, function (data) {
                var json_array = JSON.parse(data);
                console.log(json_array.length);
                option += '<thead>';
                option += '<th>PO NUMBER</th>';
                option += '<th>MRV NUMBER</th>';
                option += '<th>BILL NUMBER</th>';
                option += '<th>MRV DATE</th>';
                option += '<th>COST OF ITEM</th>';
                option += '</thead><tbody>';
                for (var i = 0; i < json_array.length; i++) {
                    if (json_array[i].po_number == null) {
                        json_array[i].po_number = '';
                    }
                    if (json_array[i].mrv_number == null) {
                        json_array[i].mrv_number = '';
                    }
                    if (json_array[i].bill_no == null) {
                        json_array[i].bill_no = '';
                    }
                    if (json_array[i].mrv_date == null) {
                        json_array[i].mrv_date = '';
                    }
                    if (json_array[i].cost_of_item == null) {
                        json_array[i].cost_of_item = '';
                    }
                    option += '<tr>';
                    option += '<td>' + json_array[i].po_number + '</td>';
                    option += '<td>' + json_array[i].mrv_number + '</td>';
                    option += '<td>' + json_array[i].bill_no + '</td>';
                    option += '<td>' + json_array[i].mrv_date + '</td>';
                    option += '<td>' + json_array[i].cost_of_item + '</td>';
                    option += '</tr>';
                }
                option += '</tbody>';
                $('.history_table_details').html(option);
            });
        } else {
            option += '<thead>';
            option += '<th>PO NUMBER</th>';
            option += '<th>MRV NUMBER</th>';
            option += '<th>BILL NUMBER</th>';
            option += '<th>MRV DATE</th>';
            option += '<th>COST OF ITEM</th>';
            option += '</thead>';
            $('.history_table_details').html(option);
        }
    });

    $('body').on('change', '#selectbrand', function (e) {
        var brand_id = $(this).val();
        $.post(siteurl + "/Inventory/Item/generate_sku", {brand_id: brand_id}, function (result) {
            $('.sku_chk').val(result);
        });
    });
});
//commmon functions 
function calculate_row_amount(sll) {
    var aa = sll.find('#qty');
    var bb = sll.find('#pro_rate');
    var cc = sll.find('#pro_amount');
    var zz = sll.find('#discount');
    var zl = sll.find('.enterd_dis_amount');
    if (zl.val()) {
        var discount_amnt = zl.val();
    } else {
        var discount_amnt = '0';
    }
    if (aa.val()) {
        var quantity = aa.val();
    } else {
        var quantity = '';
    }
    if (bb.val()) {
        var rate = bb.val();
    } else {
        var rate = '';
    }
    if (zz.val()) {
        var dis = zz.val();
    } else {
        var dis = '0';
    }
    var dd = $('#pro_total');
    if (dd.val()) {
        var tot = dd.val();
    } else {
        var tot = '';
    }
    if (quantity == "")
    {
        quantity = '0';
    }
    if (rate == "")
    {
        rate = '0';
    }
    if (quantity != "" && rate != "")
    {
        var taxamnt = 0;
        var amt = parseFloat(rate);
        var net2 = (parseFloat(quantity) * parseFloat(amt));
        var enterd_dis_amount = sll.find('.enterd_dis_amount').val();
        var pro_amount = sll.find('.pro_amount').val();
        var percent = (parseFloat(enterd_dis_amount) * 100 / parseFloat(net2));
        if (isNaN(percent)) {
            var percent = 0;
        }
        sll.find('.dis').val(parseFloat(percent).toFixed(2));
        var percentage = (parseFloat(rate) * parseFloat(dis) / 100);
        var percentage = discount_amnt;
        var net = parseFloat(net2) - parseFloat(discount_amnt);
        var tax_enabled = $('#tax_enabled').val();
        if (tax_enabled != -1) {
            taxamnt = tax_calculation(sll, net);
        }
        cc.val(parseFloat(net + taxamnt).toFixed(2));
    }
}
function final_calculation() {
    var currency_rate = $('.currency_rate').val();
    var common_percentage_amount = $('.common_percentage_amount').val();
    var pdttaxmasteramount = 0;
    $('.pdttaxmasteramount').each(function () {
        pdttaxmasteramount += parseFloat($(this).val());
    });
    var nettaxamount = parseFloat(pdttaxmasteramount);
    $('#ttltax_amount').val(nettaxamount.toFixed(2));
    var sum = 0;
    var dd = $('#pro_total');
    if (dd.val()) {
        var tot = dd.val();
    } else {
        var tot = '';
    }
    $('.pro_amount').each(function () {
        sum += Number($(this).val());
    });

//    var sum=Number(sum1)-Number(common_percentage_amount);
    dd.val(parseFloat(sum).toFixed(2));
    $('#hidden_pro_total').val(parseFloat(sum).toFixed(2));
    var final_amount = $('#pro_total').val();
    var currency_rate = $('#currency_rate').val();
    var final_currency_amt = (final_amount / currency_rate);
    var tr_currency = final_currency_amt.toFixed(2);
    $('.final_curency_amount').val(tr_currency);
}
//anjup for tax---------->

function bind_taxrate(sll, id) {
    var tax_type = $('input[name=tax_type]:checked').val();
    var interstate_tax = $('#interstate_tax' + id).val();
    var intrastate_tax = $('#intrastate_tax' + id).val();
    var export_tax = $('#export_tax' + id).val();
    var service_tax = $('#service_tax' + id).val();
    var item_taxtype = sll.find('.itemtaxtype_hidden').val();
    var msp = sll.find('.prorate_hidden').val();
    if (typeof (interstate_tax) == 'undefined') {
        interstate_tax = $('#interstate_tax').val();
        intrastate_tax = $('#intrastate_tax').val();
        export_tax = $('#export_tax').val();
        service_tax = $('#service_tax').val();
//        msp = $('#nonpro_sellingprice').val();
        msp = sll.find('.prorate_hidden').val();
    }
    if (msp == 'NaN') {
        msp = 0;
    }
    var key_exist = 0;
    console.log(product_taxarray);
    if (product_taxarray != null) {
        for (const [key, value] of Object.entries(product_taxarray)) {
            if (key == id) {
                key_exist = 1;
            }
        }
    } else {
        product_taxarray = [];
    }
    if (key_exist == 0) {
        product_taxarray[id] = {interstate_tax: interstate_tax, intrastate_tax: intrastate_tax, export_tax: export_tax, service_tax: service_tax};
    }
    console.log(product_taxarray);
    sll.find('.pdttax').val('');
    var sellingprice = 0;
    for (const [key_pdtid, value_tax] of Object.entries(product_taxarray)) {
        if (key_pdtid == id) {
            for (const [key, value] of Object.entries(tax_details)) {
                console.log(key, value);
                if (tax_type == 'intra_state') {
                    if (key == value_tax['intrastate_tax']) {
                        var ttlrate = 0;
                        for (var ii = 0; ii < value.length; ii++) {
                            console.log(sll.find('.tax_details_' + value[ii]['tax_masterid']));
                            sll.find('.selected_product_taxgrp').val(value_tax['intrastate_tax']);
                            sll.find('.tax_details_' + value[ii]['tax_masterid']).val(value[ii]['tax_rate'] + '% :\n0');
                            ttlrate += parseFloat(value[ii]['tax_rate']);
                        }
                        sellingprice = (100 * parseFloat(msp)) / (100 + ttlrate);
                    }
                } else if (tax_type == 'inter_state') {
                    if (key == value_tax['interstate_tax']) {
                        var ttlrate = 0;
                        for (var ii = 0; ii < value.length; ii++) {
                            console.log(sll.find('#taxmaster_id_' + value[ii]['tax_masterid']));
                            sll.find('.selected_product_taxgrp').val(value_tax['interstate_tax']);
                            sll.find('.tax_details_' + value[ii]['tax_masterid']).val(value[ii]['tax_rate'] + '% :\n0');
                            ttlrate += parseFloat(value[ii]['tax_rate']);
                        }
                        sellingprice = (100 * parseFloat(msp)) / (100 + ttlrate);
                    }
                } else if (tax_type == 'export') {
                    if (key == value_tax['export_tax']) {
                        var ttlrate = 0;
                        for (var ii = 0; ii < value.length; ii++) {
                            console.log(sll.find('#taxmaster_id_' + value[ii]['tax_masterid']));
                            sll.find('.selected_product_taxgrp').val(value_tax['export_tax']);
                            sll.find('.tax_details_' + value[ii]['tax_masterid']).val(value[ii]['tax_rate'] + '% :\n0');
                            ttlrate += parseFloat(value[ii]['tax_rate']);
                        }
                        sellingprice = (100 * parseFloat(msp)) / (100 + ttlrate);
                    }
                }
            }
        }
    }
    if (item_taxtype == 'exclusive') {
        sll.find('#pro_rate').val(parseFloat(msp).toFixed(2));
    } else {
        sll.find('#pro_rate').val(sellingprice.toFixed(2));
    }
}

function tax_calculation(sll, net) {
    var selected_array = [];
    var selected_pdtgrpid = sll.find('.selected_product_taxgrp').val();
    var totaltax_amount = 0;
    for (const [key, value] of Object.entries(tax_details)) {
        if (key == selected_pdtgrpid) {
            for (var ii = 0; ii < value.length; ii++) {
                selected_array.push(value[ii]['tax_masterid']);
                var taxrate = value[ii]['tax_rate'];
                var tax_amount = (parseFloat(taxrate) / 100) * parseFloat(net);
                totaltax_amount += tax_amount;
                console.log(sll.find('#tax_masterid_' + value[ii]['tax_masterid']));
                sll.find('#tax_masterid_' + value[ii]['tax_masterid']).val(value[ii]['tax_rate'] + '% :\n' + tax_amount.toFixed(2));
            }
            var finalnet_amount = parseFloat(net) + parseFloat(totaltax_amount);
        }
    }
    return totaltax_amount;
}

function product_subtotal_calculation() {
    var tax_enabled = $('#tax_enabled').val();
    if (tax_enabled != -1) {
        for (var i = 0; i < alltax_details.length; i++) {
            var totaltaxmaster_amount = 0;
            $('.tax_details_' + alltax_details[i].tax_master_id).each(function () {
                var taxamount_i = 0;
                if ($(this).val() != '') {
                    var res = $(this).val().split(':');
                    if (res.length > 1) {
                        taxamount_i = Number(res[1]);
                    }
                }
                totaltaxmaster_amount += taxamount_i;
            });
            $('#totalpro_tax_' + alltax_details[i].tax_master_id).val(totaltaxmaster_amount);
        }
    }
    var pro_total = 0;
    var pro_dis_amt = 0;
    $('.amount').each(function () {
        if ($(this).val() != '') {
            pro_total += parseFloat($(this).val());
        }
    });
    $('.item_disc_amt').each(function () {
        if ($(this).val() != '') {
            pro_dis_amt += parseFloat($(this).val());
        }

    });
    var pdttaxmasteramount = 0;
    $('.pdttaxmasteramount').each(function () {
        pdttaxmasteramount += parseFloat($(this).val());
    });
    var nettaxamount = parseFloat(pdttaxmasteramount);
    $('#ttltax_amount').val(nettaxamount.toFixed(2));
    $('#pro_total').val(pro_total);
    $('#pro_dis').val(pro_dis_amt);
}
//END<--------------------
