$(document).ready(function () {
    $(window).load(function () {
        if (typeof old_rate !== 'undefined' && typeof new_rate !== 'undefined' && parseFloat(old_rate) != '' && parseFloat(old_rate) != parseFloat(new_rate)) {
            swal({
                title: "Transaction Rate Changed",
                text: "Do you want to apply the new rate",
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "Yes, Apply !",
                cancelButtonText: "No, don't apply !",
                closeOnConfirm: false,
                closeOnCancel: false
            },
                    function (isConfirm) {
                        if (isConfirm) {
                            $('.currency_rate').val(new_rate);
                            $('.cur_trans_rate_id').val(new_cur_trans_rate_id);
                            swal("Rate Changed", "New Rate applied", "success");
                        } else {
                            swal("Cancelled", "Previous Rate will prevail", "success");
                        }
                    });
        }
    });
    $('body').on('click', '#search_do_keyword', function () {
        var search_do_keywords = $('#search_do_keywords').val();
        var from_date_list = $('.from_date_list').val();
        var to_date_list = $('.to_date_list').val();
        var created_by_p = $('#created_by_p').val();
        if (search_do_keywords == '' && from_date_list == '' && to_date_list == '' && created_by_p=='') {
            swal("Please check any filter");
            $('#search_so_keywords').css('border', '1px solid red');
        } else if (from_date_list == '' && search_do_keywords == '' && created_by_p=='')
        {
            swal("Please select from date");
        } else if (to_date_list == '' && search_do_keywords == '' && created_by_p=='')
        {
            swal("Please select to date");
        } else {
            $('#filtersubmit').submit();
        }
    });
    $("#btn_billgo").on('click', function ()
    {
        var bill_number = $('#bill_number').val();
        if (bill_number == "")
        {
            swal('Enter Bill No.');
        } else {
            window.location.href = siteurl + "/Inventory/Purchase_return/new_purchasereturn/" + bill_number;
        }
    });

    $("#btn_mrv_go").on('click', function ()
    {
        var mrv_number = $('#mrv_number').val();

        if (mrv_number == "")
        {
            swal('Enter MRV No.');
        } else {

            window.location.href = siteurl + "/Inventory/Purchase_return/new_sales_return_by_mrv/" + mrv_number;
        }
    });

    $('body').on('change', '#currency_id', function () {
        var currency_id = $(this).val();
        $('.currency_rate').val('');
        $.post(siteurl + "/Inventory/Purchase_return/fetch_currency_rate_by_latest", {currency_id: currency_id}, function (data) {
            var result = JSON.parse(data);
            $('.div_currencyrate').removeClass('no-display');
            $('.currency_rate').val(result.rate);
            $('.cur_trans_rate_id').val(result.cur_trans_rate_id);
            var net_amount = $('#net_amt').val();
            if (typeof result.rate === 'undefined' || result.rate == '') {
                result.rate = 1;
            }
            if (net_amount != 'undefined' && net_amount != '') {
                var transaction_currency = parseFloat(net_amount) * parseFloat(result.rate);
                var tr_currency = transaction_currency.toFixed(2);
                $('#transaction_currency').val(tr_currency);
                $('.transaction_rate_value span').html(tr_currency);
            }
        });
    });


    $('body').on('click', '#ck_select', function () {
        if ($(this).is(":checked")) {
            var rowid = $(this).parent().parent().attr('id-cl');
            var sll = $('[id-cl=' + rowid + ']');
            var aa = sll.find('#qty_returned');
            aa.attr('readonly', false);
        } else {

            var rowid = $(this).parent().parent().attr('id-cl');
            var sll = $('[id-cl=' + rowid + ']');
            var aa = sll.find('#qty_returned');
            var amount = sll.find('#amount');
            var error = sll.find('#error');
            error.hide();
            aa.attr('readonly', true);
            aa.val('0');
            amount.val('0');
            var sum = 0;
            $('.amount').each(function () {
                sum += Number($(this).val());

            });
            var tt = $('#net_amt');
            tt.val(parseFloat(sum));
        }
    });
    $('body').on('click', '#ck_select2', function () {
        if ($(this).is(":checked"))
        {
            var rowid = $(this).parent().parent().attr('id-cl');
            var sll = $('[id-cl=' + rowid + ']');
            var aa = sll.find('#qty_recived2');
            aa.attr('readonly', false);
        } else {
            var rowid = $(this).parent().parent().attr('id-cl');
            var sll = $('[id-cl=' + rowid + ']');
            var aa = sll.find('#qty_recived2');
            aa.attr('readonly', true);
            aa.val('');
        }
    });

    $('body').on('blur', '#qty_returned', function () {
        $(".moneyholder3").trigger("change");
    });

    $('body').on('keyup', '.qty_returned', function () {
        var rowid = $(this).closest('tr').attr('id-cl');
        var sll = $('[id-cl=' + rowid + ']');
        var aa = sll.find('#qty_returned');
        var qty_inv = sll.find('#qty');
        var bb = sll.find('#rate');
        var cc = sll.find('#amount');
        var fg = sll.find('.product_id');
        var transaction_rate = $('.currency_rate').val();
        var tax_enabled = $('#tax_enabled').val();
        var tax_amnt = 0;

        if (aa.val()) {
            var quantity = aa.val();
        } else {
            var quantity = '';
        }
        if (fg.val()) {
            var id = fg.val();
        } else {
            var id = '';
        }

        if (qty_inv.val()) {
            var qty_inv = qty_inv.val();
        } else {
            var qty_inv = '';
        }

        if (bb.val()) {
            var rate = bb.val();

        } else {
            var rate = '';
        }
        var ff = $('#net_amt');


        var error = sll.find('#error');
        if (parseFloat(parseFloat(qty_inv)) < (parseFloat(quantity)))
        {
            error.show();
            aa.val('');
            cc.val('');
            sll.find('.barcodes').html('');
            sll.find('.storeids').val('');
            sll.find('.hidden_mpn').val('');
            sll.find('.hidden_itmcondition').val('');
            sll.find('.hidden_qtys').val('');
        } else if (quantity != "" && rate != "")
        {
            error.hide();
            var net = (parseFloat(quantity) * parseFloat(rate));

            
            var tax_amnt = 0;
            if (tax_enabled) {
                if (tax_enabled != -1) {

                    tax_amnt = tax_calculation(sll, net);
                    product_subtotal_calculation();
                    find_total();
                }
            }
            var sum = parseFloat(net) + parseFloat(tax_amnt);
            cc.val(sum.toFixed(2));
            find_total();
        } else {
            error.hide();
            var amt = 0;
            cc.val(parseFloat(0));
            var sum = 0;
            $('.amount').each(function () {
                sum += Number($(this).val());
            });
            $('#net_amt').val(parseFloat(sum));
            var transaction_currency = parseFloat(sum) * parseFloat(transaction_rate);
            $('#transaction_currency').val(transaction_currency.toFixed(2));
        }

    });
    $('body').on('click', '#add_barcode', function () {

        var store_list = "";
        $('#jquery_mask').show();
        var item_quantity_exist = false;
        var item_id_array = [];
        $('.check_item').each(function () {
            var item_qty = ($(this).closest('tr').find('.qty_returned').val());
            if (item_qty > 0) {
                item_quantity_exist = true;
                var item_id = ($(this).val());
                var track_barc_type = $(this).closest('tr').find('.barcode_type').val();
                var track = $(this).closest('tr').find('.enable_tracking').val();
                if ((track == 1 && track_barc_type == 'sgu') || (track == 1 && track_barc_type == 'vpu')) {
                } else {
                    item_id_array.push(item_id);
                }
            }
        });
        var itemid_string = JSON.stringify(item_id_array);
        $.post(siteurl + "/Inventory/Delivery_order/get_store_dropdown", {itemids: itemid_string}, function (data)
        {
            $('#jquery_mask').hide();
            store_list = data;
            var disp = "";
            var cnt_qty = 0;
            $('.qty_returned').each(function () {
                cnt_qty += Number($(this).val());

            });

            if (cnt_qty > 0) {
                disp += '<tr class="t-h-bgt">\n\
            <th>Sl No</label></th>\n\
            <th>Item</label></th>\n\
            <th>Condition</label></th>\n\
            <th>Store</label></th>\n\
               \n\</tr>';
            }
            $('.return_sale').each(function () {
                if ($(this).find('.check_item').prop('checked'))
                {
                    var sale_type = $('#bill_type').val();
                    console.log(sale_type);
                    var billno = $('.bill_number').val();
                    var mrv_number = $('.mrv_number').val();
                    var bill_id = $('.billid').val();
                    var return_quan = $(this).closest('tr').find('#qty_returned').val();
                    var enable_tracking = $(this).closest('tr').find('.enable_tracking').val();
                    var barcode_type = $(this).closest('tr').find('.barcode_type').val();
                    var partial_js = $(this).closest('tr').find('.partial_enable').val();
                    var itemid = $(this).closest('tr').find('.check_item').val();
                    var product_name = $(this).closest('tr').find('.product_name').val();
                    var store_id = $(this).closest('tr').find('.store_id').val();
                    var invoice_status = $(this).closest('tr').find('.invoice_status').val();
                    var amount = $(this).closest('tr').find('.amount').val();
                    var rate = $(this).closest('tr').find('#rate').val();
                    var tot = $(this).closest('tr').find('.total_quantity').val();
                    var bill_status = $(this).closest('tr').find('.bill_status').val();
                    var amount1 = amount / return_quan;
                    $('.store_list').val(store_id);
                    for (var i = 0; i < return_quan; i++) {
                        if ((enable_tracking == 1 && barcode_type == 'sgu') || (enable_tracking == 1 && barcode_type == 'vpu')) {

                            disp += '<tr class="sec_grid brcd">\n\
                            <td>';
                            if (partial_js == 1) {
                                disp += '<input type="hidden" name="part_js[]" value="1">';
                            } else {
                                disp += '<input type="hidden" name="part_js[]" value="0">';
                            }
                            disp += '<input type="hidden" name="tracking_barcode[]" value="1"><input type="hidden" class="barcode_type_hidden"  name="barcode_type_hidden[]" value="' + barcode_type + '"><input type="hidden" value="' + tot + '" name="tot_qua[]" id="tot_qua"><input type="hidden" value="' + return_quan + '" name="returnquantity[]" id="returnqtty" ><input type="hidden" value="1" name="returnquantitys[]" id="returnqttys" ><input type="hidden" value="' + amount1 + '" name="amou[]" id="amou"><input type="hidden" value="' + rate + '" name="fullamount[]"  class="fullamount" id="fullamount"><input type="hidden" value="' + rate + '" name="rate1[]" id="rate1"><input placeholder="Serial Number" required class="form-control barcode_enter barcode_enter blurcheck benter' + i + '" type="text" name="mpn[]"></td>\n\
                            <td><input type="hidden" class="mpn_item_id" id="mpn_item_id" name="mpn_item_id[]" value="' + itemid + '"><input readonly class="form-control" type="text" value="' + product_name + '" name="item_mpn[]" id="item_mpn"></td>\n\
                            <td class="salesreturn_table"><select class="form-control" name="item_condition[]"><option value="good">good</option><option value="damaged">damaged</option></select></td>';
                            disp += '<td class="salesreturn_table"><select class="form-control store_list"  name="store[]"><option>select store</option></select></td>">';
//                            disp += '<td><select class="form-control methodused"  name="methodused[]"><option value="0">select</option>';
//                            if (billno == undefined || billno == '')
//                            {
//                                disp += '<option value="cancel">Cancel</option>';
//                            } else
//                            {
//                                if (sale_type != "Credit") {
//
//                                } else {
//                                    if (bill_status == "DRAFT")
//                                    {
//                                        disp += '<option value="cancel">Cancel</option>';
//                                    } else if (bill_status == "PARTIALPAID") {
//                                        disp += '<option value="refund">Refund</option><option value="credit">Credit</option>';
//                                    } else if (bill_status == "PAID") {
//                                        disp += '<option value="refund">Refund</option><option value="credit">Credit</option>';
//                                    }
//                                }
//                            }
//                            disp += '</select><td>&nbsp;</td></tr>';
                        }
                    }

                    if (enable_tracking == 0 || (enable_tracking == 1 && barcode_type == 'sgc') || (enable_tracking == 1 && barcode_type == 'vpc')) {
                        disp += '<tr class="splitnot' + itemid + ' brcd">\n\
                        <td>';
                        if (partial_js == 1) {
                            disp += '<input type="hidden" name="part_js[]" value="1">';
                        } else {
                            disp += '<input type="hidden" name="part_js[]" value="0">';
                        }
                        disp += '<input type="hidden" name="tracking_barcode[]" value="0"><input type="hidden" class="barcode_type_hidden"  name="barcode_type_hidden[]" value="' + barcode_type + '"><input type="hidden" value="' + tot + '" name="tot_qua[]" id="tot_qua"><input type="hidden" value="' + return_quan + '" name="returnquantity[]" id="returnqtty" ><input type="hidden" value="' + return_quan + '" name="returnquantitys[]" id="returnqttys" ><input type="hidden" value="' + amount + '" name="amou[]" id="amou"><input type="hidden" value="' + rate + '" name="fullamount[]" id="fullamount" class="fullamount"><input type="hidden" value="' + rate + '" name="rate1[]" id="rate1"><input placeholder="Serial Number" readonly class="form-control barcode_enter barcode_enter blurcheck benter' + i + '" type="text" name="mpn[]"></td>\n\
                        <td><input type="hidden" class="mpn_item_id" id="mpn_item_id" name="mpn_item_id[]" value="' + itemid + '"><input readonly class="form-control" type="text" value="' + product_name + '" name="item_mpn[]"></td>\n\
                        <td class="salesreturn_table"><select class="form-control" name="item_condition[]"><option value="good">good</option><option value="damaged">damaged</option></select><input type="hidden" value="' + invoice_status + '" name="inv_stat[]" id="inv_stat"></td>';
                        disp += '<td class="salesreturn_table"><select class="form-control store_list"  name="store[]"><option>select store</option></select></td>';
//                        disp += '<td><select class="form-control methodused"  name="methodused[]"><option value="0">select</option>';
//                        if (billno == undefined || billno == '')
//                        {
//                            disp += '<option value="cancel">Cancel</option>';
//                        } else
//                        {
//                            if (sale_type != "Credit") {
//
//                            } else {
//                                if (bill_status == "DRAFT")
//                                {
//                                    disp += '<option value="cancel">Cancel</option>';
//                                } else if (bill_status == "PARTIALPAID") {
//                                    disp += '<option value="refund">Refund</option><option value="credit">Credit</option>';
//                                } else if (bill_status == "PAID") {
//                                    disp += '<option value="refund">Refund</option><option value="credit">Credit</option>';
//                                }
//                            }
//                        }
//                        disp += '</select></td><td class="salesreturn_table"><a class="btn btn-flat bg-green pull-right form-control" splitclassid="splitnot1065" id="split_btn" item_id="' + itemid + '" amnt="' + amount + '" rate="' + rate + '" partial_js="' + partial_js + '" qtyforloop="' + return_quan + '" product_name="' + product_name + '" billno="' + billno + '" bill_status="' + bill_status + '" href="#"><i class="material-icons mt-5 mr-5 fz-15 m-p-w pull-left" >shuffle</i><h6 class="fz-15 m-p-w">Split</h6></a></td></tr>';
                    }

                }
            });
            $('#mpn_tbody').append(disp);
//            $('.store_list').html(data);
            $('.brcd').each(function () {
                var opt = '';
                var store_array = JSON.parse(data);
                var item_each_id = ($(this).find('#mpn_item_id').val());
                for (var key in store_array) {
                    if (store_array[key]['item_id'] == item_each_id)
                        opt += '<option value="' + store_array[key]['store_id'] + '">' + store_array[key]['store_name'] + '</option>';
                }
                $(this).find('.store_list').html(opt);
            });

            $('#add_barcode').hide();
        });
    });
    $('body').on('click', '.check_item_pr', function (e) {
        if ($(this).is(':checked')) {

        } else {
            $(this).closest('tr').find('.amount').val(0);
            product_subtotal_calculation()
            find_total();
        }
    })
    $('body').on('click', '.save_purchase_return', function (e) {
        var flag_len = 0;
        var flag_qty = 0;
        var len = $('.check_item_pr:checkbox:checked').length;

        if (len == 0)
        {
            swal('Please select atleast one item', "");
            flag_len = 1;
        }

        $('.check_item_pr:checked').each(function () {
            var quant = $(this).closest('tr').find('.qty_returned').val();
            if (quant == 0) {
                flag_qty = 1;
                swal('Alert', 'Please enter valid return quantity.', 'error');

                $(this).closest('tr').find('.qty_returned').css('border', '1px solid rgb(247, 12, 12)');
                return;
            }
        });

        if (flag_qty == 0 && flag_len == 0) {
            $('#purchase_return_form').submit();
        }
    });
//    $('body').on('click', '.save_purchase_return', function (e) {
//        var mpn = new Array();
//        var mpn_item_id = new Array();
//        var tracking_barcode = new Array();
//        var mrv_id = $('#mrv_id').val();
//        var bill_number = $('#bill_id').val();
//        $('.mpn_item_id').each(function () {
//            mpn_item_id.push($(this).val());
//        });
//        var item_list = JSON.stringify(mpn_item_id);
//        $('#jquery_mask').show();
//        $.post(siteurl + "/Inventory/Purchase_return/fetch_returned_barcode", {mrv_id: mrv_id, item_list: item_list, bill_number: bill_number}, function (data)
//        {
//            var bar_array=[];
//            $('#jquery_mask').hide();
//            var barcode_db_array = new Array();
//            var json_array = JSON.parse(data);
//            var flag = 0;
//             for (var i in json_array) { 
//                 var dat = json_array[i];
//                 for (var j in dat) { 
//                    bar_array[j]= dat[j]['barcode'];
//                 }
//             }
//            $('.barcode_enter').each(function () {
//                var mpn = $(this).val();
//                var item_id = $(this).closest('tr').find('.mpn_item_id').val();
//                var type = $(this).closest('tr').find('.barcode_type_hidden').val();
//                if (type == "sgu" || type == "vpu") {
//                    for (var i in json_array) { 
//                        var itemdates = i;
//                        var dates = json_array[i];
//                        if (item_id == itemdates) {
//                            if ($.inArray(mpn,bar_array) !== -1) {
//                                 flag = 1;
//                            } else {
//                                flag = 0;
//                                    swal({
//                                        title: "INVALID BARCODE !!!",
//                                        text: "try again !!! "
//                                    });
//                                    $(this).closest('tr').find('.barcode_enter').focus();
//                                    $(this).closest('tr').find('.barcode_enter').css('border', '1px solid red');
//                                    $(this).closest('tr').find('.barcode_enter').val('');
//                                    break;
//                            }
//                        }
//                    }
//                }
//
//            });
//            if (flag == 1) {
//                $('#purchase_return_form').submit();
//            }
//        });
//    });
    $('body').on('change', '.bill_select', function () {
        var bill_number = $(this).val();
        window.location.href = siteurl + "/Inventory/Purchase_return/new_purchasereturn/" + bill_number;
    });
    $('body').on('click', '#split_btn', function () {
        var qty = $(this).attr('qtyforloop');
        var itemid = $(this).attr('item_id');
        var partial_js = $(this).attr('partial_js');
        var amnt = $(this).attr('amnt');
        var rate = $(this).attr('rate');
        var bill_status = $(this).attr('bill_status');
        var billno = $(this).attr('billno');
        var product_name = $(this).attr('product_name');
        var splitcls = 'splitnot' + itemid;
        var disp = '';
        $('#jquery_mask').show();
        $.post(siteurl + "/Inventory/Mrv/get_store_dropdown", {}, function (data)
        {
            $('#jquery_mask').hide();
            for (var i = 0; i < qty; i++)
            {
                disp += '<tr class="sec_grid">\n\
                            <td >';
                if (partial_js == 1) {
                    disp += '<input type="hidden" name="part_js[]" value="1">';
                } else {
                    disp += '<input type="hidden" name="part_js[]" value="0">';
                }
                disp += '<input type="hidden" name="tracking_barcode[]" value="0"><input type="hidden" value="' + qty + '" name="returnquantity[]" id="returnqtty" ><input type="hidden" value="1" name="returnquantitys[]" id="returnqttys" ><input type="hidden" value="' + amnt + '" name="fullamount[]" id="fullamount" class="fullamount"><input type="hidden" value="' + amnt + '" name="amou[]" id="amou"><input type="hidden" value="' + rate + '" name="rate1[]" id="rate1"><input placeholder="Serial Number" readonly class="form-control barcode_enter barcode_enter blurcheck benter' + i + '" type="text" name="mpn[]"></td>\n\
                            <td><input type="hidden" id="mpn_item_id" name="mpn_item_id[]" value="' + itemid + '"><input readonly class="form-control" type="text" value="' + product_name + '" name="item_mpn[]"></td>\n\
                            <td class="salesreturn_table"><select class="form-control" name="item_condition[]"><option value="good">good</option><option value="damaged">damaged</option></select><input type="hidden" value="" name="inv_stat[]" id="inv_stat"></td>';
                disp += '<td class="salesreturn_table"><select class="form-control store_list"  name="store[]"><option>select store</option></select></td>';
                disp += '<td><select class="form-control methodused"  name="methodused[]"><option value="">select</option>';
                if (billno == undefined || billno == '')
                {
                    disp += '<option value="cancel">Cancel</option>';
                } else
                {
                    if (bill_status == "DRAFT")
                    {
                        disp += '<option value="cancel">Cancel</option>';
                    } else if (bill_status == "PARTIALPAID") {
                        disp += '<option value="refund">Refund</option><option value="credit">Credit</option>';
                    } else if (bill_status == "PAID") {
                        disp += '<option value="refund">Refund</option><option value="credit">Credit</option>';
                    }
                }
                disp += '</td></tr>';
            }
            $('#mpn_tbody').append(disp);
            $('.' + splitcls + '').remove();
            $('.store_list').html(data);

        });
    });
    $('body').on('change', '.methodused', function () {
        var method = $(this).val();
        var paid_amt = $('.paidamountbill').val();
        var sum = 0;
        if (method == 'refund' || method == 'credit')
        {
            $(this).each(function () {
                if ($(this).val() == 'refund' || $(this).val() == 'credit')
                {
                    sum += Number($(this).closest('tr').find('.fullamount').val());
                }
            });
            if (sum > paid_amt)
            {
                $(this).val("");
                swal({
                    title: "CHECK ANOTHER PAYMENT METHOD !!!",
                });
            }


        }


    });
    $('body').on('click', '#add_barcode2', function ()
    {

        var store_list = "";
        $('#jquery_mask').show();
        $.post(siteurl + "/Inventory/Mrv/get_store_dropdown", {}, function (data)
        {
            $('#jquery_mask').hide();
            store_list = data;
            var cnt_qty = 0;
            var tracking = 0;
            $('.qty_recived2').each(function () {
                cnt_qty += Number($(this).val());
            });

            var disp = "";
            if (cnt_qty > 0) {
                disp += '<tr>\n\
<th>SL Number</label></th>\n\
<th>Item</label></th>\n\
<th>Item Condition</label></th>\n\
<th>Extra Price</label></th>\n\
<th>Store</label></th>\n\
\n\</tr>';
            }
            $('.check').each(function () {
                if ($(this).prop('checked'))
                {
                    var qty = $(this).closest('tr').find('#qty_recived2').val();
                    var partial_enabled = $(this).closest('tr').find('#partial_enabled').val();
                    var partial_qty = $(this).closest('tr').find('#total_quantity').val();
                    var qty = $(this).closest('tr').find('#qty_recived2').val();
                    var item_id = $(this).val();
                    var item_name = $(this).attr('itm_name');
                    var p_return_item_id = $(this).attr('p_return_item_id');
                    var tracking = $(this).attr('tracking');
                    var item_rate = $(this).attr('itm_rate');
                    var extracharge_total = $('#extracharge_total').val();
                    var ex_price = extracharge_total / cnt_qty;
                    $('#add_barcode2').hide();


                    for ($i = 0; $i < qty; $i++)
                    {
                        if (tracking == 1)
                        {
                            disp += '<tr>\n\
<td><input type="hidden" name="p_return_item_id[]" value="' + p_return_item_id + '"/><input type="hidden" name="tracking_barcode[]" value="1"><input placeholder="SL Number" required class="form-control barcode_enter  barcode_enter' + $i + '" type="text" name="mpn[]" ></td>\n\
<td><input type="hidden" name="mpn_item_id[]" value="' + item_id + '"><input type="hidden" id="tbl_qty"name="qty[]" value="' + qty + '"><input type="hidden" id="partial"name="partial[]" value="' + partial_enabled + '"><input type="hidden" id="partial_qty"name="partial_qty[]" value="' + partial_qty + '"><input readonly class="form-control" type="text" value="' + item_name + '" name="item_mpn[]"></td>\n\
<td><select class="form-control" name="item_condition[]"><option>good</option><option>damaged</option></select>\n\
<input type="hidden" readonly class="form-control" value="' + item_rate + '" placeholder="" name="actual_item_price[]"></td>\n\
<td><input type="text" class="form-control" placeholder="extra price" value="' + ex_price + '" name="item_price[]"></td>\n\
<td><select class="form-control store_list"  name="store[]"><option>select store</option></select></td><td><a class="remove_mpn text-danger" href="javascript:void(0);"><i class="material-icons">remove_circle</i></a></td></tr>';
                        } else if (tracking == 0)
                        {
                            disp += '<tr>\n\
<td><input type="hidden" name="p_return_item_id[]" value="' + p_return_item_id + '"/><input type="hidden" name="tracking_barcode[]" value="0"><input type="text" readonly class="form-control barcode_enter  barcode_enter' + $i + '" type="text" name="mpn[]" ></td>\n\
<td><input type="hidden" name="mpn_item_id[]" value="' + item_id + '"><input type="hidden" id="tbl_qty"name="qty[]" value="' + qty + '"><input type="hidden" id="partial"name="partial[]" value="' + partial_enabled + '"><input type="hidden" id="partial_qty"name="partial_qty[]" value="' + partial_qty + '"><input readonly class="form-control" type="text" value="' + item_name + '" name="item_mpn[]"></td>\n\
<td><select class="form-control" name="item_condition[]"><option>good</option><option>damaged</option></select>\n\
<input type="hidden" readonly class="form-control" value="' + item_rate + '" placeholder="" name="actual_item_price[]"></td>\n\
<td><input type="text" class="form-control" placeholder="extra price" value="' + ex_price + '" name="item_price[]"></td>\n\
<td><select class="form-control store_list" name="store[]"><option>select store</option></select></td><td><a class="remove_mpn text-danger" href="javascript:void(0);"><i class="material-icons">remove_circle</i></a></td></tr>';
                        }
                    }
                }
            });
            $('#mpn_tbody').append(disp);
            $('.store_list').html(data);
        });
    });

    $('body').on('keyup', '#qty_recived2', function () {

        var rowid = $(this).parent().parent().attr('id-cl');
        var sll = $('[id-cl=' + rowid + ']');
        var aa = sll.find('#qty_recived2');
        if (aa.val()) {
            var re_quantity = aa.val();
        }
        var cc = sll.find('#error');
        if ((parseFloat(re_quantity)) > 1)
        {

            cc.show();
            aa.val('');
        } else {
            cc.hide();
        }
    });
    $('body').on('click', '.mrv_submit_button', function (e) {
        $('#jquery_mask').show();
        $.post(siteurl + "/Inventory/Mrv/get_barcode_details", {}, function (data)
        {
            $('#jquery_mask').hide();
            var count_err = 0;
            var flag = 0;
            var json_array = JSON.parse(data);
            var mpn = new Array();
            flag = 0;
            var tracking_barcode = new Array();
            $("input[name='mpn[]']").each(function () {
                mpn.push($(this).val());
            });
            $("input[name='tracking_barcode[]']").each(function () {
                tracking_barcode.push($(this).val());
            });
            for (var i = 0; i < mpn.length; i++)
            {
                if (tracking_barcode[i] == 1) {
                    if ($.inArray(mpn[i], json_array.barcodes) == -1)
                    {
                        var count_err = 0;
                        $('.barcode_enter' + i).css('border', '1px solid rgba(33, 33, 33, 0.12)');
                        var checked = 0;
                        $('.check').each(function ()
                        {
                            if ($(this).closest('tr').find('#ck_select').prop('checked')) {
                                checked++;
                                if ($(this).val() == '0' || $(this).val() == '' || isNaN($(this).val())) {
                                    count_err++;
                                }
                            }
                        });
                        if (count_err > 0) {
                            e.preventDefault();
                            swal('Alert', 'Please enter valid issue quantity.', 'error');
                        }
                        flag = 1;
                    } else
                    {
                        if (tracking_barcode[i] == 1) {
                            swal({
                                title: "BARCODE ALREADY EXIST!!!",
                                text: "try again !!! "

                            });
                        }
                        e.preventDefault();
                        $('.barcode_enter' + i).focus();
                        $('.barcode_enter' + i).css('border', '1px solid red');
                        $('.barcode_enter' + i).val('');
                        flag = 0;
                        break;
                    }
                } else {
                    flag = 1;
                }

            }
            if (flag == 1) {
                $('#mrv_form').submit();
            }
        });
    });
    $('body').on('click', '.charge_new', function ()
    {
        $('#Othercharges')
                .find("input[type=text],textarea,select")
                .val('')
                .end()
                .find("input[type=checkbox]")
                .prop("checked", "")
                .end();
        var selid = $(this).closest('tr').attr('id-cl_charge');
        $("#trid_charge").val(selid);
    });
    $('body').on('click', '#new_charges', function () {
        var charge_id = $('#asso_extra_chrg').val();
        var charge_description = $('#charge_discription').val();
        var charge_type = $("input[name='charge_bill_type']:checked").val();
        var charge_bill_number = $('#charge_bill_number').val();
        var charge_amount = $('#charge').val();
        var charge_paidby = $("input[name='charge_paid_by']:checked").val();
        var chrg_name = $('#asso_extra_chrg option:selected').attr('charg_name');
        var sid = $('#trid_charge').val();
        var sll = $('[id-cl_charge=' + sid + ']');
        var ff = sll.find('.associated_chrg_id');
        ff.val(charge_id);
        var chrg = sll.find('.charge_name_t');
        chrg.text(chrg_name);
        var paid_by = sll.find('.charge_paidby');
        paid_by.val(charge_paidby);
        var amountt = sll.find('.charge_amount_t');
        amountt.text(charge_amount);
        if (charge_paidby == "company") {
            var ii = sll.find('.charge_amount');
            ii.val(charge_amount);
        }
        var qq = sll.find('.charge_description');
        qq.val(charge_description);
        var bill = sll.find('.charge_bill_no');
        bill.val(charge_bill_number);
        var type = sll.find('.charge_type');
        type.val(charge_type);
        var sum = 0;
        if (charge_paidby == "company") {

            $('.charge_amount').each(function () {
                sum += Number($(this).val());
                $('#extracharge_total').val(sum);
            });
        }
        $('#Othercharges').modal('hide');
    });
    $('body').on('click', '.copyorgmember_charge', function (e) {
        e.preventDefault();
        var clid = $(".cld_charge:last").attr('id-cl_charge');
        var nxt = parseFloat(clid) + 1;
        var bc = $(".clone_charge").clone();
        bc.attr("id-cl_charge", nxt);
        var dd = bc.find("input");
        bc.find(".charge_name_t").text('');
        bc.find(".charge_amount_t").text('');
        dd.val("");
        bc.removeClass('clone_charge');
        bc.find('.clear_charge').remove();
        var cc = bc.find('.no-display');
        cc.removeClass('no-display');
        bc.appendTo(".table-append_charge");
    });
    $('body').on('click', '.clear_charge', function (e) {
        e.preventDefault();
        $(this).closest('tr').find('input,select,checkbox').val('');
        $(this).closest('tr').find('.charge_name_t').text('');
        $(this).closest('tr').find('.charge_amount_t').text('');
    });
    $('body').on('click', '.removeorgmember_charge', function (e) {
        e.preventDefault();
        $(this).closest('tr').remove();
    });
    $('body').on('change', '.qty_returned', function () {
        $("#net_amt").trigger("change");
    });

    $('body').on('change', '#net_amt', function () {

        var net_amount = $('#net_amt').val();

        var transaction_rate = $('.currency_rate').val();
        if (transaction_rate == 'undefined' && transaction_rate == '') {
            transaction_rate = 1;
        }

        if (net_amount != 'undefined' && net_amount != '') {
            var transaction_currency = parseFloat(net_amount) * parseFloat(transaction_rate);
            var tr_currency = transaction_currency.toFixed(2);
            $('#transaction_currency').val(tr_currency);
        }
    });
    $('body').on('click', '.pagesubmit', function (e) {
        e.preventDefault();
        var from_date_list = $('#from_date_list').val();
        var to_date_list = $('#to_date_list').val();
        var search_do_keywords = $('#search_do_keywords').val();
        var created_by_p = $('#created_by_p').val();
        $('#frmdate').val(from_date_list);
        $('#todate').val(to_date_list);
        $('#keywd').val(search_do_keywords);
        $('#cr_by').val(created_by_p);
        var url = $(this).attr('href');
        $('#paginationfilter').attr('action', url);
        $('#paginationfilter').submit();
    });
    function tax_calculation(sll, net) {
        var selected_array = [];
        var cc = sll.find('.amount');
        var totaltax_amount = 0;
        var selected_pdtgrpid = sll.find('.selected_product_taxgrp').val();
        for (const [key, value] of Object.entries(tax_details)) {

            if (key == selected_pdtgrpid) {
                for (var ii = 0; ii < value.length; ii++) {
                    selected_array.push(value[ii]['tax_masterid']);
                    var taxrate = value[ii]['tax_rate'];
                    var tax_amount = (parseFloat(taxrate) / 100) * parseFloat(net);
                    totaltax_amount += tax_amount;
                    sll.find('#tax_masterid_' + value[ii]['tax_masterid']).val(value[ii]['tax_rate'] + '% :\n' + tax_amount.toFixed(2));
                }
                var finalnet_amount = parseFloat(net) + parseFloat(totaltax_amount);
//            cc.val(finalnet_amount);
            }
        }
        return totaltax_amount;

    }
    function product_subtotal_calculation() {


        var tax_enabled = $('#tax_enabled').val();
        if (tax_enabled != -1) {
            for (var i = 0; i < alltax_details.length; i++) {
                var totaltaxmaster_amount = 0;
                $('.tax_details_' + alltax_details[i].tax_master_id).each(function () {
                    if ($(this).closest('tr').find('.check_item_pr').is(":checked")) {
                        var taxamount_i = 0;
                        if ($(this).val() != '') {
                            var res = $(this).val().split(':');
                            taxamount_i = Number(res[1]);
                        }
                        totaltaxmaster_amount += taxamount_i;
                    }
                });

                $('#totalpro_tax_' + alltax_details[i].tax_master_id).val(totaltaxmaster_amount.toFixed(2));
            }
        }
    }
    function find_total() {
        var pdttaxmasteramount = 0;
        $('.pdttaxmasteramount').each(function () {
            pdttaxmasteramount += parseFloat($(this).val());
        });
        var nettaxamount = parseFloat(pdttaxmasteramount);
        $('.ttltax_amount').val(nettaxamount);
        var sum = 0;
        var transaction_rate = $('.currency_rate').val();
        $('.amount').each(function () {
            sum += Number($(this).val());
        });
        $('#net_amt').val(parseFloat(sum));
        var net_amount = $('#net_amt').val();
        if (transaction_rate == 'undefined' && transaction_rate == '') {
            transaction_rate = 1;
        }

        if (net_amount != 'undefined' && net_amount != '') {
            var transaction_currency = parseFloat(net_amount) * parseFloat(transaction_rate);
            var tr_currency = transaction_currency.toFixed(2);
            $('#transaction_currency').val(tr_currency);
        }
    }
});
