$(document).ready(function () {

    $('body').on('click', '#storedelete', function () {
        var store_id = $(this).attr('store_id');
        var s = $(this).closest('tr');
        swal({
            title: "Are you sure?",
            text: "You are going to delete this Store",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes, delete !",
            cancelButtonText: "No, don't delete !",
            closeOnConfirm: false,
            closeOnCancel: false
        },
                function (isConfirm) {
                    if (isConfirm) {
                        $('#jquery_mask').show();
                        $.ajax({
                            url: siteurl + '/Inventory/Stores/delete_store',
                            data: {store_id: store_id},
                            cache: false,
                            datatype: "json",
                            type: "post",
                            success: function (d) {
                                $('#jquery_mask').hide();
                                $(s).remove();
                                //$(this).closest('.list-group').remove();
                                swal("Deleted!", "Store has been deleted.", "success");
                            },
                            fail: function (d) {
                                $('#jquery_mask').hide();
                                swal("Cannot delete!", "Store cannot be deleted.", "error");
                            }
                        });
                    } else {
                        swal("Cancelled", "Store is not deleted ", "error");
                    }
                });
        return false;
    });
    $("body").on('keyup', '#product_name', function () {
        var searchkeyword = $(this).val();
        var option = '';
        var type = '';
        var sel_price = '';
        var count = 1;
        for (var i = 0; i < item_json.length; i++) {
            if (item_json[i]['item_type'] == 'inventory' || item_json[i]['item_type'] == 'inventory_and_service') {
                if (item_json[i]['name'].toLowerCase().indexOf(searchkeyword.toLowerCase()) != -1) {

                    if (item_json[i]['item_type'] == 'inventory_and_service') {
                        type = 'inventory and service'
                    } else {
                        type = item_json[i]['item_type'];
                    }
                    sel_price = Number(item_json[i]['sellingprice']).toFixed(2);
                    option += '<tr class="sec_grid_tbl">'
                    option += '<td class="w5 pa-5 text-center">' + count + '</td> '
                    option += '<td class="w25 pa-5">' + item_json[i]['sku'] + '</td>'
                    option += '<td class="w25 pa-5">' + item_json[i]['name'] + '</td>'
                    option += '<td class="w20 pa-5">' + type + '</td>'
                    option += '<td class="w20 pa-5">' + sel_price + '</td>'
                    option += '<td class="w5 pa-5 text-center">'
                    option += '<label style="display:none;" id="pdt_ser_name' + item_json[i]['item_id'] + '">' + item_json[i]['name'] + '</label>'
                    option += '<input type="hidden" id="pdt_ser_id' + item_json[i]['item_id'] + '" value="' + item_json[i]['item_id'] + '">'
                    option += '<input type="hidden" id="pdt_ser_sku' + item_json[i]['item_id'] + '" value="' + item_json[i]['sku'] + '">'
                    option += '<input type="hidden" id="pdt_ser_sell_price' + item_json[i]['item_id'] + '" value="' + item_json[i]['sellingprice'] + '">'
                    option += '<input type="hidden" id="pdt_ser_pur_price' + item_json[i]['item_id'] + '" value="' + item_json[i]['purchase_price'] + '">'
                    option += '<input type="hidden" id="pdt_ser_unit' + item_json[i]['item_id'] + '" value="' + item_json[i]['unit_code'] + '">'
                    option += '<input type="hidden" id="pdt_ser_type' + item_json[i]['item_id'] + '" value="' + item_json[i]['item_type'] + '">'
                    option += '<input type="hidden" id="tot_qty' + item_json[i]['item_id'] + '" value="' + item_json[i]['total_quantity'] + '">'
                    option += '<input type="hidden" id="opening_stock' + item_json[i]['item_id'] + '" value="' + item_json[i]['openingstock'] + '">'
                    option += '<button type="button" class="btn btn-default btn-outline btn-flat pickitem" data-toggle="tooltip" id="product_search" sl-cl="" sel-id="' + item_json[i]['item_id'] + '"  status="whole"  value="' + item_json[i]['item_id'] + '"><i class="icon lindo-tick fz-18"></i> </button>'
                    option += '</td>'
                    option += '</tr>';
                    count++;

                }
            }
        }
        $('.itemsearch').html(option);
    });
    $("body").on('click', '.pickitem', function (e) {
        var id = $(this).attr('sel-id');
        var occurence = 0;
        $('#invoice_table .pdt_id').each(function () {
            if ($(this).val() == id) {
                occurence++;
            }
        });
        if (occurence > 0) {
            swal('Alert', 'This item already picked', 'error');
            return false;
        }
        var item_name = $('#pdt_ser_name' + id).text();
        var item_pur = $('#pdt_ser_pur_price' + id).val();
        var item_sell = $('#pdt_ser_sell_price' + id).val();
        var item_unit = $('#pdt_ser_unit' + id).val();
        var item_sku = $('#pdt_ser_sku' + id).val();
        var item_type = $('#pdt_ser_type' + id).val();
        var item_id = $(this).val();
        var opening_stock = $('#opening_stock' + id).val();
        $('#item_select').val(item_name);
        $('#item_id').val(item_id);
        $('#purchase_price').val(item_pur);
        $('#openingstock').val(opening_stock);
        $("#item_Modal").modal('toggle');
        $('#productlist').modal('hide');

    });
    $('body').on('click', '#item_select', function () {
        $('#productlist').modal('show');
        var new_array = [];
        var option = '';
        var type = '';
        var sel_price = '';
        var count = 1;
        for (var i = 0; i < item_json.length; i++) {
            if (item_json[i]['item_type'] == 'inventory' || item_json[i]['item_type'] == 'inventory_and_service') {
                new_array.push(item_json[i]);
            }
        }
        var length1 = 10;
        if (new_array.length < 10) {
            length1 = new_array.length;
        }

        for (var i = 0; i < length1; i++) {
            if (new_array[i]['item_type'] == 'inventory_and_service') {
                type = 'inventory and service'
            } else {
                type = new_array[i]['item_type'];
            }
            sel_price = Number(new_array[i]['sellingprice']).toFixed(2);

            option += '<tr class="sec_grid_tbl">'
            option += '<td class="w5 pa-5 text-center">' + count + '</td> '
            option += '<td class="w25 pa-5">' + new_array[i]['sku'] + '</td>'
            option += '<td class="w25 pa-5">' + new_array[i]['name'] + '</td>'
            option += '<td class="w20 pa-5">' + type + '</td>'
            option += '<td class="w20 pa-5">' +sel_price + '</td>'
            option += '<td class="w5 pa-5 text-center">'
            option += '<label style="display:none;" id="pdt_ser_name' + new_array[i]['item_id'] + '">' + new_array[i]['name'] + '</label>'
            option += '<input type="hidden" id="pdt_ser_id' + new_array[i]['item_id'] + '" value="' + new_array[i]['item_id'] + '">'
            option += '<input type="hidden" id="pdt_ser_sku' + new_array[i]['item_id'] + '" value="' + new_array[i]['sku'] + '">'
            option += '<input type="hidden" id="pdt_ser_sell_price' + new_array[i]['item_id'] + '" value="' + new_array[i]['sellingprice'] + '">'
            option += '<input type="hidden" id="pdt_ser_pur_price' + new_array[i]['item_id'] + '" value="' + new_array[i]['purchase_price'] + '">'
            option += '<input type="hidden" id="pdt_ser_unit' + new_array[i]['item_id'] + '" value="' + new_array[i]['unit_code'] + '">'
            option += '<input type="hidden" id="pdt_ser_type' + new_array[i]['item_id'] + '" value="' + new_array[i]['item_type'] + '">'
            option += '<input type="hidden" id="tot_qty' + new_array[i]['item_id'] + '" value="' + new_array[i]['total_quantity'] + '">'
            option += '<input type="hidden" id="opening_stock' + new_array[i]['item_id'] + '" value="' + new_array[i]['openingstock'] + '">'
            option += '<button type="button" class="btn btn-default btn-outline btn-flat pickitem" data-toggle="tooltip" id="product_search" sl-cl="" sel-id="' + new_array[i]['item_id'] + '"  status="whole"  value="' + new_array[i]['item_id'] + '"><i class="icon lindo-tick fz-18"></i> </button>'
            option += '</td>'
            option += '</tr>';
            count++;

        }
        $('.itemsearch').html(option);
    });
    $('body').on('click', '#default_store', function () {
        if ($(this).is(':checked')) {
            $('#jquery_mask').show();
            $.post(siteurl + '/Inventory/Stores/get_store_by_businessunit', function (data) {
                $('#jquery_mask').hide();
                if (data != 0) {
                    swal({
                        title: "This Unit Already Have A Default Store",
                        text: "Do you want to make this store as default store?",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonColor: "#DD6B55",
                        confirmButtonText: "Yes !",
                        cancelButtonText: "No!",
                        closeOnConfirm: false,
                        closeOnCancel: false
                    },
                            function (isConfirm) {
                                if (isConfirm) {
                                    $('.previous_default').val(data);
                                    swal("Default store!", "Store has been made default", "success");
                                } else {
                                    $('.default_store').prop('checked', false);
                                    $('.previous_default').val('0');
                                    swal("Cancelled", "Store is not made default ", "error");
                                }
                            });
                }
                return false;
            });
        }
    });
    $('body').on('click', '#storetypedelete', function () {
        var store_type_id = $(this).attr('store_type_id');
        var s = $(this).closest('tr');
        swal({
            title: "Are you sure?",
            text: "You are going to delete this Store",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes, delete !",
            cancelButtonText: "No, don't delete !",
            closeOnConfirm: false,
            closeOnCancel: false
        },
                function (isConfirm) {
                    if (isConfirm) {
                        $('#jquery_mask').show();
                        $.ajax({
                            url: siteurl + '/Inventory/Stores/delete_store_type',
                            data: {store_type_id: store_type_id},
                            cache: false,
                            datatype: "json",
                            type: "post",
                            success: function (d) {
                                $('#jquery_mask').hide();
                                $(s).remove();
                                swal("Deleted!", "Store has been deleted.", "success");
                            },
                            fail: function (d) {
                                $('#jquery_mask').hide();
                                swal("Cannot delete!", "Store cannot be deleted.", "error");
                            }
                        });
                    } else {
                        swal("Cancelled", "Store is not deleted ", "error");
                    }
                });
        return false;
    });

    $('#storefrom').on('change', function () {
        var storefrom_id = $(this).val();
        $('#stockrepobody').html('');
        var storeto_id = $('#storeto').val();

        var option = '<option value="">select</option>';
        for (var i = 0; i < all_stores.length; i++) {
            if (storefrom_id != all_stores[i].store_id) {
                option += '<option value="' + all_stores[i].store_id + '"';
                if (storeto_id != '' && all_stores[i].store_id == storeto_id) {
                    option += ' selected="selected" ';
                }
                option += '>' + all_stores[i].store_name + '</option>';
            }
        }
        $('#storeto').html(option);
        if (storefrom_id != '') {
            $('#jquery_mask').show();
            $.post(siteurl + '/Inventory/Stores/get_storeitemsajax', {store_id: storefrom_id}, function (data) {
                $('#jquery_mask').hide();
                var result = JSON.parse(data);
                var tablerow = '';
                for (var i = 0; i < result.length; i++) {
                    tablerow += '<tr class="sec_grid_tbl stockrepobody">';
                    tablerow += '<td class="w5 pa-2 text-center">' + (i + 1) + '</td>';
                    tablerow += '<td class="w75 pa-2 itemname">' + result[i].name + '</td>';
                    tablerow += '<td class="w15 pa-2 text-center availableqty">' + result[i].quantity + '</td>';
                    tablerow += '<td class="w5 pa-2"><input type="hidden" class="storeitem_id" name="storeitem_id[]" value="' + result[i].item_id + '" /><input type="hidden" class="stockstore_id" name="stockstore_id[]" value="' + result[i].id + '" />';
                    tablerow += '<div class="ma-0 pa-0">';
                    tablerow += '<input type="number" step="0.01" min="0" class="form-control check_qty number_validate"  name="qty_trnsfer[]" value="">';
                    tablerow += '<input type="hidden" class="form-control tracking_enabled" name="tracking_enabled[]" value="' + result[i].enable_tracking + '">';
                    tablerow += '<input type="hidden" class="form-control partial_selling" name="partial_selling[]" value="' + result[i].partial_selling + '">';
                    tablerow += '</div>';
                    tablerow += '</td>';
                    tablerow += '</tr>';
                }
                $('#stockrepobody').html(tablerow);
            });
        }
    });

    $('#transfersubmit').on('click', function () {
        var flag = false;
        var dat = $('#dat').val();
        $(".barcode_enter").attr("required", true);
        $('.check_qty').each(function () {
            if ($(this).val() > 0) {
                flag = true;
            }
        });
        if (!flag) {
            swal("Error!", "Transfer quantity is zero.", "error");
        } else
        if ($('#storefrom').val() == '') {
            flag = false;
            swal("Error!", "Please select store from.", "error");
        } else
        if ($('#storeto').val() == '') {
            flag = false;
            swal("Error!", "Please select store to.", "error");
        } else if (dat == '') {
            swal("Error!", "Please select a date.", "error");
            flag = false;
        } else {
            $('.barcode_enter').each(function () {
                if ($(this).val() == '') {
                    swal("Error!", "Please add barcode.", "error");
                    flag = false;
                }

            });
            var barcode_enter = $('.barcode_enter').val();
            if (barcode_enter == undefined || barcode_enter == '') {
                swal("Error!", "Please add barcode.", "error");
                flag = false;

            }
        }

        if (flag)
            $('#transferform').submit();

    });

    $('#stockrepobody').on('keyup', '.check_qty', function () {
        var available = $(this).parents('tr').find('.availableqty').html();
        var transferqty = $(this).val();
        if (parseFloat(transferqty) > parseFloat(available)) {
            $(this).val('0');
            swal("Error!", "Transfer quantity greater than available quantity.", "error");
        }
    });
    $('#stockrepobody').on('change', '.check_qty', function () {
        var available = $(this).parents('tr').find('.availableqty').html();
        var transferqty = $(this).val();
        if (parseFloat(transferqty) > parseFloat(available)) {
            $(this).val('0');
            swal("Error!", "Transfer quantity greater than available quantity.", "error");
        }
    });
    $('body').on('click', '#add_barcode1', function ()
    {
        var store_list = "";
        $.post(siteurl + "/Inventory/Mrv/get_store_dropdown", {}, function (data)
        {
            store_list = data;
            var cnt_qty = 0;
            var disp = "";
            if ($('#item_tr_head').length == 0) {
                disp += '<tr style="background-color:#f5f5f5!important; height: 40px;" class="sec_grid_tbl" id="item_tr_head">\n\
                <th class="w35 pa-5">MPN</th>\n\
                <th class="w30 pa-5">Item Condition</th>\n\
                <th class="w30 pa-5">Store</th>\n\
                <th class="w5 text-center"><i class="icon lindo-android-menu fz-20 txt-dgray"></i></th>\n\
                \n\</tr>';
            }
            disp += '<tr>\n\
<td class="w35 pa-2"><input placeholder="MPN number" required class="form-control barcode_enter" id="barcode_enter" type="text" name="mpn[]" ></td>\n\
<td class="w30 pa-2"><select class="form-control" name="item_condition[]"><option>good</option><option>damaged</option></select></td>\n\
<td class="w30 pa-2"><select class="form-control store_list"  name="store[]"><option>select store</option></select></td>\n\
<td class="w5 pa-2 text-center"><a class="remove_mpn text-danger" href="javascript:void(0);"><i class="icon lindo-minus-circle-1 fz-24"></i></a></td></tr>';

            $('#mpn_tbody').append(disp);
            $('.store_list').html(data);
        });
    });
    $('body').on('click', '#stock_button', function ()
    {

        var error = 0;
        var purchase_order = $('#purchase_order').val();
        var po_barcode = $('.barcode_enter').val();

        var mrv = $('#mrv').val();
        var item = $('#item_id').val();
        if (purchase_order == '' || purchase_order == 0)
        {
            error++;
            swal('please select purchase order');
            return false;
        }
        if (mrv == '' || mrv == 0) {
            error++;
            swal('please select mrv');
            return false;
        }
        if (item == '' || item == 0)
        {
            error++;
            swal('please select item');
            return false;
        }
        if (po_barcode == '' || po_barcode == undefined) {
            swal('please select barcode');
            return false;
        }
        var pusharray = [];
        $('#barcode_enter').each(function () {
            var po_barcode = $('.barcode_enter').val();
            if (po_barcode == '') {
                swal('please enter barcode');
            }
            if ($.inArray($(this).val(), pusharray) != -1) {
                error++;
                swal('Duplicate barcode');
                $(this).focus();
                return false;
            }
            pusharray.push($(this).val());
            if ($(this).val() == '') {
                error++;
                swal('please enter barcode');
                $(this).focus();
                return false;
            }
            if ($.inArray($(this).val(), used_barcodes) != -1) {
                error++;
                swal($(this).val() + ' Barcode not available');
                $(this).focus();
                return false;
            }
        });
        if (error == 0) {
            $('#direct_stock_form').submit();
        }
    });

    $('body').on('click', '.remove_mpn', function ()
    {
        $(this).closest('tr').remove();
    });

    $('body').on('change', '.barcode_enter', function () {

        if ($.inArray($(this).val(), used_barcodes) != -1) {
            swal($(this).val() + ' Barcode not available');
        } else {
            $(this).parents('tr').next('tr').find('.barcode_enter').focus();
        }
    });

    $('body').on('click', '#add_barcode', function () {

        $(".check_qty").prop("readonly", true);
        var disp = "";
        var cnt_qty = 0;
        $('.check_qty').each(function () {
            cnt_qty += Number($(this).val());

        });
        console.log(cnt_qty);
        if (cnt_qty > 0) {
            disp += '<tr class="t-h-bgt">\n\
<th class="w40 pa-10">Serial Number</th>\n\
<th class="w60 pa-10">Item</th>\n\
\n\</tr>';
        }
        $('.stockrepobody').each(function () {
            if (($(this).find('.check_qty').val() != "") || ($(this).find('.check_qty').val() != 0))
            {
                var itemname = $(this).closest('tr').find('.itemname').html();
                var availableqty = $(this).closest('tr').find('.availableqty').html();
                var item_id = $(this).closest('tr').find('.storeitem_id').val();
                var stockstore_id = $(this).closest('tr').find('.stockstore_id').val();
                var quantity_transfered = $(this).closest('tr').find('.check_qty').val();
                var tracking_enabled = $(this).closest('tr').find('.tracking_enabled').val();
                var partial_selling = $(this).closest('tr').find('.partial_selling').val();
                console.log(partial_selling);
                for (var i = 0; i < quantity_transfered; i++) {
                    if (tracking_enabled == 1) {
                        disp += '<tr>\n\
<td class="w40 pa-2"><input type="hidden" name="tracking_barcode[]" value="1"><input type="hidden" value="' + availableqty + '" name="available_qua[]" id="available_qua"><input type="hidden" value="' + partial_selling + '" name="partial_sel[]" id="partial_selid"><input type="hidden" value="1" name="transferquantity[]" id="transferqtty" ><input placeholder="Serial number" required class="form-control barcode_enter barcode_enter blurcheck" type="text" name="mpn[]"></td>\n\
<td class="w60 pa-2"><input type="hidden" id="mpn_item_id" name="mpn_item_id[]" value="' + item_id + '"><input readonly class="form-control" type="text" value="' + itemname + '" name="item_mpn[]" id="item_mpn"></td></tr>'
                    } else if (tracking_enabled == 0) {
                        disp += '<tr>\n\
<td class="w40 pa-2"><input type="hidden" name="tracking_barcode[]" value="0"><input type="hidden" value="' + availableqty + '" name="available_qua[]" id="available_qua"><input type="hidden" value="' + partial_selling + '" name="partial_sel[]" id="partial_selid"><input type="hidden" value="1" name="transferquantity[]" id="transferqtty" ><input placeholder="Serial number" required class="form-control barcode_enter barcode_enter blurcheck" readonly type="text" name="mpn[]"></td>\n\
<td class="w60 pa-2"><input type="hidden" id="mpn_item_id" name="mpn_item_id[]" value="' + item_id + '"><input readonly class="form-control" type="text" value="' + itemname + '" name="item_mpn[]" id="item_mpn"></td></tr>'
                    }
                }
            }

        });
        $('#mpn_tbody').append(disp);

        $('#add_barcode').hide();
    });

    $('#search_item_report').on('keyup', function () {
        var searchkeyword = $(this).val();
        var option = '';
        var count = 0;
        for (var i = 0; i < stock_report.length; i++) {
            count++;
            if (stock_report[i]['name'].toLowerCase().indexOf(searchkeyword.toLowerCase()) != -1) {
                option += '<tr class="sec_grid">'
                option += '<td>' + count + '</td>'
                option += '<td>' + stock_report[i]['name'] + '</td>'
                option += '<td>' + stock_report[i]['unit_name'] + '</td>'
                option += '<td>' + stock_report[i]['quantity'] + '</td>'
                option += '</tr>'
            }

        }
        $('.stockreport').html(option);
    });

    $('body').on('click', '.removerackclone', function (e) {
        var closest = $(this).closest('tr');
//        var item_count = closest.attr('id-cl');
//        if (item_count == 1) {
//            var bc = $(this).parent().parent();
//            var dd = bc.find("input");
//            var ss = bc.find("select");
//            dd.val("");
//            ss.val("");
//        } else {
        e.preventDefault();
        var bc = $(this).parent().parent().remove();
        var dd = bc.find("input");
        var ss = bc.find("select");
        dd.val("");
        ss.val("");
//        }
    });
    $('body').on('click', '.clearrackclone', function (e) {
        var closest = $(this).closest('tr');
//        var item_count = closest.attr('id-cl');
//        if (item_count == 1) {
        var bc = $(this).parent().parent();
        var dd = bc.find("input");
        var ss = bc.find("select");
        dd.val("");
        ss.val("");
//        } else {
//            e.preventDefault();
//            var bc = $(this).parent().parent().remove();
//            var dd = bc.find("input");
//            var ss = bc.find("select");
//            dd.val("");
//            ss.val("");
//        }
    });

    $('body').on('click', '.copyorgmember', function (e) {
        var modal_name = $(this).attr('modal_name');
        var rack_name = $(modal_name + ' .rack_name:last').val();
        if (rack_name == '') {
            swal("Enter valid entry");
        } else {
            e.preventDefault();
            var clid = $(".cld:last").attr('id-cl');
            var nxt = parseFloat(clid) + 1;
            var bc = $("#addstores tr.cld[id-cl=1]").clone();
            bc.attr("id-cl", nxt);
            var dd = bc.find("input");
            bc.find('.clearrackclone').remove();
            dd.val("");
            bc.find("textarea").val('');
            bc.find(".pdt_title").text('');
            bc.find(".attach").html('');
            bc.removeClass('clone');

//            $('#addstores .expense_header').each(function () {
//                var header = $(this).val();
//                bc.find('select.expense_header option[value=' + header + ']').remove();
//                console.log(header);
//                var tr = $(this).closest('tr');
//                var eid = tr.attr('id-cl');
//                $('.table-append tr.cld').not('tr[id-cl=' + eid + ']').find('select.expense_header option[value=' + header + ']').remove();
//            });

            var cc = bc.find('.no-display');

            cc.removeClass('no-display');
            bc.appendTo(".table-append");
        }
    });

    $('body').on('click', '#projectdetailedit', function (e) {
        var storeid = $(this).attr('proid');
        var store_dtl = [];
        $.post(siteurl + "/Inventory/Stores/get_store_byid", {storeid: storeid}, function (data) {
            console.log(data);
            store_dtl = JSON.parse(data);
            var storeid = store_dtl.storeid;
            var racks = store_dtl.racks;
            var store_type = store_dtl.store_type;
            var store_type_id = store_dtl.store_type_id;
            $('#storeeditmodal #store_name').val(storeid[0]['store_name']);
            $('#storeeditmodal #store_id').val(storeid[0]['store_id']);
            $('#storeeditmodal #previous_default').val(storeid[0]['default_store']);
            $('#storeeditmodal #store_code').val(storeid[0]['store_code']);
            var trs = "";
            var option = "";
            trs += '<table width="100%" class="table table-striped table-bordered table-append" id="invoice_table">';
            trs += '<thead>';
            trs += '<tr height="" class="bg-off-white" align="left">'
            trs += '<th></th>'
            trs += '<th>Rack Name</th>'
            trs += '</tr>';
            trs += '<tbody>';
            for (var i = 0; i < racks.length; i++)
            {
                trs += '<tr class="clone cld"  id-cl="1">'
                trs += '<td class="pa-2 text-center">'
                trs += '<a href="#" class="clearrackclone text-danger" ><i class="icon lindo-android-remove-circle fz-22 txt-danger"></i></a>'
                trs += '<a href="#" class="removerackclone no-display txt-danger fz-22 no-display"><i class="icon lindo-subtract"></i></a>'
                trs += '</td>';
                trs += '<td class="pa-2"><input type="text"  class="form-control rack_name"  name="rack_name[]" id="rack_name" value="' + racks[i]['rack_name'] + '" ><input type="hidden"  class="form-control"  name="rack_id[]" value="' + racks[i]['store_rack_id'] + '" ></td>';
                trs += '</tr>';
            }
            trs += '</tbody>'
            trs += '</table>';
            for (var i = 0; i < store_type.length; i++)
            {
                option += '<option'
                if ($.inArray(store_type_id[i], store_type) === -1) {
                    option += 'selected="selected"';
                }
                option += 'value="' + store_type[i]['store_type_id'] + '">'
                option += '"' + store_type[i]['type_name'] + '"'
                option += '</option>'
            }

            $('#storeeditmodal .result_div').html(trs);
//            $('#storeeditmodal .store_type_update').html(option);
        });



    });

    $('body').on('click', '.pagenationbtn', function () {
        var rowlimit = $(this).attr('limit');
        var pagenum = $(this).attr('page');
        var activr_page_num = $('.pagination_div .active ').attr('page');
        var pagination_count = parseInt(page_row_count / rowlimit);
        var pagenumber = pagenum;
        if (pagination_count > 0) {
            if (page_row_count % rowlimit > 0) {
                pagination_count++;
            }
        }
        if (activr_page_num != pagenum) {
            if (pagenum == 'first') {
                if (activr_page_num != 1) {
                    pagenumber = 1;
                    $('.pagenationbtn').removeClass('active');
                    $('.pagenationbtn[page="1"]').addClass('active');
                    createpagenation(rowlimit, pagenumber, pagination_count);
                    page_display(pagenumber);
                }
            } else if (pagenum == 'prev') {
                if (activr_page_num != 1) {
                    pagenumber = activr_page_num - 1;
                    $('.pagenationbtn').removeClass('active');
                    $('.pagenationbtn[page="' + (activr_page_num - 1) + '"]').addClass('active');
                    createpagenation(rowlimit, pagenumber, pagination_count);
                    page_display(pagenumber);
                }
            } else if (pagenum == 'last') {
                if (activr_page_num != pagination_count) {
                    pagenumber = pagination_count;
                    $('.pagenationbtn').removeClass('active');
                    $('.pagenationbtn[page="' + pagination_count + '"]').addClass('active');
                    createpagenation(rowlimit, pagenumber, pagination_count);
                    page_display(pagenumber);
                }
            } else if (pagenum == 'next') {

                if (activr_page_num != pagination_count) {
                    pagenumber = parseInt(activr_page_num) + 1;
                    $('.pagenationbtn').removeClass('active');
                    $('.pagenationbtn[page="' + (parseInt(activr_page_num) + 1) + '"]').addClass('active');
                    createpagenation(rowlimit, pagenumber, pagination_count);
                    page_display(pagenumber);
                }
            } else {
                if (activr_page_num != pagenum) {
                    $('.pagenationbtn').removeClass('active');
                    $(this).addClass('active');
                    createpagenation(rowlimit, pagenumber, pagination_count);
                    page_display(pagenumber);
                }
            }
        }
    });

    var mod = 0;
    var no_of_page = 0;
    var row_limit = 20;
    if (typeof (stock_report) != 'undefined') {
        mod = Number(stock_report.length) % Number(20);
        page_row_count = stock_report.length;

        no_of_page = parseInt(stock_report.length / 20);

        row_limit = 20;
        if (mod != 0)
        {
            no_of_page += 1;
        }
        createpagenation(row_limit, 1, no_of_page);

    }


});

function createpagenation(rowlimit, pagenum, pagination_count) {
    if (pagination_count == 0 || pagination_count == 1) {
    } else {
        var nav_list = '<div class="buttons-row width100 pagination_div ">';

        if (pagination_count <= 6) {
            nav_list += '    <a href="#" page="first" limit="' + rowlimit + '" class="button pagenationbtn "><<</a>';
            nav_list += '    <a href="#" page="prev" limit="' + rowlimit + '" class="button pagenationbtn"><</a>';
            for (var i = 1; i <= pagination_count; i++) {
                nav_list += '    <a href="#" page="' + i + '" limit="' + rowlimit + '" class="button pagenationbtn ' + ((pagenum == i) ? 'active' : '') + '">' + i + '</a>';
            }
            nav_list += '    <a href="#" page="next" limit="' + rowlimit + '" class="button pagenationbtn">></a>';
            nav_list += '    <a href="#" page="last" limit="' + rowlimit + '" class="button pagenationbtn">>></a>';
        } else if (pagenum == pagination_count) {
            var num1 = pagenum - 4, num2 = pagenum - 3, num3 = pagenum - 2, num4 = pagenum - 1, num5 = pagenum;
            nav_list += '    <a href="#" page="first" limit="' + rowlimit + '" class="button pagenationbtn "><<</a>';
            nav_list += '    <a href="#" page="prev" limit="' + rowlimit + '" class="button pagenationbtn"><</a>';
            nav_list += '    <a href="#" page="1" limit="' + rowlimit + '" class="button border-none">...</a>';
            nav_list += '    <a href="#" page="' + num1 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num1 + '</a>';
            nav_list += '    <a href="#" page="' + num2 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num2 + '</a>';
            nav_list += '    <a href="#" page="' + num3 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num3 + '</a>';
            nav_list += '    <a href="#" page="' + num4 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num4 + '</a>';
            nav_list += '    <a href="#" page="' + num5 + '" limit="' + rowlimit + '" class="button pagenationbtn active">' + num5 + '</a>';
            nav_list += '    <a href="#" page="next" limit="' + rowlimit + '" class="button pagenationbtn">></a>';
            nav_list += '    <a href="#" page="last" limit="' + rowlimit + '" class="button pagenationbtn">>></a>';
        } else if (pagenum == 1) {
            var num1 = pagenum, num2 = parseInt(pagenum) + 1, num3 = parseInt(pagenum) + 2, num4 = parseInt(pagenum) + 3, num5 = parseInt(pagenum) + 4;
            nav_list += '    <a href="#" page="first" limit="' + rowlimit + '" class="button pagenationbtn"><<</a>';
            nav_list += '    <a href="#" page="prev" limit="' + rowlimit + '" class="button pagenationbtn"><</a>';
            nav_list += '    <a href="#" page="' + num1 + '" limit="' + rowlimit + '" class="button pagenationbtn active">' + num1 + '</a>';
            nav_list += '    <a href="#" page="' + num2 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num2 + '</a>';
            nav_list += '    <a href="#" page="' + num3 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num3 + '</a>';
            nav_list += '    <a href="#" page="' + num4 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num4 + '</a>';
            nav_list += '    <a href="#" page="' + num5 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num5 + '</a>';
            nav_list += '    <a href="#" page="1" limit="' + rowlimit + '" class="button border-none">...</a>';
            nav_list += '    <a href="#" page="next" limit="' + rowlimit + '" class="button pagenationbtn">></a>';
            nav_list += '    <a href="#" page="last" limit="' + rowlimit + '" class="button pagenationbtn">>></a>';
        } else if (pagenum <= 4) {
            nav_list += '    <a href="#" page="first" limit="' + rowlimit + '" class="button pagenationbtn"><<</a>';
            nav_list += '    <a href="#" page="prev" limit="' + rowlimit + '" class="button pagenationbtn"><</a>';
            nav_list += '    <a href="#" page="1" limit="' + rowlimit + '" class="button pagenationbtn">1</a>';
            nav_list += '    <a href="#" page="2" limit="' + rowlimit + '" class="button pagenationbtn';
            if (pagenum == 2)
                nav_list += ' active">2</a>';
            else
                nav_list += '">2</a>';
            nav_list += '    <a href="#" page="3" limit="' + rowlimit + '" class="button pagenationbtn';
            if (pagenum == 3)
                nav_list += ' active">3</a>';
            else
                nav_list += '">3</a>';
            nav_list += '    <a href="#" page="4" limit="' + rowlimit + '" class="button pagenationbtn';
            if (pagenum == 4)
                nav_list += ' active">4</a>';
            else
                nav_list += '">4</a>';
            nav_list += '    <a href="#" page="5" limit="' + rowlimit + '" class="button pagenationbtn">5</a>';
            nav_list += '    <a href="#" page="1" limit="' + rowlimit + '" class="button border-none">...</a>';
            nav_list += '    <a href="#" page="next" limit="' + rowlimit + '" class="button pagenationbtn">></a>';
            nav_list += '    <a href="#" page="last" limit="' + rowlimit + '" class="button pagenationbtn">>></a>';
        } else if (pagenum > (pagination_count - 4)) {
            var num1 = pagination_count - 4, num2 = pagination_count - 3, num3 = pagination_count - 2, num4 = pagination_count - 1, num5 = pagination_count;
            nav_list += '    <a href="#" page="first" limit="' + rowlimit + '" class="button pagenationbtn"><<</a>';
            nav_list += '    <a href="#" page="prev" limit="' + rowlimit + '" class="button pagenationbtn"><</a>';
            nav_list += '    <a href="#" page="1" limit="' + rowlimit + '" class="button border-none">...</a>';
            nav_list += '    <a href="#" page="' + num1 + '" limit="' + rowlimit + '" class="button pagenationbtn';
            if (pagenum == num1)
                nav_list += ' active">' + num1 + '</a>';
            else
                nav_list += '">' + num1 + '</a>';
            nav_list += '    <a href="#" page="' + num2 + '" limit="' + rowlimit + '" class="button pagenationbtn';
            if (pagenum == num2)
                nav_list += ' active">' + num2 + '</a>';
            else
                nav_list += '">' + num2 + '</a>';
            nav_list += '    <a href="#" page="' + num3 + '" limit="' + rowlimit + '" class="button pagenationbtn';
            if (pagenum == num3)
                nav_list += ' active">' + num3 + '</a>';
            else
                nav_list += '">' + num3 + '</a>';
            nav_list += '    <a href="#" page="' + num4 + '" limit="' + rowlimit + '" class="button pagenationbtn';
            if (pagenum == num4)
                nav_list += ' active">' + num4 + '</a>';
            else
                nav_list += '">' + num4 + '</a>';
            nav_list += '    <a href="#" page="' + num5 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num5 + '</a>';
            nav_list += '    <a href="#" page="next" limit="' + rowlimit + '" class="button pagenationbtn">></a>';
            nav_list += '    <a href="#" page="last" limit="' + rowlimit + '" class="button pagenationbtn">>></a>';
        } else if ((pagenum > 4) && (pagination_count > (parseInt(pagenum) + 2))) {
            var num1 = pagenum - 2, num2 = pagenum - 1, num3 = pagenum, num4 = parseInt(pagenum) + 1;
            nav_list += '    <a href="#" page="first" limit="' + rowlimit + '" class="button pagenationbtn"><<</a>';
            nav_list += '    <a href="#" page="prev" limit="' + rowlimit + '" class="button pagenationbtn"><</a>';
            nav_list += '    <a href="#" page="1" limit="' + rowlimit + '" class="button border-none">...</a>';
            nav_list += '    <a href="#" page="' + num1 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num1 + '</a>';
            nav_list += '    <a href="#" page="' + num2 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num2 + '</a>';
            nav_list += '    <a href="#" page="' + num3 + '" limit="' + rowlimit + '" class="button pagenationbtn active">' + num3 + '</a>';
            nav_list += '    <a href="#" page="' + num4 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num4 + '</a>';
            nav_list += '    <a href="#" page="6" limit="' + rowlimit + '" class="button border-none">...</a>';
            nav_list += '    <a href="#" page="next" limit="' + rowlimit + '" class="button pagenationbtn">></a>';
            nav_list += '    <a href="#" page="last" limit="' + rowlimit + '" class="button pagenationbtn">>></a>';
        }
        nav_list += '</div>';
        $('.pagenatio').html(nav_list);
    }
}

function page_display(pagenumber) {
    var item_start_count = (Number(pagenumber - 1) * 20 + 1);
    var count = item_start_count;
    var option = '';
    for (var i = item_start_count; i < Number(item_start_count) + 20; i++) {

        if (stock_report[i] == undefined) {
            break;

        } else if (stock_report.length > 0) {

            option += '<tr class="sec_grid_tbl">'
            option += '<td class="w5 pa-5 text-center">' + count + '</td>'
            option += '<td class="w65 pa-10">' + stock_report[i]['name'] + '</td>'
            option += '<td class="w15 pa-10">' + stock_report[i]['unit_name'] + '</td>'
            option += '<td class="w15 pa-10 text-center">' + stock_report[i]['quantity'] + '</td>'
            option += '</tr>'
            count++;
        }
    }
    $('.stockreport').html(option);

}
