if (typeof (item_json_list) == 'undefined') {
    var item_json_list = [];
}
$(document).ready(function () {
    $(window).load(function () {
        if (typeof old_rate !== 'undefined' && typeof new_rate !== 'undefined' && parseFloat(old_rate) != '' && parseFloat(old_rate) != parseFloat(new_rate)) {
            swal({
                title: "Transaction Rate Changed",
                text: "Do you want to apply the new rate",
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "Yes, Apply !",
                cancelButtonText: "No, don't apply !",
                closeOnConfirm: false,
                closeOnCancel: false
            },
                    function (isConfirm) {
                        if (isConfirm) {
                            $('.currency_rate').val(new_rate);
                            $('.cur_trans_rate_id').val(new_cur_trans_rate_id);
                            var net = $('#net_amt').val();
                            var final = parseFloat(net) * new_rate
                            $('#transaction_currency').val(final);
                            swal("Rate Changed", "New Rate applied", "success");
                        } else {
                            swal("Cancelled", "Previous Rate will prevail", "success");
                        }
                    });
        }
    });

    $('body').on('change', '#selectCountry', function () {
        var countryid = this.value;
        var data = {countryid: countryid};
        $('#jquery_mask').show();
        $.ajax({
            url: siteurl + "/Common/Picklocation/get_states_by_country",
            type: 'post',
            data: data,
            success: function (data) {
                $('#jquery_mask').hide();
                $('#selectState').html(data);
            },
            error: function (jqXHR, textStatus, errorThrown) {
                $('#jquery_mask').hide();
                alert(jqXHR.status);
            }
        });
    });

    $('body').on('change', '#selectShippingCountry', function () {

        var countryid = this.value;
        var data = {countryid: countryid};
        $('#jquery_mask').show();
        $.ajax({
            url: siteurl + "/Common/Picklocation/get_states_by_country",
            type: 'post',
            data: data,
            success: function (data) {
                $('#jquery_mask').hide();
                $('#selectShippingState').html(data);
            },
            error: function (jqXHR, textStatus, errorThrown) {
                $('#jquery_mask').hide();
                alert(jqXHR.status);
            }
        });
    });

    $('body').on('change', '#selectState', function () {
        var stateid = this.value;
        var data = {stateid: stateid};
        $('#jquery_mask').show();
        $.ajax({
            url: siteurl + "/Common/Picklocation/get_city_by_state",
            type: 'post',
            data: data,
            success: function (data) {
                $('#jquery_mask').hide();
                $('#selectbillingCity').html(data);
            },
            error: function (jqXHR, textStatus, errorThrown) {
                $('#jquery_mask').hide();
                alert(jqXHR.status);
            }
        });
    });

    $('body').on('change', '#selectShippingState', function () {
        var stateid = this.value;
        var data = {stateid: stateid};
        $('#jquery_mask').show();
        $.ajax({
            url: siteurl + "/Common/Picklocation/get_city_by_state",
            type: 'post',
            data: data,
            success: function (data) {
                $('#jquery_mask').hide();
                $('#selectShippingCity').html(data);
            },
            error: function (jqXHR, textStatus, errorThrown) {
                $('#jquery_mask').hide();
                alert(jqXHR.status);
            }
        });
    });

    $('body').on('click', '#copyaddress', function () {
        if ($('#copyaddress').val() == 1)
        {
            $('#Shippingaddress1').val($('#billingaddress1').val());
            $('#Shippingaddress2').val($('#billingaddress2').val());
            $('#selectShippingCountry').val($('#selectCountry').val());
            $('#selectShippingState').val($('#selectState').val());
            $('#Shippingcity').val($('#billingcity').val());
            $('#Shippingcode').val($('#billingcode').val());
        } else if ($('#copyaddress').val() == 2)
        {

            $('#billingaddress1').val($('#Shippingaddress1').val());
            $('#billingaddress2').val($('#Shippingaddress2').val());
            $('#selectCountry').val($('#selectShippingCountry').val());
            $('#selectState').val($('#selectShippingState').val());
            $('#billingcity').val($('#Shippingcity').val());
            $('#billingcode').val($('#Shippingcode').val());
        }
        $("#copyaddress").val("0");
    });

//    $('body').on('click', '#currency_id', function () {
//        var currency_id = $(this).val();
//        $.post(siteurl + "/Organization/Currencyrate/fetch_currency_rate_by_latest", {currency_id: currency_id}, function (data) {
//            var result = JSON.parse(data);
//            $('.div_currencyrate').removeClass('no-display');
//            $('.currency_rate').val(result.rate);
//            $('.cur_trans_rate_id').val(result.cur_trans_rate_id);
//
//            var net_amount = $('#net_amt').val();
//            if (typeof result.rate === 'undefined' || result.rate == '') {
//                result.rate = 1;
//            }
//
//            if (net_amount != 'undefined' && net_amount != '') {
//                var transaction_currency = parseFloat(net_amount) * parseFloat(result.rate);
//                var tr_currency = transaction_currency.toFixed(2);
//                $('#transaction_currency').val(tr_currency);
//            }
//        });
//    });


    $('body').on('click', '.getdeal', function ()
    {
        $('#jquery_mask').show();
        $.post(siteurl + "/Inventory/Quote/list_deal", function (data)
        {
            $('#jquery_mask').hide();
            $('#DealModal .modal-body').html(data);
        });
    });





    $('.status:contains("Active")').addClass('label label-primary');
    $('.status:contains("Expired")').addClass('label label-warning');
    $('.status:contains("Won")').addClass('label label-success');
    $('.status:contains("Cancelled")').addClass('label label-danger');
    $('.status:contains("Approval Pending")').addClass('label label-warning');
    $('.status:contains("Rejected")').addClass('label label-danger');
    $('body').on('click', '#quote_status_cancel', function ()
    {
        var quote_id = $(this).val();
        var quote_status = 'cancelled';
        $('#jquery_mask').show();
        $.post(siteurl + "/Inventory/Quote/update_quote_status", {quote_id: quote_id, quote_status: quote_status}, function (data)
        {
            $('#jquery_mask').hide();
            location.reload();
        });
    });

    $('body').on('click', '#deletetender', function () {

        var tender_id = $(this).attr('id1');
        var s = $(this).closest('tr');
        swal({
            title: "Are you sure?",
            text: "You are going to delete this Tender",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes, delete !",
            cancelButtonText: "No, don't delete !",
            closeOnConfirm: false,
            closeOnCancel: false
        },
                function (isConfirm) {
                    if (isConfirm) {
                        $('#jquery_mask').show();
                        $.ajax({
                            url: siteurl + "/Inventory/Tender/delete_tender",
                            data: {tender_id: tender_id},
                            cache: false,
                            datatype: "json",
                            type: "post",
                            success: function (d) {
                                $('#jquery_mask').hide();
                                $(s).remove();
                                //$(this).closest('.list-group').remove();
                                swal("Deleted!", "Tender has been deleted.", "success");
                            },
                            fail: function (d) {
                                $('#jquery_mask').hide();
                                swal("Cannot delete!", "Tender cannot be deleted.", "error");
                            }
                        });
                    } else {
                        swal("Cancelled", "Tender is not deleted ", "error");
                    }
                });
        return false;

    });

    $('body').on('click', '#copy_billto_shipp', function () {
        $('#Shippingaddress1').val($('#billingaddress1').val());
        $('#Shippingaddress2').val($('#billingaddress2').val());
        $('#selectShippingCountry').val($('#selectCountry').val());
        $('#Shippingcode').val($('#billingcode').val());

        var countryid = $('#selectCountry').val();
        var bill_state = $('#selectState').val();
        if (countryid != "" && countryid != 0) {
            $('#jquery_mask').show();
            $.post(siteurl + "/Common/Picklocation/get_states_by_country", {countryid: countryid}
            , function (data) {
                $('#jquery_mask').hide();
                $('#selectShippingState').html(data);
                $('#selectShippingState').val(bill_state);
            });
        }

        var stateid = $('#selectState').val();
        var bill_city = $('#selectbillingCity').val();
        if (stateid != "" && stateid != 0) {
            $('#jquery_mask').show();
            $.post(siteurl + "/Common/Picklocation/get_city_by_state", {stateid: stateid}
            , function (data) {
                $('#jquery_mask').hide();
                $('#selectShippingCity').html(data);
                $('#selectShippingCity').val(bill_city);
            });
        }
    });

    $('body').on('click', '#copy_shippto_bill', function () {
        $('#billingaddress1').val($('#Shippingaddress1').val());
        $('#billingaddress2').val($('#Shippingaddress2').val());
        $('#selectCountry').val($('#selectShippingCountry').val());
        $('#billingcode').val($('#Shippingcode').val());

        var countryid = $('#selectShippingCountry').val();
        var shipp_state = $('#selectShippingState').val();
        if (countryid != "" && countryid != 0) {
            $('#jquery_mask').show();
            $.post(siteurl + "/Common/Picklocation/get_states_by_country", {countryid: countryid}
            , function (data) {
                $('#jquery_mask').hide();
                $('#selectState').html(data);
                $('#selectState').val(shipp_state);
            });
        }

        var stateid = $('#selectShippingState').val();
        var shipp_city = $('#selectShippingCity').val();
        if (stateid != "" && stateid != 0) {
            $('#jquery_mask').show();
            $.post(siteurl + "/Common/Picklocation/get_city_by_state", {stateid: stateid}
            , function (data) {
                $('#jquery_mask').hide();
                $('#selectbillingCity').html(data);
                $('#selectbillingCity').val(shipp_city);
            });
        }

    });

    $('body').on('keyup', '#search_company_keyword', function () {
        var keyword = $('#search_company_keyword').val();
        $('#jquery_mask').show();
        $.post(siteurl + "/Inventory/Quote/search_company", {keyword: keyword}
        , function (data) {
            $('#jquery_mask').hide();
            $('#search_result').html(data);
        });
    });

    $('#tender_form').on('submit', function (e) {
        var total = $('#net_amt').val();
//        var value = '';
//        $('.s_p').each(function () {
//            value = $(this).val();
//        });


        if (total == '' || total == '0' || isNaN(total)) {
            e.preventDefault();
            swal('Alert', 'Please enter valid Tender entry.', 'error');
        }
        $('.cld_ser').each(function () {
            if ($(this).find('.serviceid_ser').val() != "" || $(this).find('.serviceid_ser').val() != 0) {
                if ($(this).find('.ser_quan_serv').val() == "" || $(this).find('.ser_quan_serv').val() == 0) {
                    e.preventDefault();
                    swal('Alert', 'Please enter valid service entry.', 'error');
                }
                if ($(this).closest('.ser_quan allow_float').val() == "" || $(this).closest('.quan allow_float').val() == 0) {
                    $(this).closest('.ser_quan allow_float').focus();
                    e.preventDefault();
                    swal('Alert', 'Please enter valid service entry.', 'error');
                }
                $('.serv_tbltr').each(function () {
                    if ($(this).find('.service_ids').val() == '' || $(this).find('.service_ids').val() == 0) {
                        e.preventDefault();
                        swal("Please check service");
                    }
                    if ($(this).find('.ser_quan').val() == '' || $(this).find('.ser_quan').val() == 0) {
                        e.preventDefault();
                        swal("Invalid service quantity");

                    }
                });
            }
        });
    });







    $('#search_tender_keyword').on('keyup', function () {

        var searchkeyword = $(this).val();
        var option = '';
        var count = 1;
        for (var i = 0; i < item_json_list.length; i++) {

            if (item_json_list[i]['subject'].toLowerCase().indexOf(searchkeyword.toLowerCase()) != -1) {

                option += '<tr class="sec_grid">'
                option += '<td>' + count + '</td>'
                option += '<td>' + item_json_list[i]['subject'] + '</td>'
                option += '<td>' + item_json_list[i]['closing_date'] + '</td>'
                if (item_json_list[i]['company_id'] == null) {
                    option += '<td>' + item_json_list[i]['name'] + '</td>'
                } else {
                    option += '<td>' + item_json_list[i]['companyname'] + '</td>'
                }

                if (item_json_list[i]['tender_status'] != null) {
                    option += '<td> <label for="level" class="status">' + item_json_list[i]['tender_status'] + '</label></td>'
                } else {
                    option += '<td>' + ' ' + '</td>'
                }
                option += '<td>' + item_json_list[i]['emp_name'] + '</td>'
                option += '<td>'
                option += '<div class="inline-block dropdown">'
                option += '<a class="dropdown-toggle" data-toggle="dropdown" href="#" aria-expanded="false" role="button"><i class="icon lindo-android-more-vertical act-gray fz-22"></i></a>'
                option += '<ul class="dropdown-menu bullet dropdown-menu-right"  role="menu">'
                option += '<li class="b-b-g url_navigators" resource="Inventory/Tender/get_tender_for_view"><a href="' + siteurl + '/Inventory/Tender/get_tender_for_view/' + item_json_list[i]['tender_id'] + '"><i class="icon lindo-android-apps mr-10 fz-22 vam txt-success"></i>View</a></li>'
                option += '<li class="b-b-g url_navigators" resource="Inventory/Tender/get_tender_for_edit">'
                option += '<a href="' + siteurl + '/Inventory/Tender/get_tender_for_edit/' + item_json_list[i]['tender_id'] + '"><i class="icon lindo-page-edit mr-10 fz-22 vam txt-primary"></i>Edit</a>'
                option += '<li role="presentation" class="url_navigators" resource="Inventory/Tender/delete_tender">'
                option += '<a href="#" id1="' + item_json_list[i]['tender_id'] + '" id="deletetender"  role=""  ><i class="icon lindo-delete-trash-1 mr-10 fz-22 vam txt-danger"></i>Delete</a></li>'
                option += '</ul>'
                option += '</div>'
                option += '</td>'
                option += '</tr>'


            }
            count++;
        }
        $('#search_tender_result').html(option);
    });
    $('body').on('click', '.leftarrow', function () {
        var ps = $('.pagediv').find('li.active').attr('pageno');
        if (ps !== 0)
        {
            ps = ps - 1;
            $('li[pageno="' + ps + '"]').trigger('click');
        }
    });
    $('body').on('click', '.rightarrow', function () {

        var ps = $('.pagediv').find('li.active').attr('pageno');
        if (ps < no_of_page)
        {
            ps = Number(ps) + 1;
            $('li[pageno="' + ps + '"]').trigger('click');
        }

    });
    $('body').on('click', '.rightdot', function () {
        var div_name = $(this).attr('divname');
        var ac = parseInt(div_name - 10);
        var ps = $('.pagenatio').find('.sectiondiv' + div_name + '').removeClass('no-display');
        var sc = $('.pagenatio').find('.sectiondiv' + ac + '').addClass('no-display');


    });
    $('body').on('click', '.leftdot', function () {
        var div_name = $(this).attr('divname');
        var ac = parseInt(div_name - 10);
        var ps = $('.pagenatio').find('.sectiondiv' + div_name + '').removeClass('no-display');
        var sc = $('.pagenatio').find('.sectiondiv' + ac + '').addClass('no-display');


    });
    $('body').on('click', '.pagenumber', function () {

        $('.pagediv').find('li.active').removeClass('active');
        $(this).addClass('active');
        var pagenumber = $(this).attr('pageno');
        var item_start_count = (Number(pagenumber) * 20 + 1);
        var count = item_start_count;
        var option = '';
        for (var i = item_start_count; i < Number(item_start_count) + 20; i++) {
            option += '<tr class="sec_grid">'
            option += '<td>' + count + '</td>'
            option += '<td>' + item_json_list[i]['subject'] + '</td>'
            option += '<td>' + item_json_list[i]['closing_date'] + '</td>'
            if (item_json_list[i]['company_id'] == null) {
                option += '<td>' + item_json_list[i]['name'] + '</td>'
            } else {
                option += '<td>' + item_json_list[i]['companyname'] + '</td>'
            }

            if (item_json_list[i]['tender_status'] != null) {
                option += '<td> <label for="level" class="status">' + item_json_list[i]['tender_status'] + '</label></td>'
            } else {
                option += '<td>' + ' ' + '</td>'
            }
option += '<td>' + item_json_list[i]['emp_name'] + '</td>'
            option += '<td>'
            option += '<div class="inline-block dropdown">'
            option += '<a class="dropdown-toggle" data-toggle="dropdown" href="#" aria-expanded="false" role="button"><i class="icon lindo-android-more-vertical act-gray fz-22"></i></a>'
            option += '<ul class="dropdown-menu bullet dropdown-menu-right"  role="menu">'
            option += '<li class="b-b-g url_navigators" resource="Inventory/Tender/get_tender_for_view"><a href="' + siteurl + '/Inventory/Tender/get_tender_for_view/' + item_json_list[i]['tender_id'] + '"><i class="icon lindo-android-apps mr-10 fz-22 vam txt-success"></i>View</a></li>'
            option += '<li class="b-b-g url_navigators" resource="Inventory/Tender/get_tender_for_edit">'
            option += '<a href="' + siteurl + '/Inventory/Tender/get_tender_for_edit/' + item_json_list[i]['tender_id'] + '"><i class="icon lindo-page-edit mr-10 fz-22 vam txt-primary"></i>Edit</a>'
            option += '<li role="presentation" class="url_navigators" resource="Inventory/Tender/delete_tender">'
            option += '<a href="#" id1="' + item_json_list[i]['tender_id'] + '" id="deletetender"  role=""  ><i class="icon lindo-delete-trash-1 mr-10 fz-22 vam txt-danger"></i>Delete</a></li>'
            option += '</ul>'
            option += '</div>'
            option += '</td>'
            option += '</tr>'
            count++;
        }
        $('#search_tender_result').html(option);
    });

    $('body').on('click', '.filterselect', function () {

        var item_typ = $(this).attr('valuepage');
        if (item_typ == 'all')
        {
            item_json_list = item_json_list_filter;

            var mod = Number(item_json_list.length) % Number(20);
            page_row_count = item_json_list.length;
            var no_of_page = parseInt(item_json_list.length / 20);
            var row_limit = 20;
            if (mod != 0)
            {
                no_of_page += 1;
            }
            createpagenation(row_limit, 1, no_of_page);
            page_display(1);
        } else if (item_typ == 'active')
        {
            item_json_list = [];
            for (var i = 0; i < item_json_list_filter.length; i++)
            {
                if (item_json_list_filter[i]['tender_status'] == 'active')
                {
                    item_json_list.push(item_json_list_filter[i])
                }
            }
            var mod = Number(item_json_list.length) % Number(20);
            page_row_count = item_json_list.length;
            var no_of_page = parseInt(item_json_list.length / 20);
            var row_limit = 20;
            if (mod != 0)
            {
                no_of_page += 1;
            }
            createpagenation(row_limit, 1, no_of_page);
            page_display(1);
        } else if (item_typ == 'expired')
        {
            item_json_list = [];
            for (var i = 0; i < item_json_list_filter.length; i++)
            {
                if (item_json_list_filter[i]['tender_status'] == 'expired')
                {
                    item_json_list.push(item_json_list_filter[i])
                }
            }
            var mod = Number(item_json_list.length) % Number(20);
            page_row_count = item_json_list.length;
            var no_of_page = parseInt(item_json_list.length / 20);
            var row_limit = 20;
            if (mod != 0)
            {
                no_of_page += 1;
            }
            createpagenation(row_limit, 1, no_of_page);
            page_display(1);
        }
        $('.status:contains("active")').addClass('label label-success');
        $('.status:contains("expired")').addClass('label label-danger');
    });


    var page_row_count = 0;


    $('body').on('click', '.pagenationbtn', function () {


        var rowlimit = $(this).attr('limit');
        var pagenum = $(this).attr('page');
        var activr_page_num = $('.pagination_div .active ').attr('page');

        var pagination_count = parseInt(page_row_count / rowlimit);
        var pagenumber = pagenum;
        if (pagination_count > 0) {
            if (page_row_count % rowlimit > 0) {
                pagination_count++;
            }
        }
        if (activr_page_num != pagenum) {
            if (pagenum == 'first') {
                if (activr_page_num != 1) {
                    pagenumber = 1;
                    $('.pagenationbtn').removeClass('active');
                    $('.pagenationbtn[page="1"]').addClass('active');
                    createpagenation(rowlimit, pagenumber, pagination_count);
                    page_display(pagenumber);

                }
            } else if (pagenum == 'prev') {
                if (activr_page_num != 1) {
                    pagenumber = activr_page_num - 1;
                    $('.pagenationbtn').removeClass('active');
                    $('.pagenationbtn[page="' + (activr_page_num - 1) + '"]').addClass('active');
                    createpagenation(rowlimit, pagenumber, pagination_count);
                    page_display(pagenumber);
                }
            } else if (pagenum == 'last') {
                if (activr_page_num != pagination_count) {
                    pagenumber = pagination_count;
                    $('.pagenationbtn').removeClass('active');
                    $('.pagenationbtn[page="' + pagination_count + '"]').addClass('active');
                    createpagenation(rowlimit, pagenumber, pagination_count);
                    page_display(pagenumber);

                }
            } else if (pagenum == 'next') {

                if (activr_page_num != pagination_count) {
                    pagenumber = parseInt(activr_page_num) + 1;
                    $('.pagenationbtn').removeClass('active');
                    $('.pagenationbtn[page="' + (parseInt(activr_page_num) + 1) + '"]').addClass('active');
                    createpagenation(rowlimit, pagenumber, pagination_count);
                    page_display(pagenumber);
                }
            } else {
                if (activr_page_num != pagenum) {
                    $('.pagenationbtn').removeClass('active');
                    $(this).addClass('active');
                    createpagenation(rowlimit, pagenumber, pagination_count);
                    page_display(pagenumber);
                }
            }
        }
    });
//    ambili
    $('body').on('change', '#gcmpny', function ()
    {
        var val = $(this).val();

        var cmpny_name = $(this).data('cmpny_name');
        var billingaddress_id = $(this).data('billingaddress_id');
        var shippingaddress_id = $(this).data('shippingaddress_id');
        if (billingaddress_id != 0)
        {
            $('#jquery_mask').show();
            $.post(siteurl + "/Inventory/Tender/get_address_by_billingaddress_id", {billingaddress_id: billingaddress_id}, function (data)
            {
                $('#jquery_mask').hide();
                var dataArray = JSON.parse(data);
                $('#selectCountry').val(dataArray.country);
                $('#billingaddress1').val(dataArray.addressline1);
                $('#billingaddress2').val(dataArray.addressline2);
                $('#billingcode').val(dataArray.zipcode);
                var data = {countryid: dataArray.country};
                $('#jquery_mask').show();
                $.ajax({
                    url: siteurl + "/Common/Picklocation/get_states_by_country",
                    type: 'post',
                    data: data,
                    success: function (data) {
                        $('#jquery_mask').hide();
                        $('#selectState').html(data);
                        $('#selectState').val(dataArray.stateid);


                        var data = {stateid: dataArray.stateid};
                        $('#jquery_mask').show();
                        $.ajax({
                            url: siteurl + "/Common/Picklocation/get_city_by_state",
                            type: 'post',
                            data: data,
                            success: function (data) {
                                $('#jquery_mask').hide();
                                $('#selectbillingCity').html(data);
                                $('#selectbillingCity').val(dataArray.city);
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                $('#jquery_mask').hide();
                                alert(jqXHR.status);
                            }
                        });
                    },
                    error: function (jqXHR, textStatus, errorThrown) {
                        $('#jquery_mask').hide();
                        alert(jqXHR.status);
                    }
                });

            });

        }
        if (shippingaddress_id != 0)
        {
            $('#jquery_mask').show();
            $.post(siteurl + "/Inventory/Tender/get_address_by_shipping_id", {shippingaddress_id: shippingaddress_id}, function (data)
            {
                $('#jquery_mask').hide();
                var dataArray = JSON.parse(data);
                $('#selectShippingCountry').val(dataArray.country);
                $('#Shippingaddress1').val(dataArray.addressline1);
                $('#Shippingaddress2').val(dataArray.addressline2);
                $('#Shippingcode').val(dataArray.zipcode);

                var data = {countryid: dataArray.country};
                $('#jquery_mask').show();
                $.ajax({
                    url: siteurl + "/Common/Picklocation/get_states_by_country",
                    type: 'post',
                    data: data,
                    success: function (data) {
                        $('#jquery_mask').hide();
                        $('#selectShippingState').html(data);
                        $('#selectShippingState').val(dataArray.stateid);
                        var data = {stateid: dataArray.stateid};
                        $('#jquery_mask').show();
                        $.ajax({
                            url: siteurl + "/Common/Picklocation/get_city_by_state",
                            type: 'post',
                            data: data,
                            success: function (data) {
                                $('#jquery_mask').hide();
                                $('#selectShippingCity').html(data);
                                $('#selectShippingCity').val(dataArray.city);
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                $('#jquery_mask').hide();
                                alert(jqXHR.status);
                            }
                        });

                    },
                    error: function (jqXHR, textStatus, errorThrown) {
                        $('#jquery_mask').hide();
                        alert(jqXHR.status);
                    }
                });

            });

        }
        $('#getcmpny_id').val(val);
        $('#getcmpny').val(cmpny_name);
        $('#CmpnyModal').modal('hide');

        $('#contact_id').val('');
        $('#getcntct').val('');
    });

    $('body').on('change', '#gcntct', function ()
    {
        var val = $(this).val();
        var contact_id = $(this).val();
        var contact_name = $(this).data('name');
        var address_id = $(this).data('address_id');
        var getcmpny_id = $('#getcmpny_id').val();
        $('#jquery_mask').show();
        $.post(siteurl + "/Inventory/Tender/get_blocked_customer", {contact_id: contact_id}, function (data)
        {
            $('#jquery_mask').hide();
            var dataArray = JSON.parse(data);
            var blkcstmr = dataArray.blocked_customer;
            if (blkcstmr == 1) {
                swal("This Customer is blocked");
                $('#contactModal').modal('hide');
                if (getcmpny_id == 0) {
                    $('#selectCountry').val('');
                    $('#billingaddress1').val('');
                    $('#billingaddress2').val('');
                    $('#billingcity').val('');
                    $('#billingcode').val('');
                    $('#contact_id').val('');
                    $('#getcntct').val('');
                }
            } else {
                $('#contact_id').val(val);
                $('#getcntct').val(contact_name);
                $('#contactModal').modal('hide');
                if (getcmpny_id == 0) {
                    getaddress(address_id);
                }
            }

        });

    });
    $('body').on('click', '#getcntct', function () {

        var getcmpny_id = $('#getcmpny_id').val();
        if (getcmpny_id == "")
        {
            $('#contactModal .modal-body').html('Select Company First');
            $('#contactModal').modal('hide');
        } else
        {
            $('#jquery_mask').show();
            $.post(siteurl + "/Common/Pick_company_contact/get_contact", {getcmpny_id: getcmpny_id}, function (data)
            {
                $('#jquery_mask').hide();
                $('#contactModal .modal-body').html(data);

            });
        }
    });


    $('body').on('click', '#getcmpny', function () {
        var pagecheck = "pagejs";
        $.post(siteurl + "/Inventory/Quote/search_company", {pagecheck: pagecheck}
        , function (data) {
            $('#search_result').html(data);
        });
    });

    function getaddress(address_id) {
        $('#jquery_mask').show();
        $.post(siteurl + "/Inventory/Tender/get_address_by_address_id", {address_id: address_id}, function (data)
        {
            $('#jquery_mask').hide();
            var dataArray = JSON.parse(data);
            $('#selectCountry').val(dataArray.country);
            $('#billingaddress1').val(dataArray.addressline1);
            $('#billingaddress2').val(dataArray.addressline2);
            $('#billingcode').val(dataArray.zipcode);

            var data = {countryid: dataArray.country};
            $('#jquery_mask').show();
            $.ajax({
                url: siteurl + "/Common/Picklocation/get_states_by_country",
                type: 'post',
                data: data,
                success: function (data) {
                    $('#jquery_mask').hide();
                    $('#selectState').html(data);
                    $('#selectState').val(dataArray.stateid);
                    var data = {stateid: dataArray.stateid};
                    $('#jquery_mask').show();
                    $.ajax({
                        url: siteurl + "/Common/Picklocation/get_city_by_state",
                        type: 'post',
                        data: data,
                        success: function (data) {
                            $('#jquery_mask').hide();
                            $('#selectbillingCity').html(data);
                            $('#selectbillingCity').val(dataArray.city);
                        },
                        error: function (jqXHR, textStatus, errorThrown) {
                            $('#jquery_mask').hide();
                            alert(jqXHR.status);
                        }
                    });
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    $('#jquery_mask').hide();
                    alert(jqXHR.status);
                }
            });

        });
    }


    var mod = Number(item_json_list.length) % Number(20);
    page_row_count = item_json_list.length;
    var no_of_page = parseInt(item_json_list.length / 20);
    var row_limit = 20;
    if (mod != 0)
    {
        no_of_page += 1;
    }
    createpagenation(row_limit, 1, no_of_page);




    $('body').on('click', '#tender_save', function (e)
    {
        var count = 0;
        $('.error').each(function () {
            var lessorgreat = $(this).attr('lessorgreat');
            if (lessorgreat == 'less') {
                count = 1;
            }
        });

        if (count == 1) {
            swal({
                title: "Do you want to continue?",
                text: "Tender contains item with amount less than MSP",
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "Yes, continue !",
                cancelButtonText: "No, don't continue !",
                closeOnConfirm: false,
                closeOnCancel: false
            },
                    function (isConfirm) {
                        if (isConfirm) {
                            $('#tender_form').submit();
                        } else {
                            swal("Cancelled", "Tender is cancelled ", "error");
                        }
                    });
        } else {
            $('#tender_form').submit();
        }
    });


});


function createpagenation(rowlimit, pagenum, pagination_count) {
    if (pagination_count == 1 || pagination_count == 0) {
        $('.pagenatio').html('');
    } else {
        var nav_list = '<div class="buttons-row width100 pagination_div ">';

        if (pagination_count <= 6) {
            nav_list += '    <a href="#" page="first" limit="' + rowlimit + '" class="button pagenationbtn "><<</a>';
            nav_list += '    <a href="#" page="prev" limit="' + rowlimit + '" class="button pagenationbtn"><</a>';
            for (var i = 1; i <= pagination_count; i++) {
                nav_list += '    <a href="#" page="' + i + '" limit="' + rowlimit + '" class="button pagenationbtn ' + ((pagenum == i) ? 'active' : '') + '">' + i + '</a>';
            }
            nav_list += '    <a href="#" page="next" limit="' + rowlimit + '" class="button pagenationbtn">></a>';
            nav_list += '    <a href="#" page="last" limit="' + rowlimit + '" class="button pagenationbtn">>></a>';
        } else if (pagenum == pagination_count) {
            var num1 = pagenum - 4, num2 = pagenum - 3, num3 = pagenum - 2, num4 = pagenum - 1, num5 = pagenum;
            nav_list += '    <a href="#" page="first" limit="' + rowlimit + '" class="button pagenationbtn ">&#60;&#60;</a>';
            nav_list += '    <a href="#" page="prev" limit="' + rowlimit + '" class="button pagenationbtn">&#60;</a>';
            nav_list += '    <a href="#" page="1" limit="' + rowlimit + '" class="button border-none">...</a>';
            nav_list += '    <a href="#" page="' + num1 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num1 + '</a>';
            nav_list += '    <a href="#" page="' + num2 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num2 + '</a>';
            nav_list += '    <a href="#" page="' + num3 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num3 + '</a>';
            nav_list += '    <a href="#" page="' + num4 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num4 + '</a>';
            nav_list += '    <a href="#" page="' + num5 + '" limit="' + rowlimit + '" class="button pagenationbtn active">' + num5 + '</a>';
            nav_list += '    <a href="#" page="next" limit="' + rowlimit + '" class="button pagenationbtn">&#62;</a>';
            nav_list += '    <a href="#" page="last" limit="' + rowlimit + '" class="button pagenationbtn">&#62;&#62;</a>';
        } else if (pagenum == 1) {
            var num1 = pagenum, num2 = parseInt(pagenum) + 1, num3 = parseInt(pagenum) + 2, num4 = parseInt(pagenum) + 3, num5 = parseInt(pagenum) + 4;
            nav_list += '    <a href="#" page="first" limit="' + rowlimit + '" class="button pagenationbtn">&#60;&#60;</a>';
            nav_list += '    <a href="#" page="prev" limit="' + rowlimit + '" class="button pagenationbtn">&#60;</a>';
            nav_list += '    <a href="#" page="' + num1 + '" limit="' + rowlimit + '" class="button pagenationbtn active">' + num1 + '</a>';
            nav_list += '    <a href="#" page="' + num2 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num2 + '</a>';
            nav_list += '    <a href="#" page="' + num3 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num3 + '</a>';
            nav_list += '    <a href="#" page="' + num4 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num4 + '</a>';
            nav_list += '    <a href="#" page="' + num5 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num5 + '</a>';
            nav_list += '    <a href="#" page="1" limit="' + rowlimit + '" class="button border-none">...</a>';
            nav_list += '    <a href="#" page="next" limit="' + rowlimit + '" class="button pagenationbtn">&#62;</a>';
            nav_list += '    <a href="#" page="last" limit="' + rowlimit + '" class="button pagenationbtn">&#62;&#62;</a>';
        } else if (pagenum <= 4) {
            nav_list += '    <a href="#" page="first" limit="' + rowlimit + '" class="button pagenationbtn">&#60;&#60;</a>';
            nav_list += '    <a href="#" page="prev" limit="' + rowlimit + '" class="button pagenationbtn">&#60;</a>';
            nav_list += '    <a href="#" page="1" limit="' + rowlimit + '" class="button pagenationbtn">1</a>';
            nav_list += '    <a href="#" page="2" limit="' + rowlimit + '" class="button pagenationbtn';
            if (pagenum == 2)
                nav_list += ' active">2</a>';
            else
                nav_list += '">2</a>';
            nav_list += '    <a href="#" page="3" limit="' + rowlimit + '" class="button pagenationbtn';
            if (pagenum == 3)
                nav_list += ' active">3</a>';
            else
                nav_list += '">3</a>';
            nav_list += '    <a href="#" page="4" limit="' + rowlimit + '" class="button pagenationbtn';
            if (pagenum == 4)
                nav_list += ' active">4</a>';
            else
                nav_list += '">4</a>';
            nav_list += '    <a href="#" page="5" limit="' + rowlimit + '" class="button pagenationbtn">5</a>';
            nav_list += '    <a href="#" page="1" limit="' + rowlimit + '" class="button border-none">...</a>';
            nav_list += '    <a href="#" page="next" limit="' + rowlimit + '" class="button pagenationbtn">&#62;</a>';
            nav_list += '    <a href="#" page="last" limit="' + rowlimit + '" class="button pagenationbtn">&#62;&#62;</a>';
        } else if (pagenum > (pagination_count - 4)) {
            var num1 = pagination_count - 4, num2 = pagination_count - 3, num3 = pagination_count - 2, num4 = pagination_count - 1, num5 = pagination_count;
            nav_list += '    <a href="#" page="first" limit="' + rowlimit + '" class="button pagenationbtn">&#60;&#60;</a>';
            nav_list += '    <a href="#" page="prev" limit="' + rowlimit + '" class="button pagenationbtn">&#60;</a>';
            nav_list += '    <a href="#" page="1" limit="' + rowlimit + '" class="button border-none">...</a>';
            nav_list += '    <a href="#" page="' + num1 + '" limit="' + rowlimit + '" class="button pagenationbtn';
            if (pagenum == num1)
                nav_list += ' active">' + num1 + '</a>';
            else
                nav_list += '">' + num1 + '</a>';
            nav_list += '    <a href="#" page="' + num2 + '" limit="' + rowlimit + '" class="button pagenationbtn';
            if (pagenum == num2)
                nav_list += ' active">' + num2 + '</a>';
            else
                nav_list += '">' + num2 + '</a>';
            nav_list += '    <a href="#" page="' + num3 + '" limit="' + rowlimit + '" class="button pagenationbtn';
            if (pagenum == num3)
                nav_list += ' active">' + num3 + '</a>';
            else
                nav_list += '">' + num3 + '</a>';
            nav_list += '    <a href="#" page="' + num4 + '" limit="' + rowlimit + '" class="button pagenationbtn';
            if (pagenum == num4)
                nav_list += ' active">' + num4 + '</a>';
            else
                nav_list += '">' + num4 + '</a>';
            nav_list += '    <a href="#" page="' + num5 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num5 + '</a>';
            nav_list += '    <a href="#" page="next" limit="' + rowlimit + '" class="button pagenationbtn">&#62;</a>';
            nav_list += '    <a href="#" page="last" limit="' + rowlimit + '" class="button pagenationbtn">&#62;&#62;</a>';
        } else if ((pagenum > 4) && (pagination_count > (parseInt(pagenum) + 2))) {
            var num1 = pagenum - 2, num2 = pagenum - 1, num3 = pagenum, num4 = parseInt(pagenum) + 1;
            nav_list += '    <a href="#" page="first" limit="' + rowlimit + '" class="button pagenationbtn">&#60;&#60;</a>';
            nav_list += '    <a href="#" page="prev" limit="' + rowlimit + '" class="button pagenationbtn">&#60;</a>';
            nav_list += '    <a href="#" page="1" limit="' + rowlimit + '" class="button border-none">...</a>';
            nav_list += '    <a href="#" page="' + num1 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num1 + '</a>';
            nav_list += '    <a href="#" page="' + num2 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num2 + '</a>';
            nav_list += '    <a href="#" page="' + num3 + '" limit="' + rowlimit + '" class="button pagenationbtn active">' + num3 + '</a>';
            nav_list += '    <a href="#" page="' + num4 + '" limit="' + rowlimit + '" class="button pagenationbtn">' + num4 + '</a>';
            nav_list += '    <a href="#" page="6" limit="' + rowlimit + '" class="button border-none">...</a>';
            nav_list += '    <a href="#" page="next" limit="' + rowlimit + '" class="button pagenationbtn">&#62;</a>';
            nav_list += '    <a href="#" page="last" limit="' + rowlimit + '" class="button pagenationbtn">&#62;&#62;</a>';
        }
        nav_list += '</div>';
        $('.pagenatio').html(nav_list);
    }
}
function page_display(pagenumber) {

    var item_start_count = (Number(pagenumber - 1) * 20 + 0);
    var count = item_start_count + 1;

    var option = '';
    for (var i = item_start_count; i < Number(item_start_count) + 20; i++) {
        if (item_json_list[i] == undefined)
        {
            break;
        } else {
            option += '<tr class="sec_grid">'
            option += '<td>' + count + '</td>'
            option += '<td>' + item_json_list[i]['subject'] + '</td>'
            option += '<td>' + item_json_list[i]['closing_date'] + '</td>'
            if (item_json_list[i]['company_id'] == null) {
                option += '<td>' + item_json_list[i]['name'] + '</td>'
            } else {
                option += '<td>' + item_json_list[i]['companyname'] + '</td>'
            }

            if (item_json_list[i]['tender_status'] != null) {
                option += '<td> <label for="level" class="status">' + item_json_list[i]['tender_status'] + '</label></td>'
            } else {
                option += '<td>' + ' ' + '</td>'
            }
            option += '<td>' + item_json_list[i]['emp_name'] + '</td>'
            option += '<td>'
            option += '<div class="inline-block dropdown">'
            option += '<a class="dropdown-toggle" data-toggle="dropdown" href="#" aria-expanded="false" role="button"><i class="icon lindo-android-more-vertical act-gray fz-22"></i></a>'
            option += '<ul class="dropdown-menu bullet dropdown-menu-right"  role="menu">'
            option += '<li class="b-b-g url_navigators" resource="Inventory/Tender/get_tender_for_view"><a href="' + siteurl + '/Inventory/Tender/get_tender_for_view/' + item_json_list[i]['tender_id'] + '"><i class="icon lindo-android-apps mr-10 fz-22 vam txt-success"></i>View</a></li>'
            option += '<li class="b-b-g url_navigators" resource="Inventory/Tender/get_tender_for_edit">'
            option += '<a href="' + siteurl + '/Inventory/Tender/get_tender_for_edit/' + item_json_list[i]['tender_id'] + '"><i class="icon lindo-page-edit mr-10 fz-22 vam txt-primary"></i>Edit</a>'
            option += '<li role="presentation" class="url_navigators" resource="Inventory/Tender/delete_tender">'
            option += '<a href="#" id1="' + item_json_list[i]['tender_id'] + '" id="deletetender"  role=""  ><i class="icon lindo-delete-trash-1 mr-10 fz-22 vam txt-danger"></i>Delete</a></li>'
            option += '</ul>'
            option += '</div>'
            option += '</td>'
            option += '</tr>'
            count++;
        }
    }
    $('#search_tender_result').html(option);

}


