$(document).ready(function () {
    $('body').on('click', '#cityadd', function () {
        var state_id = $(this).attr('state_id');
        var country_id = $(this).attr('country_id');
        $('#cityaddmodel #state_id').val(state_id);
        $('#cityaddmodel #country_id').val(country_id);
    });

    $('body').on('click', '#cityedit', function () {
        var city_id = $(this).attr('city_id');
        $('#jquery_mask').show();
        $.post(siteurl + "/Organization/City/fetch_city_id", {city_id: city_id}, function (data)
        {
            $('#jquery_mask').hide();
            $('#cityeditModal .modal-body').html(data);
        });
    });

    $('body').on('change', '#country_id', function () {

        var country_id = this.value;
        var data = {country_id: country_id};
        $('#jquery_mask').show();
        $.ajax({
            url: siteurl + "/Organization/City/get_state_by_country_id",
            type: 'post',
            data: data,
            success: function (data) {
                $('#jquery_mask').hide();
                $('#state_id').html(data);
            },
            error: function (jqXHR, textStatus, errorThrown) {
                $('#jquery_mask').hide();
                alert(jqXHR.status);
            }
        });
    });

    $('body').on('change', '#city_country_sort', function () {
        var country_id = this.value;
        var data = {country_id: country_id};
        $('#jquery_mask').show();
        $.ajax({
            url: siteurl + "/Organization/City/get_state_by_country_id",
            type: 'post',
            data: data,
            success: function (data) {
                $('#jquery_mask').hide();
                $('#city_state_sort').html(data);
            },
            error: function (jqXHR, textStatus, errorThrown) {
                $('#jquery_mask').hide();
                alert(jqXHR.status);
            }
        });
    });
    $("body").on('change', '#city_country_id', function () {
        var country_id = this.value;
        var data = {country_id: country_id};
        $('#jquery_mask').show();
        $.ajax({
            url: siteurl + '/Organization/State/fetch_state_by_country_id',
            type: 'post',
            data: data,
            success: function (data) {
                $('#jquery_mask').hide();
                $('#city_state_id').html(data);
            },
            error: function (jqXHR, textStatus, errorThrown) {
                $('#jquery_mask').hide();
                alert(jqXHR.status);
            }
        });
    });

    if (typeof selected_country !== 'undefined') {
        if (selected_country != '') {
            var country_id = selected_country;
            $('#jquery_mask').show();
            $.post(siteurl + "/Organization/City/get_state_by_country_id", {country_id: country_id}, function (data)
            {
                $('#jquery_mask').hide();
                console.log(data);
                $('#city_state_sort').html(data);
                $('#city_state_sort').val(selected_state).change();

            });
        }
    }

//    $('body').on('click', '.pagesubmit1', function (e) {
//        e.preventDefault();
//        var country = $('#city_country_sort').val();
//        var state = $('#city_state_sort').val();
//        $('.country_hidden').val(country);
//        $('.state_hidden').val(state);
//        var url = $(this).attr('href');
//        $('#filterpagination').attr('action', url);
//        $('#filterpagination').submit();
//    });
    $('body').on('click', '#sort_button', function () {
        var state_id = $('#city_state_sort').val();
        if (state_id != "" && state_id != 0) {
            window.location.href = siteurl + "/Organization/City/viewcity_bystate/" + state_id;
        } else {
            swal("cannot proceed", "please select country and state", "error");
        }
    });

    $('body').on('click', '#citydelete', function () {
        var city_id = $(this).attr('city_id');
        var nearest = $(this).closest('tr');
        var s = $(this).closest('tr');
        swal({
            title: "Are you sure?",
            text: "You are going to delete this City",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes, delete !",
            cancelButtonText: "No, don't delete !",
            closeOnConfirm: false,
            closeOnCancel: false
        },
        function (isConfirm) {
            if (isConfirm) {
                $('#jquery_mask').show();
                $.ajax({
                    url: siteurl + '/Organization/City/delete_city',
                    data: {city_id: city_id},
                    cache: false,
                    datatype: "json",
                    type: "post",
                    success: function (d) {
                        $('#jquery_mask').hide();
                        $(s).remove();
                        //$(this).closest('.list-group').remove();
                        swal("Deleted!", "City has been deleted.", "success");
                    },
                    fail: function (d) {
                        $('#jquery_mask').hide();
                        swal("Cannot delete!", "City cannot be deleted.", "error");
                    }
                });
            } else {
                swal("Cancelled", "City is not deleted ", "error");
            }
        });
        return false;
    });
    $('#cancel').click(function () {
        $("#create_city_modal").find("input").val('');
        $("#create_city_modal").find("select").val('');
    });

    $('#btn_add_city').on('click', function (data) {
        var country_id = $('#country_id').val();
        var state_id = $('#state_id').val();
        var city_name = $('#city_name').val();
        if (country_id == '') {
            swal('Please Select Country');
        } else if (state_id == '') {
            swal('Please Select State');
        } else if (city_name == '') {
            swal('Please Enter City Name');
        } else {
            $.post(siteurl + "/Organization/City/check_City_alreadyExist", {country_id: country_id, state_id: state_id, city_name: city_name}, function (data) {
                console.log(data);
                if (data) {
                    swal('City Already Exist');
                } else {
                    $('#jquery_mask').show();
                    $.post(siteurl + "/Organization/City/insert_city", {country_id: country_id, state_id: state_id, city_name: city_name}, function (data) {
                        $('#jquery_mask').hide();
                        location.reload();
                    });
                }
            });
        }
    });

    $('#btn_edit_city').on('click', function (e) {
        e.preventDefault();
        $('#jquery_mask').show();
        $('#edit_city').submit();
    });
    $('body').on('click', '.pagesubmit', function (e) {
        e.preventDefault();
        var country = $('#city_country_sort').val();
        var state = $('#city_state_sort').val();
        var city = $('#search_city_name').val();
        $('#country_hidden').val(country);
        $('#state_hidden').val(state);
        $('#city_hidden').val(city);
        var url = $(this).attr('href');
        $('#filterpagination').attr('action', url);
        $('#filterpagination').submit();
    });

});