$(document).ready(function () {
    $('body').on('click', '#costcenteredit', function () {
        var ccId = $(this).attr('ccId');
        $('#jquery_mask').show();
        $.post(siteurl + "/Organization/Costcenter/fetch_costcenter_by_id", {ccId: ccId}, function (data)
        {
            $('#jquery_mask').hide();
            $('#costcentereditModal .modal-body').html(data);
        });
    });

    $('body').on('click', '#costcenterdelete', function () {
        var ccId = $(this).attr('ccId');
        var s = $(this).closest('tr');
        swal({
            title: "Are you sure?",
            text: "You are going to delete this Cost Center",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes, delete !",
            cancelButtonText: "No, don't delete !",
            closeOnConfirm: false,
            closeOnCancel: false
        },
                function (isConfirm) {
                    if (isConfirm) {
                        $('#jquery_mask').show();
                        $.ajax({
                            url: siteurl + '/Organization/Costcenter/delete_costcenter',
                            data: {ccId: ccId},
                            cache: false,
                            datatype: "json",
                            type: "post",
                            success: function (d) {
                                $('#jquery_mask').hide();
                                $(s).remove();
                                //$(this).closest('.list-group').remove();
                                swal("Deleted!", "Cost Center has been deleted.", "success");

                            },
                            fail: function (d) {
                                $('#jquery_mask').hide();
                                swal("Cannot delete!", "Cost Center cannot be deleted.", "error");

                            }
                        });
                    } else {
                        swal("Cancelled", "Cost Center is not deleted ", "error");
                    }
                });
        return false;
    });

    //Category master------------------------------------------------------------------------------------------------------
    $('body').on('click', '#costcentercategoryedit', function () {
        var categoryId = $(this).attr('categoryId');
        $('#jquery_mask').show();
        $.post(siteurl + "/Organization/Costcenter/fetch_cost_center_category_by_id", {categoryId: categoryId}, function (data)
        {
            $('#jquery_mask').hide();
            $('#categorymastereditModal .modal-body').html(data);
        });
    });


    $('body').on('click', '#costcentercategorydelete', function () {
        var categoryId = $(this).attr('categoryId');
        var nearest = $(this).closest('tr');

        var s = $(this).closest('tr');
        swal({
            title: "Are you sure?",
            text: "You are going to delete this Cost Center Category",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes, delete !",
            cancelButtonText: "No, don't delete !",
            closeOnConfirm: false,
            closeOnCancel: false
        },
                function (isConfirm) {
                    if (isConfirm) {
                        $('#jquery_mask').show();
                        $.ajax({
                            url: siteurl + '/Organization/Costcenter/delete_cost_center_category',
                            data: {categoryId: categoryId},
                            cache: false,
                            datatype: "json",
                            type: "post",
                            success: function (d) {
                                $('#jquery_mask').hide();
                                $(s).remove();
                                //$(this).closest('.list-group').remove();
                                swal("Deleted!", "Cost Center Category has been deleted.", "success");
                            },
                            fail: function (d) {
                                $('#jquery_mask').hide();
                                swal("Cannot delete!", "Cost Center Category cannot be deleted.", "error");
                            }
                        });
                    } else {
                        swal("Cancelled", "Cost Center Category is not deleted ", "error");
                    }
                });
        return false;
    });

    //Rate master------------------------------------------------------------------------------------------------------
    $('body').on('click', '#ratemasteredit', function () {
        var rate_master_id = $(this).attr('rate_master_id');
        $('#jquery_mask').show();
        $.post(siteurl + "/Organization/Costcenter/fetch_rate_category_by_id", {rate_master_id: rate_master_id}, function (data)
        {
            $('#jquery_mask').hide();
            $('#ratemastereditModal .modal-body').html(data);
        });
    });


    $('body').on('click', '#ratemasterdelete', function () {
        var rate_master_id = $(this).attr('rate_master_id');
        var nearest = $(this).closest('tr');

        var s = $(this).closest('tr');
        swal({
            title: "Are you sure?",
            text: "You are going to delete this Category Rate",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes, delete !",
            cancelButtonText: "No, don't delete !",
            closeOnConfirm: false,
            closeOnCancel: false
        },
                function (isConfirm) {
                    if (isConfirm) {
                        $('#jquery_mask').show();
                        $.ajax({
                            url: siteurl + '/Organization/Costcenter/delete_rate_category',
                            data: {rate_master_id: rate_master_id},
                            cache: false,
                            datatype: "json",
                            type: "post",
                            success: function (d) {
                                $('#jquery_mask').hide();
                                $(s).remove();
                                swal("Deleted!", "Category Rate has been deleted.", "success");
                            },
                            fail: function (d) {
                                $('#jquery_mask').hide();
                                swal("Cannot delete!", "Category Rate cannot be deleted.", "error");
                            }
                        });
                    } else {
                        swal("Cancelled", "Category Rate is not deleted ", "error");
                    }
                });
        return false;
    });

    $('body').on('click', '#ratemasteradd', function () {
        var categoryId = $(this).attr('categoryId');
        var costcenterid = $(this).attr('costcenterid');
        $('#ratemasterModal #categoryId').val(categoryId);
        $('#ratemasterModal #costcenterid').val(costcenterid);
    });

    $("#ratemastereditModal").on('shown.bs.modal', function () {
        //alert("I want this to appear after the modal has opened!");
        var sel = $('input[name=employee_type]:checked').val();
        if (sel == 'external') {
            $('.externalemployeediv').show();
        }
    });


    //Radio button-------------------------------------------------------------------------------------------------
    $('body').on('change', 'input[type=radio][name=employee_type]', function () {
        if (this.value == 'external') {
            $('.externalemployeediv').show();
            $('.externalemployeediv').removeClass('no-display');
        } else {
            $('.externalemployeediv').hide();
            $('.externalemployeediv').addClass('no-display');
        }
    });

    $("body").on('change', '.cost_center_id', function () {
        var cost_center_id = this.value;
        var data = {cost_center_id: cost_center_id};
        $('#jquery_mask').show();
        $.ajax({
            url: siteurl + '/Organization/Costcenter/get_costcenter_categories_by_id',
            type: 'post',
            data: data,
            success: function (data) {
                $('#jquery_mask').hide();
                $('#costcentercategory1').html(data);
                $('#costcentercategory').html(data);

            },
            error: function (jqXHR, textStatus, errorThrown) {
                $('#jquery_mask').hide();
                alert(jqXHR.status);
            }
        });
    });

    $('#cancel').click(function () {
        $("#costcenterModal").find("input").val('');
        $("#categorymasterModal").find("input").val('');
        $("#categorymasterModal").find("select").val('');

    });

    $('#btn_add_cc_category_code').on('click', function (e) {
        e.preventDefault();
        var costcenter_id = $('#costcenter_id').val();
        var name_cc_category = $('#cc_category_name').val();
        var cc_category_code = $('#cc_category_code').val();
        if (costcenter_id == '') {
            swal({title: "Cost center category", text: "Please select cost center", imageUrl: '../../../images/warn.png'});
        } else if (name_cc_category == "")
        {
            swal({title: "Cost center category", text: "Cost center category can not be null", imageUrl: '../../../images/warn.png'});
        } else if (cc_category_code == '') {
            swal({title: "Cost center category ", text: "Cost center category code can not be null", imageUrl: '../../../images/warn.png'});
        } else {
            $('#jquery_mask').show();
            $.post(siteurl + '/Organization/Costcenter/check_if_category_already_exists', {name_cc_category: name_cc_category}, function (data) {
                $('#jquery_mask').hide();
                if (data == 0) {
                    $('#ccaddform').submit();
                } else {
                    e.preventDefault();
                    $('.category_error').html(data);
                }
            });
        }
    });
    $('#cc_save').on('click', function (e) {
        e.preventDefault();
        $('#jquery_mask').show();
        $('#save_costcenter').submit();
    });

    $('#cc_edit').on('click', function (e) {
        e.preventDefault();
        $('#jquery_mask').show();
        $('#edit_costcenter').submit();
    });
    $('#update_costcenter_category').on('click', function (e) {
        e.preventDefault();
        $('#jquery_mask').show();
        $('#cc_category_update').submit();
    });

    $('#category_rate_update').on('click', function (e) {
        e.preventDefault();
        $('#jquery_mask').show();
        $('#update_rate_category').submit();
    });
    $("body").on('keyup', '#ot_rate', function () {
        var ot_rate = $(this).val();
        var hourly_rate = $('#hourly_rate').val();
        var per = (parseFloat(ot_rate) * 100) / (parseFloat(hourly_rate))
        $('#ot_rate_per').val(per.toFixed(2));

    });
    $("body").on('keyup', '#ot_rate_per', function () {
        var ot_rate_per = $(this).val();
        var hourly_rate = $('#hourly_rate').val();
        var per = (parseFloat(ot_rate_per) * parseFloat(hourly_rate)) / (100)
        $('#ot_rate').val(per.toFixed(2));

    });

    $("body").on('keyup', '#ot_rate_base', function () {
        var ot_rate_base = $(this).val();
        var hourly_rate = $('#hourly_rate_base').val();
        var per = (parseFloat(ot_rate_base) * 100) / (parseFloat(hourly_rate))
        $('#ot_rate_per_base').val(per.toFixed(2));

    });
    $("body").on('keyup', '#ot_rate_per_base', function () {
        var ot_rate_per_base = $(this).val();
        var hourly_rate = $('#hourly_rate_base').val();
        var per = (parseFloat(ot_rate_per_base) * parseFloat(hourly_rate)) / (100)
        $('#ot_rate_base').val(per.toFixed(2));

    });



    $("body").on('keyup', '#hot_rate', function () {
        var hot_rate = $(this).val();
        var hourly_rate = $('#hourly_rate').val();
        var per = (parseFloat(hot_rate) * 100) / (parseFloat(hourly_rate))
        $('#hot_rate_per').val(per.toFixed(2));

    });
    $("body").on('keyup', '#hot_rate_per', function () {
        var hot_rate_per = $(this).val();
        var hourly_rate = $('#hourly_rate').val();
        var per = (parseFloat(hot_rate_per) * parseFloat(hourly_rate)) / (100)
        $('#hot_rate').val(per.toFixed(2).toFixed(2));

    });

    $("body").on('keyup', '#hot_rate_base', function () {
        var hot_rate_base = $(this).val();
        var hourly_rate = $('#hourly_rate_base').val();
        var per = (parseFloat(hot_rate_base) * 100) / (parseFloat(hourly_rate))
        $('#hot_rate_per_base').val(per.toFixed(2));

    });
    $("body").on('keyup', '#hot_rate_per_base', function () {
        var ot_rate_per_base = $(this).val();
        var hourly_rate = $('#hourly_rate_base').val();
        var per = (parseFloat(ot_rate_per_base) * parseFloat(hourly_rate)) / (100)
        $('#hot_rate_base').val(per.toFixed(2));

    });


    $("body").on('keyup', '#hourly_rate', function () {
        var rate = $(this).val();
        var hourly_rate_base = $('#hourly_rate_base').val();

        var per = (parseFloat(rate) * 100) / (parseFloat(hourly_rate_base))
        $('#hourly_rate_per').val(per.toFixed(2));

    });
    $("body").on('keyup', '#hourly_rate_per', function () {
        var rate_per = $(this).val();
        var hourly_rate = $('#hourly_rate_base').val();
        var per = (parseFloat(rate_per) * parseFloat(hourly_rate)) / (100)
        $('#hourly_rate').val(per.toFixed(2));

    });
    $("body").on('keyup', '#hourly_rate_base', function () {
        $('#ot_rate_base').val('');
        $('#ot_rate_per_base').val('');
        $('#hot_rate_base').val('');
        $('#hot_rate_per_base').val('');

    });
    $("body").on('keyup', '#hourly_rate', function () {
        $('#ot_rate').val('');
        $('#ot_rate_per').val('');
        $('#hot_rate').val('');
        $('#hot_rate_per').val('');

    });

});
