$(document).ready(function () {
    $('body').on('click', '#country_details_edit', function () {
        var country_id = $(this).attr('country_id');
        $('#jquery_mask').show();
        $.post(siteurl + "/Organization/Country/fetch_country_by_id", {country_id: country_id}, function (data)
        {
            $('#jquery_mask').hide();
            $('#countryeditModal .modal-body').html(data);
        });
    });

    $('body').on('click', '#country_delete', function () {
        var country_id = $(this).attr('country_id');
        var nearest = $(this).closest('tr');
        var s = $(this).closest('tr');
        swal({
            title: "Are you sure?",
            text: "You are going to delete this Country",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes, delete !",
            cancelButtonText: "No, don't delete !",
            closeOnConfirm: false,
            closeOnCancel: false
        },
        function (isConfirm) {
            if (isConfirm) {
                $('#jquery_mask').show();
                $.ajax({
                    url: siteurl + '/Organization/Country/delete_country',
                    data: {country_id: country_id},
                    cache: false,
                    datatype: "json",
                    type: "post",
                    success: function (d) {
                        $('#jquery_mask').hide();
                        $(s).remove();
                        //$(this).closest('.list-group').remove();
                        swal("Deleted!", "Country has been deleted.", "success");
                    },
                    fail: function (d) {
                        $('#jquery_mask').hide();
                        swal("Cannot delete!", "Country cannot be deleted.", "error");
                    }
                });
            } else {
                swal("Cancelled", "Country is not deleted ", "error");
            }
        });
        return false;
    });
    $('#cancel').click(function () {
        $("#countryaddModal").find("input").val('');
    });

    $('#btn_addcountry').on('click', function (data) {

        var country_name = $('#country_name').val();
        if (country_name == '') {
            swal('Please Enter Country Name');
        } else {
            $.post(siteurl + "/Organization/Country/check_country_alreadyExist", {country_name: country_name}, function (data) {
                console.log(data);
                if (data) {
                    swal('Country Already Exist');
                } else {
                    $('#jquery_mask').show();
                    $.post(siteurl + "/Organization/Country/insert_country", {country_name: country_name}, function (data) {
                        $('#jquery_mask').hide();
                        location.reload();
                    });
                }
            });
        }
    });
    $('#btn_editcountry').on('click', function (e) {
        e.preventDefault();
        $('#jquery_mask').show();
        $('#update_cntry_det').submit();
    });
    //////search company/////
    $('body').on('keyup', '#search_country_keyword', function () {
        var count = 1;
        var search_country_keywords = $('#search_country_keyword').val();
        $.post(siteurl + "/Organization/Country/search_country_filter", {search_country_keywords: search_country_keywords}, function (data) {
            var json_array2 = JSON.parse(data);
            var json_array = json_array2.c_details;
            var pagination = json_array2.links;
            var option = '';
            if (json_array != '') {
                for (var i = 0; i < json_array.length; i++) {
                    option += '<tr class="sec_grid" > '
                    option += '<td>' + count + '</td>'
                    option += '<td>' + json_array[i]['country_name'] + ' </td> '
                    option += '<td>'
                    option += '<div class="inline-block dropdown ">'
                    option += '<a class="dropdown-toggle" data-toggle="dropdown" href="#" aria-expanded="true" role="button"><i class="icon lindo-android-more-vertical act-gray fz-22"></i></a>'
                    option += '<ul class="dropdown-menu bullet dropdown-menu-right" role="menu">'
                    option += '<li role="presentation" class="b-b-g url_navigators" resource="Organization/Country/viewstate_bycountry"><a href="' + siteurl + '/Organization/Country/viewstate_bycountry/' + json_array[i]['country_id'] + '"><i class= "icon lindo-view mr-10 fz-22 vam txt-success"></i>View States</a></li>'
                    option += '<li role="presentation" class="b-b-g url_navigators" resource="Organization/Country/update_country"> <a href="#" data-target="#countryeditModal" country_id = "' + json_array[i]['country_id'] + '" id="country_details_edit" data-toggle="modal"><i class="icon lindo-page-edit mr-10 fz-22 vam txt-primary"></i>Edit</a></li>'
                    option += '<li role="presentation" class="url_navigators" href="#"  resource="Organization/Country/delete_country">  <a href="#" country_id = "' + json_array[i]['country_id'] + '"  id="country_delete"><i class="icon lindo-delete-trash-1 mr-10 fz-22 vam txt-danger"></i>Delete</a></li>'
                    option += '</ul>'
                    option += '</div>'
                    option += '</td>'
                    option += '</tr>'
                    count++;
                }
            }
            else {
                option += '<tr class="b-b-g txt-danger"><td colspan="3">No Record Found</td></tr>  '
            }
            $('.search_country').html(option);
            $('.paginationdiv').html(pagination);
        });
    });
    $('body').on('click', '.pagesubmit1', function (e) {
        e.preventDefault();
        var count = 1;
        var search_country_keywords = $('#search_country_keyword').val();
        var url = $(this).attr('href');
        $.post(url, {search_country_keywords: search_country_keywords}, function (data) {

            var json_array2 = JSON.parse(data);
//                console.log(json_array2.c_details);
            var json_array = json_array2.c_details;
            var pagination = json_array2.links;
            var option = '';
            if (json_array != '') {
                for (var i = 0; i < json_array.length; i++) {
                    option += '<tr class="sec_grid" > '
                    option += '<td>' + count + '</td>'
                    option += '<td>' + json_array[i]['country_name'] + ' </td> '
                    option += '<td>'
                    option += '<div class="inline-block dropdown ">'
                    option += '<a class="dropdown-toggle" data-toggle="dropdown" href="#" aria-expanded="true" role="button"><i class="icon lindo-android-more-vertical act-gray fz-22"></i></a>'
                    option += '<ul class="dropdown-menu bullet dropdown-menu-right" role="menu">'
                    option += '<li role="presentation" class="b-b-g url_navigators" resource="Organization/Country/viewstate_bycountry"><a href="' + siteurl + '/Organization/Country/viewstate_bycountry/' + json_array[i]['country_id'] + '"><i class= "icon lindo-view mr-10 fz-22 vam txt-success"></i>View States</a></li>'
                    option += '<li role="presentation" class="b-b-g url_navigators" resource="Organization/Country/update_country"> <a href="#" data-target="#countryeditModal" country_id = "' + json_array[i]['country_id'] + '" id="country_details_edit" data-toggle="modal"><i class="icon lindo-page-edit mr-10 fz-22 vam txt-primary"></i>Edit</a></li>'
                    option += '<li role="presentation" class="url_navigators" href="#"  resource="Organization/Country/delete_country">  <a href="#" country_id = "' + json_array[i]['country_id'] + '"  id="country_delete"><i class="icon lindo-delete-trash-1 mr-10 fz-22 vam txt-danger"></i>Delete</a></li>'
                    option += '</ul>'
                    option += '</div>'
                    option += '</td>'
                    option += '</tr>'
                    count++;
                }
            }
            else {
                option += '<tr class="b-b-g txt-danger"><td colspan="3">No Record Found</td></tr>  '
            }
            $('.search_country').html(option);
            $('.paginationdiv').html(pagination);
        });
    });
});