$(document).ready(function () {
    $('body').on('click', '#currencyedit', function () {
        var currency_id = $(this).attr('currency_id');
        $('#jquery_mask').show();
        $.post(siteurl + "/Organization/Currency/fetch_currency_by_id", {currency_id: currency_id}, function (data)
        {
            $('#jquery_mask').hide();
            var result = JSON.parse(data);
            $('#currencyeditModal #currency_id').val(result.currency_id);
            $('#currencyeditModal #currency_name').val(result.currency_name);
            $('#currencyeditModal #currency_symbol').val(result.currency_symbol);
            $('#currencyeditModal #currency_symbol').trigger('change');
        });
    });


    $('body').on('click', '#currencydelete', function () {
        var currency_id = $(this).attr('currency_id');
        var nearest = $(this).closest('tr');

        var s = $(this).closest('tr');
        swal({
            title: "Are you sure?",
            text: "You are going to delete this Currency",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes, delete !",
            cancelButtonText: "No, don't delete !",
            closeOnConfirm: false,
            closeOnCancel: false
        },
        function (isConfirm) {
            if (isConfirm) {
                $('#jquery_mask').show();
                $.ajax({
                    url: siteurl + '/Organization/Currency/delete_currency',
                    data: {currency_id: currency_id},
                    cache: false,
                    datatype: "json",
                    type: "post",
                    success: function (d) {
                        $('#jquery_mask').hide();
                        $(s).remove();
                        //$(this).closest('.list-group').remove();
                        swal("Deleted!", "Currency has been deleted.", "success");
                    },
                    fail: function (d) {
                        $('#jquery_mask').hide();
                        swal("Cannot delete!", "Currency cannot be deleted.", "error");
                    }
                });
                location.reload();
            } else {
                swal("Cancelled", "Currency is not deleted ", "error");
            }
        });
        return false;
    });
    $('#cancel').click(function () {
        $('input[type="email"]').val("");
        $('input[type="text"]').val("");
    });

    $('#btn_add_currency').on('click', function (data) {
        var currency_name = $('#currency_name').val();
        var currency_symbol = $('#currency_symbol').val();
        if (currency_name == '') {
            swal('please Enter Currency Name');
        } else if (currency_symbol == '') {
            swal('Please Select Currency Symbol');
        } else {
            $.post(siteurl + "/Organization/Currency/check_currency_name", {currency_name: currency_name}, function (data) {
                if (data == 'exist') {
                    swal('Currency Name Already Exist');
                } else {
                    $('#jquery_mask').show();
                    $.post(siteurl + "/Organization/Currency/insert_currency", {currency_name: currency_name, currency_symbol: currency_symbol}, function (data) {
                        $('#jquery_mask').hide();
                        location.reload();
                    });
                }
            });
        }
    });
    
    $('#update_currency_id').on('click', function (e) {
        e.preventDefault();
        $('#jquery_mask').show();
        $('#curr_edit').submit();
    });
    $('#update_rate_currency').on('click', function (e) {
        e.preventDefault();
        $('#jquery_mask').show();
        $('#currency_rate_edit').submit();
    });

    
});