$(document).ready(function () {
    $('body').on('click', '#currencyrateedit', function () {
        var cur_trans_rate_id = $(this).attr('cur_trans_rate_id');
        $('#jquery_mask').show();
        $.post(siteurl + "/Organization/Currencyrate/fetch_currency_rate_by_id", {cur_trans_rate_id: cur_trans_rate_id}, function (data)
        {
            $('#jquery_mask').hide();
            var result = JSON.parse(data);
            console.log('lk'+result);
            $('#currencyrateeditModal #cur_trans_rate_id').val(result.cur_trans_rate_id);
            $('#currencyrateeditModal #currency_name').val(result.currency_name);
            $('#currencyrateeditModal #currency_id').val(result.currency_id);
            $('#currencyrateeditModal #rate').val(result.rate);
        });
    });

    $('body').on('click', '#ccmodalbtn', function () {
        $('#click_from').val($(this).attr('frm'));
    });

    $('body').on('click', '#btn_save_currency', function () {
        var currency_name = $('#currencyModal #currency_name').val();
        var currency_symbol = $('#currencyModal #currency_symbol').val();
        if (currency_name == '') {
            swal('please Enter Currency Name');
        } else if (currency_symbol == '') {
            swal('Please Enter Currency Symbol');
        } else {
            $.post(siteurl + "/Organization/Currency/check_currency_name", {currency_name: currency_name}, function (data) {
                console.log(data);
                if (data == 'exist') {
                    swal('Currency Name Already Exist');
                } else {
                    $.post(siteurl + "/Organization/Currency/insert_currency", {currency_name: currency_name, currency_symbol: currency_symbol}, function (data) {
                        location.reload();
                    });
                }
            });
        }
    });
    $('body').on('click', '#currencyratedelete', function () {
        var cur_trans_rate_id = $(this).attr('cur_trans_rate_id');
        var nearest = $(this).closest('tr');

        var s = $(this).closest('tr');
        swal({
            title: "Are you sure?",
            text: "You are going to delete this Currency Rate",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes, delete !",
            cancelButtonText: "No, don't delete !",
            closeOnConfirm: false,
            closeOnCancel: false
        },
                function (isConfirm) {
                    if (isConfirm) {
                        $('#jquery_mask').show();
                        $.ajax({
                            url: siteurl + '/Organization/Currencyrate/delete_currency_rate',
                            data: {cur_trans_rate_id: cur_trans_rate_id},
                            cache: false,
                            datatype: "json",
                            type: "post",
                            success: function (d) {
                                $('#jquery_mask').hide();
                                $(s).remove();
                                swal("Deleted!", "Currency Rate has been deleted.", "success");
                                location.reload();
                            },
                            fail: function (d) {
                                $('#jquery_mask').hide();
                                swal("Cannot delete!", "Currency Rate cannot be deleted.", "error");
                            }
                        });
                    } else {
                        swal("Cancelled", "Currency is not deleted ", "error");
                    }
                });
        return false;
    });

    $('#btn_add_currency').on('click', function (data) {
        var currency_name = $('#currency_name').val();
        var currency_symbol = $('#currency_symbol').val();
        if (currency_name == '') {
            swal('please Enter Currency Name');
        } else if (currency_symbol == '') {
            swal('Please Enter Currency Symbol');
        } else {
            $.post(siteurl + "/Organization/Currency/check_currency_name", {currency_name: currency_name}, function (data) {
                console.log(data);
                if (data == 'exist') {
                    swal('Currency Name Already Exist');
                } else {
                    $.post(siteurl + "/Organization/Currency/insert_currency", {currency_name: currency_name, currency_symbol: currency_symbol}, function (data) {
                        location.reload();
                    });
                }
            });
        }
    });
});