
$(document).ready(function () {
    $('body').on('click', '#generalsettingsedit', function () {

        var general_settings_id = $(this).attr('general_settings_id');
        $('#jquery_mask').show();
        $.post(siteurl + "/Organization/General/fetch_general_settings_by_id", {general_settings_id: general_settings_id}, function (data)
        {
            console.log(data);
            $('#jquery_mask').hide();
            var result = JSON.parse(data);
            $('#edit-min-hours').val(result.work_hours);
            $('#edit-time-zone option[value="' + result.time_zone + '"]').attr('selected', 'selected');
            $('#edit-currency option[value="' + result.currency + '"]').attr('selected', 'selected');
            $('#edit-language option[value="' + result.language + '"]').attr('selected', 'selected');
            $('#country_id_edit option[value="' + result.country_id + '"]').attr('selected', 'selected');
            $('input[value="' + result.attendance + '"]').attr('checked', 'checked');

            $('#general_settings').val(result.general_settings_id);

        });
    });

    $('body').on('change', '#edit-time-zone', function ()
    {
        var area_name = $('option:selected', this).val();
        $('#jquery_mask').show();
        $.post(siteurl + "/Organization/General/get_timezone_by_area", {area_name: area_name}, function (data) {
            $('#jquery_mask').hide();
            $('#time_zone').html(data);
        });
    });
    $('body').on('change', '#insert-time-zone', function ()
    {
        var area_name = $('option:selected', this).val();
        $('#jquery_mask').show();
        $.post(siteurl + "/Organization/General/get_timezone_by_area", {area_name: area_name}, function (data) {
            $('#jquery_mask').hide();
            $('#time_zone_insert').html(data);
        });
    });
    $('#update_general_settings').on('click', function (e) {
        e.preventDefault();
        $('#jquery_mask').show();
        $('#gen_settings_edit').submit();
    });
    $('.radio_tax').on('change', function (e) {
        var enable_tax = $(this).val();
        var country_id = $('#country_id').val();
        if (country_id == '') {
            swal('Please Choose Country First');
            $(this).prop('checked', false);
        } else {
            if (enable_tax == 'Enable') {
                $('.tax_headers').removeClass('no-display');
                $.post(siteurl + "/Organization/General/get_tax_headers", {country_id: country_id}, function (data) {
                    $('#tax_header').html(data);
                });
            } else {
                $('.tax_headers').addClass('no-display');
            }
        }
    });

    $('.radio_tax_edit').on('change', function (e) {
        var enable_tax = $(this).val();
        var country_id = $('#country_id_edit').val();
        var country_id = $('#country_id_edit').val();
        var tax_enabled_edit = $('#tax_enabled_edit').val();
        if (country_id == '') {
            swal('Please Choose Country First');
            $(this).prop('checked', false);
        } else {
            if (enable_tax == 'Enable') {
                $('.tax_header_edit').prop('disabled', false);
                $.post(siteurl + "/Organization/General/get_tax_headers", {country_id: country_id}, function (data) {
                    $('#tax_header_edit').html(data);
                    $('#tax_header_edit').val(tax_enabled_edit).trigger('change');
                });
            } else {
          
               $('.tax_header_edit').val('');
                $('.tax_header_edit').prop('disabled', true);
            }
        }
    });
    $('.country_id_edit').on('change', function (e) {
        var country_id = $(this).val();
        var enable_tax = $('input[name=tax_edit]:checked').val();
        if (enable_tax == 'Enable') {
            $('.tax_headers_edit').removeClass('no-display');
            $.post(siteurl + "/Organization/General/get_tax_headers", {country_id: country_id}, function (data) {
                $('#tax_header_edit').html(data);
            });
        } else {
            $('.tax_headers_edit').addClass('no-display');
        }
    });
    $('.country_id').on('change', function (e) {
        var country_id = $(this).val();
        var enable_tax = $('input[name=tax]:checked').val();
        if (enable_tax == 'Enable') {
            $('.tax_header').removeClass('no-display');
            $.post(siteurl + "/Organization/General/get_tax_headers", {country_id: country_id}, function (data) {
                $('#tax_header').html(data);
            });
        } else {
            $('.tax_header').addClass('no-display');
        }
    });
});