$(document).ready(function () {
    $("body").on('change', '.cost_center_id', function () {
        var cost_center_id = this.value;
        var data = {cost_center_id: cost_center_id};
        $('#jquery_mask').show();
        $.ajax({
            url: baseurl + 'organization/Settings/get_costcenter_categories_by_id',
            type: 'post',
            data: data,
            success: function (data) {
                $('#jquery_mask').hide();
                $('#costcentercategory1').html(data);
                $('#costcentercategory').html(data);

            },
            error: function (jqXHR, textStatus, errorThrown) {
                $('#jquery_mask').hide();
                alert(jqXHR.status);
            }
        });
    });

    //Radio button-------------------------------------------------------------------------------------------------
    $('body').on('change', 'input[type=radio][name=employee_type]', function () {
        if (this.value == 'external') {
            $('.externalemployeediv').show();
        } else {
            $('.externalemployeediv').hide();
        }
    });

    //Department------------------------------------------------------------------------------------------------------
    $('body').on('click', '#departmentedit', function () {
        var department_Id = $(this).attr('department_Id');
        $('#jquery_mask').show();
        $.post(baseurl + "organization/Settings/fetch_department_by_id", {department_Id: department_Id}, function (data)
        {
            $('#jquery_mask').hide();
            $('#departmenteditModal .modal-body').html(data);
        });
    });


    $('body').on('click', '#departmentdelete', function () {
        var department_Id = $(this).attr('department_Id');
        var nearest = $(this).closest('tr');
        var s = $(this).closest('tr');
        swal({
            title: "Are you sure?",
            text: "You are going to delete this Department",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes, delete !",
            cancelButtonText: "No, don't delete !",
            closeOnConfirm: false,
            closeOnCancel: false
        },
                function (isConfirm) {
                    if (isConfirm) {
                        $('#jquery_mask').show();
                        $.ajax({
                            url: baseurl + 'organization/Settings/delete_department',
                            data: {department_Id: department_Id},
                            cache: false,
                            datatype: "json",
                            type: "post",
                            success: function (d) {
                                $('#jquery_mask').hide();
                                $(s).remove();
                                //$(this).closest('.list-group').remove();
                                swal("Deleted!", "Department has been deleted.", "success");
                            },
                            fail: function (d) {
                                $('#jquery_mask').hide();
                                swal("Cannot delete!", "Department cannot be deleted.", "error");
                            }
                        });
                    } else {
                        swal("Cancelled", "Department is not deleted ", "error");
                    }
                });
        return false;
    });

    //Cost Center------------------------------------------------------------------------------------------------------
    $('body').on('click', '#costcenteredit', function () {
        var ccId = $(this).attr('ccId');
        $('#jquery_mask').show();
        $.post(baseurl + "organization/Settings/fetch_costcenter_by_id", {ccId: ccId}, function (data)
        {
            $('#jquery_mask').hide();
            $('#costcentereditModal .modal-body').html(data);
        });
    });


    $('body').on('click', '#costcenterdelete', function () {
        var ccId = $(this).attr('ccId');
        var nearest = $(this).closest('tr');
        var s = $(this).closest('tr');
        swal({
            title: "Are you sure?",
            text: "You are going to delete this Cost Center",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes, delete !",
            cancelButtonText: "No, don't delete !",
            closeOnConfirm: false,
            closeOnCancel: false
        },
                function (isConfirm) {
                    if (isConfirm) {
                        $('#jquery_mask').show();
                        $.ajax({
                            url: baseurl + 'organization/Settings/delete_costcenter',
                            data: {ccId: ccId},
                            cache: false,
                            datatype: "json",
                            type: "post",
                            success: function (d) {
                                $('#jquery_mask').hide();
                                $(s).remove();
                                //$(this).closest('.list-group').remove();
                                swal("Deleted!", "Cost Center has been deleted.", "success");
                            },
                            fail: function (d) {
                                $('#jquery_mask').hide();
                                swal("Cannot delete!", "Cost Center cannot be deleted.", "error");
                            }
                        });
                    } else {
                        swal("Cancelled", "Cost Center is not deleted ", "error");
                    }
                });
        return false;
    });

    //Category master------------------------------------------------------------------------------------------------------
    $('body').on('click', '#costcentercategoryedit', function () {
        var categoryId = $(this).attr('categoryId');
        $('#jquery_mask').show();
        $.post(baseurl + "organization/Settings/fetch_cost_center_category_by_id", {categoryId: categoryId}, function (data)
        {
            $('#jquery_mask').hide();
            $('#categorymastereditModal .modal-body').html(data);
        });
    });


    $('body').on('click', '#costcentercategorydelete', function () {
        var categoryId = $(this).attr('categoryId');
        var nearest = $(this).closest('tr');
        var s = $(this).closest('tr');
        swal({
            title: "Are you sure?",
            text: "You are going to delete this Cost Center Category",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes, delete !",
            cancelButtonText: "No, don't delete !",
            closeOnConfirm: false,
            closeOnCancel: false
        },
                function (isConfirm) {
                    if (isConfirm) {
                        $('#jquery_mask').show();
                        $.ajax({
                            url: baseurl + 'organization/Settings/delete_cost_center_category',
                            data: {categoryId: categoryId},
                            cache: false,
                            datatype: "json",
                            type: "post",
                            success: function (d) {
                                $('#jquery_mask').hide();
                                $(s).remove();
                                //$(this).closest('.list-group').remove();
                                swal("Deleted!", "Cost Center Category has been deleted.", "success");
                            },
                            fail: function (d) {
                                $('#jquery_mask').hide();
                                swal("Cannot delete!", "Cost Center Category cannot be deleted.", "error");
                            }
                        });
                    } else {
                        swal("Cancelled", "Cost Center Category is not deleted ", "error");
                    }
                });
        return false;
    });

    //Rate master------------------------------------------------------------------------------------------------------
    $('body').on('click', '#ratemasteredit', function () {
        var rate_master_id = $(this).attr('rate_master_id');
        $('#jquery_mask').show();
        $.post(baseurl + "organization/Settings/fetch_rate_category_by_id", {rate_master_id: rate_master_id}, function (data)
        {
            $('#jquery_mask').hide();
            $('#ratemastereditModal .modal-body').html(data);
        });
    });


    $('body').on('click', '#ratemasterdelete', function () {
        var rate_master_id = $(this).attr('rate_master_id');
        var nearest = $(this).closest('tr');

        var s = $(this).closest('tr');
        swal({
            title: "Are you sure?",
            text: "You are going to delete this Category Rate",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes, delete !",
            cancelButtonText: "No, don't delete !",
            closeOnConfirm: false,
            closeOnCancel: false
        },
                function (isConfirm) {
                    if (isConfirm) {
                        $('#jquery_mask').show();
                        $.ajax({
                            url: baseurl + 'organization/Settings/delete_rate_category',
                            data: {rate_master_id: rate_master_id},
                            cache: false,
                            datatype: "json",
                            type: "post",
                            success: function (d) {
                                $('#jquery_mask').hide();
                                $(s).remove();
                                //$(this).closest('.list-group').remove();
                                swal("Deleted!", "Category Rate has been deleted.", "success");
                            },
                            fail: function (d) {
                                $('#jquery_mask').hide();
                                swal("Cannot delete!", "Category Rate cannot be deleted.", "error");
                            }
                        });
                    } else {
                        swal("Cancelled", "Category Rate is not deleted ", "error");
                    }
                });
        return false;
    });

    $('body').on('click', '#ratemasteradd', function () {
        var categoryId = $(this).attr('categoryId');
        var costcenterid = $(this).attr('costcenterid');
        $('#ratemasterModal #categoryId').val(categoryId);
        $('#ratemasterModal #costcenterid').val(costcenterid);
    });

    //Job Designation------------------------------------------------------------------------------------------------------
    $('body').on('click', '#jobdesigedit', function () {
        var job_id = $(this).attr('job_id');
        $('#jquery_mask').show();
        $.post(baseurl + "organization/JobDesignation/fetch_job_designation_by_id", {job_id: job_id}, function (data)
        {
            $('#jquery_mask').hide();
            $('#jobdesigeditModal .modal-body').html(data);
        });
    });


    $('body').on('click', '#jobdesigdelete', function () {
        var job_id = $(this).attr('job_id');
        var nearest = $(this).closest('tr');
        var s = $(this).closest('tr');
        swal({
            title: "Are you sure?",
            text: "You are going to delete this Job Designation",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes, delete !",
            cancelButtonText: "No, don't delete !",
            closeOnConfirm: false,
            closeOnCancel: false
        },
                function (isConfirm) {
                    if (isConfirm) {
                        $('#jquery_mask').show();
                        $.ajax({
                            url: baseurl + 'organization/JobDesignation/delete_job_designation',
                            data: {job_id: job_id},
                            cache: false,
                            datatype: "json",
                            type: "post",
                            success: function (d) {
                                $('#jquery_mask').hide();
                                $(s).remove();
                                //$(this).closest('.list-group').remove();
                                swal("Deleted!", "Job Designation has been deleted.", "success");
                            },
                            fail: function (d) {
                                $('#jquery_mask').hide();
                                swal("Cannot delete!", "Job Designation cannot be deleted.", "error");
                            }
                        });
                    } else {
                        swal("Cancelled", "Job Designation is not deleted ", "error");
                    }
                });
        return false;
    });

    //Job Qualification------------------------------------------------------------------------------------------------------
    $('body').on('click', '#jobqualificationedit', function () {
        var qua_id = $(this).attr('qua_id');
        $('#jquery_mask').show();
        $.post(baseurl + "Organization/Qualification/fetch_qualification_by_id", {qua_id: qua_id}, function (data)
        {
            $('#jquery_mask').hide();
            $('#qualificationeditModal .modal-body').html(data);
        });
    });

    $('body').on('click', '#jobqualificationdelete', function () {
        var qua_id = $(this).attr('qua_id');
        var nearest = $(this).closest('tr');
        var s = $(this).closest('tr');
        swal({
            title: "Are you sure?",
            text: "You are going to delete this Qualification",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes, delete !",
            cancelButtonText: "No, don't delete !",
            closeOnConfirm: false,
            closeOnCancel: false
        },
                function (isConfirm) {
                    if (isConfirm) {
                        $('#jquery_mask').show();
                        $.ajax({
                            url: baseurl + 'Organization/Qualification/delete_jobqualification',
                            data: {qua_id: qua_id},
                            cache: false,
                            datatype: "json",
                            type: "post",
                            success: function (d) {
                                $('#jquery_mask').hide();
                                $(s).remove();
                                swal("Deleted!", "Qualification has been deleted.", "success");
                            },
                            fail: function (d) {
                                $('#jquery_mask').hide();
                                swal("Cannot delete!", "Qualification cannot be deleted.", "error");
                            }
                        });
                    } else {
                        swal("Cancelled", "Qualification is not deleted ", "error");
                    }
                });
        return false;
    });

    //General Settings------------------------------------------------------------------------------------------------------
    $('body').on('click', '#generalsettingsedit', function () {
        var general_settings_id = $(this).attr('general_settings_id');
        $('#jquery_mask').show();
        $.post(baseurl + "organization/General/fetch_general_settings_by_id", {general_settings_id: general_settings_id}, function (data)
        {
            $('#jquery_mask').hide();
            $('#settingseditModal .modal-body').html(data);
        });
    });
});