$(document).ready(function () {
    $('body').on('click', '#stateedit', function () {
        var state_id = $(this).attr('state_id');
        $('#jquery_mask').show();
        $.post(siteurl + "/Organization/State/fetch_state_by_id", {state_id: state_id}, function (data)
        {
            $('#jquery_mask').hide();
            $('#stateeditmodel .modal-body').html(data);
        });
    });
    $('body').on('click', '#stateaddbtn', function () {
        var country_id = $(this).attr('country_id');
        $('#stateaddmodel #country_id').val(country_id);
    });

    $('body').on('change', '#sort_country', function () {
        var country_id = $(this).val();
        if(country_id!=''){
            window.location.href = siteurl + "/Organization/State/viewstate_bycountry/" + country_id;
        }
    });


    $('body').on('click', '#statedelete', function () {
        var state_id = $(this).attr('state_id');
        var nearest = $(this).closest('tr');

        var s = $(this).closest('tr');
        swal({
            title: "Are you sure?",
            text: "You are going to delete this State",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes, delete !",
            cancelButtonText: "No, don't delete !",
            closeOnConfirm: false,
            closeOnCancel: false
        },
                function (isConfirm) {
                    if (isConfirm) {
                        $.ajax({
                            url: siteurl + '/Organization/State/delete_state',
                            data: {state_id: state_id},
                            cache: false,
                            datatype: "json",
                            type: "post",
                            success: function (d) {
                                $(s).remove();
                                //$(this).closest('.list-group').remove();
                                swal("Deleted!", "State has been deleted.", "success");
                            },
                            fail: function (d) {
                                swal("Cannot delete!", "State cannot be deleted.", "error");
                            }
                        });
                    } else {
                        swal("Cancelled", "State is not deleted ", "error");
                    }
                });
        return false;
    });

    $('#cancel').click(function () {
        $("#stateaddmodel").find("input").val('');
        $("#cityaddmodel").find("input").val('');
    });

    $('#btn_add_state').on('click', function (data) {
        var country_id = $('#country_id').val();
        var state_name = $('#state_name').val();
        if (country_id == '') {
            swal('Please Select Country');
        } else if (state_name == '') {
             swal('Please Enter State Name');
        } else {
            $.post(siteurl + "/Organization/State/check_State_alreadyExist", {country_id:country_id,state_name: state_name}, function (data) {
                console.log(data);
                if (data) {
                    swal('State Already Exist');
                } else {
                     $('#jquery_mask').show();
                    $.post(siteurl + "/Organization/State/insert_state", {country_id:country_id,state_name: state_name}, function (data) {
                         $('#jquery_mask').hide();
                        location.reload();
                    });
                }
            });
        }
    });
    $('#btn_edi_state').on('click', function (e) {
        e.preventDefault();
        $('#jquery_mask').show();
        $('#state_edit').submit();
    });
});