$(document).ready(function () {

    $('body .datepickerjoin').datepicker({
        format: 'yyyy-mm-dd',
        endDate: '0d'
    });
    $('.datepickerdob').datepicker({
        format: 'yyyy-mm-dd',
        endDate: '-20y'
    });

    $("body").on('click', '#btn_pay_salary', function () {
        var remuneration_pay_id = $(this).attr('remuneration_pay_id');
        var emp_id = $(this).attr('emp_id');
        var date_pay = $(this).attr('date_pay');

        var tr = $(this).closest('tr');
        var emp_name = tr.find('employee_name');
        var remaining_amt = tr.find('.remaining_amt').html();
        var salary_amt = tr.find('.salary_amt').html();
        $.post(siteurl + "/Payroll/Paysalary/view_leave_details_by_emp_id", {emp_id: emp_id, date_pay: date_pay}, function (data)
        {
            $('#remuneration_payModal .bind_leave_report').html(data);
            $('#remuneration_payModal #remuneration_pay_id_modal').val(remuneration_pay_id);
            $('#remuneration_payModal #emp_id_modal').val(emp_id);
            $('#remuneration_payModal #emp_name_modal').val(emp_name);
            $('#remuneration_payModal #remain_salary_amt').val(remaining_amt);
            $('#remuneration_payModal #hid_remain_salary_amt').val(remaining_amt);
            $('#remuneration_payModal #salary_amt_rate').val(salary_amt);
        });
    });

    $("body").on('change', '#payment_mode', function () {
        var payment_mode = $('.payment_mode option:selected').val();
        if (payment_mode == 'Bank') {
            $('.bank_div').removeClass('no-display');
            $('.cash_div').addClass('no-display');
        } else if (payment_mode == 'Cash') {
            $('.cash_div').removeClass('no-display');
            $('.bank_div').addClass('no-display');
        }

    });
    $("body").on('keyup', '#loss_of_pay', function () {
        var loss_pay = $(this).val();
        var remaining_amt = $('#remuneration_payModal #remain_salary_amt').val();
        var hid_remain_salary_amt = $('#remuneration_payModal #hid_remain_salary_amt').val();
        if (Math.abs(loss_pay) > Math.abs(hid_remain_salary_amt)) {
            swal('Cannot exceed amount more than salary');
            $(this).val('');
        } else if (loss_pay == 0 || loss_pay == '') {
            $('.div_reason').addClass('no-display');
            $('#remuneration_payModal #remain_salary_amt').val(hid_remain_salary_amt);
        } else {
            $('.div_reason').removeClass('no-display');
            remaining_amt = hid_remain_salary_amt - loss_pay;
            $('#remuneration_payModal #remain_salary_amt').val(remaining_amt);
        }

    });


    //----------------------------------------salary advance payment----------------------------------------------------
    $("body").on('change', '#emp_id,#pay_date', function () {

        var emp_id = $('#emp_id').val();
        var pay_date = $('#pay_date').val();
        $('#advancesalaryrModal .msg').html('');
        $.post(siteurl + "/Payroll/Salary_advance_payment/get_salary_amount", {emp_id: emp_id, pay_date: pay_date}, function (data)
        {
            console.log(data)
            var result = JSON.parse(data);
            var amount = result.amount;
            var lop = result.lop;
            var adv = result.adv;
            var disp = '';
            disp += 'Payment Received :' + adv + '';
            $('#advancesalaryrModal .salary_amount').val(amount.toFixed(2));
            $('#advancesalaryrModal .lop').val(lop.toFixed(2));
            if (adv > 0) {
                $('#advancesalaryrModal .msg').html(disp);
            }
            var total = parseFloat(amount) - parseFloat(lop)
            $('#advancesalaryrModal .total').val(total.toFixed(2));
        });

    });

    $('body').on('change', '#payment_mode', function ()
    {

        var mode = $('#payment_mode').val();
        if (mode == 'Cash') {
            $('#chequepanel').hide();
            $('#depositto').show();
            $('#jquery_mask').show();
            $('.interimtable').hide();
            $.post(siteurl + "/Accounts/Transaction/get_details_payment", {selected: mode}, function (data) {
                $('#jquery_mask').hide();
                var json_array = JSON.parse(data);
                var html_data = '';
                html_data += '<option value="">select</option>';
                for (var i = 0; i < json_array[0].length; i++)
                {
                    html_data += '<option value="' + json_array[0][i]['account_id'] + '">' + json_array[0][i]['account_name'] + '</option>';
                }
                $('#paid_from').html(html_data);
            });
        } else if (mode == 'Card') {
            $('#chequepanel').hide();
            $('#depositto').show();
            $('.interimtable').hide();
            mode = 'Bank';
            $('#jquery_mask').show();
            $.post(siteurl + "/Accounts/Transaction/get_details_payment", {selected: mode}, function (data) {
                $('#jquery_mask').hide();
                var json_array = JSON.parse(data);
                var html_data = '';
                html_data += '<option value="">select</option>';
                for (var i = 0; i < json_array[0].length; i++)
                {
                    html_data += '<option  value="' + json_array[0][i]['account_id'] + '">' + json_array[0][i]['account_name'] + '</option>';
                }
                $('#paid_from').html(html_data);
            });
        }
    });




    //------------------------------------------------------------------------------------------------------------------
//    $("body").on('keyup', '.paying', function () {
//        var total = 0;
//
//        $('.paying').each(function () {
//            if ($(this).val()>0) {
//                var aa = $(this).val();
//                total += Number(aa);
//            }
//        });
//         $('#ttl_pay_amt').val(total);
//    });
});