
var planing_levels = full_project.planing_levels;
var task_start_date=start_date,task_end_date=end_date;
var startdate = new Date(start_date);
var enddate = new Date(end_date);
var draw_result = result;
var task_employee = {};
var employees_assigned = {};
var div_count = 0;
var current_selected_level='',current_level_tasks=[];
var projectbudget_data = {};
var myChart;
if (typeof full_project.budget.plan_data !== 'undefined') {
    projectbudget_data = full_project.budget.plan_data;
}

function create_chart(emp_flag = false) {

    var filter_time = $('#filter_time').val();
    
    if(filter_time == 'year'){
        var now_date = new Date();
        if(now_date<enddate)
            enddate = now_date;
        now_date = new Date();
        now_date.setFullYear( now_date.getFullYear() - 1 );
        if(now_date>startdate)
            startdate = now_date;
    }else if(filter_time == '6month'){
        var now_date = new Date();
        if(now_date<enddate)
            enddate = now_date;
        now_date = new Date();
        now_date.setMonth(now_date.getMonth()-6);
        if(now_date>startdate)
            startdate = now_date;
    }else if(filter_time == '3month'){
        var now_date = new Date();
        if(now_date<enddate)
            enddate = now_date;
        
        now_date = new Date();
        now_date.setMonth(now_date.getMonth()-3);
        if(now_date>startdate)
            startdate = now_date;
    }else if(filter_time == '1month'){
        var now_date = new Date();
        if(now_date<enddate)
            enddate = now_date;
        now_date = new Date();
        now_date.setMonth(now_date.getMonth()-1);
        if(now_date>startdate)
            startdate = now_date;
    }else if(filter_time == '1week'){
        var now_date = new Date();
        if(now_date<enddate)
            enddate = now_date;
        now_date = new Date();
        now_date.setDate(now_date.getDate()-7);
        if(now_date>startdate)
            startdate = now_date;
    }else if(filter_time == 'custom'){
        var filter_start = new Date($('#filter-start-date').val());
        var filter_stop = new Date($('#filter-end-date').val());
        if(filter_stop<enddate)
            enddate = filter_stop;
        if(filter_start>startdate)
            startdate = filter_start;
    }
    var loopDate = new Date(startdate.getTime());
    var x_axis = [];
    var planned_data = [];
    var actual_data = [];
    var budget_data = [];

    while (loopDate <= enddate) {
        var thedate = loopDate.getDate();
        thedate = thedate < 10 ? '0' + thedate : thedate;
        var monthIndex = loopDate.getMonth();
        var year = loopDate.getFullYear();
        var theday = loopDate.getDay();
        x_axis.push(year + '-' + (monthIndex > 8 ? '' : '0') + (monthIndex + 1) + '-' + thedate);
        var current_date = year + '-' + (monthIndex > 8 ? '' : '0') + (monthIndex + 1) + '-' + thedate;
        if (typeof draw_result[current_date] !== 'undefined') {
            if (typeof draw_result[current_date]['planned'] !== 'undefined') {
                planned_data.push(draw_result[current_date]['planned']);
            } else {
                planned_data.push('0');
            }
            if (typeof draw_result[current_date]['actual'] !== 'undefined') {
                actual_data.push(draw_result[current_date]['actual']);
            } else {
                actual_data.push('0');
            }
        } else {
            planned_data.push('0');
            actual_data.push('0');
        }
        if (typeof projectbudget_data[current_date] !== 'undefined') {
            if (typeof projectbudget_data[current_date]['planned'] !== 'undefined') {
                budget_data.push(projectbudget_data[current_date]['planned']);
            } else {
                budget_data.push('0');
            }
        }else{
            budget_data.push('0');
        }

        loopDate.setDate(loopDate.getDate() + 1)
    }
    var plan_dataset = {
                    label: 'Current Plan',
                    data: planned_data,
                    backgroundColor: [
                        'rgba(255, 99, 132, 0.2)'
                    ],
                    borderColor: [
                        'rgba(255,99,132,1)'
                    ],
                    borderWidth: 1
                };
    var running_dataset = {
                    label: 'Actual',
                    data: actual_data,
                    backgroundColor: [
                        'rgba(85, 164, 247, 0.2)'
                    ],
                    borderColor: [
                        'rgba(85,164,247,1)'
                    ],
                    borderWidth: 1
                }
    var budget_dataset = {
                    label: 'Budget',
                    data: budget_data,
                    backgroundColor: [
                        'rgba(150, 211, 32, 0.2)'
                    ],
                    borderColor: [
                        'rgba(150, 211, 32,1)'
                    ],
                    borderWidth: 1
                }
    var datasetarray;
    if(emp_flag)
        datasetarray =  [plan_dataset,running_dataset];
    else
        datasetarray =  [plan_dataset,running_dataset,budget_dataset];
    $('#myChart').remove(); // this is my <canvas> element
    $('#graph-container').append('<canvas id="myChart"><canvas>');
    var ctx = document.getElementById("myChart").getContext('2d');
    myChart = new Chart(ctx, {
        type: 'line',
        data: {
            labels: x_axis,
            datasets: datasetarray
        },
        options: {
            scales: {
                yAxes: [{
                        ticks: {
                            beginAtZero: true
                        }
                    }]
            }
        }
    });
}
$(document).ready(function(){
    create_chart();
    $('#filter_time').on('change',function(){
        var vl = $(this).val();
        if(vl == 'custom')
            $('#filter_date').modal('show');
        else if($('#parent_select').val() == ''){
            startdate = new Date(start_date);
            enddate = new Date(end_date);
            create_chart();
        }else{
            startdate = new Date(task_start_date);
            enddate = new Date(task_end_date);
            create_chart();
        }
    });
    $('#filter_done').on('click',function(){
        if($('#filter-start-date').val() == '' || $('#filter-end-date').val() == ''){
            alert('Select Date');
        }else{
            $('#filter_date').modal('hide');
            startdate = new Date(task_start_date);
            enddate = new Date(task_end_date);
            create_chart();
        }
    });
    var parent_levels = [];
    for (var i = 0; i < planing_levels.length; i++) {
        if(planing_levels[i].parent_id == null){
            parent_levels.push({level_name:planing_levels[i].level_name,id:planing_levels[i].id,planning_levels:planing_levels[i].planning_levels});
        }
    }
    var select = '<div class="col-md-3">';
    select += '     <div class="form-group">';
    select += '         <select class="form-control" id="parent_select">';
    select += '             <option value="">All</option>';
    for (var i = 0; i < parent_levels.length; i++) {
        select += '<option value="'+parent_levels[i].id+'-'+parent_levels[i].planning_levels+'">'+parent_levels[i].level_name+'</option>';
    }                  
    select +=  '        </select>';
    select +=  '    </div>';
    select +=  '</div>';
    $('#filter_div').append(select);
    
    $('#filter_div').on('change','#parent_select',function(){
        $('.remove-col-div').remove();
        var plan_level_value = $(this).val();
        if(plan_level_value == ''){
            div_count = 0;
            startdate = new Date(start_date);
            enddate = new Date(end_date);
            draw_result = result;
            current_selected_level = '';
            current_level_tasks = [];
            create_chart();
        }else{
            var plan_level_values = plan_level_value.split('-');
            if(plan_level_values[1] == 'task')
                create_chart_tree([plan_level_values[0]],[plan_level_values[0]]);
            else{
                create_filter_select(plan_level_values[0]);
            }
        }
    });
    
    $('#filter_div').on('change','.select-filter',function(){
        var divcount_data = $(this).parents('.remove-col-div').attr('data');
        for (var i = parseInt(divcount_data)+1; i <= div_count; i++) {
            $('.remove-col-div[data="'+i+'"]').remove();
        }
        div_count = divcount_data;
        var plan_level_value = $(this).val();
        if(plan_level_value == ''){
            var parent_level = $(this).parents('.remove-col-div').attr('parent');
            $(this).parents('.remove-col-div').remove();
            div_count--;
            create_filter_select(parent_level);
        }else{
            var plan_level_values = plan_level_value.split('-');
            if(plan_level_values[1] == 'task')
                create_chart_tree([plan_level_values[0]],plan_level_values[0]);
            else{
                create_filter_select(plan_level_values[0]);
            }
        }
    });
});

function create_filter_select(level_id){
    div_count++;
    var task_array=[],flagg=false;
    var crate_select = '<div class="col-md-3 remove-col-div" data="'+div_count+'" parent="'+level_id+'">';
    crate_select += '     <div class="form-group">';
    crate_select += '         <select class="form-control select-filter" >';
    crate_select += '             <option value="">-Select-</option>';
    for (var i = 0; i < planing_levels.length; i++) {
        if(planing_levels[i].parent_id == level_id){
            flagg = true;
            if(planing_levels[i].planning_levels == 'task')
                task_array.push(planing_levels[i].id);
            else
                task_array = get_tasksof_parent(planing_levels[i].id,task_array);
            crate_select += '<option value="'+planing_levels[i].id+'-'+planing_levels[i].planning_levels+'">'+planing_levels[i].level_name+'</option>';
        }
    }
    crate_select +=  '        </select>';
    crate_select +=  '    </div>';
    crate_select +=  '</div>';
    if(flagg)
        $('#filter_div').append(crate_select);
    create_chart_tree(task_array,level_id);
}

function get_tasksof_parent(level_id, task_array = []){
    for (var i = 0; i < planing_levels.length; i++) {
        if(planing_levels[i].parent_id == level_id){
            if(planing_levels[i].planning_levels == 'task')
                task_array.push(planing_levels[i].id);
            else
                task_array = get_tasksof_parent(planing_levels[i].id,task_array);
        }
    }
    return task_array;
}

function create_chart_tree(tasks,level_id){
    current_selected_level = level_id;
    current_level_tasks = tasks;
    var current_plan_level;
    var output = {};
    for (var i = 0; i < planing_levels.length; i++) {
        if(planing_levels[i].id == level_id){
            current_plan_level = planing_levels[i];
            break;
        }
    }
    if(Object.keys(task_employee).length === 0){
        var employee_in_plan = full_project.epmloyee_tasks_plan;
        for (var i = 0; i < employee_in_plan.length; i++) {
            var each_emp_task = employee_in_plan[i];
            var schedule = JSON.parse(each_emp_task.schedule);
            if(!(each_emp_task.task_id in task_employee)){
                task_employee[each_emp_task.task_id] = {};
            }
            for (var j = 0; j < schedule.length; j++) {
                var each_schedule = schedule[j];
                var hour_array =  each_schedule['hours'].split('-');
                hour_array[1] = 10 * hour_array[1]/60;
                var final_hour = hour_array.join('.');
                if(!(each_schedule.date in task_employee[each_emp_task.task_id]))
                    task_employee[each_emp_task.task_id][each_schedule.date] = {};
                if(!('planned' in task_employee[each_emp_task.task_id][each_schedule.date]))
                    task_employee[each_emp_task.task_id][each_schedule.date]['planned'] = parseFloat(final_hour);
                else
                   task_employee[each_emp_task.task_id][each_schedule.date]['planned'] += parseFloat(final_hour); 
            }
        }
        
        var employee_actual_work = full_project.actual_works;
        for (var i = 0; i < employee_actual_work.length; i++) {
            if(!(employee_actual_work[i].task_id in task_employee))
                task_employee[employee_actual_work[i].task_id] = {};
            if(!(employee_actual_work[i].sheet_date in task_employee[employee_actual_work[i].task_id]))
                task_employee[employee_actual_work[i].task_id][employee_actual_work[i].sheet_date] = {};
            if(!('actual' in task_employee[employee_actual_work[i].task_id][employee_actual_work[i].sheet_date]))
                task_employee[employee_actual_work[i].task_id][employee_actual_work[i].sheet_date]['actual'] = parseFloat(employee_actual_work[i].hours);
            else
               task_employee[employee_actual_work[i].task_id][employee_actual_work[i].sheet_date]['actual'] += parseFloat(employee_actual_work[i].hours); 
        }
    }
    task_start_date = current_plan_level.start_date;
    task_end_date = current_plan_level.end_date
    startdate = new Date(task_start_date);
    enddate = new Date(task_end_date);
    for (var key in tasks) {
        var thistask = task_employee[tasks[key]];
        for (var key2 in thistask) {
            output[key2] = thistask[key2];
        }
    }
    draw_result = output;
    create_chart();
}

function filter_employee(employee_id){
    if(Object.keys(employees_assigned).length === 0){
        var employee_in_plan = full_project.epmloyee_tasks_plan;
        for (var i = 0; i < employee_in_plan.length; i++) {
            var each_emp_task = employee_in_plan[i];
            var schedule = JSON.parse(each_emp_task.schedule);
            if(!(each_emp_task.emp_id in employees_assigned)){
                employees_assigned[each_emp_task.emp_id] = {};
            }
            if(!(each_emp_task.task_id in employees_assigned[each_emp_task.emp_id]))
                employees_assigned[each_emp_task.emp_id][each_emp_task.task_id] = {};
            for (var j = 0; j < schedule.length; j++) {
                var each_schedule = schedule[j];
                var hour_array =  each_schedule['hours'].split('-');
                hour_array[1] = 10 * hour_array[1]/60;
                var final_hour = hour_array.join('.');
                if(!(each_schedule.date in employees_assigned[each_emp_task.emp_id][each_emp_task.task_id]))
                    employees_assigned[each_emp_task.emp_id][each_emp_task.task_id][each_schedule.date] = {};
                if(!('planned' in employees_assigned[each_emp_task.emp_id][each_emp_task.task_id][each_schedule.date]))
                    employees_assigned[each_emp_task.emp_id][each_emp_task.task_id][each_schedule.date]['planned'] = parseFloat(final_hour);
                else
                   employees_assigned[each_emp_task.emp_id][each_emp_task.task_id][each_schedule.date]['planned'] += parseFloat(final_hour); 
            }
        }
        
        var employee_actual_work = full_project.actual_works;
        for (var i = 0; i < employee_actual_work.length; i++) {
            if(!(employee_actual_work[i].emp_id in employees_assigned)){
                employees_assigned[employee_actual_work[i].emp_id] = {};
            }
            if(!(employee_actual_work[i].task_id in employees_assigned[employee_actual_work[i].emp_id]))
                employees_assigned[employee_actual_work[i].emp_id][employee_actual_work[i].task_id] = {};
            if(!(employee_actual_work[i].sheet_date in employees_assigned[employee_actual_work[i].emp_id][employee_actual_work[i].task_id]))
                employees_assigned[employee_actual_work[i].emp_id][employee_actual_work[i].task_id][employee_actual_work[i].sheet_date] = {};
            if(!('actual' in employees_assigned[employee_actual_work[i].emp_id][employee_actual_work[i].task_id][employee_actual_work[i].sheet_date]))
                employees_assigned[employee_actual_work[i].emp_id][employee_actual_work[i].task_id][employee_actual_work[i].sheet_date]['actual'] = parseFloat(employee_actual_work[i].hours);
            else
               employees_assigned[employee_actual_work[i].emp_id][employee_actual_work[i].task_id][employee_actual_work[i].sheet_date]['actual'] += parseFloat(employee_actual_work[i].hours); 
        }
    }
    var output = {};
    if(current_selected_level == ''){
        var emp_assigned = employees_assigned[employee_id];
        for (var key in emp_assigned) {
            var tasssk_asigned = emp_assigned[key];
            for (var key2 in tasssk_asigned) {
                if(key2 in output){
                    if('planned' in output[key2])
                        output[key2]['planned']+= parseFloat(tasssk_asigned[key2]['planned']);
                    else
                        output[key2]['planned'] = parseFloat(tasssk_asigned[key2]['planned']);
                    if('actual' in output[key2]){
                        if('actual' in tasssk_asigned[key2])
                            output[key2]['actual']+= parseFloat(tasssk_asigned[key2]['actual']);
                        else
                            output[key2]['actual'] = parseFloat(tasssk_asigned[key2]['actual']);
                    }
                }else
                    output[key2] = tasssk_asigned[key2];
                    
            }
        }
    }else{
        for (var key in current_level_tasks) {
            var thistask = employees_assigned[employee_id][current_level_tasks[key]];
            for (var key2 in thistask) {
                output[key2] = thistask[key2];
            }
        }
    }
    draw_result = output;
    create_chart(true);
}

 $('body').on('click','.empclick',function(){
     $(".empclick").css("background-color", "#3dba6f");
     $(this).css("background-color", "red");
    var employeeid=$(this).attr('employee_id');
    if(employeeid=="0")
    {
        var plan_level_value = $('#parent_select').val();
         if(plan_level_value == ''){
            div_count = 0;
            startdate = new Date(start_date);
            enddate = new Date(end_date);
            draw_result = result;
            current_selected_level = '';
            current_level_tasks = [];
            create_chart();
        }else{
            create_chart_tree(current_level_tasks,current_selected_level);
        }
    }
    else
    {
       filter_employee(employeeid)
    }
 });
