$(document).ready(function () {
    $('body').on('click', '#projectdetailedit', function () {
        var proid = $(this).attr('proid');
        $('#jquery_mask').show();
        $.post(siteurl + "/Pms/Project/get_project_by_id", {proid: proid}, function (data)
        {
            $('#jquery_mask').hide();
            $('#projecteditmodel .modal-body').html(data);
        });
    });
    $('body').on('click', '#projectdetaildelete', function () {
        var proid = $(this).attr('proid');
        var nearest = $(this).closest('tr');
        var s = $(this).closest('tr');
        swal({
            title: "Are you sure?",
            text: "You are going to delete this Project",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes, delete !",
            cancelButtonText: "No, don't delete !",
            closeOnConfirm: false,
            closeOnCancel: false
        },
                function (isConfirm) {
                    if (isConfirm) {
                        $('#jquery_mask').show();
                        $.ajax({
                            url: siteurl + "/Pms/Project/delete_project",
                            data: {proid: proid},
                            cache: false,
                            datatype: "json",
                            type: "post",
                            success: function (d) {
                                $('#jquery_mask').hide();
                                $(s).remove();
                                swal("Deleted!", "Project has been deleted.", "success");
                            },
                            fail: function (d) {
                                $('#jquery_mask').hide();
                                swal("Cannot delete!", "Project cannot be deleted.", "error");
                            }
                        });
                    } else {
                        swal("Cancelled", "Project is not deleted ", "error");
                    }
                });
        return false;
    });
    $('body').on('click', '#projecttype_button', function () {
        var project_type = $('#project_type').val();
        $('#jquery_mask').show();
        $.post(siteurl + '/Pms/Project/save_projecttype', {project_type: project_type}, function (data)
        {
            $('#jquery_mask').hide();
            $('#ProjectType_model').modal('hide');
            $('#addModel #projecttype').append($('<option>', {
                value: data,
                text: project_type
            }));
        });
    });
    $('body').on('click', '#client_button', function () {
        var name = $('#name').val();
        var email = $('#email').val();
        $('#jquery_mask').show();
        $.post(siteurl + '/Pms/Project/save_client', {name: name, email: email}, function (data)
        {
            $('#jquery_mask').hide();
            $('#Client_model').modal('hide');
            $('#addModel #client').append($('<option>', {
                value: data,
                text: name
            }));
        });
    });
    $('body').on('change', '#end_date', function () {
        var enddate = $(this).val();
        var startdate = $('#start_date').val();
        if (enddate < startdate) {
            swal('Please enter end date which is less than start date');
            document.getElementById("listprojectsubmit").disabled = true;
        } else {
            document.getElementById("listprojectsubmit").disabled = false;
        }

    });

});
$(document).ready(function () {
    $('body').on('keyup', '#search_company', function () {
        var keyword = $('#search_company').val();
        $('#jquery_mask').show();
        $.post(siteurl + "/Pms/Project/search_company", {keyword: keyword}
        , function (data) {
            $('#jquery_mask').hide();
            $('#search_result').html(data);
        });
    });
    $('body').on('change', '#gcmpny', function ()
    {
        var val = $(this).val();
        var cmpny_name = $(this).data('cmpny_name');
        $('#getcmpny_id').val(val);
        $('#getcmpny').val(cmpny_name);
        $('#CmpnyModal').modal('hide');
        $('#contact_id').val('');
        $('#getcntct').val('');
    });
    $('body').on('click', '#getcntct', function () {

        var getcmpny_id = $('#getcmpny_id').val();
        if (getcmpny_id == "")
        {
            $('#contactModal .modal-body').html('Select Company First');
            $('#contactModal').modal('hide');
        } else
        {
            $('#jquery_mask').show();

            $.post(siteurl + "/Pms/Project/get_contact", {getcmpny_id: getcmpny_id}, function (data)
            {
                $('#jquery_mask').hide();
                $('#contactModal .modal-body').html(data);
            });
        }
    });
    $('body').on('change', '#gcntct', function ()
    {
        var val = $(this).val();
        var contact_name = $(this).data('name');
        $('#contact_id').val(val);
        $('#getcntct').val(contact_name);
        $('#contactModal').modal('hide');
    });

    $("body").on('keyup', '#product_search', function () {
        var product_search_value = $(this).val();
        var option = '';
        var count = 1;
        for (var i = 0; i < prod.length; i++) {
            if (prod[i]['project_name'].toLowerCase().indexOf(product_search_value.toLowerCase()) != -1) {
                option += '<tr class="sec_grid_sm">'
                option += '<td class="pa-5 vat">' + count + '</td> '
                option += '<td class="pa-5 vat">' + prod[i]['project_name'] + '</td>'
                option += '<td><button type="button" class="btn btn-primary btn-flat  pickprjct" data-toggle="tooltip" data-dismiss="modal" id="product_search_pick" sl-cl="" sel-id="' + prod[i]['project_id'] + '"  status="whole"  value="' + prod[i]['project_id'] + '" project_name="' + prod[i]['project_name'] + '"><i class="icon lindo-tick fz-24 m-p-w"></i> </button>'
                option += '</td>'
                option += '<td><input type="hidden" id="project_name' + prod[i]['project_id'] + '" value="' + prod[i]['project_name'] + '"></td>'
                option += '<td><input type="hidden" id="project_id' + prod[i]['project_id'] + '" value="' + prod[i]['project_id'] + '"></td>'
                option += '</tr>';
                count++;
            }
        }

        $('.projectsearch').html(option);
    });
    $('body').on('click', '.pickprjct', function () {


        var id = $(this).attr('sel-id');
        var pr_name = $('#project_name' + id).val();
        var pr_id = $('#project_id' + id).val();
        $('#project_span').val(pr_name);
        $('#projectidspan').val(pr_id);
        $("#productsearchModal").hide();
    });
    $('body').on('click', '#btn_addmodule', function () {
        var add_module = $('.promain').clone();
        add_module.closest('div.promain').show();
        add_module.closest('div.promain').find('.remove').removeClass('no-display');
        add_module.closest('div.promain').removeClass('promain');
        add_module.find('input').val('');
        add_module.find('textarea').val('');
        $('.outer').append(add_module);
    });
    $('body').on('click', '.remove', function (e) {
        var s = $(this).closest('.promain_div');
        e.preventDefault();
        $(this).parents().closest('.remove_div').remove();
        var bl1 = $(".module_tot_cost").val();
        var bl2 = s.find(".product_cost").val();
        var mark_up = $(".markup_cost").val();
        if (bl2 != '') {
            var bl3 = parseFloat(bl1) - parseFloat(bl2);
            var bl4 = parseFloat(bl3) + parseFloat(mark_up);
            $(".module_tot_cost").val(bl3);
            $(".total_cost").val(bl4);
        } else {
            $(".module_tot_cost").val(bl1);
        }

    });


    $("body").on('keyup click', '.product_cost,#markup_cost,#amount,#percentage', function () {

        var subtotal = 0;
        var total_cost = 0;
        $('.product_cost').each(function () {
            subtotal += parseFloat($(this).val());
        });
        $('#markup_cost').show();
        $('#module_tot_cost').val(subtotal);
        var val1 = $('#module_tot_cost').val();
        var markup = $('#markup_cost').val();
        if ($('.percentage').is(':checked')) {
            var val3 = val1 * (markup / 100);
            var sum = parseFloat(val1) + parseFloat(val3);
        } else {
            var sum = parseFloat(val1) + parseFloat(markup);
        }
        $('#total_cost').val(sum);

    });


    $('body').on('click', '#editpackage', function () {
        var package_id = $(this).attr('package_id');
        var selected_emp = [];
        $('#jquery_mask').show();
        $.post(siteurl + '/Pms/Project/edit_package_master', {package_id: package_id}, function (data) {
            $('#jquery_mask').hide();
            if (data) {
                selected_emp = JSON.parse(data);
                $('#editModal #package_name').val(selected_emp.pkg_name);
                $('#editModal #package_type').val(selected_emp.pkg_type);
                $('#editModal #package_master_id').val(selected_emp.package_id);
            }
        });
    });

    $('body').on('click', '#project_type_del', function ()
    {
        var tr = $(this).closest('.main_tr');
        var project_type_id = $(this).attr('ids_delete');
        $('#jquery_mask').show();
        $.post(siteurl + '/Pms/Project/delete_project_type', {project_type_id: project_type_id}, function (data) {
            $('#jquery_mask').hide();
            location.reload();
        });

    });


    $('body').on('click', '#editprojecttype', function () {
        var project_type_id = $(this).attr('project_type_id');
        var selected_type = [];
        $('#jquery_mask').show();
        $.post(siteurl + '/Pms/Project/edit_project_type', {project_type_id: project_type_id}, function (data) {
            $('#jquery_mask').hide();
            if (data) {
                selected_type = JSON.parse(data);
                $('#editModal #project_type_edit').val(selected_type.project_type);
                $('#editModal #project_type_id').val(selected_type.id);
            }
        });
    });

    $('body').on('click', '#product_delete', function () {
        var product_delete_id = $(this).attr('product_delete_id');
        var nearest = $(this).closest('tr');
        var s = $(this).closest('tr');
        swal({
            title: "Are you sure?",
            text: "You are going to delete this Product",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes, delete !",
            cancelButtonText: "No, don't delete !",
            closeOnConfirm: false,
            closeOnCancel: false
        },
                function (isConfirm) {
                    if (isConfirm) {
                        $('#jquery_mask').show();
                        $.ajax({
                            url: siteurl + "/Pms/Project/delete_product",
                            data: {product_delete_id: product_delete_id},
                            cache: false,
                            datatype: "json",
                            type: "post",
                            success: function (d) {
                                $('#jquery_mask').hide();
                                $(s).remove();
                                swal("Deleted!", "Product has been deleted.", "success");
                                location.reload();
                            },
                            fail: function (d) {
                                $('#jquery_mask').hide();
                                swal("Cannot delete!", "Product cannot be deleted.", "error");
                            }
                        });
                    } else {
                        swal("Cancelled", "Product is not deleted ", "error");
                    }
                });
        return false;
    });


    $('body').on('click', '#btn_addmodule_edit', function () {
        var add_module = $('.promainedit_div').clone();
        add_module.closest('div.promainedit').show();
        add_module.closest('div.promainedit').find('.removeedit').removeClass('no-display');
        add_module.closest('div.promainedit').removeClass('promainedit_div');
        add_module.find('input').val('');
        add_module.find('textarea').val('');
        $('.outer').append(add_module);
    });

    $('body').on('click', '.removeedit', function (e) {
        var s = $(this).closest('.promainedit');
        e.preventDefault();
        $(this).parents().closest('.remove_div_edit').remove();
        var bl1 = $(".module_tot_cost").val();
        var bl2 = s.find(".product_cost").val();
        var mark_up = $(".markup_cost").val();
        if (bl2 != '') {
            var bl3 = parseFloat(bl1) - parseFloat(bl2);
            var bl4 = parseFloat(bl3) + parseFloat(mark_up);
            $(".module_tot_cost").val(bl3);
            $(".total_cost").val(bl4);
        } else {
            $(".module_tot_cost").val(bl1);
        }

    });

    $('body').on('click', '#package_delete', function () {
        var package_delete_id = $(this).attr('package_delete_id');
        var nearest = $(this).closest('tr');
        var s = $(this).closest('tr');
        swal({
            title: "Are you sure?",
            text: "You are going to delete this Package",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes, delete !",
            cancelButtonText: "No, don't delete !",
            closeOnConfirm: false,
            closeOnCancel: false
        },
                function (isConfirm) {
                    if (isConfirm) {
                        $('#jquery_mask').show();
                        $.ajax({
                            url: siteurl + "/Pms/Project/delete_package",
                            data: {package_delete_id: package_delete_id},
                            cache: false,
                            datatype: "json",
                            type: "post",
                            success: function (d) {
                                $('#jquery_mask').hide();
                                $(s).remove();
                                swal("Deleted!", "Package has been deleted.", "success");
                                location.reload();
                            },
                            fail: function (d) {
                                $('#jquery_mask').hide();
                                swal("Cannot delete!", "Package cannot be deleted.", "error");
                            }
                        });
                    } else {
                        swal("Cancelled", "Package is not deleted ", "error");
                    }
                });
        return false;
    });


});