$(document).ready(function () {
    $(window).load(function () {
        if (typeof old_rate !== 'undefined' && typeof new_rate !== 'undefined' && parseFloat(old_rate) != parseFloat(new_rate)) {
            swal({
                title: "Transaction Rate Changed",
                text: "Do you want to apply the new rate",
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "Yes, Apply !",
                cancelButtonText: "No, don't apply !",
                closeOnConfirm: false,
                closeOnCancel: false
            },
                    function (isConfirm) {
                        if (isConfirm) {
                            $('.currency_rate').val(new_rate);
                            $('.cur_trans_rate_id').val(new_cur_trans_rate_id);
                            swal("Rate Changed", "New Rate applied", "success");
                        } else {
                            swal("Cancelled", "Previous Rate will prevail", "success");
                        }
                    });
        }
    });
//    $('body').on('click', '#no_amc_tab', function () {
//        window.location.href = siteurl + "/Service/Amc/no_amc_list/";
//    });

   $('body').on('click', '.pagesubmit', function (e) {
        e.preventDefault();

        var search_item = $('#search_item').val();
        $('#search_item_hidden').val(search_item);
        var url = $(this).attr('href');
        $('#paginationfilter').attr('action', url);
        $('#paginationfilter').submit();
    });
    $('body').on('click', '#rec_type_custom', function () {
        var name = $(this).attr("name");
        var name_array = name.split('_');
        $('.customdiv_' + name_array[2]).removeClass('no-display');
    });
    $('body').on('click', '#rec_type_weekly', function () {
        var name = $(this).attr("name");
        var name_array = name.split('_');
        $('.customdiv_' + name_array[2]).addClass('no-display');
    });
    $('body').on('click', '#rec_type_monthly', function () {
        var name = $(this).attr("name");
        var name_array = name.split('_');
        $('.customdiv_' + name_array[2]).addClass('no-display');
    });
    $('body').on('click', '#rec_type_daily', function () {
        var name = $(this).attr("name");
        var name_array = name.split('_');
        $('.customdiv_' + name_array[2]).addClass('no-display');
    });
    $('body').on('click', '#rec_type_quarterly', function () {
        var name = $(this).attr("name");
        var name_array = name.split('_');
        $('.customdiv_' + name_array[2]).addClass('no-display');
    });
    $('body').on('click', '.amc_type_recursive', function () {
        var clid = $(this).attr('id-cld');
        $('.recursive_div_' + clid).removeClass('no-display');
        $('.no_recursive_div_' + clid).addClass('no-display');
        $('.custom_sch_div_' + clid).addClass('no-display');
        $('.no_custom_sch_div_' + clid).removeClass('no-display');
        $(this).val('recursive');
    });
    $('body').on('click', '.amc_type_custom', function () {
        var clid = $(this).attr('id-cld');
        $('.recursive_div_' + clid).addClass('no-display');
        $('.no_recursive_div_' + clid).removeClass('no-display');
        $('.custom_sch_div_' + clid).removeClass('no-display');
        $('.no_custom_sch_div_' + clid).addClass('no-display');
        $(this).val('custom');
        var aa = $('.custom_sch_div_' + clid).find('.clone2');
        if (aa.find('#serviceno').val() == '') {
            aa.remove();
        }
    });

    $('body').on('click', '.add_new', function (e) {
        var serviceno = $('.serviceno:last').val();
        var month = $('.month:last').val();
        var period = $('.period:last').val();
        if (serviceno == '' || month == '' || period == '') {
            swal('Please enter valid custom schedule entry');
        } else {
            e.preventDefault();
            var att = $(this).attr('add_no');
            var bc = $(this).closest('.new_amc_clone').find('.clone').clone();
            bc.removeClass('clone');
            bc.addClass('new_clone');
            bc.find('.clear').remove();
            bc.removeClass('clone');
            var gg = bc.find("input");
            gg.val("");
            bc.find('.month').val("");
            var cc = bc.find('.no-display');
            cc.removeClass('no-display');
            var dd = bc.find(".recursive");
            dd.addClass('no-display');
            var dd = bc.find(".rec");
            dd.addClass('no-display');
            var ee = bc.find(".clear_amc");
            ee.removeClass('no-display');
            var ff = bc.find(".clear_amc_first");
            ff.addClass('no-display');

            bc.appendTo($(this).closest('.new_amc_clone').find('.ck_amc_list'));
        }
    });
    $('body').on('click', '.clear_amc', function () {
        $(this).closest('tr').remove();
    });

    $('body').on('click', '.clear_amc_first', function () {
        $(this).closest('tr').find("input[type=text],input[type=number],textarea,select").val('');
    });
    var count = 1;
    $('body').on('click', '#add_amc', function (e) {
        var amcname = $('.amcname:last').val();
        if (amcname == '') {
            swal('Please enter valid entry');
        } else {
            var clid = $(".new_amc_clone:last").attr('id-cld');
            var nxt = parseFloat(clid) + 1;
            var bc = $(".clones").clone();
            bc.attr("id-cld", nxt);
            bc.removeClass('clones');
            bc.addClass('new_clones');
            var dd = bc.find("input");
            dd.val("");
            bc.removeClass('clone2');
            bc.find('.clone2').remove();
            bc.find('.deafault_amc').prop("checked", false);
            bc.find('.month').val("");
            bc.find('.serviceno').attr('name', 'serviceno_' + nxt + '[]');
            bc.find('.month').attr('name', 'month_' + nxt + '[]');
            bc.find('.period').attr('name', 'period_' + nxt + '[]');
            bc.find('.ck_recursive').attr('name', 'ck_recursive_' + nxt);
            bc.find('.price').attr('name', 'price_' + nxt);
            bc.find('.amc_id').attr('name', 'amc_id' + nxt);
            bc.find('.amcname').attr('name', 'amcname_' + nxt);
            bc.find('.amc_type_custom').attr('name', 'amc_type_' + nxt);
            bc.find('.amc_type_recursive').attr('name', 'amc_type_' + nxt);
            bc.find('.rec_type_daily').attr('name', 'rec_type_' + nxt);
            bc.find('.rec_type_weekly').attr('name', 'rec_type_' + nxt);
            bc.find('.rec_type_monthly').attr('name', 'rec_type_' + nxt);
            bc.find('.rec_type_quarterly').attr('name', 'rec_type_' + nxt);
            bc.find('.rec_type_custom').attr('name', 'rec_type_' + nxt);
            bc.find('.add_service_fr_amc').attr('id_ser_btn', nxt);
            bc.find('.rec_type_daily').val('daily');
            bc.find('.rec_type_weekly').val('weekly');
            bc.find('.rec_type_monthly').val('monthly');
            bc.find('.rec_type_quarterly').val('quarterly');
            bc.find('.rec_type_custom').val('custom');
            bc.find('.custom_type').attr('name', 'custom_type_' + nxt);
            bc.find('.custom_count').attr('name', 'custom_count_' + nxt);
            bc.find('.addtl_parts_div').attr('print_div_id', nxt);
            bc.find('.no_data').attr('print_div_id', nxt);
            bc.find('.amc_type_recursive').prop('checked', false);
            bc.find('.amc_type_custom').prop('checked', false);
            $('#amccount').val(nxt);
            bc.find('.new_clone').addClass('no-display');
            bc.find('.addtl_parts_div').addClass('no-display');
            bc.find('.add_new').removeClass('no-display');
            bc.find('.delete_amc').removeClass('no-display');
            bc.find('.no_data').removeClass('no-display');
            bc.find('.recursive').prop('checked', false);
            bc.find('.ck_recursive').val(0);
            bc.find('.amc_id').val(0);
            bc.find('.deafault_amc').val(nxt);
            bc.find('.deleteamc').attr("id-cld", nxt);
            bc.find('.amc_type_custom').attr("id-cld", nxt);
            bc.find('.amc_type_recursive').attr("id-cld", nxt);
            bc.find('.recursive_div_1').addClass('recursive_div_' + nxt);
            bc.find('.custom_sch_div_1').addClass('custom_sch_div_' + nxt);
            bc.find('.recursive_div_1').removeClass('recursive_div_1');
            bc.find('.custom_sch_div_1').removeClass('custom_sch_div_1');
            bc.find('.no_recursive_div_1').addClass('no_recursive_div_' + nxt);
            bc.find('.no_custom_sch_div_1').addClass('no_custom_sch_div_' + nxt);
            bc.find('.no_recursive_div_1').removeClass('no_recursive_div_1');
            bc.find('.no_custom_sch_div_1').removeClass('no_custom_sch_div_1');
            bc.find('.customdiv_1').addClass('customdiv_' + nxt);
            bc.find('.custom_sch_div_' + nxt).addClass('no-display');
            bc.find('.no_custom_sch_div_' + nxt).removeClass('no-display');
            bc.find('.customdiv_1').removeClass('customdiv_1');
            bc.addClass('newclone_' + nxt);
            bc.removeClass('newclone_1');

            bc.find('.recursive_div_' + nxt).addClass('no-display');


            var att = $('.chec').attr('recur_no');

            if (att !== 0) {
                bc.find('.recursive').attr('recur_no', count);
            }

            bc.find('.add_new').attr('add_no', count)
            count++;

            bc.appendTo(".new_amc");
            bc.find('.amc_head').text('AMC-' + nxt + '')
        }
    });
    $('body').on('click', '.deleteamc', function () {
        var clid = $(this).attr('id-cld');
        $(this).closest('.newclone_' + clid).remove();
    });
    $('body').on('keyup', '.custom_count', function () {
        var count = $(this).val();
        var name = $(this).attr("name");
        var name_array = name.split('_');
        var select_name = 'custom_type_' + name_array[2];
        var custom_type = $('select[name="' + select_name + '"]').val();

        if (count == 1 && custom_type == 'day')
        {
            $('.recursive_div_' + name_array[2]).find('.rec_type_daily').prop('checked', true);
            $('.recursive_div_' + name_array[2]).find('.custom_div').addClass('no-display');


        } else {
            $('.recursive_div_' + name_array[2]).find('.rec_type_daily').prop('checked', false);
        }
        if (count == 7 && custom_type == 'day')
        {
            $('.recursive_div_' + name_array[2]).find('.rec_type_weekly').prop('checked', true);
            $('.recursive_div_' + name_array[2]).find('.custom_div').addClass('no-display');
        } else {
            $('.recursive_div_' + name_array[2]).find('.rec_type_weekly').prop('checked', false);
        }
        if (count == 1 && custom_type == 'month')
        {
            $('.recursive_div_' + name_array[2]).find('.rec_type_monthly').prop('checked', true);
            $('.recursive_div_' + name_array[2]).find('.custom_div').addClass('no-display');
        } else {
            $('.recursive_div_' + name_array[2]).find('.rec_type_monthly').prop('checked', false);
        }
        if (count == 3 && custom_type == 'month')
        {
            $('.recursive_div_' + name_array[2]).find('.rec_type_quarterly').prop('checked', true);
            $('.recursive_div_' + name_array[2]).find('.custom_div').addClass('no-display');
        } else {
            $('.recursive_div_' + name_array[2]).find('.rec_type_quarterly').prop('checked', false);
        }
    });
    $('body').on('change', '.custom_type', function () {
        var custom_type = $(this).val();
        var name = $(this).attr("name");
        var name_array = name.split('_');
        var select_name = 'custom_count_' + name_array[2];
        var count = $('input[name="' + select_name + '"]').val();

        if (count == 1 && custom_type == 'day')
        {
            $('.recursive_div_' + name_array[2]).find('.rec_type_daily').prop('checked', true);
            $('.recursive_div_' + name_array[2]).find('.custom_div').addClass('no-display');


        } else {
            $('.recursive_div_' + name_array[2]).find('.rec_type_daily').prop('checked', false);
        }
        if (count == 7 && custom_type == 'day')
        {
            $('.recursive_div_' + name_array[2]).find('.rec_type_weekly').prop('checked', true);
            $('.recursive_div_' + name_array[2]).find('.custom_div').addClass('no-display');
        } else {
            $('.recursive_div_' + name_array[2]).find('.rec_type_weekly').prop('checked', false);
        }
        if (count == 1 && custom_type == 'month')
        {
            $('.recursive_div_' + name_array[2]).find('.rec_type_monthly').prop('checked', true);
            $('.recursive_div_' + name_array[2]).find('.custom_div').addClass('no-display');
        } else {
            $('.recursive_div_' + name_array[2]).find('.rec_type_monthly').prop('checked', false);
        }
        if (count == 3 && custom_type == 'month')
        {
            $('.recursive_div_' + name_array[2]).find('.rec_type_quarterly').prop('checked', true);
            $('.recursive_div_' + name_array[2]).find('.custom_div').addClass('no-display');
        } else {
            $('.recursive_div_' + name_array[2]).find('.rec_type_quarterly').prop('checked', false);
        }
    });
    $('body').on('keyup', '.period', function () {

        var month = $(this).closest('tr').find('.month').val();
        if (month == "Month" && Number($(this).val()) > 12)
        {
            $(this).val('');
        }
        if (month == "days" && Number($(this).val()) > 31)
        {
            $(this).val('');
        }
    });

    $("#btn_invno_go").on('click', function ()
    {
        var invoice_number = $('#invoice_number').val();
        var inv_details = [];
        if (invoice_number == "")
        {
            swal('Enter Invoice number');
        } else {

            $.post(siteurl + "/Service/Amc/get_invoice_for_view_amc", {invoice_number: invoice_number}, function (data)
            {
                if (data != "") {

                    inv_details = JSON.parse(data);
                    var inv_id = inv_details.inv_id;
                    var invoice_method = inv_details.invoice_method;

                    if (invoice_method == "sales_order") {
                        window.location.href = siteurl + "/Inventory/Invoice/get_invoice_for_view/" + inv_id;
                    } else if (invoice_method == "direct") {
                        window.location.href = siteurl + "/Inventory/Direct_invoice/get_directinvoice_for_view/" + inv_id;
                    } else {
                        swal('Invoice Does Not Exist');
                    }
                }
            });
        }
    });

    $("#btn_cnt_go").on('click', function ()
    {
        var contactname = $('#contact_dtl').val();
        var inv_details = [];
        if (contactname == "")
        {
            swal('Enter contact details');
        } else {

            $.post(siteurl + "/Service/Amc/get_inv_by_contact", {contactname: contactname}, function (data)
            {
                inv_details = JSON.parse(data);

                var disp = '';
                if (inv_details != "") {
                    disp += '<thead>';
                    disp += '<th>INVOICE NO</th>';
                    disp += '<th>INVOICE DATE</th>';
                    disp += '<th>DUE DATE</th>';
                    disp += '<th>INV TYPE</th>';
                    disp += '<th>AMOUNT</th>';
                    disp += '</thead>';
                    for (var i = 0; i < inv_details.length; i++)
                    {
                        if (inv_details[i]['inv_id'] != null) {
                            disp += '<tr>';
                            disp += '<td>' + inv_details[i]['invoice_number'] + '</td>';
                            disp += '<td>' + inv_details[i]['invo_date'] + '</td>';
                            disp += '<td>' + inv_details[i]['due_date'] + '</td>';
                            disp += '<td>' + inv_details[i]['invoice_type'] + '</td>';
                            disp += '<td>' + inv_details[i]['grandtotal'] + '</td>';
                            disp += '<td> <input type="button" class="btn btn-success pull-right amc_renew_btn" value="View Invoice" inv_id="' + inv_details[i]['inv_id'] + '"></td>';
                            disp += '</tr>';

                        }
                    }
                } else {
                    disp = 'No Invoice Available';
                }

                $('.inv_dtls').removeClass('no-display');
                $('.sl_div').addClass('no-display');
                $('#barcode_avail').addClass('no-display');
                $('.main_tr_invoice').html(disp);

            });
        }
    });


    $('body').on('click', '.amc_renew_btn', function ()
    {
        var inv_id = $(this).attr('inv_id');
        var invoice_number = 'IN-' + inv_id;
        var inv_details = [];
        $.post(siteurl + "/Service/Amc/get_invoice_for_view_amc", {invoice_number: invoice_number}, function (data)
        {
            if (data != "") {

                inv_details = JSON.parse(data);
                var inv_id = inv_details.inv_id;
                var invoice_method = inv_details.invoice_method;
                if (invoice_method == "sales_order") {
                    window.location.href = siteurl + "/Inventory/Invoice/get_invoice_for_view/" + inv_id;
                } else if (invoice_method == "direct") {
                    window.location.href = siteurl + "/Inventory/Direct_invoice/get_directinvoice_for_view/" + inv_id;
                } else {
                    swal('Invoice Dosenot Exist');
                }
            }
        });

    });


    $("#btn_slno_go").on('click', function ()
    {
        var serial_number = $('#serial_number').val();
        if (serial_number == "")
        {
            swal('Enter Serial number');
        } else {
            window.location.href = siteurl + "/Service/Amc/renew_amc/" + serial_number;
        }
    });


    $('body').on('click', '.renew_amc_slno', function ()
    {
        var item_id = $(this).attr('item_id');
        var item_name = $(this).attr('item_name');
        var slno = $(this).attr('slno');
        var valid_to = $(this).attr('valid_to');
        var json_array = [];
        $.post(siteurl + "/Service/Amc/get_amc_item_id", {item_id: item_id}, function (data)
        {
            json_array = JSON.parse(data);
            var disp = '';
            if (json_array != "") {
                disp += '<thead>';
                disp += '<th></th>';
                disp += '<th>AMC Name</th>';
                disp += '<th>Price</th>';
                disp += '</thead>';
                for (var i = 0; i < json_array.length; i++)
                {
                    disp += '<tr>';
                    disp += '<td><input type="radio" name="amcradio_renew"  class="amcradio_renew" amc_name="' + json_array[i]['amc_name'] + '"  valid_to="' + valid_to + '"    item_name="' + item_name + '"  slno="' + slno + '"  item_id="' + item_id + '"   price="' + json_array[i]['price'] + '"  amc_id="' + json_array[i]['amc_id'] + '">';
                    disp += '</td>';
                    disp += '<td>' + json_array[i]['amc_name'] + '</td>';
                    disp += '<td>' + json_array[i]['price'] + '</td>';
                    disp += '</tr>';
                }
            } else {

                disp += '<thead>';
                disp += '<th>No AMC available</th>';
                disp += '</thead>';
            }
            $('.amctable_slno').html(disp);

        });
    });

    $('body').on('click', '.amcradio_renew', function () {
        var item_id = $(this).attr('item_id');
        var item_name = $(this).attr('item_name');
        var slno = $(this).attr('slno');
        var amc_id = $(this).attr('amc_id');
        var amc_name = $(this).attr('amc_name');
        var amc_price = $(this).attr('price');
        var valid_to = $(this).attr('valid_to');
        var date = new Date(valid_to);
        var dd = date.getDate() + 1;
        var mm = date.getMonth() + 1;
        var yyyy = date.getFullYear();
        var llll = date.getFullYear() + 1;
        if (dd < 10) {
            dd = '0' + dd
        }

        if (mm < 10) {
            mm = '0' + mm
        }
        var start_date = yyyy + '-' + mm + '-' + dd;
        var end_date = llll + '-' + mm + '-' + dd;
        var disp = '';
        disp += '<tr class="amctr_' + slno + '" slno="' + slno + '"  id-cl="' + slno + '">';
        disp += '<td><input type="text" readonly  class="form-control amc_item" value="' + item_name + '" name="amc_item[]"><input type="hidden" readonly  class="amc_item_id" value="' + item_id + '" name="amc_item_id[]">';
        disp += '</td>';
        disp += '<td><input type="text" readonly  class="form-control amc_item_slno" value="' + slno + '" name="amc_item_slno[]">';
        disp += '</td>';
        disp += '<td> <input type="text" readonly  class="form-control amc_name" value="' + amc_name + '" name="amc_name[]"><input type="hidden" readonly  class="form-control amc_id" value="' + amc_id + '" name="amc_id[]">';
        disp += '</td>';
        disp += '<td> <input type="text"   class="form-control datepicker start_date' + slno + ' start_date" value="' + start_date + '" name="start_date[]"  st_date="' + start_date + '">';
        disp += '</td>';
        disp += '<td> <input type="text" readonly  class="form-control  datepicker end_date' + slno + ' end_date" value="' + end_date + '" name="end_date[]">';
        disp += '</td>';
        disp += '<td> <input type="text" class="form-control amc_price' + slno + ' amc_price" value="' + amc_price + '" name="amc_price[]">';
        disp += '</td>';
        disp += '<td> <input type="text" class="form-control amc_qty' + slno + ' amc_qty" value="1" name="amc_qty[]">';
        disp += '</td>';
        disp += '<td> <input type="text" class="form-control amc_disc' + slno + ' amc_disc" value="0" name="amc_disc[]">';
        disp += '</td>';
        disp += '<td> <input type="text" readonly class="form-control amc_amount' + slno + '  amc_amount" value="' + amc_price + '" name="amc_amount[]">';
        disp += '</td>';
        disp += '</tr>';
        $('.amc_details_renew').html(disp);
        $('.datepicker').datepicker({
            dateFormat: 'yy-mm-dd',
            minDate: new Date(start_date)
        });

        $('#amclookup_renew_amc').modal('hide');
        $('.renew_amc_div').removeClass('no-display');
    });

    $('body').on('keyup', '.amc_price,.amc_qty,.amc_disc', function () {
        var rowid = $(this).closest('tr').attr('id-cl');
        var amc_qty = $('.amc_qty' + rowid).val();
        var amc_price = $('.amc_price' + rowid).val();
        var amc_disc = $('.amc_disc' + rowid).val();
        var start_date = $('.start_date' + rowid).val();
        var originalDate = new Date(start_date);
        var dd = originalDate.getDate();
        var mm = originalDate.getMonth() + 1;
        var yyyy = originalDate.getFullYear() + parseInt(amc_qty);
        if (dd < 10) {
            dd = '0' + dd
        }

        if (mm < 10) {
            mm = '0' + mm
        }
        var end_date = yyyy + '-' + mm + '-' + dd;
        $('.end_date' + rowid).val(end_date);

        var amt_1 = (parseFloat(amc_qty) * parseFloat(amc_price));
        if (amc_disc > 0)
        {
            var amt = parseFloat(amt_1) - (parseFloat(amt_1) * parseFloat(amc_disc) / 100);
        } else {
            var amt = amt_1;
        }
        $('.amc_amount' + rowid).val(amt);
    });



    $('body').on('change', '.start_date', function () {

        var current_date = $(this).attr('st_date');
        var rowid = $(this).closest('tr').attr('id-cl');
        var amc_qty = $('.amc_qty' + rowid).val();
        var start_date = $('.start_date' + rowid).val();
        var originalDate = new Date(start_date);
        var dd = originalDate.getDate();
        var mm = originalDate.getMonth() + 1;
        var yyyy = originalDate.getFullYear() + parseInt(amc_qty);
        if (dd < 10) {
            dd = '0' + dd
        }

        if (mm < 10) {
            mm = '0' + mm
        }
        var end_date = yyyy + '-' + mm + '-' + dd;

        if (start_date < current_date) {
            swal('invalid date');
            $('.start_date' + rowid).val(current_date);
        } else {
            $('.end_date' + rowid).val(end_date);
        }
    });

    //------------------------------------------------------------------------------------------------------------------------------------
    $('body').on('click', '.amc_btn', function ()
    {
        var item_id = $(this).attr('item_id');
        var item_name = $(this).attr('item_name');
        var inv_id = $(this).attr('inv_id');
        var tr = $('.amc_id').val();
        var inv_del_id = $(this).attr('inv_del_id');
        var default_amc = $(this).attr('default_amc');
        var amc_id = $(this).attr('amc_id');
        var barcode_dtl_default = [];
        if (default_amc == 1) {

            $.post(siteurl + "/Service/Amc/get_amc_item_id", {item_id: item_id}, function (data)
            {
                var json_array = JSON.parse(data);
                var disp = '';
                if (json_array != "") {
                    disp += '<thead>';
                    disp += '<th></th>';
                    disp += '<th>AMC Name</th>';
                    disp += '<th>Price</th>';
                    disp += '</thead>';
                    for (var i = 0; i < json_array.length; i++)
                    {
                        if (json_array[i]['amc_id'] !== amc_id) {
                            disp += '<tr>';
                            disp += '<td><input type="radio" name="amcradio" data-target="#barcodeitmlookup_view_default"  data-toggle="modal" class="amcradio_default" amc_name="' + json_array[i]['amc_name'] + '"  inv_del_id="' + inv_del_id + '" inv_del_id="' + inv_del_id + '"  item_name="' + item_name + '" item_id="' + item_id + '" inv_id="' + inv_id + '"  price="' + json_array[i]['price'] + '"  amc_id="' + json_array[i]['amc_id'] + '" default_amc_id="' + amc_id + '">';
                            disp += '</td>';
                            disp += '<td>' + json_array[i]['amc_name'] + '</td>';
                            disp += '<td>' + json_array[i]['price'] + '</td>';
                            disp += '</tr>';
                        }
                    }
                } else {

                    disp += '<thead>';
                    disp += '<th>No AMC available</th>';
                    disp += '</thead>';
                }
                $('.amctable_default').html(disp);
            });

        } else {
            amclist(item_id, inv_id, item_name, inv_del_id);
        }


    });

    $('body').on('click', '.amcradio_default', function ()
    {
        var item_name = $(this).attr('item_name');
        var amc_name = $(this).attr('amc_name');
        var item_id = $(this).attr('item_id');
        var inv_id = $(this).attr('inv_id');
        var default_amc_id = $(this).attr('default_amc_id');
        var itm_do_id = $(this).attr('itm_do_id');
        var do_id = $(this).attr('inv_del_id');
        var price = $(this).attr('price');
        var amc_id = $(this).attr('amc_id');
        var inv_del_id = $(this).attr('inv_del_id');
        var barcode_dtl_default = [];
        $.post(siteurl + "/Service/Amc/get_valid_to", {item_id: item_id, inv_del_id: inv_del_id, default_amc_id: default_amc_id}, function (data)
        {
            barcode_dtl_default = JSON.parse(data);

            var disp1 = '';

            if (barcode_dtl_default != "") {
                disp1 += '<thead>';
                disp1 += '<th></th>';
                disp1 += '<th>Item Name</th>';
                disp1 += '<th>SL No</th>';
                disp1 += '<th>Valid To</th>';
                disp1 += '</thead>';
                for (var i = 0; i < barcode_dtl_default.length; i++)
                {
                    disp1 += '<tr>';
                    disp1 += '<td><input type="checkbox" name="barcode_check" class="barcode_check" valid_to="' + barcode_dtl_default[i]['valid_to'] + '"  amc_name="' + amc_name + '" slno="' + barcode_dtl_default[i]['barcode'] + '" inv_del_id="' + inv_del_id + '" item_name="' + item_name + '" item_id="' + item_id + '" inv_id="' + inv_id + '"  price="' + price + '"  amc_id="' + amc_id + '" >';
                    disp1 += '</td>';
                    disp1 += '<td>' + item_name + '</td>';
                    disp1 += '<td>' + barcode_dtl_default[i]['barcode'] + '</td>';
                    disp1 += '<td>' + barcode_dtl_default[i]['valid_to'] + '</td>';
                    disp1 += '</tr>';
                }
            }
            $('.barcodetable_default').html(disp1);
        });

    });

    $('body').on('keyup', '#ser_range', function () {
        var ser_range = $(this).val();
        $(".ser_amount").val(ser_range);
        $(".ser_total").val(ser_range);

    });

    //cost center in add non inventory
    $("body").on('change', '.cost_center', function () {
        var rowid = $(this).closest('div .div_clone').attr('id-cl');
        var sll = $('[id-cl=' + rowid + ']');
        var cost_center_id = $(this).val();
        $('#jquery_mask').show();
        $.post(siteurl + "/Service/Grv/get_costcenter_category_by_id", {cost_center_id: cost_center_id}, function (data) {
            $('#jquery_mask').hide();
            sll.find('.cost_center_category').html(data);
        });
    });

    //cost center category in add non inventory products
    $("body").on('change', '.cost_center_category', function () {
        var category_id = $(this).val();
        var rowid = $(this).closest('div .div_clone').attr('id-cl');
        var sll = $('[id-cl=' + rowid + ']');
        $('#jquery_mask').show();
        $.post(siteurl + "/Service/Grv/get_rate_category_by_id", {category_id: category_id}, function (data) {
            $('#jquery_mask').hide();
            var rate = JSON.parse(data);
            var hourly_rate = (rate['rate_details'][0]['hourly_rate']);
            var day_rate = (rate['working_hour'][0]['working_hours']);
            var rate_id = (rate['rate_details'][0]['rate_master_id']);
            sll.find('.rate_master_id').val(rate_id);
            sll.find('.rate_by_category').val(hourly_rate);
            sll.find('.day_hour').val(day_rate);
        });
    });

    $('body').on('change', '.estimate_radio_hour,.estimate_radio_day,.estimate,.cost_center_category', function () {
        $(".estimate").trigger("keyup");
    });


    //estimate in add non inventory services
    $("body").on('keyup', '.estimate', function () {
        var rowid = $(this).closest('div .div_clone  ').attr('id-cl');
        var sll = $('[id-cl=' + rowid + ']');
        var aa = sll.find('#cost_center');
        var bb = sll.find('#cost_center_category');
        var cc = sll.find('#amount');
        var fb = sll.find('#cost_type');
        var dd = sll.find('#rate_by_category');
        var ds = sll.find('#day_hour');
        var di = sll.find('#estimate');
        var tt = $('.final_rate_total');
        var tc = $('#full_cost_center');
        var tcc = $('#full_cost_center_category');
        var tra = $('#ind_rate');
        var tsa = $('#ind_type');
        var est = $('#ind_estimate_value');
        var estf = $('#rate_id_full');
        if (aa.val()) {
            var cost_center = aa.val();
        }
        if (bb.val()) {
            var cost_center_category = bb.val();
        }
        if (dd.val()) {
            var rate_by_category = dd.val();
        }
        if (ds.val()) {
            var day_hour = ds.val();
        }
        if (di.val()) {
            var input_rate = di.val();
        }
        if (fb.val()) {
            var type_ind = fb.val();
        }

        var input_rate = $(this).val();
        var rate_by_category = sll.find('.rate_by_category').val();
        var rate_day = sll.find('.day_hour').val();
//        var rate_day = Number(rate_day) * Number(rate_by_category);
        var type = '';
        var typearray = [];
        if (sll.find('.estimate_radio_hour').is(':checked')) {
            var final_rate = Number(input_rate) * Number(rate_by_category);
            var type = 'hour';
            sll.find('.ind_final_rate').val(final_rate);
            sll.find('.cost_type').val(type);
            sll.find('.rate_db').val(rate_by_category);
        } else if (sll.find('.estimate_radio_day').is(':checked')) {
            var type = 'day';
            var final_rate = Number(input_rate) * Number(rate_day) * Number(rate_by_category);
            sll.find('.ind_final_rate').val(final_rate);
            sll.find('.cost_type').val(type);
            sll.find('.rate_db').val(rate_day);
        }
        var sum = 0;
        var ratearray = [];
        $('.ind_final_rate').each(function () {
            sum += Number($(this).val());
            ratearray.push($(this).val());
        });
        var cosarray = [];
        var coscatarray = [];
        var ratearray_ind = [];
        var estimate_ind = [];
        var full_ra_id = [];
        $('.cost_center').each(function () {

            cosarray.push($(this).val());
        });
        $('.cost_center_category').each(function () {
            coscatarray.push($(this).val());
        });
        $('.rate_db').each(function () {

            ratearray_ind.push($(this).val());
        });
        $('.cost_type').each(function () {

            typearray.push($(this).val());
        });
        $('.estimate').each(function () {

            estimate_ind.push($(this).val());
        });
        $('.rate_master_id').each(function () {

            full_ra_id.push($(this).val());
        });
        tt.val(parseFloat(sum));
        tra.val(ratearray);
        tsa.val(typearray);
        tc.val(cosarray);
        tcc.val(coscatarray);
        tra.val(ratearray_ind);
        est.val(estimate_ind);
        estf.val(full_ra_id);
    });


    $('body').on('click', '#btn_addservice', function () {
        var ser_unitcoste = $('#ser_unitcoste').val();
        var ser_range = $('#ser_rangeaccu').val();
        var sid = $('#trid_ser_search').val();
        var sll = $('[id-cl_ser=' + sid + ']');
        if (ser_unitcoste == "" || ser_range == "") {
            swal("Enter all details");
        } else {
            $('#ser_unitcost').val(ser_unitcoste);
            var cost_center_id = [];
            $('.cost_center').each(function () {
                if ($(this).val() != '') {
                    cost_center_id.push($(this).val());
                }
            })
            $('.cost_center_id').val(cost_center_id);

            var cost_center_category_id = [];
            $('.cost_center_category').each(function () {
                if ($(this).val() != '') {
                    cost_center_category_id.push($(this).val());
                }
            })
            $('.cost_center_category_id').val(cost_center_category_id);

            var rate_master_id = [];
            $('.rate_master_id').each(function () {
                if ($(this).val() != '') {
                    rate_master_id.push($(this).val());
                }
            })
            $('.final_rate_ids').val(rate_master_id);

            var rate_db = [];
            $('.rate_db').each(function () {
                if ($(this).val() != '') {
                    rate_db.push($(this).val());
                }
            })
            $('.rate_type').val(rate_db);

            var estimate = [];
            $('.estimate').each(function () {
                if ($(this).val() != '') {
                    estimate.push($(this).val());
                }
            })
            $('.hour_day').val(estimate);

            var cost_type = [];
            $('.cost_type').each(function () {
                if ($(this).val() != '') {
                    cost_type.push($(this).val());
                }
            })
            $('.rate_type_value').val(cost_type);

            var sub_total = [];
            $('.ind_final_rate').each(function () {
                if ($(this).val() != '') {
                    sub_total.push($(this).val());
                }
            })
            $('.sub_total').val(sub_total);
            var final_rate_total = $('#final_rate_total').val();
            if (final_rate_total != "") {
                var total = parseFloat(ser_unitcoste) + parseFloat(final_rate_total);
            } else {
                var total = parseFloat(ser_unitcoste);
            }
            $('.ser_amount').val(total);
            $('.ser_total').val(total);
            $('.ser_range').val(ser_range);
            $('#AddService').modal('hide');
            $('#AddService_so').modal('hide');
        }

    });

    //add non inventory service button
    $('body').on('click', '.add_cos_clone', function () {
        var cost_cntr = $('.cost_center:last').val();
        var cat = $('.cost_center_category:last').val();
        var est = $('.estimate:last').val();
        if (cost_cntr == '' || cat == '' || cost_cntr == 'select' || cat == 'select' || est == '' || est == 0) {
            swal("Enter valid cost center entry");
        } else {

            var clone_radio_count = 1;
            var clid = $(".cld:last").attr('id-cl');
            var nxt = parseFloat(clid) + 1;
            var bc = $(".clone_cost_center_div").clone();
            bc.attr("id-cl", nxt);
            var dd = bc.find("input");
            dd.val("");
            bc.find('input[type="radio"]').attr('name', 'estimate_radio' + nxt);
            var abc = 'estimate_radio' + nxt;
            bc.find('input[name=' + abc + ']').attr('checked', false);
            $('.remove_cos_clone').show();
            bc.removeClass('clone_cost_center_div');
            bc.appendTo(".cost_center_div");
        }
    });


    $('body').on('click', '.remove_cos_clone', function (e) {
        var clone_id = $(this).closest('div.cld').attr('id-cl');
        var newvalue = $(this).parents('.div_clone').find('.ind_final_rate').val();
        var currnt = $('.final_rate_total').val();
        var new_value = Number(currnt) - Number(newvalue);
        $('.final_rate_total').val(new_value);
        if (clone_id != 1)
        {
            $(this).closest('div.cld').remove();
        } else
        {
            var dd = $(this).closest('div.cld').find("input");
            dd.val("");
            $(this).closest('div.cld').find('.cost_center_category').val('');
            $(this).closest('div.cld').find('.cost_center').val('');
        }
    });




    $('body').on('click', '.remove_cos_clone_pick', function (e) {
        var clone_id = $(this).closest('div.cld_pick').attr('icl');
        var newvalue = $(this).parents('.div_clone').find('.ind_final_rate_pick').val();
        var currnt = $('.final_rate_total_pick').val();
        var new_value = Number(currnt) - Number(newvalue);
        $('.final_rate_total_pick').val(new_value);
        if (clone_id != 1)
        {
//            $('.cld_pick:last').closest('div').remove();
            $(this).closest('div.cld_pick').remove();
        } else
        {
            var dd = $(this).closest('div.cld_pick').find("input");
            var aa = $(this).closest('div.cld_pick').find("input");
            dd.val("");

        }

//        $(this).parents('.div_clone').remove();
    });

    $('body').on('click', '.remove_cos_clone_so', function (e) {
        var row = $(this).attr('cl');
        var newvalue = $(this).parents('.pick_div').find('.ind_final_rate_pick').val();
        var currnt = $('.final_rate_total_pick').val();
        var new_value = Number(currnt) - Number(newvalue);
        $('.final_rate_total_pick').val(new_value);
        $(this).parents('.pick_div').remove();
    });

    $('body').on('click', '.view_invoice_btn', function ()
    {

        var inv_id = $(this).val();
        var invoice_number = 'IN-' + inv_id;
        var inv_details = [];
        $.post(siteurl + "/Service/Amc/get_invoice_for_view_amc", {invoice_number: invoice_number}, function (data)
        {
            if (data != "") {

                inv_details = JSON.parse(data);
                var inv_id = inv_details.inv_id;
                var invoice_method = inv_details.invoice_method;

                if (invoice_method == "sales_order") {
                    window.location.href = siteurl + "/Inventory/Invoice/get_invoice_for_view/" + inv_id;
                } else if (invoice_method == "direct") {
                    window.location.href = siteurl + "/Inventory/Direct_invoice/get_directinvoice_for_view/" + inv_id;
                } else {
                    swal('Invoice Dosenot Exist');
                }
            }
        });

    });
    $('body').on('click', '#currency_id', function () {
        var currency_id = $(this).val();
        $.post(siteurl + "/Organization/Currencyrate/fetch_currency_rate_by_latest", {currency_id: currency_id}, function (data) {
            var result = JSON.parse(data);
            $('.div_currencyrate').removeClass('no-display');
            $('.currency_rate').val(result.rate);
            $('.cur_trans_rate_id').val(result.cur_trans_rate_id);
            var net_amount = $('#ser_total').val();
            if (typeof result.rate === 'undefined' || result.rate == '') {
                result.rate = 1;
            }

            if (net_amount != 'undefined' && net_amount != '') {
                var transaction_currency = parseFloat(net_amount) * parseFloat(result.rate);
                var tr_currency = transaction_currency.toFixed(2);
                $('#net_currency_amt').val(tr_currency);
            }

        });
    });

    $('body').on('change', '.ser_amount', function () {
        $("#ser_total").trigger("change");
    });
    $('body').on('click', '#btn_addservice', function () {
        $("#ser_total").trigger("change");
    });

    $('body').on('change', '#ser_total,#currency_id', function () {
        var final_amount = $('#ser_total').val();
        var currency_rate = $('#currency_rate').val();
        var final_currency_amt = (final_amount * currency_rate);
        var tr_currency = final_currency_amt.toFixed(2);
        $('.net_currency_amt').val(tr_currency);

    });
    $('body').on('change', '#ser_dis', function () {
        var ser_amount = $('.ser_amount').val();
        var ser_disc = $('.ser_dis').val();

        var currency_rate = $('#currency_rate').val();
        var percentage = (parseFloat(ser_amount) * parseFloat(ser_disc) / 100);
        var net = parseFloat(ser_amount) - parseFloat(percentage);
        var final_currency_amt = (net * currency_rate);
        var tr_currency = final_currency_amt.toFixed(2);
        $('.ser_amount').val(net);
        $('.ser_total').val(net);
        $('.net_currency_amt').val(tr_currency);
    });

    $('body').on('change', '.lpo_date', function () {
        var lpo_date = $('.lpo_date').val();
        $('.datepickerexpect').datepicker({
            dateFormat: 'yy-mm-dd',
            minDate: new Date(lpo_date)

        });
    });

    $('body').on('click', '.clear_amc_first', function () {
        $(this).closest('tr').find("input[type=text],input[type=number],textarea,select").val('');
    });
    $('body').on('click', '.delete_amc_new', function () {
        var amc_id = $(this).attr('amc_id');
        swal({
            title: "Are you sure?",
            text: "You are going to delete this amc",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes, delete !",
            cancelButtonText: "No, don't delete !",
            closeOnConfirm: false,
            closeOnCancel: false
        },
                function (isConfirm) {
                    if (isConfirm) {
                        $('#jquery_mask').show();
                        $.ajax({
                            url: siteurl + '/Service/Amc/delete_amc',
                            data: {amc_id: amc_id},
                            cache: false,
                            datatype: "json",
                            type: "post",
                            success: function (d) {
                                $('#jquery_mask').hide();
                                $(this).closest('div').remove();
                                swal("Deleted!", "Amc has been deleted.", "success");
                                location.reload();
                            },
                            fail: function (d) {
                                $('#jquery_mask').hide();
                                swal("Cannot delete!", "Amc cannot be deleted.", "error");
                            }
                        });
                    } else {
                        swal("Cancelled", "Amc is not deleted ", "error");
                    }
                });

    });
    $('body').on('click', '.add_service_fr_amc', function () {
        var page = $(this).attr('page');
        var id_ser_btn = $(this).attr('id_ser_btn');
        var id = $(this).attr('main_id');
        var row_id = $(this).attr('id_ser_btn');
        $('.parts_add').attr('row_id', id_ser_btn);
        var abc = '';
        var id_array = [];
        var names = "serv_master_ids_" + row_id+'[]';
        $('.serv_master_ids[name="'+names+'"]').each(function () {
            id_array.push($(this).val());
        });
        
        if (page == "item") {
            $.post(siteurl + "/Service/Amc/get_all_service_masters_item", {equipmaster: id}, function (data)
            {
                $('#jquery_mask').hide();
                console.log(data);
                var json_array = JSON.parse(data);
                for (var i = 0; i < json_array.length; i++) {
                    if ($.inArray(json_array[i].service_master_id, id_array) == -1){
                      
                    abc += '<tr>';
                    abc += '<td><div class="checkbox checkbox-success">\n\
                        <input type="checkbox" checked="checked" class="services_id" id="" name="services_id[]" value="' + json_array[i].service_master_id + '" name_ser=' + json_array[i].service_name + ' >\n\
                        <label></label></div></td><td>' + json_array[i].service_name + '</td>';
                    abc += '</tr>';
                }
                }
                $('.service_list').html(abc);
            });
        } else {
            $('#jquery_mask').show();

            $.post(siteurl + "/Service/Amc/get_all_service_masters", {equipmaster: id}, function (data)
            {
                $('#jquery_mask').hide();
                var json_array = JSON.parse(data);
                for (var i = 0; i < json_array.length; i++) {
                    if ($.inArray(json_array[i].service_master_id, id_array) == -1){
                      
                    abc += '<tr>';
                    abc += '<td><div class="checkbox checkbox-success">\n\
                        <input type="checkbox" checked="checked" class="services_id" id="" name="services_id[]" value="' + json_array[i].service_master_id + '" name_ser=' + json_array[i].service_name + ' >\n\
                        <label></label></div></td><td>' + json_array[i].service_name + '</td>';
                    abc += '</tr>'; }
                }
                $('.service_list').html(abc);
            });
        }
    });
    $('body').on('click', '.parts_add', function () {
        var row_id = $(this).attr('row_id');
        var assign_emp_table = '';
        if ($('.services_id').length > 0) {
            assign_emp_table += '<div id="quote_table_view">';
            assign_emp_table += '<table class="table mb-0">';
            assign_emp_table += '<tbody>';
            $('.services_id').each(function () {
                if ($(this).is(":checked")) {
                    assign_emp_table += '<tr>';
                    assign_emp_table += '<td class="w50 pa-5"><label class="w100 pb-5">' + $(this).attr('name_ser');
                    +'</label>';
                    assign_emp_table += '<input type="hidden" class="serv_master_ids" name="serv_master_ids_' + row_id + '[]" value="' + $(this).val() + '"/> </td>';
                    assign_emp_table += '<td class="w50 pa-5">';
                    assign_emp_table += '<a class="inline-block txt-warning pull-right delete_pdt" href="#" id="delete_fixemp" emp_id="' + $(this).val() + '"> <i class="icon lindo-trash-bin-3 txt-danger fz-22"></i></a>';
                    assign_emp_table += '</td>';
                    assign_emp_table += '</tr>';
                }
            });
            assign_emp_table += '</tbody>';
            assign_emp_table += '</table>';
            assign_emp_table += '</div>';
            $('#addtlparts').modal('hide');
            $('#addtl_parts_div[print_div_id="' + row_id + '"]').removeClass('no-display');
            $('.no_data[print_div_id="' + row_id + '"]').addClass('no-display');
            $('#addtl_parts_div[print_div_id="' + row_id + '"]').append(assign_emp_table);
        }
    });
     $('body').on('click', '.delete_pdt', function () {
         $(this).closest('tr').remove();
     });
    
});

function amclist(item_id, inv_id, item_name, inv_del_id) {

    $.post(siteurl + "/Service/Amc/get_amc_item_id", {item_id: item_id}, function (data)
    {

        var json_array = JSON.parse(data);
        var disp = '';
        if (json_array != "") {
            disp += '<thead>';
            disp += '<th></th>';
            disp += '<th>AMC Name</th>';
            disp += '<th>Price</th>';
            disp += '</thead>';
            for (var i = 0; i < json_array.length; i++)
            {
                disp += '<tr>';
                disp += '<td><input type="radio" name="amcradio" data-target="#barcodeitmlookup_view"  data-toggle="modal" class="amcradio" amc_name="' + json_array[i]['amc_name'] + '"  inv_del_id="' + inv_del_id + '" item_name="' + item_name + '" item_id="' + item_id + '" inv_id="' + inv_id + '"  price="' + json_array[i]['price'] + '"  amc_id="' + json_array[i]['amc_id'] + '">';
                disp += '</td>';
                disp += '<td>' + json_array[i]['amc_name'] + '</td>';
                disp += '<td>' + json_array[i]['price'] + '</td>';
                disp += '</tr>';
            }
        } else {

            disp += '<thead>';
            disp += '<th>No AMC available</th>';
            disp += '</thead>';
        }
        $('.amctable').html(disp);

    });

}
